########################################################################
# Logging Variables
########################################################################
if(CMAKE_BUILD_TYPE STREQUAL "Debug")
    set(UHD_LOG_MIN_LEVEL "debug" CACHE STRING "Set UHD log level to {trace, debug, info, warning, error, fatal}")
    set(UHD_LOG_CONSOLE_DISABLE "OFF" CACHE BOOL "Disable UHD logging to stderr")
    set(UHD_LOG_FILE_LEVEL "trace" CACHE STRING "SET UHD file logging level to {trace, debug, info, warning, error, fatal}")
    set(UHD_LOG_CONSOLE_LEVEL "debug" CACHE STRING "SET UHD file logging level to {trace, debug, info, warning, error, fatal}")
else()
    set(UHD_LOG_MIN_LEVEL "debug" CACHE STRING "Set UHD log level to {trace, debug, info, warning, error, fatal}")
    set(UHD_LOG_CONSOLE_DISABLE "OFF" CACHE BOOL "Disable UHD logging to stderr")
    set(UHD_LOG_FILE_LEVEL "info" CACHE STRING "SET UHD file logging level to {trace, debug, info, warning, error, fatal}")
    set(UHD_LOG_CONSOLE_LEVEL "info" CACHE STRING "SET UHD file logging level to {trace, debug, info, warning, error, fatal}")
endif()

function(UHD_LOG_LEVEL_CONVERT ARG1 ARG2)
    string(TOLOWER "${ARG1}" LOG_LEVEL_LOWER)
    if(LOG_LEVEL_LOWER STREQUAL "trace")
        add_definitions(-D${ARG2}=0)
    elseif(LOG_LEVEL_LOWER STREQUAL "debug")
        add_definitions(-D${ARG2}=1)
    elseif(LOG_LEVEL_LOWER STREQUAL "info")
        add_definitions(-D${ARG2}=2)
    elseif(LOG_LEVEL_LOWER STREQUAL "warning")
        add_definitions(-D${ARG2}=3)
    elseif(LOG_LEVEL_LOWER STREQUAL "error")
        add_definitions(-D${ARG2}=4)
    elseif(LOG_LEVEL_LOWER STREQUAL "fatal")
        add_definitions(-D${ARG2}=5)
    else()
        add_definitions(-D${ARG2}=${ARG1})
    endif()
endfunction()

UHD_LOG_LEVEL_CONVERT(${UHD_LOG_MIN_LEVEL} "UHD_LOG_MIN_LEVEL")
UHD_LOG_LEVEL_CONVERT(${UHD_LOG_CONSOLE_LEVEL} "UHD_LOG_CONSOLE_LEVEL")
UHD_LOG_LEVEL_CONVERT(${UHD_LOG_FILE_LEVEL} "UHD_LOG_FILE_LEVEL")

if(UHD_LOG_CONSOLE_DISABLE)
    add_definitions(-DUHD_LOG_CONSOLE_DISABLE)
else()
    if(UHD_LOG_CONSOLE_TIME)
        add_definitions(-DUHD_LOG_CONSOLE_TIME)
    endif()
    if(UHD_LOG_CONSOLE_THREAD)
        add_definitions(-DUHD_LOG_CONSOLE_THREAD)
    endif()
    if(UHD_LOG_CONSOLE_SRC)
        add_definitions(-DUHD_LOG_CONSOLE_SRC)
    endif()
endif()

set(UHD_LOG_FASTPATH_DISABLE "OFF" CACHE BOOL "Disable printing of fastpath logging symbols to stderr (DOSU)")
if(UHD_LOG_FASTPATH_DISABLE)
    add_definitions(-DUHD_LOG_FASTPATH_DISABLE)
endif()

if(MSVC OR CYGWIN)
    set(UHD_LOG_CONSOLE_COLOR "OFF" CACHE BOOL "Enable color output on the terminal")
else()
    set(UHD_LOG_CONSOLE_COLOR "ON" CACHE BOOL "Enable color output on the terminal")
endif()

if(UHD_LOG_CONSOLE_COLOR)
    add_definitions(-DUHD_LOG_CONSOLE_COLOR)
endif()

set(UHD_LOG_FILE "" CACHE STRING "Set UHD log file to a file in a existing directory")
if(NOT UHD_LOG_FILE STREQUAL "")
    add_definitions(-DUHD_LOG_FILE=${UHD_LOG_FILE})
endif()

