% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsearch.R
\name{bary2cart}
\alias{bary2cart}
\title{Conversion of Barycentric to Cartesian coordinates}
\usage{
bary2cart(X, Beta)
}
\arguments{
\item{X}{Reference simplex in \eqn{N} dimensions represented by a
\eqn{N+1}-by-\eqn{N} matrix}

\item{Beta}{\eqn{M} points in barycentric coordinates with
respect to the simplex \code{X} represented by a
\eqn{M}-by-\eqn{N+1} matrix}
}
\value{
\eqn{M}-by-\eqn{N} matrix in which each row is the
Cartesian coordinates of corresponding row of \code{Beta}
}
\description{
Given the barycentric coordinates of one or more points with
respect to a simplex, compute the Cartesian coordinates of these
points.
}
\examples{
## Define simplex in 2D (i.e. a triangle)
X <- rbind(c(0, 0),
           c(0, 1),
           c(1, 0))
## Cartesian cooridinates of points
beta <- rbind(c(0, 0.5, 0.5),
              c(0.1, 0.8, 0.1))
## Plot triangle and points
trimesh(rbind(1:3), X)
text(X[,1], X[,2], 1:3) # Label vertices
P <- bary2cart(X, beta)
points(P)
}
\seealso{
\code{\link{cart2bary}}
}
\author{
David Sterratt
}
