% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/header-precedence.R
\name{precedence}
\alias{precedence}
\alias{priority}
\alias{importance}
\title{Add fields for message importance and priority}
\usage{
priority(msg, priority = NULL)

importance(msg, importance = NULL)
}
\arguments{
\item{msg}{A message object.}

\item{priority}{Priority level. One of \code{"non-urgent"}, \code{"normal"}, or \code{"urgent"}.}

\item{importance}{Importance level. One of \code{"low"}, \code{"normal"}, or \code{"high"}.}
}
\value{
A message object.
}
\description{
A hint to influence transmission speed and delivery.

A hint to the message recipient about how important the message is.
}
\details{
Does not influence transmission speed or delivery.
}
\examples{
# How rapidly does the message need to be delivered?
#
envelope() \%>\%
  subject("Deliver this immediately!") \%>\%
  priority("urgent")

envelope(priority = "non-urgent") \%>\%
  subject("No rush with this.")

# How much attention should be paid by recipient?
#
envelope() \%>\%
  subject("Read this immediately!") \%>\%
  importance("high")

envelope(importance = "low") \%>\%
  subject("Not important at all. Just delete.")
}
