% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dpt-helpers.r
\name{find_tips}
\alias{find_tips}
\title{Find tips in a DiffusionMap object}
\usage{
find_tips(dm_or_dpt, root = random_root(dm_or_dpt))
}
\arguments{
\item{dm_or_dpt}{A \code{\link{DiffusionMap}} or \code{\link{DPT}} object}

\item{root}{Root cell index from which to find tips. (default: random)}
}
\value{
An integer vector of length 3
}
\description{
Find tips in a DiffusionMap object
}
\examples{
data(guo)
dm <- DiffusionMap(guo)
is_tip <- l_which(find_tips(dm), len = ncol(guo))
plot(dm, col = factor(is_tip))

}
