/*
 * Copyright (C) 2008 Instituto Nokia de Tecnologia. All rights reserved.
 *
 * This file is part of QZion.
 *
 * QZion is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * QZion is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with QZion.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __QZIONCLIPPEDGROUP_H__
#define __QZIONCLIPPEDGROUP_H__

#include "qziongroup.h"

/*!
    \class QZionClippedGroup
    \brief A group with a clipping area.

    A QZionClippedGroup is a group with clipping area applied to its
    objects.
*/
class QZionClippedGroup : public QZionGroup
{
    Q_OBJECT

public:
    QZionClippedGroup(QZionAbstractCanvas *canvas);
    virtual ~QZionClippedGroup();

    virtual QRect rect() const;

    virtual void setClipper(QZionRectangle *rect);

private:
    virtual void paintInternal(QPainter *p, const QRect &prect,
                               const QRegion &preg, const QPoint &delta,
                               double cumulative_opacity);
};

#endif
