/*
 * Copyright 2013 Canonical Ltd.
 *
 * This file is part of powerd.
 *
 * powerd is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * powerd is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <syslog.h>
#include "log.h"

static int debug = 0;

void powerd_log(int level, const char *fmt, ...)
{
    va_list args;

    if (level == POWERD_LOG_DEBUG && !debug)
        return;

    va_start(args, fmt);
    vsyslog(level, fmt, args);
    va_end(args);
}

void powerd_log_init(void)
{
    char *debug_str;

    openlog("powerd", LOG_PID, LOG_DAEMON);

    debug_str = getenv("POWERD_DEBUG");
    if (debug_str) {
        if (!strcmp(debug_str, "1")) {
            debug = 1;
            powerd_debug("debug enabled");
        }
    }
}
