; APX CTESTcc testcases

%macro testcase 2
 %ifdef BIN
  db %1
 %endif
 %ifdef SRC
  %2
 %endif
%endmacro

bits 64

; ----- ctestcc instructions -----
; --- ctestb instruction ---
testcase	{0x62, 0xF4, 0x04, 0x02, 0x84, 0x0A},	{ctestb{dfv=} [rdx], cl}
testcase	{0x62, 0xF4, 0x05, 0x02, 0x85, 0x0A},	{ctestb{dfv=} [rdx], cx}
testcase	{0x62, 0xF4, 0x04, 0x02, 0x85, 0x0A},	{ctestb{dfv=} [rdx], ecx}
testcase	{0x62, 0xF4, 0x84, 0x02, 0x85, 0x0A},	{ctestb{dfv=} [rdx], rcx}
testcase	{0x62, 0xDC, 0x04, 0x02, 0x84, 0x0A},	{ctestb{dfv=} [r26], cl}
testcase	{0x62, 0xDC, 0x05, 0x02, 0x85, 0x0A},	{ctestb{dfv=} [r26], cx}
testcase	{0x62, 0xDC, 0x04, 0x02, 0x85, 0x0A},	{ctestb{dfv=} [r26], ecx}
testcase	{0x62, 0xDC, 0x84, 0x02, 0x85, 0x0A},	{ctestb{dfv=} [r26], rcx}
testcase	{0x62, 0xF4, 0x04, 0x02, 0xF6, 0x02, 0x05},	{ctestb{dfv=} byte [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x05, 0x02, 0xF7, 0x02, 0x05, 0x00},	{ctestb{dfv=} word [rdx], word 0x05}
testcase	{0x62, 0xF4, 0x04, 0x02, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestb{dfv=} dword [rdx], dword 0x05}
testcase	{0x62, 0xF4, 0x84, 0x02, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestb{dfv=} qword [rdx], dword 0x05}
testcase	{0x62, 0xDC, 0x04, 0x02, 0xF6, 0x02, 0x05},	{ctestb{dfv=} byte [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x05, 0x02, 0xF7, 0x02, 0x05, 0x00},	{ctestb{dfv=} word [r26], word 0x05}
testcase	{0x62, 0xDC, 0x04, 0x02, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestb{dfv=} dword [r26], dword 0x05}
testcase	{0x62, 0xDC, 0x84, 0x02, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestb{dfv=} qword [r26], dword 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x02, 0x84, 0x0A},	{ctestb{dfv=cf,zf,sf,of} [rdx], cl}
testcase	{0x62, 0xF4, 0x7D, 0x02, 0x85, 0x0A},	{ctestb{dfv=cf,zf,sf,of} [rdx], cx}
testcase	{0x62, 0xF4, 0x7C, 0x02, 0x85, 0x0A},	{ctestb{dfv=cf,zf,sf,of} [rdx], ecx}
testcase	{0x62, 0xF4, 0xFC, 0x02, 0x85, 0x0A},	{ctestb{dfv=cf,zf,sf,of} [rdx], rcx}
testcase	{0x62, 0xDC, 0x7C, 0x02, 0x84, 0x0A},	{ctestb{dfv=cf,zf,sf,of} [r26], cl}
testcase	{0x62, 0xDC, 0x7D, 0x02, 0x85, 0x0A},	{ctestb{dfv=cf,zf,sf,of} [r26], cx}
testcase	{0x62, 0xDC, 0x7C, 0x02, 0x85, 0x0A},	{ctestb{dfv=cf,zf,sf,of} [r26], ecx}
testcase	{0x62, 0xDC, 0xFC, 0x02, 0x85, 0x0A},	{ctestb{dfv=cf,zf,sf,of} [r26], rcx}
testcase	{0x62, 0xF4, 0x7C, 0x02, 0xF6, 0x02, 0x05},	{ctestb{dfv=cf,zf,sf,of} byte [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x7D, 0x02, 0xF7, 0x02, 0x05, 0x00},	{ctestb{dfv=cf,zf,sf,of} word [rdx], word 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x02, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestb{dfv=cf,zf,sf,of} dword [rdx], dword 0x05}
testcase	{0x62, 0xF4, 0xFC, 0x02, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestb{dfv=cf,zf,sf,of} qword [rdx], dword 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x02, 0xF6, 0x02, 0x05},	{ctestb{dfv=cf,zf,sf,of} byte [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x7D, 0x02, 0xF7, 0x02, 0x05, 0x00},	{ctestb{dfv=cf,zf,sf,of} word [r26], word 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x02, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestb{dfv=cf,zf,sf,of} dword [r26], dword 0x05}
testcase	{0x62, 0xDC, 0xFC, 0x02, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestb{dfv=cf,zf,sf,of} qword [r26], dword 0x05}

; --- ctestbe instruction ---
testcase	{0x62, 0xF4, 0x04, 0x06, 0x84, 0x0A},	{ctestbe{dfv=} [rdx], cl}
testcase	{0x62, 0xF4, 0x05, 0x06, 0x85, 0x0A},	{ctestbe{dfv=} [rdx], cx}
testcase	{0x62, 0xF4, 0x04, 0x06, 0x85, 0x0A},	{ctestbe{dfv=} [rdx], ecx}
testcase	{0x62, 0xF4, 0x84, 0x06, 0x85, 0x0A},	{ctestbe{dfv=} [rdx], rcx}
testcase	{0x62, 0xDC, 0x04, 0x06, 0x84, 0x0A},	{ctestbe{dfv=} [r26], cl}
testcase	{0x62, 0xDC, 0x05, 0x06, 0x85, 0x0A},	{ctestbe{dfv=} [r26], cx}
testcase	{0x62, 0xDC, 0x04, 0x06, 0x85, 0x0A},	{ctestbe{dfv=} [r26], ecx}
testcase	{0x62, 0xDC, 0x84, 0x06, 0x85, 0x0A},	{ctestbe{dfv=} [r26], rcx}
testcase	{0x62, 0xF4, 0x04, 0x06, 0xF6, 0x02, 0x05},	{ctestbe{dfv=} byte [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x05, 0x06, 0xF7, 0x02, 0x05, 0x00},	{ctestbe{dfv=} word [rdx], word 0x05}
testcase	{0x62, 0xF4, 0x04, 0x06, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestbe{dfv=} dword [rdx], dword 0x05}
testcase	{0x62, 0xF4, 0x84, 0x06, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestbe{dfv=} qword [rdx], dword 0x05}
testcase	{0x62, 0xDC, 0x04, 0x06, 0xF6, 0x02, 0x05},	{ctestbe{dfv=} byte [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x05, 0x06, 0xF7, 0x02, 0x05, 0x00},	{ctestbe{dfv=} word [r26], word 0x05}
testcase	{0x62, 0xDC, 0x04, 0x06, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestbe{dfv=} dword [r26], dword 0x05}
testcase	{0x62, 0xDC, 0x84, 0x06, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestbe{dfv=} qword [r26], dword 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x06, 0x84, 0x0A},	{ctestbe{dfv=cf,zf,sf,of} [rdx], cl}
testcase	{0x62, 0xF4, 0x7D, 0x06, 0x85, 0x0A},	{ctestbe{dfv=cf,zf,sf,of} [rdx], cx}
testcase	{0x62, 0xF4, 0x7C, 0x06, 0x85, 0x0A},	{ctestbe{dfv=cf,zf,sf,of} [rdx], ecx}
testcase	{0x62, 0xF4, 0xFC, 0x06, 0x85, 0x0A},	{ctestbe{dfv=cf,zf,sf,of} [rdx], rcx}
testcase	{0x62, 0xDC, 0x7C, 0x06, 0x84, 0x0A},	{ctestbe{dfv=cf,zf,sf,of} [r26], cl}
testcase	{0x62, 0xDC, 0x7D, 0x06, 0x85, 0x0A},	{ctestbe{dfv=cf,zf,sf,of} [r26], cx}
testcase	{0x62, 0xDC, 0x7C, 0x06, 0x85, 0x0A},	{ctestbe{dfv=cf,zf,sf,of} [r26], ecx}
testcase	{0x62, 0xDC, 0xFC, 0x06, 0x85, 0x0A},	{ctestbe{dfv=cf,zf,sf,of} [r26], rcx}
testcase	{0x62, 0xF4, 0x7C, 0x06, 0xF6, 0x02, 0x05},	{ctestbe{dfv=cf,zf,sf,of} byte [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x7D, 0x06, 0xF7, 0x02, 0x05, 0x00},	{ctestbe{dfv=cf,zf,sf,of} word [rdx], word 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x06, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestbe{dfv=cf,zf,sf,of} dword [rdx], dword 0x05}
testcase	{0x62, 0xF4, 0xFC, 0x06, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestbe{dfv=cf,zf,sf,of} qword [rdx], dword 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x06, 0xF6, 0x02, 0x05},	{ctestbe{dfv=cf,zf,sf,of} byte [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x7D, 0x06, 0xF7, 0x02, 0x05, 0x00},	{ctestbe{dfv=cf,zf,sf,of} word [r26], word 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x06, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestbe{dfv=cf,zf,sf,of} dword [r26], dword 0x05}
testcase	{0x62, 0xDC, 0xFC, 0x06, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestbe{dfv=cf,zf,sf,of} qword [r26], dword 0x05}

; --- ctestf instruction ---
testcase	{0x62, 0xF4, 0x04, 0x0B, 0x84, 0x0A},	{ctestf{dfv=} [rdx], cl}
testcase	{0x62, 0xF4, 0x05, 0x0B, 0x85, 0x0A},	{ctestf{dfv=} [rdx], cx}
testcase	{0x62, 0xF4, 0x04, 0x0B, 0x85, 0x0A},	{ctestf{dfv=} [rdx], ecx}
testcase	{0x62, 0xF4, 0x84, 0x0B, 0x85, 0x0A},	{ctestf{dfv=} [rdx], rcx}
testcase	{0x62, 0xDC, 0x04, 0x0B, 0x84, 0x0A},	{ctestf{dfv=} [r26], cl}
testcase	{0x62, 0xDC, 0x05, 0x0B, 0x85, 0x0A},	{ctestf{dfv=} [r26], cx}
testcase	{0x62, 0xDC, 0x04, 0x0B, 0x85, 0x0A},	{ctestf{dfv=} [r26], ecx}
testcase	{0x62, 0xDC, 0x84, 0x0B, 0x85, 0x0A},	{ctestf{dfv=} [r26], rcx}
testcase	{0x62, 0xF4, 0x04, 0x0B, 0xF6, 0x02, 0x05},	{ctestf{dfv=} byte [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x05, 0x0B, 0xF7, 0x02, 0x05, 0x00},	{ctestf{dfv=} word [rdx], word 0x05}
testcase	{0x62, 0xF4, 0x04, 0x0B, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestf{dfv=} dword [rdx], dword 0x05}
testcase	{0x62, 0xF4, 0x84, 0x0B, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestf{dfv=} qword [rdx], dword 0x05}
testcase	{0x62, 0xDC, 0x04, 0x0B, 0xF6, 0x02, 0x05},	{ctestf{dfv=} byte [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x05, 0x0B, 0xF7, 0x02, 0x05, 0x00},	{ctestf{dfv=} word [r26], word 0x05}
testcase	{0x62, 0xDC, 0x04, 0x0B, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestf{dfv=} dword [r26], dword 0x05}
testcase	{0x62, 0xDC, 0x84, 0x0B, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestf{dfv=} qword [r26], dword 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x0B, 0x84, 0x0A},	{ctestf{dfv=cf,zf,sf,of} [rdx], cl}
testcase	{0x62, 0xF4, 0x7D, 0x0B, 0x85, 0x0A},	{ctestf{dfv=cf,zf,sf,of} [rdx], cx}
testcase	{0x62, 0xF4, 0x7C, 0x0B, 0x85, 0x0A},	{ctestf{dfv=cf,zf,sf,of} [rdx], ecx}
testcase	{0x62, 0xF4, 0xFC, 0x0B, 0x85, 0x0A},	{ctestf{dfv=cf,zf,sf,of} [rdx], rcx}
testcase	{0x62, 0xDC, 0x7C, 0x0B, 0x84, 0x0A},	{ctestf{dfv=cf,zf,sf,of} [r26], cl}
testcase	{0x62, 0xDC, 0x7D, 0x0B, 0x85, 0x0A},	{ctestf{dfv=cf,zf,sf,of} [r26], cx}
testcase	{0x62, 0xDC, 0x7C, 0x0B, 0x85, 0x0A},	{ctestf{dfv=cf,zf,sf,of} [r26], ecx}
testcase	{0x62, 0xDC, 0xFC, 0x0B, 0x85, 0x0A},	{ctestf{dfv=cf,zf,sf,of} [r26], rcx}
testcase	{0x62, 0xF4, 0x7C, 0x0B, 0xF6, 0x02, 0x05},	{ctestf{dfv=cf,zf,sf,of} byte [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x7D, 0x0B, 0xF7, 0x02, 0x05, 0x00},	{ctestf{dfv=cf,zf,sf,of} word [rdx], word 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x0B, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestf{dfv=cf,zf,sf,of} dword [rdx], dword 0x05}
testcase	{0x62, 0xF4, 0xFC, 0x0B, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestf{dfv=cf,zf,sf,of} qword [rdx], dword 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x0B, 0xF6, 0x02, 0x05},	{ctestf{dfv=cf,zf,sf,of} byte [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x7D, 0x0B, 0xF7, 0x02, 0x05, 0x00},	{ctestf{dfv=cf,zf,sf,of} word [r26], word 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x0B, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestf{dfv=cf,zf,sf,of} dword [r26], dword 0x05}
testcase	{0x62, 0xDC, 0xFC, 0x0B, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestf{dfv=cf,zf,sf,of} qword [r26], dword 0x05}

; --- ctestl instruction ---
testcase	{0x62, 0xF4, 0x04, 0x0C, 0x84, 0x0A},	{ctestl{dfv=} [rdx], cl}
testcase	{0x62, 0xF4, 0x05, 0x0C, 0x85, 0x0A},	{ctestl{dfv=} [rdx], cx}
testcase	{0x62, 0xF4, 0x04, 0x0C, 0x85, 0x0A},	{ctestl{dfv=} [rdx], ecx}
testcase	{0x62, 0xF4, 0x84, 0x0C, 0x85, 0x0A},	{ctestl{dfv=} [rdx], rcx}
testcase	{0x62, 0xDC, 0x04, 0x0C, 0x84, 0x0A},	{ctestl{dfv=} [r26], cl}
testcase	{0x62, 0xDC, 0x05, 0x0C, 0x85, 0x0A},	{ctestl{dfv=} [r26], cx}
testcase	{0x62, 0xDC, 0x04, 0x0C, 0x85, 0x0A},	{ctestl{dfv=} [r26], ecx}
testcase	{0x62, 0xDC, 0x84, 0x0C, 0x85, 0x0A},	{ctestl{dfv=} [r26], rcx}
testcase	{0x62, 0xF4, 0x04, 0x0C, 0xF6, 0x02, 0x05},	{ctestl{dfv=} byte [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x05, 0x0C, 0xF7, 0x02, 0x05, 0x00},	{ctestl{dfv=} word [rdx], word 0x05}
testcase	{0x62, 0xF4, 0x04, 0x0C, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestl{dfv=} dword [rdx], dword 0x05}
testcase	{0x62, 0xF4, 0x84, 0x0C, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestl{dfv=} qword [rdx], dword 0x05}
testcase	{0x62, 0xDC, 0x04, 0x0C, 0xF6, 0x02, 0x05},	{ctestl{dfv=} byte [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x05, 0x0C, 0xF7, 0x02, 0x05, 0x00},	{ctestl{dfv=} word [r26], word 0x05}
testcase	{0x62, 0xDC, 0x04, 0x0C, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestl{dfv=} dword [r26], dword 0x05}
testcase	{0x62, 0xDC, 0x84, 0x0C, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestl{dfv=} qword [r26], dword 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x84, 0x0A},	{ctestl{dfv=cf,zf,sf,of} [rdx], cl}
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0x85, 0x0A},	{ctestl{dfv=cf,zf,sf,of} [rdx], cx}
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x85, 0x0A},	{ctestl{dfv=cf,zf,sf,of} [rdx], ecx}
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0x85, 0x0A},	{ctestl{dfv=cf,zf,sf,of} [rdx], rcx}
testcase	{0x62, 0xDC, 0x7C, 0x0C, 0x84, 0x0A},	{ctestl{dfv=cf,zf,sf,of} [r26], cl}
testcase	{0x62, 0xDC, 0x7D, 0x0C, 0x85, 0x0A},	{ctestl{dfv=cf,zf,sf,of} [r26], cx}
testcase	{0x62, 0xDC, 0x7C, 0x0C, 0x85, 0x0A},	{ctestl{dfv=cf,zf,sf,of} [r26], ecx}
testcase	{0x62, 0xDC, 0xFC, 0x0C, 0x85, 0x0A},	{ctestl{dfv=cf,zf,sf,of} [r26], rcx}
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0xF6, 0x02, 0x05},	{ctestl{dfv=cf,zf,sf,of} byte [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0xF7, 0x02, 0x05, 0x00},	{ctestl{dfv=cf,zf,sf,of} word [rdx], word 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestl{dfv=cf,zf,sf,of} dword [rdx], dword 0x05}
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestl{dfv=cf,zf,sf,of} qword [rdx], dword 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x0C, 0xF6, 0x02, 0x05},	{ctestl{dfv=cf,zf,sf,of} byte [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x7D, 0x0C, 0xF7, 0x02, 0x05, 0x00},	{ctestl{dfv=cf,zf,sf,of} word [r26], word 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x0C, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestl{dfv=cf,zf,sf,of} dword [r26], dword 0x05}
testcase	{0x62, 0xDC, 0xFC, 0x0C, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestl{dfv=cf,zf,sf,of} qword [r26], dword 0x05}

; --- ctestle instruction ---
testcase	{0x62, 0xF4, 0x04, 0x0E, 0x84, 0x0A},	{ctestle{dfv=} [rdx], cl}
testcase	{0x62, 0xF4, 0x05, 0x0E, 0x85, 0x0A},	{ctestle{dfv=} [rdx], cx}
testcase	{0x62, 0xF4, 0x04, 0x0E, 0x85, 0x0A},	{ctestle{dfv=} [rdx], ecx}
testcase	{0x62, 0xF4, 0x84, 0x0E, 0x85, 0x0A},	{ctestle{dfv=} [rdx], rcx}
testcase	{0x62, 0xDC, 0x04, 0x0E, 0x84, 0x0A},	{ctestle{dfv=} [r26], cl}
testcase	{0x62, 0xDC, 0x05, 0x0E, 0x85, 0x0A},	{ctestle{dfv=} [r26], cx}
testcase	{0x62, 0xDC, 0x04, 0x0E, 0x85, 0x0A},	{ctestle{dfv=} [r26], ecx}
testcase	{0x62, 0xDC, 0x84, 0x0E, 0x85, 0x0A},	{ctestle{dfv=} [r26], rcx}
testcase	{0x62, 0xF4, 0x04, 0x0E, 0xF6, 0x02, 0x05},	{ctestle{dfv=} byte [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x05, 0x0E, 0xF7, 0x02, 0x05, 0x00},	{ctestle{dfv=} word [rdx], word 0x05}
testcase	{0x62, 0xF4, 0x04, 0x0E, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestle{dfv=} dword [rdx], dword 0x05}
testcase	{0x62, 0xF4, 0x84, 0x0E, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestle{dfv=} qword [rdx], dword 0x05}
testcase	{0x62, 0xDC, 0x04, 0x0E, 0xF6, 0x02, 0x05},	{ctestle{dfv=} byte [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x05, 0x0E, 0xF7, 0x02, 0x05, 0x00},	{ctestle{dfv=} word [r26], word 0x05}
testcase	{0x62, 0xDC, 0x04, 0x0E, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestle{dfv=} dword [r26], dword 0x05}
testcase	{0x62, 0xDC, 0x84, 0x0E, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestle{dfv=} qword [r26], dword 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x0E, 0x84, 0x0A},	{ctestle{dfv=cf,zf,sf,of} [rdx], cl}
testcase	{0x62, 0xF4, 0x7D, 0x0E, 0x85, 0x0A},	{ctestle{dfv=cf,zf,sf,of} [rdx], cx}
testcase	{0x62, 0xF4, 0x7C, 0x0E, 0x85, 0x0A},	{ctestle{dfv=cf,zf,sf,of} [rdx], ecx}
testcase	{0x62, 0xF4, 0xFC, 0x0E, 0x85, 0x0A},	{ctestle{dfv=cf,zf,sf,of} [rdx], rcx}
testcase	{0x62, 0xDC, 0x7C, 0x0E, 0x84, 0x0A},	{ctestle{dfv=cf,zf,sf,of} [r26], cl}
testcase	{0x62, 0xDC, 0x7D, 0x0E, 0x85, 0x0A},	{ctestle{dfv=cf,zf,sf,of} [r26], cx}
testcase	{0x62, 0xDC, 0x7C, 0x0E, 0x85, 0x0A},	{ctestle{dfv=cf,zf,sf,of} [r26], ecx}
testcase	{0x62, 0xDC, 0xFC, 0x0E, 0x85, 0x0A},	{ctestle{dfv=cf,zf,sf,of} [r26], rcx}
testcase	{0x62, 0xF4, 0x7C, 0x0E, 0xF6, 0x02, 0x05},	{ctestle{dfv=cf,zf,sf,of} byte [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x7D, 0x0E, 0xF7, 0x02, 0x05, 0x00},	{ctestle{dfv=cf,zf,sf,of} word [rdx], word 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x0E, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestle{dfv=cf,zf,sf,of} dword [rdx], dword 0x05}
testcase	{0x62, 0xF4, 0xFC, 0x0E, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestle{dfv=cf,zf,sf,of} qword [rdx], dword 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x0E, 0xF6, 0x02, 0x05},	{ctestle{dfv=cf,zf,sf,of} byte [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x7D, 0x0E, 0xF7, 0x02, 0x05, 0x00},	{ctestle{dfv=cf,zf,sf,of} word [r26], word 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x0E, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestle{dfv=cf,zf,sf,of} dword [r26], dword 0x05}
testcase	{0x62, 0xDC, 0xFC, 0x0E, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestle{dfv=cf,zf,sf,of} qword [r26], dword 0x05}

; --- ctestnb instruction ---
testcase	{0x62, 0xF4, 0x04, 0x03, 0x84, 0x0A},	{ctestnb{dfv=} [rdx], cl}
testcase	{0x62, 0xF4, 0x05, 0x03, 0x85, 0x0A},	{ctestnb{dfv=} [rdx], cx}
testcase	{0x62, 0xF4, 0x04, 0x03, 0x85, 0x0A},	{ctestnb{dfv=} [rdx], ecx}
testcase	{0x62, 0xF4, 0x84, 0x03, 0x85, 0x0A},	{ctestnb{dfv=} [rdx], rcx}
testcase	{0x62, 0xDC, 0x04, 0x03, 0x84, 0x0A},	{ctestnb{dfv=} [r26], cl}
testcase	{0x62, 0xDC, 0x05, 0x03, 0x85, 0x0A},	{ctestnb{dfv=} [r26], cx}
testcase	{0x62, 0xDC, 0x04, 0x03, 0x85, 0x0A},	{ctestnb{dfv=} [r26], ecx}
testcase	{0x62, 0xDC, 0x84, 0x03, 0x85, 0x0A},	{ctestnb{dfv=} [r26], rcx}
testcase	{0x62, 0xF4, 0x04, 0x03, 0xF6, 0x02, 0x05},	{ctestnb{dfv=} byte [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x05, 0x03, 0xF7, 0x02, 0x05, 0x00},	{ctestnb{dfv=} word [rdx], word 0x05}
testcase	{0x62, 0xF4, 0x04, 0x03, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestnb{dfv=} dword [rdx], dword 0x05}
testcase	{0x62, 0xF4, 0x84, 0x03, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestnb{dfv=} qword [rdx], dword 0x05}
testcase	{0x62, 0xDC, 0x04, 0x03, 0xF6, 0x02, 0x05},	{ctestnb{dfv=} byte [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x05, 0x03, 0xF7, 0x02, 0x05, 0x00},	{ctestnb{dfv=} word [r26], word 0x05}
testcase	{0x62, 0xDC, 0x04, 0x03, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestnb{dfv=} dword [r26], dword 0x05}
testcase	{0x62, 0xDC, 0x84, 0x03, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestnb{dfv=} qword [r26], dword 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x03, 0x84, 0x0A},	{ctestnb{dfv=cf,zf,sf,of} [rdx], cl}
testcase	{0x62, 0xF4, 0x7D, 0x03, 0x85, 0x0A},	{ctestnb{dfv=cf,zf,sf,of} [rdx], cx}
testcase	{0x62, 0xF4, 0x7C, 0x03, 0x85, 0x0A},	{ctestnb{dfv=cf,zf,sf,of} [rdx], ecx}
testcase	{0x62, 0xF4, 0xFC, 0x03, 0x85, 0x0A},	{ctestnb{dfv=cf,zf,sf,of} [rdx], rcx}
testcase	{0x62, 0xDC, 0x7C, 0x03, 0x84, 0x0A},	{ctestnb{dfv=cf,zf,sf,of} [r26], cl}
testcase	{0x62, 0xDC, 0x7D, 0x03, 0x85, 0x0A},	{ctestnb{dfv=cf,zf,sf,of} [r26], cx}
testcase	{0x62, 0xDC, 0x7C, 0x03, 0x85, 0x0A},	{ctestnb{dfv=cf,zf,sf,of} [r26], ecx}
testcase	{0x62, 0xDC, 0xFC, 0x03, 0x85, 0x0A},	{ctestnb{dfv=cf,zf,sf,of} [r26], rcx}
testcase	{0x62, 0xF4, 0x7C, 0x03, 0xF6, 0x02, 0x05},	{ctestnb{dfv=cf,zf,sf,of} byte [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x7D, 0x03, 0xF7, 0x02, 0x05, 0x00},	{ctestnb{dfv=cf,zf,sf,of} word [rdx], word 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x03, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestnb{dfv=cf,zf,sf,of} dword [rdx], dword 0x05}
testcase	{0x62, 0xF4, 0xFC, 0x03, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestnb{dfv=cf,zf,sf,of} qword [rdx], dword 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x03, 0xF6, 0x02, 0x05},	{ctestnb{dfv=cf,zf,sf,of} byte [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x7D, 0x03, 0xF7, 0x02, 0x05, 0x00},	{ctestnb{dfv=cf,zf,sf,of} word [r26], word 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x03, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestnb{dfv=cf,zf,sf,of} dword [r26], dword 0x05}
testcase	{0x62, 0xDC, 0xFC, 0x03, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestnb{dfv=cf,zf,sf,of} qword [r26], dword 0x05}

; --- ctestnbe instruction ---
testcase	{0x62, 0xF4, 0x04, 0x07, 0x84, 0x0A},	{ctestnbe{dfv=} [rdx], cl}
testcase	{0x62, 0xF4, 0x05, 0x07, 0x85, 0x0A},	{ctestnbe{dfv=} [rdx], cx}
testcase	{0x62, 0xF4, 0x04, 0x07, 0x85, 0x0A},	{ctestnbe{dfv=} [rdx], ecx}
testcase	{0x62, 0xF4, 0x84, 0x07, 0x85, 0x0A},	{ctestnbe{dfv=} [rdx], rcx}
testcase	{0x62, 0xDC, 0x04, 0x07, 0x84, 0x0A},	{ctestnbe{dfv=} [r26], cl}
testcase	{0x62, 0xDC, 0x05, 0x07, 0x85, 0x0A},	{ctestnbe{dfv=} [r26], cx}
testcase	{0x62, 0xDC, 0x04, 0x07, 0x85, 0x0A},	{ctestnbe{dfv=} [r26], ecx}
testcase	{0x62, 0xDC, 0x84, 0x07, 0x85, 0x0A},	{ctestnbe{dfv=} [r26], rcx}
testcase	{0x62, 0xF4, 0x04, 0x07, 0xF6, 0x02, 0x05},	{ctestnbe{dfv=} byte [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x05, 0x07, 0xF7, 0x02, 0x05, 0x00},	{ctestnbe{dfv=} word [rdx], word 0x05}
testcase	{0x62, 0xF4, 0x04, 0x07, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestnbe{dfv=} dword [rdx], dword 0x05}
testcase	{0x62, 0xF4, 0x84, 0x07, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestnbe{dfv=} qword [rdx], dword 0x05}
testcase	{0x62, 0xDC, 0x04, 0x07, 0xF6, 0x02, 0x05},	{ctestnbe{dfv=} byte [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x05, 0x07, 0xF7, 0x02, 0x05, 0x00},	{ctestnbe{dfv=} word [r26], word 0x05}
testcase	{0x62, 0xDC, 0x04, 0x07, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestnbe{dfv=} dword [r26], dword 0x05}
testcase	{0x62, 0xDC, 0x84, 0x07, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestnbe{dfv=} qword [r26], dword 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x07, 0x84, 0x0A},	{ctestnbe{dfv=cf,zf,sf,of} [rdx], cl}
testcase	{0x62, 0xF4, 0x7D, 0x07, 0x85, 0x0A},	{ctestnbe{dfv=cf,zf,sf,of} [rdx], cx}
testcase	{0x62, 0xF4, 0x7C, 0x07, 0x85, 0x0A},	{ctestnbe{dfv=cf,zf,sf,of} [rdx], ecx}
testcase	{0x62, 0xF4, 0xFC, 0x07, 0x85, 0x0A},	{ctestnbe{dfv=cf,zf,sf,of} [rdx], rcx}
testcase	{0x62, 0xDC, 0x7C, 0x07, 0x84, 0x0A},	{ctestnbe{dfv=cf,zf,sf,of} [r26], cl}
testcase	{0x62, 0xDC, 0x7D, 0x07, 0x85, 0x0A},	{ctestnbe{dfv=cf,zf,sf,of} [r26], cx}
testcase	{0x62, 0xDC, 0x7C, 0x07, 0x85, 0x0A},	{ctestnbe{dfv=cf,zf,sf,of} [r26], ecx}
testcase	{0x62, 0xDC, 0xFC, 0x07, 0x85, 0x0A},	{ctestnbe{dfv=cf,zf,sf,of} [r26], rcx}
testcase	{0x62, 0xF4, 0x7C, 0x07, 0xF6, 0x02, 0x05},	{ctestnbe{dfv=cf,zf,sf,of} byte [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x7D, 0x07, 0xF7, 0x02, 0x05, 0x00},	{ctestnbe{dfv=cf,zf,sf,of} word [rdx], word 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x07, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestnbe{dfv=cf,zf,sf,of} dword [rdx], dword 0x05}
testcase	{0x62, 0xF4, 0xFC, 0x07, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestnbe{dfv=cf,zf,sf,of} qword [rdx], dword 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x07, 0xF6, 0x02, 0x05},	{ctestnbe{dfv=cf,zf,sf,of} byte [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x7D, 0x07, 0xF7, 0x02, 0x05, 0x00},	{ctestnbe{dfv=cf,zf,sf,of} word [r26], word 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x07, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestnbe{dfv=cf,zf,sf,of} dword [r26], dword 0x05}
testcase	{0x62, 0xDC, 0xFC, 0x07, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestnbe{dfv=cf,zf,sf,of} qword [r26], dword 0x05}

; --- ctestnl instruction ---
testcase	{0x62, 0xF4, 0x04, 0x0D, 0x84, 0x0A},	{ctestnl{dfv=} [rdx], cl}
testcase	{0x62, 0xF4, 0x05, 0x0D, 0x85, 0x0A},	{ctestnl{dfv=} [rdx], cx}
testcase	{0x62, 0xF4, 0x04, 0x0D, 0x85, 0x0A},	{ctestnl{dfv=} [rdx], ecx}
testcase	{0x62, 0xF4, 0x84, 0x0D, 0x85, 0x0A},	{ctestnl{dfv=} [rdx], rcx}
testcase	{0x62, 0xDC, 0x04, 0x0D, 0x84, 0x0A},	{ctestnl{dfv=} [r26], cl}
testcase	{0x62, 0xDC, 0x05, 0x0D, 0x85, 0x0A},	{ctestnl{dfv=} [r26], cx}
testcase	{0x62, 0xDC, 0x04, 0x0D, 0x85, 0x0A},	{ctestnl{dfv=} [r26], ecx}
testcase	{0x62, 0xDC, 0x84, 0x0D, 0x85, 0x0A},	{ctestnl{dfv=} [r26], rcx}
testcase	{0x62, 0xF4, 0x04, 0x0D, 0xF6, 0x02, 0x05},	{ctestnl{dfv=} byte [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x05, 0x0D, 0xF7, 0x02, 0x05, 0x00},	{ctestnl{dfv=} word [rdx], word 0x05}
testcase	{0x62, 0xF4, 0x04, 0x0D, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestnl{dfv=} dword [rdx], dword 0x05}
testcase	{0x62, 0xF4, 0x84, 0x0D, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestnl{dfv=} qword [rdx], dword 0x05}
testcase	{0x62, 0xDC, 0x04, 0x0D, 0xF6, 0x02, 0x05},	{ctestnl{dfv=} byte [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x05, 0x0D, 0xF7, 0x02, 0x05, 0x00},	{ctestnl{dfv=} word [r26], word 0x05}
testcase	{0x62, 0xDC, 0x04, 0x0D, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestnl{dfv=} dword [r26], dword 0x05}
testcase	{0x62, 0xDC, 0x84, 0x0D, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestnl{dfv=} qword [r26], dword 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x0D, 0x84, 0x0A},	{ctestnl{dfv=cf,zf,sf,of} [rdx], cl}
testcase	{0x62, 0xF4, 0x7D, 0x0D, 0x85, 0x0A},	{ctestnl{dfv=cf,zf,sf,of} [rdx], cx}
testcase	{0x62, 0xF4, 0x7C, 0x0D, 0x85, 0x0A},	{ctestnl{dfv=cf,zf,sf,of} [rdx], ecx}
testcase	{0x62, 0xF4, 0xFC, 0x0D, 0x85, 0x0A},	{ctestnl{dfv=cf,zf,sf,of} [rdx], rcx}
testcase	{0x62, 0xDC, 0x7C, 0x0D, 0x84, 0x0A},	{ctestnl{dfv=cf,zf,sf,of} [r26], cl}
testcase	{0x62, 0xDC, 0x7D, 0x0D, 0x85, 0x0A},	{ctestnl{dfv=cf,zf,sf,of} [r26], cx}
testcase	{0x62, 0xDC, 0x7C, 0x0D, 0x85, 0x0A},	{ctestnl{dfv=cf,zf,sf,of} [r26], ecx}
testcase	{0x62, 0xDC, 0xFC, 0x0D, 0x85, 0x0A},	{ctestnl{dfv=cf,zf,sf,of} [r26], rcx}
testcase	{0x62, 0xF4, 0x7C, 0x0D, 0xF6, 0x02, 0x05},	{ctestnl{dfv=cf,zf,sf,of} byte [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x7D, 0x0D, 0xF7, 0x02, 0x05, 0x00},	{ctestnl{dfv=cf,zf,sf,of} word [rdx], word 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x0D, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestnl{dfv=cf,zf,sf,of} dword [rdx], dword 0x05}
testcase	{0x62, 0xF4, 0xFC, 0x0D, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestnl{dfv=cf,zf,sf,of} qword [rdx], dword 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x0D, 0xF6, 0x02, 0x05},	{ctestnl{dfv=cf,zf,sf,of} byte [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x7D, 0x0D, 0xF7, 0x02, 0x05, 0x00},	{ctestnl{dfv=cf,zf,sf,of} word [r26], word 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x0D, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestnl{dfv=cf,zf,sf,of} dword [r26], dword 0x05}
testcase	{0x62, 0xDC, 0xFC, 0x0D, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestnl{dfv=cf,zf,sf,of} qword [r26], dword 0x05}

; --- ctestnle instruction ---
testcase	{0x62, 0xF4, 0x04, 0x0F, 0x84, 0x0A},	{ctestnle{dfv=} [rdx], cl}
testcase	{0x62, 0xF4, 0x05, 0x0F, 0x85, 0x0A},	{ctestnle{dfv=} [rdx], cx}
testcase	{0x62, 0xF4, 0x04, 0x0F, 0x85, 0x0A},	{ctestnle{dfv=} [rdx], ecx}
testcase	{0x62, 0xF4, 0x84, 0x0F, 0x85, 0x0A},	{ctestnle{dfv=} [rdx], rcx}
testcase	{0x62, 0xDC, 0x04, 0x0F, 0x84, 0x0A},	{ctestnle{dfv=} [r26], cl}
testcase	{0x62, 0xDC, 0x05, 0x0F, 0x85, 0x0A},	{ctestnle{dfv=} [r26], cx}
testcase	{0x62, 0xDC, 0x04, 0x0F, 0x85, 0x0A},	{ctestnle{dfv=} [r26], ecx}
testcase	{0x62, 0xDC, 0x84, 0x0F, 0x85, 0x0A},	{ctestnle{dfv=} [r26], rcx}
testcase	{0x62, 0xF4, 0x04, 0x0F, 0xF6, 0x02, 0x05},	{ctestnle{dfv=} byte [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x05, 0x0F, 0xF7, 0x02, 0x05, 0x00},	{ctestnle{dfv=} word [rdx], word 0x05}
testcase	{0x62, 0xF4, 0x04, 0x0F, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestnle{dfv=} dword [rdx], dword 0x05}
testcase	{0x62, 0xF4, 0x84, 0x0F, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestnle{dfv=} qword [rdx], dword 0x05}
testcase	{0x62, 0xDC, 0x04, 0x0F, 0xF6, 0x02, 0x05},	{ctestnle{dfv=} byte [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x05, 0x0F, 0xF7, 0x02, 0x05, 0x00},	{ctestnle{dfv=} word [r26], word 0x05}
testcase	{0x62, 0xDC, 0x04, 0x0F, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestnle{dfv=} dword [r26], dword 0x05}
testcase	{0x62, 0xDC, 0x84, 0x0F, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestnle{dfv=} qword [r26], dword 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x0F, 0x84, 0x0A},	{ctestnle{dfv=cf,zf,sf,of} [rdx], cl}
testcase	{0x62, 0xF4, 0x7D, 0x0F, 0x85, 0x0A},	{ctestnle{dfv=cf,zf,sf,of} [rdx], cx}
testcase	{0x62, 0xF4, 0x7C, 0x0F, 0x85, 0x0A},	{ctestnle{dfv=cf,zf,sf,of} [rdx], ecx}
testcase	{0x62, 0xF4, 0xFC, 0x0F, 0x85, 0x0A},	{ctestnle{dfv=cf,zf,sf,of} [rdx], rcx}
testcase	{0x62, 0xDC, 0x7C, 0x0F, 0x84, 0x0A},	{ctestnle{dfv=cf,zf,sf,of} [r26], cl}
testcase	{0x62, 0xDC, 0x7D, 0x0F, 0x85, 0x0A},	{ctestnle{dfv=cf,zf,sf,of} [r26], cx}
testcase	{0x62, 0xDC, 0x7C, 0x0F, 0x85, 0x0A},	{ctestnle{dfv=cf,zf,sf,of} [r26], ecx}
testcase	{0x62, 0xDC, 0xFC, 0x0F, 0x85, 0x0A},	{ctestnle{dfv=cf,zf,sf,of} [r26], rcx}
testcase	{0x62, 0xF4, 0x7C, 0x0F, 0xF6, 0x02, 0x05},	{ctestnle{dfv=cf,zf,sf,of} byte [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x7D, 0x0F, 0xF7, 0x02, 0x05, 0x00},	{ctestnle{dfv=cf,zf,sf,of} word [rdx], word 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x0F, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestnle{dfv=cf,zf,sf,of} dword [rdx], dword 0x05}
testcase	{0x62, 0xF4, 0xFC, 0x0F, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestnle{dfv=cf,zf,sf,of} qword [rdx], dword 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x0F, 0xF6, 0x02, 0x05},	{ctestnle{dfv=cf,zf,sf,of} byte [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x7D, 0x0F, 0xF7, 0x02, 0x05, 0x00},	{ctestnle{dfv=cf,zf,sf,of} word [r26], word 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x0F, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestnle{dfv=cf,zf,sf,of} dword [r26], dword 0x05}
testcase	{0x62, 0xDC, 0xFC, 0x0F, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestnle{dfv=cf,zf,sf,of} qword [r26], dword 0x05}

; --- ctestno instruction ---
testcase	{0x62, 0xF4, 0x04, 0x01, 0x84, 0x0A},	{ctestno{dfv=} [rdx], cl}
testcase	{0x62, 0xF4, 0x05, 0x01, 0x85, 0x0A},	{ctestno{dfv=} [rdx], cx}
testcase	{0x62, 0xF4, 0x04, 0x01, 0x85, 0x0A},	{ctestno{dfv=} [rdx], ecx}
testcase	{0x62, 0xF4, 0x84, 0x01, 0x85, 0x0A},	{ctestno{dfv=} [rdx], rcx}
testcase	{0x62, 0xDC, 0x04, 0x01, 0x84, 0x0A},	{ctestno{dfv=} [r26], cl}
testcase	{0x62, 0xDC, 0x05, 0x01, 0x85, 0x0A},	{ctestno{dfv=} [r26], cx}
testcase	{0x62, 0xDC, 0x04, 0x01, 0x85, 0x0A},	{ctestno{dfv=} [r26], ecx}
testcase	{0x62, 0xDC, 0x84, 0x01, 0x85, 0x0A},	{ctestno{dfv=} [r26], rcx}
testcase	{0x62, 0xF4, 0x04, 0x01, 0xF6, 0x02, 0x05},	{ctestno{dfv=} byte [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x05, 0x01, 0xF7, 0x02, 0x05, 0x00},	{ctestno{dfv=} word [rdx], word 0x05}
testcase	{0x62, 0xF4, 0x04, 0x01, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestno{dfv=} dword [rdx], dword 0x05}
testcase	{0x62, 0xF4, 0x84, 0x01, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestno{dfv=} qword [rdx], dword 0x05}
testcase	{0x62, 0xDC, 0x04, 0x01, 0xF6, 0x02, 0x05},	{ctestno{dfv=} byte [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x05, 0x01, 0xF7, 0x02, 0x05, 0x00},	{ctestno{dfv=} word [r26], word 0x05}
testcase	{0x62, 0xDC, 0x04, 0x01, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestno{dfv=} dword [r26], dword 0x05}
testcase	{0x62, 0xDC, 0x84, 0x01, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestno{dfv=} qword [r26], dword 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x01, 0x84, 0x0A},	{ctestno{dfv=cf,zf,sf,of} [rdx], cl}
testcase	{0x62, 0xF4, 0x7D, 0x01, 0x85, 0x0A},	{ctestno{dfv=cf,zf,sf,of} [rdx], cx}
testcase	{0x62, 0xF4, 0x7C, 0x01, 0x85, 0x0A},	{ctestno{dfv=cf,zf,sf,of} [rdx], ecx}
testcase	{0x62, 0xF4, 0xFC, 0x01, 0x85, 0x0A},	{ctestno{dfv=cf,zf,sf,of} [rdx], rcx}
testcase	{0x62, 0xDC, 0x7C, 0x01, 0x84, 0x0A},	{ctestno{dfv=cf,zf,sf,of} [r26], cl}
testcase	{0x62, 0xDC, 0x7D, 0x01, 0x85, 0x0A},	{ctestno{dfv=cf,zf,sf,of} [r26], cx}
testcase	{0x62, 0xDC, 0x7C, 0x01, 0x85, 0x0A},	{ctestno{dfv=cf,zf,sf,of} [r26], ecx}
testcase	{0x62, 0xDC, 0xFC, 0x01, 0x85, 0x0A},	{ctestno{dfv=cf,zf,sf,of} [r26], rcx}
testcase	{0x62, 0xF4, 0x7C, 0x01, 0xF6, 0x02, 0x05},	{ctestno{dfv=cf,zf,sf,of} byte [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x7D, 0x01, 0xF7, 0x02, 0x05, 0x00},	{ctestno{dfv=cf,zf,sf,of} word [rdx], word 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x01, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestno{dfv=cf,zf,sf,of} dword [rdx], dword 0x05}
testcase	{0x62, 0xF4, 0xFC, 0x01, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestno{dfv=cf,zf,sf,of} qword [rdx], dword 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x01, 0xF6, 0x02, 0x05},	{ctestno{dfv=cf,zf,sf,of} byte [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x7D, 0x01, 0xF7, 0x02, 0x05, 0x00},	{ctestno{dfv=cf,zf,sf,of} word [r26], word 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x01, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestno{dfv=cf,zf,sf,of} dword [r26], dword 0x05}
testcase	{0x62, 0xDC, 0xFC, 0x01, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestno{dfv=cf,zf,sf,of} qword [r26], dword 0x05}

; --- ctestns instruction ---
testcase	{0x62, 0xF4, 0x04, 0x09, 0x84, 0x0A},	{ctestns{dfv=} [rdx], cl}
testcase	{0x62, 0xF4, 0x05, 0x09, 0x85, 0x0A},	{ctestns{dfv=} [rdx], cx}
testcase	{0x62, 0xF4, 0x04, 0x09, 0x85, 0x0A},	{ctestns{dfv=} [rdx], ecx}
testcase	{0x62, 0xF4, 0x84, 0x09, 0x85, 0x0A},	{ctestns{dfv=} [rdx], rcx}
testcase	{0x62, 0xDC, 0x04, 0x09, 0x84, 0x0A},	{ctestns{dfv=} [r26], cl}
testcase	{0x62, 0xDC, 0x05, 0x09, 0x85, 0x0A},	{ctestns{dfv=} [r26], cx}
testcase	{0x62, 0xDC, 0x04, 0x09, 0x85, 0x0A},	{ctestns{dfv=} [r26], ecx}
testcase	{0x62, 0xDC, 0x84, 0x09, 0x85, 0x0A},	{ctestns{dfv=} [r26], rcx}
testcase	{0x62, 0xF4, 0x04, 0x09, 0xF6, 0x02, 0x05},	{ctestns{dfv=} byte [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x05, 0x09, 0xF7, 0x02, 0x05, 0x00},	{ctestns{dfv=} word [rdx], word 0x05}
testcase	{0x62, 0xF4, 0x04, 0x09, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestns{dfv=} dword [rdx], dword 0x05}
testcase	{0x62, 0xF4, 0x84, 0x09, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestns{dfv=} qword [rdx], dword 0x05}
testcase	{0x62, 0xDC, 0x04, 0x09, 0xF6, 0x02, 0x05},	{ctestns{dfv=} byte [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x05, 0x09, 0xF7, 0x02, 0x05, 0x00},	{ctestns{dfv=} word [r26], word 0x05}
testcase	{0x62, 0xDC, 0x04, 0x09, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestns{dfv=} dword [r26], dword 0x05}
testcase	{0x62, 0xDC, 0x84, 0x09, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestns{dfv=} qword [r26], dword 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x09, 0x84, 0x0A},	{ctestns{dfv=cf,zf,sf,of} [rdx], cl}
testcase	{0x62, 0xF4, 0x7D, 0x09, 0x85, 0x0A},	{ctestns{dfv=cf,zf,sf,of} [rdx], cx}
testcase	{0x62, 0xF4, 0x7C, 0x09, 0x85, 0x0A},	{ctestns{dfv=cf,zf,sf,of} [rdx], ecx}
testcase	{0x62, 0xF4, 0xFC, 0x09, 0x85, 0x0A},	{ctestns{dfv=cf,zf,sf,of} [rdx], rcx}
testcase	{0x62, 0xDC, 0x7C, 0x09, 0x84, 0x0A},	{ctestns{dfv=cf,zf,sf,of} [r26], cl}
testcase	{0x62, 0xDC, 0x7D, 0x09, 0x85, 0x0A},	{ctestns{dfv=cf,zf,sf,of} [r26], cx}
testcase	{0x62, 0xDC, 0x7C, 0x09, 0x85, 0x0A},	{ctestns{dfv=cf,zf,sf,of} [r26], ecx}
testcase	{0x62, 0xDC, 0xFC, 0x09, 0x85, 0x0A},	{ctestns{dfv=cf,zf,sf,of} [r26], rcx}
testcase	{0x62, 0xF4, 0x7C, 0x09, 0xF6, 0x02, 0x05},	{ctestns{dfv=cf,zf,sf,of} byte [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x7D, 0x09, 0xF7, 0x02, 0x05, 0x00},	{ctestns{dfv=cf,zf,sf,of} word [rdx], word 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x09, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestns{dfv=cf,zf,sf,of} dword [rdx], dword 0x05}
testcase	{0x62, 0xF4, 0xFC, 0x09, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestns{dfv=cf,zf,sf,of} qword [rdx], dword 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x09, 0xF6, 0x02, 0x05},	{ctestns{dfv=cf,zf,sf,of} byte [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x7D, 0x09, 0xF7, 0x02, 0x05, 0x00},	{ctestns{dfv=cf,zf,sf,of} word [r26], word 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x09, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestns{dfv=cf,zf,sf,of} dword [r26], dword 0x05}
testcase	{0x62, 0xDC, 0xFC, 0x09, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestns{dfv=cf,zf,sf,of} qword [r26], dword 0x05}

; --- ctestnz instruction ---
testcase	{0x62, 0xF4, 0x04, 0x05, 0x84, 0x0A},	{ctestnz{dfv=} [rdx], cl}
testcase	{0x62, 0xF4, 0x05, 0x05, 0x85, 0x0A},	{ctestnz{dfv=} [rdx], cx}
testcase	{0x62, 0xF4, 0x04, 0x05, 0x85, 0x0A},	{ctestnz{dfv=} [rdx], ecx}
testcase	{0x62, 0xF4, 0x84, 0x05, 0x85, 0x0A},	{ctestnz{dfv=} [rdx], rcx}
testcase	{0x62, 0xDC, 0x04, 0x05, 0x84, 0x0A},	{ctestnz{dfv=} [r26], cl}
testcase	{0x62, 0xDC, 0x05, 0x05, 0x85, 0x0A},	{ctestnz{dfv=} [r26], cx}
testcase	{0x62, 0xDC, 0x04, 0x05, 0x85, 0x0A},	{ctestnz{dfv=} [r26], ecx}
testcase	{0x62, 0xDC, 0x84, 0x05, 0x85, 0x0A},	{ctestnz{dfv=} [r26], rcx}
testcase	{0x62, 0xF4, 0x04, 0x05, 0xF6, 0x02, 0x05},	{ctestnz{dfv=} byte [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x05, 0x05, 0xF7, 0x02, 0x05, 0x00},	{ctestnz{dfv=} word [rdx], word 0x05}
testcase	{0x62, 0xF4, 0x04, 0x05, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestnz{dfv=} dword [rdx], dword 0x05}
testcase	{0x62, 0xF4, 0x84, 0x05, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestnz{dfv=} qword [rdx], dword 0x05}
testcase	{0x62, 0xDC, 0x04, 0x05, 0xF6, 0x02, 0x05},	{ctestnz{dfv=} byte [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x05, 0x05, 0xF7, 0x02, 0x05, 0x00},	{ctestnz{dfv=} word [r26], word 0x05}
testcase	{0x62, 0xDC, 0x04, 0x05, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestnz{dfv=} dword [r26], dword 0x05}
testcase	{0x62, 0xDC, 0x84, 0x05, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestnz{dfv=} qword [r26], dword 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x05, 0x84, 0x0A},	{ctestnz{dfv=cf,zf,sf,of} [rdx], cl}
testcase	{0x62, 0xF4, 0x7D, 0x05, 0x85, 0x0A},	{ctestnz{dfv=cf,zf,sf,of} [rdx], cx}
testcase	{0x62, 0xF4, 0x7C, 0x05, 0x85, 0x0A},	{ctestnz{dfv=cf,zf,sf,of} [rdx], ecx}
testcase	{0x62, 0xF4, 0xFC, 0x05, 0x85, 0x0A},	{ctestnz{dfv=cf,zf,sf,of} [rdx], rcx}
testcase	{0x62, 0xDC, 0x7C, 0x05, 0x84, 0x0A},	{ctestnz{dfv=cf,zf,sf,of} [r26], cl}
testcase	{0x62, 0xDC, 0x7D, 0x05, 0x85, 0x0A},	{ctestnz{dfv=cf,zf,sf,of} [r26], cx}
testcase	{0x62, 0xDC, 0x7C, 0x05, 0x85, 0x0A},	{ctestnz{dfv=cf,zf,sf,of} [r26], ecx}
testcase	{0x62, 0xDC, 0xFC, 0x05, 0x85, 0x0A},	{ctestnz{dfv=cf,zf,sf,of} [r26], rcx}
testcase	{0x62, 0xF4, 0x7C, 0x05, 0xF6, 0x02, 0x05},	{ctestnz{dfv=cf,zf,sf,of} byte [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x7D, 0x05, 0xF7, 0x02, 0x05, 0x00},	{ctestnz{dfv=cf,zf,sf,of} word [rdx], word 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x05, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestnz{dfv=cf,zf,sf,of} dword [rdx], dword 0x05}
testcase	{0x62, 0xF4, 0xFC, 0x05, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestnz{dfv=cf,zf,sf,of} qword [rdx], dword 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x05, 0xF6, 0x02, 0x05},	{ctestnz{dfv=cf,zf,sf,of} byte [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x7D, 0x05, 0xF7, 0x02, 0x05, 0x00},	{ctestnz{dfv=cf,zf,sf,of} word [r26], word 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x05, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestnz{dfv=cf,zf,sf,of} dword [r26], dword 0x05}
testcase	{0x62, 0xDC, 0xFC, 0x05, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestnz{dfv=cf,zf,sf,of} qword [r26], dword 0x05}

; --- ctesto instruction ---
testcase	{0x62, 0xF4, 0x04, 0x00, 0x84, 0x0A},	{ctesto{dfv=} [rdx], cl}
testcase	{0x62, 0xF4, 0x05, 0x00, 0x85, 0x0A},	{ctesto{dfv=} [rdx], cx}
testcase	{0x62, 0xF4, 0x04, 0x00, 0x85, 0x0A},	{ctesto{dfv=} [rdx], ecx}
testcase	{0x62, 0xF4, 0x84, 0x00, 0x85, 0x0A},	{ctesto{dfv=} [rdx], rcx}
testcase	{0x62, 0xDC, 0x04, 0x00, 0x84, 0x0A},	{ctesto{dfv=} [r26], cl}
testcase	{0x62, 0xDC, 0x05, 0x00, 0x85, 0x0A},	{ctesto{dfv=} [r26], cx}
testcase	{0x62, 0xDC, 0x04, 0x00, 0x85, 0x0A},	{ctesto{dfv=} [r26], ecx}
testcase	{0x62, 0xDC, 0x84, 0x00, 0x85, 0x0A},	{ctesto{dfv=} [r26], rcx}
testcase	{0x62, 0xF4, 0x04, 0x00, 0xF6, 0x02, 0x05},	{ctesto{dfv=} byte [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x05, 0x00, 0xF7, 0x02, 0x05, 0x00},	{ctesto{dfv=} word [rdx], word 0x05}
testcase	{0x62, 0xF4, 0x04, 0x00, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctesto{dfv=} dword [rdx], dword 0x05}
testcase	{0x62, 0xF4, 0x84, 0x00, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctesto{dfv=} qword [rdx], dword 0x05}
testcase	{0x62, 0xDC, 0x04, 0x00, 0xF6, 0x02, 0x05},	{ctesto{dfv=} byte [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x05, 0x00, 0xF7, 0x02, 0x05, 0x00},	{ctesto{dfv=} word [r26], word 0x05}
testcase	{0x62, 0xDC, 0x04, 0x00, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctesto{dfv=} dword [r26], dword 0x05}
testcase	{0x62, 0xDC, 0x84, 0x00, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctesto{dfv=} qword [r26], dword 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x00, 0x84, 0x0A},	{ctesto{dfv=cf,zf,sf,of} [rdx], cl}
testcase	{0x62, 0xF4, 0x7D, 0x00, 0x85, 0x0A},	{ctesto{dfv=cf,zf,sf,of} [rdx], cx}
testcase	{0x62, 0xF4, 0x7C, 0x00, 0x85, 0x0A},	{ctesto{dfv=cf,zf,sf,of} [rdx], ecx}
testcase	{0x62, 0xF4, 0xFC, 0x00, 0x85, 0x0A},	{ctesto{dfv=cf,zf,sf,of} [rdx], rcx}
testcase	{0x62, 0xDC, 0x7C, 0x00, 0x84, 0x0A},	{ctesto{dfv=cf,zf,sf,of} [r26], cl}
testcase	{0x62, 0xDC, 0x7D, 0x00, 0x85, 0x0A},	{ctesto{dfv=cf,zf,sf,of} [r26], cx}
testcase	{0x62, 0xDC, 0x7C, 0x00, 0x85, 0x0A},	{ctesto{dfv=cf,zf,sf,of} [r26], ecx}
testcase	{0x62, 0xDC, 0xFC, 0x00, 0x85, 0x0A},	{ctesto{dfv=cf,zf,sf,of} [r26], rcx}
testcase	{0x62, 0xF4, 0x7C, 0x00, 0xF6, 0x02, 0x05},	{ctesto{dfv=cf,zf,sf,of} byte [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x7D, 0x00, 0xF7, 0x02, 0x05, 0x00},	{ctesto{dfv=cf,zf,sf,of} word [rdx], word 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x00, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctesto{dfv=cf,zf,sf,of} dword [rdx], dword 0x05}
testcase	{0x62, 0xF4, 0xFC, 0x00, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctesto{dfv=cf,zf,sf,of} qword [rdx], dword 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x00, 0xF6, 0x02, 0x05},	{ctesto{dfv=cf,zf,sf,of} byte [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x7D, 0x00, 0xF7, 0x02, 0x05, 0x00},	{ctesto{dfv=cf,zf,sf,of} word [r26], word 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x00, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctesto{dfv=cf,zf,sf,of} dword [r26], dword 0x05}
testcase	{0x62, 0xDC, 0xFC, 0x00, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctesto{dfv=cf,zf,sf,of} qword [r26], dword 0x05}

; --- ctests instruction ---
testcase	{0x62, 0xF4, 0x04, 0x08, 0x84, 0x0A},	{ctests{dfv=} [rdx], cl}
testcase	{0x62, 0xF4, 0x05, 0x08, 0x85, 0x0A},	{ctests{dfv=} [rdx], cx}
testcase	{0x62, 0xF4, 0x04, 0x08, 0x85, 0x0A},	{ctests{dfv=} [rdx], ecx}
testcase	{0x62, 0xF4, 0x84, 0x08, 0x85, 0x0A},	{ctests{dfv=} [rdx], rcx}
testcase	{0x62, 0xDC, 0x04, 0x08, 0x84, 0x0A},	{ctests{dfv=} [r26], cl}
testcase	{0x62, 0xDC, 0x05, 0x08, 0x85, 0x0A},	{ctests{dfv=} [r26], cx}
testcase	{0x62, 0xDC, 0x04, 0x08, 0x85, 0x0A},	{ctests{dfv=} [r26], ecx}
testcase	{0x62, 0xDC, 0x84, 0x08, 0x85, 0x0A},	{ctests{dfv=} [r26], rcx}
testcase	{0x62, 0xF4, 0x04, 0x08, 0xF6, 0x02, 0x05},	{ctests{dfv=} byte [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x05, 0x08, 0xF7, 0x02, 0x05, 0x00},	{ctests{dfv=} word [rdx], word 0x05}
testcase	{0x62, 0xF4, 0x04, 0x08, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctests{dfv=} dword [rdx], dword 0x05}
testcase	{0x62, 0xF4, 0x84, 0x08, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctests{dfv=} qword [rdx], dword 0x05}
testcase	{0x62, 0xDC, 0x04, 0x08, 0xF6, 0x02, 0x05},	{ctests{dfv=} byte [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x05, 0x08, 0xF7, 0x02, 0x05, 0x00},	{ctests{dfv=} word [r26], word 0x05}
testcase	{0x62, 0xDC, 0x04, 0x08, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctests{dfv=} dword [r26], dword 0x05}
testcase	{0x62, 0xDC, 0x84, 0x08, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctests{dfv=} qword [r26], dword 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x84, 0x0A},	{ctests{dfv=cf,zf,sf,of} [rdx], cl}
testcase	{0x62, 0xF4, 0x7D, 0x08, 0x85, 0x0A},	{ctests{dfv=cf,zf,sf,of} [rdx], cx}
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x85, 0x0A},	{ctests{dfv=cf,zf,sf,of} [rdx], ecx}
testcase	{0x62, 0xF4, 0xFC, 0x08, 0x85, 0x0A},	{ctests{dfv=cf,zf,sf,of} [rdx], rcx}
testcase	{0x62, 0xDC, 0x7C, 0x08, 0x84, 0x0A},	{ctests{dfv=cf,zf,sf,of} [r26], cl}
testcase	{0x62, 0xDC, 0x7D, 0x08, 0x85, 0x0A},	{ctests{dfv=cf,zf,sf,of} [r26], cx}
testcase	{0x62, 0xDC, 0x7C, 0x08, 0x85, 0x0A},	{ctests{dfv=cf,zf,sf,of} [r26], ecx}
testcase	{0x62, 0xDC, 0xFC, 0x08, 0x85, 0x0A},	{ctests{dfv=cf,zf,sf,of} [r26], rcx}
testcase	{0x62, 0xF4, 0x7C, 0x08, 0xF6, 0x02, 0x05},	{ctests{dfv=cf,zf,sf,of} byte [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x7D, 0x08, 0xF7, 0x02, 0x05, 0x00},	{ctests{dfv=cf,zf,sf,of} word [rdx], word 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x08, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctests{dfv=cf,zf,sf,of} dword [rdx], dword 0x05}
testcase	{0x62, 0xF4, 0xFC, 0x08, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctests{dfv=cf,zf,sf,of} qword [rdx], dword 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x08, 0xF6, 0x02, 0x05},	{ctests{dfv=cf,zf,sf,of} byte [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x7D, 0x08, 0xF7, 0x02, 0x05, 0x00},	{ctests{dfv=cf,zf,sf,of} word [r26], word 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x08, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctests{dfv=cf,zf,sf,of} dword [r26], dword 0x05}
testcase	{0x62, 0xDC, 0xFC, 0x08, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctests{dfv=cf,zf,sf,of} qword [r26], dword 0x05}

; --- ctestt instruction ---
testcase	{0x62, 0xF4, 0x04, 0x0A, 0x84, 0x0A},	{ctestt{dfv=} [rdx], cl}
testcase	{0x62, 0xF4, 0x05, 0x0A, 0x85, 0x0A},	{ctestt{dfv=} [rdx], cx}
testcase	{0x62, 0xF4, 0x04, 0x0A, 0x85, 0x0A},	{ctestt{dfv=} [rdx], ecx}
testcase	{0x62, 0xF4, 0x84, 0x0A, 0x85, 0x0A},	{ctestt{dfv=} [rdx], rcx}
testcase	{0x62, 0xDC, 0x04, 0x0A, 0x84, 0x0A},	{ctestt{dfv=} [r26], cl}
testcase	{0x62, 0xDC, 0x05, 0x0A, 0x85, 0x0A},	{ctestt{dfv=} [r26], cx}
testcase	{0x62, 0xDC, 0x04, 0x0A, 0x85, 0x0A},	{ctestt{dfv=} [r26], ecx}
testcase	{0x62, 0xDC, 0x84, 0x0A, 0x85, 0x0A},	{ctestt{dfv=} [r26], rcx}
testcase	{0x62, 0xF4, 0x04, 0x0A, 0xF6, 0x02, 0x05},	{ctestt{dfv=} byte [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x05, 0x0A, 0xF7, 0x02, 0x05, 0x00},	{ctestt{dfv=} word [rdx], word 0x05}
testcase	{0x62, 0xF4, 0x04, 0x0A, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestt{dfv=} dword [rdx], dword 0x05}
testcase	{0x62, 0xF4, 0x84, 0x0A, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestt{dfv=} qword [rdx], dword 0x05}
testcase	{0x62, 0xDC, 0x04, 0x0A, 0xF6, 0x02, 0x05},	{ctestt{dfv=} byte [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x05, 0x0A, 0xF7, 0x02, 0x05, 0x00},	{ctestt{dfv=} word [r26], word 0x05}
testcase	{0x62, 0xDC, 0x04, 0x0A, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestt{dfv=} dword [r26], dword 0x05}
testcase	{0x62, 0xDC, 0x84, 0x0A, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestt{dfv=} qword [r26], dword 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x0A, 0x84, 0x0A},	{ctestt{dfv=cf,zf,sf,of} [rdx], cl}
testcase	{0x62, 0xF4, 0x7D, 0x0A, 0x85, 0x0A},	{ctestt{dfv=cf,zf,sf,of} [rdx], cx}
testcase	{0x62, 0xF4, 0x7C, 0x0A, 0x85, 0x0A},	{ctestt{dfv=cf,zf,sf,of} [rdx], ecx}
testcase	{0x62, 0xF4, 0xFC, 0x0A, 0x85, 0x0A},	{ctestt{dfv=cf,zf,sf,of} [rdx], rcx}
testcase	{0x62, 0xDC, 0x7C, 0x0A, 0x84, 0x0A},	{ctestt{dfv=cf,zf,sf,of} [r26], cl}
testcase	{0x62, 0xDC, 0x7D, 0x0A, 0x85, 0x0A},	{ctestt{dfv=cf,zf,sf,of} [r26], cx}
testcase	{0x62, 0xDC, 0x7C, 0x0A, 0x85, 0x0A},	{ctestt{dfv=cf,zf,sf,of} [r26], ecx}
testcase	{0x62, 0xDC, 0xFC, 0x0A, 0x85, 0x0A},	{ctestt{dfv=cf,zf,sf,of} [r26], rcx}
testcase	{0x62, 0xF4, 0x7C, 0x0A, 0xF6, 0x02, 0x05},	{ctestt{dfv=cf,zf,sf,of} byte [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x7D, 0x0A, 0xF7, 0x02, 0x05, 0x00},	{ctestt{dfv=cf,zf,sf,of} word [rdx], word 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x0A, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestt{dfv=cf,zf,sf,of} dword [rdx], dword 0x05}
testcase	{0x62, 0xF4, 0xFC, 0x0A, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestt{dfv=cf,zf,sf,of} qword [rdx], dword 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x0A, 0xF6, 0x02, 0x05},	{ctestt{dfv=cf,zf,sf,of} byte [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x7D, 0x0A, 0xF7, 0x02, 0x05, 0x00},	{ctestt{dfv=cf,zf,sf,of} word [r26], word 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x0A, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestt{dfv=cf,zf,sf,of} dword [r26], dword 0x05}
testcase	{0x62, 0xDC, 0xFC, 0x0A, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestt{dfv=cf,zf,sf,of} qword [r26], dword 0x05}

; --- ctestz instruction ---
testcase	{0x62, 0xF4, 0x04, 0x04, 0x84, 0x0A},	{ctestz{dfv=} [rdx], cl}
testcase	{0x62, 0xF4, 0x05, 0x04, 0x85, 0x0A},	{ctestz{dfv=} [rdx], cx}
testcase	{0x62, 0xF4, 0x04, 0x04, 0x85, 0x0A},	{ctestz{dfv=} [rdx], ecx}
testcase	{0x62, 0xF4, 0x84, 0x04, 0x85, 0x0A},	{ctestz{dfv=} [rdx], rcx}
testcase	{0x62, 0xDC, 0x04, 0x04, 0x84, 0x0A},	{ctestz{dfv=} [r26], cl}
testcase	{0x62, 0xDC, 0x05, 0x04, 0x85, 0x0A},	{ctestz{dfv=} [r26], cx}
testcase	{0x62, 0xDC, 0x04, 0x04, 0x85, 0x0A},	{ctestz{dfv=} [r26], ecx}
testcase	{0x62, 0xDC, 0x84, 0x04, 0x85, 0x0A},	{ctestz{dfv=} [r26], rcx}
testcase	{0x62, 0xF4, 0x04, 0x04, 0xF6, 0x02, 0x05},	{ctestz{dfv=} byte [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x05, 0x04, 0xF7, 0x02, 0x05, 0x00},	{ctestz{dfv=} word [rdx], word 0x05}
testcase	{0x62, 0xF4, 0x04, 0x04, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestz{dfv=} dword [rdx], dword 0x05}
testcase	{0x62, 0xF4, 0x84, 0x04, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestz{dfv=} qword [rdx], dword 0x05}
testcase	{0x62, 0xDC, 0x04, 0x04, 0xF6, 0x02, 0x05},	{ctestz{dfv=} byte [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x05, 0x04, 0xF7, 0x02, 0x05, 0x00},	{ctestz{dfv=} word [r26], word 0x05}
testcase	{0x62, 0xDC, 0x04, 0x04, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestz{dfv=} dword [r26], dword 0x05}
testcase	{0x62, 0xDC, 0x84, 0x04, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestz{dfv=} qword [r26], dword 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x04, 0x84, 0x0A},	{ctestz{dfv=cf,zf,sf,of} [rdx], cl}
testcase	{0x62, 0xF4, 0x7D, 0x04, 0x85, 0x0A},	{ctestz{dfv=cf,zf,sf,of} [rdx], cx}
testcase	{0x62, 0xF4, 0x7C, 0x04, 0x85, 0x0A},	{ctestz{dfv=cf,zf,sf,of} [rdx], ecx}
testcase	{0x62, 0xF4, 0xFC, 0x04, 0x85, 0x0A},	{ctestz{dfv=cf,zf,sf,of} [rdx], rcx}
testcase	{0x62, 0xDC, 0x7C, 0x04, 0x84, 0x0A},	{ctestz{dfv=cf,zf,sf,of} [r26], cl}
testcase	{0x62, 0xDC, 0x7D, 0x04, 0x85, 0x0A},	{ctestz{dfv=cf,zf,sf,of} [r26], cx}
testcase	{0x62, 0xDC, 0x7C, 0x04, 0x85, 0x0A},	{ctestz{dfv=cf,zf,sf,of} [r26], ecx}
testcase	{0x62, 0xDC, 0xFC, 0x04, 0x85, 0x0A},	{ctestz{dfv=cf,zf,sf,of} [r26], rcx}
testcase	{0x62, 0xF4, 0x7C, 0x04, 0xF6, 0x02, 0x05},	{ctestz{dfv=cf,zf,sf,of} byte [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x7D, 0x04, 0xF7, 0x02, 0x05, 0x00},	{ctestz{dfv=cf,zf,sf,of} word [rdx], word 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x04, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestz{dfv=cf,zf,sf,of} dword [rdx], dword 0x05}
testcase	{0x62, 0xF4, 0xFC, 0x04, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestz{dfv=cf,zf,sf,of} qword [rdx], dword 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x04, 0xF6, 0x02, 0x05},	{ctestz{dfv=cf,zf,sf,of} byte [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x7D, 0x04, 0xF7, 0x02, 0x05, 0x00},	{ctestz{dfv=cf,zf,sf,of} word [r26], word 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x04, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestz{dfv=cf,zf,sf,of} dword [r26], dword 0x05}
testcase	{0x62, 0xDC, 0xFC, 0x04, 0xF7, 0x02, 0x05, 0x00, 0x00, 0x00},	{ctestz{dfv=cf,zf,sf,of} qword [r26], dword 0x05}
