{- This module was generated from data in the Kate syntax
   highlighting file vhdl.xml, version 2, by Rocky Scaletta (rocky@purdue.edu), Stefan Endrullis (stefan@endrullis.de), Florent Ouchet (outchy@users.sourceforge.net), Chris Higgs (chiggs.99@gmail.com), Jan Michel (jan@mueschelsoft.de), Luigi Calligaris (luigi.calligaris@stfc.ac.uk) -}

module Text.Highlighting.Kate.Syntax.Vhdl
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec hiding (State)
import Control.Monad.State
import Data.Char (isSpace)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "VHDL"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.vhdl;*.vhd"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine (parseExpression Nothing)

-- | Parse an expression using appropriate local context.
parseExpression :: Maybe (String,String)
                -> KateParser Token
parseExpression mbcontext = do
  (lang,cont) <- maybe currentContext return mbcontext
  result <- parseRules (lang,cont)
  optional $ do eof
                updateState $ \st -> st{ synStPrevChar = '\n' }
                pEndLine
  return result

startingState = SyntaxState {synStContexts = [("VHDL","start")], synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStContinuation = False, synStCaseSensitive = True, synStKeywordCaseSensitive = False, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  contexts <- synStContexts `fmap` getState
  st <- getState
  if length contexts >= 2
    then case context of
      _ | synStContinuation st -> updateState $ \st -> st{ synStContinuation = False }
      ("VHDL","start") -> return ()
      ("VHDL","package") -> return ()
      ("VHDL","packagemain") -> return ()
      ("VHDL","packagefunction") -> return ()
      ("VHDL","packagebody") -> return ()
      ("VHDL","packagebodymain") -> return ()
      ("VHDL","packagebodyfunc1") -> return ()
      ("VHDL","packagebodyfunc2") -> return ()
      ("VHDL","architecture_main") -> return ()
      ("VHDL","arch_start") -> return ()
      ("VHDL","arch_decl") -> return ()
      ("VHDL","archfunc1") -> return ()
      ("VHDL","archfunc2") -> return ()
      ("VHDL","detect_arch_parts") -> return ()
      ("VHDL","generate1") -> return ()
      ("VHDL","generate2") -> return ()
      ("VHDL","process1") -> return ()
      ("VHDL","proc_rules") -> return ()
      ("VHDL","instance") -> return ()
      ("VHDL","instanceMap") -> return ()
      ("VHDL","instanceInnerPar") -> return ()
      ("VHDL","forwhile1") -> return ()
      ("VHDL","forwhile2") -> return ()
      ("VHDL","if_start") -> return ()
      ("VHDL","if") -> return ()
      ("VHDL","case1") -> return ()
      ("VHDL","case2") -> return ()
      ("VHDL","caseWhen") -> return ()
      ("VHDL","caseWhen2") -> return ()
      ("VHDL","entity") -> return ()
      ("VHDL","entity_main") -> return ()
      ("VHDL","configuration") -> return ()
      ("VHDL","conf_start") -> return ()
      ("VHDL","conf_decl") -> return ()
      ("VHDL","conf_for") -> return ()
      ("VHDL","preDetection") -> return ()
      ("VHDL","generalDetection") -> return ()
      ("VHDL","comment") -> (popContext) >> pEndLine
      ("VHDL","string") -> return ()
      ("VHDL","attribute") -> (popContext) >> pEndLine
      ("VHDL","quot in att") -> return ()
      ("VHDL","signal") -> return ()
      _ -> return ()
    else return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

list_keywordsToplevel = Set.fromList $ words $ "file library use"
list_keywords = Set.fromList $ words $ "access after alias all array assert assume assume_guarantee attribute begin block body bus component constant context cover default disconnect downto end exit fairness falling_edge file for force function generate generic group guarded impure inertial is label linkage literal map new next null of on open others parameter port postponed procedure process property protected pure range record register reject release report return rising_edge select sequence severity signal shared strong subtype to transport type unaffected units until variable vmode vprop vunit wait when with note warning error failure in inout out buffer and abs or xor xnor not mod nand nor rem rol ror sla sra sll srl"
list_if = Set.fromList $ words $ "if else elsif then"
list_forOrWhile = Set.fromList $ words $ "loop"
list_directions = Set.fromList $ words $ "in inout out buffer linkage"
list_signals = Set.fromList $ words $ "signal variable constant type attribute"
list_range = Set.fromList $ words $ "to downto others"
list_case = Set.fromList $ words $ "case when"
list_timeunits = Set.fromList $ words $ "fs ps ns us ms sec min hr"
list_types = Set.fromList $ words $ "bit bit_vector character boolean boolean_vector integer integer_vector real real_vector time time_vector delay_length string severity_level positive natural file_open_kind file_open_status signed unsigned unresolved_unsigned unresolved_signed line text side width std_logic std_logic_vector std_ulogic std_ulogic_vector x01 x01z ux01 ux01z qsim_state qsim_state_vector qsim_12state qsim_12state_vector qsim_strength mux_bit mux_vector reg_bit reg_vector wor_bit wor_vector"

regex_'28'5cb'29package'5cb = compileRegex True "(\\b)package\\b"
regex_'28'5cb'29is'5cb = compileRegex True "(\\b)is\\b"
regex_'28'5cb'29end'5cb = compileRegex True "(\\b)end\\b"
regex_'28'5cb'29function'5cb = compileRegex True "(\\b)function\\b"
regex_'28'5cb'29'5cb'28'3f'21'28'3f'3aprocess'7cconstant'7csignal'7cvariable'29'29'28'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'29'5cb'5cb = compileRegex True "(\\b)\\b(?!(?:process|constant|signal|variable))([A-Za-z_][A-Za-z0-9_]*)\\b\\b"
regex_'28'5cb'29end'5cs'2bpackage'5cb = compileRegex True "(\\b)end\\s+package\\b"
regex_'28'5cb'29begin'5cb = compileRegex True "(\\b)begin\\b"
regex_'28'5cb'29'28generate'7cloop'29'5cb = compileRegex True "(\\b)(generate|loop)\\b"
regex_'28'5cb'29'28for'7cif'7cwhile'29'5cb = compileRegex True "(\\b)(for|if|while)\\b"
regex_'28'5cb'29end'5cs'2b'28generate'7cloop'29'28'5cs'2b'5cb'28'3f'21'28'3f'3aprocess'7cconstant'7csignal'7cvariable'29'29'28'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'29'5cb'29'3f = compileRegex True "(\\b)end\\s+(generate|loop)(\\s+\\b(?!(?:process|constant|signal|variable))([A-Za-z_][A-Za-z0-9_]*)\\b)?"
regex_'28'5cb'29process'5cb = compileRegex True "(\\b)process\\b"
regex_'28'5cb'29'5cb'28'3f'21'28'3f'3aprocess'7cconstant'7csignal'7cvariable'29'29'28'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'29'5cb'28'3f'3d'5cs'2a'3a'28'3f'21'3d'29'29 = compileRegex True "(\\b)\\b(?!(?:process|constant|signal|variable))([A-Za-z_][A-Za-z0-9_]*)\\b(?=\\s*:(?!=))"
regex_'28'5cb'29if'5cb = compileRegex True "(\\b)if\\b"
regex_'28'5cb'29case'5cb = compileRegex True "(\\b)case\\b"
regex_'28'5cb'29'28port'7cgeneric'29'5cs'2bmap'5cs'2a'5c'28 = compileRegex True "(\\b)(port|generic)\\s+map\\s*\\("
regex_'28'5cb'29loop'5cb = compileRegex True "(\\b)loop\\b"
regex_'28'5cb'29'28for'7cwhile'29'5cb = compileRegex True "(\\b)(for|while)\\b"
regex_'28'5cb'29end'5cs'2bloop'28'5cs'2b'5cb'28'3f'21'28'3f'3aprocess'7cconstant'7csignal'7cvariable'29'29'28'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'29'5cb'29'3f = compileRegex True "(\\b)end\\s+loop(\\s+\\b(?!(?:process|constant|signal|variable))([A-Za-z_][A-Za-z0-9_]*)\\b)?"
regex_'28'5cb'29then'5cb = compileRegex True "(\\b)then\\b"
regex_'28'5cb'29end'5cs'2bif'28'5cs'2b'5cb'28'3f'21'28'3f'3aprocess'7cconstant'7csignal'7cvariable'29'29'28'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'29'5cb'29'3f'5cs'2a'3b = compileRegex True "(\\b)end\\s+if(\\s+\\b(?!(?:process|constant|signal|variable))([A-Za-z_][A-Za-z0-9_]*)\\b)?\\s*;"
regex_'28'5cb'29end'5cs'2bcase'28'5cb'28'3f'21'28'3f'3aprocess'7cconstant'7csignal'7cvariable'29'29'28'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'29'5cb'29'3f'5cs'2a'3b = compileRegex True "(\\b)end\\s+case(\\b(?!(?:process|constant|signal|variable))([A-Za-z_][A-Za-z0-9_]*)\\b)?\\s*;"
regex_'28'5cb'29when'5cb = compileRegex True "(\\b)when\\b"
regex_'5cs'2awhen'5cb = compileRegex True "\\s*when\\b"
regex_'5cs'2aend'5cs'2bcase'5cb = compileRegex True "\\s*end\\s+case\\b"
regex_'28'5cb'28'3f'21'28'3f'3aprocess'7cconstant'7csignal'7cvariable'29'29'28'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'29'5cb'29 = compileRegex True "(\\b(?!(?:process|constant|signal|variable))([A-Za-z_][A-Za-z0-9_]*)\\b)"
regex_generic = compileRegex True "generic"
regex_port = compileRegex True "port"
regex_end'28'5cs'2b'5cb'28'3f'21'28'3f'3aprocess'7cconstant'7csignal'7cvariable'29'29'28'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'29'5cb'29'3f = compileRegex True "end(\\s+\\b(?!(?:process|constant|signal|variable))([A-Za-z_][A-Za-z0-9_]*)\\b)?"

parseRules ("VHDL","start") =
  (((parseRules ("VHDL","preDetection")))
   <|>
   ((lookAhead (pRegExprDynamic "(\\b)architecture\\s+(\\b(?!(?:process|constant|signal|variable))([A-Za-z_][A-Za-z0-9_]*)\\b)\\b") >> pushContext ("VHDL","architecture_main") >> currentContext >>= parseRules))
   <|>
   ((pString False "entity" >>= withAttribute KeywordTok) >>~ pushContext ("VHDL","entity"))
   <|>
   ((lookAhead (pRegExprDynamic "(\\b)package\\s+(\\b(?!(?:process|constant|signal|variable))([A-Za-z_][A-Za-z0-9_]*)\\b)\\s+is\\b") >> pushContext ("VHDL","package") >> currentContext >>= parseRules))
   <|>
   ((lookAhead (pRegExprDynamic "(\\b)package\\s+body\\s+(\\b(?!(?:process|constant|signal|variable))([A-Za-z_][A-Za-z0-9_]*)\\b)\\s+is\\b") >> pushContext ("VHDL","packagebody") >> currentContext >>= parseRules))
   <|>
   ((lookAhead (pRegExprDynamic "(\\b)configuration\\s+(\\b(?!(?:process|constant|signal|variable))([A-Za-z_][A-Za-z0-9_]*)\\b)\\b") >> pushContext ("VHDL","configuration") >> currentContext >>= parseRules))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_keywordsToplevel >>= withAttribute KeywordTok))
   <|>
   (currentContext >>= \x -> guard (x == ("VHDL","start")) >> pDefault >>= withAttribute NormalTok))

parseRules ("VHDL","package") =
  (((parseRules ("VHDL","preDetection")))
   <|>
   ((pRegExpr regex_'28'5cb'29package'5cb >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'28'5cb'29is'5cb >>= withAttribute KeywordTok) >>~ pushContext ("VHDL","packagemain"))
   <|>
   ((pRegExprDynamic "(\\b)%2\\b" >>= withAttribute KeywordTok))
   <|>
   ((pRegExprDynamic "(\\b)end(\\s+package)?(\\s+%2)?\\s*;" >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((parseRules ("VHDL","generalDetection")))
   <|>
   (currentContext >>= \x -> guard (x == ("VHDL","package")) >> pDefault >>= withAttribute NormalTok))

parseRules ("VHDL","packagemain") =
  (((parseRules ("VHDL","preDetection")))
   <|>
   ((lookAhead (pRegExpr regex_'28'5cb'29end'5cb) >> (popContext) >> currentContext >>= parseRules))
   <|>
   ((pRegExpr regex_'28'5cb'29function'5cb >>= withAttribute KeywordTok) >>~ pushContext ("VHDL","packagefunction"))
   <|>
   ((parseRules ("VHDL","generalDetection")))
   <|>
   (currentContext >>= \x -> guard (x == ("VHDL","packagemain")) >> pDefault >>= withAttribute NormalTok))

parseRules ("VHDL","packagefunction") =
  (((pRegExpr regex_'28'5cb'29'5cb'28'3f'21'28'3f'3aprocess'7cconstant'7csignal'7cvariable'29'29'28'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'29'5cb'5cb >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("VHDL","packagefunction")) >> pDefault >>= withAttribute NormalTok))

parseRules ("VHDL","packagebody") =
  (((parseRules ("VHDL","preDetection")))
   <|>
   ((pRegExpr regex_'28'5cb'29package'5cb >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'28'5cb'29is'5cb >>= withAttribute KeywordTok) >>~ pushContext ("VHDL","packagebodymain"))
   <|>
   ((pRegExprDynamic "(\\b)%2\\b" >>= withAttribute KeywordTok))
   <|>
   ((pRegExprDynamic "(\\b)end(\\s+package)?(\\s+%2)?\\s*;" >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((parseRules ("VHDL","generalDetection")))
   <|>
   (currentContext >>= \x -> guard (x == ("VHDL","packagebody")) >> pDefault >>= withAttribute NormalTok))

parseRules ("VHDL","packagebodymain") =
  (((parseRules ("VHDL","preDetection")))
   <|>
   ((lookAhead (pRegExpr regex_'28'5cb'29end'5cs'2bpackage'5cb) >> (popContext) >> currentContext >>= parseRules))
   <|>
   ((lookAhead (pRegExprDynamic "(\\b)function\\s+(\\b(?!(?:process|constant|signal|variable))([A-Za-z_][A-Za-z0-9_]*)\\b)\\b") >> pushContext ("VHDL","packagebodyfunc1") >> currentContext >>= parseRules))
   <|>
   ((parseRules ("VHDL","generalDetection")))
   <|>
   (currentContext >>= \x -> guard (x == ("VHDL","packagebodymain")) >> pDefault >>= withAttribute NormalTok))

parseRules ("VHDL","packagebodyfunc1") =
  (((parseRules ("VHDL","preDetection")))
   <|>
   ((pRegExpr regex_'28'5cb'29begin'5cb >>= withAttribute KeywordTok) >>~ pushContext ("VHDL","packagebodyfunc2"))
   <|>
   ((pRegExprDynamic "(\\b)end(\\s+function)?(\\s+%2)?\\b" >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((pRegExprDynamic "(\\b)%2\\b" >>= withAttribute KeywordTok))
   <|>
   ((parseRules ("VHDL","generalDetection")))
   <|>
   (currentContext >>= \x -> guard (x == ("VHDL","packagebodyfunc1")) >> pDefault >>= withAttribute NormalTok))

parseRules ("VHDL","packagebodyfunc2") =
  (((parseRules ("VHDL","preDetection")))
   <|>
   ((lookAhead (pRegExprDynamic "(\\b)end(\\s+function)?\\b") >> (popContext) >> currentContext >>= parseRules))
   <|>
   ((pRegExpr regex_'28'5cb'29begin'5cb >>= withAttribute KeywordTok))
   <|>
   ((parseRules ("VHDL","proc_rules")))
   <|>
   (currentContext >>= \x -> guard (x == ("VHDL","packagebodyfunc2")) >> pDefault >>= withAttribute NormalTok))

parseRules ("VHDL","architecture_main") =
  (((parseRules ("VHDL","preDetection")))
   <|>
   ((lookAhead (pRegExprDynamic "(\\b)architecture\\s+(\\b(?!(?:process|constant|signal|variable))([A-Za-z_][A-Za-z0-9_]*)\\b)\\s+of\\s+(\\b(?!(?:process|constant|signal|variable))([A-Za-z_][A-Za-z0-9_]*)\\b)\\s+is") >> pushContext ("VHDL","arch_start") >> currentContext >>= parseRules))
   <|>
   ((pRegExprDynamic "(\\b)end(\\s+architecture)?(\\s+%2)?\\s*;" >>= withAttribute KeywordTok) >>~ (popContext >> popContext))
   <|>
   ((pRegExprDynamic "(\\b)end(\\s+architecture)?(\\s+\\b(?!(?:process|constant|signal|variable))([A-Za-z_][A-Za-z0-9_]*)\\b)\\s*;" >>= withAttribute ErrorTok) >>~ (popContext >> popContext))
   <|>
   ((parseRules ("VHDL","detect_arch_parts")))
   <|>
   (currentContext >>= \x -> guard (x == ("VHDL","architecture_main")) >> pDefault >>= withAttribute NormalTok))

parseRules ("VHDL","arch_start") =
  (((parseRules ("VHDL","preDetection")))
   <|>
   ((pRegExpr regex_'28'5cb'29is'5cb >>= withAttribute KeywordTok) >>~ pushContext ("VHDL","arch_decl"))
   <|>
   ((pRegExprDynamic "(\\b)%2\\b" >>= withAttribute KeywordTok))
   <|>
   ((pRegExprDynamic "(\\b)%4\\b" >>= withAttribute FunctionTok))
   <|>
   ((parseRules ("VHDL","generalDetection")))
   <|>
   (currentContext >>= \x -> guard (x == ("VHDL","arch_start")) >> pDefault >>= withAttribute KeywordTok))

parseRules ("VHDL","arch_decl") =
  (((parseRules ("VHDL","preDetection")))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_signals >>= withAttribute OtherTok) >>~ pushContext ("VHDL","signal"))
   <|>
   ((pString False "function" >>= withAttribute KeywordTok) >>~ pushContext ("VHDL","archfunc1"))
   <|>
   ((pString False "component" >>= withAttribute KeywordTok) >>~ pushContext ("VHDL","entity"))
   <|>
   ((pString False "begin" >>= withAttribute KeywordTok) >>~ (popContext >> popContext))
   <|>
   ((parseRules ("VHDL","generalDetection")))
   <|>
   (currentContext >>= \x -> guard (x == ("VHDL","arch_decl")) >> pDefault >>= withAttribute NormalTok))

parseRules ("VHDL","archfunc1") =
  (((parseRules ("VHDL","preDetection")))
   <|>
   ((pRegExpr regex_'28'5cb'29begin'5cb >>= withAttribute KeywordTok) >>~ pushContext ("VHDL","archfunc2"))
   <|>
   ((pRegExprDynamic "(\\b)end(\\s+function)?(\\s+%2)?\\b" >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((pRegExprDynamic "(\\b)%2\\b" >>= withAttribute KeywordTok))
   <|>
   ((parseRules ("VHDL","generalDetection")))
   <|>
   (currentContext >>= \x -> guard (x == ("VHDL","archfunc1")) >> pDefault >>= withAttribute NormalTok))

parseRules ("VHDL","archfunc2") =
  (((parseRules ("VHDL","preDetection")))
   <|>
   ((lookAhead (pRegExprDynamic "(\\b)end(\\s+function)?\\b") >> (popContext) >> currentContext >>= parseRules))
   <|>
   ((pRegExpr regex_'28'5cb'29begin'5cb >>= withAttribute KeywordTok))
   <|>
   ((parseRules ("VHDL","proc_rules")))
   <|>
   (currentContext >>= \x -> guard (x == ("VHDL","archfunc2")) >> pDefault >>= withAttribute NormalTok))

parseRules ("VHDL","detect_arch_parts") =
  (((lookAhead (pRegExprDynamic "(\\b)(\\b(?!(?:process|constant|signal|variable))([A-Za-z_][A-Za-z0-9_]*)\\b\\s*:\\s*)(if|for).*\\s+generate\\b") >> pushContext ("VHDL","generate1") >> currentContext >>= parseRules))
   <|>
   ((lookAhead (pRegExprDynamic "(\\b)(\\b(?!(?:process|constant|signal|variable))([A-Za-z_][A-Za-z0-9_]*)\\b\\s*:\\s*)?process\\b") >> pushContext ("VHDL","process1") >> currentContext >>= parseRules))
   <|>
   ((lookAhead (pRegExprDynamic "(\\b)(\\b(?!(?:process|constant|signal|variable))([A-Za-z_][A-Za-z0-9_]*)\\b)\\s*:\\s*((entity\\s+)?(\\b(?!(?:process|constant|signal|variable))([A-Za-z_][A-Za-z0-9_]*)\\b)(\\.\\b(?!(?:process|constant|signal|variable))([A-Za-z_][A-Za-z0-9_]*)\\b)?)") >> pushContext ("VHDL","instance") >> currentContext >>= parseRules))
   <|>
   ((parseRules ("VHDL","generalDetection")))
   <|>
   (currentContext >>= \x -> guard (x == ("VHDL","detect_arch_parts")) >> pDefault >>= withAttribute NormalTok))

parseRules ("VHDL","generate1") =
  (((parseRules ("VHDL","preDetection")))
   <|>
   ((pRegExpr regex_'28'5cb'29'28generate'7cloop'29'5cb >>= withAttribute KeywordTok) >>~ pushContext ("VHDL","generate2"))
   <|>
   ((pRegExprDynamic "(\\b)%3\\b" >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'28'5cb'29'28for'7cif'7cwhile'29'5cb >>= withAttribute KeywordTok))
   <|>
   ((parseRules ("VHDL","generalDetection")))
   <|>
   (currentContext >>= \x -> guard (x == ("VHDL","generate1")) >> pDefault >>= withAttribute NormalTok))

parseRules ("VHDL","generate2") =
  (((parseRules ("VHDL","preDetection")))
   <|>
   ((pRegExpr regex_'28'5cb'29begin'5cb >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'28'5cb'29end'5cs'2b'28generate'7cloop'29'28'5cs'2b'5cb'28'3f'21'28'3f'3aprocess'7cconstant'7csignal'7cvariable'29'29'28'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'29'5cb'29'3f >>= withAttribute KeywordTok) >>~ (popContext >> popContext))
   <|>
   ((parseRules ("VHDL","detect_arch_parts")))
   <|>
   (currentContext >>= \x -> guard (x == ("VHDL","generate2")) >> pDefault >>= withAttribute NormalTok))

parseRules ("VHDL","process1") =
  (((parseRules ("VHDL","preDetection")))
   <|>
   ((pRegExprDynamic "(\\b)end\\s+process(\\s+%3)?" >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((pRegExprDynamic "(\\b)end\\s+process(\\s+\\b(?!(?:process|constant|signal|variable))([A-Za-z_][A-Za-z0-9_]*)\\b)?" >>= withAttribute ErrorTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'28'5cb'29process'5cb >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'28'5cb'29begin'5cb >>= withAttribute KeywordTok))
   <|>
   ((parseRules ("VHDL","proc_rules")))
   <|>
   (currentContext >>= \x -> guard (x == ("VHDL","process1")) >> pDefault >>= withAttribute NormalTok))

parseRules ("VHDL","proc_rules") =
  (((pRegExpr regex_'28'5cb'29'5cb'28'3f'21'28'3f'3aprocess'7cconstant'7csignal'7cvariable'29'29'28'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'29'5cb'28'3f'3d'5cs'2a'3a'28'3f'21'3d'29'29 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'28'5cb'29if'5cb >>= withAttribute KeywordTok) >>~ pushContext ("VHDL","if_start"))
   <|>
   ((lookAhead (pRegExpr regex_'28'5cb'29case'5cb) >> pushContext ("VHDL","case1") >> currentContext >>= parseRules))
   <|>
   ((lookAhead (pRegExprDynamic "(\\b)((\\b(?!(?:process|constant|signal|variable))([A-Za-z_][A-Za-z0-9_]*)\\b)\\s*:\\s*)?((for|while)\\s+.+\\s+)loop\\b") >> pushContext ("VHDL","forwhile1") >> currentContext >>= parseRules))
   <|>
   ((parseRules ("VHDL","generalDetection")))
   <|>
   (currentContext >>= \x -> guard (x == ("VHDL","proc_rules")) >> pDefault >>= withAttribute NormalTok))

parseRules ("VHDL","instance") =
  (((parseRules ("VHDL","preDetection")))
   <|>
   ((pRegExprDynamic "(\\b)%4\\b" >>= withAttribute FunctionTok))
   <|>
   ((pRegExprDynamic "(\\b)%3\\b" >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'28'5cb'29'28port'7cgeneric'29'5cs'2bmap'5cs'2a'5c'28 >>= withAttribute KeywordTok) >>~ pushContext ("VHDL","instanceMap"))
   <|>
   ((pDetectChar False ';' >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((parseRules ("VHDL","generalDetection")))
   <|>
   (currentContext >>= \x -> guard (x == ("VHDL","instance")) >> pDefault >>= withAttribute ErrorTok))

parseRules ("VHDL","instanceMap") =
  (((pAnyChar "<;:" >>= withAttribute ErrorTok))
   <|>
   ((pDetectChar False ':' >>= withAttribute ErrorTok))
   <|>
   ((parseRules ("VHDL","preDetection")))
   <|>
   ((pDetectChar False ')' >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((pDetectChar False '(' >>= withAttribute NormalTok) >>~ pushContext ("VHDL","instanceInnerPar"))
   <|>
   ((parseRules ("VHDL","generalDetection")))
   <|>
   (currentContext >>= \x -> guard (x == ("VHDL","instanceMap")) >> pDefault >>= withAttribute NormalTok))

parseRules ("VHDL","instanceInnerPar") =
  (((parseRules ("VHDL","preDetection")))
   <|>
   ((pDetectChar False ')' >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((pDetectChar False '(' >>= withAttribute NormalTok) >>~ pushContext ("VHDL","instanceInnerPar"))
   <|>
   ((pDetectChar False ';' >>= withAttribute ErrorTok))
   <|>
   ((parseRules ("VHDL","generalDetection")))
   <|>
   (currentContext >>= \x -> guard (x == ("VHDL","instanceInnerPar")) >> pDefault >>= withAttribute NormalTok))

parseRules ("VHDL","forwhile1") =
  (((parseRules ("VHDL","preDetection")))
   <|>
   ((pRegExpr regex_'28'5cb'29loop'5cb >>= withAttribute KeywordTok) >>~ pushContext ("VHDL","forwhile2"))
   <|>
   ((pRegExprDynamic "(\\b)%3\\b" >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'28'5cb'29'28for'7cwhile'29'5cb >>= withAttribute KeywordTok))
   <|>
   ((parseRules ("VHDL","generalDetection")))
   <|>
   (currentContext >>= \x -> guard (x == ("VHDL","forwhile1")) >> pDefault >>= withAttribute NormalTok))

parseRules ("VHDL","forwhile2") =
  (((parseRules ("VHDL","preDetection")))
   <|>
   ((pRegExpr regex_'28'5cb'29begin'5cb >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'28'5cb'29end'5cs'2bloop'28'5cs'2b'5cb'28'3f'21'28'3f'3aprocess'7cconstant'7csignal'7cvariable'29'29'28'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'29'5cb'29'3f >>= withAttribute KeywordTok) >>~ (popContext >> popContext))
   <|>
   ((parseRules ("VHDL","proc_rules")))
   <|>
   (currentContext >>= \x -> guard (x == ("VHDL","forwhile2")) >> pDefault >>= withAttribute NormalTok))

parseRules ("VHDL","if_start") =
  (((parseRules ("VHDL","preDetection")))
   <|>
   ((pRegExpr regex_'28'5cb'29then'5cb >>= withAttribute KeywordTok) >>~ pushContext ("VHDL","if"))
   <|>
   ((parseRules ("VHDL","generalDetection")))
   <|>
   (currentContext >>= \x -> guard (x == ("VHDL","if_start")) >> pDefault >>= withAttribute NormalTok))

parseRules ("VHDL","if") =
  (((parseRules ("VHDL","preDetection")))
   <|>
   ((pRegExpr regex_'28'5cb'29end'5cs'2bif'28'5cs'2b'5cb'28'3f'21'28'3f'3aprocess'7cconstant'7csignal'7cvariable'29'29'28'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'29'5cb'29'3f'5cs'2a'3b >>= withAttribute KeywordTok) >>~ (popContext >> popContext))
   <|>
   ((parseRules ("VHDL","proc_rules")))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_if >>= withAttribute KeywordTok))
   <|>
   (currentContext >>= \x -> guard (x == ("VHDL","if")) >> pDefault >>= withAttribute NormalTok))

parseRules ("VHDL","case1") =
  (((parseRules ("VHDL","preDetection")))
   <|>
   ((pRegExpr regex_'28'5cb'29is'5cb >>= withAttribute KeywordTok) >>~ pushContext ("VHDL","case2"))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_case >>= withAttribute KeywordTok))
   <|>
   ((parseRules ("VHDL","generalDetection")))
   <|>
   (currentContext >>= \x -> guard (x == ("VHDL","case1")) >> pDefault >>= withAttribute NormalTok))

parseRules ("VHDL","case2") =
  (((parseRules ("VHDL","preDetection")))
   <|>
   ((pRegExpr regex_'28'5cb'29end'5cs'2bcase'28'5cb'28'3f'21'28'3f'3aprocess'7cconstant'7csignal'7cvariable'29'29'28'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'29'5cb'29'3f'5cs'2a'3b >>= withAttribute KeywordTok) >>~ (popContext >> popContext))
   <|>
   ((lookAhead (pRegExprDynamic "(\\b)when(\\s+\\b(?!(?:process|constant|signal|variable))([A-Za-z_][A-Za-z0-9_]*)\\b)?\\b") >> pushContext ("VHDL","caseWhen") >> currentContext >>= parseRules))
   <|>
   ((parseRules ("VHDL","proc_rules")))
   <|>
   (currentContext >>= \x -> guard (x == ("VHDL","case2")) >> pDefault >>= withAttribute NormalTok))

parseRules ("VHDL","caseWhen") =
  (((pDetect2Chars False '=' '>' >>= withAttribute OtherTok) >>~ pushContext ("VHDL","caseWhen2"))
   <|>
   ((parseRules ("VHDL","preDetection")))
   <|>
   ((pRegExpr regex_'28'5cb'29when'5cb >>= withAttribute KeywordTok))
   <|>
   ((pRegExprDynamic "(\\b)%2\\b" >>= withAttribute KeywordTok))
   <|>
   ((parseRules ("VHDL","proc_rules")))
   <|>
   (currentContext >>= \x -> guard (x == ("VHDL","caseWhen")) >> pDefault >>= withAttribute NormalTok))

parseRules ("VHDL","caseWhen2") =
  (((parseRules ("VHDL","preDetection")))
   <|>
   ((pColumn 0 >> lookAhead (pRegExpr regex_'5cs'2awhen'5cb) >> (popContext >> popContext) >> currentContext >>= parseRules))
   <|>
   ((pColumn 0 >> lookAhead (pRegExpr regex_'5cs'2aend'5cs'2bcase'5cb) >> (popContext >> popContext) >> currentContext >>= parseRules))
   <|>
   ((parseRules ("VHDL","proc_rules")))
   <|>
   (currentContext >>= \x -> guard (x == ("VHDL","caseWhen2")) >> pDefault >>= withAttribute NormalTok))

parseRules ("VHDL","entity") =
  (((parseRules ("VHDL","preDetection")))
   <|>
   ((pRegExpr regex_'28'5cb'28'3f'21'28'3f'3aprocess'7cconstant'7csignal'7cvariable'29'29'28'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'29'5cb'29 >>= withAttribute KeywordTok) >>~ pushContext ("VHDL","entity_main"))
   <|>
   ((parseRules ("VHDL","generalDetection")))
   <|>
   (currentContext >>= \x -> guard (x == ("VHDL","entity")) >> pDefault >>= withAttribute NormalTok))

parseRules ("VHDL","entity_main") =
  (((parseRules ("VHDL","preDetection")))
   <|>
   ((pRegExprDynamic "(\\b)end(\\s+(entity|component))?(\\s+%1)?\\s*;" >>= withAttribute KeywordTok) >>~ (popContext >> popContext))
   <|>
   ((pRegExprDynamic "(\\b)end(\\s+(entity|component))?(\\s+\\b(?!(?:process|constant|signal|variable))([A-Za-z_][A-Za-z0-9_]*)\\b)?\\s*;" >>= withAttribute ErrorTok) >>~ (popContext >> popContext))
   <|>
   ((pRegExpr regex_generic >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_port >>= withAttribute KeywordTok))
   <|>
   ((parseRules ("VHDL","generalDetection")))
   <|>
   (currentContext >>= \x -> guard (x == ("VHDL","entity_main")) >> pDefault >>= withAttribute NormalTok))

parseRules ("VHDL","configuration") =
  (((parseRules ("VHDL","preDetection")))
   <|>
   ((lookAhead (pRegExprDynamic "(\\b)configuration\\s+(\\b(?!(?:process|constant|signal|variable))([A-Za-z_][A-Za-z0-9_]*)\\b)\\s+of\\s+(\\b(?!(?:process|constant|signal|variable))([A-Za-z_][A-Za-z0-9_]*)\\b)\\s+is") >> pushContext ("VHDL","conf_start") >> currentContext >>= parseRules))
   <|>
   ((pRegExprDynamic "(\\b)end(\\s+configuration)?(\\s+%2)?\\s*;" >>= withAttribute KeywordTok) >>~ (popContext >> popContext))
   <|>
   ((pRegExprDynamic "(\\b)end(\\s+configuration)?(\\s+\\b(?!(?:process|constant|signal|variable))([A-Za-z_][A-Za-z0-9_]*)\\b)\\s*;" >>= withAttribute ErrorTok) >>~ (popContext >> popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("VHDL","configuration")) >> pDefault >>= withAttribute NormalTok))

parseRules ("VHDL","conf_start") =
  (((parseRules ("VHDL","preDetection")))
   <|>
   ((pRegExpr regex_'28'5cb'29is'5cb >>= withAttribute KeywordTok) >>~ pushContext ("VHDL","conf_decl"))
   <|>
   ((pRegExprDynamic "(\\b)%2\\b" >>= withAttribute KeywordTok))
   <|>
   ((pRegExprDynamic "(\\b)%4\\b" >>= withAttribute FunctionTok))
   <|>
   ((parseRules ("VHDL","generalDetection")))
   <|>
   (currentContext >>= \x -> guard (x == ("VHDL","conf_start")) >> pDefault >>= withAttribute KeywordTok))

parseRules ("VHDL","conf_decl") =
  (((parseRules ("VHDL","preDetection")))
   <|>
   ((pString False "for" >>= withAttribute KeywordTok) >>~ pushContext ("VHDL","conf_for"))
   <|>
   ((lookAhead (pString False "end") >> (popContext >> popContext) >> currentContext >>= parseRules))
   <|>
   ((parseRules ("VHDL","generalDetection")))
   <|>
   (currentContext >>= \x -> guard (x == ("VHDL","conf_decl")) >> pDefault >>= withAttribute NormalTok))

parseRules ("VHDL","conf_for") =
  (((parseRules ("VHDL","preDetection")))
   <|>
   ((pString False "for" >>= withAttribute KeywordTok) >>~ pushContext ("VHDL","conf_for"))
   <|>
   ((pRegExpr regex_end'28'5cs'2b'5cb'28'3f'21'28'3f'3aprocess'7cconstant'7csignal'7cvariable'29'29'28'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'29'5cb'29'3f >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((parseRules ("VHDL","generalDetection")))
   <|>
   (currentContext >>= \x -> guard (x == ("VHDL","conf_for")) >> pDefault >>= withAttribute NormalTok))

parseRules ("VHDL","preDetection") =
  (((pDetect2Chars False '-' '-' >>= withAttribute CommentTok) >>~ pushContext ("VHDL","comment"))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext ("VHDL","string"))
   <|>
   ((pAnyChar "[&><=:+\\-*\\/|].," >>= withAttribute OtherTok))
   <|>
   ((pDetectChar False '\'' >>= withAttribute BaseNTok) >>~ pushContext ("VHDL","attribute"))
   <|>
   (currentContext >>= \x -> guard (x == ("VHDL","preDetection")) >> pDefault >>= withAttribute NormalTok))

parseRules ("VHDL","generalDetection") =
  (((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_types >>= withAttribute DataTypeTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_timeunits >>= withAttribute DataTypeTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_signals >>= withAttribute OtherTok) >>~ pushContext ("VHDL","signal"))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_range >>= withAttribute OtherTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_keywords >>= withAttribute KeywordTok))
   <|>
   ((pInt >>= withAttribute DecValTok))
   <|>
   ((pHlCChar >>= withAttribute CharTok))
   <|>
   ((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   (currentContext >>= \x -> guard (x == ("VHDL","generalDetection")) >> pDefault >>= withAttribute NormalTok))

parseRules ("VHDL","comment") =
  (currentContext >>= \x -> guard (x == ("VHDL","comment")) >> pDefault >>= withAttribute CommentTok)

parseRules ("VHDL","string") =
  (((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("VHDL","string")) >> pDefault >>= withAttribute StringTok))

parseRules ("VHDL","attribute") =
  (((pDetectChar False '"' >>= withAttribute BaseNTok) >>~ pushContext ("VHDL","quot in att"))
   <|>
   ((pDetectChar False '"' >>= withAttribute BaseNTok) >>~ pushContext ("VHDL","quot in att"))
   <|>
   ((pDetectChar False ' ' >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((pDetectChar False '\'' >>= withAttribute BaseNTok) >>~ (popContext))
   <|>
   ((pAnyChar ")=<>" >>= withAttribute BaseNTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("VHDL","attribute")) >> pDefault >>= withAttribute BaseNTok))

parseRules ("VHDL","quot in att") =
  (((pDetectChar False '"' >>= withAttribute BaseNTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("VHDL","quot in att")) >> pDefault >>= withAttribute BaseNTok))

parseRules ("VHDL","signal") =
  (((parseRules ("VHDL","preDetection")))
   <|>
   ((lookAhead (pDetectChar False ';') >> (popContext) >> currentContext >>= parseRules))
   <|>
   ((parseRules ("VHDL","generalDetection")))
   <|>
   (currentContext >>= \x -> guard (x == ("VHDL","signal")) >> pDefault >>= withAttribute NormalTok))


parseRules x = parseRules ("VHDL","start") <|> fail ("Unknown context" ++ show x)
