#! /usr/bin/python

from xml.dom.minidom import parse, Element
import sys

# Small script to workaround http://bugzilla.gnome.org/show_bug.cgi?id=578484
# Must be ran everytime glade modifies the xml file.

doc = parse(sys.argv[1])
root = doc.childNodes[0]

for ch in root.childNodes:
    if ch.__class__ is Element:
        if ch.hasAttribute('class'):
            if ch.getAttribute('class') == 'GtkAdjustment':
                for prop in ch.childNodes:
                    if prop.__class__ is Element:
                        if prop.getAttribute('name') == 'value':
                            ch.removeChild(prop)
                            ch.appendChild(prop)
                            break

fout = open(sys.argv[1], 'w')
fout.write(doc.toxml().encode('UTF-8'))
fout.close()
