/*
 * Copyright (C) 2008 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.google.common.collect;
public class MapsTest_gwt extends com.google.gwt.junit.client.GWTTestCase {
@Override public String getModuleName() {
  return "com.google.common.collect.testModule";
}
public void testAsConverter_inverse() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testAsConverter_inverse();
}

public void testAsConverter_isAView() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testAsConverter_isAView();
}

public void testAsConverter_noMapping() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testAsConverter_noMapping();
}

public void testAsConverter_nominal() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testAsConverter_nominal();
}

public void testAsConverter_nullConversions() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testAsConverter_nullConversions();
}

public void testAsConverter_serialization() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testAsConverter_serialization();
}

public void testAsConverter_toString() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testAsConverter_toString();
}

public void testAsConverter_withNullMapping() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testAsConverter_withNullMapping();
}

public void testAsMap() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testAsMap();
}

public void testAsMapEmpty() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testAsMapEmpty();
}

public void testAsMapReadsThrough() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testAsMapReadsThrough();
}

public void testAsMapReturnsSortedMapForSortedSetInput() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testAsMapReturnsSortedMapForSortedSetInput();
}

public void testAsMapSorted() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testAsMapSorted();
}

public void testAsMapSortedEmpty() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testAsMapSortedEmpty();
}

public void testAsMapSortedReadsThrough() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testAsMapSortedReadsThrough();
}

public void testAsMapSortedSubViewKeySetsDoNotSupportAdd() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testAsMapSortedSubViewKeySetsDoNotSupportAdd();
}

public void testAsMapSortedWritesThrough() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testAsMapSortedWritesThrough();
}

public void testAsMapWritesThrough() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testAsMapWritesThrough();
}

public void testCapacityForLargeSizes() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testCapacityForLargeSizes();
}

public void testCapacityForNegativeSizeFails() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testCapacityForNegativeSizeFails();
}

public void testConcurrentMap() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testConcurrentMap();
}

public void testEnumMap() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testEnumMap();
}

public void testEnumMapNullClass() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testEnumMapNullClass();
}

public void testEnumMapWithInitialEmptyEnumMap() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testEnumMapWithInitialEmptyEnumMap();
}

public void testEnumMapWithInitialEmptyMap() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testEnumMapWithInitialEmptyMap();
}

public void testEnumMapWithInitialEnumMap() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testEnumMapWithInitialEnumMap();
}

public void testEnumMapWithInitialMap() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testEnumMapWithInitialMap();
}

public void testHashMap() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testHashMap();
}

public void testHashMapGeneralizesTypes() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testHashMapGeneralizesTypes();
}

public void testHashMapWithInitialMap() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testHashMapWithInitialMap();
}

public void testIdentityHashMap() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testIdentityHashMap();
}

public void testImmutableEntry() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testImmutableEntry();
}

public void testImmutableEntryNull() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testImmutableEntryNull();
}

public void testLinkedHashMap() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testLinkedHashMap();
}

public void testLinkedHashMapGeneralizesTypes() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testLinkedHashMapGeneralizesTypes();
}

public void testLinkedHashMapWithInitialMap() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testLinkedHashMapWithInitialMap();
}

public void testMapDifferenceEmptyEmpty() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testMapDifferenceEmptyEmpty();
}

public void testMapDifferenceEmptySingleton() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testMapDifferenceEmptySingleton();
}

public void testMapDifferenceEquals() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testMapDifferenceEquals();
}

public void testMapDifferenceOfSortedMapIsSorted() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testMapDifferenceOfSortedMapIsSorted();
}

public void testMapDifferencePredicateTypical() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testMapDifferencePredicateTypical();
}

public void testMapDifferenceSingletonEmpty() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testMapDifferenceSingletonEmpty();
}

public void testMapDifferenceTypical() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testMapDifferenceTypical();
}

public void testSortedMapDifferenceEmptyEmpty() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testSortedMapDifferenceEmptyEmpty();
}

public void testSortedMapDifferenceEmptySingleton() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testSortedMapDifferenceEmptySingleton();
}

public void testSortedMapDifferenceEquals() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testSortedMapDifferenceEquals();
}

public void testSortedMapDifferenceImmutable() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testSortedMapDifferenceImmutable();
}

public void testSortedMapDifferenceSingletonEmpty() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testSortedMapDifferenceSingletonEmpty();
}

public void testSortedMapDifferenceTypical() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testSortedMapDifferenceTypical();
}

public void testSortedMapTransformEntries() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testSortedMapTransformEntries();
}

public void testSortedMapTransformValues() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testSortedMapTransformValues();
}

public void testSynchronizedBiMap() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testSynchronizedBiMap();
}

public void testToMap() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testToMap();
}

public void testToMapIterator() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testToMapIterator();
}

public void testToMapWithDuplicateKeys() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testToMapWithDuplicateKeys();
}

public void testToMapWithNullKeys() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testToMapWithNullKeys();
}

public void testToMapWithNullValues() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testToMapWithNullValues();
}

public void testToStringImplWithNullKeys() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testToStringImplWithNullKeys();
}

public void testToStringImplWithNullValues() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testToStringImplWithNullValues();
}

public void testTransformEntries() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testTransformEntries();
}

public void testTransformEntriesExample() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testTransformEntriesExample();
}

public void testTransformEntriesGenerics() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testTransformEntriesGenerics();
}

public void testTransformEntriesSecretlySorted() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testTransformEntriesSecretlySorted();
}

public void testTransformValues() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testTransformValues();
}

public void testTransformValuesSecretlySorted() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testTransformValuesSecretlySorted();
}

public void testTreeMap() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testTreeMap();
}

public void testTreeMapDerived() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testTreeMapDerived();
}

public void testTreeMapNonGeneric() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testTreeMapNonGeneric();
}

public void testTreeMapWithComparator() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testTreeMapWithComparator();
}

public void testTreeMapWithInitialMap() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testTreeMapWithInitialMap();
}

public void testUniqueIndexCollection() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testUniqueIndexCollection();
}

public void testUniqueIndexDuplicates() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testUniqueIndexDuplicates();
}

public void testUniqueIndexIterable() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testUniqueIndexIterable();
}

public void testUniqueIndexIterator() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testUniqueIndexIterator();
}

public void testUniqueIndexNullKey() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testUniqueIndexNullKey();
}

public void testUniqueIndexNullValue() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testUniqueIndexNullValue();
}

public void testUnmodifiableBiMap() throws Exception {
  com.google.common.collect.MapsTest testCase = new com.google.common.collect.MapsTest();
  testCase.testUnmodifiableBiMap();
}

public void testFilterEntriesIdentifiesBiMap__FilteredBiMapTest() throws Exception {
  com.google.common.collect.MapsTest.FilteredBiMapTest testCase = new com.google.common.collect.MapsTest.FilteredBiMapTest();
  testCase.testFilterEntriesIdentifiesBiMap();
}

public void testFilterKeysIdentifiesBiMap__FilteredBiMapTest() throws Exception {
  com.google.common.collect.MapsTest.FilteredBiMapTest testCase = new com.google.common.collect.MapsTest.FilteredBiMapTest();
  testCase.testFilterKeysIdentifiesBiMap();
}

public void testFilterValuesIdentifiesBiMap__FilteredBiMapTest() throws Exception {
  com.google.common.collect.MapsTest.FilteredBiMapTest testCase = new com.google.common.collect.MapsTest.FilteredBiMapTest();
  testCase.testFilterValuesIdentifiesBiMap();
}

public void testFilteredEntriesIllegalPut__FilteredBiMapTest() throws Exception {
  com.google.common.collect.MapsTest.FilteredBiMapTest testCase = new com.google.common.collect.MapsTest.FilteredBiMapTest();
  testCase.testFilteredEntriesIllegalPut();
}

public void testFilteredEntriesIllegalPutAll__FilteredBiMapTest() throws Exception {
  com.google.common.collect.MapsTest.FilteredBiMapTest testCase = new com.google.common.collect.MapsTest.FilteredBiMapTest();
  testCase.testFilteredEntriesIllegalPutAll();
}

public void testFilteredEntriesObjectPredicate__FilteredBiMapTest() throws Exception {
  com.google.common.collect.MapsTest.FilteredBiMapTest testCase = new com.google.common.collect.MapsTest.FilteredBiMapTest();
  testCase.testFilteredEntriesObjectPredicate();
}

public void testFilteredEntriesWildCardEntryPredicate__FilteredBiMapTest() throws Exception {
  com.google.common.collect.MapsTest.FilteredBiMapTest testCase = new com.google.common.collect.MapsTest.FilteredBiMapTest();
  testCase.testFilteredEntriesWildCardEntryPredicate();
}

public void testFilteredKeysFilteredReflectsBackingChanges__FilteredBiMapTest() throws Exception {
  com.google.common.collect.MapsTest.FilteredBiMapTest testCase = new com.google.common.collect.MapsTest.FilteredBiMapTest();
  testCase.testFilteredKeysFilteredReflectsBackingChanges();
}

public void testFilteredKeysIllegalPut__FilteredBiMapTest() throws Exception {
  com.google.common.collect.MapsTest.FilteredBiMapTest testCase = new com.google.common.collect.MapsTest.FilteredBiMapTest();
  testCase.testFilteredKeysIllegalPut();
}

public void testFilteredKeysIllegalPutAll__FilteredBiMapTest() throws Exception {
  com.google.common.collect.MapsTest.FilteredBiMapTest testCase = new com.google.common.collect.MapsTest.FilteredBiMapTest();
  testCase.testFilteredKeysIllegalPutAll();
}

public void testFilteredValuesClear__FilteredBiMapTest() throws Exception {
  com.google.common.collect.MapsTest.FilteredBiMapTest testCase = new com.google.common.collect.MapsTest.FilteredBiMapTest();
  testCase.testFilteredValuesClear();
}

public void testFilteredValuesIllegalPut__FilteredBiMapTest() throws Exception {
  com.google.common.collect.MapsTest.FilteredBiMapTest testCase = new com.google.common.collect.MapsTest.FilteredBiMapTest();
  testCase.testFilteredValuesIllegalPut();
}

public void testFilteredValuesIllegalPutAll__FilteredBiMapTest() throws Exception {
  com.google.common.collect.MapsTest.FilteredBiMapTest testCase = new com.google.common.collect.MapsTest.FilteredBiMapTest();
  testCase.testFilteredValuesIllegalPutAll();
}

public void testFilteredValuesIllegalSetValue__FilteredBiMapTest() throws Exception {
  com.google.common.collect.MapsTest.FilteredBiMapTest testCase = new com.google.common.collect.MapsTest.FilteredBiMapTest();
  testCase.testFilteredValuesIllegalSetValue();
}

public void testFilterEntriesIdentifiesSortedMap__FilteredSortedMapTest() throws Exception {
  com.google.common.collect.MapsTest.FilteredSortedMapTest testCase = new com.google.common.collect.MapsTest.FilteredSortedMapTest();
  testCase.testFilterEntriesIdentifiesSortedMap();
}

public void testFilterKeysIdentifiesSortedMap__FilteredSortedMapTest() throws Exception {
  com.google.common.collect.MapsTest.FilteredSortedMapTest testCase = new com.google.common.collect.MapsTest.FilteredSortedMapTest();
  testCase.testFilterKeysIdentifiesSortedMap();
}

public void testFilterValuesIdentifiesSortedMap__FilteredSortedMapTest() throws Exception {
  com.google.common.collect.MapsTest.FilteredSortedMapTest testCase = new com.google.common.collect.MapsTest.FilteredSortedMapTest();
  testCase.testFilterValuesIdentifiesSortedMap();
}

public void testFilteredEntriesIllegalPut__FilteredSortedMapTest() throws Exception {
  com.google.common.collect.MapsTest.FilteredSortedMapTest testCase = new com.google.common.collect.MapsTest.FilteredSortedMapTest();
  testCase.testFilteredEntriesIllegalPut();
}

public void testFilteredEntriesIllegalPutAll__FilteredSortedMapTest() throws Exception {
  com.google.common.collect.MapsTest.FilteredSortedMapTest testCase = new com.google.common.collect.MapsTest.FilteredSortedMapTest();
  testCase.testFilteredEntriesIllegalPutAll();
}

public void testFilteredEntriesObjectPredicate__FilteredSortedMapTest() throws Exception {
  com.google.common.collect.MapsTest.FilteredSortedMapTest testCase = new com.google.common.collect.MapsTest.FilteredSortedMapTest();
  testCase.testFilteredEntriesObjectPredicate();
}

public void testFilteredEntriesWildCardEntryPredicate__FilteredSortedMapTest() throws Exception {
  com.google.common.collect.MapsTest.FilteredSortedMapTest testCase = new com.google.common.collect.MapsTest.FilteredSortedMapTest();
  testCase.testFilteredEntriesWildCardEntryPredicate();
}

public void testFilteredKeysFilteredReflectsBackingChanges__FilteredSortedMapTest() throws Exception {
  com.google.common.collect.MapsTest.FilteredSortedMapTest testCase = new com.google.common.collect.MapsTest.FilteredSortedMapTest();
  testCase.testFilteredKeysFilteredReflectsBackingChanges();
}

public void testFilteredKeysIllegalPut__FilteredSortedMapTest() throws Exception {
  com.google.common.collect.MapsTest.FilteredSortedMapTest testCase = new com.google.common.collect.MapsTest.FilteredSortedMapTest();
  testCase.testFilteredKeysIllegalPut();
}

public void testFilteredKeysIllegalPutAll__FilteredSortedMapTest() throws Exception {
  com.google.common.collect.MapsTest.FilteredSortedMapTest testCase = new com.google.common.collect.MapsTest.FilteredSortedMapTest();
  testCase.testFilteredKeysIllegalPutAll();
}

public void testFilteredValuesClear__FilteredSortedMapTest() throws Exception {
  com.google.common.collect.MapsTest.FilteredSortedMapTest testCase = new com.google.common.collect.MapsTest.FilteredSortedMapTest();
  testCase.testFilteredValuesClear();
}

public void testFilteredValuesIllegalPut__FilteredSortedMapTest() throws Exception {
  com.google.common.collect.MapsTest.FilteredSortedMapTest testCase = new com.google.common.collect.MapsTest.FilteredSortedMapTest();
  testCase.testFilteredValuesIllegalPut();
}

public void testFilteredValuesIllegalPutAll__FilteredSortedMapTest() throws Exception {
  com.google.common.collect.MapsTest.FilteredSortedMapTest testCase = new com.google.common.collect.MapsTest.FilteredSortedMapTest();
  testCase.testFilteredValuesIllegalPutAll();
}

public void testFilteredValuesIllegalSetValue__FilteredSortedMapTest() throws Exception {
  com.google.common.collect.MapsTest.FilteredSortedMapTest testCase = new com.google.common.collect.MapsTest.FilteredSortedMapTest();
  testCase.testFilteredValuesIllegalSetValue();
}

public void testFirstAndLastKeyFilteredMap__FilteredSortedMapTest() throws Exception {
  com.google.common.collect.MapsTest.FilteredSortedMapTest testCase = new com.google.common.collect.MapsTest.FilteredSortedMapTest();
  testCase.testFirstAndLastKeyFilteredMap();
}

public void testHeadSubTailMap_FilteredMap__FilteredSortedMapTest() throws Exception {
  com.google.common.collect.MapsTest.FilteredSortedMapTest testCase = new com.google.common.collect.MapsTest.FilteredSortedMapTest();
  testCase.testHeadSubTailMap_FilteredMap();
}

public void testFilteredEntriesIllegalPut__FilteredMapTest() throws Exception {
  com.google.common.collect.MapsTest.FilteredMapTest testCase = new com.google.common.collect.MapsTest.FilteredMapTest();
  testCase.testFilteredEntriesIllegalPut();
}

public void testFilteredEntriesIllegalPutAll__FilteredMapTest() throws Exception {
  com.google.common.collect.MapsTest.FilteredMapTest testCase = new com.google.common.collect.MapsTest.FilteredMapTest();
  testCase.testFilteredEntriesIllegalPutAll();
}

public void testFilteredEntriesObjectPredicate__FilteredMapTest() throws Exception {
  com.google.common.collect.MapsTest.FilteredMapTest testCase = new com.google.common.collect.MapsTest.FilteredMapTest();
  testCase.testFilteredEntriesObjectPredicate();
}

public void testFilteredEntriesWildCardEntryPredicate__FilteredMapTest() throws Exception {
  com.google.common.collect.MapsTest.FilteredMapTest testCase = new com.google.common.collect.MapsTest.FilteredMapTest();
  testCase.testFilteredEntriesWildCardEntryPredicate();
}

public void testFilteredKeysFilteredReflectsBackingChanges__FilteredMapTest() throws Exception {
  com.google.common.collect.MapsTest.FilteredMapTest testCase = new com.google.common.collect.MapsTest.FilteredMapTest();
  testCase.testFilteredKeysFilteredReflectsBackingChanges();
}

public void testFilteredKeysIllegalPut__FilteredMapTest() throws Exception {
  com.google.common.collect.MapsTest.FilteredMapTest testCase = new com.google.common.collect.MapsTest.FilteredMapTest();
  testCase.testFilteredKeysIllegalPut();
}

public void testFilteredKeysIllegalPutAll__FilteredMapTest() throws Exception {
  com.google.common.collect.MapsTest.FilteredMapTest testCase = new com.google.common.collect.MapsTest.FilteredMapTest();
  testCase.testFilteredKeysIllegalPutAll();
}

public void testFilteredValuesClear__FilteredMapTest() throws Exception {
  com.google.common.collect.MapsTest.FilteredMapTest testCase = new com.google.common.collect.MapsTest.FilteredMapTest();
  testCase.testFilteredValuesClear();
}

public void testFilteredValuesIllegalPut__FilteredMapTest() throws Exception {
  com.google.common.collect.MapsTest.FilteredMapTest testCase = new com.google.common.collect.MapsTest.FilteredMapTest();
  testCase.testFilteredValuesIllegalPut();
}

public void testFilteredValuesIllegalPutAll__FilteredMapTest() throws Exception {
  com.google.common.collect.MapsTest.FilteredMapTest testCase = new com.google.common.collect.MapsTest.FilteredMapTest();
  testCase.testFilteredValuesIllegalPutAll();
}

public void testFilteredValuesIllegalSetValue__FilteredMapTest() throws Exception {
  com.google.common.collect.MapsTest.FilteredMapTest testCase = new com.google.common.collect.MapsTest.FilteredMapTest();
  testCase.testFilteredValuesIllegalSetValue();
}
}
