extern "C" {
#include <grass/gis.h>
#include <grass/glocale.h>
}

#include "common.h"
#include "Iwave.h"

#ifdef WIN32
#pragma warning(disable:4305)	/* disable warning about initialization of a float by a double */
#endif

/* Adding new band filters:
 * see README
 */


/*
  spectral band of meteosat
*/
void IWave::meteo()
{
    static const float sr[305] = {
	.00,    .00,    .00,    .01,    .01,    .01,    .02,
	.02,    .02,    .02,    .02,    .02,    .03,    .03,
	.04,    .04,    .04,    .05,    .05,    .05,    .06,
	.06,    .07,    .07,    .07,    .08,    .08,    .09,
	.09,    .10,    .10,    .10,    .11,    .11,    .12,
	.12,    .12,    .13,    .14,    .14,    .15,    .15,
	.16,    .16,    .17,    .17,    .18,    .18,    .19,
	.20,    .20,    .21,    .21,    .22,    .23,    .24,
	.24,    .25,    .26,    .27,    .28,    .28,    .29,
	.30,    .30,    .31,    .32,    .33,    .34,    .35,
	.35,    .36,    .37,    .38,    .39,    .40,    .40,
	.41,    .42,    .43,    .44,    .45,    .46,    .48,
	.49,    .50,    .51,    .52,    .53,    .55,    .56,
	.57,    .58,    .60,    .61,    .62,    .63,    .64,
	.65,    .65,    .66,    .67,    .67,    .68,    .69,
	.69,    .70,    .71,    .71,    .72,    .73,    .73,
	.74,    .76,    .77,    .78,    .78,    .79,    .80,
	.81,    .82,    .83,    .84,    .85,    .86,    .87,
	.88,    .89,    .89,    .91,    .92,    .93,    .94,
	.95,    .96,    .96,    .97,    .98,    .98,    .99,
	.99,    .99,    .99,   1.00,   1.00,   1.00,   1.00,
	1.00,   1.00,   1.00,   1.00,   1.00,   1.00,    .99,
	.99,    .99,    .99,    .98,    .98,    .98,    .98,
	.98,    .97,    .97,    .97,    .97,    .97,    .97,
	.97,    .96,    .96,    .96,    .96,    .96,    .96,
	.96,    .96,    .96,    .96,    .95,    .95,    .95,
	.94,    .93,    .93,    .92,    .92,    .91,    .90,
	.89,    .89,    .88,    .88,    .87,    .86,    .86,
	.85,    .85,    .84,    .84,    .83,    .82,    .82,
	.81,    .80,    .80,    .79,    .79,    .78,    .77,
	.77,    .76,    .76,    .75,    .75,    .74,    .74,
	.74,    .73,    .73,    .72,    .71,    .70,    .68,
	.67,    .65,    .64,    .63,    .62,    .61,    .60,
	.59,    .58,    .57,    .56,    .55,    .54,    .53,
	.52,    .51,    .50,    .49,    .49,    .48,    .47,
	.46,    .45,    .43,    .42,    .41,    .40,    .39,
	.38,    .37,    .36,    .35,    .34,    .33,    .31,
	.30,    .29,    .28,    .28,    .27,    .25,    .24,
	.23,    .22,    .21,    .20,    .19,    .18,    .17,
	.16,    .15,    .14,    .13,    .12,    .11,    .11,
	.10,    .09,    .08,    .08,    .08,    .07,    .06,
	.06,    .05,    .05,    .05,    .04,    .04,    .03,
	.03,    .02,    .02,    .01,    .01,    .01,    .01,
	.01,    .00,    .00,    .00 };


    ffu.wlinf=0.3499999f;
    ffu.wlsup=1.11f;

    int i;
    for(i = 0; i < 40; i++)	ffu.s[0] = 0;
    for(i = 0; i < 305; i++)	ffu.s[40+i] = sr[i];
    for(i = 345; i < 1501; i++) ffu.s[i] = 0;
}


void IWave::goes_east()
{
    /* spectral band of goes east */
    static const float sr[165] = {
	.00,    .00,    .00,    .01,    .01,    .03,    .05,
	.09,    .13,    .22,    .30,    .38,    .46,    .52,
	.58,    .63,    .68,    .70,    .73,    .75,    .77,
	.79,    .81,    .82,    .84,    .85,    .86,    .87,
	.88,    .89,    .90,    .91,    .92,    .93,    .93,
	.94,    .95,    .96,    .96,    .97,    .98,    .99,
	.99,    .99,    .98,    .98,    .97,    .97,    .96,
	.95,    .95,    .94,    .94,    .93,    .93,    .92,
	.92,    .91,    .91,    .91,    .91,    .91,    .91,
	.91,    .91,    .91,    .91,    .90,    .89,    .88,
	.88,    .86,    .84,    .83,    .81,    .79,    .77,
	.75,    .73,    .71,    .69,    .69,    .68,    .67,
	.66,    .65,    .64,    .63,    .61,    .60,    .59,
	.57,    .56,    .54,    .52,    .50,    .49,    .47,
	.46,    .44,    .43,    .41,    .40,    .38,    .36,
	.35,    .33,    .32,    .30,    .29,    .28,    .27,
	.26,    .25,    .23,    .22,    .21,    .20,    .19,
	.18,    .17,    .16,    .15,    .14,    .13,    .12,
	.11,    .10,    .10,    .09,    .08,    .08,    .07,
	.06,    .06,    .05,    .05,    .04,    .04,    .03,
	.03,    .03,    .02,    .02,    .02,    .02,    .01,
	.01,    .01,    .01,    .01,    .00,    .00,    .00,
	.00,    .00,    .00,    .00,    .00,    .00,    .00,
	.00,    .00,    .00,    .00 };

    ffu.wlinf = 0.49f;
    ffu.wlsup = 0.8999999f;
    int i = 0;
    for(i = 0; i < 96; i++)	ffu.s[i] = 0;
    for(i = 0; i < 165; i++)	ffu.s[96+i] = sr[i];
    for(i = 261; i < 1501; i++) ffu.s[i] = 0;
}

void IWave::goes_west()
{
    /* spectral band of goes west */
	
    static const float sr[165] = {
	.00,    .00,    .00,    .00,    .00,    .01,    .02,
	.04,    .06,    .12,    .18,    .30,    .41,    .51,
	.61,    .69,    .77,    .83,    .89,    .91,    .93,
	.94,    .96,    .96,    .97,    .98,    .99,    .99,
	.99,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,
	.99,    .99,    .99,    .98,    .98,    .97,    .97,
	.96,    .96,    .96,    .95,    .95,    .95,    .94,
	.94,    .93,    .92,    .91,    .90,    .89,    .88,
	.87,    .86,    .85,    .84,    .83,    .82,    .81,
	.80,    .80,    .79,    .78,    .77,    .76,    .75,
	.74,    .73,    .72,    .70,    .69,    .67,    .66,
	.64,    .63,    .61,    .59,    .58,    .56,    .55,
	.54,    .52,    .51,    .50,    .49,    .48,    .46,
	.45,    .44,    .43,    .41,    .40,    .38,    .37,
	.36,    .34,    .33,    .32,    .31,    .29,    .28,
	.27,    .26,    .24,    .23,    .22,    .21,    .20,
	.19,    .18,    .17,    .17,    .16,    .15,    .14,
	.14,    .13,    .12,    .12,    .11,    .10,    .09,
	.09,    .08,    .08,    .07,    .07,    .07,    .06,
	.06,    .05,    .05,    .05,    .04,    .04,    .03,
	.03,    .03,    .03,    .02,    .02,    .02,    .02,
	.02,    .01,    .01,    .01,    .01,    .01,    .01,
	.01,    .00,    .00,    .00,    .00,    .00,    .00,
	.00,    .00,    .00,    .00 };

    ffu.wlinf = 0.49f;
    ffu.wlsup = 0.8999999f;
    int i = 0;
    for(i = 0; i < 96; i++)	ffu.s[i] = 0;
    for(i = 0; i < 165; i++)	ffu.s[96+i] = sr[i];
    for(i = 261; i < 1501; i++) ffu.s[i] = 0;
}

void IWave::avhrr(int iwa)
{
    /* 1st spectral band of avhrr  (noaa 6) */
    static const float sr1[80] = {
	.0000, .0178, .0355, .0533, .0710, .1655, .2600, .3545,
	.4490, .5215, .5940, .6665, .7390, .7575, .7760, .7945,
	.8130, .8113, .8095, .8078, .8060, .8201, .8343, .8484,
	.8625, .8766, .8908, .9049, .9190, .9291, .9393, .9494,
	.9595, .9696, .9798, .9899, 1.000, .9996, .9992, .9989,
	.9985, .9981, .9977, .9974, .9970, .9596, .9222, .8849,
	.8475, .8101, .7727, .7354, .6980, .6047, .5115, .4182,
	.3250, .2767, .2285, .1802, .1320, .1127, .0935, .0742,
	.0550, .0480, .0410, .0340, .0270, .0235, .0200, .0165,
	.0130, .0115, .0100, .0085, .0070, .0052, .0035, .0017
    };

    /* 2nd spectral band of avhrr  (noaa 6) */
    static const float sr2[173] = {

	.0000, .0020, .0040, .0060, .0080, .0710, .1340, .1970,
	.2600, .3492, .4385, .5277, .6170, .6678, .7185, .7693,
	.8200, .8435, .8670, .8905, .9140, .9212, .9285, .9358,
	.9430, .9415, .9400, .9385, .9370, .9520, .9670, .9820,
	.9970, .9977, .9985, .9992, 1.000, .9813, .9625, .9438,
	.9250, .9148, .9045, .8943, .8840, .8751, .8663, .8574,
	.8485, .8396, .8307, .8219, .8130, .8100, .8070, .8040,
	.8010, .7980, .7950, .7920, .7890, .7878, .7865, .7853,
	.7840, .7828, .7815, .7803, .7790, .7751, .7713, .7674,
	.7635, .7596, .7558, .7519, .7480, .7464, .7448, .7431,
	.7415, .7399, .7383, .7366, .7350, .7225, .7100, .6975,
	.6850, .6783, .6715, .6648, .6580, .6515, .6450, .6385,
	.6320, .6270, .6220, .6170, .6120, .6093, .6065, .6038,
	.6010, .5993, .5975, .5958, .5940, .5910, .5880, .5850,
	.5820, .5720, .5620, .5520, .5420, .5243, .5065, .4887,
	.4710, .4402, .4095, .3787, .3480, .3155, .2830, .2505,
	.2180, .1935, .1690, .1445, .1200, .1055, .0910, .0765,
	.0620, .0540, .0460, .0380, .0300, .0257, .0215, .0172,
	.0130, .0112, .0095, .0077, .0060, .0053, .0045, .0038,
	.0030, .0025, .0020, .0015, .0010, .0010, .0010, .0010,
	.0010, .0009, .0007, .0006, .0005, .0004, .0004, .0003,
	.0002, .0002, .0001, .0001, .0000 
    };


    /* 1st spectral band of avhrr (noaa 7) */
    static const float sr3[121] = {
	.0000, .0008, .0016, .0024, .0032, .0032, .0031, .0030,
	.0030, .0029, .0029, .0028, .0028, .0027, .0027, .0026,
	.0025, .0031, .0036, .0042, .0047, .0288, .0529, .0769,
	.1010, .1943, .2875, .3808, .4740, .5363, .5985, .6608,
	.7230, .7390, .7550, .7710, .7870, .7838, .7805, .7773,
	.7740, .7788, .7835, .7883, .7930, .8100, .8270, .8440,
	.8610, .8958, .9305, .9653,1.0000, .9860, .9720, .9580,
	.9440, .9435, .9430, .9425, .9420, .9442, .9465, .9487,
	.9510, .9575, .9640, .9705, .9770, .9135, .8500, .7865,
	.7230, .6285, .5340, .4395, .3450, .2955, .2460, .1965,
	.1470, .1280, .1090, .0900, .0710, .0638, .0565, .0493,
	.0420, .0383, .0345, .0307, .0270, .0245, .0220, .0195,
	.0170, .0158, .0145, .0132, .0120, .0114, .0107, .0101,
	.0095, .0096, .0098, .0099, .0100, .0103, .0105, .0108,
	.0110, .0100, .0090, .0080, .0070, .0052, .0035, .0017,
	.0000 
    };

    /* 2nd spectral band of avhrr  (noaa 7) */
    static const float sr4[213] = {
	.0000, .0018, .0035, .0053, .0070, .0068, .0065, .0063,
	.0060, .0058, .0055, .0052, .0050, .0050, .0050, .0050,
	.0050, .0060, .0070, .0080, .0090, .0320, .0550, .0780,
	.1010, .1788, .2565, .3343, .4120, .4922, .5725, .6527,
	.7330, .7765, .8200, .8635, .9070, .9218, .9365, .9513,
	.9660, .9725, .9790, .9855, .9920, .9940, .9960, .9980,
	1.0000, .9962,.9925, .9887, .9850, .9870, .9890, .9910,
	.9930, .9763, .9595, .9428, .9260, .9298, .9335, .9373,
	.9410, .9373, .9335, .9298, .9260, .9120, .8980, .8840,
	.8700, .8700, .8700, .8700, .8700, .8703, .8705, .8708,
	.8710, .8708, .8705, .8703, .8700, .8715, .8730, .8745,
	.8760, .8740, .8720, .8700, .8680, .8690, .8700, .8710,
	.8720, .8687, .8655, .8623, .8590, .8555, .8520, .8485,
	.8450, .8428, .8405, .8383, .8360, .8328, .8295, .8263,
	.8230, .8145, .8060, .7975, .7890, .7872, .7855, .7838,
	.7820, .7790, .7760, .7730, .7700, .7682, .7665, .7648,
	.7630, .7545, .7460, .7375, .7290, .6987, .6685, .6382,
	.6080, .5623, .5165, .4707, .4250, .3812, .3375, .2937/
	.2500, .2215, .1930, .1645, .1360, .1202, .1045, .0887,
	.0730, .0647, .0565, .0482, .0400, .0357, .0315, .0272,
	.0230, .0207, .0185, .0162, .0140, .0125, .0110, .0095,
	.0080, .0075, .0070, .0065, .0060, .0055, .0050, .0045,
	.0040, .0039, .0038, .0037, .0036, .0036, .0037, .0037,
	.0037, .0035, .0034, .0032, .0031, .0029, .0028, .0026,
	.0025, .0025, .0024, .0024, .0023, .0023, .0022, .0022,
	.0021, .0021, .0021, .0020, .0020, .0019, .0019, .0018,
	.0018, .0013, .0009, .0004, .0000 
    };

    /* 1st spectral band of avhrr (noaa 8) */
    static const float sr5[189] = {
	.0000, .0012, .0024, .0036, .0048, .0223, .0399, .0574,
	.0749, .1633, .2517, .3400, .4284, .4937, .5590, .6243,
	.6896, .7135, .7375, .7614, .7853, .7833, .7813, .7793,
	.7773, .7774, .7775, .7776, .7777, .7922, .8067, .8211,
	.8356, .8566, .8777, .8987, .9197, .9332, .9468, .9603,
	.9739, .9674, .9609, .9545, .9480, .9507, .9534, .9561,
	.9588, .9691, .9794, .9897,1.0000, .9692, .9385, .9077,
	.8770, .7775, .6779, .5784, .4789, .4108, .3428, .2747,
	.2067, .1782, .1497, .1213, .0928, .0820, .0712, .0604,
	.0496, .0425, .0355, .0284, .0214, .0208, .0202, .0196,
	.0190, .0167, .0145, .0122, .0100, .0095, .0090, .0085,
	.0080, .0083, .0086, .0089, .0092, .0094, .0097, .0100,
	.0103, .0100, .0096, .0093, .0090, .0086, .0083, .0079,
	.0076, .0082, .0087, .0093, .0099, .0104, .0110, .0115,
	.0121, .0114, .0108, .0101, .0094, .0088, .0081, .0075,
	.0068, .0074, .0079, .0085, .0091, .0097, .0102, .0108,
	.0114, .0115, .0115, .0116, .0117, .0118, .0119, .0119,
	.0120, .0136, .0152, .0167, .0183, .0204, .0224, .0245,
	.0265, .0295, .0324, .0354, .0384, .0419, .0453, .0488,
	.0522, .0514, .0507, .0499, .0491, .0467, .0443, .0420,
	.0396, .0348, .0299, .0251, .0203, .0183, .0164, .0144,
	.0125, .0118, .0110, .0103, .0095, .0083, .0071, .0060,
	.0048, .0041, .0035, .0028, .0022, .0022, .0021, .0021,
	.0021, .0016, .0010, .0005, .0000 
    };


    /*  2nd spectral band of avhrr  (noaa 8) */
    static const float sr6[177] = { 
	.0000, .0095, .0190, .0285, .0381, .0476, .0571, .0666,
	.0761, .1559, .2358, .3156, .3954, .4855, .5756, .6658,
	.7559, .7966, .8373, .8779, .9186, .9332, .9478, .9624,
	.9770, .9814, .9858, .9902, .9946, .9959, .9973, .9986,
	1.0000, .9965, .9930, .9896, .9861, .9796, .9731, .9666,
	.9601, .9518, .9435, .9351, .9268, .9171, .9073, .8976,
	.8879, .8791, .8703, .8615, .8527, .8439, .8351, .8263,
	.8175, .8140, .8104, .8068, .8033, .7997, .7962, .7926,
	.7891, .7871, .7850, .7830, .7810, .7790, .7769, .7749,
	.7729, .7711, .7694, .7677, .7659, .7642, .7624, .7607,
	.7589, .7558, .7528, .7497, .7466, .7436, .7405, .7375,
	.7344, .7282, .7220, .7158, .7096, .7034, .6972, .6910,
	.6848, .6781, .6713, .6646, .6579, .6511, .6444, .6376,
	.6309, .6265, .6221, .6177, .6133, .6088, .6044, .6000,
	.5956, .5888, .5820, .5752, .5684, .5616, .5548, .5480,
	.5412, .5159, .4906, .4653, .4400, .4147, .3894, .3641,
	.3388, .3061, .2734, .2408, .2081, .1851, .1621, .1392,
	.1162, .1023, .0884, .0745, .0606, .0532, .0458, .0384/
	.0310, .0271, .0231, .0192, .0153, .0134, .0115, .0096,
	.0077, .0071, .0065, .0059, .0053, .0046, .0040, .0034,
	.0028, .0026, .0024, .0023, .0021, .0019, .0017, .0016,
	.0014, .0012, .0010, .0009, .0007, .0005, .0003, .0002,
	.0000
    };

    /* 1st spectral band of avhrr (noaa 9) */
    static const float sr7[113] = {
	.0000, .0001, .0003, .0004, .0006, .0040, .0074, .0108,
	.0142, .0622, .1101, .1581, .2060, .2810, .3561, .4311,
	.5061, .5500, .5940, .6379, .6818, .7127, .7437, .7746,
	.8055, .8122, .8190, .8170, .8150, .8063, .7975, .7887,
	.7800, .7881, .7962, .8044, .8125, .8335, .8544, .8753,
	.8963, .9000, .9037, .9074, .9111, .8899, .8688, .8476,
	.8265, .8198, .8130, .8110, .8090, .8277, .8464, .8650,
	.8837, .9128, .9419, .9709,1.0000, .9678, .9356, .9035,
	.8713, .7712, .6711, .5711, .4710, .4067, .3424, .2782,
	.2139, .1849, .1559, .1269, .0979, .0861, .0743, .0625,
	.0507, .0454, .0400, .0347, .0294, .0266, .0238, .0210,
	.0182, .0170, .0157, .0145, .0133, .0124, .0115, .0107,
	.0098, .0092, .0086, .0080, .0074, .0071, .0069, .0066,
	.0063, .0062, .0061, .0061, .0060, .0045, .0030, .0015,
	.0000
    };

    /* 2nd spectral band of avhrr  (noaa 9) */
    static const float sr8[197] = {
	.0000, .0011, .0022, .0033, .0044, .0207, .0369, .0532,
	.0694, .1410, .2127, .2843, .3559, .4388, .5217, .6047,
	.6876, .7304, .7731, .8159, .8586, .8782, .8977, .9173,
	.9369, .9491, .9614, .9736, .9859, .9894, .9930, .9965,
	1.0000, .9956, .9912, .9869, .9825, .9699, .9574, .9448,
	.9323, .9243, .9163, .9083, .9003, .8971, .8939, .8907,
	.8875, .8881, .8887, .8893, .8899, .8931, .8963, .8994,
	.9026, .9046, .9067, .9087, .9108, .9114, .9120, .9126,
	.9132, .9065, .8997, .8930, .8863, .8807, .8750, .8694,
	.8638, .8605, .8571, .8538, .8504, .8532, .8560, .8588,
	.8616, .8644, .8672, .8701, .8729, .8749, .8770, .8790,
	.8811, .8766, .8721, .8677, .8632, .8502, .8372, .8242,
	.8112, .7959, .7806, .7653, .7500, .7423, .7347, .7270,
	.7193, .7166, .7138, .7111, .7084, .7169, .7255, .7340,
	.7425, .7382, .7338, .7295, .7251, .6819, .6387, .5955,
	.5523, .4922, .4321, .3721, .3120, .2722, .2325, .1927,
	.1529, .1336, .1144, .0951, .0759, .0673, .0586, .0500,
	.0414, .0370, .0327, .0283, .0240, .0217, .0195, .0172,
	.0150, .0139, .0128, .0118, .0107, .0099, .0090, .0082,
	.0074, .0070, .0066, .0061, .0057, .0054, .0051, .0049,
	.0046, .0044, .0042, .0041, .0039, .0037, .0036, .0034,
	.0033, .0032, .0031, .0030, .0029, .0028, .0027, .0026,
	.0025, .0025, .0025, .0024, .0024, .0023, .0022, .0021,
	.0020, .0019, .0018, .0018, .0017, .0016, .0015, .0015,
	.0014, .0010, .0007, .0003, .0000
    };

    /* 1st spectral band of avhrr (noaa 10) */
    static const float sr9[101] = {
	.0000, .0005, .0010, .0015, .0020, .0023, .0025, .0028,
	.0030, .0239, .0448, .0657, .0866, .1852, .2838, .3824,
	.4810, .5470, .6130, .6790, .7450, .7640, .7830, .8020,
	.8210, .8182, .8154, .8126, .8098, .8219, .8339, .8460,
	.8580, .8808, .9035, .9263, .9490, .9607, .9723, .9840,
	.9956, .9875, .9793, .9712, .9630, .9595, .9560, .9525,
	.9490, .9618, .9745, .9872,1.0000, .9980, .9960, .9940,
	.9920, .9013, .8105, .7197, .6290, .5400, .4510, .3620,
	.2730, .2315, .1900, .1485, .1070, .0935, .0800, .0665,
	.0530, .0468, .0405, .0343, .0280, .0255, .0230, .0205,
	.0180, .0165, .0150, .0135, .0120, .0110, .0100, .0090,
	.0080, .0070, .0061, .0051, .0042, .0034, .0026, .0018,
	.0010, .0007, .0005, .0002, .0000
    };

    /* 2nd spectral band of avhrr  (noaa 10) */
    static const float sr10[237] = {
	.0000, .0006, .0012, .0018, .0024, .0030, .0036, .0042,
	.0048, .0049, .0049, .0050, .0051, .0051, .0052, .0052,
	.0053, .0053, .0054, .0054, .0055, .0055, .0056, .0056,
	.0057, .0054, .0050, .0047, .0044, .0041, .0037, .0034,
	.0031, .0031, .0032, .0032, .0033, .0033, .0033, .0034,
	.0034, .0239, .0445, .0650, .0855, .1561, .2267, .2974,
	.3680, .4508, .5335, .6163, .6990, .7430, .7870, .8310,
	.8750, .8918, .9085, .9253, .9420, .9510, .9600, .9690,
	.9780, .9835, .9890, .9945,1.0000, .9933, .9866, .9800,
	.9733, .9661, .9589, .9517, .9445, .9329, .9213, .9096,
	.8980, .8935, .8890, .8845, .8800, .8788, .8775, .8763,
	.8750, .8658, .8565, .8473, .8380, .8415, .8450, .8485,
	.8520, .8508, .8495, .8483, .8470, .8410, .8350, .8290,
	.8230, .8148, .8065, .7983, .7900, .7983, .8065, .8148,
	.8230, .8190, .8150, .8110, .8070, .7990, .7910, .7830,
	.7750, .7712, .7675, .7637, .7600, .7425, .7250, .7075,
	.6900, .6855, .6810, .6765, .6720, .6710, .6700, .6690,
	.6680, .6655, .6630, .6605, .6580, .6455, .6330, .6205,
	.6080, .5993, .5905, .5818, .5730, .5602, .5475, .5347,
	.5220, .4872, .4525, .4177, .3830, .3435, .3040, .2645,
	.2250, .2015, .1780, .1545, .1310, .1155, .1000, .0845,
	.0690, .0613, .0535, .0457, .0380, .0337, .0295, .0252,
	.0210, .0189, .0168, .0147, .0126, .0114, .0102, .0091,
	.0079, .0073, .0067, .0060, .0054, .0051, .0047, .0044,
	.0041, .0040, .0038, .0037, .0036, .0035, .0034, .0033,
	.0032, .0031, .0030, .0030, .0029, .0028, .0027, .0027,
	.0026, .0026, .0025, .0025, .0024, .0023, .0022, .0022,
	.0021, .0020, .0019, .0018, .0017, .0016, .0016, .0015,
	.0015, .0015, .0014, .0014, .0014, .0014, .0014, .0015,
	.0015, .0011, .0008, .0004, .0000
    };
 
    /* 1st spectral band of avhrr (noaa 11) */
    static const float sr11[113] = {
	.0000, .0033, .0065, .0098, .0130, .0500, .0870, .1240,
	.1610, .2385, .3160, .3935, .4710, .5150, .5590, .6030,
	.6470, .6768, .7065, .7363, .7660, .7745, .7830, .7915,
	.8000, .7918, .7835, .7753, .7670, .7747, .7825, .7903,
	.7980, .8215, .8450, .8685, .8920, .8907, .8895, .8882,
	.8870, .8702, .8535, .8367, .8200, .8110, .8020, .7930,
	.7840, .8050, .8260, .8470, .8680, .9010, .9340, .9670,
	1.0000, .9562, .9125, .8687, .8250, .7192, .6135, .5077,
	.4020, .3467, .2915, .2362, .1810, .1568, .1325, .1083,
	.0840, .0735, .0630, .0525, .0420, .0380, .0340, .0300,
	.0260, .0242, .0225, .0207, .0190, .0180, .0170, .0160,
	.0150, .0137, .0125, .0112, .0100, .0087, .0075, .0062,
	.0050, .0052, .0055, .0057, .0060, .0060, .0060, .0060,
	.0060, .0060, .0060, .0060, .0060, .0045, .0030, .0015,
	.0000
    };

    /* 2nd spectral band of avhrr  (noaa 11) */
    static const float sr12[209] = {
	.0000, .0005, .0010, .0015, .0020, .0025, .0030, .0035,
	.0040, .0039, .0037, .0036, .0035, .0034, .0032, .0031,
	.0030, .0029, .0028, .0026, .0025, .0024, .0023, .0021,
	.0020, .0020, .0020, .0020, .0020, .0020, .0020, .0020,
	.0020, .0028, .0035, .0043, .0050, .0173, .0295, .0418,
	.0540, .1150, .1760, .2370, .2980, .3822, .4665, .5507,
	.6350, .6865, .7380, .7895, .8410, .8623, .8835, .9048,
	.9260, .9415, .9570, .9725, .9880, .9910, .9940, .9970,
	1.0000, .9925, .9850, .9775, .9700, .9600, .9500, .9400,
	.9300, .9193, .9085, .8978, .8870, .8770, .8670, .8570,
	.8470, .8478, .8485, .8493, .8500, .8518, .8535, .8553,
	.8570, .8602, .8635, .8668, .8700, .8673, .8645, .8618,
	.8590, .8505, .8420, .8335, .8250, .8183, .8115, .8047,
	.7980, .7983, .7985, .7988, .7990, .7935, .7880, .7825,
	.7770, .7835, .7900, .7965, .8030, .8075, .8120, .8165,
	.8210, .8108, .8005, .7903, .7800, .7767, .7735, .7703,
	.7670, .7473, .7275, .7077, .6880, .6755, .6630, .6505,
	.6380, .6350, .6320, .6290, .6260, .6345, .6430, .6515/
	.6600, .6695, .6790, .6885, .6980, .6790, .6600, .6410,
	.6220, .5645, .5070, .4495, .3920, .3420, .2920, .2420,
	.1920, .1667, .1415, .1162, .0910, .0795, .0680, .0565,
	.0450, .0411, .0372, .0334, .0295, .0256, .0217, .0179,
	.0140, .0129, .0117, .0106, .0095, .0084, .0072, .0061,
	.0050, .0048, .0045, .0043, .0040, .0038, .0035, .0033,
	.0030, .0029, .0027, .0026, .0025, .0024, .0022, .0021,
	.0020, .0017, .0015, .0012, .0010, .0007, .0005, .0002,
	.0000
    };

    /* 1st spectral band of avhrr (noaa 12) */
    static const float sr13[201] = {
	.0000, .0000, .0000, .0000, .0000, .0000, .0000, .0000,
	.0000, .0000, .0000, .0000, .0000, .0000, .0000, .0000,
	.0000, .0000, .0000, .0000, .0000, .0048, .0135, .0200,
	.0270, .1046, .2094, .3253, .4360, .5286, .6030, .6621,
	.7090, .7464, .7753, .7966, .8110, .8196, .8249, .8301,

	.8380, .8507, .8668, .8837, .8990, .9109, .9198, .9265,
	.9320, .9371, .9419, .9466, .9510, .9552, .9587, .9612,
	.9620, .9610, .9593, .9582, .9590, .9625, .9673, .9715,
	.9730, .9707, .9666, .9635, .9640, .9701, .9799, .9908,
	1.0000, .9805, .9590, .9407, .9180, .8357, .7325, .6205,
	.5120, .4170, .3365, .2692, .2140, .1695, .1343, .1066,
	.0850, .0679, .0546, .0442, .0360, .0294, .0240, .0196,
	.0160, .0130, .0105, .0089, .0080, .0080, .0083, .0085,
	.0080, .0064, .0041, .0018, .0000, .0000, .0000, .0000,
	.0000, .0000, .0000, .0000, .0000, .0000, .0000, .0000,
	.0000, .0000, .0000, .0000, .0000, .0000, .0000, .0000,
	.0000, .0000, .0000, .0000, .0000, .0000, .0000, .0000,
	.0000, .0024, .0056, .0087, .0110, .0118, .0117, .0112,
	.0110, .0117, .0130, .0145, .0160, .0171, .0178, .0184,
	.0190, .0197, .0205, .0213, .0220, .0226, .0229, .0228,
	.0220, .0205, .0187, .0170, .0160, .0159, .0160, .0157,
	.0140, .0106, .0063, .0023, .0000, .0001, .0018, .0038,
	.0050, .0044, .0027, .0009, .0000, .0006, .0023, .0040,
	.0050, .0046, .0032, .0015, .0000, .0000, .0000, .0000,
	.0000, .0000, .0000, .0000, .0000, .0000, .0000, .0000,
	.0000
    };

    /* 2nd spectral band of avhrr  (noaa 12) */
    static const float sr14[189] = {
	.0000, .0000, .0000, .0000, .0000, .0000, .0000, .0000,
	.0000, .0050, .0111, .0162, .0180, .0153, .0097, .0038,
	.0000, .0005, .0060, .0168, .0330, .0555, .0869, .1303,
	.1890, .2643, .3509, .4418, .5300, .6096, .6796, .7403,
	.7920, .8350, .8702, .8988, .9220, .9408, .9559, .9680,
	.9780, .9863, .9929, .9975,1.0000, .0115, .9987, .9958,
	.9920, .9876, .9821, .9748, .9650, .9522, .9370, .9203,
	.9030, .8858, .8694, .8543, .8410, .8299, .8207, .8129,
	.8060, .7997, .7943, .7902, .7880, .7879, .7893, .7916,
	.7940, .7959, .7971, .7972, .7960, .7935, .7900, .7860,
	.7820, .7783, .7747, .7704, .7650, .7582, .7506, .7433,
	.7370, .7326, .7299, .7288, .7290, .7303, .7323, .7350,
	.7380, .7411, .7441, .7468, .7490, .7504, .7510, .7505,
	.7490, .7463, .7421, .7365, .7290, .7197, .7086, .6960,
	.6820, .6670, .6518, .6371, .6240, .6131, .6043, .5973,
	.5920, .5881, .5857, .5849, .5860, .5889, .5929, .5969,
	.6000, .6011, .5986, .5905, .5750, .5508, .5186, .4792,
	.4340, .3842, .3326, .2822, .2360, .1964, .1633, .1357,
	.1130, .0943, .0789, .0664, .0560, .0473, .0400, .0339,
	.0290, .0250, .0217, .0191, .0170, .0152, .0137, .0123,
	.0110, .0098, .0086, .0077, .0070, .0066, .0063, .0059,
	.0050, .0035, .0019, .0005, .0000, .0006, .0019, .0033,
	.0040, .0036, .0025, .0011, .0000, .0000, .0000, .0000,
	.0000, .0000, .0000, .0000, .0000
    };

    /* 1st spectral band of avhrr (noaa 14) -from NOAA/POD Guide */
    static const float sr15[241] = {
	.0000, .0000, .0000, .0000, .0000, .0000, .0000, .0000,
	.0000, .0000, .0000, .0000, .0000, .0000, .0000, .0000,
	.0000, .0003, .0007, .0010, .0013, .0152, .0290, .0429,
	.0568, .1226, .1884, .2543, .3201, .3727, .4254, .4780,
	.5306, .5528, .5749, .5971, .6193, .6267, .6342, .6417,
	.6492, .6538, .6583, .6629, .6675, .6734, .6793, .6853,
	.6912, .6948, .6984, .7020, .7056, .7106, .7156, .7206,
	.7256, .7243, .7229, .7216, .7203, .7188, .7174, .7159,
	.7145, .7130, .7116, .7102, .7088, .7154, .7221, .7287,
	.7353, .7292, .7232, .7172, .7111, .6501, .5891, .5281,
	.4671, .4037, .3402, .2768, .2133, .1830, .1527, .1223,
	.0920, .0797, .0675, .0553, .0431, .0406, .0381, .0357,
	.0332, .0279, .0226, .0173, .0120, .0117, .0114, .0110,
	.0107, .0100, .0093, .0086, .0080, .0076, .0072, .0069,
	.0065, .0062, .0059, .0055, .0052, .0051, .0050, .0048,
	.0047, .0048, .0049, .0050, .0051, .0051, .0050, .0050,
	.0050, .0050, .0051, .0052, .0052, .0053, .0054, .0054,
	.0055, .0057, .0059, .0061, .0063, .0068, .0072, .0076,
	.0080, .0084, .0088, .0092, .0096, .0100, .0104, .0108,
	.0113, .0116, .0119, .0122, .0125, .0127, .0128, .0130,
	.0132, .0130, .0128, .0126, .0123, .0120, .0116, .0112,
	.0108, .0104, .0099, .0095, .0090, .0086, .0082, .0078,
	.0074, .0072, .0070, .0067, .0065, .0063, .0060, .0058,
	.0055, .0053, .0050, .0048, .0046, .0044, .0042, .0040,
	.0038, .0036, .0034, .0032, .0030, .0028, .0027, .0025,
	.0023, .0022, .0022, .0021, .0020, .0019, .0018, .0017,
	.0016, .0016, .0015, .0014, .0014, .0013, .0012, .0012,
	.0011, .0011, .0011, .0011, .0011, .0011, .0011, .0011,
	.0011, .0011, .0011, .0011, .0011, .0011, .0011, .0010,
	.0010, .0010, .0010, .0010, .0010, .0010, .0010, .0010,
	.0010
    };

    /* 2nd spectral band of avhrr (noaa 14) */
    static const float sr16[176] = {
	.0000,.0000,.0000,.0000,.0000,.0000,.0022,.0045,
	.0067,.0090,.0107,.0125,.0143,.0160,.0543,.0925,
	.1308,.1690,.2573,.3455,.4338,.5220,.5978,.6735,
	.7492,.8250,.8503,.8755,.9007,.9260,.9362,.9465,
	.9568,.9670,.9737,.9805,.9872,.9940,.9935,.9930,
	.9925,.9920,.9940,.9960,.9980,1.000,.9885,.9770,
	.9655,.9540,.9398,.9255,.9112,.8970,.8855,.8740,
	.8625,.8510,.8400,.8290,.8180,.8070,.8052,.8035,
	.8018,.8000,.8065,.8130,.8195,.8260,.8257,.8255,
	.8253,.8250,.8245,.8240,.8235,.8230,.8230,.8230,
	.8230,.8230,.8210,.8190,.8170,.8150,.8147,.8145,
	.8142,.8140,.8183,.8225,.8267,.8310,.8367,.8425,
	.8482,.8540,.8547,.8555,.8562,.8570,.8510,.8450,
	.8390,.8330,.8170,.8010,.7850,.7690,.7587,.7485,
	.7383,.7280,.7203,.7125,.7048,.6970,.6957,.6945,
	.6932,.6920,.6970,.7020,.7070,.7120,.7035,.6950,
	.6865,.6780,.6370,.5960,.5550,.5140,.4560,.3980,
	.3400,.2820,.2458,.2095,.1732,.1370,.1190,.1010,
	.0830,.0650,.0560,.0470,.0380,.0290,.0250,.0210,
	.0170,.0130,.0095,.0060,.0050,.0040,.0020,.0000,
	.0010,.0020,.0018,.0015,.0012,.0010,.0010,.0010,
	.0010,.0010,.0008,.0005,.0003,.0000,.0000,.0000
    };

    static const float wli[16] = { 0.55, 0.69, 0.5, 0.64, 0.54, 0.68, 0.53, 0.68, 0.53, 0.60, 0.54, 0.60, 0.50, 0.65, 0.50, 0.68 };
    static const float wls[16] = { 0.75, 1.12, 0.8, 1.17, 1.01, 1.12, 0.81, 1.17, 0.78, 1.19, 0.82, 1.12, 1.00, 1.12, 1.11, 1.10 };

    ffu.wlinf = (float)wli[iwa-1];
    ffu.wlsup = (float)wls[iwa-1];

    int i;
    for(i = 0; i < 1501; i++) ffu.s[i] = 0; 

    switch(iwa)
    {
    case 1: for(i = 0; i < 80; i++)  ffu.s[120+i] = sr1[i];
	break;
    case 2: for(i = 0; i < 173; i++) ffu.s[176+i] = sr2[i];
	break;
    case 3: for(i = 0; i < 121; i++) ffu.s[100+i] = sr3[i];
	break;
    case 4: for(i = 0; i < 213; i++) ffu.s[156+i] = sr4[i];
	break;
    case 5: for(i = 0; i < 189; i++) ffu.s[116+i] = sr5[i];
	break;
    case 6: for(i = 0; i < 177; i++) ffu.s[172+i] = sr6[i];
	break;
    case 7: for(i = 0; i < 113; i++) ffu.s[112+i] = sr7[i];
	break;
    case 8: for(i = 0; i < 197; i++) ffu.s[172+i] = sr8[i];
	break;
    case 9: for(i = 0; i < 101; i++) ffu.s[112+i] = sr9[i];
	break;
    case 10: for(i = 0; i < 237; i++) ffu.s[140+i] = sr10[i];
	break;
    case 11: for(i = 0; i < 113; i++) ffu.s[116+i] = sr11[i];
	break;
    case 12: for(i = 0; i < 209; i++) ffu.s[140+i] = sr12[i];
	break;
    case 13: for(i = 0; i < 201; i++) ffu.s[100+i] = sr13[i];
	break;
    case 14: for(i = 0; i < 189; i++) ffu.s[160+i] = sr14[i];
	break;
    case 15: for(i = 0; i < 241; i++) ffu.s[100+i] = sr15[i];
	break;
    case 16: for(i = 0; i < 176; i++) ffu.s[168+i] = sr16[i];
    }
}

void IWave::hrv(int iwa)
{

    /* 1st spectral band of hrv1 */
    static const float sr1[73] = {
	.0010, .0023, .0035, .0048, .0060, .0492, .0925, .1357,
	.1790, .2598, .3405, .4213, .5020, .5575, .6130, .6685,
	.7240, .7588, .7935, .8283, .8630, .8900, .9170, .9440,
	.9710, .9782, .9855, .9927,1.0000, .9875, .9750, .9625,
	.9500, .9255, .9010, .8765, .8520, .8225, .7930, .7635,
	.7340, .7105, .6870, .6635, .6400, .5945, .5490, .5035,
	.4580, .3985, .3390, .2795, .2200, .1787, .1375, .0962,
	.0550, .0437, .0325, .0212, .0100, .0085, .0070, .0055,
	.0040, .0035, .0030, .0025, .0020, .0015, .0010, .0005,
	.0000
    };

    /* 2nd spectral band of hrv1 */
    static const float sr2[49] = {
	.0190, .0845, .1500, .2155, .2810, .3870, .4930, .5990,
	.7050, .7663, .8275, .8888, .9500, .9557, .9615, .9672,
	.9730, .9797, .9865, .9933,1.0000, .8445, .6890, .5335,
	.3780, .3152, .2525, .1897, .1270, .1067, .0865, .0662,
	.0460, .0395, .0330, .0265, .0200, .0172, .0145, .0117,
	.0090, .0080, .0070, .0060, .0050, .0045, .0040, .0035,
	.0030
    };

    /* 3rd spectral band of hrv1 */
    static const float sr3[81] = {
	.0010, .0033, .0055, .0078, .0100, .0238, .0375, .0513,
	.0650, .0953, .1255, .1558, .1860, .2470, .3080, .3690,
	.4300, .4918, .5535, .6153, .6770, .7222, .7675, .8127,
	.8580, .8825, .9070, .9315, .9560, .9670, .9780, .9890,
	1.0000, .9915, .9830, .9745, .9660, .9557, .9455, .9352,
	.9250, .9112, .8975, .8837, .8700, .8777, .8855, .8932,
	.9010, .8342, .7675, .7007, .6340, .5600, .4860, .4120,
	.3380, .2875, .2370, .1865, .1360, .1130, .0900, .0670,
	.0440, .0360, .0280, .0200, .0120, .0108, .0095, .0083,
	.0070, .0067, .0065, .0062, .0060, .0047, .0035, .0022,
	.0010
    };

    /* panchromatic band of hrv1 */
    static const float sr4[129] = {
	.0000, .0013, .0025, .0038, .0050, .0322, .0595, .0867,
	.1140, .1723, .2305, .2888, .3470, .3748, .4025, .4303,
	.4580, .4750, .4920, .5090, .5260, .5538, .5815, .6093,
	.6370, .6575, .6780, .6985, .7190, .7228, .7265, .7303,
	.7340, .7370, .7400, .7430, .7460, .7595, .7730, .7865,
	.8000, .8163, .8325, .8488, .8650, .8767, .8885, .9003,
	.9120, .9137, .9155, .9172, .9190, .9245, .9300, .9355,
	.9410, .9387, .9365, .9342, .9320, .9373, .9425, .9478,
	.9530, .9575, .9620, .9665, .9710, .9783, .9855, .9928,
	1.0000, .9898, .9795, .9693, .9590, .9450, .9310, .9170,
	.9030, .8780, .8530, .8280, .8030, .7770, .7510, .7250,
	.6990, .6820, .6650, .6480, .6310, .6235, .6160, .6085,
	.6010, .5535, .5060, .4585, .4110, .3620, .3130, .2640,
	.2150, .1825, .1500, .1175, .0850, .0720, .0590, .0460,
	.0330, .0282, .0235, .0187, .0140, .0120, .0100, .0080,
	.0060, .0055, .0050, .0045, .0040, .0035, .0030, .0025,
	.0020
    };

    /* 1st spectral band of hrv2 */
    static const float sr5[73] = {
	.0010, .0015, .0020, .0025, .0030, .0040, .0050, .0060,
	.0070, .0850, .1630, .2410, .3190, .3918, .4645, .5373,
	.6100, .6500, .6900, .7300, .7700, .7965, .8230, .8495,
	.8760, .8957, .9155, .9352, .9550, .9663, .9775, .9888,
	1.0000, .9915, .9830, .9745, .9660, .9362, .9065, .8767,
	.8470, .8147, .7825, .7502, .7180, .6660, .6140, .5620,
	.5100, .4638, .4175, .3713, .3250, .2737, .2225, .1712,
	.1200, .1012, .0825, .0637, .0450, .0377, .0305, .0232,
	.0160, .0122, .0085, .0047, .0010, .0007, .0005, .0002,
	.0000
    };

    /* 2nd spectral band of hrv2 */
    static const float sr6[57] = {	
	.0040, .0045, .0050, .0055, .0060, .0115, .0170, .0225,
	.0280, .0893, .1505, .2118, .2730, .3593, .4455, .5318,
	.6180, .6803, .7425, .8048, .8670, .9003, .9335, .9668,
	1.0000, .9365, .8730, .8095, .7460, .6830, .6200, .5570,
	.4940, .4405, .3870, .3335, .2800, .2452, .2105, .1757,
	.1410, .1222, .1035, .0847, .0660, .0575, .0490, .0405,
	.0320, .0283, .0245, .0208, .0170, .0152, .0135, .0117,
	.0100
    };

    /* 3rd spectral band of hrv2 */
    static const float sr7[81] = {	
	.0020, .0030, .0040, .0050, .0060, .0105, .0150, .0195,
	.0240, .0380, .0520, .0660, .0800, .1140, .1480, .1820,
	.2160, .2722, .3285, .3847, .4410, .5018, .5625, .6233,
	.6840, .7298, .7755, .8213, .8670, .8920, .9170, .9420,
	.9670, .9753, .9835, .9918,1.0000, .9967, .9935, .9902,
	.9870, .9793, .9715, .9638, .9560, .9500, .9440, .9380,
	.9320, .9047, .8775, .8502, .8230, .7665, .7100, .6535,
	.5970, .5305, .4640, .3975, .3310, .2850, .2390, .1930,
	.1470, .1250, .1030, .0810, .0590, .0497, .0405, .0312,
	.0220, .0185, .0150, .0115, .0080, .0062, .0045, .0027,
	.0010
    };
 
    /* panchromatic spectral band of hrv2 */
    static const float sr8[129] = {	
	.0010, .0013, .0015, .0018, .0020, .0137, .0255, .0372,
	.0490, .0898, .1305, .1713, .2120, .2468, .2815, .3163,
	.3510, .3725, .3940, .4155, .4370, .4655, .4940, .5225,
	.5510, .5742, .5975, .6207, .6440, .6505, .6570, .6635,
	.6700, .6752, .6805, .6858, .6910, .7032, .7155, .7278,
	.7400, .7530, .7660, .7790, .7920, .8027, .8135, .8242,
	.8350, .8427, .8505, .8582, .8660, .8692, .8725, .8758,
	.8790, .8830, .8870, .8910, .8950, .9025, .9100, .9175,
	.9250, .9365, .9480, .9595, .9710, .9783, .9855, .9928,
	1.0000, .9930, .9860, .9790, .9720, .9548, .9375, .9202,
	.9030, .8802, .8575, .8347, .8120, .7945, .7770, .7595,
	.7420, .7062, .6705, .6347, .5990, .5587, .5185, .4782,
	.4380, .3893, .3405, .2918, .2430, .2085, .1740, .1395,
	.1050, .0895, .0740, .0585, .0430, .0367, .0305, .0242,
	.0180, .0155, .0130, .0105, .0080, .0070, .0060, .0050,
	.0040, .0035, .0030, .0025, .0020, .0018, .0015, .0013,
	.0010
    };

    static const float wli[8] = { 0.4699999, 0.60, 0.73, 0.4699999, 0.4699999, 0.5899999, 0.74, 0.4699999 };
    static const float wls[8] = { 0.6499999, 0.72, 0.93, 0.7900000, 0.6499999, 0.7300000, 0.94, 0.7900000 };

    ffu.wlinf = wli[iwa-1];
    ffu.wlsup = wls[iwa-1];

    int i;
    for(i = 0; i < 1501; i++) ffu.s[i] = 0; 

    switch(iwa)
    {
    case 1: for(i = 0; i < 73; i++)	 ffu.s[88+i] = sr1[i];
	break;
    case 2: for(i = 0; i < 49; i++)	 ffu.s[140+i] = sr2[i];
	break;
    case 3: for(i = 0; i < 81; i++)	 ffu.s[192+i] = sr3[i];
	break;
    case 4: for(i = 0; i < 129; i++)	 ffu.s[88+i] = sr4[i];
	break;
    case 5: for(i = 0; i < 73; i++)	 ffu.s[88+i] = sr5[i];
	break;
    case 6: for(i = 0; i < 57; i++)	 ffu.s[136+i] = sr6[i];
	break;
    case 7: for(i = 0; i < 81; i++)	 ffu.s[196+i] = sr7[i];
	break;
    case 8: for(i = 0; i < 129; i++)	 ffu.s[88+i] = sr8[i];
	break;
    }
}


void IWave::tm(int iwa)
{
    /* 1st spectral band of thematic mapper */
    static const float sr1[53] = {		
	.0030, .0085, .0140, .0255, .0370, .0500, .0630, .2010,
	.3390, .5030, .6670, .6935, .7200, .7525, .7850, .8030,
	.8210, .8370, .8530, .8780, .9030, .9135, .9240, .9355,
	.9470, .9625, .9780, .9835, .9890, .9860, .9830, .9060,
	.8290, .7815, .7340, .5265, .3190, .1995, .0800, .0630,
	.0460, .0380, .0300, .0230, .0160, .0120, .0080, .0065,
	.0050, .0045, .0040, .0035, .0030
    };

    /* 2nd spectral band of thematic mapper */
    static const float sr2[61] = {
	.0010, .0055, .0100, .0165, .0230, .0305, .0380, .1010,
	.1640, .2710, .3780, .4750, .5720, .6150, .6580, .6945,
	.7310, .7575, .7840, .8105, .8370, .8510, .8650, .8770,
	.8890, .8965, .9040, .9055, .9070, .9070, .9070, .9095,
	.9120, .9310, .9500, .9685, .9870, .9951, .9980, .9705,
	.9430, .8655, .7880, .6250, .4620, .3330, .2040, .1505,
	.0970, .0745, .0520, .0440, .0360, .0285, .0210, .0165,
	.0120, .0090, .0060, .0030, .0000
    };

    /* 3rd spectral band of thematic mapper */
    static const float sr3[65] = { 
	.0020, .0020, .0020, .0020, .0020, .0030, .0040, .0060,
	.0080, .0140, .0200, .0290, .0380, .0730, .1080, .2020,
	.2960, .3840, .4720, .5245, .5770, .6625, .7480, .7830,
	.8180, .8430, .8680, .8845, .9010, .9030, .9050, .9055,
	.9060, .9200, .9340, .9520, .9700, .9815, .9930,1.0000,
	.9980, .9770, .9560, .8715, .7870, .5775, .3680, .2435,
	.1190, .0920, .0650, .0555, .0460, .0385, .0310, .0255,
	.0200, .0160, .0120, .0090, .0060, .0055, .0050, .0040,
	.0030
    };

    /* 4th spectral band of thematic mapper */
    static const float sr4[89] = {  
	.0020, .0035, .0050, .0060, .0070, .0080, .0090, .0140,
	.0190, .0260, .0330, .0520, .0710, .1035, .1360, .2055,
	.2750, .3615, .4480, .5505, .6530, .7410, .8290, .8795,
	.9300, .9520, .9740, .9870,1.0000, .9955, .9910, .9855,
	.9800, .9685, .9570, .9465, .9360, .9260, .9160, .9165,
	.9170, .9180, .9190, .9195, .9200, .9215, .9230, .9240,
	.9250, .9160, .9070, .8965, .8860, .8835, .8810, .8825,
	.8840, .8825, .8810, .8705, .8600, .8410, .8220, .8030,
	.7840, .7715, .7590, .7370, .7150, .5905, .4660, .3385,
	.2110, .1440, .0770, .0540, .0310, .0230, .0150, .0115,
	.0080, .0070, .0060, .0050, .0040, .0030, .0020, .0010,
	.0000
    };
	 
    /* 5th spectral band of thematic mapper */
    static const float sr5[156] = { 
	.0000, .0003, .0007, .0010, .0013, .0015, .0018, .0020,
	.0038, .0055, .0073, .0090, .0123, .0155, .0188, .0220,
	.0393, .0565, .0738, .0910, .1410, .1910, .2410, .2910,
	.3617, .4325, .5032, .5740, .6383, .7025, .7668, .8310,
	.8622, .8935, .9248, .9560, .9522, .9485, .9447, .9410,
	.9417, .9425, .9433, .9440, .9505, .9570, .9635, .9700,
	.9738, .9775, .9813, .9850, .9833, .9815, .9797, .9780,
	.9747, .9715, .9682, .9650, .9682, .9715, .9747, .9780,
	.9793, .9805, .9818, .9830, .9837, .9845, .9852, .9860,
	.9838, .9815, .9793, .9770, .9815, .9860, .9905, .9950,
	.9963, .9975, .9988,1.0000, .9992, .9985, .9977, .9970,
	.9912, .9855, .9797, .9740, .9697, .9655, .9613, .9570,
	.9553, .9535, .9517, .9500, .9505, .9510, .9515, .9520,
	.9370, .9220, .9070, .8920, .8260, .7600, .6940, .6280,
	.5507, .4735, .3962, .3190, .2780, .2370, .1960, .1550,
	.1340, .1130, .0920, .0710, .0643, .0575, .0508, .0440,
	.0385, .0330, .0275, .0220, .0197, .0175, .0152, .0130,
	.0120, .0110, .0100, .0090, .0077, .0065, .0052, .0040,
	.0037, .0035, .0032, .0030, .0027, .0025, .0022, .0020,
	.0015, .0010, .0005, .0000
    };

    /* 7th spectral band of thematic mapper */
    static const float sr6[185] = { 
	.0000, .0005, .0010, .0015, .0020, .0025, .0030, .0035,
	.0040, .0043, .0045, .0048, .0050, .0055, .0060, .0065,
	.0070, .0075, .0080, .0085, .0090, .0103, .0115, .0128,
	.0140, .0153, .0165, .0178, .0190, .0233, .0275, .0318,
	.0360, .0400, .0440, .0480, .0520, .0563, .0605, .0648,
	.0690, .0768, .0845, .0923, .1000, .1125, .1250, .1375,
	.1500, .1753, .2005, .2258, .2510, .2870, .3230, .3590,
	.3950, .4313, .4675, .5038, .5400, .5788, .6175, .6563,
	.6950, .7345, .7740, .8135, .8530, .8737, .8945, .9152,
	.9360, .9398, .9435, .9473, .9510, .9472, .9435, .9397,
	.9360, .9385, .9410, .9435, .9460, .9500, .9540, .9580,
	.9620, .9693, .9765, .9838, .9910, .9930, .9950, .9970,
	.9990,1.0000, .9988, .9975, .9960, .9952, .9945, .9937,
	.9930, .9922, .9915, .9908, .9900, .9815, .9730, .9645,
	.9560, .9525, .9490, .9455, .9420, .9370, .9320, .9270,
	.9220, .9205, .9190, .9175, .9160, .9135, .9110, .9085,
	.9060, .9020, .8980, .8940, .8900, .8730, .8560, .8390,
	.8220, .8058, .7895, .7732, .7570, .7545, .7520, .7495,
	.7470, .7623, .7775, .7928, .8080, .8245, .8410, .8575,
	.8740, .8292, .7845, .7397, .6950, .6290, .5630, .4970,
	.4310, .3747, .3185, .2622, .2060, .1735, .1410, .1085,
	.0760, .0653, .0545, .0438, .0330, .0275, .0220, .0165,
	.0110, .0097, .0085, .0072, .0060, .0045, .0030, .0015,
	.0000
    };

    static const float wli[6] = { 0.43, 0.5000000, 0.5799999, 0.73, 1.5025, 1.95 };
    static const float wls[6] = { 0.56, 0.6499999, 0.7400000, 0.95, 1.8900, 2.41 };

    ffu.wlinf = wli[iwa-1];
    ffu.wlsup = wls[iwa-1];

    int i;
    for(i = 0; i < 1501; i++) ffu.s[i] = 0; 

    switch(iwa)
    {
    case 1: for(i = 0; i < 53; i++)	 ffu.s[72+i] = sr1[i];
	break;
    case 2: for(i = 0; i < 61; i++)	 ffu.s[100+i] = sr2[i];
	break;
    case 3: for(i = 0; i < 65; i++)	 ffu.s[132+i] = sr3[i];
	break;
    case 4: for(i = 0; i < 89; i++)	 ffu.s[192+i] = sr4[i];
	break;
    case 5: for(i = 0; i < 156; i++)	 ffu.s[501+i] = sr5[i];
	break;
    case 6: for(i = 0; i < 185; i++)	 ffu.s[680+i] = sr6[i];
	break;
    }
}

void IWave::mss(int iwa)
{
    /* 1st spectral band of multi spectral scanner */
    static const float sr1[67] = { 
	.00,    .01,    .01,    .01,    .02,    .04,    .05,
	.09,    .13,    .21,    .29,    .45,    .61,    .72,
	.82,    .85,    .89,    .92,    .95,    .96,    .98,
	.99,    .99,   1.00,   1.00,   1.00,   1.00,   1.00,
	1.00,   1.00,   .99,    .99,    .98,    .98,    .98,
	.97,    .97,    .96,    .96,    .96,    .96,    .95,
	.95,    .93,    .91,    .89,    .87,    .85,    .82,
	.73,    .65,    .54,    .43,    .38,    .33,    .24,
	.15,    .11,    .08,    .06,    .04,    .03,    .03,
	.02,    .02,    .02,    .01
    };

    /* 2nd spectral band of multi spectral scanner */
    static const float sr2[69] = { 
	.01,    .01,    .01,    .01,    .01,    .01,    .02,
	.03,    .04,    .08,    .13,    .21,    .29,    .43,
	.57,    .69,    .80,    .86,    .92,    .94,    .96,
	.97,    .99,    .99,   1.00,   1.00,   1.00,    .99,
	.98,    .97,    .96,    .94,    .93,    .90,    .88,
	.92,    .96,    .96,    .96,    .95,    .95,    .90,
	.84,    .82,    .80,    .79,    .78,    .79,    .80,
	.80,    .80,    .73,    .67,    .59,    .50,    .38,
	.25,    .18,    .11,    .09,    .08,    .07,    .06,
	.05,    .05,    .04,    .04,    .03,    .03
    };

    /* 3rd spectral band of multi spectral scanner */
    static const float sr3[81] = { 
	.01,    .01,    .01,    .02,    .02,    .02,    .02,
	.03,    .03,    .05,    .07,    .10,    .14,    .17,
	.20,    .31,    .41,    .48,    .56,    .66,    .75,
	.83,    .90,    .93,    .97,    .98,    .99,   1.00,
	1.00,   1.00,   .99,    .99,    .98,    .97,    .96,
	.94,    .93,    .90,    .88,    .87,    .86,    .84,
	.83,    .82,    .82,    .82,    .82,    .82,    .83,
	.83,    .83,    .83,    .83,    .81,    .80,    .78,
	.75,    .68,    .61,    .55,    .49,    .41,    .34,
	.29,    .24,    .19,    .15,    .12,    .08,    .07,
	.07,    .05,    .03,    .03,    .03,    .02,    .02,
	.01,    .01,    .01,    .01
    };

    /* 4th spectral band of multi spectral scanner */
    static const float sr4[127] = { 
	.01,    .02,    .02,    .04,    .06,    .14,    .21,
	.45,    .68,    .76,    .83,    .89,    .94,    .94,
	.94,    .94,    .95,    .95,    .96,    .97,    .98,
	.99,    .99,   1.00,   1.00,   1.00,   1.00,   1.00,
	1.00,   1.00,   .99,    .98,    .97,    .96,    .95,
	.94,    .93,    .92,    .92,    .91,    .90,    .89,
	.88,    .87,    .86,    .86,    .85,    .83,    .82,
	.81,    .80,    .78,    .77,    .76,    .76,    .75,
	.74,    .72,    .70,    .69,    .68,    .66,    .64,
	.63,    .62,    .61,    .60,    .58,    .57,    .56/
	.55,    .55,    .54,    .52,    .51,    .50,    .49,
	.47,    .46,    .45,    .44,    .43,    .42,    .41,
	.40,    .39,    .39,    .38,    .37,    .36,    .35,
	.34,    .33,    .32,    .31,    .30,    .29,    .28,
	.27,    .26,    .25,    .24,    .23,    .22,    .21,
	.20,    .20,    .19,    .18,    .16,    .15,    .14,
	.13,    .12,    .12,    .11,    .10,    .08,    .07,
	.06,    .06,    .05,    .04,    .03,    .02,    .01,
	.01
    };

    static const float wli[4] = { 0.4749999, 0.5799999, 0.6549999, 0.7849999 };
    static const float wls[4] = { 0.6399999, 0.7500000, 0.8549998, 1.1000000 };

    ffu.wlinf = wli[iwa-1];
    ffu.wlsup = wls[iwa-1];

    int i;
    for(i = 0; i < 1501; i++) ffu.s[i] = 0; 

    switch(iwa)
    {
    case 1: for(i = 0; i < 67; i++)	 ffu.s[90+i] = sr1[i];
	break;
    case 2: for(i = 0; i < 69; i++)	 ffu.s[132+i] = sr2[i];
	break;
    case 3: for(i = 0; i < 81; i++)	 ffu.s[162+i] = sr3[i];
	break;
    case 4: for(i = 0; i < 127; i++)	 ffu.s[214+i] = sr4[i];
	break;
    }
}

void IWave::mas(int iwa)
{
    /* first spectral band of Modis airborne simulator */
    static const float sr1[35] = {
	.0244, .0338, .0536, .1052, .1941, .3166, .4797, .6893,
	.9417,1.2218,1.4890,1.7202,1.9194,2.0812,2.1934,2.2580,
	2.3031,2.3395,2.3620,2.3575,2.3228,2.2421,2.1129,1.9317,
	1.7031,1.4126,1.0985, .8088, .5573, .3477, .1843, .0918,
	.0473, .0308, .0248
    };

    /* second spectral band of Modis airborne simulator */
    static const float sr2[38] = {
	.0197, .0223, .0298, .0481, .0877, .1645, .2829, .4699,
	.7101, .9752,1.2209,1.4459,1.6307,1.7482,1.8092,1.8370,
	1.8465,1.8527,1.8574,1.8627,1.8703,1.8733,1.8763,1.8769,
	1.8731,1.8599,1.8221,1.7208,1.5341,1.2689, .9810, .6911,
	.4250, .2204, .0947, .0447, .0253, .0209
    };

    /* third spectral band of Modis airborne simulator */
    static const float sr3[34] = {
	.0273, .0357, .0560, .1265, .3269, .6239, .9777,1.3481,
	1.7037,2.0081,2.1885,2.2765,2.3178,2.3474,2.3777,2.4053,
	2.4286,2.4487,2.4604,2.4324,2.2594,1.9695,1.6105,1.2200,
	.8289, .4724, .2484, .1443, .0998, .0726, .0546, .0421,
	.0333, .0270
    };

    /* fourth spectral band of Modis airborne simulator */
    static const float sr4[40] = {
	.0242, .0276, .0364, .0505, .0717, .1058, .1841, .3889,
	.7570,1.1872,1.6245,1.9511,2.0986,2.1652,2.2058,2.2430,
	2.2471,2.2299,2.2190,2.2052,2.1875,2.1519,2.0989,2.0314,
	1.9292,1.7185,1.3603, .9476, .5555, .2803, .1608, .1090,
	.0926, .0830, .0720, .0590, .0476, .0377, .0300, .0245
    };

    /* fifth spectral band of Modis airborne simulator */

    static const float sr5[56] = {
	.0232, .0234, .0254, .0259, .0300, .0313, .0325, .0368,
	.0397, .0432, .0454, .0525, .0624, .0839, .1305, .2066,
	.3012, .4087, .5292, .6814, .8961,1.1607,1.4407,1.6803,
	1.8543,1.9683,2.0260,2.0562,2.0704,2.0550,2.0031,1.9304,
	1.8731,1.8325,1.7974,1.7334,1.6188,1.4710,1.2919,1.0871,
	.8785, .6871, .5194, .3728, .2565, .1667, .1099, .0720,
	.0536, .0434, .0375, .0355, .0324, .0281, .0251, .0214
    };

    
    /* sixth spectral band of Modis airborne simulator */
    static const float sr6[40] = {
	.0229, .0271, .0404, .0690, .1237, .2051, .3206, .4619,
	.6269, .8073,1.0025,1.2045,1.4075,1.5980,1.7690,1.9111,
	2.0102,2.0697,2.0965,2.1009,2.0903,2.0685,2.0262,1.9608,
	1.8675,1.7447,1.5974,1.4411,1.2742,1.0954, .9031, .7062,
	.5164, .3475, .2148, .1205, .0665, .0376, .0254, .0211
    };

    /* seventh spectral band of Modis airborne simulator */
    static const float sr7[117] = {
	.0075, .0087, .0108, .0133, .0168, .0208, .0257, .0312,
	.0379, .0456, .0540, .0629, .0728, .0828, .0937, .1054,
	.1189, .1329, .1478, .1618, .1729, .1845, .1963, .2095,
	.2206, .2326, .2448, .2578, .2714, .2864, .3033, .3192,
	.3349, .3515, .3724, .3922, .4100, .4291, .4477, .4674,
	.4824, .4992, .5197, .5436, .5681, .5908, .6099, .6204,
	.6284, .6393, .6466, .6466, .6488, .6531, .6575, .6612,
	.6572, .6566, .6577, .6602, .6649, .6595, .6568, .6522,
	.6606, .6656, .6606, .6517, .6426, .6374, .6311, .6217,
	.6053, .5933, .5827, .5672, .5483, .5325, .5241, .5121,
	.5077, .4958, .4827, .4718, .4552, .4369, .4200, .4076,
	.3921, .3730, .3550, .3397, .3224, .3045, .2849, .2622,
	.2426, .2223, .2035, .1830, .1628, .1416, .1211, .1033,
	.0871, .0731, .0606, .0491, .0395, .0315, .0245, .0189,
	.0151, .0117, .0093, .0076, .0070
    };
    
    /* third band of MODIS (469nm) soil and vegetation differences */
    static const float sr8[13] = {
	.0732, .8372,3.6403,4.9195,5.0091,5.0102,5.0102,5.0099,
	4.9670,4.0931,1.2880, .1186, .0237
    };

    /* fifth band of MODIS ( 1.24micron)  leaf and canopy properties */
    static const float sr9[25] = {
	.0094, .0143, .0248, .0457, .0902, .1928, .4494,1.1087,
	2.4282,3.6387,4.5556,4.9434,4.9975,4.9434,4.5556,3.6387,
	2.4282,1.1087, .4494, .1928, .0902, .0457, .0248, .0143,
	.0094
    };

    /* sixth band of MODIS ( 1.64microns) snow and cloud differences */
    static const float sr10[27] = {
	.0215, .0307, .0493, .0827, .1454, .2693, .5240,1.0412,
	1.9431,2.6724,3.3494,3.8269,4.0296,4.0624,4.0296,3.8269,
	3.3494,2.6724,1.9097,1.0412, .5240, .2693, .1454, .0827,
	.0493, .0307, .0215
    };

    static const float wli[10] = { 0.5025, 0.6075, 0.8300, 0.9000, 1.8200, 2.0950, 3.5800, 0.4550, 1.2100, 1.6075 };
    static const float wls[10] = { 0.5875, 0.7000, 0.9125, 0.9975, 1.9575, 2.1925, 3.8700, 0.4850, 1.2700, 1.6725 };

    ffu.wlinf = wli[iwa-1];
    ffu.wlsup = wls[iwa-1];

    int i;
    for(i = 0; i < 1501; i++) ffu.s[i] = 0; 

    switch(iwa)
    {
    case 1: for(i = 0; i < 35; i++)	 ffu.s[101+i] = sr1[i];
	break;
    case 2: for(i = 0; i < 38; i++)	 ffu.s[143+i] = sr2[i];
	break;
    case 3: for(i = 0; i < 34; i++)	 ffu.s[232+i] = sr3[i];
	break;
    case 4: for(i = 0; i < 40; i++)	 ffu.s[260+i] = sr4[i];
	break;
    case 5: for(i = 0; i < 56; i++)	 ffu.s[628+i] = sr5[i];
	break;
    case 6: for(i = 0; i < 40; i++)	 ffu.s[738+i] = sr6[i];
	break;
    case 7: for(i = 0; i < 117; i++)	 ffu.s[1332+i] = sr7[i];
	break;
    case 8: for(i = 0; i < 13; i++)	 ffu.s[82+i] = sr8[i];
	break;
    case 9: for(i = 0; i < 25; i++)	 ffu.s[384+i] = sr9[i];
	break;
    case 10: for(i = 0; i < 27; i++)	 ffu.s[543+i] = sr10[i];
	break;
    }
}

void IWave::modis(int iwa)
{
    /* band 1 of MODIS (vegetation monitoring at 250m) */
    static const float sr1[31] = {
	.0000, .0000, .0101, .0984, .2914, .5020, .6564, .6881,
	.7064, .7114, .7292, .7523, .7721, .7852, .8112, .8664,
	.9309, .9794,1.0000, .9855, .9333, .8429, .7187, .5672,
	.3996, .2327, .1024, .0369, .0157, .0092, .0000
    };

    /* band 2 of MODIS (vegetation monitoring at 250m) */
    static const float sr2[34] = {
	.0000, .0216, .0502, .0923, .1431, .1938, .2713, .4292,
	.6543, .8606, .9672, .9609, .9418, .9273, .9311, .9550,
	.9827, .9948,1.0000, .9782, .9308, .7860, .5430, .2931,
	.1477, .0824, .0520, .0367, .0276, .0213, .0159, .0112,
	.0076, .0000
    };

    /* band 3 of MODIS (vegetation monitoring at 500m / MVI) */
    static const float sr3[14] = {
	.0000, .0222, .2021, .7451,1.0141, .9036, .8745, .9242,
	1.0009, .9305, .5877, .1496, .0170, .0000
    };

    /* band 4 of MODIS (green channel at 500m ) */
    static const float sr4[13] = {
	.0286, .2645, .7583, .9889,1.0002, .9750, .9726, .9878,
	.9622, .7041, .2147, .0163, .0000
    };

    /* band 5 of MODIS (cloud channel at 500m ) */
    static const float sr5[23] = {
	.0000, .0188, .0381, .0984, .1872, .3188, .4933, .6582,
	.8046, .8877, .9564, .9973,1.0000, .9451, .8172, .6366,
	.3949, .2260, .1218, .0623, .0253, .0173, .0000
    };

    /* band 6 of MODIS (snow/ice channel at 500m ) */
    static const float sr6[27] = {
	.0000, .0580, .0910, .1611, .2705, .4289, .6049, .7688,
	.8948, .9729,1.0000, .9969, .9875, .9648, .9278, .8629,
	.7530, .6041, .4342, .2748, .1614, .0911, .0508, .0299,
	.0162, .0108, .0000
    };

    /* band 7 of MODIS (liquid water absorption channel at 500m ) */
    static const float sr7[51] = {
	.0000, .0124, .0165, .0229, .0317, .0444, .0630, .0918,
	.1358, .2006, .2904, .4032, .5329, .6632, .7775, .8680,
	.9308, .9700, .9913,1.0000,1.0009, .9961, .9866, .9715,
	.9498, .9209, .8851, .8446, .8022, .7614, .7241, .6860,
	.6423, .5915, .5326, .4637, .3846, .3042, .2317, .1698,
	.1195, .0814, .0553, .0381, .0266, .0189, .0137, .0097,
	.0056, .0001, .0000
    };

    static const float wli[7] = { 0.6100, 0.8200, 0.4500, 0.5400, 1.2150, 1.6000, 2.0575 };
    static const float wls[7] = { 0.6850, 0.9025, 0.4825, 0.5700, 1.2700, 1.6650, 2.1825 };

    ffu.wlinf = wli[iwa-1];
    ffu.wlsup = wls[iwa-1];

    int i;
    for(i = 0; i < 1501; i++) ffu.s[i] = 0; 

    switch(iwa)
    {
    case 1: for(i = 0; i < 31; i++)	 ffu.s[144+i] = sr1[i];
	break;
    case 2: for(i = 0; i < 34; i++)	 ffu.s[228+i] = sr2[i];
	break;
    case 3: for(i = 0; i < 14; i++)	 ffu.s[80+i] = sr3[i];
	break;
    case 4: for(i = 0; i < 13; i++)	 ffu.s[116+i] = sr4[i];
	break;
    case 5: for(i = 0; i < 23; i++)	 ffu.s[386+i] = sr5[i];
	break;
    case 6: for(i = 0; i < 27; i++)	 ffu.s[540+i] = sr6[i];
	break;
    case 7: for(i = 0; i < 51; i++)	 ffu.s[723+i] = sr7[i];
	break;
    }
}

void IWave::polder(int iwa)
{
    /* band 1 of POLDER (443 mic, polarized channel) */
    static const float sr1[27] = {
	.0003, .0042, .0028, .0036, .0060, .0134, .0430, .1284,
	.3394, .6162, .8056, .9060, .9656, .9968, .9880, .8944,

	.6612, .3880, .1950, .0966, .0512, .0292, .0180, .0122,
	.0040, .0000, .0000 
    };

    /* band 2 of POLDER (490 mic) */
    static const float sr2[46] = {
	.0000, .0000, .0000, .0000, .0000, .0000, .0000, .0000,
	.0000, .0000, .0000, .0000, .0000, .0000, .0000, .0000,
	.0000, .0000, .0000, .0000, .0012, .0014, .0022, .0032,
	.0060, .0116, .0252, .0666, .1932, .4896, .8104, .9414,
	.9544, .9710, .9898, .9544, .6920, .3438, .1466, .0630,
	.0304, .0170, .0102, .0070, .0000, .0000
    };

    /* band 3 of POLDER (565 mic) */
    static const float sr3[26] = {
	.0000, .0016, .0048, .0074, .0130, .0258, .0566, .1368,
	.3294, .6592, .9270, .9946, .9798, .9544, .9262, .8814,
	.7692, .5420, .2814, .1218, .0518, .0244, .0118, .0066,
	.0038, .0000
    };

    /* band 4 of POLDER (670 P1, polarized channel) */
    static const float sr4[30] = {
	.0000, .0000, .0000, .0000, .0010, .0044, .0022, .0140,
	.0176, .0394, .1004, .2476, .5462, .8672, .9902, .9874,
	.9572, .9484, .9264, .8274, .5688, .2828, .1154, .0500,
	.0224, .0186, .0160, .0072, .0000, .0000
    };

    /* band 5 of POLDER (763 mic, oxygen absorption channel) */
    static const float sr5[15] = {
	.0000, .0004, .0046, .0134, .0834, .4148, .8056, .9274,
	.9880, .7488, .2416, .0416, .0094, .0008, .0000
    };

    /* band 6 of POLDER (765 mic, oxygen absorption channel) */
    static const float sr6[53] = {
	.0000, .0000, .0010, .0018, .0010, .0030, .0046, .0080,
	.0096, .0140, .0202, .0300, .0410, .0622, .0958, .1516,
	.2400, .3648, .5174, .6640, .7798, .8494, .8858, .9066,
	.9202, .9374, .9516, .9692, .9886, .9932, .9650, .8684,
	.6836, .4686, .2922, .1724, .1012, .0594, .0360, .0238,
	.0144, .0104, .0088, .0060, .0052, .0046, .0038, .0052,
	.0028, .0022, .0000, .0000, .0000
    };

    /* band 7 of POLDER (865 P1, polarized channel) */
    static const float sr7[45] = {
	.0000, .0004, .0008, .0024, .0030, .0056, .0102, .0186,
	.0338, .0622, .1110, .1974, .3410, .5432, .7610, .9218,
	.9896, .9936, .9744, .9514, .9352, .9222, .9150, .9094,
	.8954, .8592, .7766, .6354, .4604, .3006, .1838, .1082,
	.0626, .0346, .0198, .0112, .0064, .0038, .0028, .0016,
	.0014, .0006, .0000, .0000, .0000
    };

    /* band 8 of POLDER (910 mic, water vapor absorption channel) */
    static const float sr8[31] = {
	.0000, .0000, .0000, .0012, .0016, .0018, .0032, .0046,
	.0082, .0158, .0354, .0876, .2242, .5142, .8436, .9848,
	.9838, .9534, .9254, .9084, .8560, .6444, .3388, .1424,
	.0566, .0238, .0098, .0000, .0000, .0000, .0000
    };

    static const float wli[8] = { 0.4125, 0.4100, 0.5325, 0.6300, 0.7450, 0.7000, 0.8100, 0.8650 };
    static const float wls[8] = { 0.4775, 0.5225, 0.5950, 0.7025, 0.7800, 0.8300, 0.9200, 0.9400 };

    ffu.wlinf = wli[iwa-1];
    ffu.wlsup = wls[iwa-1];

    int i;
    for(i = 0; i < 1501; i++) ffu.s[i] = 0; 

    switch(iwa)
    {
    case 1: for(i = 0; i < 27; i++)	 ffu.s[65+i] = sr1[i];
	break;
    case 2: for(i = 0; i < 46; i++)	 ffu.s[64+i] = sr2[i];
	break;
    case 3: for(i = 0; i < 26; i++)	 ffu.s[113+i] = sr3[i];
	break;
    case 4: for(i = 0; i < 30; i++)	 ffu.s[152+i] = sr4[i];
	break;
    case 5: for(i = 0; i < 15; i++)	 ffu.s[198+i] = sr5[i];
	break;
    case 6: for(i = 0; i < 53; i++)	 ffu.s[180+i] = sr6[i];
	break;
    case 7: for(i = 0; i < 45; i++)	 ffu.s[224+i] = sr7[i];
	break;
    case 8: for(i = 0; i < 31; i++)	 ffu.s[246+i] = sr8[i];
	break;
    }
}

void IWave::etmplus(int iwa)
{
    /* Spectral filter data found on the following page:
       http://ltpwww.gsfc.nasa.gov/IAS/handbook/handbook_toc.html
    */
    /* 1st spectral band of enhanced thematic mapper plus */
    static const float sr1[35] = {
	.0160, .0710, .2870, .6665, .7920, .8570, .8390, .8060,
	.7790, .8460, .9010, .8995, .8900, .8510, .8750, .8930,
	.8840, .9300, .9580, .9540, .9800, .9750, .9650, .9625,
	.9950, .9900, .9900, .9795, .9830, .9685, .9600, .7685,
	.2930, .0545, .0090
    };

    /* 2nd spectral band of enhanced thematic mapper plus */
    static const float sr2[50] = {
	.0006, .0015, .0030, .0117, .0260, .0740, .1740, .3480,
	.5520, .6960, .7590, .7845, .8220, .8695, .9050, .9285,
	.9470, .9525, .9520, .9515, .9530, .9500, .9540, .9670,
	.9590, .9405, .9330, .9385, .9510, .9565, .9550, .9560,
	.9730, .9915,1.0000, .9760, .9420, .9300, .9120, .7985,
	.5740, .3400, .1850, .1055, .0620, .0375, .0210, .0109,
	.0048, .0021
    };

    /* 3rd spectral band of enhanced thematic mapper plus */
    static const float sr3[36] = {
	.0001, .0006, .0020, .0095, .0470, .1740, .4190, .7310,
	.9210, .9425, .9370, .9365, .9490, .9645, .9730, .9705,
	.9580, .9550, .9620, .9800, .9930, .9980,1.0000, .9955,
	.9920, .9885, .9770, .9545, .9320, .8805, .7290, .4440,
	.1830, .0660, .0250, .0121
    };

    /* 4th spectral band of enhanced thematic mapper plus */
    static const float sr4[70] = {
	.0004, .0021, .0037, .0024, .0010, .0199, .0315, .0518,
	.0690, .1100, .1750, .2710, .4020, .5555, .7050, .8120,
	.8710, .8955, .9080, .9180, .9260, .9280, .9300, .9255,
	.9250, .9280, .9230, .9165, .9080, .9035, .9090, .9240,
	.9460, .9655, .9710, .9690, .9670, .9655, .9670, .9605,
	.9490, .9310, .9250, .9295, .9430, .9610, .9850, .9925,
	.9980, .9915, .9940, .9970, .9980, .9995, .9910, .9880,
	.9690, .9265, .8680, .8175, .8190, .8800, .8540, .5725,
	.2560, .1035, .0440, .0220, .0110, .0071

    };

    /* 5th spectral band of enhanced thematic mapper plus */
    static const float sr5[116] = {
	.0015, .0000, .0010, .0112, .0120, .0060, .0135, .0210,
	.0400, .0530, .0760, .1028, .1480, .2052, .2740, .3660,
	.4620, .5137, .5780, .6250, .6670, .7090, .7370, .7710,
	.8080, .8315, .8590, .8750, .8930, .9013, .8960, .8953,
	.8945, .8878, .8760, .8685, .8725, .8773, .8740, .8605,
	.8680, .8785, .8990, .8940, .9000, .9020, .9190, .9248,
	.9290, .9455, .9475, .9533, .9520, .9668, .9610, .9598,
	.9780, .9587, .9535, .9513, .9517, .9550, .9440, .9345,
	.9305, .9385, .9480, .9398, .9385, .9470, .9450, .9450,
	.9553, .9648, .9690, .9733, .9910, .9960, .9975, .9945,
	1.0000, .9913, .9865, .9885, .9895, .9875, .9810, .9812,
	.9780, .9685, .9600, .9383, .9020, .8545, .7910, .6928,
	.6077, .5257, .4275, .3420, .2670, .2028, .1585, .1187,
	.0840, .0723, .0535, .0437, .0390, .0305, .0205, .0217,
	.0110, .0100, .0060, .0020
    };

    /* 7th spectral band of enhanced thematic mapper plus */
    static const float sr6[147] = {
	.0020, .0020, .0120, .0085, .0090, .0177, .0170, .0313,
	.0370, .0458, .0580, .0762, .0880, .1097, .1490, .1960,
	.2420, .3030, .3670, .4368, .5190, .6100, .6765, .7182,
	.7560, .7738, .7840, .7755, .7890, .7817, .7780, .7665,
	.7615, .7680, .7750, .7690, .7880, .8085, .7940, .8230,
	.8115, .8195, .8365, .8370, .8360, .8513, .8585, .8553,
	.8710, .8735, .8750, .8590, .8715, .8593, .8720, .8625,
	.8650, .8680, .8765, .8730, .8690, .8760, .8680, .8793,
	.8735, .8760, .8800, .8745, .8700, .8578, .8630, .8585,
	.8440, .8585, .8545, .8625, .8680, .8560, .8470, .8613,
	.8510, .8520, .8380, .8465, .8403, .8305, .8355, .8382,
	.8220, .8380, .8385, .8425, .8535, .8623, .8730, .8680,
	.8790, .8908, .8980, .9195, .9200, .9263, .9275, .9340,
	.9360, .9533, .9540, .9518, .9600, .9728, .9850, .9720,
	.9700, .9938, .9895, .9748,1.0000, .9912, .9680, .9658,
	.9555, .9295, .9290, .9255, .9030, .9235, .9290, .9285,
	.9200, .8533, .7750, .6587, .5315, .4035, .2750, .2175,
	.1310, .1035, .0750, .0518, .0290, .0280, .0135, .0193,
	.0130, .0065, .0150
    };

    /* 8th spectral band of enhanced thematic mapper plus (Pan) */
    static const float sr7[164] = {
	.0028, .0175, .0563, .1500, .3285, .5015, .5845, .5990,
	.6018, .6095, .6143, .6100, .6035, .6035, .6118, .6270,
	.6385, .6445, .6438, .6320, .6260, .6245, .6320, .6420,
	.6593, .6775, .6898, .6970, .7005, .7050, .7110, .7130,
	.7165, .7180, .7120, .7070, .7040, .7030, .7148, .7300,
	.7440, .7535, .7615, .7640, .7533, .7450, .7353, .7290,
	.7285, .7310, .7328, .7340, .7435, .7495, .7540, .7580,
	.7618, .7680, .7720, .7790, .7815, .7850, .7900, .7930,
	.7918, .7915, .7950, .7980, .8018, .8060, .8133, .8200,
	.8275, .8315, .8370, .8420, .8485, .8545, .8605, .8680,
	.8723, .8795, .8853, .8920, .8945, .8960, .8945, .8940,
	.8943, .8955, .8975, .9000, .9033, .9035, .9023, .9000,
	.8968, .8935, .8828, .8790, .8783, .8730, .8760, .8800,
	.8813, .8865, .8910, .8930, .9035, .9105, .9183, .9200,
	.9175, .9160, .9183, .9180, .9168, .9155, .9173, .9270,
	.9290, .9375, .9497, .9570, .9638, .9695, .9715, .9770,
	.9795, .9840, .9908, .9970, .9985, .9980, .9953, .9940,
	.9920, .9930, .9925, .9870, .9755, .9650, .9583, .9490,
	.9348, .9240, .9133, .9070, .9053, .9085, .9193, .9400,
	.9658, .9780, .9625, .8950, .7520, .5715, .3962, .2580,
	.1675, .1080, .0687, .0440
    };

    static const float wli[7] = { 0.4350, 0.5000, 0.6150, 0.7400, 1.5050, 2.0150, 0.5025 };
    static const float wls[7] = { 0.5200, 0.6225, 0.7025, 0.9125, 1.7925, 2.3800, 0.9100 };

    ffu.wlinf = wli[iwa-1];
    ffu.wlsup = wls[iwa-1];

    int i;
    for(i = 0; i < 1501; i++) ffu.s[i] = 0; 

    switch(iwa)
    {
    case 1: for(i = 0; i < 35; i++)	 ffu.s[74+i] = sr1[i];
	break;
    case 2: for(i = 0; i < 50; i++)	 ffu.s[100+i] = sr2[i];
	break;
    case 3: for(i = 0; i < 36; i++)	 ffu.s[146+i] = sr3[i];
	break;
    case 4: for(i = 0; i < 70; i++)	 ffu.s[196+i] = sr4[i];
	break;
    case 5: for(i = 0; i < 116; i++)	 ffu.s[502+i] = sr5[i];
	break;
    case 6: for(i = 0; i < 147; i++)	 ffu.s[706+i] = sr6[i];
	break;
    case 7: for(i = 0; i < 164; i++)	 ffu.s[101+i] = sr7[i];
    }
}

float IWave::solirr(const float wl) const
{
/*    si (in w/m2/micron) contains the values of the solar
      irradiance between 0.25 and 4.0 microns, by step of 0.0025 m.
      the value of the total irradiance is 1372 w/m2 on the whole
      spectrum (1358 w/m2 between 0.25 and 4.0 microns) */

    static const float si[1501] = {
        69.30,  77.65,  86.00, 100.06, 114.12, 137.06, 160.00,
	169.52, 179.04, 178.02, 177.00, 193.69, 210.38, 241.69,
	273.00, 318.42, 363.84, 434.42, 505.00, 531.50, 558.00,
	547.50, 537.00, 559.02, 581.03, 619.52, 658.00, 694.39,
	730.78, 774.39, 817.99, 871.99, 925.99, 912.04, 898.09,
	920.69, 943.29, 925.99, 908.69, 936.09, 963.49, 994.94,
	1026.39, 980.74, 935.09,1036.29,1137.49,1163.74,1189.99,
	1109.34,1028.69,1088.99,1149.29,1033.69, 918.09,1031.89,
	1145.69,1035.09, 924.49,1269.29,1614.09,1631.09,1648.09,
	1677.19,1706.29,1744.89,1783.49,1750.19,1716.89,1705.19,
	1693.49,1597.69,1501.89,1630.99,1760.09,1775.24,1790.39,
	1859.94,1929.49,1993.44,2057.39,2039.23,2021.08,2030.73,
	2040.38,2026.53,2012.68,1999.53,1986.38,2002.88,2019.38,
	2038.09,2056.79,1967.74,1878.68,1905.83,1932.98,1953.58,
	1974.18,1935.68,1897.19,1916.78,1936.38,1937.23,1938.09,
	1881.44,1824.79,1814.09,1803.39,1832.24,1861.09,1885.93,
	1910.78,1904.68,1898.58,1875.73,1852.88,1865.64,1878.39,
	1874.74,1871.09,1872.44,1873.79,1850.39,1826.99,1837.04,
	1847.09,1841.18,1835.28,1849.48,1863.69,1851.03,1838.38,
	1840.73,1843.08,1802.83,1762.58,1778.78,1794.99,1777.48,
	1759.98,1764.73,1769.49,1753.48,1737.48,1713.14,1688.80,
	1702.88,1716.97,1696.07,1675.17,1672.03,1668.89,1663.56,
	1658.23,1647.75,1637.27,1630.02,1622.77,1606.06,1589.36,
	1552.29,1515.22,1528.91,1542.60,1548.90,1555.21,1544.41,
	1533.62,1525.24,1516.86,1507.92,1498.98,1484.07,1469.17,
	1464.28,1459.39,1448.73,1438.08,1423.16,1408.24,1407.53,
	1406.82,1397.82,1388.82,1378.51,1368.21,1352.13,1336.05,
	1343.88,1351.71,1339.60,1327.50,1320.72,1313.94,1294.94,
	1275.94,1280.92,1285.90,1278.04,1270.19,1263.68,1257.18,
	1249.80,1242.41,1231.30,1220.19,1212.14,1204.10,1201.69,
	1199.29,1194.78,1190.27,1185.47,1180.68,1174.38,1168.09,
	1156.17,1144.26,1143.46,1142.67,1132.95,1123.23,1116.71,
	1110.19,1110.89,1111.59,1094.80,1078.01,1077.75,1077.49,
	1073.89,1070.29,1058.71,1047.13,1045.66,1044.20,1037.03,
	1029.86,1010.40, 990.94, 966.91, 942.89, 972.87,1002.86,
	978.93, 955.00, 960.95, 966.91, 983.31, 999.71, 991.91,
	984.11, 979.05, 973.99, 968.79, 963.60, 958.23, 952.87,
	947.93, 942.99, 937.99, 933.00, 928.00, 923.00, 918.18,
	913.37, 908.74, 904.11, 899.05, 893.99, 889.18, 884.37,
	879.74, 875.12, 870.24, 865.36, 860.94, 856.53, 852.02,
	847.50, 843.00, 838.50, 833.99, 829.49, 824.98, 820.48,
	815.99, 811.50, 806.99, 802.49, 798.17, 793.86, 789.74,
	785.63, 781.25, 776.87, 772.92, 768.98, 764.80, 760.63,
	756.06, 751.49, 746.99, 742.49, 738.18, 733.88, 729.76,
	725.63, 721.24, 716.86, 712.92, 708.99, 704.81, 700.63,
	696.25, 691.87, 687.94, 684.01, 680.01, 676.00, 671.80,
	667.61, 663.23, 658.86, 655.32, 651.77, 649.07, 646.37,
	643.74, 641.11, 638.05, 634.99, 632.18, 629.37, 626.74,
	624.12, 621.06, 618.00, 615.18, 612.37, 609.92, 607.48,
	604.79, 602.11, 599.24, 596.38, 593.93, 591.48, 588.79,
	586.11, 583.25, 580.40, 577.94, 575.48, 572.99, 570.51,
	568.00, 565.49, 562.98, 560.47, 557.98, 555.50, 553.01,
	550.51, 548.00, 545.49, 542.98, 540.48, 537.98, 535.49,
	533.19, 530.90, 528.94, 526.99, 524.80, 522.62, 520.24,
	517.87, 515.44, 513.01, 509.59, 506.17, 502.89, 499.62,
	496.35, 493.09, 489.81, 486.54, 483.27, 480.01, 476.73,
	473.46, 470.19, 466.92, 463.64, 460.37, 457.10, 453.84,
	450.57, 447.30, 444.03, 440.76, 437.48, 434.21, 430.94,
	427.67, 424.40, 421.13, 417.86, 414.59, 411.32, 408.05,
	404.78, 401.51, 398.24, 394.97, 391.70, 388.43, 392.57,
	396.71, 401.92, 407.14, 405.32, 403.50, 401.67, 399.84,
	398.02, 396.21, 394.37, 392.54, 390.72, 388.90, 387.06,
	385.23, 383.42, 381.60, 379.77, 377.95, 376.12, 374.30,
	372.48, 370.66, 368.82, 366.99, 365.17, 363.35, 361.52,
	359.69, 357.87, 356.05, 354.22, 352.39, 350.57, 348.75,
	346.92, 345.10, 343.27, 341.45, 341.84, 342.24, 342.95,
	343.66, 342.27, 340.89, 339.49, 338.09, 336.69, 335.30,
	333.91, 332.53, 331.13, 329.73, 328.34, 326.96, 325.56,
	324.16, 322.77, 321.39, 319.99, 318.59, 317.20, 315.82,
	314.42, 313.03, 311.63, 310.24, 308.85, 307.46, 306.06,
	304.66, 303.28, 301.90, 300.50, 299.10, 297.71, 296.32,
	294.93, 293.54, 293.41, 293.28, 293.35, 293.42, 292.26,
	291.10, 289.97, 288.84, 287.69, 286.54, 285.39, 284.25,
	283.10, 281.96, 280.81, 279.67, 278.52, 277.38, 276.23,
	275.08, 273.94, 272.80, 271.65, 270.51, 269.36, 268.22,
	267.07, 265.93, 264.78, 263.64, 262.49, 261.34, 260.20,
	259.06, 257.91, 256.77, 255.62, 254.47, 253.33, 252.20,
	251.16, 250.13, 249.11, 248.09, 246.97, 245.86, 244.74,
	243.61, 242.49, 241.37, 240.24, 239.12, 238.00, 236.89,
	235.76, 234.64, 233.51, 232.38, 231.26, 230.13, 229.01,
	227.90, 226.77, 225.65, 224.53, 223.42, 222.29, 221.16,
	220.04, 218.92, 217.80, 216.68, 215.55, 214.43, 213.30,
	212.18, 211.06, 209.94, 208.82, 207.69, 206.99, 206.29,
	205.65, 205.02, 203.98, 202.95, 201.90, 200.85, 199.81,
	198.78, 197.74, 196.70, 195.65, 194.61, 193.57, 192.54,
	191.50, 190.47, 189.42, 188.37, 187.33, 186.30, 185.26,
	184.22, 183.18, 182.14, 181.10, 180.06, 179.02, 177.98,
	176.93, 175.89, 174.86, 173.83, 172.78, 171.73, 170.70,
	169.67, 168.62, 167.57, 167.59, 167.60, 167.76, 167.93,
	167.09, 166.26, 165.42, 164.58, 163.75, 162.92, 162.08,
	161.25, 160.41, 159.58, 158.74, 157.91, 157.07, 156.24,
	155.40, 154.57, 153.73, 152.90, 152.06, 151.23, 150.39,
	149.56, 148.72, 147.89, 147.06, 146.23, 145.39, 144.55,
	143.71, 142.88, 142.05, 141.22, 140.38, 139.54, 138.70,
	137.86, 137.99, 138.11, 138.36, 138.60, 137.94, 137.29,
	136.64, 136.00, 135.35, 134.71, 134.05, 133.39, 132.74,
	132.09, 131.45, 130.81, 130.15, 129.49, 128.84, 128.20,
	127.55, 126.90, 126.25, 125.60, 124.94, 124.29, 123.64,
	123.00, 122.35, 121.70, 121.05, 120.40, 119.74, 119.09,
	118.45, 117.81, 117.15, 116.50, 115.85, 115.19, 115.25,
	115.31, 115.46, 115.62, 115.11, 114.60, 114.09, 113.58,
	113.06, 112.54, 112.03, 111.53, 111.01, 110.50, 109.99,
	109.47, 108.95, 108.44, 107.93, 107.42, 106.92, 106.42,
	105.89, 105.37, 104.85, 104.34, 103.83, 103.33, 102.81,
	102.29, 101.79, 101.29, 100.77, 100.25,  99.74,  99.22,
        98.71,  98.20,  97.69,  97.18,  97.12,  97.07,  97.09,
        97.11,  96.68,  96.26,  95.84,  95.42,  94.99,  94.56,
        94.14,  93.72,  93.31,  92.89,  92.46,  92.03,  91.61,
        91.19,  90.76,  90.34,  89.92,  89.49,  89.07,  88.66,
        88.24,  87.81,  87.39,  86.97,  86.55,  86.12,  85.69,
        85.26,  84.85,  84.43,  84.01,  83.59,  83.17,  82.75,
        82.32,  81.89,  81.89,  81.89,  81.95,  82.02,  81.68,
        81.35,  81.00,  80.65,  80.32,  79.99,  79.64,  79.30,
        78.96,  78.61,  78.27,  77.94,  77.60,  77.26,  76.91,
        76.57,  76.24,  75.90,  75.56,  75.22,  74.88,  74.54,
        74.20,  73.86,  73.52,  73.18,  72.84,  72.50,  72.16,
        71.82,  71.48,  71.14,  70.80,  70.47,  70.13,  69.79,
        69.76,  69.73,  69.76,  69.80,  69.52,  69.24,  68.96,
        68.68,  68.41,  68.14,  67.85,  67.57,  67.29,  67.02,
        66.75,  66.48,  66.19,  65.90,  65.63,  65.36,  65.08,
        64.80,  64.53,  64.25,  63.97,  63.69,  63.41,  63.14,
        62.85,  62.57,  62.30,  62.03,  61.75,  61.47,  61.19,
        60.92,  60.64,  60.36,  60.08,  59.81,  59.80,  59.80,
        59.82,  59.85,  59.63,  59.40,  59.17,  58.95,  58.73,
        58.50,  58.28,  58.06,  57.83,  57.60,  57.37,  57.15,
        56.93,  56.70,  56.48,  56.26,  56.03,  55.79,  55.57,
        55.36,  55.13,  54.90,  54.66,  54.43,  54.22,  54.00,
        53.77,  53.55,  53.32,  53.09,  52.87,  52.65,  52.43,
        52.20,  51.97,  51.75,  51.72,  51.68,  51.67,  51.67,
        51.48,  51.30,  51.11,  50.92,  50.73,  50.55,  50.37,
        50.18,  49.98,  49.79,  49.61,  49.43,  49.23,  49.04,
        48.85,  48.67,  48.48,  48.30,  48.12,  47.93,  47.73,
        47.54,  47.36,  47.18,  46.98,  46.79,  46.60,  46.42,
        46.24,  46.06,  45.87,  45.67,  45.48,  45.30,  45.12,
        44.93,  44.87,  44.82,  44.80,  44.79,  44.62,  44.45,
        44.29,  44.14,  43.98,  43.83,  43.66,  43.49,  43.34,
        43.18,  43.02,  42.86,  42.70,  42.55,  42.38,  42.21,
        42.06,  41.90,  41.74,  41.58,  41.42,  41.26,  41.10,
        40.94,  40.78,  40.62,  40.46,  40.31,  40.14,  39.97,
        39.81,  39.66,  39.50,  39.34,  39.18,  39.03,  38.99,
        38.96,  38.94,  38.92,  38.79,  38.66,  38.52,  38.38,
        38.25,  38.12,  37.99,  37.86,  37.72,  37.58,  37.44,
        37.30,  37.17,  37.05,  36.91,  36.77,  36.64,  36.50,
        36.36,  36.23,  36.09,  35.96,  35.82,  35.69,  35.55,
        35.42,  35.28,  35.15,  35.01,  34.88,  34.75,  34.61,
        34.47,  34.34,  34.20,  34.07,  34.05,  34.03,  34.03,
        34.03,  33.91,  33.79,  33.68,  33.57,  33.46,  33.35,
        33.23,  33.12,  33.01,  32.90,  32.78,  32.67,  32.55,
        32.44,  32.33,  32.23,  32.11,  32.00,  31.89,  31.77,
        31.66,  31.55,  31.43,  31.31,  31.20,  31.10,  30.99,
        30.87,  30.76,  30.66,  30.54,  30.42,  30.31,  30.20,
        30.08,  29.97,  29.93,  29.90,  29.88,  29.87,  29.76,
        29.66,  29.56,  29.46,  29.36,  29.27,  29.17,  29.08,
        28.98,  28.88,  28.77,  28.67,  28.58,  28.49,  28.39,
        28.30,  28.20,  28.10,  28.00,  27.91,  27.81,  27.71,
        27.61,  27.52,  27.41,  27.31,  27.21,  27.12,  27.03,
        26.93,  26.83,  26.74,  26.64,  26.54,  26.44,  26.35,
        26.33,  26.31,  26.29,  26.28,  26.20,  26.12,  26.04,
        25.95,  25.87,  25.79,  25.71,  25.64,  25.54,  25.45,
        25.37,  25.30,  25.21,  25.12,  25.05,  24.98,  24.89,
        24.80,  24.71,  24.63,  24.55,  24.47,  24.39,  24.31,
        24.22,  24.14,  24.05,  23.97,  23.89,  23.81,  23.73,
        23.66,  23.56,  23.47,  23.39,  23.31,  23.28,  23.26,
        23.23,  23.21,  23.13,  23.06,  22.99,  22.92,  22.84,
        22.76,  22.69,  22.63,  22.55,  22.47,  22.41,  22.35,
        22.27,  22.19,  22.11,  22.04,  21.97,  21.90,  21.83,
        21.76,  21.68,  21.60,  21.53,  21.47,  21.39,  21.31,
        21.24,  21.18,  21.11,  21.03,  20.96,  20.89,  20.81,
        20.73,  20.66,  20.60,  20.57,  20.55,  20.54,  20.53,
        20.46,  20.40,  20.34,  20.28,  20.21,  20.14,  20.08,
        20.03,  19.96,  19.90,  19.83,  19.77,  19.71,  19.65,
        19.59,  19.53,  19.46,  19.39,  19.33,  19.27,  19.21,
        19.15,  19.08,  19.02,  18.96,  18.90,  18.84,  18.78,
        18.71,  18.64,  18.58,  18.53,  18.46,  18.40,  18.33,
        18.27,  18.26,  18.25,  18.24,  18.24,  18.19,  18.14,
        18.08,  18.03,  17.98,  17.93,  17.88,  17.83,  17.77,
        17.71,  17.66,  17.62,  17.56,  17.50,  17.45,  17.41,
        17.35,  17.29,  17.25,  17.21,  17.14,  17.08,  17.04,
        17.00,  16.93,  16.87,  16.83,  16.79,  16.72,  16.66,
        16.61,  16.57,  16.51,  16.46,  16.41,  16.36,  16.34,
        16.33,  16.31,  16.30,  16.26,  16.22,  16.17,  16.13,
        16.08,  16.04,  16.00,  15.96,  15.90,  15.84,  15.81,
        15.78,  15.73,  15.68,  15.63,  15.59,  15.55,  15.50,
        15.45,  15.40,  15.36,  15.32,  15.28,  15.24,  15.18,
        15.13,  15.09,  15.05,  15.01,  14.96,  14.91,  14.87,
        14.82,  14.78,  14.73,  14.69,  14.66,  14.64,  14.64,
        14.63,  14.59,  14.55,  14.50,  14.45,  14.41,  14.38,
        14.35,  14.32,  14.26,  14.21,  14.18,  14.15,  14.10,
        14.05,  14.01,  13.98,  13.94,  13.91,  13.86,  13.82,
        13.78,  13.74,  13.70,  13.67,  13.62,  13.58,  13.54,
        13.50,  13.46,  13.43,  13.39,  13.35,  13.30,  13.25,
        13.22,  13.18,  13.17,  13.16,  13.14,  13.12,  13.09,
        13.06,  13.03,  13.00,  12.96,  12.92,  12.89,  12.85,
        12.81,  12.78,  12.74,  12.70,  12.67,  12.65,  12.61,
        12.57,  12.53,  12.50,  12.46,  12.43,  12.39,  12.36,
        12.32,  12.28,  12.25,  12.22,  12.18,  12.15,  12.11,
        12.07,  12.04,  12.01,  11.97,  11.94,  11.90,  11.86,
        11.85,  11.85,  11.85,  11.84,  11.81,  11.78,  11.75,
        11.72,  11.69,  11.66,  11.63,  11.60,  11.58,  11.55,
        11.51,  11.47,  11.45,  11.42,  11.39,  11.36,  11.33,
        11.30,  11.27,  11.24,  11.21,  11.18,  11.15,  11.12,
        11.09,  11.06,  11.03,  11.00,  10.97,  10.94,  10.91,
        10.89,  10.85,  10.82,  10.78,  10.75,  10.73,  10.72,
        10.71,  10.70,  10.67,  10.64,  10.62,  10.59,  10.55,
        10.52,  10.50,  10.47,  10.44,  10.42,  10.39,  10.37,
        10.34,  10.31,  10.28,  10.25,  10.22,  10.20,  10.17,
        10.15,  10.12,  10.10,  10.06,  10.03,  10.00,   9.98,
	9.95,   9.92,   9.89,   9.86,   9.84,   9.82,   9.79,
	9.75,   9.73,   9.71,   9.70,   9.70,   9.70,   9.70,
	9.67,   9.63,   9.61,   9.59,   9.58,   9.56,   9.53,
	9.50,   9.48,   9.45,   9.43,   9.41,   9.39,   9.36,
	9.34,   9.32,   9.30,   9.27,   9.24,   9.22,   9.20,
	9.18,   9.15,   9.13,   9.11,   9.08,   9.06,   9.05,
	9.02,   8.99,   8.96,   8.94,   8.92,   8.90,   8.87,
	8.85,   8.83,   8.81
    };

    float pas = 0.0025;
    int   iwl = (int)((wl - 0.250) / pas + 1.5);
	  
    if(iwl >= 0) return si[iwl-1];

    cout << " wavelength  less  than  0.25  micron: " << endl << " let's take s(l)=s(0.25)" << endl;
    return si[0];
}

void IWave::irs_1c_liss(int iwa)
{
    /* 2nd spectral band of IRS 1C LISS III */
    static const float sr2[61] = {
	.0006, .0009, .0012, .0020, .0036, .0080, .0216, .0655,
	.1690, .3080, .4280, .5600, .7010, .7600, .7640, .7690,
	.7960, .8400, .8760, .8820, .8670, .8560, .8620, .8890,
	.9240, .9480, .9590, .9540, .9460, .9490, .9660, .9860,
	1.0000,.9960, .9740, .9490, .9340, .9340, .9340, .9210,
	.8820, .8300, .7880, .7770, .7670, .6640, .4190, .1980,
	.0882, .0396, .0192, .0107, .0066, .0041, .0026, .0018,
	.0012, .0010, .0007, .0006
    };

    /* 3rd spectral band of IRS 1C LISS III */
    static const float sr3[45] = { 
	.0041, .0110, .0357, .1310, .4020, .7200, .8300, .8700,
	.8980, .9120, .9230, .9300, .9320, .9310, .9270, .9300,
	.9390, .9510, .9580, .9600, .9630, .9700, .9890,1.0000,
	.9880, .9390, .8740, .8220, .8040, .8350, .9000, .9620,
	.9730, .9410, .9170, .8790, .6460, .2940, .1050, .0390,
	.0105, .0040, .0020, .0010, .0000
    };

    /* 4th spectral band of IRS 1C LISS III */
    static const float sr4[65] = {  
	.0090, .0149, .0244, .0400, .0649, .1020, .1520, .2170,
	.2940, .3820, .4830, .6120, .7270, .8320, .9180, .9760,
	1.0000,.9970, .9800, .9590, .9410, .9330, .9330, .9390,
	.9480, .9550, .9620, .9580, .9500, .9380, .9270, .9150,
	.9100, .9050, .9050, .9020, .8970, .8900, .8830, .8740,
	.8690, .8700, .8720, .8740, .8680, .8490, .8150, .7720,
	.7310, .6990, .6840, .6800, .6640, .5750, .4060, .2280,
	.1240, .0641, .0356, .0206, .0126, .0080, .0052, .0035,
	.0025
    };
	 
    /* 5th spectral band of IRS 1C LISS III */
    static const float sr5[155] = { 
	.0000, .0000, .0000, .0000, .0001, .0001, .0001, .0001,
	.0000, .0001, .0001, .0021, .0001, .0000, .0001, .0001,
	.0001, .0001, .0001, .0002, .0002, .0002, .0001, .0005,
	.0004, .0006, .0007, .0010, .0011, .0015, .0020, .0024,
	.0030, .0039, .0051, .0068, .0088, .0114, .0153, .0206,
	.0281, .0372, .0515, .0708, .0983, .1370, .1870, .2580,
	.3470, .4410, .5340, .6190, .6920, .7510, .7940, .8270,
	.8500, .8680, .8800, .8920, .9010, .9090, .9170, .9250,
	.9310, .9400, .9490, .9590, .9700, .9760, .9850, .9920,
	.9960,1.0000,1.0000, .9960, .9910, .9860, .9790, .9730,
	.9680, .9660, .9620, .9640, .9670, .9700, .9750, .9810,
	.9850, .9880, .9840, .9770, .9690, .9560, .9400, .9240,
	.9080, .8880, .8710, .8570, .8410, .8300, .8220, .8180,
	.8170, .8220, .8290, .8370, .8460, .8550, .8450, .8310,
	.8110, .7870, .7580, .7180, .6780, .6380, .5990, .5640,
	.5280, .4930, .4590, .4210, .3770, .3320, .2770, .2160,
	.1580, .1110, .0772, .0528, .0357, .0242, .0165, .0117,
	.0083, .0059, .0042, .0031, .0023, .0017, .0013, .0009,
	.0007, .0005, .0004, .0002, .0002, .0001, .0001, .0001,
	.0001, .0000, .0000
    };

    static const float wli[4] = { 0.502, 0.612, 0.752, 1.452 };
    static const float wls[4] = { 0.620, 0.700, 0.880, 1.760 };

    ffu.wlinf = wli[iwa-1];
    ffu.wlsup = wls[iwa-1];

    int i;
    for(i = 0; i < 1501; i++) ffu.s[i] = 0; 

    switch(iwa)
    {
    case 1: for(i = 0; i < 61; i++)	 ffu.s[101+i] = sr2[i];
	break;
    case 2: for(i = 0; i < 45; i++)	 ffu.s[145+i] = sr3[i];
	break;
    case 3: for(i = 0; i < 65; i++)	 ffu.s[201+i] = sr4[i];
	break;
    case 4: for(i = 0; i < 155; i++)	 ffu.s[481+i] = sr5[i];
	break;
    }
}

void IWave::aster(int iwa)
{
    /* Spectral filter data found on the following page:
	 http://www.science.aster.ersdac.or.jp/en/about_aster/sensor/
	 */
    /* Band 1 of Aster; Central Wavelength = 556nm */
    static const float sr1[67] = {
		.0000, .0054, .0073, .0078, .0076, .0074, .0093, .0217,
		.0580, .0947, .1566, .2694, .3712, .4813, .6204, .7414,
		.8392, .9077, .9552, .9878, .9973, .9992, .9781, .9373,
		.8900, .8784, .8786, .8941, .8993, .9049, .9231, .9238,
		.9184, .9301, .9423, .9493, .9522, .9548, .9598, .9593,
		.9528, .9256, .8967, .8748, .8265, .7625, .7065, .6282,
		.5206, .3775, .2535, .1629, .1168, .0859, .0593, .0451,
		.0355, .0174, .0078, .0049, .0040, .0038, .0053, .0052,
		.0037, .0023, .0000
    };
	
    /* Band 2 of Aster; Central Wavelength = 659nm  */
    static const float sr2[59] = {
		.0000, .0038, .0034, .0008, .0008, .0024, .0029, .0006,
		.0047, .0050, .0033, .0049, .0126, .0000, .1220, .2738,
		.4703, .6723, .8350, .9709, .9990, .9835, .9715, .9710,
		.9734, .9430, .9095, .9305, .9418, .9386, .9202, .9100,
		.8973, .8606, .8195, .7986, .7889, .7702, .7538, .6961,
		.6087, .5186, .4523, .4258, .3811, .3244, .2591, .1854,
		.1121, .0623, .0469, .0334, .0181, .0112, .0010, .0054,
		.0044, .0017, .0000
    };
	
    /* Band 3N (N=Nadir pointing) of Aster; Central Wavelength = 807nm  */
    static const float sr3[77] = {
		.0000, .0017, .0078, .0167, .0285, .0447, .0492, .0509,
		.0744, .1160, .1768, .2527, .3625, .5534, .8008,1.0000,
		.9903, .9613, .9012, .9032, .9197, .9655, .9868, .9942,
		.9857, .9745, .9648, .9465, .9368, .9634, .9760, .9820,
		.9938, .9968, .9908, .9810, .9756, .9855, .9832, .9694,
		.9587, .9527, .9499, .9357, .9263, .9552, .9579, .9489,
		.9447, .9399, .9322, .8945, .8220, .7353, .6193, .4813,
		.3584, .2614, .1890, .1269, .0841, .0618, .0442, .0318,
		.0277, .0245, .0213, .0130, .0075, .0074, .0068, .0049,
		.0030, .0024, .0024, .0017, .0000
    };
	
    /* Band 4 of Aster; Central Wavelength = 1657nm  */
    static const float sr4[89] = {
		.0000, .0001, .0001, .0002, .0004, .0005, .0007, .0009,
		.0012, .0014, .0017, .0021, .0024, .0028, .0032, .0036,
		.0040, .0045, .0054, .0065, .0080, .0112, .0170, .0245,
		.0330, .0450, .0740, .0990, .1520, .2140, .3050, .4200,
		.5970, .6750, .7900, .8270, .8400, .8408, .9010, .9050,
		.9100, .9140, .9050, .9260, .9470, .9670, .9760, .9840,
		.9710, .9790, .9880,1.0000, .9902, .9840, .9780, .9710,
		.9470, .9510, .9450, .9380, .9340, .9300, .9360, .9420,
		.9140, .8970, .7980, .7000, .5970, .4610, .3700, .2630,
		.1730, .1259, .0888, .0619, .0450, .0346, .0267, .0207,
		.0160, .0120, .0086, .0060, .0040, .0025, .0013, .0003,
		.0000
    };
	
    /* Band 5 of Aster; Central Wavelength = 2169nm  */
    static const float sr5[74] = {
		.0000, .0001, .0007, .0017, .0030, .0045, .0062, .0080,
		.0100, .0124, .0157, .0200, .0290, .0410, .0780, .1310,
		.2050, .3030, .5410, .7050, .7790, .7910, .8030, .8220,
		.8400, .9180, .9590,1.0000, .9750, .9020, .7790, .6890,
		.5900, .4180, .3030, .2300, .1720, .1070, .0700, .0610,
		.0498, .0385, .0273, .0160, .0140, .0120, .0100, .0080,
		.0070, .0060, .0050, .0040, .0038, .0036, .0034, .0033,
		.0031, .0029, .0027, .0025, .0024, .0023, .0021, .0020,
		.0019, .0017, .0016, .0015, .0013, .0011, .0008, .0005,
		.0002, .0000
    };
	
    /* Band 6 of Aster; Central Wavelength = 2209nm  */
    static const float sr6[78] = {
		.0000, .0001, .0001, .0003, .0005, .0007, .0010, .0014,
		.0018, .0022, .0027, .0032, .0037, .0044, .0050, .0057,
		.0064, .0072, .0080, .0092, .0110, .0133, .0160, .0194,
		.0240, .0298, .0370, .0490, .0660, .1070, .1720, .2540,
		.3520, .5000, .6020, .7420, .7620, .7790, .8520, .8690,
		.8860, .9020, .9290, .9550, .9840,1.0000, .9340, .8200,
		.7540, .5160, .3280, .2380, .1640, .1070, .0570, .0468,
		.0365, .0263, .0160, .0140, .0120, .0100, .0080, .0070,
		.0060, .0050, .0040, .0036, .0032, .0029, .0025, .0022,
		.0018, .0015, .0011, .0006, .0002, .0000
    };
	
    /* Band 7 of Aster; Central Wavelength = 2263nm  */
    static const float sr7[78] = {
		.0000, .0012, .0031, .0054, .0080, .0111, .0149, .0195,
		.0250, .0330, .0490, .0700, .1150, .1760, .2500, .3850,
		.5080, .6560, .7950, .8690, .8480, .9100, .9100, .9260,
		.9260, .9430, .9590, .9750, .9750,1.0000, .9590, .8690,
		.7990, .7050, .6230, .5000, .3930, .3030, .2420, .1760,
		.1270, .1060, .0840, .0625, .0410, .0370, .0330, .0290,
		.0250, .0230, .0215, .0199, .0182, .0165, .0147, .0130,
		.0112, .0093, .0084, .0078, .0074, .0070, .0067, .0062,
		.0058, .0053, .0049, .0044, .0040, .0035, .0031, .0027,
		.0022, .0018, .0013, .0008, .0004, .0000
    };
	
    /* Band 8 of Aster; Central Wavelength = 2334nm  */
    static const float sr8[92] = {
		.0000, .0026, .0055, .0081, .0103, .0120, .0131, .0138,
		.0147, .0160, .0195, .0260, .0347, .0450, .0610, .0820,
		.1060, .1390, .2040, .2860, .4490, .6040, .7020, .8330,
		.9710, .9880, .9550, .9800, .9770, .9750, .9720, .9700,
		.9670, .9470, .9620, .9770, .9920,1.0000, .9800, .9960,
		.9920, .9960, .9550, .9630, .9060, .8370, .7840, .7020,
		.5800, .4410, .3430, .2780, .2200, .1670, .1307, .0996,
		.0747, .0570, .0440, .0332, .0250, .0200, .0171, .0150,
		.0134, .0120, .0108, .0098, .0089, .0080, .0070, .0059,
		.0049, .0040, .0031, .0022, .0015, .0012, .0010, .0009,
		.0008, .0007, .0006, .0005, .0004, .0004, .0003, .0002,
		.0002, .0001, .0001, .0000
    };
	
    /* Band 9 of Aster; Central Wavelength = 2400nm  */
    static const float sr9[98] = {
		.0000, .0004, .0012, .0020, .0028, .0036, .0044, .0053,
		.0062, .0071, .0080, .0089, .0098, .0108, .0120, .0133,
		.0148, .0169, .0200, .0290, .0450, .0650, .0780, .1100,
		.1550, .2290, .3270, .4240, .5390, .7270, .7840, .9060,
		.9270, .8980, .9000, .9010, .9030, .9040, .9060, .9310,
		.9270, .9220, .9610,1.0000, .9800, .9590, .9270, .8940,
		.8690, .8330, .8160, .7670, .7020, .6610, .5630, .4240,
		.3430, .2610, .1920, .1439, .1021, .0695, .0490, .0369,
		.0274, .0205, .0160, .0132, .0111, .0094, .0080, .0066,
		.0053, .0044, .0040, .0051, .0073, .0087, .0088, .0088,
		.0087, .0087, .0086, .0085, .0084, .0082, .0079, .0076,
		.0072, .0067, .0062, .0055, .0047, .0039, .0029, .0018,
		.0005, .0000
    };
	
    static const float wli[9] = { 0.4800, 0.5875, 0.7225, 1.5300, 2.1025, 2.1050, 2.2000, 2.2475, 2.2950 };
    static const float wls[9] = { 0.6450, 0.7325, 0.9125, 1.7500, 2.2850, 2.2975, 2.3925, 2.4750, 2.5375 };
	
    ffu.wlinf = wli[iwa-1];
    ffu.wlsup = wls[iwa-1];
	
    int i;
    for(i = 0; i < 1501; i++) ffu.s[i] = 0; 
	
    switch(iwa)
    {
		case  1: for(i = 0; i <  67; i++)	 ffu.s[92+i] = sr1[i];
			break;
		case  2: for(i = 0; i <  59; i++)	 ffu.s[135+i] = sr2[i];
			break;
		case  3: for(i = 0; i <  77; i++)	 ffu.s[189+i] = sr3[i];
			break;
		case  4: for(i = 0; i <  89; i++)	 ffu.s[512+i] = sr4[i];
			break;
		case  5: for(i = 0; i <  74; i++)	 ffu.s[741+i] = sr5[i];
			break;
		case  6: for(i = 0; i <  78; i++)	 ffu.s[742+i] = sr6[i];
			break;
		case  7: for(i = 0; i <  78; i++)	 ffu.s[780+i] = sr7[i];
			break;
		case  8: for(i = 0; i <  92; i++)	 ffu.s[799+i] = sr8[i];
			break;
		case  9: for(i = 0; i <  98; i++)	 ffu.s[818+i] = sr9[i];
    }
}

/* Following filter function created using create_iwave.py */

void IWave::avnir(int iwa)
{
    /* "band 1" of AVNIR */
    static const float sr1[65] = {
		.0000, .0000, .0000, .0008, .0017, .0049, .0080, .0186,
		.0293, .0776, .1260, .2609, .3958, .5315, .6672, .6947,
		.7223, .7262, .7300, .7272, .7245, .7717, .8189, .8502,
		.8815, .9068, .9322, .9496, .9669, .9708, .9747, .9873,
		1.0000, .9849, .9699, .9507, .9316, .9365, .9415, .9632,
		.9849, .9600, .9351, .7552, .5754, .3911, .2068, .1361,
		.0655, .0440, .0226, .0150, .0075, .0046, .0018, .0009,
		.0000, .0000, .0000, .0000, .0000, .0000, .0000, .0000,
		.0000
    };
	
    /* "band 2" of AVNIR */
    static const float sr2[57] = {
		.0000, .0000, .0000, .0008, .0015, .0030, .0045, .0123,
		.0202, .0470, .0739, .1358, .1977, .3205, .4433, .5633,
		.6832, .7137, .7442, .7594, .7746, .8089, .8432, .8576,
		.8719, .8721, .8724, .8873, .9022, .9254, .9486, .9625,
		.9764, .9882, 1.0000, .9904, .9808, .9349, .8890, .8367,
		.7843, .7651, .7458, .7156, .6854, .5639, .4425, .3005,
		.1586, .0985, .0384, .0236, .0088, .0053, .0017, .0008,
		.0000
    };
	
    /* "band 3" of AVNIR */
    static const float sr3[81] = {
		.0000, .0000, .0000, .0000, .0000, .0000, .0000, .0008,
		.0016, .0025, .0034, .0043, .0051, .0075, .0099, .0126,
		.0153, .0228, .0304, .0462, .0620, .0995, .1370, .2107,
		.2844, .3857, .4871, .5747, .6624, .7198, .7771, .7896,
		.8021, .7991, .7960, .7989, .8017, .8312, .8606, .8982,
		.9359, .9592, .9825, .9912, 1.0000, .9931, .9862, .9568,
		.9275, .9046, .8818, .8607, .8395, .8344, .8293, .8215,
		.8136, .7470, .6804, .5481, .4158, .3100, .2043, .1471,
		.0898, .0634, .0369, .0273, .0177, .0135, .0093, .0076,
		.0060, .0045, .0030, .0023, .0015, .0016, .0016, .0008,
		.0000
    };
	
    /* "band 4" of AVNIR */
    static const float sr4[121] = {
		.0000, .0000, .0000, .0000, .0000, .0000, .0000, .0011,
		.0023, .0023, .0022, .0033, .0045, .0080, .0115, .0190,
		.0264, .0484, .0704, .1138, .1572, .2351, .3129, .4431,
		.5733, .7244, .8754, .9377, 1.0000, .9884, .9768, .9528,
		.9288, .9091, .8894, .8763, .8633, .8627, .8622, .8753,
		.8885, .9136, .9388, .9437, .9486, .9531, .9576, .9411,
		.9247, .8969, .8691, .8467, .8242, .7893, .7545, .7331,
		.7117, .6911, .6705, .6560, .6414, .6357, .6299, .6258,
		.6217, .6227, .6237, .6025, .5812, .5843, .5874, .5867,
		.5860, .5696, .5532, .5251, .4969, .4438, .3908, .3191,
		.2475, .1906, .1338, .1033, .0727, .0543, .0359, .0292,
		.0224, .0161, .0097, .0069, .0040, .0038, .0036, .0030,
		.0025, .0024, .0024, .0015, .0007, .0004, .0000, .0003,
		.0007, .0006, .0006, .0006, .0006, .0003, .0000, .0000,
		.0000, .0000, .0000, .0000, .0000, .0000, .0000, .0000,
		.0000
    };
	
    static const float wli[4] = {0.390, 0.485, 0.545, 0.700};
    static const float wls[4] = {0.550, 0.625, 0.745, 1.000};

    ffu.wlinf = (float)wli[iwa-1];
    ffu.wlsup = (float)wls[iwa-1];

    int i;
    for(i = 0; i < 1501; i++) ffu.s[i] = 0;

    switch(iwa)
    {
    case 1: for(i = 0; i < 65; i++)  ffu.s[56+i] = sr1[i];
        break;
    case 2: for(i = 0; i < 57; i++)  ffu.s[94+i] = sr2[i];
        break;
    case 3: for(i = 0; i < 81; i++)  ffu.s[118+i] = sr3[i];
        break;
    case 4: for(i = 0; i < 121; i++)  ffu.s[180+i] = sr4[i];
        break;
    }
}

/* Following filter function created using create_iwave.py */

void IWave::ikonos(int iwa)
{

    /* Ikonos Green of ikonos */
    static const float sr1[275] = {
		.0008, .0011, .0015, .0012, .0009, .0008, .0007, .0007,
		.0007, .0010, .0013, .0015, .0017, .0018, .0019, .0024,
		.0028, .0040, .0052, .0064, .0077, .0082, .0088, .0103,
		.0119, .0147, .0175, .0262, .0350, .0602, .0854, .1392,
		.1929, .2617, .3305, .3750, .4195, .4638, .5082, .5607,
		.6132, .6437, .6742, .6973, .7204, .7406, .7608, .7605,
		.7601, .7742, .7883, .8225, .8566, .8730, .8894, .9165,
		.9436, .9718, 1.0000, .9934, .9868, .9562, .9255, .8434,
		.7613, .6519, .5424, .4282, .3139, .2590, .2041, .1780,
		.1519, .1188, .0856, .0644, .0432, .0371, .0310, .0288,
		.0266, .0244, .0222, .0221, .0221, .0242, .0262, .0279,
		.0296, .0283, .0270, .0248, .0226, .0240, .0254, .0280,
		.0305, .0289, .0274, .0243, .0213, .0215, .0217, .0257,
		.0296, .0319, .0342, .0306, .0271, .0233, .0195, .0195,
		.0195, .0193, .0190, .0165, .0140, .0107, .0073, .0067,
		.0060, .0056, .0051, .0065, .0079, .0101, .0123, .0161,
		.0200, .0210, .0221, .0214, .0208, .0199, .0190, .0172,
		.0155, .0126, .0097, .0083, .0068, .0059, .0049, .0052,
		.0054, .0085, .0115, .0169, .0222, .0231, .0240, .0180,
		.0121, .0080, .0040, .0031, .0022, .0024, .0026, .0024,
		.0023, .0029, .0035, .0030, .0025, .0024, .0023, .0032,
		.0040, .0038, .0036, .0032, .0027, .0025, .0024, .0025,
		.0026, .0024, .0022, .0019, .0016, .0016, .0016, .0018,
		.0020, .0020, .0020, .0023, .0025, .0031, .0036, .0046,
		.0056, .0061, .0066, .0071, .0075, .0078, .0080, .0087,
		.0095, .0089, .0083, .0085, .0088, .0090, .0093, .0100,
		.0107, .0116, .0125, .0128, .0131, .0131, .0131, .0125,
		.0119, .0112, .0105, .0100, .0095, .0091, .0088, .0086,
		.0084, .0083, .0082, .0081, .0080, .0082, .0084, .0082,
		.0081, .0081, .0080, .0080, .0080, .0074, .0069, .0062,
		.0054, .0051, .0048, .0046, .0045, .0043, .0041, .0038,
		.0036, .0035, .0035, .0034, .0033, .0030, .0028, .0028,
		.0028, .0026, .0024, .0024, .0023, .0025, .0026, .0026,
		.0026, .0026, .0026, .0021, .0016, .0018, .0019, .0022,
		.0024, .0019, .0013
    };
	
    /* Ikonos Red of ikonos */
    static const float sr2[275] = {
		.0006, .0007, .0008, .0008, .0007, .0008, .0008, .0007,
		.0006, .0007, .0008, .0007, .0006, .0008, .0009, .0007,
		.0006, .0010, .0013, .0013, .0012, .0019, .0027, .0018,
		.0010, .0011, .0013, .0016, .0019, .0023, .0027, .0030,
		.0034, .0037, .0040, .0049, .0057, .0074, .0091, .0102,
		.0113, .0113, .0113, .0122, .0130, .0151, .0172, .0208,
		.0245, .0306, .0367, .0435, .0503, .0565, .0628, .0861,
		.1094, .1512, .1931, .2421, .2911, .3653, .4396, .5451,
		.6507, .7286, .8066, .8391, .8717, .8801, .8884, .8891,
		.8898, .8824, .8749, .8635, .8521, .8722, .8923, .9450,
		.9977, .9819, .9661, .9369, .9077, .9005, .8932, .9195,
		.9459, .9715, .9972, .9785, .9598, .9186, .8774, .8136,
		.7497, .6259, .5020, .3926, .2832, .2215, .1599, .1334,
		.1068, .0947, .0825, .0732, .0640, .0557, .0474, .0397,
		.0320, .0273, .0227, .0196, .0166, .0155, .0145, .0147,
		.0148, .0155, .0162, .0174, .0186, .0193, .0199, .0193,
		.0188, .0170, .0152, .0138, .0125, .0122, .0119, .0114,
		.0109, .0122, .0135, .0150, .0165, .0174, .0183, .0171,
		.0159, .0135, .0112, .0088, .0063, .0059, .0055, .0044,
		.0034, .0036, .0039, .0037, .0035, .0032, .0030, .0030,
		.0031, .0027, .0023, .0029, .0034, .0035, .0036, .0044,
		.0053, .0059, .0065, .0068, .0072, .0080, .0089, .0092,
		.0095, .0088, .0080, .0075, .0070, .0067, .0064, .0063,
		.0061, .0059, .0056, .0054, .0053, .0057, .0061, .0068,
		.0074, .0070, .0067, .0067, .0067, .0081, .0094, .0111,
		.0128, .0135, .0143, .0151, .0159, .0165, .0171, .0172,
		.0172, .0168, .0163, .0158, .0152, .0143, .0134, .0127,
		.0120, .0113, .0106, .0103, .0100, .0096, .0092, .0095,
		.0098, .0093, .0089, .0087, .0084, .0081, .0078, .0077,
		.0075, .0072, .0070, .0064, .0059, .0056, .0054, .0050,
		.0046, .0043, .0039, .0038, .0036, .0034, .0033, .0031,
		.0029, .0029, .0028, .0028, .0028, .0025, .0022, .0024,
		.0025, .0024, .0022, .0024, .0025, .0023, .0021, .0019,
		.0017, .0019, .0021, .0021, .0020, .0021, .0022, .0018,
		.0014, .0015, .0016
    };
	
    /* Ikonos NIR of ikonos */
    static const float sr3[275] = {
		.0000, .0003, .0005, .0004, .0004, .0005, .0006, .0005,
		.0003, .0006, .0008, .0007, .0007, .0005, .0004, .0009,
		.0015, .0018, .0020, .0025, .0030, .0033, .0035, .0038,
		.0040, .0041, .0041, .0060, .0078, .0081, .0084, .0083,
		.0082, .0066, .0051, .0038, .0026, .0035, .0043, .0049,
		.0055, .0055, .0055, .0042, .0029, .0023, .0017, .0016,
		.0015, .0026, .0036, .0040, .0043, .0034, .0025, .0023,
		.0020, .0017, .0013, .0014, .0015, .0015, .0015, .0018,
		.0021, .0022, .0024, .0025, .0027, .0030, .0034, .0031,
		.0029, .0029, .0029, .0035, .0041, .0050, .0060, .0066,
		.0072, .0083, .0093, .0093, .0093, .0090, .0087, .0091,
		.0095, .0099, .0103, .0118, .0133, .0169, .0204, .0244,
		.0285, .0316, .0347, .0388, .0428, .0502, .0575, .0715,
		.0855, .1052, .1249, .1506, .1764, .2174, .2584, .3386,
		.4188, .5285, .6381, .7213, .8045, .8414, .8784, .8990,
		.9196, .9364, .9532, .9545, .9559, .9424, .9289, .9339,
		.9389, .9628, .9866, .9917, .9968, .9524, .9079, .8388,
		.7698, .6808, .5919, .5067, .4215, .3634, .3053, .2658,
		.2262, .1923, .1583, .1315, .1046, .0860, .0674, .0560,
		.0447, .0373, .0299, .0269, .0239, .0230, .0220, .0202,
		.0184, .0171, .0159, .0161, .0162, .0159, .0157, .0161,
		.0165, .0168, .0171, .0167, .0163, .0142, .0121, .0106,
		.0091, .0079, .0068, .0065, .0062, .0059, .0056, .0049,
		.0042, .0042, .0042, .0046, .0050, .0045, .0040, .0040,
		.0040, .0033, .0027, .0028, .0030, .0028, .0025, .0029,
		.0033, .0029, .0026, .0026, .0026, .0027, .0028, .0027,
		.0027, .0028, .0028, .0027, .0026, .0026, .0026, .0025,
		.0025, .0024, .0024, .0024, .0023, .0026, .0029, .0028,
		.0027, .0029, .0031, .0035, .0039, .0040, .0040, .0040,
		.0040, .0037, .0035, .0031, .0026, .0024, .0022, .0019,
		.0016, .0015, .0014, .0014, .0013, .0013, .0014, .0012,
		.0011, .0011, .0012, .0012, .0012, .0011, .0010, .0013,
		.0016, .0013, .0010, .0012, .0013, .0014, .0014, .0022,
		.0029, .0023, .0018, .0020, .0023, .0018, .0013, .0011,
		.0009, .0004, .0000
    };
	
    static const float wli[3] = {0.350, 0.350, 0.350};
    static const float wls[3] = {1.035, 1.035, 1.035};

    ffu.wlinf = (float)wli[iwa-1];
    ffu.wlsup = (float)wls[iwa-1];

    int i;
    for(i = 0; i < 1501; i++) ffu.s[i] = 0;

    switch(iwa)
    {
    case 1: for(i = 0; i < 275; i++)  ffu.s[40+i] = sr1[i];
        break;
    case 2: for(i = 0; i < 275; i++)  ffu.s[40+i] = sr2[i];
        break;
    case 3: for(i = 0; i < 275; i++)  ffu.s[40+i] = sr3[i];
        break;
    }
}

/* Following filter function created using create_iwave.py */

void IWave::rapideye(int iwa)
{

    /* "Blue" of rapideye */
    static const float sr1[30] = {
		.0200, .5050, .7300, .7450, .7600, .7750, .7800,
		.8000, .8000, .8000, .8100, .8000, .8100, .8200,
		.8300, .8400, .8500, .8650, .8800, .8900, .9200,
		.9500, .9700, .9700, 1.0000, 1.0000
    };

    /* "Green" of rapideye */
    static const float sr2[53] = {
		.0100, .0183, .0267, .0105, .0132, .0158, .0184,
		.0237, .0263, .0289, .0288, .0268, .0248, .0228,
		.0188, .0168, .0148, .0128, .0108, .0200, .1200,
		.8700, .8700, .8800, .8700, .8800, .8800, .8800,
		.8900, .9000, .9000, .9050, .9200, .9250, .9300,
		.9500, .9550, .9700, .9750, .9800, .9800, .9900,
		.9900, .9850, 1.0000, .2750
    };

    /* "Red" of rapideye */
    static const float sr3[27] = {
		.0100, .0300, .2000, .7900, .8500, .8750, .8800,
		.9000, .9100, .9100, .9200, .9300, .9450, .9500,
		.9700, .9750, .9900, .9900, .9900, .9900, 1.0000,
		.8600, .1150
    };

    /* "RedEdge " of rapideye */
    static const float sr4[95] = {
		.0300, .0285, .0271, .0256, .0241, .0226, .0212,
		.0182, .0168, .0153, .0138, .0124, .0109, .0101,
		.0108, .0111, .0114, .0118, .0121, .0124, .0128,
		.0134, .0138, .0141, .0144, .0147, .0151, .0154,
		.0161, .0164, .0167, .0170, .0174, .0177, .0180,
		.0187, .0190, .0193, .0197, .0200, .0200, .0200,
		.0200, .0200, .0200, .0200, .0200, .0200, .0200,
		.0200, .0200, .0197, .0191, .0185, .0178, .0172,
		.0159, .0153, .0146, .0140, .0133, .0127, .0121,
		.0108, .0101, .0200, .1050, .4900, .9450, 1.0000,
		1.0000, .9900, .9900, .9900, .9800, .9750, .9700,
		.9600, .9450, .9400, .9000, .4300, .0950
    };

    /* "NIR " of rapideye */
    static const float sr5[137] = {
		.0100, .0102, .0103, .0105, .0106, .0108, .0110,
		.0113, .0115, .0116, .0118, .0119, .0121, .0123,
		.0126, .0128, .0129, .0131, .0132, .0134, .0136,
		.0139, .0141, .0142, .0144, .0145, .0147, .0149,
		.0152, .0154, .0155, .0157, .0158, .0160, .0162,
		.0165, .0167, .0168, .0170, .0171, .0173, .0175,
		.0178, .0180, .0181, .0183, .0184, .0186, .0188,
		.0191, .0193, .0194, .0196, .0197, .0199, .0199,
		.0192, .0188, .0185, .0182, .0178, .0175, .0171,
		.0164, .0161, .0158, .0154, .0151, .0147, .0144,
		.0137, .0134, .0130, .0127, .0123, .0120, .0116,
		.0110, .0106, .0103, .0100, .0100, .0250, .0700,
		.5000, .8850, 1.0000, .9750, .9700, .9750, .9800,
		.9700, .9600, .9600, .9600, .9600, .9600, .9600,
		.9500, .9400, .9400, .9300, .9300, .9300, .9300,
		.9200, .9200, .9100, .9000, .8900, .8850, .8800,
		.8600, .8400, .8400, .8150, .5800, .2450, .0800,

    };

    static const float wli[5] = {0.438, 0.463, 0.624, 0.500, 0.520};
    static const float wls[5] = {0.513, 0.594, 0.690, 0.737, 0.862};

    ffu.wlinf = (float)wli[iwa-1];
    ffu.wlsup = (float)wls[iwa-1];

    int i;
    for(i = 0; i < 1501; i++) ffu.s[i] = 0;

    switch(iwa)
    {
    case 1: for(i = 0; i < 30; i++)  ffu.s[75+i] = sr1[i];
        break;
    case 2: for(i = 0; i < 53; i++)  ffu.s[85+i] = sr2[i];
        break;
    case 3: for(i = 0; i < 27; i++)  ffu.s[149+i] = sr3[i];
        break;
    case 4: for(i = 0; i < 95; i++)  ffu.s[100+i] = sr4[i];
        break;
    case 5: for(i = 0; i < 137; i++)  ffu.s[108+i] = sr5[i];
        break;
    }
}

/* Following filter function created using create_iwave.py */

void IWave::vgt1_spot4(int iwa)
{

    /* B0 of VGT1-spot4 */
    static const float sr1[41] = {
		.0001, .0003, .0005, .0007, .0010, .0013, .0028, .0050,
		.0182, .0377, .0828, .1423, .2234, .3168, .4108, .5052,
		.5925, .6759, .7509, .8212, .8815, .9361, .9699, .9920,
		.9907, .9761, .9528, .9248, .8811, .8287, .7223, .5857,
		.4394, .2876, .1820, .1024, .0579, .0331, .0196, .0125,
		.0000
    };

    /* B2 of VGT1-spot4 */
    static const float sr2[82] = {
		.0017, .0017, .0016, .0016, .0016, .0024, .0031, .0039,
		.0046, .0439, .0832, .1225, .1618, .2737, .3856, .4975,
		.6094, .6615, .7136, .7657, .8178, .8278, .8377, .8477,
		.8577, .8673, .8769, .8865, .8961, .9088, .9214, .9341,
		.9468, .9595, .9722, .9849, .9976, .9895, .9815, .9734,
		.9653, .9169, .8685, .8201, .7717, .6989, .6260, .5532,
		.4804, .4243, .3681, .3120, .2559, .2229, .1899, .1569,
		.1239, .1063, .0887, .0712, .0536, .0454, .0372, .0289,
		.0207, .0175, .0143, .0111, .0079, .0069, .0060, .0050,
		.0040, .0034, .0027, .0021, .0015, .0015, .0015, .0015,
		.0015, .0000
    };

    /* B3 of VGT1-spot4 */
    static const float sr3[133] = {
		.0007, .0008, .0008, .0009, .0010, .0011, .0013, .0014,
		.0015, .0019, .0022, .0026, .0030, .0051, .0072, .0092,
		.0113, .0210, .0308, .0406, .0503, .0806, .1109, .1411,
		.1714, .2271, .2828, .3385, .3942, .4584, .5226, .5869,
		.6511, .6966, .7421, .7876, .8331, .8607, .8883, .9159,
		.9435, .9552, .9668, .9785, .9902, .9927, .9951, .9976,
		1.0000, .9999, .9997, .9996, .9994, .9984, .9974, .9964,
		.9954, .9927, .9900, .9873, .9846, .9766, .9686, .9606,
		.9526, .9445, .9365, .9284, .9203, .9008, .8813, .8618,
		.8423, .7897, .7370, .6844, .6318, .5584, .4849, .4114,
		.3380, .2893, .2407, .1920, .1434, .1222, .1010, .0798,
		.0586, .0505, .0425, .0345, .0264, .0229, .0194, .0159,
		.0124, .0111, .0098, .0085, .0072, .0065, .0057, .0050,
		.0042, .0038, .0034, .0031, .0027, .0024, .0021, .0017,
		.0014, .0014, .0014, .0013, .0013, .0013, .0013, .0012,
		.0012, .0012, .0011, .0011, .0011, .0010, .0009, .0009,
		.0008, .0007, .0006, .0006, .0005
    };

    /* MIR of VGT1-spot4 */
    static const float sr4[141] = {
		.0010, .0010, .0010, .0010, .0010, .0011, .0011, .0012,
		.0013, .0014, .0014, .0015, .0016, .0016, .0017, .0018,
		.0018, .0019, .0021, .0022, .0024, .0026, .0028, .0030,
		.0032, .0035, .0038, .0041, .0044, .0050, .0055, .0060,
		.0066, .0075, .0083, .0092, .0101, .0118, .0136, .0154,
		.0171, .0203, .0235, .0267, .0299, .0366, .0433, .0501,
		.0568, .0708, .0848, .0989, .1129, .1406, .1684, .1961,
		.2239, .2691, .3142, .3594, .4045, .4677, .5308, .5939,
		.6571, .7099, .7628, .8156, .8685, .8934, .9183, .9433,
		.9682, .9761, .9841, .9920, 1.0000, .9971, .9941, .9912,
		.9883, .9840, .9797, .9753, .9710, .9517, .9325, .9132,
		.8939, .8713, .8488, .8262, .8036, .7457, .6878, .6299,
		.5720, .5109, .4498, .3887, .3276, .2926, .2576, .2226,
		.1876, .1704, .1531, .1358, .1186, .1078, .0970, .0863,
		.0755, .0685, .0614, .0544, .0474, .0430, .0385, .0340,
		.0296, .0269, .0242, .0214, .0187, .0172, .0157, .0142,
		.0127, .0118, .0109, .0101, .0092, .0086, .0080, .0075,
		.0069, .0064, .0060, .0055, .0050
    };

    static const float wli[4] = {0.400, 0.580, 0.700, 1.450};
    static const float wls[4] = {0.500, 0.782, 1.030, 1.800};

    ffu.wlinf = (float)wli[iwa-1];
    ffu.wlsup = (float)wls[iwa-1];

    int i;
    for(i = 0; i < 1501; i++) ffu.s[i] = 0;

    switch(iwa)
    {
    case 1: for(i = 0; i < 41; i++)  ffu.s[60+i] = sr1[i];
        break;
    case 2: for(i = 0; i < 82; i++)  ffu.s[132+i] = sr2[i];
        break;
    case 3: for(i = 0; i < 133; i++)  ffu.s[180+i] = sr3[i];
        break;
    case 4: for(i = 0; i < 141; i++)  ffu.s[480+i] = sr4[i];
        break;
    }
}

/* Following filter function created using create_iwave.py */

void IWave::vgt2_spot5(int iwa)
{

    /* B0 of VGT2_spot5 */
    static const float sr1[61] = {
		.0007, .0008, .0010, .0010, .0011, .0012, .0013, .0029,
		.0045, .0209, .0374, .0964, .1553, .2551, .3549, .4536,
		.5524, .6318, .7111, .7602, .8093, .8304, .8514, .8698,
		.8882, .9441, 1.0000, .9787, .9574, .7493, .5412, .3553,
		.1694, .1083, .0472, .0318, .0163, .0116, .0069, .0053,
		.0036, .0028, .0020, .0017, .0014, .0011, .0009, .0008,
		.0008, .0008, .0007, .0006, .0006, .0006, .0005, .0004,
		.0004, .0004, .0004, .0003, .0003
    };

    /* B2 of VGT2_spot5 */
    static const float sr2[81] = {
		.0006, .0006, .0006, .0007, .0007, .0033, .0059, .0084,
		.0110, .0688, .1265, .1842, .2420, .3532, .4643, .5755,
		.6866, .7306, .7745, .8185, .8625, .8766, .8906, .9046,
		.9187, .9307, .9426, .9546, .9666, .9749, .9833, .9917,
		1.0000, .9957, .9915, .9872, .9829, .9387, .8945, .8503,
		.8061, .7316, .6570, .5825, .5079, .4468, .3856, .3245,
		.2634, .2293, .1952, .1611, .1270, .1095, .0921, .0746,
		.0572, .0490, .0408, .0326, .0244, .0208, .0171, .0135,
		.0099, .0085, .0071, .0057, .0043, .0037, .0031, .0025,
		.0019, .0017, .0014, .0012, .0010, .0009, .0008, .0007,
		.0006
    };

    /* B3 of VGT2_spot5 */
    static const float sr3[121] = {
		.0003, .0003, .0003, .0003, .0003, .0003, .0003, .0004,
		.0004, .0005, .0006, .0008, .0009, .0017, .0024, .0032,
		.0040, .0082, .0124, .0166, .0208, .0361, .0514, .0667,
		.0820, .1175, .1530, .1885, .2240, .2774, .3309, .3844,
		.4378, .4906, .5434, .5962, .6490, .6899, .7308, .7716,
		.8125, .8369, .8612, .8856, .9100, .9248, .9396, .9544,
		.9692, .9761, .9829, .9898, .9967, .9975, .9983, .9992,
		1.0000, .9939, .9878, .9817, .9756, .9618, .9480, .9342,
		.9204, .9030, .8856, .8682, .8508, .8236, .7965, .7693,
		.7422, .6945, .6467, .5989, .5512, .4910, .4308, .3706,
		.3104, .2681, .2258, .1836, .1413, .1213, .1013, .0813,
		.0613, .0530, .0447, .0364, .0281, .0245, .0209, .0172,
		.0136, .0120, .0104, .0089, .0073, .0065, .0056, .0047,
		.0039, .0036, .0032, .0029, .0025, .0023, .0021, .0018,
		.0016, .0015, .0014, .0012, .0011, .0010, .0008, .0007,
		.0006
    };

    /* MIR of VGT2_spot5 */
    static const float sr4[141] = {
		.0005, .0006, .0006, .0007, .0008, .0008, .0008, .0009,
		.0009, .0009, .0009, .0009, .0009, .0011, .0014, .0016,
		.0019, .0022, .0024, .0027, .0029, .0034, .0040, .0045,
		.0050, .0060, .0070, .0080, .0090, .0108, .0126, .0143,
		.0161, .0196, .0231, .0266, .0301, .0372, .0444, .0515,
		.0586, .0723, .0860, .0997, .1134, .1401, .1668, .1936,
		.2203, .2668, .3134, .3599, .4065, .4664, .5263, .5863,
		.6462, .6929, .7396, .7862, .8329, .8630, .8931, .9233,
		.9534, .9644, .9754, .9863, .9973, .9980, .9987, .9993,
		1.0000, .9987, .9974, .9962, .9949, .9914, .9879, .9845,
		.9810, .9687, .9564, .9440, .9317, .9055, .8793, .8532,
		.8270, .7811, .7351, .6892, .6433, .5746, .5059, .4371,
		.3684, .3244, .2803, .2363, .1923, .1713, .1502, .1292,
		.1082, .0970, .0859, .0747, .0636, .0575, .0514, .0453,
		.0392, .0360, .0327, .0295, .0262, .0235, .0209, .0182,
		.0155, .0139, .0123, .0106, .0090, .0082, .0073, .0065,
		.0057, .0053, .0050, .0046, .0043, .0040, .0037, .0033,
		.0030, .0026, .0022, .0019, .0015
    };

    static const float wli[4] = {0.400, 0.580, 0.700, 1.450};
    static const float wls[4] = {0.550, 0.780, 1.000, 1.800};

    ffu.wlinf = (float)wli[iwa-1];
    ffu.wlsup = (float)wls[iwa-1];

    int i;
    for(i = 0; i < 1501; i++) ffu.s[i] = 0;

    switch(iwa)
    {
    case 1: for(i = 0; i < 61; i++)  ffu.s[60+i] = sr1[i];
        break;
    case 2: for(i = 0; i < 81; i++)  ffu.s[132+i] = sr2[i];
        break;
    case 3: for(i = 0; i < 121; i++)  ffu.s[180+i] = sr3[i];
        break;
    case 4: for(i = 0; i < 141; i++)  ffu.s[480+i] = sr4[i];
        break;
    }
}

float IWave::equivwl() const
{
    float seb = 0;
    float wlwave = 0;

    for(int i = iinf; i <= isup; i++)
    {
	float sbor = ffu.s[i];
	if(i == iinf || i == isup) sbor *= 0.5;
	float wl = (float)(0.25 + i * step);
	float swl = solirr(wl);
	float coef = sbor * step * swl;
	seb += coef;
	wlwave += wl * coef;
    }

    return wlwave/seb;
}

void IWave::parse()
{
    iinf = 0;
    isup = 1500;

    int i;
    for(i = 0; i <= isup; i++) ffu.s[i] = 1;

    cin >> iwave;
    cin.ignore(numeric_limits<int>::max(),'\n');
	
    if(iwave == 0 || iwave == -2)
    {
	cin >> ffu.wlinf;
	cin >> ffu.wlsup;
	cin.ignore(numeric_limits<int>::max(),'\n');
    }  
    else if(iwave < 0)	/* excludes -2 */
    {
	cin >> wl;
	cin.ignore(numeric_limits<int>::max(),'\n');
	ffu.wlinf = wl;
	ffu.wlsup = wl;
    } 
    else
    {
	/* da big switch */
	if(iwave == 1)
	{
	    cin >> ffu.wlinf;
	    cin >> ffu.wlsup;
	    cin.ignore(numeric_limits<int>::max(),'\n');
	    /* moved rest further on */
	}
	else if(iwave == 2)	meteo();
	else if(iwave == 3)	goes_east();
	else if(iwave == 4)	goes_west();
	else if(iwave <= 16)	avhrr(iwave - 4);
	else if(iwave <= 24)	hrv(iwave - 16);
	else if(iwave <= 30)	tm(iwave - 24);
	else if(iwave <= 34)	mss(iwave - 30);
	else if(iwave <= 41)	mas(iwave - 34);
	else if(iwave <= 48)	modis(iwave - 41);
	else if(iwave <= 52)	avhrr(iwave - 36);
	else if(iwave <= 60)	polder(iwave - 52);
	else if(iwave <= 67)	etmplus(iwave - 60);
	else if(iwave <= 71)	irs_1c_liss(iwave - 67);
	else if(iwave <= 80)	aster(iwave - 71);
	else if(iwave <= 84)    avnir(iwave - 80);
	else if(iwave <= 87)    ikonos(iwave - 84);
	else if(iwave <= 92)    rapideye(iwave - 87);
	else if(iwave <= 96)    vgt1_spot4(iwave - 92);
	else if(iwave <= 100)   vgt2_spot5(iwave - 96);
	else G_warning(_("Unsupported iwave value: %d"), iwave);
    }

    iinf = (int)((ffu.wlinf - 0.25f) / 0.0025f + 1.5f) - 1;	/* remember indexing*/
    isup = (int)((ffu.wlsup - 0.25f) / 0.0025f + 1.5f) - 1;	/*		   "*/

    if(iwave == 1)	/* moved here to avoid unnecessery gotos */
    {
	for(int i = iinf; i <= isup; i++) cin >> ffu.s[i];
	cin.ignore(numeric_limits<int>::max(),'\n');
    }
}

/* --- spectral condition ---- */
void IWave::print()
{
    static const string nsat[102] = {
	string(" constant        "), string(" user s          "),
	string(" meteosat        "), string(" goes east       "), string(" goes west       "),
	string(" avhrr 1 (noaa6) "), string(" avhrr 2 (noaa6) "),
	string(" avhrr 1 (noaa7) "), string(" avhrr 2 (noaa7) "),
	string(" avhrr 1 (noaa8) "), string(" avhrr 2 (noaa8) "),
	string(" avhrr 1 (noaa9) "), string(" avhrr 2 (noaa9) "),
	string(" avhrr 1 (noaa10)"), string(" avhrr 2 (noaa10)"),
	string(" avhrr 1 (noaa11)"), string(" avhrr 2 (noaa11)"),
	string(" hrv1 1          "), string(" hrv1 2          "), string(" hrv1 3          "),
	string(" hrv1 pan        "),
	string(" hrv2 1          "), string(" hrv2 2          "), string(" hrv2 3          "),
	string(" hrv2 pan        "),
	string("  tm  1          "), string("  tm  2          "), string("  tm  3          "),
	string("  tm  4          "), string("  tm  5          "), string("  tm  7          "),
	string("  mss 4          "), string("  mss 5          "),
	string("  mss 6          "), string("  mss 7          "),
	string("  mas 1          "), string("  mas 2          "), string("  mas 3          "),
	string("  mas 4          "), string("  mas 5          "), string("  mas 6          "),
	string("  mas 7          "), string("  modis 1        "), string("  modis 2        "),
	string("  modis 3        "), string("  modis 4        "), string("  modis 5        "),
	string("  modis 6        "), string("  modis 7        "),
	string(" avhrr 1 (noaa12)"), string(" avhrr 2 (noaa12)"),
	string(" avhrr 1 (noaa14)"), string(" avhrr 2 (noaa14)"),
	string(" polder 1        "), string(" polder 2        "),
	string(" polder 3        "), string(" polder 4        "), string(" polder 6        "),
	string(" polder 6        "), string(" polder 7        "), string(" polder 8        "),
	string(" etm+ 1          "), string(" etm+ 2          "), string(" etm+ 3          "),
	string(" etm+ 4          "), string(" etm+ 5          "), string(" etm+ 7          "),
	string(" etm+ 8          "),
	string(" liss 2          "), string(" liss 3          "), string(" liss 4          "),
	string(" liss 5          "),
	string(" aster 1         "), string(" aster 2         "), string(" aster 3N        "),
	string(" aster 4         "), string(" aster 5         "), string(" aster 6         "),
	string(" aster 7         "), string(" aster 8         "), string(" aster 9         "),
	string(" avnir 1         "), string(" avnir 2         "), string(" avnir 3         "),
	string(" avnir 4         "),
	string(" ikonos green    "), string(" ikonos red      "),	string(" ikonos NIR      "),
	string(" rapideye blue   "), string(" rapideye green  "),	string(" rapideye red    "),
	string(" rapideye rededge"), string(" rapideye NIR    "),
	string(" vgt1 spot4 0    "), string(" vgt1 spot4 2    "), string(" vgt1 spot4 3    "),
	string(" vgt1 spot4 MIR  "),
	string(" vgt2 spot5 0    "), string(" vgt2 spot5 2    "), string(" vgt2 spot5 3    "),
	string(" vgt2 spot5 MIR  "),
    };


    Output::Begin(); 
    Output::Repeat(22, ' ');
    Output::Print(" spectral condition  ");
    Output::End();

    Output::Begin(); 
    Output::Repeat(22, ' ');
    Output::Print(" ------------------  ");
    Output::End();

    if(iwave == -2)
    {
	Output::Begin();
	Output::Repeat(10,' ');
	Output::Print(nsat[0]);
	Output::End();

	Output::Begin();
	Output::Repeat(15,' ');
	Output::Print("value of filter function :");
	Output::End();

	Output::Begin();
	Output::Repeat(15,' ');
	ostringstream s;
	s.setf(ios::fixed, ios::floatfield);
	s << setprecision(3);
	s << " wl inf=" << setw(9) << ffu.wlinf << " mic  " 
	  << " wl sup=" << setw(9) << ffu.wlsup << " mic" << ends;
	Output::Print(s.str());
	Output::End();
    }
    else if(iwave == -1)
    {
	Output::Begin();
	Output::Repeat(12,' ');
	ostringstream s;
	s.setf(ios::fixed, ios::floatfield);
	s << setprecision(3);
	s << " monochromatic calculation at wl :" << setw(9) << ffu.wlsup << " micron" << ends;
	Output::Print(s.str());
	Output::End();
    }
    else if(iwave >= 0)
    {
	Output::Begin();
	Output::Repeat(10,' ');
	Output::Print(nsat[iwave]);
	Output::End();

	Output::Begin();
	Output::Repeat(15,' ');
	Output::Print("value of filter function :");
	Output::End();

	Output::Begin();
	Output::Repeat(15,' ');
	ostringstream s;
	s.setf(ios::fixed, ios::floatfield);
	s << setprecision(3);
	s << " wl inf=" << setw(9) << ffu.wlinf << " mic  " 
	  << " wl sup=" << setw(9) << ffu.wlsup << " mic" << ends;
	Output::Print(s.str());
	Output::End();
    }
}

IWave IWave::Parse()
{
    IWave iwave;
    iwave.parse();
    return iwave;
}
