### Copyright (C) 2005 Peter Williams <pwil3058@bigpond.net.au>

### This program is free software; you can redistribute it and/or modify
### it under the terms of the GNU General Public License as published by
### the Free Software Foundation; version 2 of the License only.

### This program is distributed in the hope that it will be useful,
### but WITHOUT ANY WARRANTY; without even the implied warranty of
### MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
### GNU General Public License for more details.

### You should have received a copy of the GNU General Public License
### along with this program; if not, write to the Free Software
### Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import gtk, gtk.gdk, os, os.path, sys, collections

# find the icons directory
# first look in the source directory (so that we can run uninstalled)
_ICON_DIR = os.path.join(sys.path[0],'pixmaps')
if not os.path.exists(_ICON_DIR) or not os.path.isdir(_ICON_DIR):
    _TAILEND = os.path.join('share', 'pixmaps', 'gquilt')
    _prefix = sys.path[0]
    while _prefix:
        _ICON_DIR = os.path.join(_prefix, _TAILEND)
        if os.path.exists(_ICON_DIR) and os.path.isdir(_ICON_DIR):
            break
        _prefix = os.path.dirname(_prefix)

_APP_ICON = "gquilt"
APP_ICON_FILE = os.path.join(os.path.dirname(_ICON_DIR), _APP_ICON + os.extsep + "png")

POP = "gquilt_stock_pop"
PUSH = "gquilt_stock_push"
FOLD = "gquilt_stock_fold"
IMPORT_PATCH = "gquilt_stock_import"
DIFF = "gquilt_stock_diff"
MELD = "gquilt_stock_meld"
APPLIED_OK = "gquilt_stock_tick"
APPLIED_NOT_OK = "gquilt_stock_cross"
TOP_OK = "gquilt_stock_tick"
TOP_NOT_OK = "gquilt_stock_cross"
FINISH = "gquilt_stock_finish"
STOCK_NEW_PATCH = 'gquilt_stock_new_patch'
STOCK_PATCH_GUARD = 'gquilt_stock_patch_guard'
STOCK_PATCH_GUARD_SELECT = 'gquilt_stock_patch_guard_select'
STOCK_REFRESH_PATCH = 'gquilt_stock_refresh_patch'

_STOCK_ITEMS_OWN_PNG = [
    (APPLIED_NOT_OK, 'Applied (needs refresh)', 0, 0, None),
    (APPLIED_OK, 'Applied', 0, 0, None),
    (DIFF, 'Diff', 0, 0, None),
    (IMPORT_PATCH, 'Import', 0, 0, None),
    (FINISH, 'Finish', 0, 0, None),
    (FOLD, 'Fold', 0, 0, None),
    (MELD, 'Meld', 0, 0, None),
    (POP, 'Pop', 0, 0, None),
    (PUSH, 'Push', 0, 0, None),
    (STOCK_NEW_PATCH, 'New', 0, 0, None),
    (STOCK_PATCH_GUARD, 'Guard', 0, 0, None),
    (STOCK_PATCH_GUARD_SELECT, 'Select', 0, 0, None),
    (STOCK_REFRESH_PATCH, 'Refresh', 0, 0, None),
    (TOP_OK, 'Top', 0, 0, None),
    (TOP_NOT_OK, 'Top (needs refresh)', 0, 0, None),
]

gtk.stock_add(_STOCK_ITEMS_OWN_PNG)

_FACTORY = gtk.IconFactory()
_FACTORY.add_default()

def _png_file_name(item_name):
    return os.path.join(_ICON_DIR, item_name[len('gquilt_'):] + os.extsep + 'png')

def make_pixbuf(name):
    return gtk.gdk.pixbuf_new_from_file(_png_file_name(name))

for _item in _STOCK_ITEMS_OWN_PNG:
    _name = _item[0]
    _FACTORY.add(_name, gtk.IconSet(make_pixbuf(_name)))

StockAlias = collections.namedtuple('StockAlias', ['name', 'alias', 'text'])

# Icons that are aliased to Gtk or other stock items
STOCK_DIFF = 'gquilt_stock_diff'
STOCK_INIT = 'gquilt_stock_init'
STOCK_INSERT = 'gwsmhg_stock_insert'
STOCK_NEW_PLAYGROUND = 'gquilt_stock_new_playground'
STOCK_SYNCH = 'gquilt_stock_synch'

_STOCK_ALIAS_LIST = [
    StockAlias(name=STOCK_DIFF, alias=DIFF, text='Diff'),
    StockAlias(name=STOCK_INIT, alias=APPLIED_OK, text='Init'),
    StockAlias(name=STOCK_INSERT, alias=gtk.STOCK_ADD, text='_Insert'),
    StockAlias(name=STOCK_NEW_PLAYGROUND, alias=gtk.STOCK_NEW, text='New Playground'),
    StockAlias(name=STOCK_SYNCH, alias=gtk.STOCK_REFRESH, text='Synchronize'),
]

_STYLE = gtk.Frame().get_style()

for _item in _STOCK_ALIAS_LIST:
    _FACTORY.add(_item.name, _STYLE.lookup_icon_set(_item.alias))

gtk.stock_add([(item.name, item.text, 0, 0, None) for item in _STOCK_ALIAS_LIST])
