#ifndef _QUIESCENSE_VIEWER_H
#define _QUIESCENSE_VIEWER_H
#include "boardAndListTabChild.h"
#include "osl/state/simpleState.h"
#include "osl/state/numEffectState.h"
#include "osl/search/simpleHashTable.h"
#include "osl/game_playing/gameState.h"

#include <boost/scoped_ptr.hpp>

namespace osl
{
  namespace search
  {
    class SimpleHashRecord;
    class SimpleHashTable;
  }
}

class QuiescenceItem;

class QuiescenceViewer : public BoardAndListTabChild
{
public:
  QuiescenceViewer(QWidget *parent = 0, const char *name = 0);
  bool analyze(const osl::state::SimpleState& s,
	       const osl::stl::vector<osl::Move>& moves);
  bool analyzeHalfDepth(const osl::state::SimpleState& s,
			const osl::stl::vector<osl::Move>& moves);
private:
  bool analyze(const osl::state::SimpleState& s,
	       const osl::stl::vector<osl::Move>& moves,
	       int depth);
  template <class Eval>
  void analyze(const osl::state::SimpleState& state,
	       const osl::Move last_move, int depth);
  boost::scoped_ptr<osl::search::SimpleHashTable> table;
};
#endif // _QUIESCENCE_VIEWER_H
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
