/* -*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 4 c-style: "K&R" -*- */

/*----------------------------------------------------------------------
 
  gpiv - Graphic program for Particle Image Velocimetry, based on gtk/gnome
          libraries.

   Copyright (C) 2007, 2008
   Gerber van der Graaf <gerber_graaf@users.sourceforge.net>

   This file is part of gpiv.

   Gpiv is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

----------------------------------------------------------------------*/

/*
 * (callback) functions for image processing
 * $Log: imgproc.h,v $
 * Revision 1.1  2008-09-16 11:04:47  gerber
 * added imgproc routines
 *
 */

#ifndef IMGPROC_H
#define IMGPROC_H

gchar *
set_imgproc_filtervar (GpivConsole *gpiv,
                       gint id,
                       gint value);

void
exec_imgproc (GpivConsole *gpiv);


/*
 * Callback functions
 */
void
on_button_filter_enter (GtkWidget *widget, 
                        gpointer data);

void
on_button_filter (GtkWidget *widget, 
                  gpointer data);


void
on_spinbutton_filtervar (GtkSpinButton *widget, 
                         GtkWidget *entry);

void 
on_button_imgproc_enter (GtkWidget *widget, 
                         gpointer data);

void
on_button_imgproc (GtkWidget *widget, 
                   gpointer data);

#endif /* IMGPROC_H */
