/*
 * Decompiled with CFR 0.152.
 */
package com.dsi.ant.plugins.antplus.pcc;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Message;
import android.os.Parcel;
import android.os.Parcelable;
import com.dsi.ant.plugins.antplus.common.AntFsCommon;
import com.dsi.ant.plugins.antplus.common.FitFileCommon;
import com.dsi.ant.plugins.antplus.pcc.defines.AntFsRequestStatus;
import com.dsi.ant.plugins.antplus.pcc.defines.AntFsState;
import com.dsi.ant.plugins.antplus.pccbase.AntPluginPcc;
import com.dsi.ant.plugins.antplus.pccbase.PccReleaseHandle;
import com.dsi.ant.plugins.utility.log.LogAnt;
import java.io.Serializable;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.Semaphore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntPlusWatchDownloaderPcc
extends AntPluginPcc {
    private static final String TAG = AntPlusWatchDownloaderPcc.class.getSimpleName();
    IAvailableDeviceListReceiver mAvailableDeviceListReceiver;
    DownloadRequestActivitiesInfo singleRequestReceiver;
    HashMap<UUID, DownloadRequestActivitiesInfo> mListenForNewActivitiesDeviceToReceiverMap = new HashMap();
    Semaphore mCommandLock = new Semaphore(1);

    @Override
    protected int getRequiredServiceVersionForBind() {
        return 10800;
    }

    public static PccReleaseHandle<AntPlusWatchDownloaderPcc> requestDeviceListAccess(Context bindToContext, AntPluginPcc.IPluginAccessResultReceiver<AntPlusWatchDownloaderPcc> resultReceiver, AntPluginPcc.IDeviceStateChangeReceiver stateReceiver, IAvailableDeviceListReceiver availableDeviceListRecevier) {
        Bundle b = new Bundle();
        b.putInt("int_RequestAccessMode", 300);
        AntPlusWatchDownloaderPcc possibleRetObj = new AntPlusWatchDownloaderPcc();
        possibleRetObj.mAvailableDeviceListReceiver = availableDeviceListRecevier;
        return AntPlusWatchDownloaderPcc.requestAccess_Helper_Main(bindToContext, b, possibleRetObj, new AntPluginPcc.RequestAccessResultHandler(), resultReceiver, stateReceiver);
    }

    private AntPlusWatchDownloaderPcc() {
    }

    @Override
    protected Intent getServiceBindIntent() {
        Intent it = new Intent();
        it.setComponent(new ComponentName("com.dsi.ant.plugins.antplus", "com.dsi.ant.plugins.antplus.watchcommunicator.WatchCommunicatorService"));
        return it;
    }

    @Override
    protected String getPluginPrintableName() {
        return "ANT+ Plugin: Watch Downloader";
    }

    @Override
    protected void handlePluginEvent(Message eventMsg) {
        switch (eventMsg.arg1) {
            case 201: {
                if (this.mAvailableDeviceListReceiver == null) break;
                Bundle b = eventMsg.getData();
                b.setClassLoader(this.getClass().getClassLoader());
                DeviceListUpdateCode updateCode = DeviceListUpdateCode.getValueFromInt(b.getInt("int_listUpdateCode"));
                Parcelable[] uncastDeviceInfos = b.getParcelableArray("arrayParcelable_deviceInfos");
                DeviceInfo[] deviceInfos = new DeviceInfo[uncastDeviceInfos.length];
                for (int i = 0; i < uncastDeviceInfos.length; ++i) {
                    deviceInfos[i] = (DeviceInfo)uncastDeviceInfos[i];
                }
                DeviceInfo deviceChanging = null;
                if (b.containsKey("parcelable_changingDeviceInfo")) {
                    deviceChanging = (DeviceInfo)b.getParcelable("parcelable_changingDeviceInfo");
                }
                this.mAvailableDeviceListReceiver.onNewAvailableDeviceList(updateCode, deviceInfos, deviceChanging);
                break;
            }
            case 190: 
            case 191: 
            case 202: {
                if (this.singleRequestReceiver == null) break;
                this.handleDownloadEvent(this.singleRequestReceiver, eventMsg.arg1, eventMsg.getData());
                if (eventMsg.arg1 != 202) break;
                this.singleRequestReceiver = null;
                this.mCommandLock.release();
                break;
            }
            case 203: {
                Bundle b = eventMsg.getData();
                UUID targetDevice = (UUID)b.getSerializable("uuid_targetDeviceUUID");
                DownloadRequestActivitiesInfo wi = this.mListenForNewActivitiesDeviceToReceiverMap.get(targetDevice);
                this.handleDownloadEvent(wi, eventMsg.arg2, b);
                break;
            }
            default: {
                LogAnt.d(TAG, "Unrecognized event received: " + eventMsg.arg1);
            }
        }
    }

    private void handleDownloadEvent(DownloadRequestActivitiesInfo requestInfo, int eventCode, Bundle data) {
        switch (eventCode) {
            case 202: {
                if (requestInfo.downloadActivitiesFinishedReceiver == null) break;
                AntFsRequestStatus statusCode = AntFsRequestStatus.getValueFromInt(data.getInt("int_statusCode"));
                requestInfo.downloadActivitiesFinishedReceiver.onNewDownloadActivitiesFinished(statusCode);
                break;
            }
            case 191: {
                if (requestInfo.fitFileDownloadedReceiver == null) break;
                byte[] fileBytes = data.getByteArray("arrayByte_rawFileBytes");
                requestInfo.fitFileDownloadedReceiver.onNewFitFileDownloaded(new FitFileCommon.FitFile(fileBytes));
                break;
            }
            case 190: {
                if (requestInfo.antFsProgressUpdateRecevier == null) break;
                AntFsState stateCode = AntFsState.getValueFromInt(data.getInt("int_stateCode"));
                long transferredBytes = data.getLong("long_transferredBytes");
                long totalBytes = data.getLong("long_totalBytes");
                requestInfo.antFsProgressUpdateRecevier.onNewAntFsProgressUpdate(stateCode, transferredBytes, totalBytes);
            }
        }
    }

    public void requestCurrentDeviceList() {
        Message cmdMsg = Message.obtain();
        cmdMsg.what = 20001;
        Message ret = this.sendPluginCommand(cmdMsg);
        if (ret == null) {
            LogAnt.e(TAG, "Cmd requestCurrentDeviceList died in sendPluginCommand()");
            return;
        }
        if (ret.arg1 != 0) {
            LogAnt.e(TAG, "Cmd requestCurrentDeviceList failed with code " + ret.arg1);
            throw new RuntimeException("requestCurrentDeviceList cmd failed internally");
        }
        ret.recycle();
    }

    public boolean requestDownloadAllActivities(UUID targetDeviceUUID, IDownloadActivitiesFinishedReceiver downloadActivitiesFinishedReceiver, FitFileCommon.IFitFileDownloadedReceiver fitFileDownloadedReceiver, AntFsCommon.IAntFsProgressUpdateReceiver antFsProgressUpdateRecevier) {
        if (!this.mCommandLock.tryAcquire()) {
            LogAnt.e(TAG, "Cmd failed to start because a local command is still processing.");
            return false;
        }
        this.singleRequestReceiver = new DownloadRequestActivitiesInfo(downloadActivitiesFinishedReceiver, fitFileDownloadedReceiver, antFsProgressUpdateRecevier);
        Message cmdMsg = Message.obtain();
        cmdMsg.what = 20002;
        Bundle params = new Bundle();
        cmdMsg.setData(params);
        params.putSerializable("uuid_targetDeviceUUID", (Serializable)targetDeviceUUID);
        params.putBoolean("bool_UseAntFsProgressUpdates", antFsProgressUpdateRecevier != null);
        Message ret = this.sendPluginCommand(cmdMsg);
        if (ret == null) {
            LogAnt.e(TAG, "Cmd requestDownloadAllActivities died in sendPluginCommand()");
            this.mCommandLock.release();
            return false;
        }
        if (ret.arg1 != 0) {
            LogAnt.e(TAG, "Cmd requestDownloadAllActivities failed with code " + ret.arg1);
            this.mCommandLock.release();
            return false;
        }
        ret.recycle();
        return true;
    }

    public boolean requestDownloadNewActivities(UUID targetDeviceUUID, IDownloadActivitiesFinishedReceiver downloadActivitiesFinishedReceiver, FitFileCommon.IFitFileDownloadedReceiver fitFileDownloadedReceiver, AntFsCommon.IAntFsProgressUpdateReceiver antFsProgressUpdateRecevier) {
        if (!this.mCommandLock.tryAcquire()) {
            LogAnt.e(TAG, "Cmd failed to start because a local command is still processing.");
            return false;
        }
        this.singleRequestReceiver = new DownloadRequestActivitiesInfo(downloadActivitiesFinishedReceiver, fitFileDownloadedReceiver, antFsProgressUpdateRecevier);
        Message cmdMsg = Message.obtain();
        cmdMsg.what = 20003;
        Bundle params = new Bundle();
        cmdMsg.setData(params);
        params.putSerializable("uuid_targetDeviceUUID", (Serializable)targetDeviceUUID);
        params.putBoolean("bool_UseAntFsProgressUpdates", antFsProgressUpdateRecevier != null);
        Message ret = this.sendPluginCommand(cmdMsg);
        if (ret == null) {
            LogAnt.e(TAG, "Cmd requestDownloadNewActivities died in sendPluginCommand()");
            this.mCommandLock.release();
            return false;
        }
        if (ret.arg1 != 0) {
            LogAnt.e(TAG, "Cmd requestDownloadNewActivities failed with code " + ret.arg1);
            this.mCommandLock.release();
            return false;
        }
        ret.recycle();
        return true;
    }

    public boolean listenForNewActivities(UUID targetDeviceUUID, IDownloadActivitiesFinishedReceiver downloadActivitiesFinishedReceiver, FitFileCommon.IFitFileDownloadedReceiver fitFileDownloadedReceiver) {
        DownloadRequestActivitiesInfo wi = new DownloadRequestActivitiesInfo(downloadActivitiesFinishedReceiver, fitFileDownloadedReceiver, null);
        Message cmdMsg = Message.obtain();
        cmdMsg.what = 20004;
        Bundle params = new Bundle();
        cmdMsg.setData(params);
        params.putSerializable("uuid_targetDeviceUUID", (Serializable)targetDeviceUUID);
        Message ret = this.sendPluginCommand(cmdMsg);
        if (ret == null) {
            LogAnt.e(TAG, "Cmd requestlistenForNewActivities died in sendPluginCommand()");
            return false;
        }
        if (ret.arg1 != 0) {
            LogAnt.e(TAG, "Cmd requestlistenForNewActivities failed with code " + ret.arg1);
            return false;
        }
        this.mListenForNewActivitiesDeviceToReceiverMap.put(targetDeviceUUID, wi);
        ret.recycle();
        return true;
    }

    public boolean cancelListenForNewActivities(UUID targetDeviceUUID) {
        Message ret;
        Message cmdMsg = Message.obtain();
        cmdMsg.what = 20005;
        Bundle params = new Bundle();
        cmdMsg.setData(params);
        if (targetDeviceUUID != null) {
            params.putSerializable("uuid_targetDeviceUUID", (Serializable)targetDeviceUUID);
        }
        if ((ret = this.sendPluginCommand(cmdMsg)) == null) {
            LogAnt.e(TAG, "Cmd cancelListenForNewActivities died in sendPluginCommand()");
            return false;
        }
        if (ret.arg1 != 0) {
            LogAnt.e(TAG, "Cmd cancelListenForNewActivities failed with code " + ret.arg1);
            return false;
        }
        if (targetDeviceUUID != null) {
            this.mListenForNewActivitiesDeviceToReceiverMap.remove(targetDeviceUUID);
        } else {
            this.mListenForNewActivitiesDeviceToReceiverMap.clear();
        }
        ret.recycle();
        return true;
    }

    private class DownloadRequestActivitiesInfo {
        public IDownloadActivitiesFinishedReceiver downloadActivitiesFinishedReceiver;
        public FitFileCommon.IFitFileDownloadedReceiver fitFileDownloadedReceiver;
        public AntFsCommon.IAntFsProgressUpdateReceiver antFsProgressUpdateRecevier;

        public DownloadRequestActivitiesInfo(IDownloadActivitiesFinishedReceiver downloadActivitiesFinishedReceiver, FitFileCommon.IFitFileDownloadedReceiver fitFileDownloadedReceiver, AntFsCommon.IAntFsProgressUpdateReceiver antFsProgressUpdateRecevier) {
            this.downloadActivitiesFinishedReceiver = downloadActivitiesFinishedReceiver;
            this.fitFileDownloadedReceiver = fitFileDownloadedReceiver;
            this.antFsProgressUpdateRecevier = antFsProgressUpdateRecevier;
        }
    }

    public static interface IDownloadActivitiesFinishedReceiver {
        public void onNewDownloadActivitiesFinished(AntFsRequestStatus var1);
    }

    public static interface IAvailableDeviceListReceiver {
        public void onNewAvailableDeviceList(DeviceListUpdateCode var1, DeviceInfo[] var2, DeviceInfo var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DeviceListUpdateCode {
        NO_CHANGE(0),
        DEVICE_ADDED_TO_LIST(10),
        DEVICE_REMOVED_FROM_LIST(20),
        UNRECOGNIZED(-1);

        private int intValue;

        private DeviceListUpdateCode(int intValue) {
            this.intValue = intValue;
        }

        public int getIntValue() {
            return this.intValue;
        }

        public static DeviceListUpdateCode getValueFromInt(int intValue) {
            for (DeviceListUpdateCode code : DeviceListUpdateCode.values()) {
                if (code.getIntValue() != intValue) continue;
                return code;
            }
            DeviceListUpdateCode unrecognized = UNRECOGNIZED;
            unrecognized.intValue = intValue;
            return unrecognized;
        }
    }

    public static class DeviceInfo
    implements Parcelable {
        private final int ipcVersionNumber;
        protected UUID deviceUUID;
        protected String savedDisplayName;
        protected int antFsManufacturerId;
        protected int antFsDeviceType;
        public static final Parcelable.Creator<DeviceInfo> CREATOR = new Parcelable.Creator<DeviceInfo>(){

            public DeviceInfo createFromParcel(Parcel in) {
                return new DeviceInfo(in);
            }

            public DeviceInfo[] newArray(int size) {
                return new DeviceInfo[size];
            }
        };

        public DeviceInfo(UUID deviceUUID, int antFsManufacturerId, int antFsDeviceType, String savedDisplayName) {
            this.ipcVersionNumber = 1;
            this.deviceUUID = deviceUUID;
            this.savedDisplayName = savedDisplayName;
            this.antFsManufacturerId = antFsManufacturerId;
            this.antFsDeviceType = antFsDeviceType;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.ipcVersionNumber);
            dest.writeSerializable((Serializable)this.deviceUUID);
            dest.writeString(this.savedDisplayName);
            dest.writeInt(this.antFsManufacturerId);
            dest.writeInt(this.antFsDeviceType);
        }

        private DeviceInfo(Parcel in) {
            this.ipcVersionNumber = 1;
            int incomingVersion = in.readInt();
            if (incomingVersion != 1) {
                LogAnt.i(TAG, "Decoding version " + incomingVersion + " DeviceInfo parcel with version 1 parser.");
            }
            this.deviceUUID = (UUID)in.readSerializable();
            this.savedDisplayName = in.readString();
            this.antFsManufacturerId = in.readInt();
            this.antFsDeviceType = in.readInt();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof DeviceInfo)) {
                return false;
            }
            return ((DeviceInfo)o).deviceUUID.equals(this.deviceUUID);
        }

        public UUID getDeviceUUID() {
            return this.deviceUUID;
        }

        public int getAntfsManufacturerId() {
            return this.antFsManufacturerId;
        }

        public int getAntfsDeviceType() {
            return this.antFsDeviceType;
        }

        public String getDisplayName() {
            return this.savedDisplayName;
        }
    }

    public class IpcDefines {
        public static final String PATH_ANTPLUS_WATCHDOWNLOADERPLUGIN_PKG = "com.dsi.ant.plugins.antplus";
        public static final String PATH_ANTPLUS_WATCHDOWNLOADERPLUGIN_SERVICE = "com.dsi.ant.plugins.antplus.watchcommunicator.WatchCommunicatorService";
        public static final int MSG_REQACC_PARAM_MODE_iSCANAVAILABLEDEVICES = 300;
        public static final int MSG_EVENT_WATCHDOWNLOADER_whatAVAILABLEDEVICELIST = 201;
        public static final String MSG_EVENT_WATCHDOWNLOADER_AVAILABLEDEVICELIST_PARAM_intLISTUPDATECODE = "int_listUpdateCode";
        public static final String MSG_EVENT_WATCHDOWNLOADER_AVAILABLEDEVICELIST_PARAM_arrayParcelableDEVICEINFOS = "arrayParcelable_deviceInfos";
        public static final String MSG_EVENT_WATCHDOWNLOADER_AVAILABLEDEVICELIST_PARAM_parcelableCHANGINGDEVICEINFO = "parcelable_changingDeviceInfo";
        public static final int MSG_EVENT_WATCHDOWNLOADER_whatDOWNLOADACTIVITIESFINISHED = 202;
        public static final String MSG_EVENT_WATCHDOWNLOADER_DOWNLOADACTIVITIESFINISHED_PARAM_intSTATUSCODE = "int_statusCode";
        public static final int MSG_EVENT_WATCHDOWNLOADER_whatLISTENFORNEWACTIVITIESDATA = 203;
        public static final String MSG_CMD_WATCHDOWNLOADER_DOWNLOADREQUEST_PARAM_uuidTARGETDEVICEUUID = "uuid_targetDeviceUUID";
        public static final int MSG_CMD_WATCHDOWNLOADER_whatREQUESTCURRENTDEVICELIST = 20001;
        public static final int MSG_CMD_WATCHDOWNLOADER_whatREQUESTDOWNLOADALLACTIVITIES = 20002;
        public static final int MSG_CMD_WATCHDOWNLOADER_whatREQUESTDOWNLOADNEWACTIVITIES = 20003;
        public static final int MSG_CMD_WATCHDOWNLOADER_whatLISTENFORNEWACTIVITIES = 20004;
        public static final int MSG_CMD_WATCHDOWNLOADER_whatCANCELLISTENFORNEWACTIVITIES = 20005;
    }
}

