// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/recommender/v1beta1/insight.proto

package recommender

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	duration "github.com/golang/protobuf/ptypes/duration"
	_struct "github.com/golang/protobuf/ptypes/struct"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Insight category.
type Insight_Category int32

const (
	// Unspecified category.
	Insight_CATEGORY_UNSPECIFIED Insight_Category = 0
	// The insight is related to cost.
	Insight_COST Insight_Category = 1
	// The insight is related to security.
	Insight_SECURITY Insight_Category = 2
	// The insight is related to performance.
	Insight_PERFORMANCE Insight_Category = 3
	// This insight is related to manageability.
	Insight_MANAGEABILITY Insight_Category = 4
)

var Insight_Category_name = map[int32]string{
	0: "CATEGORY_UNSPECIFIED",
	1: "COST",
	2: "SECURITY",
	3: "PERFORMANCE",
	4: "MANAGEABILITY",
}

var Insight_Category_value = map[string]int32{
	"CATEGORY_UNSPECIFIED": 0,
	"COST":                 1,
	"SECURITY":             2,
	"PERFORMANCE":          3,
	"MANAGEABILITY":        4,
}

func (x Insight_Category) String() string {
	return proto.EnumName(Insight_Category_name, int32(x))
}

func (Insight_Category) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_5d1881529c3c94a8, []int{0, 0}
}

// Represents insight state.
type InsightStateInfo_State int32

const (
	// Unspecified state.
	InsightStateInfo_STATE_UNSPECIFIED InsightStateInfo_State = 0
	// Insight is active. Content for ACTIVE insights can be updated by Google.
	// ACTIVE insights can be marked DISMISSED OR ACCEPTED.
	InsightStateInfo_ACTIVE InsightStateInfo_State = 1
	// Some action has been taken based on this insight. Insights become
	// accepted when a recommendation derived from the insight has been marked
	// CLAIMED, SUCCEEDED, or FAILED. ACTIVE insights can also be marked
	// ACCEPTED explicitly. Content for ACCEPTED insights is immutable. ACCEPTED
	// insights can only be marked ACCEPTED (which may update state metadata).
	InsightStateInfo_ACCEPTED InsightStateInfo_State = 2
	// Insight is dismissed. Content for DISMISSED insights can be updated by
	// Google. DISMISSED insights can be marked as ACTIVE.
	InsightStateInfo_DISMISSED InsightStateInfo_State = 3
)

var InsightStateInfo_State_name = map[int32]string{
	0: "STATE_UNSPECIFIED",
	1: "ACTIVE",
	2: "ACCEPTED",
	3: "DISMISSED",
}

var InsightStateInfo_State_value = map[string]int32{
	"STATE_UNSPECIFIED": 0,
	"ACTIVE":            1,
	"ACCEPTED":          2,
	"DISMISSED":         3,
}

func (x InsightStateInfo_State) String() string {
	return proto.EnumName(InsightStateInfo_State_name, int32(x))
}

func (InsightStateInfo_State) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_5d1881529c3c94a8, []int{1, 0}
}

// An insight along with the information used to derive the insight. The insight
// may have associated recomendations as well.
type Insight struct {
	// Name of the insight.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Free-form human readable summary in English. The maximum length is 500
	// characters.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Fully qualified resource names that this insight is targeting.
	TargetResources []string `protobuf:"bytes,9,rep,name=target_resources,json=targetResources,proto3" json:"target_resources,omitempty"`
	// Insight subtype. Insight content schema will be stable for a given subtype.
	InsightSubtype string `protobuf:"bytes,10,opt,name=insight_subtype,json=insightSubtype,proto3" json:"insight_subtype,omitempty"`
	// A struct of custom fields to explain the insight.
	// Example: "grantedPermissionsCount": "1000"
	Content *_struct.Struct `protobuf:"bytes,3,opt,name=content,proto3" json:"content,omitempty"`
	// Timestamp of the latest data used to generate the insight.
	LastRefreshTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=last_refresh_time,json=lastRefreshTime,proto3" json:"last_refresh_time,omitempty"`
	// Observation period that led to the insight. The source data used to
	// generate the insight ends at last_refresh_time and begins at
	// (last_refresh_time - observation_period).
	ObservationPeriod *duration.Duration `protobuf:"bytes,5,opt,name=observation_period,json=observationPeriod,proto3" json:"observation_period,omitempty"`
	// Information state and metadata.
	StateInfo *InsightStateInfo `protobuf:"bytes,6,opt,name=state_info,json=stateInfo,proto3" json:"state_info,omitempty"`
	// Category being targeted by the insight.
	Category Insight_Category `protobuf:"varint,7,opt,name=category,proto3,enum=google.cloud.recommender.v1beta1.Insight_Category" json:"category,omitempty"`
	// Fingerprint of the Insight. Provides optimistic locking when updating
	// states.
	Etag string `protobuf:"bytes,11,opt,name=etag,proto3" json:"etag,omitempty"`
	// Recommendations derived from this insight.
	AssociatedRecommendations []*Insight_RecommendationReference `protobuf:"bytes,8,rep,name=associated_recommendations,json=associatedRecommendations,proto3" json:"associated_recommendations,omitempty"`
	XXX_NoUnkeyedLiteral      struct{}                           `json:"-"`
	XXX_unrecognized          []byte                             `json:"-"`
	XXX_sizecache             int32                              `json:"-"`
}

func (m *Insight) Reset()         { *m = Insight{} }
func (m *Insight) String() string { return proto.CompactTextString(m) }
func (*Insight) ProtoMessage()    {}
func (*Insight) Descriptor() ([]byte, []int) {
	return fileDescriptor_5d1881529c3c94a8, []int{0}
}

func (m *Insight) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Insight.Unmarshal(m, b)
}
func (m *Insight) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Insight.Marshal(b, m, deterministic)
}
func (m *Insight) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Insight.Merge(m, src)
}
func (m *Insight) XXX_Size() int {
	return xxx_messageInfo_Insight.Size(m)
}
func (m *Insight) XXX_DiscardUnknown() {
	xxx_messageInfo_Insight.DiscardUnknown(m)
}

var xxx_messageInfo_Insight proto.InternalMessageInfo

func (m *Insight) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Insight) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Insight) GetTargetResources() []string {
	if m != nil {
		return m.TargetResources
	}
	return nil
}

func (m *Insight) GetInsightSubtype() string {
	if m != nil {
		return m.InsightSubtype
	}
	return ""
}

func (m *Insight) GetContent() *_struct.Struct {
	if m != nil {
		return m.Content
	}
	return nil
}

func (m *Insight) GetLastRefreshTime() *timestamp.Timestamp {
	if m != nil {
		return m.LastRefreshTime
	}
	return nil
}

func (m *Insight) GetObservationPeriod() *duration.Duration {
	if m != nil {
		return m.ObservationPeriod
	}
	return nil
}

func (m *Insight) GetStateInfo() *InsightStateInfo {
	if m != nil {
		return m.StateInfo
	}
	return nil
}

func (m *Insight) GetCategory() Insight_Category {
	if m != nil {
		return m.Category
	}
	return Insight_CATEGORY_UNSPECIFIED
}

func (m *Insight) GetEtag() string {
	if m != nil {
		return m.Etag
	}
	return ""
}

func (m *Insight) GetAssociatedRecommendations() []*Insight_RecommendationReference {
	if m != nil {
		return m.AssociatedRecommendations
	}
	return nil
}

// Reference to an associated recommendation.
type Insight_RecommendationReference struct {
	// Recommendation resource name, e.g.
	// projects/[PROJECT_NUMBER]/locations/[LOCATION]/recommenders/[RECOMMENDER_ID]/recommendations/[RECOMMENDATION_ID]
	Recommendation       string   `protobuf:"bytes,1,opt,name=recommendation,proto3" json:"recommendation,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Insight_RecommendationReference) Reset()         { *m = Insight_RecommendationReference{} }
func (m *Insight_RecommendationReference) String() string { return proto.CompactTextString(m) }
func (*Insight_RecommendationReference) ProtoMessage()    {}
func (*Insight_RecommendationReference) Descriptor() ([]byte, []int) {
	return fileDescriptor_5d1881529c3c94a8, []int{0, 0}
}

func (m *Insight_RecommendationReference) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Insight_RecommendationReference.Unmarshal(m, b)
}
func (m *Insight_RecommendationReference) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Insight_RecommendationReference.Marshal(b, m, deterministic)
}
func (m *Insight_RecommendationReference) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Insight_RecommendationReference.Merge(m, src)
}
func (m *Insight_RecommendationReference) XXX_Size() int {
	return xxx_messageInfo_Insight_RecommendationReference.Size(m)
}
func (m *Insight_RecommendationReference) XXX_DiscardUnknown() {
	xxx_messageInfo_Insight_RecommendationReference.DiscardUnknown(m)
}

var xxx_messageInfo_Insight_RecommendationReference proto.InternalMessageInfo

func (m *Insight_RecommendationReference) GetRecommendation() string {
	if m != nil {
		return m.Recommendation
	}
	return ""
}

// Information related to insight state.
type InsightStateInfo struct {
	// Insight state.
	State InsightStateInfo_State `protobuf:"varint,1,opt,name=state,proto3,enum=google.cloud.recommender.v1beta1.InsightStateInfo_State" json:"state,omitempty"`
	// A map of metadata for the state, provided by user or automations systems.
	StateMetadata        map[string]string `protobuf:"bytes,2,rep,name=state_metadata,json=stateMetadata,proto3" json:"state_metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *InsightStateInfo) Reset()         { *m = InsightStateInfo{} }
func (m *InsightStateInfo) String() string { return proto.CompactTextString(m) }
func (*InsightStateInfo) ProtoMessage()    {}
func (*InsightStateInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_5d1881529c3c94a8, []int{1}
}

func (m *InsightStateInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_InsightStateInfo.Unmarshal(m, b)
}
func (m *InsightStateInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_InsightStateInfo.Marshal(b, m, deterministic)
}
func (m *InsightStateInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InsightStateInfo.Merge(m, src)
}
func (m *InsightStateInfo) XXX_Size() int {
	return xxx_messageInfo_InsightStateInfo.Size(m)
}
func (m *InsightStateInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_InsightStateInfo.DiscardUnknown(m)
}

var xxx_messageInfo_InsightStateInfo proto.InternalMessageInfo

func (m *InsightStateInfo) GetState() InsightStateInfo_State {
	if m != nil {
		return m.State
	}
	return InsightStateInfo_STATE_UNSPECIFIED
}

func (m *InsightStateInfo) GetStateMetadata() map[string]string {
	if m != nil {
		return m.StateMetadata
	}
	return nil
}

func init() {
	proto.RegisterEnum("google.cloud.recommender.v1beta1.Insight_Category", Insight_Category_name, Insight_Category_value)
	proto.RegisterEnum("google.cloud.recommender.v1beta1.InsightStateInfo_State", InsightStateInfo_State_name, InsightStateInfo_State_value)
	proto.RegisterType((*Insight)(nil), "google.cloud.recommender.v1beta1.Insight")
	proto.RegisterType((*Insight_RecommendationReference)(nil), "google.cloud.recommender.v1beta1.Insight.RecommendationReference")
	proto.RegisterType((*InsightStateInfo)(nil), "google.cloud.recommender.v1beta1.InsightStateInfo")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.recommender.v1beta1.InsightStateInfo.StateMetadataEntry")
}

func init() {
	proto.RegisterFile("google/cloud/recommender/v1beta1/insight.proto", fileDescriptor_5d1881529c3c94a8)
}

var fileDescriptor_5d1881529c3c94a8 = []byte{
	// 815 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x55, 0xe1, 0x6e, 0xe3, 0x44,
	0x10, 0x26, 0x4e, 0xda, 0x26, 0x13, 0x9a, 0xba, 0xab, 0x43, 0xe7, 0x46, 0x08, 0xa2, 0x08, 0x1d,
	0xe1, 0x8f, 0xad, 0x96, 0x3f, 0xa7, 0xe3, 0x0f, 0xae, 0xe3, 0x16, 0x0b, 0x92, 0x86, 0xb5, 0xaf,
	0xd2, 0xf1, 0x27, 0x6c, 0x9c, 0x8d, 0xcf, 0x10, 0x7b, 0x2d, 0xef, 0xa6, 0x52, 0x54, 0x2a, 0x78,
	0x03, 0xde, 0x81, 0x9f, 0x3c, 0x01, 0xef, 0xc2, 0x1b, 0xdc, 0x53, 0x20, 0xaf, 0xd7, 0x6d, 0x9a,
	0xea, 0x54, 0x8a, 0xf8, 0x37, 0x9e, 0x99, 0xef, 0x9b, 0x9d, 0xf9, 0x66, 0xd7, 0x60, 0x46, 0x8c,
	0x45, 0x4b, 0x6a, 0x85, 0x4b, 0xb6, 0x9a, 0x5b, 0x39, 0x0d, 0x59, 0x92, 0xd0, 0x74, 0x4e, 0x73,
	0xeb, 0xea, 0x78, 0x46, 0x05, 0x39, 0xb6, 0xe2, 0x94, 0xc7, 0xd1, 0x5b, 0x61, 0x66, 0x39, 0x13,
	0x0c, 0xf5, 0xca, 0x7c, 0x53, 0xe6, 0x9b, 0x1b, 0xf9, 0xa6, 0xca, 0xef, 0x1e, 0x29, 0x46, 0x92,
	0xc5, 0x56, 0x4e, 0x39, 0x5b, 0xe5, 0x21, 0x2d, 0xc1, 0xdd, 0x4f, 0x54, 0x48, 0x7e, 0xcd, 0x56,
	0x0b, 0x6b, 0xbe, 0xca, 0x89, 0x88, 0x59, 0xaa, 0xe2, 0x1f, 0x6f, 0xc7, 0xb9, 0xc8, 0x57, 0xa1,
	0x2a, 0xdd, 0xfd, 0x74, 0x3b, 0x2a, 0xe2, 0x84, 0x72, 0x41, 0x92, 0xac, 0x4c, 0xe8, 0xff, 0xb5,
	0x07, 0x7b, 0x5e, 0x79, 0x5a, 0x84, 0xa0, 0x91, 0x92, 0x84, 0x1a, 0xb5, 0x5e, 0x6d, 0xd0, 0xc2,
	0xd2, 0x46, 0x3d, 0x68, 0xcf, 0x29, 0x0f, 0xf3, 0x38, 0x2b, 0x6a, 0x1a, 0x9a, 0x0c, 0x6d, 0xba,
	0xd0, 0x17, 0xa0, 0x0b, 0x92, 0x47, 0x54, 0x4c, 0xab, 0x93, 0x73, 0xa3, 0xd5, 0xab, 0x0f, 0x5a,
	0xf8, 0xa0, 0xf4, 0xe3, 0xca, 0x8d, 0x3e, 0x87, 0x03, 0x35, 0x99, 0x29, 0x5f, 0xcd, 0xc4, 0x3a,
	0xa3, 0x06, 0x48, 0xc2, 0x8e, 0x72, 0xfb, 0xa5, 0x17, 0x1d, 0xc3, 0x5e, 0xc8, 0x52, 0x41, 0x53,
	0x61, 0xd4, 0x7b, 0xb5, 0x41, 0xfb, 0xe4, 0xb9, 0x9a, 0xb9, 0x59, 0x35, 0x62, 0xfa, 0xb2, 0x4d,
	0x5c, 0xe5, 0xa1, 0x33, 0x38, 0x5c, 0x12, 0x5e, 0x1c, 0x62, 0x91, 0x53, 0xfe, 0x76, 0x5a, 0x34,
	0x6a, 0x34, 0x24, 0xb8, 0xfb, 0x00, 0x1c, 0x54, 0x53, 0xc0, 0x07, 0x05, 0x08, 0x97, 0x98, 0xc2,
	0x8b, 0xbe, 0x01, 0xc4, 0x66, 0x9c, 0xe6, 0x57, 0x72, 0xc8, 0xd3, 0x8c, 0xe6, 0x31, 0x9b, 0x1b,
	0x3b, 0x92, 0xe8, 0xe8, 0x01, 0xd1, 0x50, 0x89, 0x81, 0x0f, 0x37, 0x40, 0x13, 0x89, 0x41, 0xdf,
	0x03, 0x70, 0x41, 0x04, 0x9d, 0xc6, 0xe9, 0x82, 0x19, 0xbb, 0x92, 0xe1, 0xc4, 0x7c, 0x6c, 0x17,
	0x4c, 0xa5, 0x86, 0x5f, 0x40, 0xbd, 0x74, 0xc1, 0x70, 0x8b, 0x57, 0x26, 0x1a, 0x43, 0x33, 0x24,
	0x82, 0x46, 0x2c, 0x5f, 0x1b, 0x7b, 0xbd, 0xda, 0xa0, 0xf3, 0x04, 0x42, 0xd3, 0x51, 0x48, 0x7c,
	0xcb, 0x51, 0x28, 0x4e, 0x05, 0x89, 0x8c, 0x76, 0xa9, 0x78, 0x61, 0xa3, 0xdf, 0x6a, 0xd0, 0x25,
	0x9c, 0xb3, 0x30, 0x26, 0x82, 0xce, 0xa7, 0xb7, 0x8c, 0xb2, 0x35, 0x6e, 0x34, 0x7b, 0xf5, 0x41,
	0xfb, 0xc4, 0xfe, 0xf7, 0x65, 0xf1, 0x3d, 0x02, 0x4c, 0x17, 0x34, 0xa7, 0x69, 0x48, 0xf1, 0xd1,
	0x5d, 0x91, 0xfb, 0x29, 0xbc, 0x6b, 0xc3, 0xf3, 0xf7, 0xa0, 0xd0, 0x0b, 0xe8, 0xdc, 0x3f, 0x91,
	0xda, 0xd6, 0x2d, 0x6f, 0xff, 0x47, 0x68, 0x56, 0xfd, 0x22, 0x03, 0x9e, 0x39, 0x76, 0xe0, 0x9e,
	0x5f, 0xe0, 0x37, 0xd3, 0xd7, 0x63, 0x7f, 0xe2, 0x3a, 0xde, 0x99, 0xe7, 0x0e, 0xf5, 0x0f, 0x50,
	0x13, 0x1a, 0xce, 0x85, 0x1f, 0xe8, 0x35, 0xf4, 0x21, 0x34, 0x7d, 0xd7, 0x79, 0x8d, 0xbd, 0xe0,
	0x8d, 0xae, 0xa1, 0x03, 0x68, 0x4f, 0x5c, 0x7c, 0x76, 0x81, 0x47, 0xf6, 0xd8, 0x71, 0xf5, 0x3a,
	0x3a, 0x84, 0xfd, 0x91, 0x3d, 0xb6, 0xcf, 0x5d, 0xfb, 0xd4, 0xfb, 0xae, 0xc8, 0x69, 0xbc, 0xfa,
	0xf5, 0x9d, 0xfd, 0x0b, 0xf4, 0x37, 0x3b, 0x2f, 0x47, 0x42, 0xb2, 0x98, 0x9b, 0x21, 0x4b, 0xac,
	0xea, 0x5a, 0x5d, 0x66, 0x39, 0xfb, 0x89, 0x86, 0x82, 0x5b, 0xd7, 0xca, 0xba, 0xb1, 0x96, 0x2c,
	0x2c, 0x7b, 0xb5, 0xae, 0x2b, 0xf3, 0xa6, 0x7a, 0x35, 0x82, 0x75, 0x46, 0xb9, 0x75, 0x5d, 0xdd,
	0x94, 0xe2, 0x42, 0xdc, 0xc6, 0xee, 0xfc, 0x37, 0xfd, 0xbf, 0x35, 0xd0, 0xb7, 0x97, 0x05, 0x8d,
	0x61, 0x47, 0xae, 0x8b, 0x1c, 0x4b, 0xe7, 0xe4, 0xe5, 0xd3, 0xf7, 0xcd, 0x94, 0x16, 0x2e, 0x69,
	0xd0, 0x12, 0x3a, 0xe5, 0x12, 0x27, 0x54, 0x90, 0x39, 0x11, 0xc4, 0xd0, 0xe4, 0x02, 0xb8, 0xff,
	0x95, 0x78, 0xa4, 0x78, 0xdc, 0x54, 0xe4, 0x6b, 0xbc, 0xcf, 0x37, 0x7d, 0xdd, 0xaf, 0x01, 0x3d,
	0x4c, 0x42, 0x3a, 0xd4, 0x7f, 0xa6, 0x6b, 0x25, 0x74, 0x61, 0xa2, 0x67, 0xb0, 0x73, 0x45, 0x96,
	0x2b, 0xaa, 0xde, 0xa3, 0xf2, 0xe3, 0x95, 0xf6, 0xb2, 0xd6, 0x3f, 0x87, 0x1d, 0xc9, 0x80, 0x3e,
	0x82, 0x43, 0x3f, 0xb0, 0x03, 0x77, 0x4b, 0x71, 0x80, 0x5d, 0xdb, 0x09, 0xbc, 0x4b, 0xb7, 0xd4,
	0xdc, 0x76, 0x1c, 0x77, 0x12, 0xb8, 0x43, 0x5d, 0x43, 0xfb, 0xd0, 0x1a, 0x7a, 0xfe, 0xc8, 0xf3,
	0x7d, 0x77, 0xa8, 0xd7, 0x4f, 0x7f, 0xd7, 0xde, 0xd9, 0x09, 0xbc, 0x78, 0x5c, 0xdf, 0x42, 0x2e,
	0xe4, 0xfc, 0x0f, 0x1a, 0xc3, 0x67, 0x21, 0x4b, 0x1e, 0x1d, 0xeb, 0xa4, 0xf6, 0xc3, 0xb7, 0x2a,
	0x27, 0x62, 0x4b, 0x92, 0x46, 0x26, 0xcb, 0x23, 0x2b, 0xa2, 0xa9, 0x7c, 0x93, 0xac, 0xbb, 0x33,
	0xbe, 0xff, 0xf7, 0xf4, 0xd5, 0x86, 0xef, 0x0f, 0xad, 0xe1, 0x60, 0xd7, 0xf9, 0x53, 0xeb, 0x9d,
	0x97, 0xa4, 0x8e, 0x2c, 0x8c, 0x37, 0x0a, 0x5f, 0x1e, 0x9f, 0x16, 0xa8, 0xd9, 0xae, 0xac, 0xf0,
	0xe5, 0x3f, 0x01, 0x00, 0x00, 0xff, 0xff, 0x68, 0x6e, 0x61, 0x54, 0xff, 0x06, 0x00, 0x00,
}
