/**
 * Go SDK for OpenFGA
 *
 * API version: 0.1
 * Website: https://openfga.dev
 * Documentation: https://openfga.dev/docs
 * Support: https://discord.gg/8naAwJfWN6
 * License: [Apache-2.0](https://github.com/openfga/go-sdk/blob/main/LICENSE)
 *
 * NOTE: This file was auto generated by OpenAPI Generator (https://openapi-generator.tech). DO NOT EDIT.
 */

package openfga

import (
	"bytes"

	"encoding/json"
)

// CheckRequestTupleKey struct for CheckRequestTupleKey
type CheckRequestTupleKey struct {
	User     string `json:"user"yaml:"user"`
	Relation string `json:"relation"yaml:"relation"`
	Object   string `json:"object"yaml:"object"`
}

// NewCheckRequestTupleKey instantiates a new CheckRequestTupleKey object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewCheckRequestTupleKey(user string, relation string, object string) *CheckRequestTupleKey {
	this := CheckRequestTupleKey{}
	this.User = user
	this.Relation = relation
	this.Object = object
	return &this
}

// NewCheckRequestTupleKeyWithDefaults instantiates a new CheckRequestTupleKey object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewCheckRequestTupleKeyWithDefaults() *CheckRequestTupleKey {
	this := CheckRequestTupleKey{}
	return &this
}

// GetUser returns the User field value
func (o *CheckRequestTupleKey) GetUser() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.User
}

// GetUserOk returns a tuple with the User field value
// and a boolean to check if the value has been set.
func (o *CheckRequestTupleKey) GetUserOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.User, true
}

// SetUser sets field value
func (o *CheckRequestTupleKey) SetUser(v string) {
	o.User = v
}

// GetRelation returns the Relation field value
func (o *CheckRequestTupleKey) GetRelation() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Relation
}

// GetRelationOk returns a tuple with the Relation field value
// and a boolean to check if the value has been set.
func (o *CheckRequestTupleKey) GetRelationOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Relation, true
}

// SetRelation sets field value
func (o *CheckRequestTupleKey) SetRelation(v string) {
	o.Relation = v
}

// GetObject returns the Object field value
func (o *CheckRequestTupleKey) GetObject() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Object
}

// GetObjectOk returns a tuple with the Object field value
// and a boolean to check if the value has been set.
func (o *CheckRequestTupleKey) GetObjectOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Object, true
}

// SetObject sets field value
func (o *CheckRequestTupleKey) SetObject(v string) {
	o.Object = v
}

func (o CheckRequestTupleKey) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["user"] = o.User
	toSerialize["relation"] = o.Relation
	toSerialize["object"] = o.Object
	var b bytes.Buffer
	enc := json.NewEncoder(&b)
	enc.SetEscapeHTML(false)
	err := enc.Encode(toSerialize)
	if err != nil {
		return nil, err
	}
	return b.Bytes(), nil
}

type NullableCheckRequestTupleKey struct {
	value *CheckRequestTupleKey
	isSet bool
}

func (v NullableCheckRequestTupleKey) Get() *CheckRequestTupleKey {
	return v.value
}

func (v *NullableCheckRequestTupleKey) Set(val *CheckRequestTupleKey) {
	v.value = val
	v.isSet = true
}

func (v NullableCheckRequestTupleKey) IsSet() bool {
	return v.isSet
}

func (v *NullableCheckRequestTupleKey) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableCheckRequestTupleKey(val *CheckRequestTupleKey) *NullableCheckRequestTupleKey {
	return &NullableCheckRequestTupleKey{value: val, isSet: true}
}

func (v NullableCheckRequestTupleKey) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableCheckRequestTupleKey) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
