// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package bedrockagentruntime

import (
	"bytes"
	"fmt"
	"io"
	"sync"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awserr"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/client"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/eventstream"
	"github.com/aws/aws-sdk-go/private/protocol/eventstream/eventstreamapi"
	"github.com/aws/aws-sdk-go/private/protocol/rest"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opInvokeAgent = "InvokeAgent"

// InvokeAgentRequest generates a "aws/request.Request" representing the
// client's request for the InvokeAgent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See InvokeAgent for more information on using the InvokeAgent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the InvokeAgentRequest method.
//	req, resp := client.InvokeAgentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/InvokeAgent
func (c *BedrockAgentRuntime) InvokeAgentRequest(input *InvokeAgentInput) (req *request.Request, output *InvokeAgentOutput) {
	op := &request.Operation{
		Name:       opInvokeAgent,
		HTTPMethod: "POST",
		HTTPPath:   "/agents/{agentId}/agentAliases/{agentAliasId}/sessions/{sessionId}/text",
	}

	if input == nil {
		input = &InvokeAgentInput{}
	}

	output = &InvokeAgentOutput{}
	req = c.newRequest(op, input, output)

	es := NewInvokeAgentEventStream()
	output.eventStream = es

	req.Handlers.Send.Swap(client.LogHTTPResponseHandler.Name, client.LogHTTPResponseHeaderHandler)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, rest.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBack(es.runOutputStream)
	req.Handlers.Unmarshal.PushBack(es.runOnStreamPartClose)
	return
}

// InvokeAgent API operation for Agents for Amazon Bedrock Runtime.
//
// Invokes the specified Bedrock model to run inference using the input provided
// in the request body.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock Runtime's
// API operation InvokeAgent for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     This exception is thrown when there is a conflict performing an operation
//
//   - ResourceNotFoundException
//     This exception is thrown when a resource referenced by the operation does
//     not exist
//
//   - ValidationException
//     This exception is thrown when the request's input validation fails
//
//   - InternalServerException
//     This exception is thrown if there was an unexpected error during processing
//     of request
//
//   - DependencyFailedException
//     This exception is thrown when a request fails due to dependency like Lambda,
//     Bedrock, STS resource due to a customer fault (i.e. bad configuration)
//
//   - BadGatewayException
//     This exception is thrown when a request fails due to dependency like Lambda,
//     Bedrock, STS resource
//
//   - ThrottlingException
//     This exception is thrown when the number of requests exceeds the limit
//
//   - AccessDeniedException
//     This exception is thrown when a request is denied per access permissions
//
//   - ServiceQuotaExceededException
//     This exception is thrown when a request is made beyond the service quota
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/InvokeAgent
func (c *BedrockAgentRuntime) InvokeAgent(input *InvokeAgentInput) (*InvokeAgentOutput, error) {
	req, out := c.InvokeAgentRequest(input)
	return out, req.Send()
}

// InvokeAgentWithContext is the same as InvokeAgent with the addition of
// the ability to pass a context and additional request options.
//
// See InvokeAgent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgentRuntime) InvokeAgentWithContext(ctx aws.Context, input *InvokeAgentInput, opts ...request.Option) (*InvokeAgentOutput, error) {
	req, out := c.InvokeAgentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

var _ awserr.Error
var _ time.Time

// InvokeAgentEventStream provides the event stream handling for the InvokeAgent.
//
// For testing and mocking the event stream this type should be initialized via
// the NewInvokeAgentEventStream constructor function. Using the functional options
// to pass in nested mock behavior.
type InvokeAgentEventStream struct {

	// Reader is the EventStream reader for the ResponseStream
	// events. This value is automatically set by the SDK when the API call is made
	// Use this member when unit testing your code with the SDK to mock out the
	// EventStream Reader.
	//
	// Must not be nil.
	Reader ResponseStreamReader

	outputReader io.ReadCloser

	done      chan struct{}
	closeOnce sync.Once
	err       *eventstreamapi.OnceError
}

// NewInvokeAgentEventStream initializes an InvokeAgentEventStream.
// This function should only be used for testing and mocking the InvokeAgentEventStream
// stream within your application.
//
// The Reader member must be set before reading events from the stream.
//
//	es := NewInvokeAgentEventStream(func(o *InvokeAgentEventStream){
//	    es.Reader = myMockStreamReader
//	})
func NewInvokeAgentEventStream(opts ...func(*InvokeAgentEventStream)) *InvokeAgentEventStream {
	es := &InvokeAgentEventStream{
		done: make(chan struct{}),
		err:  eventstreamapi.NewOnceError(),
	}

	for _, fn := range opts {
		fn(es)
	}

	return es
}

func (es *InvokeAgentEventStream) runOnStreamPartClose(r *request.Request) {
	if es.done == nil {
		return
	}
	go es.waitStreamPartClose()

}

func (es *InvokeAgentEventStream) waitStreamPartClose() {
	var outputErrCh <-chan struct{}
	if v, ok := es.Reader.(interface{ ErrorSet() <-chan struct{} }); ok {
		outputErrCh = v.ErrorSet()
	}
	var outputClosedCh <-chan struct{}
	if v, ok := es.Reader.(interface{ Closed() <-chan struct{} }); ok {
		outputClosedCh = v.Closed()
	}

	select {
	case <-es.done:
	case <-outputErrCh:
		es.err.SetError(es.Reader.Err())
		es.Close()
	case <-outputClosedCh:
		if err := es.Reader.Err(); err != nil {
			es.err.SetError(es.Reader.Err())
		}
		es.Close()
	}
}

// Events returns a channel to read events from.
//
// These events are:
//
//   - PayloadPart
//   - TracePart
//   - ResponseStreamUnknownEvent
func (es *InvokeAgentEventStream) Events() <-chan ResponseStreamEvent {
	return es.Reader.Events()
}

func (es *InvokeAgentEventStream) runOutputStream(r *request.Request) {
	var opts []func(*eventstream.Decoder)
	if r.Config.Logger != nil && r.Config.LogLevel.Matches(aws.LogDebugWithEventStreamBody) {
		opts = append(opts, eventstream.DecodeWithLogger(r.Config.Logger))
	}

	unmarshalerForEvent := unmarshalerForResponseStreamEvent{
		metadata: protocol.ResponseMetadata{
			StatusCode: r.HTTPResponse.StatusCode,
			RequestID:  r.RequestID,
		},
	}.UnmarshalerForEventName

	decoder := eventstream.NewDecoder(r.HTTPResponse.Body, opts...)
	eventReader := eventstreamapi.NewEventReader(decoder,
		protocol.HandlerPayloadUnmarshal{
			Unmarshalers: r.Handlers.UnmarshalStream,
		},
		unmarshalerForEvent,
	)

	es.outputReader = r.HTTPResponse.Body
	es.Reader = newReadResponseStream(eventReader)
}

// Close closes the stream. This will also cause the stream to be closed.
// Close must be called when done using the stream API. Not calling Close
// may result in resource leaks.
//
// You can use the closing of the Reader's Events channel to terminate your
// application's read from the API's stream.
func (es *InvokeAgentEventStream) Close() (err error) {
	es.closeOnce.Do(es.safeClose)
	return es.Err()
}

func (es *InvokeAgentEventStream) safeClose() {
	if es.done != nil {
		close(es.done)
	}

	es.Reader.Close()
	if es.outputReader != nil {
		es.outputReader.Close()
	}
}

// Err returns any error that occurred while reading or writing EventStream
// Events from the service API's response. Returns nil if there were no errors.
func (es *InvokeAgentEventStream) Err() error {
	if err := es.err.Err(); err != nil {
		return err
	}
	if err := es.Reader.Err(); err != nil {
		return err
	}

	return nil
}

const opRetrieve = "Retrieve"

// RetrieveRequest generates a "aws/request.Request" representing the
// client's request for the Retrieve operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See Retrieve for more information on using the Retrieve
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RetrieveRequest method.
//	req, resp := client.RetrieveRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/Retrieve
func (c *BedrockAgentRuntime) RetrieveRequest(input *RetrieveInput) (req *request.Request, output *RetrieveOutput) {
	op := &request.Operation{
		Name:       opRetrieve,
		HTTPMethod: "POST",
		HTTPPath:   "/knowledgebases/{knowledgeBaseId}/retrieve",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &RetrieveInput{}
	}

	output = &RetrieveOutput{}
	req = c.newRequest(op, input, output)
	return
}

// Retrieve API operation for Agents for Amazon Bedrock Runtime.
//
// Retrieve from knowledge base.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock Runtime's
// API operation Retrieve for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     This exception is thrown when there is a conflict performing an operation
//
//   - ResourceNotFoundException
//     This exception is thrown when a resource referenced by the operation does
//     not exist
//
//   - ValidationException
//     This exception is thrown when the request's input validation fails
//
//   - InternalServerException
//     This exception is thrown if there was an unexpected error during processing
//     of request
//
//   - DependencyFailedException
//     This exception is thrown when a request fails due to dependency like Lambda,
//     Bedrock, STS resource due to a customer fault (i.e. bad configuration)
//
//   - BadGatewayException
//     This exception is thrown when a request fails due to dependency like Lambda,
//     Bedrock, STS resource
//
//   - ThrottlingException
//     This exception is thrown when the number of requests exceeds the limit
//
//   - AccessDeniedException
//     This exception is thrown when a request is denied per access permissions
//
//   - ServiceQuotaExceededException
//     This exception is thrown when a request is made beyond the service quota
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/Retrieve
func (c *BedrockAgentRuntime) Retrieve(input *RetrieveInput) (*RetrieveOutput, error) {
	req, out := c.RetrieveRequest(input)
	return out, req.Send()
}

// RetrieveWithContext is the same as Retrieve with the addition of
// the ability to pass a context and additional request options.
//
// See Retrieve for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgentRuntime) RetrieveWithContext(ctx aws.Context, input *RetrieveInput, opts ...request.Option) (*RetrieveOutput, error) {
	req, out := c.RetrieveRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// RetrievePages iterates over the pages of a Retrieve operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See Retrieve method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a Retrieve operation.
//	pageNum := 0
//	err := client.RetrievePages(params,
//	    func(page *bedrockagentruntime.RetrieveOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *BedrockAgentRuntime) RetrievePages(input *RetrieveInput, fn func(*RetrieveOutput, bool) bool) error {
	return c.RetrievePagesWithContext(aws.BackgroundContext(), input, fn)
}

// RetrievePagesWithContext same as RetrievePages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgentRuntime) RetrievePagesWithContext(ctx aws.Context, input *RetrieveInput, fn func(*RetrieveOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *RetrieveInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.RetrieveRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*RetrieveOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opRetrieveAndGenerate = "RetrieveAndGenerate"

// RetrieveAndGenerateRequest generates a "aws/request.Request" representing the
// client's request for the RetrieveAndGenerate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RetrieveAndGenerate for more information on using the RetrieveAndGenerate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RetrieveAndGenerateRequest method.
//	req, resp := client.RetrieveAndGenerateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/RetrieveAndGenerate
func (c *BedrockAgentRuntime) RetrieveAndGenerateRequest(input *RetrieveAndGenerateInput) (req *request.Request, output *RetrieveAndGenerateOutput) {
	op := &request.Operation{
		Name:       opRetrieveAndGenerate,
		HTTPMethod: "POST",
		HTTPPath:   "/retrieveAndGenerate",
	}

	if input == nil {
		input = &RetrieveAndGenerateInput{}
	}

	output = &RetrieveAndGenerateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RetrieveAndGenerate API operation for Agents for Amazon Bedrock Runtime.
//
// # RetrieveAndGenerate API
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock Runtime's
// API operation RetrieveAndGenerate for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     This exception is thrown when there is a conflict performing an operation
//
//   - ResourceNotFoundException
//     This exception is thrown when a resource referenced by the operation does
//     not exist
//
//   - ValidationException
//     This exception is thrown when the request's input validation fails
//
//   - InternalServerException
//     This exception is thrown if there was an unexpected error during processing
//     of request
//
//   - DependencyFailedException
//     This exception is thrown when a request fails due to dependency like Lambda,
//     Bedrock, STS resource due to a customer fault (i.e. bad configuration)
//
//   - BadGatewayException
//     This exception is thrown when a request fails due to dependency like Lambda,
//     Bedrock, STS resource
//
//   - ThrottlingException
//     This exception is thrown when the number of requests exceeds the limit
//
//   - AccessDeniedException
//     This exception is thrown when a request is denied per access permissions
//
//   - ServiceQuotaExceededException
//     This exception is thrown when a request is made beyond the service quota
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/RetrieveAndGenerate
func (c *BedrockAgentRuntime) RetrieveAndGenerate(input *RetrieveAndGenerateInput) (*RetrieveAndGenerateOutput, error) {
	req, out := c.RetrieveAndGenerateRequest(input)
	return out, req.Send()
}

// RetrieveAndGenerateWithContext is the same as RetrieveAndGenerate with the addition of
// the ability to pass a context and additional request options.
//
// See RetrieveAndGenerate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgentRuntime) RetrieveAndGenerateWithContext(ctx aws.Context, input *RetrieveAndGenerateInput, opts ...request.Option) (*RetrieveAndGenerateOutput, error) {
	req, out := c.RetrieveAndGenerateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// This exception is thrown when a request is denied per access permissions
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Non Blank String
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

// The AccessDeniedException is and event in the ResponseStream group of events.
func (s *AccessDeniedException) eventResponseStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the AccessDeniedException value.
// This method is only used internally within the SDK's EventStream handling.
func (s *AccessDeniedException) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *AccessDeniedException) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.ExceptionMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// input to lambda used in action group
type ActionGroupInvocationInput_ struct {
	_ struct{} `type:"structure"`

	// Agent Trace Action Group Name
	//
	// ActionGroupName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ActionGroupInvocationInput_'s
	// String and GoString methods.
	ActionGroupName *string `locationName:"actionGroupName" type:"string" sensitive:"true"`

	// Agent Trace Action Group API path
	//
	// ApiPath is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ActionGroupInvocationInput_'s
	// String and GoString methods.
	ApiPath *string `locationName:"apiPath" type:"string" sensitive:"true"`

	// list of parameters included in action group invocation
	Parameters []*Parameter `locationName:"parameters" type:"list"`

	// Request Body Content Map
	RequestBody *RequestBody `locationName:"requestBody" type:"structure"`

	// Agent Trace Action Group Action verb
	//
	// Verb is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ActionGroupInvocationInput_'s
	// String and GoString methods.
	Verb *string `locationName:"verb" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionGroupInvocationInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionGroupInvocationInput_) GoString() string {
	return s.String()
}

// SetActionGroupName sets the ActionGroupName field's value.
func (s *ActionGroupInvocationInput_) SetActionGroupName(v string) *ActionGroupInvocationInput_ {
	s.ActionGroupName = &v
	return s
}

// SetApiPath sets the ApiPath field's value.
func (s *ActionGroupInvocationInput_) SetApiPath(v string) *ActionGroupInvocationInput_ {
	s.ApiPath = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *ActionGroupInvocationInput_) SetParameters(v []*Parameter) *ActionGroupInvocationInput_ {
	s.Parameters = v
	return s
}

// SetRequestBody sets the RequestBody field's value.
func (s *ActionGroupInvocationInput_) SetRequestBody(v *RequestBody) *ActionGroupInvocationInput_ {
	s.RequestBody = v
	return s
}

// SetVerb sets the Verb field's value.
func (s *ActionGroupInvocationInput_) SetVerb(v string) *ActionGroupInvocationInput_ {
	s.Verb = &v
	return s
}

// output from lambda used in action group
type ActionGroupInvocationOutput_ struct {
	_ struct{} `type:"structure"`

	// Agent Trace Action Group Lambda Invocation Output String
	//
	// Text is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ActionGroupInvocationOutput_'s
	// String and GoString methods.
	Text *string `locationName:"text" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionGroupInvocationOutput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionGroupInvocationOutput_) GoString() string {
	return s.String()
}

// SetText sets the Text field's value.
func (s *ActionGroupInvocationOutput_) SetText(v string) *ActionGroupInvocationOutput_ {
	s.Text = &v
	return s
}

// Citations associated with final agent response
type Attribution struct {
	_ struct{} `type:"structure"`

	// List of citations
	Citations []*Citation `locationName:"citations" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Attribution) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Attribution) GoString() string {
	return s.String()
}

// SetCitations sets the Citations field's value.
func (s *Attribution) SetCitations(v []*Citation) *Attribution {
	s.Citations = v
	return s
}

// This exception is thrown when a request fails due to dependency like Lambda,
// Bedrock, STS resource
type BadGatewayException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Non Blank String
	Message_ *string `locationName:"message" type:"string"`

	// Non Blank String
	ResourceName *string `locationName:"resourceName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadGatewayException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadGatewayException) GoString() string {
	return s.String()
}

// The BadGatewayException is and event in the ResponseStream group of events.
func (s *BadGatewayException) eventResponseStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the BadGatewayException value.
// This method is only used internally within the SDK's EventStream handling.
func (s *BadGatewayException) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *BadGatewayException) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.ExceptionMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

func newErrorBadGatewayException(v protocol.ResponseMetadata) error {
	return &BadGatewayException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *BadGatewayException) Code() string {
	return "BadGatewayException"
}

// Message returns the exception's message.
func (s *BadGatewayException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *BadGatewayException) OrigErr() error {
	return nil
}

func (s *BadGatewayException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *BadGatewayException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *BadGatewayException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Citation associated with the agent response
type Citation struct {
	_ struct{} `type:"structure"`

	// Generate response part
	GeneratedResponsePart *GeneratedResponsePart `locationName:"generatedResponsePart" type:"structure"`

	// list of retrieved references
	RetrievedReferences []*RetrievedReference `locationName:"retrievedReferences" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Citation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Citation) GoString() string {
	return s.String()
}

// SetGeneratedResponsePart sets the GeneratedResponsePart field's value.
func (s *Citation) SetGeneratedResponsePart(v *GeneratedResponsePart) *Citation {
	s.GeneratedResponsePart = v
	return s
}

// SetRetrievedReferences sets the RetrievedReferences field's value.
func (s *Citation) SetRetrievedReferences(v []*RetrievedReference) *Citation {
	s.RetrievedReferences = v
	return s
}

// This exception is thrown when there is a conflict performing an operation
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Non Blank String
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

// The ConflictException is and event in the ResponseStream group of events.
func (s *ConflictException) eventResponseStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the ConflictException value.
// This method is only used internally within the SDK's EventStream handling.
func (s *ConflictException) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *ConflictException) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.ExceptionMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// This exception is thrown when a request fails due to dependency like Lambda,
// Bedrock, STS resource due to a customer fault (i.e. bad configuration)
type DependencyFailedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Non Blank String
	Message_ *string `locationName:"message" type:"string"`

	// Non Blank String
	ResourceName *string `locationName:"resourceName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DependencyFailedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DependencyFailedException) GoString() string {
	return s.String()
}

// The DependencyFailedException is and event in the ResponseStream group of events.
func (s *DependencyFailedException) eventResponseStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the DependencyFailedException value.
// This method is only used internally within the SDK's EventStream handling.
func (s *DependencyFailedException) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *DependencyFailedException) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.ExceptionMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

func newErrorDependencyFailedException(v protocol.ResponseMetadata) error {
	return &DependencyFailedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *DependencyFailedException) Code() string {
	return "DependencyFailedException"
}

// Message returns the exception's message.
func (s *DependencyFailedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *DependencyFailedException) OrigErr() error {
	return nil
}

func (s *DependencyFailedException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *DependencyFailedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *DependencyFailedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Trace Part which is emitted when agent trace could not be generated
type FailureTrace struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// Agent Trace Failed Reason String
	//
	// FailureReason is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by FailureTrace's
	// String and GoString methods.
	FailureReason *string `locationName:"failureReason" type:"string" sensitive:"true"`

	// Identifier for trace
	TraceId *string `locationName:"traceId" min:"2" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FailureTrace) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FailureTrace) GoString() string {
	return s.String()
}

// SetFailureReason sets the FailureReason field's value.
func (s *FailureTrace) SetFailureReason(v string) *FailureTrace {
	s.FailureReason = &v
	return s
}

// SetTraceId sets the TraceId field's value.
func (s *FailureTrace) SetTraceId(v string) *FailureTrace {
	s.TraceId = &v
	return s
}

// Agent finish output
type FinalResponse struct {
	_ struct{} `type:"structure"`

	// Agent Trace Action Group Lambda Invocation Output String
	//
	// Text is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by FinalResponse's
	// String and GoString methods.
	Text *string `locationName:"text" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FinalResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FinalResponse) GoString() string {
	return s.String()
}

// SetText sets the Text field's value.
func (s *FinalResponse) SetText(v string) *FinalResponse {
	s.Text = &v
	return s
}

// Generate response part
type GeneratedResponsePart struct {
	_ struct{} `type:"structure"`

	// Text response part
	TextResponsePart *TextResponsePart `locationName:"textResponsePart" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GeneratedResponsePart) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GeneratedResponsePart) GoString() string {
	return s.String()
}

// SetTextResponsePart sets the TextResponsePart field's value.
func (s *GeneratedResponsePart) SetTextResponsePart(v *TextResponsePart) *GeneratedResponsePart {
	s.TextResponsePart = v
	return s
}

// Configurations for controlling the inference response of an InvokeAgent API
// call
type InferenceConfiguration struct {
	_ struct{} `type:"structure"`

	// Maximum length of output
	MaximumLength *int64 `locationName:"maximumLength" type:"integer"`

	// List of stop sequences
	StopSequences []*string `locationName:"stopSequences" type:"list"`

	// Controls randomness, higher values increase diversity
	Temperature *float64 `locationName:"temperature" type:"float"`

	// Sample from the k most likely next tokens
	TopK *int64 `locationName:"topK" type:"integer"`

	// Cumulative probability cutoff for token selection
	TopP *float64 `locationName:"topP" type:"float"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InferenceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InferenceConfiguration) GoString() string {
	return s.String()
}

// SetMaximumLength sets the MaximumLength field's value.
func (s *InferenceConfiguration) SetMaximumLength(v int64) *InferenceConfiguration {
	s.MaximumLength = &v
	return s
}

// SetStopSequences sets the StopSequences field's value.
func (s *InferenceConfiguration) SetStopSequences(v []*string) *InferenceConfiguration {
	s.StopSequences = v
	return s
}

// SetTemperature sets the Temperature field's value.
func (s *InferenceConfiguration) SetTemperature(v float64) *InferenceConfiguration {
	s.Temperature = &v
	return s
}

// SetTopK sets the TopK field's value.
func (s *InferenceConfiguration) SetTopK(v int64) *InferenceConfiguration {
	s.TopK = &v
	return s
}

// SetTopP sets the TopP field's value.
func (s *InferenceConfiguration) SetTopP(v float64) *InferenceConfiguration {
	s.TopP = &v
	return s
}

// This exception is thrown if there was an unexpected error during processing
// of request
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Non Blank String
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

// The InternalServerException is and event in the ResponseStream group of events.
func (s *InternalServerException) eventResponseStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the InternalServerException value.
// This method is only used internally within the SDK's EventStream handling.
func (s *InternalServerException) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *InternalServerException) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.ExceptionMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Trace Part which contains input details for action group or knowledge base
type InvocationInput_ struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// input to lambda used in action group
	ActionGroupInvocationInput *ActionGroupInvocationInput_ `locationName:"actionGroupInvocationInput" type:"structure"`

	// types of invocations
	InvocationType *string `locationName:"invocationType" type:"string" enum:"InvocationType"`

	// Input to lambda used in action group
	KnowledgeBaseLookupInput *KnowledgeBaseLookupInput_ `locationName:"knowledgeBaseLookupInput" type:"structure"`

	// Identifier for trace
	TraceId *string `locationName:"traceId" min:"2" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvocationInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvocationInput_) GoString() string {
	return s.String()
}

// SetActionGroupInvocationInput sets the ActionGroupInvocationInput field's value.
func (s *InvocationInput_) SetActionGroupInvocationInput(v *ActionGroupInvocationInput_) *InvocationInput_ {
	s.ActionGroupInvocationInput = v
	return s
}

// SetInvocationType sets the InvocationType field's value.
func (s *InvocationInput_) SetInvocationType(v string) *InvocationInput_ {
	s.InvocationType = &v
	return s
}

// SetKnowledgeBaseLookupInput sets the KnowledgeBaseLookupInput field's value.
func (s *InvocationInput_) SetKnowledgeBaseLookupInput(v *KnowledgeBaseLookupInput_) *InvocationInput_ {
	s.KnowledgeBaseLookupInput = v
	return s
}

// SetTraceId sets the TraceId field's value.
func (s *InvocationInput_) SetTraceId(v string) *InvocationInput_ {
	s.TraceId = &v
	return s
}

// InvokeAgent Request
type InvokeAgentInput struct {
	_ struct{} `type:"structure"`

	// Identifier for Agent Alias
	//
	// AgentAliasId is a required field
	AgentAliasId *string `location:"uri" locationName:"agentAliasId" type:"string" required:"true"`

	// Identifier for Agent
	//
	// AgentId is a required field
	AgentId *string `location:"uri" locationName:"agentId" type:"string" required:"true"`

	// Enable agent trace events for improved debugging
	EnableTrace *bool `locationName:"enableTrace" type:"boolean"`

	// End current session
	EndSession *bool `locationName:"endSession" type:"boolean"`

	// Input data in the format specified in the Content-Type request header.
	//
	// InputText is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by InvokeAgentInput's
	// String and GoString methods.
	//
	// InputText is a required field
	InputText *string `locationName:"inputText" type:"string" required:"true" sensitive:"true"`

	// Identifier used for the current session
	//
	// SessionId is a required field
	SessionId *string `location:"uri" locationName:"sessionId" min:"2" type:"string" required:"true"`

	// Session state passed by customer. Base64 encoded json string representation
	// of SessionState.
	SessionState *SessionState `locationName:"sessionState" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvokeAgentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvokeAgentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InvokeAgentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InvokeAgentInput"}
	if s.AgentAliasId == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentAliasId"))
	}
	if s.AgentAliasId != nil && len(*s.AgentAliasId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentAliasId", 1))
	}
	if s.AgentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentId"))
	}
	if s.AgentId != nil && len(*s.AgentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentId", 1))
	}
	if s.InputText == nil {
		invalidParams.Add(request.NewErrParamRequired("InputText"))
	}
	if s.SessionId == nil {
		invalidParams.Add(request.NewErrParamRequired("SessionId"))
	}
	if s.SessionId != nil && len(*s.SessionId) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("SessionId", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentAliasId sets the AgentAliasId field's value.
func (s *InvokeAgentInput) SetAgentAliasId(v string) *InvokeAgentInput {
	s.AgentAliasId = &v
	return s
}

// SetAgentId sets the AgentId field's value.
func (s *InvokeAgentInput) SetAgentId(v string) *InvokeAgentInput {
	s.AgentId = &v
	return s
}

// SetEnableTrace sets the EnableTrace field's value.
func (s *InvokeAgentInput) SetEnableTrace(v bool) *InvokeAgentInput {
	s.EnableTrace = &v
	return s
}

// SetEndSession sets the EndSession field's value.
func (s *InvokeAgentInput) SetEndSession(v bool) *InvokeAgentInput {
	s.EndSession = &v
	return s
}

// SetInputText sets the InputText field's value.
func (s *InvokeAgentInput) SetInputText(v string) *InvokeAgentInput {
	s.InputText = &v
	return s
}

// SetSessionId sets the SessionId field's value.
func (s *InvokeAgentInput) SetSessionId(v string) *InvokeAgentInput {
	s.SessionId = &v
	return s
}

// SetSessionState sets the SessionState field's value.
func (s *InvokeAgentInput) SetSessionState(v *SessionState) *InvokeAgentInput {
	s.SessionState = v
	return s
}

// InvokeAgent Response
type InvokeAgentOutput struct {
	_ struct{} `type:"structure" payload:"Completion"`

	eventStream *InvokeAgentEventStream

	// streaming response mimetype of the model
	//
	// ContentType is a required field
	ContentType *string `location:"header" locationName:"x-amzn-bedrock-agent-content-type" type:"string" required:"true"`

	// streaming response mimetype of the model
	//
	// SessionId is a required field
	SessionId *string `location:"header" locationName:"x-amz-bedrock-agent-session-id" min:"2" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvokeAgentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvokeAgentOutput) GoString() string {
	return s.String()
}

// SetContentType sets the ContentType field's value.
func (s *InvokeAgentOutput) SetContentType(v string) *InvokeAgentOutput {
	s.ContentType = &v
	return s
}

// SetSessionId sets the SessionId field's value.
func (s *InvokeAgentOutput) SetSessionId(v string) *InvokeAgentOutput {
	s.SessionId = &v
	return s
}

// GetStream returns the type to interact with the event stream.
func (s *InvokeAgentOutput) GetStream() *InvokeAgentEventStream {
	return s.eventStream
}

// Input to lambda used in action group
type KnowledgeBaseLookupInput_ struct {
	_ struct{} `type:"structure"`

	// Agent Trace Action Group Knowledge Base Id
	//
	// KnowledgeBaseId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by KnowledgeBaseLookupInput_'s
	// String and GoString methods.
	KnowledgeBaseId *string `locationName:"knowledgeBaseId" type:"string" sensitive:"true"`

	// Agent Trace Action Group Lambda Invocation Output String
	//
	// Text is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by KnowledgeBaseLookupInput_'s
	// String and GoString methods.
	Text *string `locationName:"text" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KnowledgeBaseLookupInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KnowledgeBaseLookupInput_) GoString() string {
	return s.String()
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *KnowledgeBaseLookupInput_) SetKnowledgeBaseId(v string) *KnowledgeBaseLookupInput_ {
	s.KnowledgeBaseId = &v
	return s
}

// SetText sets the Text field's value.
func (s *KnowledgeBaseLookupInput_) SetText(v string) *KnowledgeBaseLookupInput_ {
	s.Text = &v
	return s
}

// Input to lambda used in action group
type KnowledgeBaseLookupOutput_ struct {
	_ struct{} `type:"structure"`

	// list of retrieved references
	RetrievedReferences []*RetrievedReference `locationName:"retrievedReferences" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KnowledgeBaseLookupOutput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KnowledgeBaseLookupOutput_) GoString() string {
	return s.String()
}

// SetRetrievedReferences sets the RetrievedReferences field's value.
func (s *KnowledgeBaseLookupOutput_) SetRetrievedReferences(v []*RetrievedReference) *KnowledgeBaseLookupOutput_ {
	s.RetrievedReferences = v
	return s
}

// Knowledge base input query.
type KnowledgeBaseQuery struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// Knowledge base input query in text
	//
	// Text is a required field
	Text *string `locationName:"text" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KnowledgeBaseQuery) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KnowledgeBaseQuery) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KnowledgeBaseQuery) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KnowledgeBaseQuery"}
	if s.Text == nil {
		invalidParams.Add(request.NewErrParamRequired("Text"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetText sets the Text field's value.
func (s *KnowledgeBaseQuery) SetText(v string) *KnowledgeBaseQuery {
	s.Text = &v
	return s
}

// Search parameters for retrieving from knowledge base.
type KnowledgeBaseRetrievalConfiguration struct {
	_ struct{} `type:"structure"`

	// Knowledge base vector search configuration
	//
	// VectorSearchConfiguration is a required field
	VectorSearchConfiguration *KnowledgeBaseVectorSearchConfiguration `locationName:"vectorSearchConfiguration" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KnowledgeBaseRetrievalConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KnowledgeBaseRetrievalConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KnowledgeBaseRetrievalConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KnowledgeBaseRetrievalConfiguration"}
	if s.VectorSearchConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("VectorSearchConfiguration"))
	}
	if s.VectorSearchConfiguration != nil {
		if err := s.VectorSearchConfiguration.Validate(); err != nil {
			invalidParams.AddNested("VectorSearchConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVectorSearchConfiguration sets the VectorSearchConfiguration field's value.
func (s *KnowledgeBaseRetrievalConfiguration) SetVectorSearchConfiguration(v *KnowledgeBaseVectorSearchConfiguration) *KnowledgeBaseRetrievalConfiguration {
	s.VectorSearchConfiguration = v
	return s
}

// Result item returned from a knowledge base retrieval.
type KnowledgeBaseRetrievalResult struct {
	_ struct{} `type:"structure"`

	// Content of a retrieval result.
	//
	// Content is a required field
	Content *RetrievalResultContent `locationName:"content" type:"structure" required:"true"`

	// The source location of a retrieval result.
	Location *RetrievalResultLocation `locationName:"location" type:"structure"`

	// The relevance score of a result.
	Score *float64 `locationName:"score" type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KnowledgeBaseRetrievalResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KnowledgeBaseRetrievalResult) GoString() string {
	return s.String()
}

// SetContent sets the Content field's value.
func (s *KnowledgeBaseRetrievalResult) SetContent(v *RetrievalResultContent) *KnowledgeBaseRetrievalResult {
	s.Content = v
	return s
}

// SetLocation sets the Location field's value.
func (s *KnowledgeBaseRetrievalResult) SetLocation(v *RetrievalResultLocation) *KnowledgeBaseRetrievalResult {
	s.Location = v
	return s
}

// SetScore sets the Score field's value.
func (s *KnowledgeBaseRetrievalResult) SetScore(v float64) *KnowledgeBaseRetrievalResult {
	s.Score = &v
	return s
}

// Configurations for retrieval and generation for knowledge base.
type KnowledgeBaseRetrieveAndGenerateConfiguration struct {
	_ struct{} `type:"structure"`

	// Identifier of the KnowledgeBase
	//
	// KnowledgeBaseId is a required field
	KnowledgeBaseId *string `locationName:"knowledgeBaseId" type:"string" required:"true"`

	// Arn of a Bedrock model.
	//
	// ModelArn is a required field
	ModelArn *string `locationName:"modelArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KnowledgeBaseRetrieveAndGenerateConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KnowledgeBaseRetrieveAndGenerateConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KnowledgeBaseRetrieveAndGenerateConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KnowledgeBaseRetrieveAndGenerateConfiguration"}
	if s.KnowledgeBaseId == nil {
		invalidParams.Add(request.NewErrParamRequired("KnowledgeBaseId"))
	}
	if s.ModelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelArn"))
	}
	if s.ModelArn != nil && len(*s.ModelArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ModelArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *KnowledgeBaseRetrieveAndGenerateConfiguration) SetKnowledgeBaseId(v string) *KnowledgeBaseRetrieveAndGenerateConfiguration {
	s.KnowledgeBaseId = &v
	return s
}

// SetModelArn sets the ModelArn field's value.
func (s *KnowledgeBaseRetrieveAndGenerateConfiguration) SetModelArn(v string) *KnowledgeBaseRetrieveAndGenerateConfiguration {
	s.ModelArn = &v
	return s
}

// Knowledge base vector search configuration
type KnowledgeBaseVectorSearchConfiguration struct {
	_ struct{} `type:"structure"`

	// Top-K results to retrieve from knowledge base.
	//
	// NumberOfResults is a required field
	NumberOfResults *int64 `locationName:"numberOfResults" min:"1" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KnowledgeBaseVectorSearchConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KnowledgeBaseVectorSearchConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KnowledgeBaseVectorSearchConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KnowledgeBaseVectorSearchConfiguration"}
	if s.NumberOfResults == nil {
		invalidParams.Add(request.NewErrParamRequired("NumberOfResults"))
	}
	if s.NumberOfResults != nil && *s.NumberOfResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("NumberOfResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNumberOfResults sets the NumberOfResults field's value.
func (s *KnowledgeBaseVectorSearchConfiguration) SetNumberOfResults(v int64) *KnowledgeBaseVectorSearchConfiguration {
	s.NumberOfResults = &v
	return s
}

// Trace Part which contains information used to call Invoke Model
type ModelInvocationInput_ struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// Configurations for controlling the inference response of an InvokeAgent API
	// call
	InferenceConfiguration *InferenceConfiguration `locationName:"inferenceConfiguration" type:"structure"`

	// ARN of a Lambda.
	OverrideLambda *string `locationName:"overrideLambda" type:"string"`

	// indicates if agent uses default prompt or overriden prompt
	ParserMode *string `locationName:"parserMode" type:"string" enum:"CreationMode"`

	// indicates if agent uses default prompt or overriden prompt
	PromptCreationMode *string `locationName:"promptCreationMode" type:"string" enum:"CreationMode"`

	// Prompt Message
	//
	// Text is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ModelInvocationInput_'s
	// String and GoString methods.
	Text *string `locationName:"text" type:"string" sensitive:"true"`

	// Identifier for trace
	TraceId *string `locationName:"traceId" min:"2" type:"string"`

	// types of prompts
	Type *string `locationName:"type" type:"string" enum:"PromptType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModelInvocationInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModelInvocationInput_) GoString() string {
	return s.String()
}

// SetInferenceConfiguration sets the InferenceConfiguration field's value.
func (s *ModelInvocationInput_) SetInferenceConfiguration(v *InferenceConfiguration) *ModelInvocationInput_ {
	s.InferenceConfiguration = v
	return s
}

// SetOverrideLambda sets the OverrideLambda field's value.
func (s *ModelInvocationInput_) SetOverrideLambda(v string) *ModelInvocationInput_ {
	s.OverrideLambda = &v
	return s
}

// SetParserMode sets the ParserMode field's value.
func (s *ModelInvocationInput_) SetParserMode(v string) *ModelInvocationInput_ {
	s.ParserMode = &v
	return s
}

// SetPromptCreationMode sets the PromptCreationMode field's value.
func (s *ModelInvocationInput_) SetPromptCreationMode(v string) *ModelInvocationInput_ {
	s.PromptCreationMode = &v
	return s
}

// SetText sets the Text field's value.
func (s *ModelInvocationInput_) SetText(v string) *ModelInvocationInput_ {
	s.Text = &v
	return s
}

// SetTraceId sets the TraceId field's value.
func (s *ModelInvocationInput_) SetTraceId(v string) *ModelInvocationInput_ {
	s.TraceId = &v
	return s
}

// SetType sets the Type field's value.
func (s *ModelInvocationInput_) SetType(v string) *ModelInvocationInput_ {
	s.Type = &v
	return s
}

// Trace Part which contains output details for action group or knowledge base
// or final response
type Observation struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// output from lambda used in action group
	ActionGroupInvocationOutput *ActionGroupInvocationOutput_ `locationName:"actionGroupInvocationOutput" type:"structure"`

	// Agent finish output
	FinalResponse *FinalResponse `locationName:"finalResponse" type:"structure"`

	// Input to lambda used in action group
	KnowledgeBaseLookupOutput *KnowledgeBaseLookupOutput_ `locationName:"knowledgeBaseLookupOutput" type:"structure"`

	// Observation information if there were reprompts
	//
	// RepromptResponse is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Observation's
	// String and GoString methods.
	RepromptResponse *RepromptResponse `locationName:"repromptResponse" type:"structure" sensitive:"true"`

	// Identifier for trace
	TraceId *string `locationName:"traceId" min:"2" type:"string"`

	// types of observations
	Type *string `locationName:"type" type:"string" enum:"Type"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Observation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Observation) GoString() string {
	return s.String()
}

// SetActionGroupInvocationOutput sets the ActionGroupInvocationOutput field's value.
func (s *Observation) SetActionGroupInvocationOutput(v *ActionGroupInvocationOutput_) *Observation {
	s.ActionGroupInvocationOutput = v
	return s
}

// SetFinalResponse sets the FinalResponse field's value.
func (s *Observation) SetFinalResponse(v *FinalResponse) *Observation {
	s.FinalResponse = v
	return s
}

// SetKnowledgeBaseLookupOutput sets the KnowledgeBaseLookupOutput field's value.
func (s *Observation) SetKnowledgeBaseLookupOutput(v *KnowledgeBaseLookupOutput_) *Observation {
	s.KnowledgeBaseLookupOutput = v
	return s
}

// SetRepromptResponse sets the RepromptResponse field's value.
func (s *Observation) SetRepromptResponse(v *RepromptResponse) *Observation {
	s.RepromptResponse = v
	return s
}

// SetTraceId sets the TraceId field's value.
func (s *Observation) SetTraceId(v string) *Observation {
	s.TraceId = &v
	return s
}

// SetType sets the Type field's value.
func (s *Observation) SetType(v string) *Observation {
	s.Type = &v
	return s
}

// Trace contains intermidate response during orchestration
type OrchestrationTrace struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// Trace Part which contains input details for action group or knowledge base
	//
	// InvocationInput is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by OrchestrationTrace's
	// String and GoString methods.
	InvocationInput *InvocationInput_ `locationName:"invocationInput" type:"structure" sensitive:"true"`

	// Trace Part which contains information used to call Invoke Model
	//
	// ModelInvocationInput is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by OrchestrationTrace's
	// String and GoString methods.
	ModelInvocationInput *ModelInvocationInput_ `locationName:"modelInvocationInput" type:"structure" sensitive:"true"`

	// Trace Part which contains output details for action group or knowledge base
	// or final response
	//
	// Observation is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by OrchestrationTrace's
	// String and GoString methods.
	Observation *Observation `locationName:"observation" type:"structure" sensitive:"true"`

	// Trace Part which contains information related to reasoning
	//
	// Rationale is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by OrchestrationTrace's
	// String and GoString methods.
	Rationale *Rationale `locationName:"rationale" type:"structure" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OrchestrationTrace) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OrchestrationTrace) GoString() string {
	return s.String()
}

// SetInvocationInput sets the InvocationInput field's value.
func (s *OrchestrationTrace) SetInvocationInput(v *InvocationInput_) *OrchestrationTrace {
	s.InvocationInput = v
	return s
}

// SetModelInvocationInput sets the ModelInvocationInput field's value.
func (s *OrchestrationTrace) SetModelInvocationInput(v *ModelInvocationInput_) *OrchestrationTrace {
	s.ModelInvocationInput = v
	return s
}

// SetObservation sets the Observation field's value.
func (s *OrchestrationTrace) SetObservation(v *Observation) *OrchestrationTrace {
	s.Observation = v
	return s
}

// SetRationale sets the Rationale field's value.
func (s *OrchestrationTrace) SetRationale(v *Rationale) *OrchestrationTrace {
	s.Rationale = v
	return s
}

// parameters included in action group invocation
type Parameter struct {
	_ struct{} `type:"structure"`

	// Name of parameter
	Name *string `locationName:"name" type:"string"`

	// Type of parameter
	Type *string `locationName:"type" type:"string"`

	// Value of parameter
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Parameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Parameter) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *Parameter) SetName(v string) *Parameter {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *Parameter) SetType(v string) *Parameter {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Parameter) SetValue(v string) *Parameter {
	s.Value = &v
	return s
}

// Base 64 endoded byte response
type PayloadPart struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// Citations associated with final agent response
	Attribution *Attribution `locationName:"attribution" type:"structure"`

	// PartBody of the payload in bytes
	//
	// Bytes is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PayloadPart's
	// String and GoString methods.
	//
	// Bytes is automatically base64 encoded/decoded by the SDK.
	Bytes []byte `locationName:"bytes" type:"blob" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PayloadPart) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PayloadPart) GoString() string {
	return s.String()
}

// SetAttribution sets the Attribution field's value.
func (s *PayloadPart) SetAttribution(v *Attribution) *PayloadPart {
	s.Attribution = v
	return s
}

// SetBytes sets the Bytes field's value.
func (s *PayloadPart) SetBytes(v []byte) *PayloadPart {
	s.Bytes = v
	return s
}

// The PayloadPart is and event in the ResponseStream group of events.
func (s *PayloadPart) eventResponseStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the PayloadPart value.
// This method is only used internally within the SDK's EventStream handling.
func (s *PayloadPart) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *PayloadPart) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.EventMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

// Trace Part which contains information related to postprocessing
type PostProcessingModelInvocationOutput_ struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// Trace Part which contains information if preprocessing was successful
	//
	// ParsedResponse is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PostProcessingModelInvocationOutput_'s
	// String and GoString methods.
	ParsedResponse *PostProcessingParsedResponse `locationName:"parsedResponse" type:"structure" sensitive:"true"`

	// Identifier for trace
	TraceId *string `locationName:"traceId" min:"2" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PostProcessingModelInvocationOutput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PostProcessingModelInvocationOutput_) GoString() string {
	return s.String()
}

// SetParsedResponse sets the ParsedResponse field's value.
func (s *PostProcessingModelInvocationOutput_) SetParsedResponse(v *PostProcessingParsedResponse) *PostProcessingModelInvocationOutput_ {
	s.ParsedResponse = v
	return s
}

// SetTraceId sets the TraceId field's value.
func (s *PostProcessingModelInvocationOutput_) SetTraceId(v string) *PostProcessingModelInvocationOutput_ {
	s.TraceId = &v
	return s
}

// Trace Part which contains information if preprocessing was successful
type PostProcessingParsedResponse struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// Agent Trace Output String
	//
	// Text is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PostProcessingParsedResponse's
	// String and GoString methods.
	Text *string `locationName:"text" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PostProcessingParsedResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PostProcessingParsedResponse) GoString() string {
	return s.String()
}

// SetText sets the Text field's value.
func (s *PostProcessingParsedResponse) SetText(v string) *PostProcessingParsedResponse {
	s.Text = &v
	return s
}

// Trace Part which contains information related to post processing step
type PostProcessingTrace struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// Trace Part which contains information used to call Invoke Model
	//
	// ModelInvocationInput is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PostProcessingTrace's
	// String and GoString methods.
	ModelInvocationInput *ModelInvocationInput_ `locationName:"modelInvocationInput" type:"structure" sensitive:"true"`

	// Trace Part which contains information related to postprocessing
	//
	// ModelInvocationOutput is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PostProcessingTrace's
	// String and GoString methods.
	ModelInvocationOutput *PostProcessingModelInvocationOutput_ `locationName:"modelInvocationOutput" type:"structure" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PostProcessingTrace) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PostProcessingTrace) GoString() string {
	return s.String()
}

// SetModelInvocationInput sets the ModelInvocationInput field's value.
func (s *PostProcessingTrace) SetModelInvocationInput(v *ModelInvocationInput_) *PostProcessingTrace {
	s.ModelInvocationInput = v
	return s
}

// SetModelInvocationOutput sets the ModelInvocationOutput field's value.
func (s *PostProcessingTrace) SetModelInvocationOutput(v *PostProcessingModelInvocationOutput_) *PostProcessingTrace {
	s.ModelInvocationOutput = v
	return s
}

// Trace Part which contains information related to preprocessing
type PreProcessingModelInvocationOutput_ struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// Trace Part which contains information if preprocessing was successful
	//
	// ParsedResponse is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PreProcessingModelInvocationOutput_'s
	// String and GoString methods.
	ParsedResponse *PreProcessingParsedResponse `locationName:"parsedResponse" type:"structure" sensitive:"true"`

	// Identifier for trace
	TraceId *string `locationName:"traceId" min:"2" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PreProcessingModelInvocationOutput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PreProcessingModelInvocationOutput_) GoString() string {
	return s.String()
}

// SetParsedResponse sets the ParsedResponse field's value.
func (s *PreProcessingModelInvocationOutput_) SetParsedResponse(v *PreProcessingParsedResponse) *PreProcessingModelInvocationOutput_ {
	s.ParsedResponse = v
	return s
}

// SetTraceId sets the TraceId field's value.
func (s *PreProcessingModelInvocationOutput_) SetTraceId(v string) *PreProcessingModelInvocationOutput_ {
	s.TraceId = &v
	return s
}

// Trace Part which contains information if preprocessing was successful
type PreProcessingParsedResponse struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// Boolean value
	IsValid *bool `locationName:"isValid" type:"boolean"`

	// Agent Trace Rationale String
	//
	// Rationale is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PreProcessingParsedResponse's
	// String and GoString methods.
	Rationale *string `locationName:"rationale" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PreProcessingParsedResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PreProcessingParsedResponse) GoString() string {
	return s.String()
}

// SetIsValid sets the IsValid field's value.
func (s *PreProcessingParsedResponse) SetIsValid(v bool) *PreProcessingParsedResponse {
	s.IsValid = &v
	return s
}

// SetRationale sets the Rationale field's value.
func (s *PreProcessingParsedResponse) SetRationale(v string) *PreProcessingParsedResponse {
	s.Rationale = &v
	return s
}

// Trace Part which contains information related to preprocessing step
type PreProcessingTrace struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// Trace Part which contains information used to call Invoke Model
	//
	// ModelInvocationInput is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PreProcessingTrace's
	// String and GoString methods.
	ModelInvocationInput *ModelInvocationInput_ `locationName:"modelInvocationInput" type:"structure" sensitive:"true"`

	// Trace Part which contains information related to preprocessing
	//
	// ModelInvocationOutput is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PreProcessingTrace's
	// String and GoString methods.
	ModelInvocationOutput *PreProcessingModelInvocationOutput_ `locationName:"modelInvocationOutput" type:"structure" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PreProcessingTrace) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PreProcessingTrace) GoString() string {
	return s.String()
}

// SetModelInvocationInput sets the ModelInvocationInput field's value.
func (s *PreProcessingTrace) SetModelInvocationInput(v *ModelInvocationInput_) *PreProcessingTrace {
	s.ModelInvocationInput = v
	return s
}

// SetModelInvocationOutput sets the ModelInvocationOutput field's value.
func (s *PreProcessingTrace) SetModelInvocationOutput(v *PreProcessingModelInvocationOutput_) *PreProcessingTrace {
	s.ModelInvocationOutput = v
	return s
}

// Trace Part which contains information related to reasoning
type Rationale struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// Agent Trace Rationale String
	//
	// Text is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Rationale's
	// String and GoString methods.
	Text *string `locationName:"text" type:"string" sensitive:"true"`

	// Identifier for trace
	TraceId *string `locationName:"traceId" min:"2" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Rationale) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Rationale) GoString() string {
	return s.String()
}

// SetText sets the Text field's value.
func (s *Rationale) SetText(v string) *Rationale {
	s.Text = &v
	return s
}

// SetTraceId sets the TraceId field's value.
func (s *Rationale) SetTraceId(v string) *Rationale {
	s.TraceId = &v
	return s
}

// Observation information if there were reprompts
type RepromptResponse struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// Parsing error source
	//
	// Source is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by RepromptResponse's
	// String and GoString methods.
	Source *string `locationName:"source" type:"string" enum:"Source" sensitive:"true"`

	// Reprompt response text
	Text *string `locationName:"text" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RepromptResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RepromptResponse) GoString() string {
	return s.String()
}

// SetSource sets the Source field's value.
func (s *RepromptResponse) SetSource(v string) *RepromptResponse {
	s.Source = &v
	return s
}

// SetText sets the Text field's value.
func (s *RepromptResponse) SetText(v string) *RepromptResponse {
	s.Text = &v
	return s
}

// Request Body Content Map
type RequestBody struct {
	_ struct{} `type:"structure"`

	// Content type paramter map
	Content map[string][]*Parameter `locationName:"content" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RequestBody) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RequestBody) GoString() string {
	return s.String()
}

// SetContent sets the Content field's value.
func (s *RequestBody) SetContent(v map[string][]*Parameter) *RequestBody {
	s.Content = v
	return s
}

// This exception is thrown when a resource referenced by the operation does
// not exist
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Non Blank String
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

// The ResourceNotFoundException is and event in the ResponseStream group of events.
func (s *ResourceNotFoundException) eventResponseStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the ResourceNotFoundException value.
// This method is only used internally within the SDK's EventStream handling.
func (s *ResourceNotFoundException) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *ResourceNotFoundException) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.ExceptionMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// ResponseStreamEvent groups together all EventStream
// events writes for ResponseStream.
//
// These events are:
//
//   - PayloadPart
//   - TracePart
type ResponseStreamEvent interface {
	eventResponseStream()
	eventstreamapi.Marshaler
	eventstreamapi.Unmarshaler
}

// ResponseStreamReader provides the interface for reading to the stream. The
// default implementation for this interface will be ResponseStream.
//
// The reader's Close method must allow multiple concurrent calls.
//
// These events are:
//
//   - PayloadPart
//   - TracePart
//   - ResponseStreamUnknownEvent
type ResponseStreamReader interface {
	// Returns a channel of events as they are read from the event stream.
	Events() <-chan ResponseStreamEvent

	// Close will stop the reader reading events from the stream.
	Close() error

	// Returns any error that has occurred while reading from the event stream.
	Err() error
}

type readResponseStream struct {
	eventReader *eventstreamapi.EventReader
	stream      chan ResponseStreamEvent
	err         *eventstreamapi.OnceError

	done      chan struct{}
	closeOnce sync.Once
}

func newReadResponseStream(eventReader *eventstreamapi.EventReader) *readResponseStream {
	r := &readResponseStream{
		eventReader: eventReader,
		stream:      make(chan ResponseStreamEvent),
		done:        make(chan struct{}),
		err:         eventstreamapi.NewOnceError(),
	}
	go r.readEventStream()

	return r
}

// Close will close the underlying event stream reader.
func (r *readResponseStream) Close() error {
	r.closeOnce.Do(r.safeClose)
	return r.Err()
}

func (r *readResponseStream) ErrorSet() <-chan struct{} {
	return r.err.ErrorSet()
}

func (r *readResponseStream) Closed() <-chan struct{} {
	return r.done
}

func (r *readResponseStream) safeClose() {
	close(r.done)
}

func (r *readResponseStream) Err() error {
	return r.err.Err()
}

func (r *readResponseStream) Events() <-chan ResponseStreamEvent {
	return r.stream
}

func (r *readResponseStream) readEventStream() {
	defer r.Close()
	defer close(r.stream)

	for {
		event, err := r.eventReader.ReadEvent()
		if err != nil {
			if err == io.EOF {
				return
			}
			select {
			case <-r.done:
				// If closed already ignore the error
				return
			default:
			}
			if _, ok := err.(*eventstreamapi.UnknownMessageTypeError); ok {
				continue
			}
			r.err.SetError(err)
			return
		}

		select {
		case r.stream <- event.(ResponseStreamEvent):
		case <-r.done:
			return
		}
	}
}

type unmarshalerForResponseStreamEvent struct {
	metadata protocol.ResponseMetadata
}

func (u unmarshalerForResponseStreamEvent) UnmarshalerForEventName(eventType string) (eventstreamapi.Unmarshaler, error) {
	switch eventType {
	case "chunk":
		return &PayloadPart{}, nil
	case "trace":
		return &TracePart{}, nil
	case "accessDeniedException":
		return newErrorAccessDeniedException(u.metadata).(eventstreamapi.Unmarshaler), nil
	case "badGatewayException":
		return newErrorBadGatewayException(u.metadata).(eventstreamapi.Unmarshaler), nil
	case "conflictException":
		return newErrorConflictException(u.metadata).(eventstreamapi.Unmarshaler), nil
	case "dependencyFailedException":
		return newErrorDependencyFailedException(u.metadata).(eventstreamapi.Unmarshaler), nil
	case "internalServerException":
		return newErrorInternalServerException(u.metadata).(eventstreamapi.Unmarshaler), nil
	case "resourceNotFoundException":
		return newErrorResourceNotFoundException(u.metadata).(eventstreamapi.Unmarshaler), nil
	case "serviceQuotaExceededException":
		return newErrorServiceQuotaExceededException(u.metadata).(eventstreamapi.Unmarshaler), nil
	case "throttlingException":
		return newErrorThrottlingException(u.metadata).(eventstreamapi.Unmarshaler), nil
	case "validationException":
		return newErrorValidationException(u.metadata).(eventstreamapi.Unmarshaler), nil
	default:
		return &ResponseStreamUnknownEvent{Type: eventType}, nil
	}
}

// ResponseStreamUnknownEvent provides a failsafe event for the
// ResponseStream group of events when an unknown event is received.
type ResponseStreamUnknownEvent struct {
	Type    string
	Message eventstream.Message
}

// The ResponseStreamUnknownEvent is and event in the ResponseStream
// group of events.
func (s *ResponseStreamUnknownEvent) eventResponseStream() {}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (e *ResponseStreamUnknownEvent) MarshalEvent(pm protocol.PayloadMarshaler) (
	msg eventstream.Message, err error,
) {
	return e.Message.Clone(), nil
}

// UnmarshalEvent unmarshals the EventStream Message into the ResponseStream value.
// This method is only used internally within the SDK's EventStream handling.
func (e *ResponseStreamUnknownEvent) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	e.Message = msg.Clone()
	return nil
}

// Content of a retrieval result.
type RetrievalResultContent struct {
	_ struct{} `type:"structure"`

	// Content of a retrieval result in text
	//
	// Text is a required field
	Text *string `locationName:"text" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetrievalResultContent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetrievalResultContent) GoString() string {
	return s.String()
}

// SetText sets the Text field's value.
func (s *RetrievalResultContent) SetText(v string) *RetrievalResultContent {
	s.Text = &v
	return s
}

// The source location of a retrieval result.
type RetrievalResultLocation struct {
	_ struct{} `type:"structure"`

	// The S3 location of a retrieval result.
	S3Location *RetrievalResultS3Location `locationName:"s3Location" type:"structure"`

	// The location type of a retrieval result.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"RetrievalResultLocationType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetrievalResultLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetrievalResultLocation) GoString() string {
	return s.String()
}

// SetS3Location sets the S3Location field's value.
func (s *RetrievalResultLocation) SetS3Location(v *RetrievalResultS3Location) *RetrievalResultLocation {
	s.S3Location = v
	return s
}

// SetType sets the Type field's value.
func (s *RetrievalResultLocation) SetType(v string) *RetrievalResultLocation {
	s.Type = &v
	return s
}

// The S3 location of a retrieval result.
type RetrievalResultS3Location struct {
	_ struct{} `type:"structure"`

	// URI of S3 location
	Uri *string `locationName:"uri" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetrievalResultS3Location) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetrievalResultS3Location) GoString() string {
	return s.String()
}

// SetUri sets the Uri field's value.
func (s *RetrievalResultS3Location) SetUri(v string) *RetrievalResultS3Location {
	s.Uri = &v
	return s
}

// Configures the retrieval and generation for the session.
type RetrieveAndGenerateConfiguration struct {
	_ struct{} `type:"structure"`

	// Configurations for retrieval and generation for knowledge base.
	KnowledgeBaseConfiguration *KnowledgeBaseRetrieveAndGenerateConfiguration `locationName:"knowledgeBaseConfiguration" type:"structure"`

	// The type of RetrieveAndGenerate.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"RetrieveAndGenerateType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetrieveAndGenerateConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetrieveAndGenerateConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RetrieveAndGenerateConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RetrieveAndGenerateConfiguration"}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.KnowledgeBaseConfiguration != nil {
		if err := s.KnowledgeBaseConfiguration.Validate(); err != nil {
			invalidParams.AddNested("KnowledgeBaseConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKnowledgeBaseConfiguration sets the KnowledgeBaseConfiguration field's value.
func (s *RetrieveAndGenerateConfiguration) SetKnowledgeBaseConfiguration(v *KnowledgeBaseRetrieveAndGenerateConfiguration) *RetrieveAndGenerateConfiguration {
	s.KnowledgeBaseConfiguration = v
	return s
}

// SetType sets the Type field's value.
func (s *RetrieveAndGenerateConfiguration) SetType(v string) *RetrieveAndGenerateConfiguration {
	s.Type = &v
	return s
}

type RetrieveAndGenerateInput struct {
	_ struct{} `type:"structure"`

	// Customer input of the turn
	//
	// Input is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by RetrieveAndGenerateInput's
	// String and GoString methods.
	//
	// Input is a required field
	Input *RetrieveAndGenerateInput_ `locationName:"input" type:"structure" required:"true" sensitive:"true"`

	// Configures the retrieval and generation for the session.
	RetrieveAndGenerateConfiguration *RetrieveAndGenerateConfiguration `locationName:"retrieveAndGenerateConfiguration" type:"structure"`

	// Configures common parameters of the session.
	SessionConfiguration *RetrieveAndGenerateSessionConfiguration `locationName:"sessionConfiguration" type:"structure"`

	// Identifier of the session.
	SessionId *string `locationName:"sessionId" min:"2" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetrieveAndGenerateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetrieveAndGenerateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RetrieveAndGenerateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RetrieveAndGenerateInput"}
	if s.Input == nil {
		invalidParams.Add(request.NewErrParamRequired("Input"))
	}
	if s.SessionId != nil && len(*s.SessionId) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("SessionId", 2))
	}
	if s.Input != nil {
		if err := s.Input.Validate(); err != nil {
			invalidParams.AddNested("Input", err.(request.ErrInvalidParams))
		}
	}
	if s.RetrieveAndGenerateConfiguration != nil {
		if err := s.RetrieveAndGenerateConfiguration.Validate(); err != nil {
			invalidParams.AddNested("RetrieveAndGenerateConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.SessionConfiguration != nil {
		if err := s.SessionConfiguration.Validate(); err != nil {
			invalidParams.AddNested("SessionConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInput sets the Input field's value.
func (s *RetrieveAndGenerateInput) SetInput(v *RetrieveAndGenerateInput_) *RetrieveAndGenerateInput {
	s.Input = v
	return s
}

// SetRetrieveAndGenerateConfiguration sets the RetrieveAndGenerateConfiguration field's value.
func (s *RetrieveAndGenerateInput) SetRetrieveAndGenerateConfiguration(v *RetrieveAndGenerateConfiguration) *RetrieveAndGenerateInput {
	s.RetrieveAndGenerateConfiguration = v
	return s
}

// SetSessionConfiguration sets the SessionConfiguration field's value.
func (s *RetrieveAndGenerateInput) SetSessionConfiguration(v *RetrieveAndGenerateSessionConfiguration) *RetrieveAndGenerateInput {
	s.SessionConfiguration = v
	return s
}

// SetSessionId sets the SessionId field's value.
func (s *RetrieveAndGenerateInput) SetSessionId(v string) *RetrieveAndGenerateInput {
	s.SessionId = &v
	return s
}

// Customer input of the turn
type RetrieveAndGenerateInput_ struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// Customer input of the turn in text
	//
	// Text is a required field
	Text *string `locationName:"text" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetrieveAndGenerateInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetrieveAndGenerateInput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RetrieveAndGenerateInput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RetrieveAndGenerateInput_"}
	if s.Text == nil {
		invalidParams.Add(request.NewErrParamRequired("Text"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetText sets the Text field's value.
func (s *RetrieveAndGenerateInput_) SetText(v string) *RetrieveAndGenerateInput_ {
	s.Text = &v
	return s
}

type RetrieveAndGenerateOutput struct {
	_ struct{} `type:"structure"`

	// List of citations
	Citations []*Citation `locationName:"citations" type:"list"`

	// Service response of the turn
	//
	// Output is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by RetrieveAndGenerateOutput's
	// String and GoString methods.
	//
	// Output is a required field
	Output *RetrieveAndGenerateOutput_ `locationName:"output" type:"structure" required:"true" sensitive:"true"`

	// Identifier of the session.
	//
	// SessionId is a required field
	SessionId *string `locationName:"sessionId" min:"2" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetrieveAndGenerateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetrieveAndGenerateOutput) GoString() string {
	return s.String()
}

// SetCitations sets the Citations field's value.
func (s *RetrieveAndGenerateOutput) SetCitations(v []*Citation) *RetrieveAndGenerateOutput {
	s.Citations = v
	return s
}

// SetOutput sets the Output field's value.
func (s *RetrieveAndGenerateOutput) SetOutput(v *RetrieveAndGenerateOutput_) *RetrieveAndGenerateOutput {
	s.Output = v
	return s
}

// SetSessionId sets the SessionId field's value.
func (s *RetrieveAndGenerateOutput) SetSessionId(v string) *RetrieveAndGenerateOutput {
	s.SessionId = &v
	return s
}

// Service response of the turn
type RetrieveAndGenerateOutput_ struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// Service response of the turn in text
	//
	// Text is a required field
	Text *string `locationName:"text" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetrieveAndGenerateOutput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetrieveAndGenerateOutput_) GoString() string {
	return s.String()
}

// SetText sets the Text field's value.
func (s *RetrieveAndGenerateOutput_) SetText(v string) *RetrieveAndGenerateOutput_ {
	s.Text = &v
	return s
}

// Configures common parameters of the session.
type RetrieveAndGenerateSessionConfiguration struct {
	_ struct{} `type:"structure"`

	// The KMS key arn to encrypt the customer data of the session.
	//
	// KmsKeyArn is a required field
	KmsKeyArn *string `locationName:"kmsKeyArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetrieveAndGenerateSessionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetrieveAndGenerateSessionConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RetrieveAndGenerateSessionConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RetrieveAndGenerateSessionConfiguration"}
	if s.KmsKeyArn == nil {
		invalidParams.Add(request.NewErrParamRequired("KmsKeyArn"))
	}
	if s.KmsKeyArn != nil && len(*s.KmsKeyArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KmsKeyArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKmsKeyArn sets the KmsKeyArn field's value.
func (s *RetrieveAndGenerateSessionConfiguration) SetKmsKeyArn(v string) *RetrieveAndGenerateSessionConfiguration {
	s.KmsKeyArn = &v
	return s
}

type RetrieveInput struct {
	_ struct{} `type:"structure"`

	// Identifier of the KnowledgeBase
	//
	// KnowledgeBaseId is a required field
	KnowledgeBaseId *string `location:"uri" locationName:"knowledgeBaseId" type:"string" required:"true"`

	// Opaque continuation token of previous paginated response.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// Search parameters for retrieving from knowledge base.
	RetrievalConfiguration *KnowledgeBaseRetrievalConfiguration `locationName:"retrievalConfiguration" type:"structure"`

	// Knowledge base input query.
	//
	// RetrievalQuery is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by RetrieveInput's
	// String and GoString methods.
	//
	// RetrievalQuery is a required field
	RetrievalQuery *KnowledgeBaseQuery `locationName:"retrievalQuery" type:"structure" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetrieveInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetrieveInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RetrieveInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RetrieveInput"}
	if s.KnowledgeBaseId == nil {
		invalidParams.Add(request.NewErrParamRequired("KnowledgeBaseId"))
	}
	if s.KnowledgeBaseId != nil && len(*s.KnowledgeBaseId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KnowledgeBaseId", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.RetrievalQuery == nil {
		invalidParams.Add(request.NewErrParamRequired("RetrievalQuery"))
	}
	if s.RetrievalConfiguration != nil {
		if err := s.RetrievalConfiguration.Validate(); err != nil {
			invalidParams.AddNested("RetrievalConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.RetrievalQuery != nil {
		if err := s.RetrievalQuery.Validate(); err != nil {
			invalidParams.AddNested("RetrievalQuery", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *RetrieveInput) SetKnowledgeBaseId(v string) *RetrieveInput {
	s.KnowledgeBaseId = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *RetrieveInput) SetNextToken(v string) *RetrieveInput {
	s.NextToken = &v
	return s
}

// SetRetrievalConfiguration sets the RetrievalConfiguration field's value.
func (s *RetrieveInput) SetRetrievalConfiguration(v *KnowledgeBaseRetrievalConfiguration) *RetrieveInput {
	s.RetrievalConfiguration = v
	return s
}

// SetRetrievalQuery sets the RetrievalQuery field's value.
func (s *RetrieveInput) SetRetrievalQuery(v *KnowledgeBaseQuery) *RetrieveInput {
	s.RetrievalQuery = v
	return s
}

type RetrieveOutput struct {
	_ struct{} `type:"structure"`

	// Opaque continuation token of previous paginated response.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// List of knowledge base retrieval results
	//
	// RetrievalResults is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by RetrieveOutput's
	// String and GoString methods.
	//
	// RetrievalResults is a required field
	RetrievalResults []*KnowledgeBaseRetrievalResult `locationName:"retrievalResults" type:"list" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetrieveOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetrieveOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *RetrieveOutput) SetNextToken(v string) *RetrieveOutput {
	s.NextToken = &v
	return s
}

// SetRetrievalResults sets the RetrievalResults field's value.
func (s *RetrieveOutput) SetRetrievalResults(v []*KnowledgeBaseRetrievalResult) *RetrieveOutput {
	s.RetrievalResults = v
	return s
}

// Retrieved reference
type RetrievedReference struct {
	_ struct{} `type:"structure"`

	// Content of a retrieval result.
	Content *RetrievalResultContent `locationName:"content" type:"structure"`

	// The source location of a retrieval result.
	Location *RetrievalResultLocation `locationName:"location" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetrievedReference) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetrievedReference) GoString() string {
	return s.String()
}

// SetContent sets the Content field's value.
func (s *RetrievedReference) SetContent(v *RetrievalResultContent) *RetrievedReference {
	s.Content = v
	return s
}

// SetLocation sets the Location field's value.
func (s *RetrievedReference) SetLocation(v *RetrievalResultLocation) *RetrievedReference {
	s.Location = v
	return s
}

// This exception is thrown when a request is made beyond the service quota
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Non Blank String
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

// The ServiceQuotaExceededException is and event in the ResponseStream group of events.
func (s *ServiceQuotaExceededException) eventResponseStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the ServiceQuotaExceededException value.
// This method is only used internally within the SDK's EventStream handling.
func (s *ServiceQuotaExceededException) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *ServiceQuotaExceededException) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.ExceptionMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Session state provided
type SessionState struct {
	_ struct{} `type:"structure"`

	// Prompt Session Attributes
	PromptSessionAttributes map[string]*string `locationName:"promptSessionAttributes" type:"map"`

	// Session Attributes
	SessionAttributes map[string]*string `locationName:"sessionAttributes" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SessionState) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SessionState) GoString() string {
	return s.String()
}

// SetPromptSessionAttributes sets the PromptSessionAttributes field's value.
func (s *SessionState) SetPromptSessionAttributes(v map[string]*string) *SessionState {
	s.PromptSessionAttributes = v
	return s
}

// SetSessionAttributes sets the SessionAttributes field's value.
func (s *SessionState) SetSessionAttributes(v map[string]*string) *SessionState {
	s.SessionAttributes = v
	return s
}

// Span of text
type Span struct {
	_ struct{} `type:"structure"`

	// End of span
	End *int64 `locationName:"end" type:"integer"`

	// Start of span
	Start *int64 `locationName:"start" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Span) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Span) GoString() string {
	return s.String()
}

// SetEnd sets the End field's value.
func (s *Span) SetEnd(v int64) *Span {
	s.End = &v
	return s
}

// SetStart sets the Start field's value.
func (s *Span) SetStart(v int64) *Span {
	s.Start = &v
	return s
}

// Text response part
type TextResponsePart struct {
	_ struct{} `type:"structure"`

	// Span of text
	Span *Span `locationName:"span" type:"structure"`

	// Response part in text
	Text *string `locationName:"text" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TextResponsePart) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TextResponsePart) GoString() string {
	return s.String()
}

// SetSpan sets the Span field's value.
func (s *TextResponsePart) SetSpan(v *Span) *TextResponsePart {
	s.Span = v
	return s
}

// SetText sets the Text field's value.
func (s *TextResponsePart) SetText(v string) *TextResponsePart {
	s.Text = &v
	return s
}

// This exception is thrown when the number of requests exceeds the limit
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Non Blank String
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

// The ThrottlingException is and event in the ResponseStream group of events.
func (s *ThrottlingException) eventResponseStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the ThrottlingException value.
// This method is only used internally within the SDK's EventStream handling.
func (s *ThrottlingException) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *ThrottlingException) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.ExceptionMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Trace contains intermidate response for customer
type Trace struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// Trace Part which is emitted when agent trace could not be generated
	//
	// FailureTrace is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Trace's
	// String and GoString methods.
	FailureTrace *FailureTrace `locationName:"failureTrace" type:"structure" sensitive:"true"`

	// Trace contains intermidate response during orchestration
	//
	// OrchestrationTrace is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Trace's
	// String and GoString methods.
	OrchestrationTrace *OrchestrationTrace `locationName:"orchestrationTrace" type:"structure" sensitive:"true"`

	// Trace Part which contains information related to post processing step
	//
	// PostProcessingTrace is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Trace's
	// String and GoString methods.
	PostProcessingTrace *PostProcessingTrace `locationName:"postProcessingTrace" type:"structure" sensitive:"true"`

	// Trace Part which contains information related to preprocessing step
	//
	// PreProcessingTrace is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Trace's
	// String and GoString methods.
	PreProcessingTrace *PreProcessingTrace `locationName:"preProcessingTrace" type:"structure" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Trace) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Trace) GoString() string {
	return s.String()
}

// SetFailureTrace sets the FailureTrace field's value.
func (s *Trace) SetFailureTrace(v *FailureTrace) *Trace {
	s.FailureTrace = v
	return s
}

// SetOrchestrationTrace sets the OrchestrationTrace field's value.
func (s *Trace) SetOrchestrationTrace(v *OrchestrationTrace) *Trace {
	s.OrchestrationTrace = v
	return s
}

// SetPostProcessingTrace sets the PostProcessingTrace field's value.
func (s *Trace) SetPostProcessingTrace(v *PostProcessingTrace) *Trace {
	s.PostProcessingTrace = v
	return s
}

// SetPreProcessingTrace sets the PreProcessingTrace field's value.
func (s *Trace) SetPreProcessingTrace(v *PreProcessingTrace) *Trace {
	s.PreProcessingTrace = v
	return s
}

// Trace Part which contains intermidate response for customer
type TracePart struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// Identifier of the agent alias.
	AgentAliasId *string `locationName:"agentAliasId" type:"string"`

	// Identifier of the agent.
	AgentId *string `locationName:"agentId" type:"string"`

	// Identifier of the session.
	SessionId *string `locationName:"sessionId" min:"2" type:"string"`

	// Trace contains intermidate response for customer
	//
	// Trace is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by TracePart's
	// String and GoString methods.
	Trace *Trace `locationName:"trace" type:"structure" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TracePart) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TracePart) GoString() string {
	return s.String()
}

// SetAgentAliasId sets the AgentAliasId field's value.
func (s *TracePart) SetAgentAliasId(v string) *TracePart {
	s.AgentAliasId = &v
	return s
}

// SetAgentId sets the AgentId field's value.
func (s *TracePart) SetAgentId(v string) *TracePart {
	s.AgentId = &v
	return s
}

// SetSessionId sets the SessionId field's value.
func (s *TracePart) SetSessionId(v string) *TracePart {
	s.SessionId = &v
	return s
}

// SetTrace sets the Trace field's value.
func (s *TracePart) SetTrace(v *Trace) *TracePart {
	s.Trace = v
	return s
}

// The TracePart is and event in the ResponseStream group of events.
func (s *TracePart) eventResponseStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the TracePart value.
// This method is only used internally within the SDK's EventStream handling.
func (s *TracePart) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *TracePart) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.EventMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

// This exception is thrown when the request's input validation fails
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Non Blank String
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

// The ValidationException is and event in the ResponseStream group of events.
func (s *ValidationException) eventResponseStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the ValidationException value.
// This method is only used internally within the SDK's EventStream handling.
func (s *ValidationException) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *ValidationException) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.ExceptionMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// indicates if agent uses default prompt or overriden prompt
const (
	// CreationModeDefault is a CreationMode enum value
	CreationModeDefault = "DEFAULT"

	// CreationModeOverridden is a CreationMode enum value
	CreationModeOverridden = "OVERRIDDEN"
)

// CreationMode_Values returns all elements of the CreationMode enum
func CreationMode_Values() []string {
	return []string{
		CreationModeDefault,
		CreationModeOverridden,
	}
}

// types of invocations
const (
	// InvocationTypeActionGroup is a InvocationType enum value
	InvocationTypeActionGroup = "ACTION_GROUP"

	// InvocationTypeKnowledgeBase is a InvocationType enum value
	InvocationTypeKnowledgeBase = "KNOWLEDGE_BASE"

	// InvocationTypeFinish is a InvocationType enum value
	InvocationTypeFinish = "FINISH"
)

// InvocationType_Values returns all elements of the InvocationType enum
func InvocationType_Values() []string {
	return []string{
		InvocationTypeActionGroup,
		InvocationTypeKnowledgeBase,
		InvocationTypeFinish,
	}
}

// types of prompts
const (
	// PromptTypePreProcessing is a PromptType enum value
	PromptTypePreProcessing = "PRE_PROCESSING"

	// PromptTypeOrchestration is a PromptType enum value
	PromptTypeOrchestration = "ORCHESTRATION"

	// PromptTypeKnowledgeBaseResponseGeneration is a PromptType enum value
	PromptTypeKnowledgeBaseResponseGeneration = "KNOWLEDGE_BASE_RESPONSE_GENERATION"

	// PromptTypePostProcessing is a PromptType enum value
	PromptTypePostProcessing = "POST_PROCESSING"
)

// PromptType_Values returns all elements of the PromptType enum
func PromptType_Values() []string {
	return []string{
		PromptTypePreProcessing,
		PromptTypeOrchestration,
		PromptTypeKnowledgeBaseResponseGeneration,
		PromptTypePostProcessing,
	}
}

// The location type of a retrieval result.
const (
	// RetrievalResultLocationTypeS3 is a RetrievalResultLocationType enum value
	RetrievalResultLocationTypeS3 = "S3"
)

// RetrievalResultLocationType_Values returns all elements of the RetrievalResultLocationType enum
func RetrievalResultLocationType_Values() []string {
	return []string{
		RetrievalResultLocationTypeS3,
	}
}

// The type of RetrieveAndGenerate.
const (
	// RetrieveAndGenerateTypeKnowledgeBase is a RetrieveAndGenerateType enum value
	RetrieveAndGenerateTypeKnowledgeBase = "KNOWLEDGE_BASE"
)

// RetrieveAndGenerateType_Values returns all elements of the RetrieveAndGenerateType enum
func RetrieveAndGenerateType_Values() []string {
	return []string{
		RetrieveAndGenerateTypeKnowledgeBase,
	}
}

// Parsing error source
const (
	// SourceActionGroup is a Source enum value
	SourceActionGroup = "ACTION_GROUP"

	// SourceKnowledgeBase is a Source enum value
	SourceKnowledgeBase = "KNOWLEDGE_BASE"

	// SourceParser is a Source enum value
	SourceParser = "PARSER"
)

// Source_Values returns all elements of the Source enum
func Source_Values() []string {
	return []string{
		SourceActionGroup,
		SourceKnowledgeBase,
		SourceParser,
	}
}

// types of observations
const (
	// TypeActionGroup is a Type enum value
	TypeActionGroup = "ACTION_GROUP"

	// TypeKnowledgeBase is a Type enum value
	TypeKnowledgeBase = "KNOWLEDGE_BASE"

	// TypeFinish is a Type enum value
	TypeFinish = "FINISH"

	// TypeAskUser is a Type enum value
	TypeAskUser = "ASK_USER"

	// TypeReprompt is a Type enum value
	TypeReprompt = "REPROMPT"
)

// Type_Values returns all elements of the Type enum
func Type_Values() []string {
	return []string{
		TypeActionGroup,
		TypeKnowledgeBase,
		TypeFinish,
		TypeAskUser,
		TypeReprompt,
	}
}
