// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package applicationdiscoveryservice provides a client for AWS Application Discovery Service.
package applicationdiscoveryservice

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opCreateTags = "CreateTags"

// CreateTagsRequest generates a "aws/request.Request" representing the
// client's request for the CreateTags operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateTags for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateTags method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateTagsRequest method.
//    req, resp := client.CreateTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ApplicationDiscoveryService) CreateTagsRequest(input *CreateTagsInput) (req *request.Request, output *CreateTagsOutput) {
	op := &request.Operation{
		Name:       opCreateTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTagsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateTagsOutput{}
	req.Data = output
	return
}

// CreateTags API operation for AWS Application Discovery Service.
//
// Creates one or more tags for configuration items. Tags are metadata that
// help you categorize IT assets. This API accepts a list of multiple configuration
// items.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Application Discovery Service's
// API operation CreateTags for usage and error information.
//
// Returned Error Codes:
//   * AuthorizationErrorException
//   The AWS user account does not have permission to perform the action. Check
//   the IAM policy associated with this account.
//
//   * ResourceNotFoundException
//   The specified configuration ID was not located. Verify the configuration
//   ID and try again.
//
//   * InvalidParameterException
//   One or more parameters are not valid. Verify the parameters and try again.
//
//   * InvalidParameterValueException
//   The value of one or more parameters are either invalid or out of range. Verify
//   the parameter values and try again.
//
//   * ServerInternalErrorException
//   The server experienced an internal error. Try again.
//
func (c *ApplicationDiscoveryService) CreateTags(input *CreateTagsInput) (*CreateTagsOutput, error) {
	req, out := c.CreateTagsRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteTags = "DeleteTags"

// DeleteTagsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTags operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteTags for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteTags method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteTagsRequest method.
//    req, resp := client.DeleteTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ApplicationDiscoveryService) DeleteTagsRequest(input *DeleteTagsInput) (req *request.Request, output *DeleteTagsOutput) {
	op := &request.Operation{
		Name:       opDeleteTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTagsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteTagsOutput{}
	req.Data = output
	return
}

// DeleteTags API operation for AWS Application Discovery Service.
//
// Deletes the association between configuration items and one or more tags.
// This API accepts a list of multiple configuration items.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Application Discovery Service's
// API operation DeleteTags for usage and error information.
//
// Returned Error Codes:
//   * AuthorizationErrorException
//   The AWS user account does not have permission to perform the action. Check
//   the IAM policy associated with this account.
//
//   * ResourceNotFoundException
//   The specified configuration ID was not located. Verify the configuration
//   ID and try again.
//
//   * InvalidParameterException
//   One or more parameters are not valid. Verify the parameters and try again.
//
//   * InvalidParameterValueException
//   The value of one or more parameters are either invalid or out of range. Verify
//   the parameter values and try again.
//
//   * ServerInternalErrorException
//   The server experienced an internal error. Try again.
//
func (c *ApplicationDiscoveryService) DeleteTags(input *DeleteTagsInput) (*DeleteTagsOutput, error) {
	req, out := c.DeleteTagsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeAgents = "DescribeAgents"

// DescribeAgentsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAgents operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeAgents for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeAgents method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeAgentsRequest method.
//    req, resp := client.DescribeAgentsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ApplicationDiscoveryService) DescribeAgentsRequest(input *DescribeAgentsInput) (req *request.Request, output *DescribeAgentsOutput) {
	op := &request.Operation{
		Name:       opDescribeAgents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAgentsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeAgentsOutput{}
	req.Data = output
	return
}

// DescribeAgents API operation for AWS Application Discovery Service.
//
// Lists AWS agents by ID or lists all agents associated with your user account
// if you did not specify an agent ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Application Discovery Service's
// API operation DescribeAgents for usage and error information.
//
// Returned Error Codes:
//   * AuthorizationErrorException
//   The AWS user account does not have permission to perform the action. Check
//   the IAM policy associated with this account.
//
//   * InvalidParameterException
//   One or more parameters are not valid. Verify the parameters and try again.
//
//   * InvalidParameterValueException
//   The value of one or more parameters are either invalid or out of range. Verify
//   the parameter values and try again.
//
//   * ServerInternalErrorException
//   The server experienced an internal error. Try again.
//
func (c *ApplicationDiscoveryService) DescribeAgents(input *DescribeAgentsInput) (*DescribeAgentsOutput, error) {
	req, out := c.DescribeAgentsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeConfigurations = "DescribeConfigurations"

// DescribeConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeConfigurations operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeConfigurations for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeConfigurations method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeConfigurationsRequest method.
//    req, resp := client.DescribeConfigurationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ApplicationDiscoveryService) DescribeConfigurationsRequest(input *DescribeConfigurationsInput) (req *request.Request, output *DescribeConfigurationsOutput) {
	op := &request.Operation{
		Name:       opDescribeConfigurations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeConfigurationsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeConfigurationsOutput{}
	req.Data = output
	return
}

// DescribeConfigurations API operation for AWS Application Discovery Service.
//
// Retrieves a list of attributes for a specific configuration ID. For example,
// the output for a server configuration item includes a list of attributes
// about the server, including host name, operating system, number of network
// cards, etc.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Application Discovery Service's
// API operation DescribeConfigurations for usage and error information.
//
// Returned Error Codes:
//   * AuthorizationErrorException
//   The AWS user account does not have permission to perform the action. Check
//   the IAM policy associated with this account.
//
//   * InvalidParameterException
//   One or more parameters are not valid. Verify the parameters and try again.
//
//   * InvalidParameterValueException
//   The value of one or more parameters are either invalid or out of range. Verify
//   the parameter values and try again.
//
//   * ServerInternalErrorException
//   The server experienced an internal error. Try again.
//
func (c *ApplicationDiscoveryService) DescribeConfigurations(input *DescribeConfigurationsInput) (*DescribeConfigurationsOutput, error) {
	req, out := c.DescribeConfigurationsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeExportConfigurations = "DescribeExportConfigurations"

// DescribeExportConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeExportConfigurations operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeExportConfigurations for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeExportConfigurations method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeExportConfigurationsRequest method.
//    req, resp := client.DescribeExportConfigurationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ApplicationDiscoveryService) DescribeExportConfigurationsRequest(input *DescribeExportConfigurationsInput) (req *request.Request, output *DescribeExportConfigurationsOutput) {
	op := &request.Operation{
		Name:       opDescribeExportConfigurations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeExportConfigurationsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeExportConfigurationsOutput{}
	req.Data = output
	return
}

// DescribeExportConfigurations API operation for AWS Application Discovery Service.
//
// Retrieves the status of a given export process. You can retrieve status from
// a maximum of 100 processes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Application Discovery Service's
// API operation DescribeExportConfigurations for usage and error information.
//
// Returned Error Codes:
//   * AuthorizationErrorException
//   The AWS user account does not have permission to perform the action. Check
//   the IAM policy associated with this account.
//
//   * ResourceNotFoundException
//   The specified configuration ID was not located. Verify the configuration
//   ID and try again.
//
//   * InvalidParameterException
//   One or more parameters are not valid. Verify the parameters and try again.
//
//   * InvalidParameterValueException
//   The value of one or more parameters are either invalid or out of range. Verify
//   the parameter values and try again.
//
//   * ServerInternalErrorException
//   The server experienced an internal error. Try again.
//
func (c *ApplicationDiscoveryService) DescribeExportConfigurations(input *DescribeExportConfigurationsInput) (*DescribeExportConfigurationsOutput, error) {
	req, out := c.DescribeExportConfigurationsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeTags = "DescribeTags"

// DescribeTagsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTags operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeTags for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeTags method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeTagsRequest method.
//    req, resp := client.DescribeTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ApplicationDiscoveryService) DescribeTagsRequest(input *DescribeTagsInput) (req *request.Request, output *DescribeTagsOutput) {
	op := &request.Operation{
		Name:       opDescribeTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTagsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeTagsOutput{}
	req.Data = output
	return
}

// DescribeTags API operation for AWS Application Discovery Service.
//
// Retrieves a list of configuration items that are tagged with a specific tag.
// Or retrieves a list of all tags assigned to a specific configuration item.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Application Discovery Service's
// API operation DescribeTags for usage and error information.
//
// Returned Error Codes:
//   * AuthorizationErrorException
//   The AWS user account does not have permission to perform the action. Check
//   the IAM policy associated with this account.
//
//   * ResourceNotFoundException
//   The specified configuration ID was not located. Verify the configuration
//   ID and try again.
//
//   * InvalidParameterException
//   One or more parameters are not valid. Verify the parameters and try again.
//
//   * InvalidParameterValueException
//   The value of one or more parameters are either invalid or out of range. Verify
//   the parameter values and try again.
//
//   * ServerInternalErrorException
//   The server experienced an internal error. Try again.
//
func (c *ApplicationDiscoveryService) DescribeTags(input *DescribeTagsInput) (*DescribeTagsOutput, error) {
	req, out := c.DescribeTagsRequest(input)
	err := req.Send()
	return out, err
}

const opExportConfigurations = "ExportConfigurations"

// ExportConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the ExportConfigurations operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ExportConfigurations for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ExportConfigurations method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ExportConfigurationsRequest method.
//    req, resp := client.ExportConfigurationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ApplicationDiscoveryService) ExportConfigurationsRequest(input *ExportConfigurationsInput) (req *request.Request, output *ExportConfigurationsOutput) {
	op := &request.Operation{
		Name:       opExportConfigurations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ExportConfigurationsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ExportConfigurationsOutput{}
	req.Data = output
	return
}

// ExportConfigurations API operation for AWS Application Discovery Service.
//
// Exports all discovered configuration data to an Amazon S3 bucket or an application
// that enables you to view and evaluate the data. Data includes tags and tag
// associations, processes, connections, servers, and system performance. This
// API returns an export ID which you can query using the GetExportStatus API.
// The system imposes a limit of two configuration exports in six hours.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Application Discovery Service's
// API operation ExportConfigurations for usage and error information.
//
// Returned Error Codes:
//   * AuthorizationErrorException
//   The AWS user account does not have permission to perform the action. Check
//   the IAM policy associated with this account.
//
//   * InvalidParameterException
//   One or more parameters are not valid. Verify the parameters and try again.
//
//   * InvalidParameterValueException
//   The value of one or more parameters are either invalid or out of range. Verify
//   the parameter values and try again.
//
//   * ServerInternalErrorException
//   The server experienced an internal error. Try again.
//
//   * OperationNotPermittedException
//   This operation is not permitted.
//
func (c *ApplicationDiscoveryService) ExportConfigurations(input *ExportConfigurationsInput) (*ExportConfigurationsOutput, error) {
	req, out := c.ExportConfigurationsRequest(input)
	err := req.Send()
	return out, err
}

const opListConfigurations = "ListConfigurations"

// ListConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the ListConfigurations operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListConfigurations for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListConfigurations method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListConfigurationsRequest method.
//    req, resp := client.ListConfigurationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ApplicationDiscoveryService) ListConfigurationsRequest(input *ListConfigurationsInput) (req *request.Request, output *ListConfigurationsOutput) {
	op := &request.Operation{
		Name:       opListConfigurations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListConfigurationsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListConfigurationsOutput{}
	req.Data = output
	return
}

// ListConfigurations API operation for AWS Application Discovery Service.
//
// Retrieves a list of configurations items according to the criteria you specify
// in a filter. The filter criteria identify relationship requirements.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Application Discovery Service's
// API operation ListConfigurations for usage and error information.
//
// Returned Error Codes:
//   * AuthorizationErrorException
//   The AWS user account does not have permission to perform the action. Check
//   the IAM policy associated with this account.
//
//   * ResourceNotFoundException
//   The specified configuration ID was not located. Verify the configuration
//   ID and try again.
//
//   * InvalidParameterException
//   One or more parameters are not valid. Verify the parameters and try again.
//
//   * InvalidParameterValueException
//   The value of one or more parameters are either invalid or out of range. Verify
//   the parameter values and try again.
//
//   * ServerInternalErrorException
//   The server experienced an internal error. Try again.
//
func (c *ApplicationDiscoveryService) ListConfigurations(input *ListConfigurationsInput) (*ListConfigurationsOutput, error) {
	req, out := c.ListConfigurationsRequest(input)
	err := req.Send()
	return out, err
}

const opStartDataCollectionByAgentIds = "StartDataCollectionByAgentIds"

// StartDataCollectionByAgentIdsRequest generates a "aws/request.Request" representing the
// client's request for the StartDataCollectionByAgentIds operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See StartDataCollectionByAgentIds for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the StartDataCollectionByAgentIds method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the StartDataCollectionByAgentIdsRequest method.
//    req, resp := client.StartDataCollectionByAgentIdsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ApplicationDiscoveryService) StartDataCollectionByAgentIdsRequest(input *StartDataCollectionByAgentIdsInput) (req *request.Request, output *StartDataCollectionByAgentIdsOutput) {
	op := &request.Operation{
		Name:       opStartDataCollectionByAgentIds,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartDataCollectionByAgentIdsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &StartDataCollectionByAgentIdsOutput{}
	req.Data = output
	return
}

// StartDataCollectionByAgentIds API operation for AWS Application Discovery Service.
//
// Instructs the specified agents to start collecting data. Agents can reside
// on host servers or virtual machines in your data center.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Application Discovery Service's
// API operation StartDataCollectionByAgentIds for usage and error information.
//
// Returned Error Codes:
//   * AuthorizationErrorException
//   The AWS user account does not have permission to perform the action. Check
//   the IAM policy associated with this account.
//
//   * InvalidParameterException
//   One or more parameters are not valid. Verify the parameters and try again.
//
//   * InvalidParameterValueException
//   The value of one or more parameters are either invalid or out of range. Verify
//   the parameter values and try again.
//
//   * ServerInternalErrorException
//   The server experienced an internal error. Try again.
//
func (c *ApplicationDiscoveryService) StartDataCollectionByAgentIds(input *StartDataCollectionByAgentIdsInput) (*StartDataCollectionByAgentIdsOutput, error) {
	req, out := c.StartDataCollectionByAgentIdsRequest(input)
	err := req.Send()
	return out, err
}

const opStopDataCollectionByAgentIds = "StopDataCollectionByAgentIds"

// StopDataCollectionByAgentIdsRequest generates a "aws/request.Request" representing the
// client's request for the StopDataCollectionByAgentIds operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See StopDataCollectionByAgentIds for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the StopDataCollectionByAgentIds method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the StopDataCollectionByAgentIdsRequest method.
//    req, resp := client.StopDataCollectionByAgentIdsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ApplicationDiscoveryService) StopDataCollectionByAgentIdsRequest(input *StopDataCollectionByAgentIdsInput) (req *request.Request, output *StopDataCollectionByAgentIdsOutput) {
	op := &request.Operation{
		Name:       opStopDataCollectionByAgentIds,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopDataCollectionByAgentIdsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &StopDataCollectionByAgentIdsOutput{}
	req.Data = output
	return
}

// StopDataCollectionByAgentIds API operation for AWS Application Discovery Service.
//
// Instructs the specified agents to stop collecting data.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Application Discovery Service's
// API operation StopDataCollectionByAgentIds for usage and error information.
//
// Returned Error Codes:
//   * AuthorizationErrorException
//   The AWS user account does not have permission to perform the action. Check
//   the IAM policy associated with this account.
//
//   * InvalidParameterException
//   One or more parameters are not valid. Verify the parameters and try again.
//
//   * InvalidParameterValueException
//   The value of one or more parameters are either invalid or out of range. Verify
//   the parameter values and try again.
//
//   * ServerInternalErrorException
//   The server experienced an internal error. Try again.
//
func (c *ApplicationDiscoveryService) StopDataCollectionByAgentIds(input *StopDataCollectionByAgentIdsInput) (*StopDataCollectionByAgentIdsOutput, error) {
	req, out := c.StopDataCollectionByAgentIdsRequest(input)
	err := req.Send()
	return out, err
}

// Information about agents that were instructed to start collecting data. Information
// includes the agent ID, a description of the operation, and whether or not
// the agent configuration was updated.
type AgentConfigurationStatus struct {
	_ struct{} `type:"structure"`

	// The agent ID.
	AgentId *string `locationName:"agentId" type:"string"`

	// A description of the operation performed.
	Description *string `locationName:"description" type:"string"`

	// Information about the status of the StartDataCollection and StopDataCollection
	// operations. The system has recorded the data collection operation. The agent
	// receives this command the next time it polls for a new command.
	OperationSucceeded *bool `locationName:"operationSucceeded" type:"boolean"`
}

// String returns the string representation
func (s AgentConfigurationStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AgentConfigurationStatus) GoString() string {
	return s.String()
}

// Information about agents associated with the user’s AWS account. Information
// includes agent IDs, IP addresses, media access control (MAC) addresses, agent
// health, hostname where the agent resides, and agent version for each agent.
type AgentInfo struct {
	_ struct{} `type:"structure"`

	// The agent ID.
	AgentId *string `locationName:"agentId" type:"string"`

	// Network details about the host where the agent resides.
	AgentNetworkInfoList []*AgentNetworkInfo `locationName:"agentNetworkInfoList" type:"list"`

	// This data type is currently not valid.
	ConnectorId *string `locationName:"connectorId" type:"string"`

	// The health of the agent.
	Health *string `locationName:"health" type:"string" enum:"AgentStatus"`

	// The name of the host where the agent resides. The host can be a server or
	// virtual machine.
	HostName *string `locationName:"hostName" type:"string"`

	// The agent version.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation
func (s AgentInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AgentInfo) GoString() string {
	return s.String()
}

// Network details about the host where the agent resides.
type AgentNetworkInfo struct {
	_ struct{} `type:"structure"`

	// The IP address for the host where the agent resides.
	IpAddress *string `locationName:"ipAddress" type:"string"`

	// The MAC address for the host where the agent resides.
	MacAddress *string `locationName:"macAddress" type:"string"`
}

// String returns the string representation
func (s AgentNetworkInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AgentNetworkInfo) GoString() string {
	return s.String()
}

// Tags for a configuration item. Tags are metadata that help you categorize
// IT assets.
type ConfigurationTag struct {
	_ struct{} `type:"structure"`

	// The configuration ID for the item you want to tag. You can specify a list
	// of keys and values.
	ConfigurationId *string `locationName:"configurationId" type:"string"`

	// A type of IT asset that you want to tag.
	ConfigurationType *string `locationName:"configurationType" type:"string" enum:"ConfigurationItemType"`

	// A type of tag to filter on. For example, serverType.
	Key *string `locationName:"key" type:"string"`

	// The time the configuration tag was created in Coordinated Universal Time
	// (UTC).
	TimeOfCreation *time.Time `locationName:"timeOfCreation" type:"timestamp" timestampFormat:"unix"`

	// A value to filter on. For example key = serverType and value = web server.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation
func (s ConfigurationTag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfigurationTag) GoString() string {
	return s.String()
}

type CreateTagsInput struct {
	_ struct{} `type:"structure"`

	// A list of configuration items that you want to tag.
	//
	// ConfigurationIds is a required field
	ConfigurationIds []*string `locationName:"configurationIds" type:"list" required:"true"`

	// Tags that you want to associate with one or more configuration items. Specify
	// the tags that you want to create in a key-value format. For example:
	//
	// {"key": "serverType", "value": "webServer"}
	//
	// Tags is a required field
	Tags []*Tag `locationName:"tags" locationNameList:"item" type:"list" required:"true"`
}

// String returns the string representation
func (s CreateTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTagsInput"}
	if s.ConfigurationIds == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationIds"))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateTagsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTagsOutput) GoString() string {
	return s.String()
}

type DeleteTagsInput struct {
	_ struct{} `type:"structure"`

	// A list of configuration items with tags that you want to delete.
	//
	// ConfigurationIds is a required field
	ConfigurationIds []*string `locationName:"configurationIds" type:"list" required:"true"`

	// Tags that you want to delete from one or more configuration items. Specify
	// the tags that you want to delete in a key-value format. For example:
	//
	// {"key": "serverType", "value": "webServer"}
	Tags []*Tag `locationName:"tags" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DeleteTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTagsInput"}
	if s.ConfigurationIds == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationIds"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteTagsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTagsOutput) GoString() string {
	return s.String()
}

type DescribeAgentsInput struct {
	_ struct{} `type:"structure"`

	// The agent IDs for which you want information. If you specify no IDs, the
	// system returns information about all agents associated with your AWS user
	// account.
	AgentIds []*string `locationName:"agentIds" type:"list"`

	// The total number of agents to return. The maximum value is 100.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// A token to start the list. Use this token to get the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeAgentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAgentsInput) GoString() string {
	return s.String()
}

type DescribeAgentsOutput struct {
	_ struct{} `type:"structure"`

	// Lists AWS agents by ID or lists all agents associated with your user account
	// if you did not specify an agent ID. The output includes agent IDs, IP addresses,
	// media access control (MAC) addresses, agent health, host name where the agent
	// resides, and the version number of each agent.
	AgentsInfo []*AgentInfo `locationName:"agentsInfo" type:"list"`

	// The call returns a token. Use this token to get the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeAgentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAgentsOutput) GoString() string {
	return s.String()
}

type DescribeConfigurationsInput struct {
	_ struct{} `type:"structure"`

	// One or more configuration IDs.
	//
	// ConfigurationIds is a required field
	ConfigurationIds []*string `locationName:"configurationIds" type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConfigurationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeConfigurationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeConfigurationsInput"}
	if s.ConfigurationIds == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// A key in the response map. The value is an array of data.
	Configurations []map[string]*string `locationName:"configurations" type:"list"`
}

// String returns the string representation
func (s DescribeConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConfigurationsOutput) GoString() string {
	return s.String()
}

type DescribeExportConfigurationsInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier that you can use to query the export status.
	ExportIds []*string `locationName:"exportIds" type:"list"`

	// The maximum number of results that you want to display as a part of the query.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// A token to get the next set of results. For example, if you specified 100
	// IDs for DescribeConfigurationsRequest$configurationIds but set DescribeExportConfigurationsRequest$maxResults
	// to 10, you will get results in a set of 10. Use the token in the query to
	// get the next set of 10.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeExportConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeExportConfigurationsInput) GoString() string {
	return s.String()
}

type DescribeExportConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// Returns export details. When the status is complete, the response includes
	// a URL for an Amazon S3 bucket where you can view the data in a CSV file.
	ExportsInfo []*ExportInfo `locationName:"exportsInfo" type:"list"`

	// A token to get the next set of results. For example, if you specified 100
	// IDs for DescribeConfigurationsRequest$configurationIds but set DescribeExportConfigurationsRequest$maxResults
	// to 10, you will get results in a set of 10. Use the token in the query to
	// get the next set of 10.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeExportConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeExportConfigurationsOutput) GoString() string {
	return s.String()
}

type DescribeTagsInput struct {
	_ struct{} `type:"structure"`

	// You can filter the list using a key-value format. You can separate these
	// items by using logical operators. Allowed filters include tagKey, tagValue,
	// and configurationId.
	Filters []*TagFilter `locationName:"filters" type:"list"`

	// The total number of items to return. The maximum value is 100.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// A token to start the list. Use this token to get the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTagsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeTagsOutput struct {
	_ struct{} `type:"structure"`

	// The call returns a token. Use this token to get the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Depending on the input, this is a list of configuration items tagged with
	// a specific tag, or a list of tags for a specific configuration item.
	Tags []*ConfigurationTag `locationName:"tags" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTagsOutput) GoString() string {
	return s.String()
}

type ExportConfigurationsInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ExportConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExportConfigurationsInput) GoString() string {
	return s.String()
}

type ExportConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// A unique identifier that you can use to query the export status.
	ExportId *string `locationName:"exportId" type:"string"`
}

// String returns the string representation
func (s ExportConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExportConfigurationsOutput) GoString() string {
	return s.String()
}

// Information regarding the export status of the discovered data. The value
// is an array of objects.
type ExportInfo struct {
	_ struct{} `type:"structure"`

	// A URL for an Amazon S3 bucket where you can review the configuration data.
	// The URL is displayed only if the export succeeded.
	ConfigurationsDownloadUrl *string `locationName:"configurationsDownloadUrl" type:"string"`

	// A unique identifier that you can use to query the export.
	//
	// ExportId is a required field
	ExportId *string `locationName:"exportId" type:"string" required:"true"`

	// The time the configuration data export was initiated.
	//
	// ExportRequestTime is a required field
	ExportRequestTime *time.Time `locationName:"exportRequestTime" type:"timestamp" timestampFormat:"unix" required:"true"`

	// The status of the configuration data export. The status can succeed, fail,
	// or be in-progress.
	//
	// ExportStatus is a required field
	ExportStatus *string `locationName:"exportStatus" type:"string" required:"true" enum:"ExportStatus"`

	// Helpful status messages for API callers. For example: Too many exports in
	// the last 6 hours. Export in progress. Export was successful.
	//
	// StatusMessage is a required field
	StatusMessage *string `locationName:"statusMessage" type:"string" required:"true"`
}

// String returns the string representation
func (s ExportInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExportInfo) GoString() string {
	return s.String()
}

// A filter that can use conditional operators.
type Filter struct {
	_ struct{} `type:"structure"`

	// A conditional operator. The following operators are valid: EQUALS, NOT_EQUALS,
	// CONTAINS, NOT_CONTAINS. If you specify multiple filters, the system utilizes
	// all filters as though concatenated by AND. If you specify multiple values
	// for a particular filter, the system differentiates the values using OR. Calling
	// either DescribeConfigurations or ListConfigurations returns attributes of
	// matching configuration items.
	//
	// Condition is a required field
	Condition *string `locationName:"condition" type:"string" required:"true"`

	// The name of the filter. The following filter names are allowed for SERVER
	// configuration items.
	//
	// Server
	//
	//    * server.hostName
	//
	//    * server.osName
	//
	//    * server.osVersion
	//
	//    * server.configurationid
	//
	//    * server.agentid
	//
	// The name of the filter. The following filter names are allowed for PROCESS
	// configuration items.
	//
	// Process
	//
	//    * process.configurationid
	//
	//    * process.name
	//
	//    * process.commandLine
	//
	//    * server.configurationid
	//
	//    * server.hostName
	//
	//    * server.osName
	//
	//    * server.osVersion
	//
	//    * server.agentId
	//
	// The name of the filter. The following filter names are allowed for CONNECTION
	// configuration items.
	//
	// Connection
	//
	//    * connection.sourceIp
	//
	//    * connection.destinationIp
	//
	//    * connection.destinationPort
	//
	//    * sourceProcess.configurationId
	//
	//    * sourceProcess.name
	//
	//    * sourceProcess.commandLine
	//
	//    * destinationProcess.configurationId
	//
	//    * destinationProcess.name
	//
	//    * destinationProcess.commandLine
	//
	//    * sourceServer.configurationId
	//
	//    * sourceServer.hostName
	//
	//    * sourceServer.osName
	//
	//    * sourceServer.osVersion
	//
	//    * sourceServer.agentId
	//
	//    * destinationServer.configurationId
	//
	//    * destinationServer.hostName
	//
	//    * destinationServer.osName
	//
	//    * destinationServer.osVersion
	//
	//    * destinationServer.agentId
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// A string value that you want to filter on. For example, if you choose the
	// destinationServer.osVersion filter name, you could specify Ubuntu for the
	// value.
	//
	// Values is a required field
	Values []*string `locationName:"values" locationNameList:"item" type:"list" required:"true"`
}

// String returns the string representation
func (s Filter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Filter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Filter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Filter"}
	if s.Condition == nil {
		invalidParams.Add(request.NewErrParamRequired("Condition"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListConfigurationsInput struct {
	_ struct{} `type:"structure"`

	// A valid configuration identified by the Discovery Service.
	//
	// ConfigurationType is a required field
	ConfigurationType *string `locationName:"configurationType" type:"string" required:"true" enum:"ConfigurationItemType"`

	// You can filter the list using a key-value format. For example:
	//
	// {"key": "serverType", "value": "webServer"}
	//
	// You can separate these items by using logical operators.
	Filters []*Filter `locationName:"filters" type:"list"`

	// The total number of items to return. The maximum value is 100.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// A token to start the list. Use this token to get the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListConfigurationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListConfigurationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListConfigurationsInput"}
	if s.ConfigurationType == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationType"))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// Returns configuration details, including the configuration ID, attribute
	// names, and attribute values.
	Configurations []map[string]*string `locationName:"configurations" type:"list"`

	// The call returns a token. Use this token to get the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListConfigurationsOutput) GoString() string {
	return s.String()
}

type StartDataCollectionByAgentIdsInput struct {
	_ struct{} `type:"structure"`

	// The IDs of the agents that you want to start collecting data. If you send
	// a request to an AWS agent ID that you do not have permission to contact,
	// according to your AWS account, the service does not throw an exception. Instead,
	// it returns the error in the Description field. If you send a request to multiple
	// agents and you do not have permission to contact some of those agents, the
	// system does not throw an exception. Instead, the system shows Failed in the
	// Description field.
	//
	// AgentIds is a required field
	AgentIds []*string `locationName:"agentIds" type:"list" required:"true"`
}

// String returns the string representation
func (s StartDataCollectionByAgentIdsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartDataCollectionByAgentIdsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartDataCollectionByAgentIdsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartDataCollectionByAgentIdsInput"}
	if s.AgentIds == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type StartDataCollectionByAgentIdsOutput struct {
	_ struct{} `type:"structure"`

	// Information about agents that were instructed to start collecting data. Information
	// includes the agent ID, a description of the operation performed, and whether
	// or not the agent configuration was updated.
	AgentsConfigurationStatus []*AgentConfigurationStatus `locationName:"agentsConfigurationStatus" type:"list"`
}

// String returns the string representation
func (s StartDataCollectionByAgentIdsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartDataCollectionByAgentIdsOutput) GoString() string {
	return s.String()
}

type StopDataCollectionByAgentIdsInput struct {
	_ struct{} `type:"structure"`

	// The IDs of the agents that you want to stop collecting data.
	//
	// AgentIds is a required field
	AgentIds []*string `locationName:"agentIds" type:"list" required:"true"`
}

// String returns the string representation
func (s StopDataCollectionByAgentIdsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopDataCollectionByAgentIdsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopDataCollectionByAgentIdsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopDataCollectionByAgentIdsInput"}
	if s.AgentIds == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type StopDataCollectionByAgentIdsOutput struct {
	_ struct{} `type:"structure"`

	// Information about agents that were instructed to stop collecting data. Information
	// includes the agent ID, a description of the operation performed, and whether
	// or not the agent configuration was updated.
	AgentsConfigurationStatus []*AgentConfigurationStatus `locationName:"agentsConfigurationStatus" type:"list"`
}

// String returns the string representation
func (s StopDataCollectionByAgentIdsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopDataCollectionByAgentIdsOutput) GoString() string {
	return s.String()
}

// Metadata that help you categorize IT assets.
type Tag struct {
	_ struct{} `type:"structure"`

	// A type of tag to filter on.
	//
	// Key is a required field
	Key *string `locationName:"key" type:"string" required:"true"`

	// A value for a tag key to filter on.
	//
	// Value is a required field
	Value *string `locationName:"value" type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The name of a tag filter. Valid names are: tagKey, tagValue, configurationId.
type TagFilter struct {
	_ struct{} `type:"structure"`

	// A name of a tag filter.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// Values of a tag filter.
	//
	// Values is a required field
	Values []*string `locationName:"values" locationNameList:"item" type:"list" required:"true"`
}

// String returns the string representation
func (s TagFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagFilter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

const (
	// AgentStatusHealthy is a AgentStatus enum value
	AgentStatusHealthy = "HEALTHY"

	// AgentStatusUnhealthy is a AgentStatus enum value
	AgentStatusUnhealthy = "UNHEALTHY"

	// AgentStatusRunning is a AgentStatus enum value
	AgentStatusRunning = "RUNNING"

	// AgentStatusUnknown is a AgentStatus enum value
	AgentStatusUnknown = "UNKNOWN"

	// AgentStatusBlacklisted is a AgentStatus enum value
	AgentStatusBlacklisted = "BLACKLISTED"

	// AgentStatusShutdown is a AgentStatus enum value
	AgentStatusShutdown = "SHUTDOWN"
)

const (
	// ConfigurationItemTypeServer is a ConfigurationItemType enum value
	ConfigurationItemTypeServer = "SERVER"

	// ConfigurationItemTypeProcess is a ConfigurationItemType enum value
	ConfigurationItemTypeProcess = "PROCESS"

	// ConfigurationItemTypeConnection is a ConfigurationItemType enum value
	ConfigurationItemTypeConnection = "CONNECTION"
)

const (
	// ExportStatusFailed is a ExportStatus enum value
	ExportStatusFailed = "FAILED"

	// ExportStatusSucceeded is a ExportStatus enum value
	ExportStatusSucceeded = "SUCCEEDED"

	// ExportStatusInProgress is a ExportStatus enum value
	ExportStatusInProgress = "IN_PROGRESS"
)
