// Code generated by smithy-go-codegen DO NOT EDIT.

package medicalimaging

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/medicalimaging/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpCopyImageSet struct {
}

func (*validateOpCopyImageSet) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCopyImageSet) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CopyImageSetInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCopyImageSetInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateDatastore struct {
}

func (*validateOpCreateDatastore) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateDatastore) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateDatastoreInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateDatastoreInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteDatastore struct {
}

func (*validateOpDeleteDatastore) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteDatastore) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteDatastoreInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteDatastoreInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteImageSet struct {
}

func (*validateOpDeleteImageSet) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteImageSet) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteImageSetInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteImageSetInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetDatastore struct {
}

func (*validateOpGetDatastore) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetDatastore) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetDatastoreInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetDatastoreInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetDICOMImportJob struct {
}

func (*validateOpGetDICOMImportJob) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetDICOMImportJob) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetDICOMImportJobInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetDICOMImportJobInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetImageFrame struct {
}

func (*validateOpGetImageFrame) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetImageFrame) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetImageFrameInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetImageFrameInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetImageSet struct {
}

func (*validateOpGetImageSet) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetImageSet) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetImageSetInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetImageSetInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetImageSetMetadata struct {
}

func (*validateOpGetImageSetMetadata) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetImageSetMetadata) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetImageSetMetadataInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetImageSetMetadataInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListDICOMImportJobs struct {
}

func (*validateOpListDICOMImportJobs) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListDICOMImportJobs) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListDICOMImportJobsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListDICOMImportJobsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListImageSetVersions struct {
}

func (*validateOpListImageSetVersions) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListImageSetVersions) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListImageSetVersionsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListImageSetVersionsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListTagsForResource struct {
}

func (*validateOpListTagsForResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListTagsForResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListTagsForResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListTagsForResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpSearchImageSets struct {
}

func (*validateOpSearchImageSets) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpSearchImageSets) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*SearchImageSetsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpSearchImageSetsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpStartDICOMImportJob struct {
}

func (*validateOpStartDICOMImportJob) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpStartDICOMImportJob) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*StartDICOMImportJobInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpStartDICOMImportJobInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpTagResource struct {
}

func (*validateOpTagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpTagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*TagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpTagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUntagResource struct {
}

func (*validateOpUntagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUntagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UntagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUntagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateImageSetMetadata struct {
}

func (*validateOpUpdateImageSetMetadata) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateImageSetMetadata) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateImageSetMetadataInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateImageSetMetadataInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpCopyImageSetValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCopyImageSet{}, middleware.After)
}

func addOpCreateDatastoreValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateDatastore{}, middleware.After)
}

func addOpDeleteDatastoreValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteDatastore{}, middleware.After)
}

func addOpDeleteImageSetValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteImageSet{}, middleware.After)
}

func addOpGetDatastoreValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetDatastore{}, middleware.After)
}

func addOpGetDICOMImportJobValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetDICOMImportJob{}, middleware.After)
}

func addOpGetImageFrameValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetImageFrame{}, middleware.After)
}

func addOpGetImageSetValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetImageSet{}, middleware.After)
}

func addOpGetImageSetMetadataValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetImageSetMetadata{}, middleware.After)
}

func addOpListDICOMImportJobsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListDICOMImportJobs{}, middleware.After)
}

func addOpListImageSetVersionsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListImageSetVersions{}, middleware.After)
}

func addOpListTagsForResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListTagsForResource{}, middleware.After)
}

func addOpSearchImageSetsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpSearchImageSets{}, middleware.After)
}

func addOpStartDICOMImportJobValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpStartDICOMImportJob{}, middleware.After)
}

func addOpTagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpTagResource{}, middleware.After)
}

func addOpUntagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUntagResource{}, middleware.After)
}

func addOpUpdateImageSetMetadataValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateImageSetMetadata{}, middleware.After)
}

func validateCopyDestinationImageSet(v *types.CopyDestinationImageSet) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CopyDestinationImageSet"}
	if v.ImageSetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ImageSetId"))
	}
	if v.LatestVersionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LatestVersionId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCopyImageSetInformation(v *types.CopyImageSetInformation) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CopyImageSetInformation"}
	if v.SourceImageSet == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SourceImageSet"))
	} else if v.SourceImageSet != nil {
		if err := validateCopySourceImageSetInformation(v.SourceImageSet); err != nil {
			invalidParams.AddNested("SourceImageSet", err.(smithy.InvalidParamsError))
		}
	}
	if v.DestinationImageSet != nil {
		if err := validateCopyDestinationImageSet(v.DestinationImageSet); err != nil {
			invalidParams.AddNested("DestinationImageSet", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCopySourceImageSetInformation(v *types.CopySourceImageSetInformation) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CopySourceImageSetInformation"}
	if v.LatestVersionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LatestVersionId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateDICOMStudyDateAndTime(v *types.DICOMStudyDateAndTime) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DICOMStudyDateAndTime"}
	if v.DICOMStudyDate == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DICOMStudyDate"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateImageFrameInformation(v *types.ImageFrameInformation) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ImageFrameInformation"}
	if v.ImageFrameId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ImageFrameId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSearchByAttributeValue(v types.SearchByAttributeValue) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SearchByAttributeValue"}
	switch uv := v.(type) {
	case *types.SearchByAttributeValueMemberDICOMStudyDateAndTime:
		if err := validateDICOMStudyDateAndTime(&uv.Value); err != nil {
			invalidParams.AddNested("[DICOMStudyDateAndTime]", err.(smithy.InvalidParamsError))
		}

	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSearchByAttributeValues(v []types.SearchByAttributeValue) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SearchByAttributeValues"}
	for i := range v {
		if err := validateSearchByAttributeValue(v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSearchCriteria(v *types.SearchCriteria) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SearchCriteria"}
	if v.Filters != nil {
		if err := validateSearchFilters(v.Filters); err != nil {
			invalidParams.AddNested("Filters", err.(smithy.InvalidParamsError))
		}
	}
	if v.Sort != nil {
		if err := validateSort(v.Sort); err != nil {
			invalidParams.AddNested("Sort", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSearchFilter(v *types.SearchFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SearchFilter"}
	if v.Values == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Values"))
	} else if v.Values != nil {
		if err := validateSearchByAttributeValues(v.Values); err != nil {
			invalidParams.AddNested("Values", err.(smithy.InvalidParamsError))
		}
	}
	if len(v.Operator) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Operator"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSearchFilters(v []types.SearchFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SearchFilters"}
	for i := range v {
		if err := validateSearchFilter(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSort(v *types.Sort) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Sort"}
	if len(v.SortOrder) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("SortOrder"))
	}
	if len(v.SortField) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("SortField"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCopyImageSetInput(v *CopyImageSetInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CopyImageSetInput"}
	if v.DatastoreId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DatastoreId"))
	}
	if v.SourceImageSetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SourceImageSetId"))
	}
	if v.CopyImageSetInformation == nil {
		invalidParams.Add(smithy.NewErrParamRequired("CopyImageSetInformation"))
	} else if v.CopyImageSetInformation != nil {
		if err := validateCopyImageSetInformation(v.CopyImageSetInformation); err != nil {
			invalidParams.AddNested("CopyImageSetInformation", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateDatastoreInput(v *CreateDatastoreInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateDatastoreInput"}
	if v.ClientToken == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClientToken"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteDatastoreInput(v *DeleteDatastoreInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteDatastoreInput"}
	if v.DatastoreId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DatastoreId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteImageSetInput(v *DeleteImageSetInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteImageSetInput"}
	if v.DatastoreId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DatastoreId"))
	}
	if v.ImageSetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ImageSetId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetDatastoreInput(v *GetDatastoreInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetDatastoreInput"}
	if v.DatastoreId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DatastoreId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetDICOMImportJobInput(v *GetDICOMImportJobInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetDICOMImportJobInput"}
	if v.DatastoreId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DatastoreId"))
	}
	if v.JobId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("JobId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetImageFrameInput(v *GetImageFrameInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetImageFrameInput"}
	if v.DatastoreId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DatastoreId"))
	}
	if v.ImageSetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ImageSetId"))
	}
	if v.ImageFrameInformation == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ImageFrameInformation"))
	} else if v.ImageFrameInformation != nil {
		if err := validateImageFrameInformation(v.ImageFrameInformation); err != nil {
			invalidParams.AddNested("ImageFrameInformation", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetImageSetInput(v *GetImageSetInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetImageSetInput"}
	if v.DatastoreId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DatastoreId"))
	}
	if v.ImageSetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ImageSetId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetImageSetMetadataInput(v *GetImageSetMetadataInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetImageSetMetadataInput"}
	if v.DatastoreId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DatastoreId"))
	}
	if v.ImageSetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ImageSetId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListDICOMImportJobsInput(v *ListDICOMImportJobsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListDICOMImportJobsInput"}
	if v.DatastoreId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DatastoreId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListImageSetVersionsInput(v *ListImageSetVersionsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListImageSetVersionsInput"}
	if v.DatastoreId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DatastoreId"))
	}
	if v.ImageSetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ImageSetId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListTagsForResourceInput(v *ListTagsForResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListTagsForResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpSearchImageSetsInput(v *SearchImageSetsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SearchImageSetsInput"}
	if v.DatastoreId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DatastoreId"))
	}
	if v.SearchCriteria != nil {
		if err := validateSearchCriteria(v.SearchCriteria); err != nil {
			invalidParams.AddNested("SearchCriteria", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpStartDICOMImportJobInput(v *StartDICOMImportJobInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StartDICOMImportJobInput"}
	if v.DataAccessRoleArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DataAccessRoleArn"))
	}
	if v.ClientToken == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClientToken"))
	}
	if v.DatastoreId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DatastoreId"))
	}
	if v.InputS3Uri == nil {
		invalidParams.Add(smithy.NewErrParamRequired("InputS3Uri"))
	}
	if v.OutputS3Uri == nil {
		invalidParams.Add(smithy.NewErrParamRequired("OutputS3Uri"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpTagResourceInput(v *TagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.Tags == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Tags"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUntagResourceInput(v *UntagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UntagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.TagKeys == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TagKeys"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateImageSetMetadataInput(v *UpdateImageSetMetadataInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateImageSetMetadataInput"}
	if v.DatastoreId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DatastoreId"))
	}
	if v.ImageSetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ImageSetId"))
	}
	if v.LatestVersionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LatestVersionId"))
	}
	if v.UpdateImageSetMetadataUpdates == nil {
		invalidParams.Add(smithy.NewErrParamRequired("UpdateImageSetMetadataUpdates"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
