// Code generated by smithy-go-codegen DO NOT EDIT.

package controltower

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/controltower/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists all landing zone operations from the past 90 days. Results are sorted by
// time, with the most recent operation first.
func (c *Client) ListLandingZoneOperations(ctx context.Context, params *ListLandingZoneOperationsInput, optFns ...func(*Options)) (*ListLandingZoneOperationsOutput, error) {
	if params == nil {
		params = &ListLandingZoneOperationsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListLandingZoneOperations", params, optFns, c.addOperationListLandingZoneOperationsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListLandingZoneOperationsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListLandingZoneOperationsInput struct {

	// An input filter for the ListLandingZoneOperations API that lets you select the
	// types of landing zone operations to view.
	Filter *types.LandingZoneOperationFilter

	// How many results to return per API call.
	MaxResults *int32

	// The token to continue the list from a previous API call with the same
	// parameters.
	NextToken *string

	noSmithyDocumentSerde
}

type ListLandingZoneOperationsOutput struct {

	// Lists landing zone operations.
	//
	// This member is required.
	LandingZoneOperations []types.LandingZoneOperationSummary

	// Retrieves the next page of results. If the string is empty, the response is the
	// end of the results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListLandingZoneOperationsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListLandingZoneOperations{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListLandingZoneOperations{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListLandingZoneOperations"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListLandingZoneOperations(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListLandingZoneOperationsPaginatorOptions is the paginator options for
// ListLandingZoneOperations
type ListLandingZoneOperationsPaginatorOptions struct {
	// How many results to return per API call.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListLandingZoneOperationsPaginator is a paginator for ListLandingZoneOperations
type ListLandingZoneOperationsPaginator struct {
	options   ListLandingZoneOperationsPaginatorOptions
	client    ListLandingZoneOperationsAPIClient
	params    *ListLandingZoneOperationsInput
	nextToken *string
	firstPage bool
}

// NewListLandingZoneOperationsPaginator returns a new
// ListLandingZoneOperationsPaginator
func NewListLandingZoneOperationsPaginator(client ListLandingZoneOperationsAPIClient, params *ListLandingZoneOperationsInput, optFns ...func(*ListLandingZoneOperationsPaginatorOptions)) *ListLandingZoneOperationsPaginator {
	if params == nil {
		params = &ListLandingZoneOperationsInput{}
	}

	options := ListLandingZoneOperationsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListLandingZoneOperationsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListLandingZoneOperationsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListLandingZoneOperations page.
func (p *ListLandingZoneOperationsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListLandingZoneOperationsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListLandingZoneOperations(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListLandingZoneOperationsAPIClient is a client that implements the
// ListLandingZoneOperations operation.
type ListLandingZoneOperationsAPIClient interface {
	ListLandingZoneOperations(context.Context, *ListLandingZoneOperationsInput, ...func(*Options)) (*ListLandingZoneOperationsOutput, error)
}

var _ ListLandingZoneOperationsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListLandingZoneOperations(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListLandingZoneOperations",
	}
}
