/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */

/***********************************************************************************/
/* This file is automatically generated using bindtool and can be manually edited  */
/* The following lines can be configured to regenerate this file during cmake      */
/* If manual edits are made, the following tags should be modified accordingly.    */
/* BINDTOOL_GEN_AUTOMATIC(0)                                                       */
/* BINDTOOL_USE_PYGCCXML(0)                                                        */
/* BINDTOOL_HEADER_FILE(math.h)                                        */
/* BINDTOOL_HEADER_FILE_HASH(85ba2e8e7191733cc35f70005e2d99e9)                     */
/***********************************************************************************/

#include <pybind11/complex.h>
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

#include <gnuradio/math.h>
// pydoc.h is automatically generated in the build directory
#include <math_pydoc.h>

void bind_math(py::module& m)
{


    m.def("fast_cc_multiply",
          &::gr::fast_cc_multiply,
          py::arg("out"),
          py::arg("cc1"),
          py::arg("cc2"),
          D(fast_cc_multiply));


    m.def("is_power_of_2", &::gr::is_power_of_2, py::arg("x"), D(is_power_of_2));


    m.def("fast_atan2f",
          (float (*)(float, float)) & ::gr::fast_atan2f,
          py::arg("y"),
          py::arg("x"),
          D(fast_atan2f, 0));


    m.def("fast_atan2f",
          (float (*)(gr_complex)) & ::gr::fast_atan2f,
          py::arg("z"),
          D(fast_atan2f, 1));


    m.def("branchless_clip",
          &::gr::branchless_clip,
          py::arg("x"),
          py::arg("clip"),
          D(branchless_clip));


    m.def("clip", &::gr::clip, py::arg("x"), py::arg("clip"), D(clip));


    m.def("binary_slicer", &::gr::binary_slicer, py::arg("x"), D(binary_slicer));


    m.def("quad_45deg_slicer",
          (unsigned int (*)(float, float)) & ::gr::quad_45deg_slicer,
          py::arg("r"),
          py::arg("i"),
          D(quad_45deg_slicer, 0));


    m.def("quad_0deg_slicer",
          (unsigned int (*)(float, float)) & ::gr::quad_0deg_slicer,
          py::arg("r"),
          py::arg("i"),
          D(quad_0deg_slicer, 0));


    m.def("quad_45deg_slicer",
          (unsigned int (*)(gr_complex)) & ::gr::quad_45deg_slicer,
          py::arg("x"),
          D(quad_45deg_slicer, 1));


    m.def("quad_0deg_slicer",
          (unsigned int (*)(gr_complex)) & ::gr::quad_0deg_slicer,
          py::arg("x"),
          D(quad_0deg_slicer, 1));


    m.def("branchless_binary_slicer",
          &::gr::branchless_binary_slicer,
          py::arg("x"),
          D(branchless_binary_slicer));


    m.def("branchless_quad_0deg_slicer",
          (unsigned int (*)(float, float)) & ::gr::branchless_quad_0deg_slicer,
          py::arg("r"),
          py::arg("i"),
          D(branchless_quad_0deg_slicer, 0));


    m.def("branchless_quad_0deg_slicer",
          (unsigned int (*)(gr_complex)) & ::gr::branchless_quad_0deg_slicer,
          py::arg("x"),
          D(branchless_quad_0deg_slicer, 1));


    m.def("branchless_quad_45deg_slicer",
          (unsigned int (*)(float, float)) & ::gr::branchless_quad_45deg_slicer,
          py::arg("r"),
          py::arg("i"),
          D(branchless_quad_45deg_slicer, 0));


    m.def("branchless_quad_45deg_slicer",
          (unsigned int (*)(gr_complex)) & ::gr::branchless_quad_45deg_slicer,
          py::arg("x"),
          D(branchless_quad_45deg_slicer, 1));


    m.def("p2_round_down",
          &::gr::p2_round_down,
          py::arg("x"),
          py::arg("pow2"),
          D(p2_round_down));


    m.def(
        "p2_round_up", &::gr::p2_round_up, py::arg("x"), py::arg("pow2"), D(p2_round_up));


    m.def("p2_modulo", &::gr::p2_modulo, py::arg("x"), py::arg("pow2"), D(p2_modulo));


    m.def("p2_modulo_neg",
          &::gr::p2_modulo_neg,
          py::arg("x"),
          py::arg("pow2"),
          D(p2_modulo_neg));
}
