#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <glade/glade.h>
#include "gm-world.h"
#include "gm-support.h"
#include "gm-debug.h"

#define GM_WORLD_LOGS_DIALOG_XML PACKAGE_DATA_DIR "/" PACKAGE "/ui/gm-world-logs.glade"

void 
on_gm_world_logs_dialog_row_activated(GtkTreeView *treeview, GtkTreePath *arg1,
		GtkTreeViewColumn *arg2, GtkDialog *dlg);

/* Public */

void
gm_world_logs_dialog_build_tree_view(GtkTreeView *tree_view) {
	GtkTreeModel *model, *smodel;
	GtkCellRenderer *renderer;
	GtkTreeViewColumn *column;

	model = GTK_TREE_MODEL(gtk_list_store_new(2, G_TYPE_STRING, G_TYPE_STRING));
  
	renderer = gtk_cell_renderer_text_new();
	column = gtk_tree_view_column_new_with_attributes(_("Logs"), renderer, 
			"text", 1, NULL);
	gtk_tree_view_append_column(tree_view, column);
  
	smodel = gtk_tree_model_sort_new_with_model(model);
	
	g_object_unref(model);
	
	gtk_tree_view_column_set_sort_column_id(column, 0);
	gtk_tree_sortable_set_sort_column_id(GTK_TREE_SORTABLE(smodel), 0, 
			GTK_SORT_DESCENDING);
  
	gtk_tree_view_set_model(tree_view, GTK_TREE_MODEL(smodel));
	g_object_unref(smodel);
}

gint
gm_world_logs_dialog_fill(GmWorld *world, GtkTreeView *view, 
		GtkTreeModel *model, GError **err) {
	gint res = 0;
	gchar *path, *tmp, *tmp2;
	gchar const *fname;
	GDir *dir;
	GtkTreeIter iter;
	FILE *f;
	long fsize;
	
	/* Fill it in */
	path = g_strdup_printf("%s/logs/", gm_world_path(world));
	dir = g_dir_open(path, 0, err);

	if (dir) {
		while ((fname = g_dir_read_name(dir)) != NULL) {
			++res;
			tmp = g_strconcat(path, fname, NULL);
			f = fopen(tmp, "r");
      
			if (f) {
				fseek(f, 0, SEEK_END);
				fsize = ftell(f);
				fclose(f);
				g_free(tmp);
        
				tmp = gnome_vfs_format_file_size_for_display(fsize);
				tmp2 = g_strconcat(fname, " (", tmp, ")", NULL);
        
				gtk_list_store_prepend(GTK_LIST_STORE(model), &iter);
				gtk_list_store_set(GTK_LIST_STORE(model), &iter, 0, fname, 1, 
						tmp2, -1);
				g_free(tmp2);
			}
      
			g_free(tmp);
		}
    
		g_dir_close(dir);
		g_free(path);
    	return res;
	} else {
		g_free(path);
		return -1;
	}
}

GtkDialog *
gm_world_logs_dialog_new(GmWorld *world, GtkTreeView **view) {
	GladeXML *xml;
	GtkDialog *dlg;
	GError *err = NULL;
	gint res;
	gchar *tmp;
	GtkTreeModel *model, *smodel;
	GtkTreeIter iter;
	
	xml = glade_xml_new(GM_WORLD_LOGS_DIALOG_XML, "gm_world_logs_dialog", NULL);

	if (xml == NULL) {
		gm_debug_msg(DEBUG_ALWAYS, "Couldn't find glade file %s!", 
				GM_WORLD_LOGS_DIALOG_XML);
		return NULL;
	}

	dlg = GTK_DIALOG(glade_xml_get_widget(xml, "gm_world_logs_dialog"));
	*view = GTK_TREE_VIEW(glade_xml_get_widget(xml, "tree_view_files"));

	gm_world_logs_dialog_build_tree_view(*view);
	smodel = gtk_tree_view_get_model(*view);
	model = gtk_tree_model_sort_get_model(GTK_TREE_MODEL_SORT(
			smodel));

	res = gm_world_logs_dialog_fill(world, *view, model, &err);
	
	if (res == -1) {
		tmp = g_strdup_printf(_("Couldn't open the log directory: %s"), 
				err->message);
		gm_error_dialog(tmp, NULL);
		g_error_free(err);
		g_free(tmp);
		gtk_widget_destroy(GTK_WIDGET(dlg));
		dlg = NULL;
	} else if (res == 0) {
		gm_info_dialog(_("There are no log files for this world"), NULL);
		gtk_widget_destroy(GTK_WIDGET(dlg));
		dlg = NULL;
	} else {
		if (gtk_tree_model_get_iter_first(smodel, &iter)) {
			gtk_tree_selection_select_iter(gtk_tree_view_get_selection(*view), 
					&iter);
		}
		
		glade_xml_signal_connect_data(xml, "on_tree_view_files_row_activated", 
				G_CALLBACK(on_gm_world_logs_dialog_row_activated), dlg);
	}
  
	g_object_unref(xml);
  
	return dlg;
}

/* Callbacks */

void 
on_gm_world_logs_dialog_row_activated(GtkTreeView *treeview, GtkTreePath *arg1,
		GtkTreeViewColumn *arg2, GtkDialog *dlg) {
  gtk_dialog_response(dlg, GTK_RESPONSE_OK);
}
