-------------------------------------------------------------------------------
--                                                                           --
--  Filename        : $Source: /cvsroot/gnade/gnade/contrib/gsql/project_file.ads,v $
--  Description     : GUI top level window
--  Author          : Michael Erdmann                                        --
--  Created         : 8.8.2001                                               --
--  Last Modified By: $Author: persan $
--  Last Modified On: $Date: 2007/09/06 20:17:53 $
--  Status          : $State: Exp $
--
--  Copyright (C) 2000 Michael Erdmann                                       --
--                                                                           --
--  GNADE is free software;  you can redistribute it  and/or modify it under --
--  terms of the  GNU General Public License as published  by the Free Soft- --
--  ware  Foundation;  either version 2,  or (at your option) any later ver- --
--  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
--  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
--  for  more details.  You should have  received  a copy of the GNU General --
--  Public License  distributed with GNAT;  see file COPYING.  If not, write --
--  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
--  MA 02111-1307, USA.                                                      --
--                                                                           --
--  As a special exception,  if other files  instantiate  generics from this --
--  unit, or you link  this unit with other files  to produce an executable, --
--  this  unit  does not  by itself cause  the resulting  executable  to  be --
--  covered  by the  GNU  General  Public  License.  This exception does not --
--  however invalidate  any other reasons why  the executable file  might be --
--  covered by the  GNU Public License.                                      --
--                                                                           --
--  Author: Michael Erdmann <michael.erdmann@snafu.de>                       --
--                                                                           --
--  GNADE is implemented to work with GNAT, the GNU Ada compiler.            --
--                                                                           --
-------------------------------------------------------------------------------
with Ada.Strings.Unbounded;            use Ada.Strings.Unbounded;
with GSQL_Types;                       use GSQL_Types;

package Project_File is

   Max_Catalog_Length : constant Natural := 1000;

   File_Name : Unbounded_String := Null_Unbounded_String;

   procedure Open (
                   Path  : in String  := "";
                   Quiet : in Boolean := False);

   procedure Save (
                   Path  : in String := "");

   procedure Close;

   No_More_Components : exception;
   Section_Not_Found  : exception;

   procedure Get (
                  Cls    : in String;
                  Name   : in String;
                  Result : out Text_Buffer;
                  Size   : out Positive);

   function Get (
                 Cls    : in String;
                 Name   : in String) return String;

   function Section_Exists (
                            Cls    : in String;
                            Name   : in String) return Boolean;

   procedure Add (
                  Cls    : in String;
                  Name   : in String;
                  Data   : in String);

   procedure Add (
                  Cls    : in String;
                  Name   : in String;
                  Data   : in Text_Buffer);

   procedure Update (
                     Cls    : in String;
                     Name   : in String;
                     Data   : in String);

   procedure Update (
                     Cls    : in String;
                     Name   : in String;
                     Data   : in Text_Buffer);

   procedure Remove (
                     Cls    : in String;
                     Name   : in String;
                     Quiet  : in Boolean := True);

   procedure Catalog (
                      Name  : in String;
                      Cat   : out Text_Buffer);

end Project_File;
