/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package com.sun.enterprise.deployment.annotation;

/**
 * Exception that denotes a warning or error condition in the 
 * annotation procesing tool
 *
 * @author Jerome Dochez
 */
public class AnnotationProcessorException extends Exception {
    
    final private String message;
    
    final private AnnotationInfo locator;
    
    boolean isFatal = false;
    
    /** 
     * Creats a new annotation exception
     * @param message describing the exception cause
     */
    public AnnotationProcessorException(String message) {
        this.message = message;
        this.locator = null;
    }
    
    /**
     * Creates a new annotation exception 
     * @param message describing the exception cause
     * @param locator gives information about the annotation and 
     * the annotated element which caused the exception
     */
    public AnnotationProcessorException(String message, AnnotationInfo locator) {
        this.message = message;
        this.locator = locator;
    }
    
    /**
     * Return a meaningful string explaining the exception cause
     * @return the exception reason
     */
    public String getMessage() {
        return message;
    }
    
    /**
     * Return information about the annotation and annotated element 
     * which caused the exception or null if it is not available.
     * @return the annotation info instance 
     */
    public AnnotationInfo getLocator() {
        return locator;
    }
    
    /**
     * @return a meaningful description
     */
    public String toString() {
        return (locator==null?message:message + "at " + locator);
    }
    
    /**
     *
     * @return true if this exception was considered by the sender as being
     * fatal to the annotations processing(i.e. it should stop).
     */
    public boolean isFatal(){
        return isFatal;
    }
   
    /**
     * Sets wether is exception is considered as fatal to the annotation 
     * processing.
     * @param true if the annotation processing should stop
     */
     public void setFatal(boolean fatal){
         this.isFatal = fatal;
     }      
}
