// Example of using the GeographicLib::OSGB class
// $Id: 80feea12c2ebb7e594d8e17bf841c1a141cf3c36 $

#include <iostream>
#include <exception>
#include <string>
#include <GeographicLib/OSGB.hpp>

using namespace std;
using namespace GeographicLib;

int main() {
  try {
    {
      // Sample forward calculation
      double lat = 55.5, lon = -1.64; // Embleton, Northumberland
      double x, y;
      OSGB::Forward(lat, lon, x, y);
      string gridref;
      OSGB::GridReference(x, y, 2, gridref);
      cout << x << " " << y << " " << gridref << "\n";
    }
    {
      // Sample reverse calculation
      string gridref = "NU2222";
      double x, y;
      int prec;
      OSGB::GridReference(gridref, x, y, prec);
      double lat, lon;
      OSGB::Reverse(x, y, lat, lon);
      cout << prec << " " << lat << " " << lon << "\n";
    }
  }
  catch (const exception& e) {
    cerr << "Caught exception: " << e.what() << "\n";
    return 1;
  }
  return 0;
}
