import gtk



class Menu(gtk.Menu):

    def __init__(self, data):

        gtk.Menu.__init__(self)

        for entry in data:
            if (entry):
                label, handler, args = entry
                mitem = gtk.MenuItem(label)
                
                if (handler):
                    mitem.connect("activate", self.__on_activate,
                                  handler, args)

            else:
                mitem = gtk.MenuItem()
                
            mitem.show()
            self.add(mitem)
        #end for



    def __on_activate(self, src, handler, args):
        
        apply(handler, args)



    def popup(self, button, time):

        gtk.Menu.popup(self, None, None, None, button, time)



    def __on_menu(self, menu, *args):

        return (0, 0, 0)
