/**************************************************************************\
 gatos (General ATI TV and Overlay Software)

  Project Coordinated By Insomnia (Steaphan Greene)
  (insomnia@core.binghamton.edu)

  Copyright (C) 1999 Steaphan Greene, yvind Aabling, Octavian Purdila, 
	Vladimir Dergachev and Christian Lupien.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.

\**************************************************************************/

/*
 * NOTE:
 *
 * Based on code Linux kernel code in init/main.c and
 * linux-2.2.12/arch/i386/lib/delay.c
 * 
 * Based on bogo-1.3 by Jeff Tranter (Jeff_Tranter@Mitel.COM)
 *
 * Modified by Daniel Caujolle-Bert for Gatos.
 *  - Use the delay from linux kernel 2.2 now, and 
 *    control the returned value to avoid 0 BogoMips. 
 */

#include "gatos.h"

#include <stdio.h>
#include <time.h>

#define gout(FMT,ARGS...)	printf(FMT,##ARGS) ; fflush(stdout)

/* ------------------------------------------------------------------------ */
/* Private routine */

/*
 * From Linux kernel 2.2.12
 */
#if defined (__NetBSD__)
static void __inline__ delay(unsigned long loops) {
  int d0;
  __asm__ (
           "\tjmp 1f\n"
           ".align 15\n"
           "1:\tjmp 2f\n"
           ".align 15\n"
           "2:\tdecl %0\n\tjns 2b"
           :"=&a" (d0)
           :"0" (loops));
  }
#else
static void __inline__ delay(unsigned long loops) {
  int d0;
  __asm__ (
           "\tjmp 1f\n"
           ".align 16\n"
           "1:\tjmp 2f\n"
           ".align 16\n"
           "2:\tdecl %0\n\tjns 2b"
           :"=&a" (d0)
           :"0" (loops));
  }
#endif
/* ------------------------------------------------------------------------ */
/* Public routine */

/*
 * Return the *magic* bogomips value
 */
unsigned long get_bogomips(void) {
  unsigned long loops_per_sec = 1;
  unsigned long ticks;
  int bogocrash = 1; 

  if(VERBOSE) gout("Calibrating delay loop");
  while((loops_per_sec <<= 1)) {
        if(VERBOSE) gout(".");
        ticks = clock();
	delay(loops_per_sec);
	ticks = clock() - ticks;
	if(ticks >= CLOCKS_PER_SEC) {
	   loops_per_sec = ((loops_per_sec / ticks) * CLOCKS_PER_SEC)/500000;
	   /* Never return 0 */
	   if(loops_per_sec > 0) {
	      if(VERBOSE) gout("done\n");
	      return loops_per_sec;
  	     } else {
	      bogocrash++;
	      if(bogocrash < 10) {
	         loops_per_sec = 1;
	        } else {
		 if(VERBOSE) gout("done\n");
		 return 2000;
		}
	     }
	   }
       }
  /* If failed, return an arbitrary value */
  if(VERBOSE) gout(" FAILED!!\n");
  return 2000;
  }
