include_guard()

include(AddFileDependencies)
include(${CGAL_MODULES_DIR}/CGAL_add_test.cmake)

add_custom_target(CGALlab_all_plugins)
add_executable(CGALlab_compile_all_plugins CGALlab_compile_all_plugins.cpp)
add_dependencies(CGALlab_compile_all_plugins CGALlab_all_plugins)

  macro(cgal_lab_plugin plugin_name plugin_implementation_base_name)
    cmake_parse_arguments(ARG "" "" "KEYWORDS" ${ARGN})
    list_split(option ARGN_TAIL ${ARG_UNPARSED_ARGUMENTS} )
    if(NOT ${option} STREQUAL "EXCLUDE_FROM_ALL")
      if(NOT ${option} STREQUAL "NO_MOC")
        set(other_sources ${ARG_UNPARSED_ARGUMENTS})
        set(option "")
      else()
        set(other_sources ${ARGN_TAIL})
      endif()
    else()
      set(other_sources ${ARGN_TAIL})
    endif()
    if("${option}" STREQUAL "NO_MOC")
      set(option "")
      set(moc_file_name "")
    else()
      set(moc_file_name ${plugin_implementation_base_name}.moc )
      qt6_generate_moc( ${plugin_implementation_base_name}.cpp "${CMAKE_CURRENT_BINARY_DIR}/${moc_file_name}" TARGET ${plugin_name})
      add_file_dependencies( ${moc_file_name} "${CMAKE_CURRENT_SOURCE_DIR}/${plugin_implementation_base_name}.cpp" )
    endif()

    add_library(${plugin_name} MODULE ${option} ${moc_file_name} ${plugin_implementation_base_name}.cpp ${other_sources})
    set_property(TARGET ${plugin_name}
      PROPERTY LIBRARY_OUTPUT_DIRECTORY
      "${CGAL_LAB_DEMO_PLUGINS_DIR}")
    cgal_add_compilation_test(${plugin_name})
    add_to_cached_list( CGAL_EXECUTABLE_TARGETS ${plugin_name} )
    # Link with Qt
    target_link_libraries( ${plugin_name} PUBLIC ${QT_LIBRARIES} )
    # Link with the demo_framework
    if(TARGET demo_framework)
      target_link_libraries( ${plugin_name} PUBLIC demo_framework)
      add_dependencies(${plugin_name} demo_framework)
    else()
      target_link_libraries( ${plugin_name} PUBLIC CGAL_Lab_framework)
      add_dependencies(${plugin_name} CGAL_Lab_framework)
    endif()
    if(TARGET "compilation_of__demo_framework" AND TEST "compilation of  ${plugin_name}")
      set_property(TEST "compilation of  ${plugin_name}" APPEND PROPERTY FIXTURES_REQUIRED demo_framework_SetupFixture)
    endif()
    # Link with CGAL
    target_link_libraries( ${plugin_name} PUBLIC CGAL::CGAL )
    if(NOT CGAL_TEST_SUITE AND TARGET CGALlab)
      add_dependencies( ${plugin_name} CGALlab )
    endif()
    if(NOT TARGET CGALlab_all_plugins)
      message(AUTHOR_WARNING "CGALlab_all_plugins target not found, creating it")
      add_custom_target(CGALlab_all_plugins)
    endif()
    add_dependencies(CGALlab_all_plugins ${plugin_name})
    #metadata management
    #create "${plugin_implementation_base_name}.json" in BINARY_DIR
    STRING(TOLOWER "${plugin_implementation_base_name}.json" base_name)
    SET(filename "${CMAKE_CURRENT_BINARY_DIR}/${base_name}")
    LIST(LENGTH ARG_KEYWORDS size)
    SET(keywords "")
    if(${size} GREATER 0)
      foreach(keyword ${ARG_KEYWORDS})
        SET(keywords "${keywords}\"${keyword}\", ")
        if(NOT TARGET ${keyword})
          add_custom_target(${keyword})
        endif()
        add_dependencies( ${keyword} ${plugin_name})
      endforeach()
      # Remove the last comma and space
      string(REGEX REPLACE ", $" "" keywords "${keywords}")
    endif()
    file(WRITE ${filename} "{\n  \"Keywords\" : [ ${keywords} ],\n")
    string(TIMESTAMP VERSION "%Y-%m-%d %H:%M")
    file(APPEND ${filename} "  \"ConfigDate\" : \"${VERSION}\"\n}\n")
    CGAL_install_hooks()
  endmacro(cgal_lab_plugin)
