//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Base/SlotFactory.h
//! @brief     Defines class ActionFactory.
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2021
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_BASE_SLOTFACTORY_H
#define BORNAGAIN_GUI_VIEW_BASE_SLOTFACTORY_H

#include <QAction>
#include <QObject>
#include <QString>
#include <functional>

//! Factory to create commonly used actions
namespace SlotFactory {

//! Create "remove" action.
//!
//! The "what" text will be used in the tooltip, appended to "Remove ".
//! If a slot is given, it will be connected to the "triggered" signal.
QAction* createRemoveSlot(QObject* parent, const QString& what,
                          std::function<void()> slot = nullptr);
//! Create "duplicate" action.
//!
//! The "what" text will be used in the tooltip, appended to "Duplicate ".
//! If a slot is given, it will be connected to the "triggered" signal.
QAction* createDuplicateSlot(QObject* parent, const QString& what,
                             std::function<void()> slot = nullptr);

//! Create "show in Realspace" action.
//!
//! The "what" text will be used in the tooltip.
//! If a slot is given, it will be connected to the "triggered" signal.
QAction* createShowInRealspaceSlot(QObject* parent, const QString& what,
                                   std::function<void()> slot = nullptr);

} // namespace SlotFactory

#endif // BORNAGAIN_GUI_VIEW_BASE_SLOTFACTORY_H
