var { ExtensionCommon } = ChromeUtils.import ?  ChromeUtils.import("resource://gre/modules/ExtensionCommon.jsm")
:   ChromeUtils.importESModule(
  "resource://gre/modules/ExtensionCommon.sys.mjs"
);
var { ExtensionSupport } = ChromeUtils.import ?  ChromeUtils.import("resource:///modules/ExtensionSupport.jsm")
:   ChromeUtils.importESModule(
  "resource:///modules/ExtensionSupport.sys.mjs"
);

var ThreadPaneColumns;
try {
  ({ ThreadPaneColumns } = ChromeUtils.importESModule("chrome://messenger/content/thread-pane-columns.mjs"));
}
catch (err) {
  ({ ThreadPaneColumns } = ChromeUtils.importESModule("chrome://messenger/content/ThreadPaneColumns.mjs"));
}


var customColumnIds = [];
var test = {};

var customColumn = class extends ExtensionCommon.ExtensionAPI {
  getAPI(context) {
    context.callOnClose(this);
    return {
      customColumn: {
        async refreshColumn(id) {
          ThreadPaneColumns.refreshCustomColumn(id);
        },

        async add(id) {
          var { xnote } = ChromeUtils.import ?  ChromeUtils.import("resource://xnote/modules/xnote.jsm")
          :  ChromeUtils.importESModule("resource://xnote/modules/xnote.sys.mjs");
                  let customColumn = ThreadPaneColumns.getCustomColumns().find(
            c => c.id == id
          );
          if (!customColumn) {
            customColumnIds.push(id);

            function getXNote(message) {
              let xnotePrefs = xnote.ns.Commons.xnotePrefs;
              let ic = '\u{1F4D2}';
              let note = new xnote.ns.Note(message.messageId);
              if (note.exists()) {
                if (xnotePrefs.show_first_x_chars_in_col > 0) {

                  return ic + " " + note.text.substr(0, xnotePrefs.show_first_x_chars_in_col);//ic + " " + 
                } else {
                  return ic;
                }
              }
              else {
                return "";
              }
            }

            if (typeof ThreadPaneColumns !== "undefined") {
              ThreadPaneColumns.addCustomColumn(id, {
                name: '\u{1F4D2}' + "XNote",
                hidden: false,
                //              iconCallback: getImageSrc,
                icon: false,
                //              iconHeaderUrl: "resource://xnote/skin/xnote_context.png",
                resizable: true,
                sortable: true,
                textCallback: getXNote,
              });
            } else {
              console.error("ThreadPaneColumns is not defined.");
            };
          };
        },

        async remove(id) {
          const customColumn = ThreadPaneColumns.getCustomColumns().find(
            c => c.id == id
          );
          if (customColumn) {
            if (typeof ThreadPaneColumns !== "undefined") {
              ThreadPaneColumns.removeCustomColumn(id);
            }
            customColumnIds = customColumnIds.filter(e => e !== id);
          };
        },
      },
    };
  }

  close() {
    for (const id of customColumnIds) {
      try {
        ThreadPaneColumns.removeCustomColumn(id);
      } catch (e) {
        console.error(e);
      }
    }
  }
};
