# NAME

**wasmedge** - standalone runtime for WebAssembly

# SYNOPSIS

**wasmedge** [*SUBCOMMAND*] [*OPTIONS*] [`--`] `WASM_OR_SO` [*ARG* `...`]

# DESCRIPTION

WasmEdge is a lightweight, high-performance, and extensible [WebAssembly](https://webassembly.org/) runtime for cloud native, edge, and decentralized applications. It powers serverless apps, embedded functions, microservices, smart contracts, and IoT devices.

The WasmEdge Runtime provides a well-defined execution sandbox for its contained WebAssembly bytecode program. The runtime offers isolation and protection for operating system resources (e.g., file system, sockets, environment variables, processes) and memory space. The most important use case for WasmEdge is to safely execute user-defined or community-contributed code as plug-ins in a software product (e.g., SaaS, software-defined vehicles, edge nodes, or even blockchain nodes). It enables third-party developers, vendors, suppliers, and community members to extend and customize the software product.

**wasmedge** accepts a file path, `WASM_OR_SO`, to a WebAssembly file or a native shared library object as generated by **wasmedge compile**(1).

`ARG` is the optional command line arguments array:

   * In reactor mode, the first argument will be the function name, and the arguments after `ARG[0]` will be parameters of wasm function `ARG[0]`.
   * In command mode, the arguments will be the command line arguments of the WASI `_start` function. They are also known as command line arguments(`argv`) for a standalone C/C++ program.

# SUBCOMMANDS

`compile`

:   WasmEdge compiler subcommand. See **wasmedge-compile**(1) for the options applicable to this mode.

`run`

:   WasmEdge runtime tool subcommand. **wasmedge run** is an alias of **wasmedge** without the `--version` option. See below for the options applicable to this mode. 

# OPTIONS

## Generic program information

`-h`, `--help`

:   Show the help messages. Will ignore other arguments below.

`-v`, `--version`

:   Show the version information. Will ignore other arguments below.

## Basic options

`--reactor`

:   Enable reactor mode. Reactor mode calls `_initialize` if exported.

`--dir`

:   Binding directories into WASI virtual filesystem. Each directory can be specified as `--dir host_path`. You can also map a guest directory to a host directory by `--dir guest_path:host_path`, where `guest_path` specifies the path that will correspond to `host_path` for calls like `fopen` in the guest.

`--env`

:   Environmental variables. Each variable can be specified as `--env NAME=VALUE`.

`--force-interpreter`

:   Forcibly run WASM in interpreter mode.

`--forbidden-plugin`

:   List of plugins to ignore.

## Statistics information

`--enable-time-measuring`

:   Enable generating code for counting time during execution.

`--enable-gas-measuring`

:   Enable generating code for counting gas burned during execution.

`--enable-instruction-count`

:   Enable generating code for counting WebAssembly instructions executed.

`--enable-all-statistics`

:   Enable generating code for all statistics options include instruction counting, gas measuring, and execution time.

## Resource limitations

`--time-limit`

:   Limitation of maximum time(in milliseconds) for execution, default value is 0 for no limitations.

`--gas-limit`

:   Limitation of execution gas. Upper bound can be specified as `--gas-limit GAS_LIMIT`.

`--memory-page-limit`

:   Limitation of pages(as size of 64 KiB) in every memory instance. Upper bound can be specified as `--memory-page-limit PAGE_COUNT`.

## WebAssembly proposals

`--disable-import-export-mut-globals`

:   Disable Import/Export of mutable globals proposal.

`--disable-non-trap-float-to-int`

:   Disable Non-trapping float-to-int conversions proposal.

`--disable-sign-extension-operators`

:   Disable Sign-extension operators proposal.

`--disable-multi-value`

:   Disable Multi-value proposal.

`--disable-bulk-memory`

:   Disable Bulk memory operations proposal.

`--disable-reference-types`

:   Disable Reference types proposal.

`--disable-simd`

:   Disable SIMD proposal.

`--enable-multi-memory`

:   Enable Multiple memories proposal.

`--enable-tail-call`

:   Enable Tail-call proposal.

`--enable-extended-const`

:   Enable Extended-const proposal.

`--enable-threads`

:   Enable Threads proposal.

`--enable-all`

:   Enable all features.

# EXAMPLE

## Call a WebAssembly function

Assuming a WebAssembly program placed under the file `fibonacci.wasm`, set up
so to export a `fib()` function and accepting a single `i32` integer as the
input parameter, one can execute `wasmedge` in reactor mode to invoke the
exported function as follows:

```bash
$ wasmedge --reactor fibonacci.wasm fib 10
```

## Execute a standalone WebAssembly program

Assuming a `WebAssembly program contains a `main()` function, printing out
`hello` followed by the command line arguments:

```bash
$ wasmedge hello.wasm world
```

# AUTHOR

Copyright (c) 2019-2022 Second State INC. Licensed under the Apache License,
Version 2.0.

# SEE ALSO

## Regular manual pages

**wasmedge-compile**(1)

## Full documentation

A [complete manual of WasmEdge](https://wasmedge.org/docs/) can be found online.
