# 2022-03-09 Triage Log

A pretty smooth week. All three regressions were small, and two were isolated to rustdoc alone.

Triage done by **@pnkfelix**.
Revision range: [f0c4da49983aa699f715caf681e3154b445fb60b..10dccdc7fcbdc64ee9efe2c1ed975ab8c1d61287](https://perf.rust-lang.org/?start=f0c4da49983aa699f715caf681e3154b445fb60b&end=10dccdc7fcbdc64ee9efe2c1ed975ab8c1d61287&absolute=false&stat=instructions%3Au)

3 Regressions, 3 Improvements, 1 Mixed; 2 of them in rollups
53 comparisons made in total

#### Regressions

Rollup of 9 pull requests [#94541](https://github.com/rust-lang/rust/pull/94541)
- Arithmetic mean of relevant regressions: 1.5%
- Largest regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=8769f4ef2fe1efddd1f072485f97f568e7328f79&end=2f8d1a835b4e7feaf625f74d0d5cb9b84dbc845a&stat=instructions:u): 3.9% on `full` builds of `deeply-nested-async check`
- After looking at the performance data, it seems like the regressions to `deeply-nested-async` are isolated to some [slowdown in `check_mod_privacy`](https://perf.rust-lang.org/detailed-query.html?sort_idx=-11&commit=2f8d1a835b4e7feaf625f74d0d5cb9b84dbc845a&base_commit=8769f4ef2fe1efddd1f072485f97f568e7328f79&benchmark=deeply-nested-async-check&scenario=full).
- But AFAICT nothing in this rollup should have affected `check_mod_privacy`.
- Chalking this up to optimization noise; marked as triaged.

Support GATs in Rustdoc [#94009](https://github.com/rust-lang/rust/pull/94009)
- Arithmetic mean of relevant regressions: 0.8%
- Largest regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=40d3040ae19b8c43c0027bc6d3e9805e5ee5e0ee&end=6d7684101a51f1c375ec84aef5d2fbdeb214bbc2&stat=instructions:u): 1.1% on `full` builds of `ctfe-stress-4 doc`
- Already marked as triaged by rustdoc team; this change makes rustdoc track more data, which inevitably leads to perf regressions.

rustdoc: Stop textually replacing `Self` in doc links before resolving them [#93805](https://github.com/rust-lang/rust/pull/93805)
- Arithmetic mean of relevant regressions: 0.3%
- Arithmetic mean of all relevant changes: 0.3%
- Largest regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=0cbef1c6a7f4ee33cd41d91778544c5399f10f39&end=1661e4c7e0e68b4297aec095064d80566d4ea2b1&stat=instructions:u): 1.0% on `full` builds of `serde doc`
- rustdoc team did not expect a regression here.
- it looks like collect-intra-doc-links got slower. not clear why, though.
- slowdown was solely observed in `serde doc`. posted some theories and marked as triaged.

#### Improvements

remove obligation dedup from `impl_or_trait_obligations` [#84944](https://github.com/rust-lang/rust/pull/84944)
- Arithmetic mean of relevant improvements: -1.4%
- Largest improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=45660949132222ba7ec0905649b2affd68e0e13c&end=32cbc7630b2d6b7141e2588f91380c1a58cf0016&stat=instructions:u): -4.0% on `full` builds of `deeply-nested check`


Introduce `ConstAllocation`. [#94597](https://github.com/rust-lang/rust/pull/94597)
- Arithmetic mean of relevant improvements: -0.9%
- Arithmetic mean of all relevant changes: -0.8%
- Largest improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=38a0b81b1c32764d6a583a5efb6f306b8c44c503&end=8876ca3dd46b99fe7e6ad937f11493d37996231e&stat=instructions:u): -1.4% on `full` builds of `keccak check`


Rollup of 6 pull requests [#94761](https://github.com/rust-lang/rust/pull/94761)
- Arithmetic mean of relevant improvements: -1.1%
- Largest improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=163c207fc28cadff4de1808848a93e3e5f2d1941&end=6045c34f15d463c7d51104b968c1eabc5275b9c1&stat=instructions:u): -1.2% on `full` builds of `token-stream-stress check`


#### Mixed

Reopen 91719 [#94570](https://github.com/rust-lang/rust/pull/94570)
- Arithmetic mean of relevant regressions: 0.5%
- Arithmetic mean of relevant improvements: -1.4%
- Arithmetic mean of all relevant changes: -1.0%
- Largest improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=047f9c4bc4e26df4f54c3c76af3e963782ed05e4&end=b4bf56cd66ca83e908fd43bde4c627f94b2a8a9f&stat=instructions:u): -6.9% on `full` builds of `deeply-nested-async check`
- Largest regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=047f9c4bc4e26df4f54c3c76af3e963782ed05e4&end=b4bf56cd66ca83e908fd43bde4c627f94b2a8a9f&stat=instructions:u): 1.3% on `incr-full` builds of `piston-image opt`
- Already [triaged by workingjubilee](https://github.com/rust-lang/rust/pull/94570#issuecomment-1058879131) when they r+'ed it.


#### Untriaged Pull Requests

- [#94541 Rollup of 9 pull requests](https://github.com/rust-lang/rust/pull/94541)
- [#94402 Revert "Auto merge of #92419 - erikdesjardins:coldland, r=nagisa"](https://github.com/rust-lang/rust/pull/94402)
- [#94333 Rollup of 9 pull requests](https://github.com/rust-lang/rust/pull/94333)
- [#94130 Use undef for (some) partially-uninit constants](https://github.com/rust-lang/rust/pull/94130)
- [#94103 Rollup of 9 pull requests](https://github.com/rust-lang/rust/pull/94103)
- [#94072 Rollup of 8 pull requests](https://github.com/rust-lang/rust/pull/94072)
- [#93805 rustdoc: Stop textually replacing `Self` in doc links before resolving them](https://github.com/rust-lang/rust/pull/93805)
- [#93670 Apply noundef attribute to &T, &mut T, Box<T>, bool](https://github.com/rust-lang/rust/pull/93670)
- [#93505 safely `transmute<&List<Ty<'tcx>>, &List<GenericArg<'tcx>>>`](https://github.com/rust-lang/rust/pull/93505)
- [#93466 Make dead code check a query.](https://github.com/rust-lang/rust/pull/93466)
- [#93312 Return an indexmap in `all_local_trait_impls` query](https://github.com/rust-lang/rust/pull/93312)
- [#93298 make `find_similar_impl_candidates` even fuzzier](https://github.com/rust-lang/rust/pull/93298)
- [#93288 Rollup of 8 pull requests](https://github.com/rust-lang/rust/pull/93288)
- [#93154 debuginfo: Make sure that type names for closure and generator environments are unique in debuginfo.](https://github.com/rust-lang/rust/pull/93154)
- [#93148 Overhaul interning.](https://github.com/rust-lang/rust/pull/93148)
- [#93138 Rollup of 17 pull requests](https://github.com/rust-lang/rust/pull/93138)
- [#93095 Store a `Symbol` instead of an `Ident` in `AssocItem`](https://github.com/rust-lang/rust/pull/93095)
- [#92911 Guard against unwinding in cleanup code](https://github.com/rust-lang/rust/pull/92911)
- [#92896 Update some rustc dependencies to deduplicate them](https://github.com/rust-lang/rust/pull/92896)
- [#92844 Rollup of 9 pull requests](https://github.com/rust-lang/rust/pull/92844)
- [#92816 Remove deprecated LLVM-style inline assembly](https://github.com/rust-lang/rust/pull/92816)
- [#92805 partially revertish `lazily "compute" anon const default substs`](https://github.com/rust-lang/rust/pull/92805)
- [#92535 Allow unwinding from OOM hooks](https://github.com/rust-lang/rust/pull/92535)
- [#92534 Hash `Ident` spans in all HIR structures](https://github.com/rust-lang/rust/pull/92534)
- [#92356 Add {Add,Sub,Mul,Div,Rem,BitXor,BitOr,BitAnd}{,Assign}<$t> to Saturat…](https://github.com/rust-lang/rust/pull/92356)
- [#92277 rustc_metadata: Stop passing `CrateMetadataRef` by reference (step 1)](https://github.com/rust-lang/rust/pull/92277)
- [#92252 Update pulldown-cmark version to 0.9](https://github.com/rust-lang/rust/pull/92252)
- [#92229 Do not display `~const Drop` in rustdoc](https://github.com/rust-lang/rust/pull/92229)
- [#92227 Rustdoc: use `is_doc_hidden` method on more places](https://github.com/rust-lang/rust/pull/92227)
- [#92149 Fix bad caching of `~const Drop` bounds](https://github.com/rust-lang/rust/pull/92149)

#### Nags requiring follow up

TODO: Nags

