Unsafe code was used outside of an unsafe block.

Erroneous code example:

```compile_fail,E0133
unsafe fn f() { return; } // This is the unsafe code

fn main() {
    f(); // error: call to unsafe function requires unsafe function or block
}
```

Using unsafe functionality is potentially dangerous and disallowed by safety
checks. Examples:

* Dereferencing raw pointers
* Calling functions via FFI
* Calling functions marked unsafe

These safety checks can be relaxed for a section of the code by wrapping the
unsafe instructions with an `unsafe` block. For instance:

```
unsafe fn f() { return; }

fn main() {
    unsafe { f(); } // ok!
}
```

See the [unsafe section][unsafe-section] of the Book for more details.

#### Unsafe code in functions

Unsafe code is currently accepted in unsafe functions, but that is being phased
out in favor of requiring unsafe blocks here too.

```
unsafe fn f() { return; }

unsafe fn g() {
    f(); // Is accepted, but no longer recommended
    unsafe { f(); } // Recommended way to write this
}
```

Linting against this is controlled via the `unsafe_op_in_unsafe_fn` lint, which
is `warn` by default in the 2024 edition and `allow` by default in earlier
editions.

[unsafe-section]: https://doc.rust-lang.org/book/ch19-01-unsafe-rust.html
