
// THIS FILE IS AUTOMATICALLY GENERATED; DO NOT EDIT

//! A Folder represents an AST->AST fold; it accepts an AST piece,
//! and returns a piece of the same type.

// Unreachable code is generated sometimes without the full feature.
#![allow(unreachable_code)]

use *;
use synom::delimited::Delimited;

trait FoldHelper {
    type Item;
    fn lift<F>(self, f: F) -> Self where F: FnMut(Self::Item) -> Self::Item;
}

impl<T> FoldHelper for Vec<T> {
    type Item = T;
    fn lift<F>(self, f: F) -> Self where F: FnMut(Self::Item) -> Self::Item {
        self.into_iter().map(f).collect()
    }
}

impl<T, U> FoldHelper for Delimited<T, U> {
    type Item = T;
    fn lift<F>(self, mut f: F) -> Self where F: FnMut(Self::Item) -> Self::Item {
        self.into_iter().map(|elem| {
            let (t, u) = elem.into_tuple();
            (f(t), u)
        }).collect::<Vec<(T, Option<U>)>>().into()
    }
}


#[cfg(feature = "full")]
macro_rules! full {
    ($e:expr) => { $e }
}

#[cfg(not(feature = "full"))]
macro_rules! full {
    ($e:expr) => { unreachable!() }
}


/// AST->AST fold.
///
/// Each method of the Folder trait is a hook to be potentially overridden. Each
/// method's default implementation recursively visits the substructure of the
/// input via the `walk` functions, which perform an "identity fold", that
/// is, they return the same structure that they are given (for example the
/// `fold_file` method by default calls `fold::walk_file`).
///
/// If you want to ensure that your code handles every variant
/// explicitly, you need to override each method.  (And you also need
/// to monitor future changes to `Folder` in case a new method with a
/// new default implementation gets introduced.)
pub trait Folder {

fn fold_abi(&mut self, i: Abi) -> Abi { fold_abi(self, i) }

fn fold_abi_kind(&mut self, i: AbiKind) -> AbiKind { fold_abi_kind(self, i) }

fn fold_angle_bracketed_parameter_data(&mut self, i: AngleBracketedParameterData) -> AngleBracketedParameterData { fold_angle_bracketed_parameter_data(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_arg_captured(&mut self, i: ArgCaptured) -> ArgCaptured { fold_arg_captured(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_arg_self(&mut self, i: ArgSelf) -> ArgSelf { fold_arg_self(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_arg_self_ref(&mut self, i: ArgSelfRef) -> ArgSelfRef { fold_arg_self_ref(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_arm(&mut self, i: Arm) -> Arm { fold_arm(self, i) }

fn fold_attr_style(&mut self, i: AttrStyle) -> AttrStyle { fold_attr_style(self, i) }

fn fold_attribute(&mut self, i: Attribute) -> Attribute { fold_attribute(self, i) }

fn fold_bare_fn_arg(&mut self, i: BareFnArg) -> BareFnArg { fold_bare_fn_arg(self, i) }

fn fold_bare_fn_arg_name(&mut self, i: BareFnArgName) -> BareFnArgName { fold_bare_fn_arg_name(self, i) }

fn fold_bare_fn_ty(&mut self, i: BareFnTy) -> BareFnTy { fold_bare_fn_ty(self, i) }

fn fold_bin_op(&mut self, i: BinOp) -> BinOp { fold_bin_op(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_binding_mode(&mut self, i: BindingMode) -> BindingMode { fold_binding_mode(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_block(&mut self, i: Block) -> Block { fold_block(self, i) }

fn fold_body(&mut self, i: Body) -> Body { fold_body(self, i) }

fn fold_body_enum(&mut self, i: BodyEnum) -> BodyEnum { fold_body_enum(self, i) }

fn fold_body_struct(&mut self, i: BodyStruct) -> BodyStruct { fold_body_struct(self, i) }

fn fold_bound_lifetimes(&mut self, i: BoundLifetimes) -> BoundLifetimes { fold_bound_lifetimes(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_capture_by(&mut self, i: CaptureBy) -> CaptureBy { fold_capture_by(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_constness(&mut self, i: Constness) -> Constness { fold_constness(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_defaultness(&mut self, i: Defaultness) -> Defaultness { fold_defaultness(self, i) }

fn fold_derive_input(&mut self, i: DeriveInput) -> DeriveInput { fold_derive_input(self, i) }

fn fold_expr(&mut self, i: Expr) -> Expr { fold_expr(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_expr_addr_of(&mut self, i: ExprAddrOf) -> ExprAddrOf { fold_expr_addr_of(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_expr_array(&mut self, i: ExprArray) -> ExprArray { fold_expr_array(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_expr_assign(&mut self, i: ExprAssign) -> ExprAssign { fold_expr_assign(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_expr_assign_op(&mut self, i: ExprAssignOp) -> ExprAssignOp { fold_expr_assign_op(self, i) }

fn fold_expr_binary(&mut self, i: ExprBinary) -> ExprBinary { fold_expr_binary(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_expr_block(&mut self, i: ExprBlock) -> ExprBlock { fold_expr_block(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_expr_box(&mut self, i: ExprBox) -> ExprBox { fold_expr_box(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_expr_break(&mut self, i: ExprBreak) -> ExprBreak { fold_expr_break(self, i) }

fn fold_expr_call(&mut self, i: ExprCall) -> ExprCall { fold_expr_call(self, i) }

fn fold_expr_cast(&mut self, i: ExprCast) -> ExprCast { fold_expr_cast(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_expr_catch(&mut self, i: ExprCatch) -> ExprCatch { fold_expr_catch(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_expr_closure(&mut self, i: ExprClosure) -> ExprClosure { fold_expr_closure(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_expr_continue(&mut self, i: ExprContinue) -> ExprContinue { fold_expr_continue(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_expr_field(&mut self, i: ExprField) -> ExprField { fold_expr_field(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_expr_for_loop(&mut self, i: ExprForLoop) -> ExprForLoop { fold_expr_for_loop(self, i) }

fn fold_expr_group(&mut self, i: ExprGroup) -> ExprGroup { fold_expr_group(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_expr_if(&mut self, i: ExprIf) -> ExprIf { fold_expr_if(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_expr_if_let(&mut self, i: ExprIfLet) -> ExprIfLet { fold_expr_if_let(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_expr_in_place(&mut self, i: ExprInPlace) -> ExprInPlace { fold_expr_in_place(self, i) }

fn fold_expr_index(&mut self, i: ExprIndex) -> ExprIndex { fold_expr_index(self, i) }

fn fold_expr_kind(&mut self, i: ExprKind) -> ExprKind { fold_expr_kind(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_expr_loop(&mut self, i: ExprLoop) -> ExprLoop { fold_expr_loop(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_expr_match(&mut self, i: ExprMatch) -> ExprMatch { fold_expr_match(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_expr_method_call(&mut self, i: ExprMethodCall) -> ExprMethodCall { fold_expr_method_call(self, i) }

fn fold_expr_paren(&mut self, i: ExprParen) -> ExprParen { fold_expr_paren(self, i) }

fn fold_expr_path(&mut self, i: ExprPath) -> ExprPath { fold_expr_path(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_expr_range(&mut self, i: ExprRange) -> ExprRange { fold_expr_range(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_expr_repeat(&mut self, i: ExprRepeat) -> ExprRepeat { fold_expr_repeat(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_expr_ret(&mut self, i: ExprRet) -> ExprRet { fold_expr_ret(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_expr_struct(&mut self, i: ExprStruct) -> ExprStruct { fold_expr_struct(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_expr_try(&mut self, i: ExprTry) -> ExprTry { fold_expr_try(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_expr_tup(&mut self, i: ExprTup) -> ExprTup { fold_expr_tup(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_expr_tup_field(&mut self, i: ExprTupField) -> ExprTupField { fold_expr_tup_field(self, i) }

fn fold_expr_type(&mut self, i: ExprType) -> ExprType { fold_expr_type(self, i) }

fn fold_expr_unary(&mut self, i: ExprUnary) -> ExprUnary { fold_expr_unary(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_expr_while(&mut self, i: ExprWhile) -> ExprWhile { fold_expr_while(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_expr_while_let(&mut self, i: ExprWhileLet) -> ExprWhileLet { fold_expr_while_let(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_expr_yield(&mut self, i: ExprYield) -> ExprYield { fold_expr_yield(self, i) }

fn fold_field(&mut self, i: Field) -> Field { fold_field(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_field_pat(&mut self, i: FieldPat) -> FieldPat { fold_field_pat(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_field_value(&mut self, i: FieldValue) -> FieldValue { fold_field_value(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_file(&mut self, i: File) -> File { fold_file(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_fn_arg(&mut self, i: FnArg) -> FnArg { fold_fn_arg(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_fn_decl(&mut self, i: FnDecl) -> FnDecl { fold_fn_decl(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_foreign_item(&mut self, i: ForeignItem) -> ForeignItem { fold_foreign_item(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_foreign_item_fn(&mut self, i: ForeignItemFn) -> ForeignItemFn { fold_foreign_item_fn(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_foreign_item_kind(&mut self, i: ForeignItemKind) -> ForeignItemKind { fold_foreign_item_kind(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_foreign_item_static(&mut self, i: ForeignItemStatic) -> ForeignItemStatic { fold_foreign_item_static(self, i) }

fn fold_function_ret_ty(&mut self, i: FunctionRetTy) -> FunctionRetTy { fold_function_ret_ty(self, i) }

fn fold_generics(&mut self, i: Generics) -> Generics { fold_generics(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_impl_item(&mut self, i: ImplItem) -> ImplItem { fold_impl_item(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_impl_item_const(&mut self, i: ImplItemConst) -> ImplItemConst { fold_impl_item_const(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_impl_item_kind(&mut self, i: ImplItemKind) -> ImplItemKind { fold_impl_item_kind(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_impl_item_method(&mut self, i: ImplItemMethod) -> ImplItemMethod { fold_impl_item_method(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_impl_item_type(&mut self, i: ImplItemType) -> ImplItemType { fold_impl_item_type(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_impl_polarity(&mut self, i: ImplPolarity) -> ImplPolarity { fold_impl_polarity(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_in_place_kind(&mut self, i: InPlaceKind) -> InPlaceKind { fold_in_place_kind(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_item(&mut self, i: Item) -> Item { fold_item(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_item_const(&mut self, i: ItemConst) -> ItemConst { fold_item_const(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_item_default_impl(&mut self, i: ItemDefaultImpl) -> ItemDefaultImpl { fold_item_default_impl(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_item_enum(&mut self, i: ItemEnum) -> ItemEnum { fold_item_enum(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_item_extern_crate(&mut self, i: ItemExternCrate) -> ItemExternCrate { fold_item_extern_crate(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_item_fn(&mut self, i: ItemFn) -> ItemFn { fold_item_fn(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_item_foreign_mod(&mut self, i: ItemForeignMod) -> ItemForeignMod { fold_item_foreign_mod(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_item_impl(&mut self, i: ItemImpl) -> ItemImpl { fold_item_impl(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_item_kind(&mut self, i: ItemKind) -> ItemKind { fold_item_kind(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_item_mod(&mut self, i: ItemMod) -> ItemMod { fold_item_mod(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_item_static(&mut self, i: ItemStatic) -> ItemStatic { fold_item_static(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_item_struct(&mut self, i: ItemStruct) -> ItemStruct { fold_item_struct(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_item_trait(&mut self, i: ItemTrait) -> ItemTrait { fold_item_trait(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_item_ty(&mut self, i: ItemTy) -> ItemTy { fold_item_ty(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_item_union(&mut self, i: ItemUnion) -> ItemUnion { fold_item_union(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_item_use(&mut self, i: ItemUse) -> ItemUse { fold_item_use(self, i) }

fn fold_lifetime_def(&mut self, i: LifetimeDef) -> LifetimeDef { fold_lifetime_def(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_local(&mut self, i: Local) -> Local { fold_local(self, i) }

fn fold_mac(&mut self, i: Mac) -> Mac { fold_mac(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_mac_stmt_style(&mut self, i: MacStmtStyle) -> MacStmtStyle { fold_mac_stmt_style(self, i) }

fn fold_meta_item(&mut self, i: MetaItem) -> MetaItem { fold_meta_item(self, i) }

fn fold_meta_item_list(&mut self, i: MetaItemList) -> MetaItemList { fold_meta_item_list(self, i) }

fn fold_meta_name_value(&mut self, i: MetaNameValue) -> MetaNameValue { fold_meta_name_value(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_method_sig(&mut self, i: MethodSig) -> MethodSig { fold_method_sig(self, i) }

fn fold_mut_ty(&mut self, i: MutTy) -> MutTy { fold_mut_ty(self, i) }

fn fold_mutability(&mut self, i: Mutability) -> Mutability { fold_mutability(self, i) }

fn fold_nested_meta_item(&mut self, i: NestedMetaItem) -> NestedMetaItem { fold_nested_meta_item(self, i) }

fn fold_parenthesized_parameter_data(&mut self, i: ParenthesizedParameterData) -> ParenthesizedParameterData { fold_parenthesized_parameter_data(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_pat(&mut self, i: Pat) -> Pat { fold_pat(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_pat_box(&mut self, i: PatBox) -> PatBox { fold_pat_box(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_pat_ident(&mut self, i: PatIdent) -> PatIdent { fold_pat_ident(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_pat_lit(&mut self, i: PatLit) -> PatLit { fold_pat_lit(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_pat_path(&mut self, i: PatPath) -> PatPath { fold_pat_path(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_pat_range(&mut self, i: PatRange) -> PatRange { fold_pat_range(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_pat_ref(&mut self, i: PatRef) -> PatRef { fold_pat_ref(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_pat_slice(&mut self, i: PatSlice) -> PatSlice { fold_pat_slice(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_pat_struct(&mut self, i: PatStruct) -> PatStruct { fold_pat_struct(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_pat_tuple(&mut self, i: PatTuple) -> PatTuple { fold_pat_tuple(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_pat_tuple_struct(&mut self, i: PatTupleStruct) -> PatTupleStruct { fold_pat_tuple_struct(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_pat_wild(&mut self, i: PatWild) -> PatWild { fold_pat_wild(self, i) }

fn fold_path(&mut self, i: Path) -> Path { fold_path(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_path_glob(&mut self, i: PathGlob) -> PathGlob { fold_path_glob(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_path_list(&mut self, i: PathList) -> PathList { fold_path_list(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_path_list_item(&mut self, i: PathListItem) -> PathListItem { fold_path_list_item(self, i) }

fn fold_path_parameters(&mut self, i: PathParameters) -> PathParameters { fold_path_parameters(self, i) }

fn fold_path_segment(&mut self, i: PathSegment) -> PathSegment { fold_path_segment(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_path_simple(&mut self, i: PathSimple) -> PathSimple { fold_path_simple(self, i) }

fn fold_poly_trait_ref(&mut self, i: PolyTraitRef) -> PolyTraitRef { fold_poly_trait_ref(self, i) }

fn fold_qself(&mut self, i: QSelf) -> QSelf { fold_qself(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_range_limits(&mut self, i: RangeLimits) -> RangeLimits { fold_range_limits(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_stmt(&mut self, i: Stmt) -> Stmt { fold_stmt(self, i) }

fn fold_trait_bound_modifier(&mut self, i: TraitBoundModifier) -> TraitBoundModifier { fold_trait_bound_modifier(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_trait_item(&mut self, i: TraitItem) -> TraitItem { fold_trait_item(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_trait_item_const(&mut self, i: TraitItemConst) -> TraitItemConst { fold_trait_item_const(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_trait_item_kind(&mut self, i: TraitItemKind) -> TraitItemKind { fold_trait_item_kind(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_trait_item_method(&mut self, i: TraitItemMethod) -> TraitItemMethod { fold_trait_item_method(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_trait_item_type(&mut self, i: TraitItemType) -> TraitItemType { fold_trait_item_type(self, i) }

fn fold_ty(&mut self, i: Ty) -> Ty { fold_ty(self, i) }

fn fold_ty_array(&mut self, i: TyArray) -> TyArray { fold_ty_array(self, i) }

fn fold_ty_bare_fn(&mut self, i: TyBareFn) -> TyBareFn { fold_ty_bare_fn(self, i) }

fn fold_ty_group(&mut self, i: TyGroup) -> TyGroup { fold_ty_group(self, i) }

fn fold_ty_impl_trait(&mut self, i: TyImplTrait) -> TyImplTrait { fold_ty_impl_trait(self, i) }

fn fold_ty_infer(&mut self, i: TyInfer) -> TyInfer { fold_ty_infer(self, i) }

fn fold_ty_never(&mut self, i: TyNever) -> TyNever { fold_ty_never(self, i) }

fn fold_ty_param(&mut self, i: TyParam) -> TyParam { fold_ty_param(self, i) }

fn fold_ty_param_bound(&mut self, i: TyParamBound) -> TyParamBound { fold_ty_param_bound(self, i) }

fn fold_ty_paren(&mut self, i: TyParen) -> TyParen { fold_ty_paren(self, i) }

fn fold_ty_path(&mut self, i: TyPath) -> TyPath { fold_ty_path(self, i) }

fn fold_ty_ptr(&mut self, i: TyPtr) -> TyPtr { fold_ty_ptr(self, i) }

fn fold_ty_rptr(&mut self, i: TyRptr) -> TyRptr { fold_ty_rptr(self, i) }

fn fold_ty_slice(&mut self, i: TySlice) -> TySlice { fold_ty_slice(self, i) }

fn fold_ty_trait_object(&mut self, i: TyTraitObject) -> TyTraitObject { fold_ty_trait_object(self, i) }

fn fold_ty_tup(&mut self, i: TyTup) -> TyTup { fold_ty_tup(self, i) }

fn fold_type_binding(&mut self, i: TypeBinding) -> TypeBinding { fold_type_binding(self, i) }

fn fold_un_op(&mut self, i: UnOp) -> UnOp { fold_un_op(self, i) }

fn fold_unsafety(&mut self, i: Unsafety) -> Unsafety { fold_unsafety(self, i) }

fn fold_variant(&mut self, i: Variant) -> Variant { fold_variant(self, i) }

fn fold_variant_data(&mut self, i: VariantData) -> VariantData { fold_variant_data(self, i) }
# [ cfg ( feature = "full" ) ]
fn fold_view_path(&mut self, i: ViewPath) -> ViewPath { fold_view_path(self, i) }

fn fold_vis_crate(&mut self, i: VisCrate) -> VisCrate { fold_vis_crate(self, i) }

fn fold_vis_inherited(&mut self, i: VisInherited) -> VisInherited { fold_vis_inherited(self, i) }

fn fold_vis_public(&mut self, i: VisPublic) -> VisPublic { fold_vis_public(self, i) }

fn fold_vis_restricted(&mut self, i: VisRestricted) -> VisRestricted { fold_vis_restricted(self, i) }

fn fold_visibility(&mut self, i: Visibility) -> Visibility { fold_visibility(self, i) }

fn fold_where_bound_predicate(&mut self, i: WhereBoundPredicate) -> WhereBoundPredicate { fold_where_bound_predicate(self, i) }

fn fold_where_clause(&mut self, i: WhereClause) -> WhereClause { fold_where_clause(self, i) }

fn fold_where_eq_predicate(&mut self, i: WhereEqPredicate) -> WhereEqPredicate { fold_where_eq_predicate(self, i) }

fn fold_where_predicate(&mut self, i: WherePredicate) -> WherePredicate { fold_where_predicate(self, i) }

fn fold_where_region_predicate(&mut self, i: WhereRegionPredicate) -> WhereRegionPredicate { fold_where_region_predicate(self, i) }

}


pub fn fold_abi<V: Folder + ?Sized>(_visitor: &mut V, _i: Abi) -> Abi {
    Abi {
        extern_token: _i . extern_token,
        kind: _visitor.fold_abi_kind(_i . kind),
    }
}

pub fn fold_abi_kind<V: Folder + ?Sized>(_visitor: &mut V, _i: AbiKind) -> AbiKind {
    use ::AbiKind::*;
    match _i {
        Named(_binding_0, ) => {
            Named (
                _binding_0,
            )
        }
        Default => { Default }
    }
}

pub fn fold_angle_bracketed_parameter_data<V: Folder + ?Sized>(_visitor: &mut V, _i: AngleBracketedParameterData) -> AngleBracketedParameterData {
    AngleBracketedParameterData {
        turbofish: _i . turbofish,
        lt_token: _i . lt_token,
        lifetimes: _i . lifetimes,
        types: FoldHelper::lift(_i . types, |it| { _visitor.fold_ty(it) }),
        bindings: FoldHelper::lift(_i . bindings, |it| { _visitor.fold_type_binding(it) }),
        gt_token: _i . gt_token,
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_arg_captured<V: Folder + ?Sized>(_visitor: &mut V, _i: ArgCaptured) -> ArgCaptured {
    ArgCaptured {
        pat: _visitor.fold_pat(_i . pat),
        colon_token: _i . colon_token,
        ty: _visitor.fold_ty(_i . ty),
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_arg_self<V: Folder + ?Sized>(_visitor: &mut V, _i: ArgSelf) -> ArgSelf {
    ArgSelf {
        mutbl: _visitor.fold_mutability(_i . mutbl),
        self_token: _i . self_token,
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_arg_self_ref<V: Folder + ?Sized>(_visitor: &mut V, _i: ArgSelfRef) -> ArgSelfRef {
    ArgSelfRef {
        and_token: _i . and_token,
        self_token: _i . self_token,
        lifetime: _i . lifetime,
        mutbl: _visitor.fold_mutability(_i . mutbl),
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_arm<V: Folder + ?Sized>(_visitor: &mut V, _i: Arm) -> Arm {
    Arm {
        attrs: FoldHelper::lift(_i . attrs, |it| { _visitor.fold_attribute(it) }),
        pats: FoldHelper::lift(_i . pats, |it| { _visitor.fold_pat(it) }),
        if_token: _i . if_token,
        guard: (_i . guard).map(|it| { Box::new(_visitor.fold_expr(* it)) }),
        rocket_token: _i . rocket_token,
        body: Box::new(_visitor.fold_expr(* _i . body)),
        comma: _i . comma,
    }
}

pub fn fold_attr_style<V: Folder + ?Sized>(_visitor: &mut V, _i: AttrStyle) -> AttrStyle {
    use ::AttrStyle::*;
    match _i {
        Outer => { Outer }
        Inner(_binding_0, ) => {
            Inner (
                _binding_0,
            )
        }
    }
}

pub fn fold_attribute<V: Folder + ?Sized>(_visitor: &mut V, _i: Attribute) -> Attribute {
    Attribute {
        style: _visitor.fold_attr_style(_i . style),
        pound_token: _i . pound_token,
        bracket_token: _i . bracket_token,
        path: _visitor.fold_path(_i . path),
        tts: _i . tts,
        is_sugared_doc: _i . is_sugared_doc,
    }
}

pub fn fold_bare_fn_arg<V: Folder + ?Sized>(_visitor: &mut V, _i: BareFnArg) -> BareFnArg {
    BareFnArg {
        name: _i . name,
        ty: _visitor.fold_ty(_i . ty),
    }
}

pub fn fold_bare_fn_arg_name<V: Folder + ?Sized>(_visitor: &mut V, _i: BareFnArgName) -> BareFnArgName {
    use ::BareFnArgName::*;
    match _i {
        Named(_binding_0, ) => {
            Named (
                _binding_0,
            )
        }
        Wild(_binding_0, ) => {
            Wild (
                _binding_0,
            )
        }
    }
}

pub fn fold_bare_fn_ty<V: Folder + ?Sized>(_visitor: &mut V, _i: BareFnTy) -> BareFnTy {
    BareFnTy {
        lifetimes: (_i . lifetimes).map(|it| { _visitor.fold_bound_lifetimes(it) }),
        unsafety: _visitor.fold_unsafety(_i . unsafety),
        abi: (_i . abi).map(|it| { _visitor.fold_abi(it) }),
        fn_token: _i . fn_token,
        paren_token: _i . paren_token,
        inputs: FoldHelper::lift(_i . inputs, |it| { _visitor.fold_bare_fn_arg(it) }),
        variadic: _i . variadic,
        output: _visitor.fold_function_ret_ty(_i . output),
    }
}

pub fn fold_bin_op<V: Folder + ?Sized>(_visitor: &mut V, _i: BinOp) -> BinOp {
    use ::BinOp::*;
    match _i {
        Add(_binding_0, ) => {
            Add (
                _binding_0,
            )
        }
        Sub(_binding_0, ) => {
            Sub (
                _binding_0,
            )
        }
        Mul(_binding_0, ) => {
            Mul (
                _binding_0,
            )
        }
        Div(_binding_0, ) => {
            Div (
                _binding_0,
            )
        }
        Rem(_binding_0, ) => {
            Rem (
                _binding_0,
            )
        }
        And(_binding_0, ) => {
            And (
                _binding_0,
            )
        }
        Or(_binding_0, ) => {
            Or (
                _binding_0,
            )
        }
        BitXor(_binding_0, ) => {
            BitXor (
                _binding_0,
            )
        }
        BitAnd(_binding_0, ) => {
            BitAnd (
                _binding_0,
            )
        }
        BitOr(_binding_0, ) => {
            BitOr (
                _binding_0,
            )
        }
        Shl(_binding_0, ) => {
            Shl (
                _binding_0,
            )
        }
        Shr(_binding_0, ) => {
            Shr (
                _binding_0,
            )
        }
        Eq(_binding_0, ) => {
            Eq (
                _binding_0,
            )
        }
        Lt(_binding_0, ) => {
            Lt (
                _binding_0,
            )
        }
        Le(_binding_0, ) => {
            Le (
                _binding_0,
            )
        }
        Ne(_binding_0, ) => {
            Ne (
                _binding_0,
            )
        }
        Ge(_binding_0, ) => {
            Ge (
                _binding_0,
            )
        }
        Gt(_binding_0, ) => {
            Gt (
                _binding_0,
            )
        }
        AddEq(_binding_0, ) => {
            AddEq (
                _binding_0,
            )
        }
        SubEq(_binding_0, ) => {
            SubEq (
                _binding_0,
            )
        }
        MulEq(_binding_0, ) => {
            MulEq (
                _binding_0,
            )
        }
        DivEq(_binding_0, ) => {
            DivEq (
                _binding_0,
            )
        }
        RemEq(_binding_0, ) => {
            RemEq (
                _binding_0,
            )
        }
        BitXorEq(_binding_0, ) => {
            BitXorEq (
                _binding_0,
            )
        }
        BitAndEq(_binding_0, ) => {
            BitAndEq (
                _binding_0,
            )
        }
        BitOrEq(_binding_0, ) => {
            BitOrEq (
                _binding_0,
            )
        }
        ShlEq(_binding_0, ) => {
            ShlEq (
                _binding_0,
            )
        }
        ShrEq(_binding_0, ) => {
            ShrEq (
                _binding_0,
            )
        }
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_binding_mode<V: Folder + ?Sized>(_visitor: &mut V, _i: BindingMode) -> BindingMode {
    use ::BindingMode::*;
    match _i {
        ByRef(_binding_0, _binding_1, ) => {
            ByRef (
                _binding_0,
                _visitor.fold_mutability(_binding_1),
            )
        }
        ByValue(_binding_0, ) => {
            ByValue (
                _visitor.fold_mutability(_binding_0),
            )
        }
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_block<V: Folder + ?Sized>(_visitor: &mut V, _i: Block) -> Block {
    Block {
        brace_token: _i . brace_token,
        stmts: FoldHelper::lift(_i . stmts, |it| { _visitor.fold_stmt(it) }),
    }
}

pub fn fold_body<V: Folder + ?Sized>(_visitor: &mut V, _i: Body) -> Body {
    use ::Body::*;
    match _i {
        Enum(_binding_0, ) => {
            Enum (
                _visitor.fold_body_enum(_binding_0),
            )
        }
        Struct(_binding_0, ) => {
            Struct (
                _visitor.fold_body_struct(_binding_0),
            )
        }
    }
}

pub fn fold_body_enum<V: Folder + ?Sized>(_visitor: &mut V, _i: BodyEnum) -> BodyEnum {
    BodyEnum {
        enum_token: _i . enum_token,
        brace_token: _i . brace_token,
        variants: FoldHelper::lift(_i . variants, |it| { _visitor.fold_variant(it) }),
    }
}

pub fn fold_body_struct<V: Folder + ?Sized>(_visitor: &mut V, _i: BodyStruct) -> BodyStruct {
    BodyStruct {
        data: _visitor.fold_variant_data(_i . data),
        struct_token: _i . struct_token,
        semi_token: _i . semi_token,
    }
}

pub fn fold_bound_lifetimes<V: Folder + ?Sized>(_visitor: &mut V, _i: BoundLifetimes) -> BoundLifetimes {
    BoundLifetimes {
        for_token: _i . for_token,
        lt_token: _i . lt_token,
        lifetimes: FoldHelper::lift(_i . lifetimes, |it| { _visitor.fold_lifetime_def(it) }),
        gt_token: _i . gt_token,
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_capture_by<V: Folder + ?Sized>(_visitor: &mut V, _i: CaptureBy) -> CaptureBy {
    use ::CaptureBy::*;
    match _i {
        Value(_binding_0, ) => {
            Value (
                _binding_0,
            )
        }
        Ref => { Ref }
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_constness<V: Folder + ?Sized>(_visitor: &mut V, _i: Constness) -> Constness {
    use ::Constness::*;
    match _i {
        Const(_binding_0, ) => {
            Const (
                _binding_0,
            )
        }
        NotConst => { NotConst }
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_defaultness<V: Folder + ?Sized>(_visitor: &mut V, _i: Defaultness) -> Defaultness {
    use ::Defaultness::*;
    match _i {
        Default(_binding_0, ) => {
            Default (
                _binding_0,
            )
        }
        Final => { Final }
    }
}

pub fn fold_derive_input<V: Folder + ?Sized>(_visitor: &mut V, _i: DeriveInput) -> DeriveInput {
    DeriveInput {
        ident: _i . ident,
        vis: _visitor.fold_visibility(_i . vis),
        attrs: FoldHelper::lift(_i . attrs, |it| { _visitor.fold_attribute(it) }),
        generics: _visitor.fold_generics(_i . generics),
        body: _visitor.fold_body(_i . body),
    }
}

pub fn fold_expr<V: Folder + ?Sized>(_visitor: &mut V, _i: Expr) -> Expr {
    Expr {
        node: _visitor.fold_expr_kind(_i . node),
        attrs: FoldHelper::lift(_i . attrs, |it| { _visitor.fold_attribute(it) }),
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_expr_addr_of<V: Folder + ?Sized>(_visitor: &mut V, _i: ExprAddrOf) -> ExprAddrOf {
    ExprAddrOf {
        and_token: _i . and_token,
        mutbl: _visitor.fold_mutability(_i . mutbl),
        expr: Box::new(_visitor.fold_expr(* _i . expr)),
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_expr_array<V: Folder + ?Sized>(_visitor: &mut V, _i: ExprArray) -> ExprArray {
    ExprArray {
        exprs: FoldHelper::lift(_i . exprs, |it| { _visitor.fold_expr(it) }),
        bracket_token: _i . bracket_token,
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_expr_assign<V: Folder + ?Sized>(_visitor: &mut V, _i: ExprAssign) -> ExprAssign {
    ExprAssign {
        left: Box::new(_visitor.fold_expr(* _i . left)),
        right: Box::new(_visitor.fold_expr(* _i . right)),
        eq_token: _i . eq_token,
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_expr_assign_op<V: Folder + ?Sized>(_visitor: &mut V, _i: ExprAssignOp) -> ExprAssignOp {
    ExprAssignOp {
        op: _visitor.fold_bin_op(_i . op),
        left: Box::new(_visitor.fold_expr(* _i . left)),
        right: Box::new(_visitor.fold_expr(* _i . right)),
    }
}

pub fn fold_expr_binary<V: Folder + ?Sized>(_visitor: &mut V, _i: ExprBinary) -> ExprBinary {
    ExprBinary {
        op: _visitor.fold_bin_op(_i . op),
        left: Box::new(_visitor.fold_expr(* _i . left)),
        right: Box::new(_visitor.fold_expr(* _i . right)),
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_expr_block<V: Folder + ?Sized>(_visitor: &mut V, _i: ExprBlock) -> ExprBlock {
    ExprBlock {
        unsafety: _visitor.fold_unsafety(_i . unsafety),
        block: _visitor.fold_block(_i . block),
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_expr_box<V: Folder + ?Sized>(_visitor: &mut V, _i: ExprBox) -> ExprBox {
    ExprBox {
        expr: Box::new(_visitor.fold_expr(* _i . expr)),
        box_token: _i . box_token,
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_expr_break<V: Folder + ?Sized>(_visitor: &mut V, _i: ExprBreak) -> ExprBreak {
    ExprBreak {
        label: _i . label,
        expr: (_i . expr).map(|it| { Box::new(_visitor.fold_expr(* it)) }),
        break_token: _i . break_token,
    }
}

pub fn fold_expr_call<V: Folder + ?Sized>(_visitor: &mut V, _i: ExprCall) -> ExprCall {
    ExprCall {
        func: Box::new(_visitor.fold_expr(* _i . func)),
        args: FoldHelper::lift(_i . args, |it| { _visitor.fold_expr(it) }),
        paren_token: _i . paren_token,
    }
}

pub fn fold_expr_cast<V: Folder + ?Sized>(_visitor: &mut V, _i: ExprCast) -> ExprCast {
    ExprCast {
        expr: Box::new(_visitor.fold_expr(* _i . expr)),
        as_token: _i . as_token,
        ty: Box::new(_visitor.fold_ty(* _i . ty)),
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_expr_catch<V: Folder + ?Sized>(_visitor: &mut V, _i: ExprCatch) -> ExprCatch {
    ExprCatch {
        do_token: _i . do_token,
        catch_token: _i . catch_token,
        block: _visitor.fold_block(_i . block),
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_expr_closure<V: Folder + ?Sized>(_visitor: &mut V, _i: ExprClosure) -> ExprClosure {
    ExprClosure {
        capture: _visitor.fold_capture_by(_i . capture),
        decl: Box::new(_visitor.fold_fn_decl(* _i . decl)),
        body: Box::new(_visitor.fold_expr(* _i . body)),
        or1_token: _i . or1_token,
        or2_token: _i . or2_token,
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_expr_continue<V: Folder + ?Sized>(_visitor: &mut V, _i: ExprContinue) -> ExprContinue {
    ExprContinue {
        label: _i . label,
        continue_token: _i . continue_token,
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_expr_field<V: Folder + ?Sized>(_visitor: &mut V, _i: ExprField) -> ExprField {
    ExprField {
        expr: Box::new(_visitor.fold_expr(* _i . expr)),
        field: _i . field,
        dot_token: _i . dot_token,
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_expr_for_loop<V: Folder + ?Sized>(_visitor: &mut V, _i: ExprForLoop) -> ExprForLoop {
    ExprForLoop {
        pat: Box::new(_visitor.fold_pat(* _i . pat)),
        expr: Box::new(_visitor.fold_expr(* _i . expr)),
        body: _visitor.fold_block(_i . body),
        label: _i . label,
        for_token: _i . for_token,
        colon_token: _i . colon_token,
        in_token: _i . in_token,
    }
}

pub fn fold_expr_group<V: Folder + ?Sized>(_visitor: &mut V, _i: ExprGroup) -> ExprGroup {
    ExprGroup {
        expr: Box::new(_visitor.fold_expr(* _i . expr)),
        group_token: _i . group_token,
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_expr_if<V: Folder + ?Sized>(_visitor: &mut V, _i: ExprIf) -> ExprIf {
    ExprIf {
        cond: Box::new(_visitor.fold_expr(* _i . cond)),
        if_true: _visitor.fold_block(_i . if_true),
        if_false: (_i . if_false).map(|it| { Box::new(_visitor.fold_expr(* it)) }),
        if_token: _i . if_token,
        else_token: _i . else_token,
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_expr_if_let<V: Folder + ?Sized>(_visitor: &mut V, _i: ExprIfLet) -> ExprIfLet {
    ExprIfLet {
        pat: Box::new(_visitor.fold_pat(* _i . pat)),
        expr: Box::new(_visitor.fold_expr(* _i . expr)),
        if_true: _visitor.fold_block(_i . if_true),
        if_false: (_i . if_false).map(|it| { Box::new(_visitor.fold_expr(* it)) }),
        if_token: _i . if_token,
        let_token: _i . let_token,
        eq_token: _i . eq_token,
        else_token: _i . else_token,
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_expr_in_place<V: Folder + ?Sized>(_visitor: &mut V, _i: ExprInPlace) -> ExprInPlace {
    ExprInPlace {
        place: Box::new(_visitor.fold_expr(* _i . place)),
        kind: _visitor.fold_in_place_kind(_i . kind),
        value: Box::new(_visitor.fold_expr(* _i . value)),
    }
}

pub fn fold_expr_index<V: Folder + ?Sized>(_visitor: &mut V, _i: ExprIndex) -> ExprIndex {
    ExprIndex {
        expr: Box::new(_visitor.fold_expr(* _i . expr)),
        index: Box::new(_visitor.fold_expr(* _i . index)),
        bracket_token: _i . bracket_token,
    }
}

pub fn fold_expr_kind<V: Folder + ?Sized>(_visitor: &mut V, _i: ExprKind) -> ExprKind {
    use ::ExprKind::*;
    match _i {
        Box(_binding_0, ) => {
            Box (
                full!(_visitor.fold_expr_box(_binding_0)),
            )
        }
        InPlace(_binding_0, ) => {
            InPlace (
                full!(_visitor.fold_expr_in_place(_binding_0)),
            )
        }
        Array(_binding_0, ) => {
            Array (
                full!(_visitor.fold_expr_array(_binding_0)),
            )
        }
        Call(_binding_0, ) => {
            Call (
                _visitor.fold_expr_call(_binding_0),
            )
        }
        MethodCall(_binding_0, ) => {
            MethodCall (
                full!(_visitor.fold_expr_method_call(_binding_0)),
            )
        }
        Tup(_binding_0, ) => {
            Tup (
                full!(_visitor.fold_expr_tup(_binding_0)),
            )
        }
        Binary(_binding_0, ) => {
            Binary (
                _visitor.fold_expr_binary(_binding_0),
            )
        }
        Unary(_binding_0, ) => {
            Unary (
                _visitor.fold_expr_unary(_binding_0),
            )
        }
        Lit(_binding_0, ) => {
            Lit (
                _binding_0,
            )
        }
        Cast(_binding_0, ) => {
            Cast (
                _visitor.fold_expr_cast(_binding_0),
            )
        }
        Type(_binding_0, ) => {
            Type (
                _visitor.fold_expr_type(_binding_0),
            )
        }
        If(_binding_0, ) => {
            If (
                full!(_visitor.fold_expr_if(_binding_0)),
            )
        }
        IfLet(_binding_0, ) => {
            IfLet (
                full!(_visitor.fold_expr_if_let(_binding_0)),
            )
        }
        While(_binding_0, ) => {
            While (
                full!(_visitor.fold_expr_while(_binding_0)),
            )
        }
        WhileLet(_binding_0, ) => {
            WhileLet (
                full!(_visitor.fold_expr_while_let(_binding_0)),
            )
        }
        ForLoop(_binding_0, ) => {
            ForLoop (
                full!(_visitor.fold_expr_for_loop(_binding_0)),
            )
        }
        Loop(_binding_0, ) => {
            Loop (
                full!(_visitor.fold_expr_loop(_binding_0)),
            )
        }
        Match(_binding_0, ) => {
            Match (
                full!(_visitor.fold_expr_match(_binding_0)),
            )
        }
        Closure(_binding_0, ) => {
            Closure (
                full!(_visitor.fold_expr_closure(_binding_0)),
            )
        }
        Block(_binding_0, ) => {
            Block (
                full!(_visitor.fold_expr_block(_binding_0)),
            )
        }
        Assign(_binding_0, ) => {
            Assign (
                full!(_visitor.fold_expr_assign(_binding_0)),
            )
        }
        AssignOp(_binding_0, ) => {
            AssignOp (
                full!(_visitor.fold_expr_assign_op(_binding_0)),
            )
        }
        Field(_binding_0, ) => {
            Field (
                full!(_visitor.fold_expr_field(_binding_0)),
            )
        }
        TupField(_binding_0, ) => {
            TupField (
                full!(_visitor.fold_expr_tup_field(_binding_0)),
            )
        }
        Index(_binding_0, ) => {
            Index (
                _visitor.fold_expr_index(_binding_0),
            )
        }
        Range(_binding_0, ) => {
            Range (
                full!(_visitor.fold_expr_range(_binding_0)),
            )
        }
        Path(_binding_0, ) => {
            Path (
                _visitor.fold_expr_path(_binding_0),
            )
        }
        AddrOf(_binding_0, ) => {
            AddrOf (
                full!(_visitor.fold_expr_addr_of(_binding_0)),
            )
        }
        Break(_binding_0, ) => {
            Break (
                full!(_visitor.fold_expr_break(_binding_0)),
            )
        }
        Continue(_binding_0, ) => {
            Continue (
                full!(_visitor.fold_expr_continue(_binding_0)),
            )
        }
        Ret(_binding_0, ) => {
            Ret (
                full!(_visitor.fold_expr_ret(_binding_0)),
            )
        }
        Mac(_binding_0, ) => {
            Mac (
                _visitor.fold_mac(_binding_0),
            )
        }
        Struct(_binding_0, ) => {
            Struct (
                full!(_visitor.fold_expr_struct(_binding_0)),
            )
        }
        Repeat(_binding_0, ) => {
            Repeat (
                full!(_visitor.fold_expr_repeat(_binding_0)),
            )
        }
        Paren(_binding_0, ) => {
            Paren (
                _visitor.fold_expr_paren(_binding_0),
            )
        }
        Group(_binding_0, ) => {
            Group (
                _visitor.fold_expr_group(_binding_0),
            )
        }
        Try(_binding_0, ) => {
            Try (
                full!(_visitor.fold_expr_try(_binding_0)),
            )
        }
        Catch(_binding_0, ) => {
            Catch (
                full!(_visitor.fold_expr_catch(_binding_0)),
            )
        }
        Yield(_binding_0, ) => {
            Yield (
                full!(_visitor.fold_expr_yield(_binding_0)),
            )
        }
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_expr_loop<V: Folder + ?Sized>(_visitor: &mut V, _i: ExprLoop) -> ExprLoop {
    ExprLoop {
        body: _visitor.fold_block(_i . body),
        label: _i . label,
        loop_token: _i . loop_token,
        colon_token: _i . colon_token,
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_expr_match<V: Folder + ?Sized>(_visitor: &mut V, _i: ExprMatch) -> ExprMatch {
    ExprMatch {
        match_token: _i . match_token,
        brace_token: _i . brace_token,
        expr: Box::new(_visitor.fold_expr(* _i . expr)),
        arms: FoldHelper::lift(_i . arms, |it| { _visitor.fold_arm(it) }),
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_expr_method_call<V: Folder + ?Sized>(_visitor: &mut V, _i: ExprMethodCall) -> ExprMethodCall {
    ExprMethodCall {
        expr: Box::new(_visitor.fold_expr(* _i . expr)),
        method: _i . method,
        typarams: FoldHelper::lift(_i . typarams, |it| { _visitor.fold_ty(it) }),
        args: FoldHelper::lift(_i . args, |it| { _visitor.fold_expr(it) }),
        paren_token: _i . paren_token,
        dot_token: _i . dot_token,
        lt_token: _i . lt_token,
        colon2_token: _i . colon2_token,
        gt_token: _i . gt_token,
    }
}

pub fn fold_expr_paren<V: Folder + ?Sized>(_visitor: &mut V, _i: ExprParen) -> ExprParen {
    ExprParen {
        expr: Box::new(_visitor.fold_expr(* _i . expr)),
        paren_token: _i . paren_token,
    }
}

pub fn fold_expr_path<V: Folder + ?Sized>(_visitor: &mut V, _i: ExprPath) -> ExprPath {
    ExprPath {
        qself: (_i . qself).map(|it| { _visitor.fold_qself(it) }),
        path: _visitor.fold_path(_i . path),
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_expr_range<V: Folder + ?Sized>(_visitor: &mut V, _i: ExprRange) -> ExprRange {
    ExprRange {
        from: (_i . from).map(|it| { Box::new(_visitor.fold_expr(* it)) }),
        to: (_i . to).map(|it| { Box::new(_visitor.fold_expr(* it)) }),
        limits: _visitor.fold_range_limits(_i . limits),
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_expr_repeat<V: Folder + ?Sized>(_visitor: &mut V, _i: ExprRepeat) -> ExprRepeat {
    ExprRepeat {
        bracket_token: _i . bracket_token,
        semi_token: _i . semi_token,
        expr: Box::new(_visitor.fold_expr(* _i . expr)),
        amt: Box::new(_visitor.fold_expr(* _i . amt)),
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_expr_ret<V: Folder + ?Sized>(_visitor: &mut V, _i: ExprRet) -> ExprRet {
    ExprRet {
        expr: (_i . expr).map(|it| { Box::new(_visitor.fold_expr(* it)) }),
        return_token: _i . return_token,
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_expr_struct<V: Folder + ?Sized>(_visitor: &mut V, _i: ExprStruct) -> ExprStruct {
    ExprStruct {
        path: _visitor.fold_path(_i . path),
        fields: FoldHelper::lift(_i . fields, |it| { _visitor.fold_field_value(it) }),
        rest: (_i . rest).map(|it| { Box::new(_visitor.fold_expr(* it)) }),
        dot2_token: _i . dot2_token,
        brace_token: _i . brace_token,
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_expr_try<V: Folder + ?Sized>(_visitor: &mut V, _i: ExprTry) -> ExprTry {
    ExprTry {
        expr: Box::new(_visitor.fold_expr(* _i . expr)),
        question_token: _i . question_token,
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_expr_tup<V: Folder + ?Sized>(_visitor: &mut V, _i: ExprTup) -> ExprTup {
    ExprTup {
        args: FoldHelper::lift(_i . args, |it| { _visitor.fold_expr(it) }),
        paren_token: _i . paren_token,
        lone_comma: _i . lone_comma,
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_expr_tup_field<V: Folder + ?Sized>(_visitor: &mut V, _i: ExprTupField) -> ExprTupField {
    ExprTupField {
        expr: Box::new(_visitor.fold_expr(* _i . expr)),
        field: _i . field,
        dot_token: _i . dot_token,
    }
}

pub fn fold_expr_type<V: Folder + ?Sized>(_visitor: &mut V, _i: ExprType) -> ExprType {
    ExprType {
        expr: Box::new(_visitor.fold_expr(* _i . expr)),
        colon_token: _i . colon_token,
        ty: Box::new(_visitor.fold_ty(* _i . ty)),
    }
}

pub fn fold_expr_unary<V: Folder + ?Sized>(_visitor: &mut V, _i: ExprUnary) -> ExprUnary {
    ExprUnary {
        op: _visitor.fold_un_op(_i . op),
        expr: Box::new(_visitor.fold_expr(* _i . expr)),
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_expr_while<V: Folder + ?Sized>(_visitor: &mut V, _i: ExprWhile) -> ExprWhile {
    ExprWhile {
        cond: Box::new(_visitor.fold_expr(* _i . cond)),
        body: _visitor.fold_block(_i . body),
        label: _i . label,
        colon_token: _i . colon_token,
        while_token: _i . while_token,
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_expr_while_let<V: Folder + ?Sized>(_visitor: &mut V, _i: ExprWhileLet) -> ExprWhileLet {
    ExprWhileLet {
        pat: Box::new(_visitor.fold_pat(* _i . pat)),
        expr: Box::new(_visitor.fold_expr(* _i . expr)),
        body: _visitor.fold_block(_i . body),
        label: _i . label,
        colon_token: _i . colon_token,
        while_token: _i . while_token,
        let_token: _i . let_token,
        eq_token: _i . eq_token,
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_expr_yield<V: Folder + ?Sized>(_visitor: &mut V, _i: ExprYield) -> ExprYield {
    ExprYield {
        yield_token: _i . yield_token,
        expr: (_i . expr).map(|it| { Box::new(_visitor.fold_expr(* it)) }),
    }
}

pub fn fold_field<V: Folder + ?Sized>(_visitor: &mut V, _i: Field) -> Field {
    Field {
        ident: _i . ident,
        vis: _visitor.fold_visibility(_i . vis),
        attrs: FoldHelper::lift(_i . attrs, |it| { _visitor.fold_attribute(it) }),
        ty: _visitor.fold_ty(_i . ty),
        colon_token: _i . colon_token,
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_field_pat<V: Folder + ?Sized>(_visitor: &mut V, _i: FieldPat) -> FieldPat {
    FieldPat {
        ident: _i . ident,
        pat: Box::new(_visitor.fold_pat(* _i . pat)),
        is_shorthand: _i . is_shorthand,
        colon_token: _i . colon_token,
        attrs: FoldHelper::lift(_i . attrs, |it| { _visitor.fold_attribute(it) }),
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_field_value<V: Folder + ?Sized>(_visitor: &mut V, _i: FieldValue) -> FieldValue {
    FieldValue {
        ident: _i . ident,
        expr: _visitor.fold_expr(_i . expr),
        is_shorthand: _i . is_shorthand,
        attrs: FoldHelper::lift(_i . attrs, |it| { _visitor.fold_attribute(it) }),
        colon_token: _i . colon_token,
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_file<V: Folder + ?Sized>(_visitor: &mut V, _i: File) -> File {
    File {
        shebang: _i . shebang,
        attrs: FoldHelper::lift(_i . attrs, |it| { _visitor.fold_attribute(it) }),
        items: FoldHelper::lift(_i . items, |it| { _visitor.fold_item(it) }),
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_fn_arg<V: Folder + ?Sized>(_visitor: &mut V, _i: FnArg) -> FnArg {
    use ::FnArg::*;
    match _i {
        SelfRef(_binding_0, ) => {
            SelfRef (
                _visitor.fold_arg_self_ref(_binding_0),
            )
        }
        SelfValue(_binding_0, ) => {
            SelfValue (
                _visitor.fold_arg_self(_binding_0),
            )
        }
        Captured(_binding_0, ) => {
            Captured (
                _visitor.fold_arg_captured(_binding_0),
            )
        }
        Ignored(_binding_0, ) => {
            Ignored (
                _visitor.fold_ty(_binding_0),
            )
        }
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_fn_decl<V: Folder + ?Sized>(_visitor: &mut V, _i: FnDecl) -> FnDecl {
    FnDecl {
        fn_token: _i . fn_token,
        paren_token: _i . paren_token,
        inputs: FoldHelper::lift(_i . inputs, |it| { _visitor.fold_fn_arg(it) }),
        output: _visitor.fold_function_ret_ty(_i . output),
        generics: _visitor.fold_generics(_i . generics),
        variadic: _i . variadic,
        dot_tokens: _i . dot_tokens,
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_foreign_item<V: Folder + ?Sized>(_visitor: &mut V, _i: ForeignItem) -> ForeignItem {
    ForeignItem {
        ident: _i . ident,
        attrs: FoldHelper::lift(_i . attrs, |it| { _visitor.fold_attribute(it) }),
        node: _visitor.fold_foreign_item_kind(_i . node),
        vis: _visitor.fold_visibility(_i . vis),
        semi_token: _i . semi_token,
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_foreign_item_fn<V: Folder + ?Sized>(_visitor: &mut V, _i: ForeignItemFn) -> ForeignItemFn {
    ForeignItemFn {
        decl: Box::new(_visitor.fold_fn_decl(* _i . decl)),
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_foreign_item_kind<V: Folder + ?Sized>(_visitor: &mut V, _i: ForeignItemKind) -> ForeignItemKind {
    use ::ForeignItemKind::*;
    match _i {
        Fn(_binding_0, ) => {
            Fn (
                _visitor.fold_foreign_item_fn(_binding_0),
            )
        }
        Static(_binding_0, ) => {
            Static (
                _visitor.fold_foreign_item_static(_binding_0),
            )
        }
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_foreign_item_static<V: Folder + ?Sized>(_visitor: &mut V, _i: ForeignItemStatic) -> ForeignItemStatic {
    ForeignItemStatic {
        static_token: _i . static_token,
        ty: Box::new(_visitor.fold_ty(* _i . ty)),
        colon_token: _i . colon_token,
        mutbl: _visitor.fold_mutability(_i . mutbl),
    }
}

pub fn fold_function_ret_ty<V: Folder + ?Sized>(_visitor: &mut V, _i: FunctionRetTy) -> FunctionRetTy {
    use ::FunctionRetTy::*;
    match _i {
        Default => { Default }
        Ty(_binding_0, _binding_1, ) => {
            Ty (
                _visitor.fold_ty(_binding_0),
                _binding_1,
            )
        }
    }
}

pub fn fold_generics<V: Folder + ?Sized>(_visitor: &mut V, _i: Generics) -> Generics {
    Generics {
        lt_token: _i . lt_token,
        gt_token: _i . gt_token,
        lifetimes: FoldHelper::lift(_i . lifetimes, |it| { _visitor.fold_lifetime_def(it) }),
        ty_params: FoldHelper::lift(_i . ty_params, |it| { _visitor.fold_ty_param(it) }),
        where_clause: _visitor.fold_where_clause(_i . where_clause),
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_impl_item<V: Folder + ?Sized>(_visitor: &mut V, _i: ImplItem) -> ImplItem {
    ImplItem {
        attrs: FoldHelper::lift(_i . attrs, |it| { _visitor.fold_attribute(it) }),
        node: _visitor.fold_impl_item_kind(_i . node),
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_impl_item_const<V: Folder + ?Sized>(_visitor: &mut V, _i: ImplItemConst) -> ImplItemConst {
    ImplItemConst {
        vis: _visitor.fold_visibility(_i . vis),
        defaultness: _visitor.fold_defaultness(_i . defaultness),
        const_token: _i . const_token,
        ident: _i . ident,
        colon_token: _i . colon_token,
        ty: _visitor.fold_ty(_i . ty),
        eq_token: _i . eq_token,
        expr: _visitor.fold_expr(_i . expr),
        semi_token: _i . semi_token,
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_impl_item_kind<V: Folder + ?Sized>(_visitor: &mut V, _i: ImplItemKind) -> ImplItemKind {
    use ::ImplItemKind::*;
    match _i {
        Const(_binding_0, ) => {
            Const (
                _visitor.fold_impl_item_const(_binding_0),
            )
        }
        Method(_binding_0, ) => {
            Method (
                _visitor.fold_impl_item_method(_binding_0),
            )
        }
        Type(_binding_0, ) => {
            Type (
                _visitor.fold_impl_item_type(_binding_0),
            )
        }
        Macro(_binding_0, ) => {
            Macro (
                _visitor.fold_mac(_binding_0),
            )
        }
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_impl_item_method<V: Folder + ?Sized>(_visitor: &mut V, _i: ImplItemMethod) -> ImplItemMethod {
    ImplItemMethod {
        vis: _visitor.fold_visibility(_i . vis),
        defaultness: _visitor.fold_defaultness(_i . defaultness),
        sig: _visitor.fold_method_sig(_i . sig),
        block: _visitor.fold_block(_i . block),
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_impl_item_type<V: Folder + ?Sized>(_visitor: &mut V, _i: ImplItemType) -> ImplItemType {
    ImplItemType {
        vis: _visitor.fold_visibility(_i . vis),
        defaultness: _visitor.fold_defaultness(_i . defaultness),
        type_token: _i . type_token,
        ident: _i . ident,
        eq_token: _i . eq_token,
        ty: _visitor.fold_ty(_i . ty),
        semi_token: _i . semi_token,
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_impl_polarity<V: Folder + ?Sized>(_visitor: &mut V, _i: ImplPolarity) -> ImplPolarity {
    use ::ImplPolarity::*;
    match _i {
        Positive => { Positive }
        Negative(_binding_0, ) => {
            Negative (
                _binding_0,
            )
        }
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_in_place_kind<V: Folder + ?Sized>(_visitor: &mut V, _i: InPlaceKind) -> InPlaceKind {
    use ::InPlaceKind::*;
    match _i {
        Arrow(_binding_0, ) => {
            Arrow (
                _binding_0,
            )
        }
        In(_binding_0, ) => {
            In (
                _binding_0,
            )
        }
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_item<V: Folder + ?Sized>(_visitor: &mut V, _i: Item) -> Item {
    Item {
        attrs: FoldHelper::lift(_i . attrs, |it| { _visitor.fold_attribute(it) }),
        node: _visitor.fold_item_kind(_i . node),
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_item_const<V: Folder + ?Sized>(_visitor: &mut V, _i: ItemConst) -> ItemConst {
    ItemConst {
        vis: _visitor.fold_visibility(_i . vis),
        const_token: _i . const_token,
        ident: _i . ident,
        colon_token: _i . colon_token,
        ty: Box::new(_visitor.fold_ty(* _i . ty)),
        eq_token: _i . eq_token,
        expr: Box::new(_visitor.fold_expr(* _i . expr)),
        semi_token: _i . semi_token,
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_item_default_impl<V: Folder + ?Sized>(_visitor: &mut V, _i: ItemDefaultImpl) -> ItemDefaultImpl {
    ItemDefaultImpl {
        unsafety: _visitor.fold_unsafety(_i . unsafety),
        impl_token: _i . impl_token,
        path: _visitor.fold_path(_i . path),
        for_token: _i . for_token,
        dot2_token: _i . dot2_token,
        brace_token: _i . brace_token,
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_item_enum<V: Folder + ?Sized>(_visitor: &mut V, _i: ItemEnum) -> ItemEnum {
    ItemEnum {
        vis: _visitor.fold_visibility(_i . vis),
        enum_token: _i . enum_token,
        ident: _i . ident,
        generics: _visitor.fold_generics(_i . generics),
        brace_token: _i . brace_token,
        variants: FoldHelper::lift(_i . variants, |it| { _visitor.fold_variant(it) }),
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_item_extern_crate<V: Folder + ?Sized>(_visitor: &mut V, _i: ItemExternCrate) -> ItemExternCrate {
    ItemExternCrate {
        vis: _visitor.fold_visibility(_i . vis),
        extern_token: _i . extern_token,
        crate_token: _i . crate_token,
        ident: _i . ident,
        rename: _i . rename,
        semi_token: _i . semi_token,
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_item_fn<V: Folder + ?Sized>(_visitor: &mut V, _i: ItemFn) -> ItemFn {
    ItemFn {
        vis: _visitor.fold_visibility(_i . vis),
        constness: _visitor.fold_constness(_i . constness),
        unsafety: _visitor.fold_unsafety(_i . unsafety),
        abi: (_i . abi).map(|it| { _visitor.fold_abi(it) }),
        decl: Box::new(_visitor.fold_fn_decl(* _i . decl)),
        ident: _i . ident,
        block: Box::new(_visitor.fold_block(* _i . block)),
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_item_foreign_mod<V: Folder + ?Sized>(_visitor: &mut V, _i: ItemForeignMod) -> ItemForeignMod {
    ItemForeignMod {
        abi: _visitor.fold_abi(_i . abi),
        brace_token: _i . brace_token,
        items: FoldHelper::lift(_i . items, |it| { _visitor.fold_foreign_item(it) }),
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_item_impl<V: Folder + ?Sized>(_visitor: &mut V, _i: ItemImpl) -> ItemImpl {
    ItemImpl {
        defaultness: _visitor.fold_defaultness(_i . defaultness),
        unsafety: _visitor.fold_unsafety(_i . unsafety),
        impl_token: _i . impl_token,
        generics: _visitor.fold_generics(_i . generics),
        trait_: _i . trait_,
        self_ty: Box::new(_visitor.fold_ty(* _i . self_ty)),
        brace_token: _i . brace_token,
        items: FoldHelper::lift(_i . items, |it| { _visitor.fold_impl_item(it) }),
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_item_kind<V: Folder + ?Sized>(_visitor: &mut V, _i: ItemKind) -> ItemKind {
    use ::ItemKind::*;
    match _i {
        ExternCrate(_binding_0, ) => {
            ExternCrate (
                _visitor.fold_item_extern_crate(_binding_0),
            )
        }
        Use(_binding_0, ) => {
            Use (
                _visitor.fold_item_use(_binding_0),
            )
        }
        Static(_binding_0, ) => {
            Static (
                _visitor.fold_item_static(_binding_0),
            )
        }
        Const(_binding_0, ) => {
            Const (
                _visitor.fold_item_const(_binding_0),
            )
        }
        Fn(_binding_0, ) => {
            Fn (
                _visitor.fold_item_fn(_binding_0),
            )
        }
        Mod(_binding_0, ) => {
            Mod (
                _visitor.fold_item_mod(_binding_0),
            )
        }
        ForeignMod(_binding_0, ) => {
            ForeignMod (
                _visitor.fold_item_foreign_mod(_binding_0),
            )
        }
        Ty(_binding_0, ) => {
            Ty (
                _visitor.fold_item_ty(_binding_0),
            )
        }
        Enum(_binding_0, ) => {
            Enum (
                _visitor.fold_item_enum(_binding_0),
            )
        }
        Struct(_binding_0, ) => {
            Struct (
                _visitor.fold_item_struct(_binding_0),
            )
        }
        Union(_binding_0, ) => {
            Union (
                _visitor.fold_item_union(_binding_0),
            )
        }
        Trait(_binding_0, ) => {
            Trait (
                _visitor.fold_item_trait(_binding_0),
            )
        }
        DefaultImpl(_binding_0, ) => {
            DefaultImpl (
                _visitor.fold_item_default_impl(_binding_0),
            )
        }
        Impl(_binding_0, ) => {
            Impl (
                _visitor.fold_item_impl(_binding_0),
            )
        }
        Mac(_binding_0, ) => {
            Mac (
                _visitor.fold_mac(_binding_0),
            )
        }
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_item_mod<V: Folder + ?Sized>(_visitor: &mut V, _i: ItemMod) -> ItemMod {
    ItemMod {
        vis: _visitor.fold_visibility(_i . vis),
        mod_token: _i . mod_token,
        ident: _i . ident,
        content: _i . content,
        semi: _i . semi,
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_item_static<V: Folder + ?Sized>(_visitor: &mut V, _i: ItemStatic) -> ItemStatic {
    ItemStatic {
        vis: _visitor.fold_visibility(_i . vis),
        static_token: _i . static_token,
        mutbl: _visitor.fold_mutability(_i . mutbl),
        ident: _i . ident,
        colon_token: _i . colon_token,
        ty: Box::new(_visitor.fold_ty(* _i . ty)),
        eq_token: _i . eq_token,
        expr: Box::new(_visitor.fold_expr(* _i . expr)),
        semi_token: _i . semi_token,
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_item_struct<V: Folder + ?Sized>(_visitor: &mut V, _i: ItemStruct) -> ItemStruct {
    ItemStruct {
        vis: _visitor.fold_visibility(_i . vis),
        struct_token: _i . struct_token,
        ident: _i . ident,
        generics: _visitor.fold_generics(_i . generics),
        data: _visitor.fold_variant_data(_i . data),
        semi_token: _i . semi_token,
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_item_trait<V: Folder + ?Sized>(_visitor: &mut V, _i: ItemTrait) -> ItemTrait {
    ItemTrait {
        vis: _visitor.fold_visibility(_i . vis),
        unsafety: _visitor.fold_unsafety(_i . unsafety),
        trait_token: _i . trait_token,
        ident: _i . ident,
        generics: _visitor.fold_generics(_i . generics),
        colon_token: _i . colon_token,
        supertraits: FoldHelper::lift(_i . supertraits, |it| { _visitor.fold_ty_param_bound(it) }),
        brace_token: _i . brace_token,
        items: FoldHelper::lift(_i . items, |it| { _visitor.fold_trait_item(it) }),
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_item_ty<V: Folder + ?Sized>(_visitor: &mut V, _i: ItemTy) -> ItemTy {
    ItemTy {
        vis: _visitor.fold_visibility(_i . vis),
        type_token: _i . type_token,
        ident: _i . ident,
        generics: _visitor.fold_generics(_i . generics),
        eq_token: _i . eq_token,
        ty: Box::new(_visitor.fold_ty(* _i . ty)),
        semi_token: _i . semi_token,
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_item_union<V: Folder + ?Sized>(_visitor: &mut V, _i: ItemUnion) -> ItemUnion {
    ItemUnion {
        vis: _visitor.fold_visibility(_i . vis),
        union_token: _i . union_token,
        ident: _i . ident,
        generics: _visitor.fold_generics(_i . generics),
        data: _visitor.fold_variant_data(_i . data),
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_item_use<V: Folder + ?Sized>(_visitor: &mut V, _i: ItemUse) -> ItemUse {
    ItemUse {
        vis: _visitor.fold_visibility(_i . vis),
        use_token: _i . use_token,
        path: Box::new(_visitor.fold_view_path(* _i . path)),
        semi_token: _i . semi_token,
    }
}

pub fn fold_lifetime_def<V: Folder + ?Sized>(_visitor: &mut V, _i: LifetimeDef) -> LifetimeDef {
    LifetimeDef {
        attrs: FoldHelper::lift(_i . attrs, |it| { _visitor.fold_attribute(it) }),
        lifetime: _i . lifetime,
        colon_token: _i . colon_token,
        bounds: _i . bounds,
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_local<V: Folder + ?Sized>(_visitor: &mut V, _i: Local) -> Local {
    Local {
        let_token: _i . let_token,
        colon_token: _i . colon_token,
        eq_token: _i . eq_token,
        semi_token: _i . semi_token,
        pat: Box::new(_visitor.fold_pat(* _i . pat)),
        ty: (_i . ty).map(|it| { Box::new(_visitor.fold_ty(* it)) }),
        init: (_i . init).map(|it| { Box::new(_visitor.fold_expr(* it)) }),
        attrs: FoldHelper::lift(_i . attrs, |it| { _visitor.fold_attribute(it) }),
    }
}

pub fn fold_mac<V: Folder + ?Sized>(_visitor: &mut V, _i: Mac) -> Mac {
    Mac {
        path: _visitor.fold_path(_i . path),
        bang_token: _i . bang_token,
        ident: _i . ident,
        tokens: _i . tokens,
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_mac_stmt_style<V: Folder + ?Sized>(_visitor: &mut V, _i: MacStmtStyle) -> MacStmtStyle {
    use ::MacStmtStyle::*;
    match _i {
        Semicolon(_binding_0, ) => {
            Semicolon (
                _binding_0,
            )
        }
        Braces => { Braces }
        NoBraces => { NoBraces }
    }
}

pub fn fold_meta_item<V: Folder + ?Sized>(_visitor: &mut V, _i: MetaItem) -> MetaItem {
    use ::MetaItem::*;
    match _i {
        Term(_binding_0, ) => {
            Term (
                _binding_0,
            )
        }
        List(_binding_0, ) => {
            List (
                _visitor.fold_meta_item_list(_binding_0),
            )
        }
        NameValue(_binding_0, ) => {
            NameValue (
                _visitor.fold_meta_name_value(_binding_0),
            )
        }
    }
}

pub fn fold_meta_item_list<V: Folder + ?Sized>(_visitor: &mut V, _i: MetaItemList) -> MetaItemList {
    MetaItemList {
        ident: _i . ident,
        paren_token: _i . paren_token,
        nested: FoldHelper::lift(_i . nested, |it| { _visitor.fold_nested_meta_item(it) }),
    }
}

pub fn fold_meta_name_value<V: Folder + ?Sized>(_visitor: &mut V, _i: MetaNameValue) -> MetaNameValue {
    MetaNameValue {
        ident: _i . ident,
        eq_token: _i . eq_token,
        lit: _i . lit,
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_method_sig<V: Folder + ?Sized>(_visitor: &mut V, _i: MethodSig) -> MethodSig {
    MethodSig {
        constness: _visitor.fold_constness(_i . constness),
        unsafety: _visitor.fold_unsafety(_i . unsafety),
        abi: (_i . abi).map(|it| { _visitor.fold_abi(it) }),
        ident: _i . ident,
        decl: _visitor.fold_fn_decl(_i . decl),
    }
}

pub fn fold_mut_ty<V: Folder + ?Sized>(_visitor: &mut V, _i: MutTy) -> MutTy {
    MutTy {
        ty: _visitor.fold_ty(_i . ty),
        mutability: _visitor.fold_mutability(_i . mutability),
    }
}

pub fn fold_mutability<V: Folder + ?Sized>(_visitor: &mut V, _i: Mutability) -> Mutability {
    use ::Mutability::*;
    match _i {
        Mutable(_binding_0, ) => {
            Mutable (
                _binding_0,
            )
        }
        Immutable => { Immutable }
    }
}

pub fn fold_nested_meta_item<V: Folder + ?Sized>(_visitor: &mut V, _i: NestedMetaItem) -> NestedMetaItem {
    use ::NestedMetaItem::*;
    match _i {
        MetaItem(_binding_0, ) => {
            MetaItem (
                _visitor.fold_meta_item(_binding_0),
            )
        }
        Literal(_binding_0, ) => {
            Literal (
                _binding_0,
            )
        }
    }
}

pub fn fold_parenthesized_parameter_data<V: Folder + ?Sized>(_visitor: &mut V, _i: ParenthesizedParameterData) -> ParenthesizedParameterData {
    ParenthesizedParameterData {
        paren_token: _i . paren_token,
        inputs: FoldHelper::lift(_i . inputs, |it| { _visitor.fold_ty(it) }),
        output: _visitor.fold_function_ret_ty(_i . output),
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_pat<V: Folder + ?Sized>(_visitor: &mut V, _i: Pat) -> Pat {
    use ::Pat::*;
    match _i {
        Wild(_binding_0, ) => {
            Wild (
                _visitor.fold_pat_wild(_binding_0),
            )
        }
        Ident(_binding_0, ) => {
            Ident (
                _visitor.fold_pat_ident(_binding_0),
            )
        }
        Struct(_binding_0, ) => {
            Struct (
                _visitor.fold_pat_struct(_binding_0),
            )
        }
        TupleStruct(_binding_0, ) => {
            TupleStruct (
                _visitor.fold_pat_tuple_struct(_binding_0),
            )
        }
        Path(_binding_0, ) => {
            Path (
                _visitor.fold_pat_path(_binding_0),
            )
        }
        Tuple(_binding_0, ) => {
            Tuple (
                _visitor.fold_pat_tuple(_binding_0),
            )
        }
        Box(_binding_0, ) => {
            Box (
                _visitor.fold_pat_box(_binding_0),
            )
        }
        Ref(_binding_0, ) => {
            Ref (
                _visitor.fold_pat_ref(_binding_0),
            )
        }
        Lit(_binding_0, ) => {
            Lit (
                _visitor.fold_pat_lit(_binding_0),
            )
        }
        Range(_binding_0, ) => {
            Range (
                _visitor.fold_pat_range(_binding_0),
            )
        }
        Slice(_binding_0, ) => {
            Slice (
                _visitor.fold_pat_slice(_binding_0),
            )
        }
        Mac(_binding_0, ) => {
            Mac (
                _visitor.fold_mac(_binding_0),
            )
        }
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_pat_box<V: Folder + ?Sized>(_visitor: &mut V, _i: PatBox) -> PatBox {
    PatBox {
        pat: Box::new(_visitor.fold_pat(* _i . pat)),
        box_token: _i . box_token,
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_pat_ident<V: Folder + ?Sized>(_visitor: &mut V, _i: PatIdent) -> PatIdent {
    PatIdent {
        mode: _visitor.fold_binding_mode(_i . mode),
        ident: _i . ident,
        subpat: (_i . subpat).map(|it| { Box::new(_visitor.fold_pat(* it)) }),
        at_token: _i . at_token,
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_pat_lit<V: Folder + ?Sized>(_visitor: &mut V, _i: PatLit) -> PatLit {
    PatLit {
        expr: Box::new(_visitor.fold_expr(* _i . expr)),
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_pat_path<V: Folder + ?Sized>(_visitor: &mut V, _i: PatPath) -> PatPath {
    PatPath {
        qself: (_i . qself).map(|it| { _visitor.fold_qself(it) }),
        path: _visitor.fold_path(_i . path),
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_pat_range<V: Folder + ?Sized>(_visitor: &mut V, _i: PatRange) -> PatRange {
    PatRange {
        lo: Box::new(_visitor.fold_expr(* _i . lo)),
        hi: Box::new(_visitor.fold_expr(* _i . hi)),
        limits: _visitor.fold_range_limits(_i . limits),
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_pat_ref<V: Folder + ?Sized>(_visitor: &mut V, _i: PatRef) -> PatRef {
    PatRef {
        pat: Box::new(_visitor.fold_pat(* _i . pat)),
        mutbl: _visitor.fold_mutability(_i . mutbl),
        and_token: _i . and_token,
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_pat_slice<V: Folder + ?Sized>(_visitor: &mut V, _i: PatSlice) -> PatSlice {
    PatSlice {
        front: FoldHelper::lift(_i . front, |it| { _visitor.fold_pat(it) }),
        middle: (_i . middle).map(|it| { Box::new(_visitor.fold_pat(* it)) }),
        back: FoldHelper::lift(_i . back, |it| { _visitor.fold_pat(it) }),
        dot2_token: _i . dot2_token,
        comma_token: _i . comma_token,
        bracket_token: _i . bracket_token,
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_pat_struct<V: Folder + ?Sized>(_visitor: &mut V, _i: PatStruct) -> PatStruct {
    PatStruct {
        path: _visitor.fold_path(_i . path),
        fields: FoldHelper::lift(_i . fields, |it| { _visitor.fold_field_pat(it) }),
        brace_token: _i . brace_token,
        dot2_token: _i . dot2_token,
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_pat_tuple<V: Folder + ?Sized>(_visitor: &mut V, _i: PatTuple) -> PatTuple {
    PatTuple {
        pats: FoldHelper::lift(_i . pats, |it| { _visitor.fold_pat(it) }),
        dots_pos: _i . dots_pos,
        paren_token: _i . paren_token,
        dot2_token: _i . dot2_token,
        comma_token: _i . comma_token,
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_pat_tuple_struct<V: Folder + ?Sized>(_visitor: &mut V, _i: PatTupleStruct) -> PatTupleStruct {
    PatTupleStruct {
        path: _visitor.fold_path(_i . path),
        pat: _visitor.fold_pat_tuple(_i . pat),
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_pat_wild<V: Folder + ?Sized>(_visitor: &mut V, _i: PatWild) -> PatWild {
    PatWild {
        underscore_token: _i . underscore_token,
    }
}

pub fn fold_path<V: Folder + ?Sized>(_visitor: &mut V, _i: Path) -> Path {
    Path {
        leading_colon: _i . leading_colon,
        segments: FoldHelper::lift(_i . segments, |it| { _visitor.fold_path_segment(it) }),
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_path_glob<V: Folder + ?Sized>(_visitor: &mut V, _i: PathGlob) -> PathGlob {
    PathGlob {
        path: _visitor.fold_path(_i . path),
        colon2_token: _i . colon2_token,
        star_token: _i . star_token,
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_path_list<V: Folder + ?Sized>(_visitor: &mut V, _i: PathList) -> PathList {
    PathList {
        path: _visitor.fold_path(_i . path),
        colon2_token: _i . colon2_token,
        brace_token: _i . brace_token,
        items: FoldHelper::lift(_i . items, |it| { _visitor.fold_path_list_item(it) }),
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_path_list_item<V: Folder + ?Sized>(_visitor: &mut V, _i: PathListItem) -> PathListItem {
    PathListItem {
        name: _i . name,
        rename: _i . rename,
        as_token: _i . as_token,
    }
}

pub fn fold_path_parameters<V: Folder + ?Sized>(_visitor: &mut V, _i: PathParameters) -> PathParameters {
    use ::PathParameters::*;
    match _i {
        None => { None }
        AngleBracketed(_binding_0, ) => {
            AngleBracketed (
                _visitor.fold_angle_bracketed_parameter_data(_binding_0),
            )
        }
        Parenthesized(_binding_0, ) => {
            Parenthesized (
                _visitor.fold_parenthesized_parameter_data(_binding_0),
            )
        }
    }
}

pub fn fold_path_segment<V: Folder + ?Sized>(_visitor: &mut V, _i: PathSegment) -> PathSegment {
    PathSegment {
        ident: _i . ident,
        parameters: _visitor.fold_path_parameters(_i . parameters),
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_path_simple<V: Folder + ?Sized>(_visitor: &mut V, _i: PathSimple) -> PathSimple {
    PathSimple {
        path: _visitor.fold_path(_i . path),
        as_token: _i . as_token,
        rename: _i . rename,
    }
}

pub fn fold_poly_trait_ref<V: Folder + ?Sized>(_visitor: &mut V, _i: PolyTraitRef) -> PolyTraitRef {
    PolyTraitRef {
        bound_lifetimes: (_i . bound_lifetimes).map(|it| { _visitor.fold_bound_lifetimes(it) }),
        trait_ref: _visitor.fold_path(_i . trait_ref),
    }
}

pub fn fold_qself<V: Folder + ?Sized>(_visitor: &mut V, _i: QSelf) -> QSelf {
    QSelf {
        lt_token: _i . lt_token,
        ty: Box::new(_visitor.fold_ty(* _i . ty)),
        position: _i . position,
        as_token: _i . as_token,
        gt_token: _i . gt_token,
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_range_limits<V: Folder + ?Sized>(_visitor: &mut V, _i: RangeLimits) -> RangeLimits {
    use ::RangeLimits::*;
    match _i {
        HalfOpen(_binding_0, ) => {
            HalfOpen (
                _binding_0,
            )
        }
        Closed(_binding_0, ) => {
            Closed (
                _binding_0,
            )
        }
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_stmt<V: Folder + ?Sized>(_visitor: &mut V, _i: Stmt) -> Stmt {
    use ::Stmt::*;
    match _i {
        Local(_binding_0, ) => {
            Local (
                Box::new(_visitor.fold_local(* _binding_0)),
            )
        }
        Item(_binding_0, ) => {
            Item (
                Box::new(_visitor.fold_item(* _binding_0)),
            )
        }
        Expr(_binding_0, ) => {
            Expr (
                Box::new(_visitor.fold_expr(* _binding_0)),
            )
        }
        Semi(_binding_0, _binding_1, ) => {
            Semi (
                Box::new(_visitor.fold_expr(* _binding_0)),
                _binding_1,
            )
        }
        Mac(_binding_0, ) => {
            Mac (
                _binding_0,
            )
        }
    }
}

pub fn fold_trait_bound_modifier<V: Folder + ?Sized>(_visitor: &mut V, _i: TraitBoundModifier) -> TraitBoundModifier {
    use ::TraitBoundModifier::*;
    match _i {
        None => { None }
        Maybe(_binding_0, ) => {
            Maybe (
                _binding_0,
            )
        }
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_trait_item<V: Folder + ?Sized>(_visitor: &mut V, _i: TraitItem) -> TraitItem {
    TraitItem {
        attrs: FoldHelper::lift(_i . attrs, |it| { _visitor.fold_attribute(it) }),
        node: _visitor.fold_trait_item_kind(_i . node),
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_trait_item_const<V: Folder + ?Sized>(_visitor: &mut V, _i: TraitItemConst) -> TraitItemConst {
    TraitItemConst {
        const_token: _i . const_token,
        ident: _i . ident,
        colon_token: _i . colon_token,
        ty: _visitor.fold_ty(_i . ty),
        default: _i . default,
        semi_token: _i . semi_token,
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_trait_item_kind<V: Folder + ?Sized>(_visitor: &mut V, _i: TraitItemKind) -> TraitItemKind {
    use ::TraitItemKind::*;
    match _i {
        Const(_binding_0, ) => {
            Const (
                _visitor.fold_trait_item_const(_binding_0),
            )
        }
        Method(_binding_0, ) => {
            Method (
                _visitor.fold_trait_item_method(_binding_0),
            )
        }
        Type(_binding_0, ) => {
            Type (
                _visitor.fold_trait_item_type(_binding_0),
            )
        }
        Macro(_binding_0, ) => {
            Macro (
                _visitor.fold_mac(_binding_0),
            )
        }
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_trait_item_method<V: Folder + ?Sized>(_visitor: &mut V, _i: TraitItemMethod) -> TraitItemMethod {
    TraitItemMethod {
        sig: _visitor.fold_method_sig(_i . sig),
        default: (_i . default).map(|it| { _visitor.fold_block(it) }),
        semi_token: _i . semi_token,
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_trait_item_type<V: Folder + ?Sized>(_visitor: &mut V, _i: TraitItemType) -> TraitItemType {
    TraitItemType {
        type_token: _i . type_token,
        ident: _i . ident,
        colon_token: _i . colon_token,
        bounds: FoldHelper::lift(_i . bounds, |it| { _visitor.fold_ty_param_bound(it) }),
        default: _i . default,
        semi_token: _i . semi_token,
    }
}

pub fn fold_ty<V: Folder + ?Sized>(_visitor: &mut V, _i: Ty) -> Ty {
    use ::Ty::*;
    match _i {
        Slice(_binding_0, ) => {
            Slice (
                _visitor.fold_ty_slice(_binding_0),
            )
        }
        Array(_binding_0, ) => {
            Array (
                _visitor.fold_ty_array(_binding_0),
            )
        }
        Ptr(_binding_0, ) => {
            Ptr (
                _visitor.fold_ty_ptr(_binding_0),
            )
        }
        Rptr(_binding_0, ) => {
            Rptr (
                _visitor.fold_ty_rptr(_binding_0),
            )
        }
        BareFn(_binding_0, ) => {
            BareFn (
                _visitor.fold_ty_bare_fn(_binding_0),
            )
        }
        Never(_binding_0, ) => {
            Never (
                _visitor.fold_ty_never(_binding_0),
            )
        }
        Tup(_binding_0, ) => {
            Tup (
                _visitor.fold_ty_tup(_binding_0),
            )
        }
        Path(_binding_0, ) => {
            Path (
                _visitor.fold_ty_path(_binding_0),
            )
        }
        TraitObject(_binding_0, ) => {
            TraitObject (
                _visitor.fold_ty_trait_object(_binding_0),
            )
        }
        ImplTrait(_binding_0, ) => {
            ImplTrait (
                _visitor.fold_ty_impl_trait(_binding_0),
            )
        }
        Paren(_binding_0, ) => {
            Paren (
                _visitor.fold_ty_paren(_binding_0),
            )
        }
        Group(_binding_0, ) => {
            Group (
                _visitor.fold_ty_group(_binding_0),
            )
        }
        Infer(_binding_0, ) => {
            Infer (
                _visitor.fold_ty_infer(_binding_0),
            )
        }
        Mac(_binding_0, ) => {
            Mac (
                _visitor.fold_mac(_binding_0),
            )
        }
    }
}

pub fn fold_ty_array<V: Folder + ?Sized>(_visitor: &mut V, _i: TyArray) -> TyArray {
    TyArray {
        bracket_token: _i . bracket_token,
        ty: Box::new(_visitor.fold_ty(* _i . ty)),
        semi_token: _i . semi_token,
        amt: _visitor.fold_expr(_i . amt),
    }
}

pub fn fold_ty_bare_fn<V: Folder + ?Sized>(_visitor: &mut V, _i: TyBareFn) -> TyBareFn {
    TyBareFn {
        ty: Box::new(_visitor.fold_bare_fn_ty(* _i . ty)),
    }
}

pub fn fold_ty_group<V: Folder + ?Sized>(_visitor: &mut V, _i: TyGroup) -> TyGroup {
    TyGroup {
        group_token: _i . group_token,
        ty: Box::new(_visitor.fold_ty(* _i . ty)),
    }
}

pub fn fold_ty_impl_trait<V: Folder + ?Sized>(_visitor: &mut V, _i: TyImplTrait) -> TyImplTrait {
    TyImplTrait {
        impl_token: _i . impl_token,
        bounds: FoldHelper::lift(_i . bounds, |it| { _visitor.fold_ty_param_bound(it) }),
    }
}

pub fn fold_ty_infer<V: Folder + ?Sized>(_visitor: &mut V, _i: TyInfer) -> TyInfer {
    TyInfer {
        underscore_token: _i . underscore_token,
    }
}

pub fn fold_ty_never<V: Folder + ?Sized>(_visitor: &mut V, _i: TyNever) -> TyNever {
    TyNever {
        bang_token: _i . bang_token,
    }
}

pub fn fold_ty_param<V: Folder + ?Sized>(_visitor: &mut V, _i: TyParam) -> TyParam {
    TyParam {
        attrs: FoldHelper::lift(_i . attrs, |it| { _visitor.fold_attribute(it) }),
        ident: _i . ident,
        colon_token: _i . colon_token,
        bounds: FoldHelper::lift(_i . bounds, |it| { _visitor.fold_ty_param_bound(it) }),
        eq_token: _i . eq_token,
        default: (_i . default).map(|it| { _visitor.fold_ty(it) }),
    }
}

pub fn fold_ty_param_bound<V: Folder + ?Sized>(_visitor: &mut V, _i: TyParamBound) -> TyParamBound {
    use ::TyParamBound::*;
    match _i {
        Trait(_binding_0, _binding_1, ) => {
            Trait (
                _visitor.fold_poly_trait_ref(_binding_0),
                _visitor.fold_trait_bound_modifier(_binding_1),
            )
        }
        Region(_binding_0, ) => {
            Region (
                _binding_0,
            )
        }
    }
}

pub fn fold_ty_paren<V: Folder + ?Sized>(_visitor: &mut V, _i: TyParen) -> TyParen {
    TyParen {
        paren_token: _i . paren_token,
        ty: Box::new(_visitor.fold_ty(* _i . ty)),
    }
}

pub fn fold_ty_path<V: Folder + ?Sized>(_visitor: &mut V, _i: TyPath) -> TyPath {
    TyPath {
        qself: (_i . qself).map(|it| { _visitor.fold_qself(it) }),
        path: _visitor.fold_path(_i . path),
    }
}

pub fn fold_ty_ptr<V: Folder + ?Sized>(_visitor: &mut V, _i: TyPtr) -> TyPtr {
    TyPtr {
        star_token: _i . star_token,
        const_token: _i . const_token,
        ty: Box::new(_visitor.fold_mut_ty(* _i . ty)),
    }
}

pub fn fold_ty_rptr<V: Folder + ?Sized>(_visitor: &mut V, _i: TyRptr) -> TyRptr {
    TyRptr {
        and_token: _i . and_token,
        lifetime: _i . lifetime,
        ty: Box::new(_visitor.fold_mut_ty(* _i . ty)),
    }
}

pub fn fold_ty_slice<V: Folder + ?Sized>(_visitor: &mut V, _i: TySlice) -> TySlice {
    TySlice {
        ty: Box::new(_visitor.fold_ty(* _i . ty)),
        bracket_token: _i . bracket_token,
    }
}

pub fn fold_ty_trait_object<V: Folder + ?Sized>(_visitor: &mut V, _i: TyTraitObject) -> TyTraitObject {
    TyTraitObject {
        bounds: FoldHelper::lift(_i . bounds, |it| { _visitor.fold_ty_param_bound(it) }),
    }
}

pub fn fold_ty_tup<V: Folder + ?Sized>(_visitor: &mut V, _i: TyTup) -> TyTup {
    TyTup {
        paren_token: _i . paren_token,
        tys: FoldHelper::lift(_i . tys, |it| { _visitor.fold_ty(it) }),
        lone_comma: _i . lone_comma,
    }
}

pub fn fold_type_binding<V: Folder + ?Sized>(_visitor: &mut V, _i: TypeBinding) -> TypeBinding {
    TypeBinding {
        ident: _i . ident,
        eq_token: _i . eq_token,
        ty: _visitor.fold_ty(_i . ty),
    }
}

pub fn fold_un_op<V: Folder + ?Sized>(_visitor: &mut V, _i: UnOp) -> UnOp {
    use ::UnOp::*;
    match _i {
        Deref(_binding_0, ) => {
            Deref (
                _binding_0,
            )
        }
        Not(_binding_0, ) => {
            Not (
                _binding_0,
            )
        }
        Neg(_binding_0, ) => {
            Neg (
                _binding_0,
            )
        }
    }
}

pub fn fold_unsafety<V: Folder + ?Sized>(_visitor: &mut V, _i: Unsafety) -> Unsafety {
    use ::Unsafety::*;
    match _i {
        Unsafe(_binding_0, ) => {
            Unsafe (
                _binding_0,
            )
        }
        Normal => { Normal }
    }
}

pub fn fold_variant<V: Folder + ?Sized>(_visitor: &mut V, _i: Variant) -> Variant {
    Variant {
        ident: _i . ident,
        attrs: FoldHelper::lift(_i . attrs, |it| { _visitor.fold_attribute(it) }),
        data: _visitor.fold_variant_data(_i . data),
        discriminant: (_i . discriminant).map(|it| { _visitor.fold_expr(it) }),
        eq_token: _i . eq_token,
    }
}

pub fn fold_variant_data<V: Folder + ?Sized>(_visitor: &mut V, _i: VariantData) -> VariantData {
    use ::VariantData::*;
    match _i {
        Struct(_binding_0, _binding_1, ) => {
            Struct (
                FoldHelper::lift(_binding_0, |it| { _visitor.fold_field(it) }),
                _binding_1,
            )
        }
        Tuple(_binding_0, _binding_1, ) => {
            Tuple (
                FoldHelper::lift(_binding_0, |it| { _visitor.fold_field(it) }),
                _binding_1,
            )
        }
        Unit => { Unit }
    }
}
# [ cfg ( feature = "full" ) ]
pub fn fold_view_path<V: Folder + ?Sized>(_visitor: &mut V, _i: ViewPath) -> ViewPath {
    use ::ViewPath::*;
    match _i {
        Simple(_binding_0, ) => {
            Simple (
                _visitor.fold_path_simple(_binding_0),
            )
        }
        Glob(_binding_0, ) => {
            Glob (
                _visitor.fold_path_glob(_binding_0),
            )
        }
        List(_binding_0, ) => {
            List (
                _visitor.fold_path_list(_binding_0),
            )
        }
    }
}

pub fn fold_vis_crate<V: Folder + ?Sized>(_visitor: &mut V, _i: VisCrate) -> VisCrate {
    VisCrate {
        pub_token: _i . pub_token,
        paren_token: _i . paren_token,
        crate_token: _i . crate_token,
    }
}

pub fn fold_vis_inherited<V: Folder + ?Sized>(_visitor: &mut V, _i: VisInherited) -> VisInherited {
    VisInherited {
    }
}

pub fn fold_vis_public<V: Folder + ?Sized>(_visitor: &mut V, _i: VisPublic) -> VisPublic {
    VisPublic {
        pub_token: _i . pub_token,
    }
}

pub fn fold_vis_restricted<V: Folder + ?Sized>(_visitor: &mut V, _i: VisRestricted) -> VisRestricted {
    VisRestricted {
        pub_token: _i . pub_token,
        paren_token: _i . paren_token,
        in_token: _i . in_token,
        path: Box::new(_visitor.fold_path(* _i . path)),
    }
}

pub fn fold_visibility<V: Folder + ?Sized>(_visitor: &mut V, _i: Visibility) -> Visibility {
    use ::Visibility::*;
    match _i {
        Public(_binding_0, ) => {
            Public (
                _visitor.fold_vis_public(_binding_0),
            )
        }
        Crate(_binding_0, ) => {
            Crate (
                _visitor.fold_vis_crate(_binding_0),
            )
        }
        Restricted(_binding_0, ) => {
            Restricted (
                _visitor.fold_vis_restricted(_binding_0),
            )
        }
        Inherited(_binding_0, ) => {
            Inherited (
                _visitor.fold_vis_inherited(_binding_0),
            )
        }
    }
}

pub fn fold_where_bound_predicate<V: Folder + ?Sized>(_visitor: &mut V, _i: WhereBoundPredicate) -> WhereBoundPredicate {
    WhereBoundPredicate {
        bound_lifetimes: (_i . bound_lifetimes).map(|it| { _visitor.fold_bound_lifetimes(it) }),
        bounded_ty: _visitor.fold_ty(_i . bounded_ty),
        colon_token: _i . colon_token,
        bounds: FoldHelper::lift(_i . bounds, |it| { _visitor.fold_ty_param_bound(it) }),
    }
}

pub fn fold_where_clause<V: Folder + ?Sized>(_visitor: &mut V, _i: WhereClause) -> WhereClause {
    WhereClause {
        where_token: _i . where_token,
        predicates: FoldHelper::lift(_i . predicates, |it| { _visitor.fold_where_predicate(it) }),
    }
}

pub fn fold_where_eq_predicate<V: Folder + ?Sized>(_visitor: &mut V, _i: WhereEqPredicate) -> WhereEqPredicate {
    WhereEqPredicate {
        lhs_ty: _visitor.fold_ty(_i . lhs_ty),
        eq_token: _i . eq_token,
        rhs_ty: _visitor.fold_ty(_i . rhs_ty),
    }
}

pub fn fold_where_predicate<V: Folder + ?Sized>(_visitor: &mut V, _i: WherePredicate) -> WherePredicate {
    use ::WherePredicate::*;
    match _i {
        BoundPredicate(_binding_0, ) => {
            BoundPredicate (
                _visitor.fold_where_bound_predicate(_binding_0),
            )
        }
        RegionPredicate(_binding_0, ) => {
            RegionPredicate (
                _visitor.fold_where_region_predicate(_binding_0),
            )
        }
        EqPredicate(_binding_0, ) => {
            EqPredicate (
                _visitor.fold_where_eq_predicate(_binding_0),
            )
        }
    }
}

pub fn fold_where_region_predicate<V: Folder + ?Sized>(_visitor: &mut V, _i: WhereRegionPredicate) -> WhereRegionPredicate {
    WhereRegionPredicate {
        lifetime: _i . lifetime,
        colon_token: _i . colon_token,
        bounds: _i . bounds,
    }
}

