#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`, `\"Win32_System_Kernel\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn AddVectoredContinueHandler(first: u32, handler: PVECTORED_EXCEPTION_HANDLER) -> *mut ::core::ffi::c_void {
    ::windows::imp::link ! ( "kernel32.dll""system" fn AddVectoredContinueHandler ( first : u32 , handler : PVECTORED_EXCEPTION_HANDLER ) -> *mut ::core::ffi::c_void );
    AddVectoredContinueHandler(first, handler)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`, `\"Win32_System_Kernel\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn AddVectoredExceptionHandler(first: u32, handler: PVECTORED_EXCEPTION_HANDLER) -> *mut ::core::ffi::c_void {
    ::windows::imp::link ! ( "kernel32.dll""system" fn AddVectoredExceptionHandler ( first : u32 , handler : PVECTORED_EXCEPTION_HANDLER ) -> *mut ::core::ffi::c_void );
    AddVectoredExceptionHandler(first, handler)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn Beep(dwfreq: u32, dwduration: u32) -> super::super::super::Foundation::BOOL {
    ::windows::imp::link ! ( "kernel32.dll""system" fn Beep ( dwfreq : u32 , dwduration : u32 ) -> super::super::super::Foundation:: BOOL );
    Beep(dwfreq, dwduration)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BindImage<P0, P1, P2>(imagename: P0, dllpath: P1, symbolpath: P2) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P2: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "imagehlp.dll""system" fn BindImage ( imagename : :: windows::core::PCSTR , dllpath : :: windows::core::PCSTR , symbolpath : :: windows::core::PCSTR ) -> super::super::super::Foundation:: BOOL );
    BindImage(imagename.into_param().abi(), dllpath.into_param().abi(), symbolpath.into_param().abi())
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BindImageEx<P0, P1, P2>(flags: u32, imagename: P0, dllpath: P1, symbolpath: P2, statusroutine: PIMAGEHLP_STATUS_ROUTINE) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P2: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "imagehlp.dll""system" fn BindImageEx ( flags : u32 , imagename : :: windows::core::PCSTR , dllpath : :: windows::core::PCSTR , symbolpath : :: windows::core::PCSTR , statusroutine : PIMAGEHLP_STATUS_ROUTINE ) -> super::super::super::Foundation:: BOOL );
    BindImageEx(flags, imagename.into_param().abi(), dllpath.into_param().abi(), symbolpath.into_param().abi(), statusroutine)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CheckRemoteDebuggerPresent<P0>(hprocess: P0, pbdebuggerpresent: *mut super::super::super::Foundation::BOOL) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn CheckRemoteDebuggerPresent ( hprocess : super::super::super::Foundation:: HANDLE , pbdebuggerpresent : *mut super::super::super::Foundation:: BOOL ) -> super::super::super::Foundation:: BOOL );
    CheckRemoteDebuggerPresent(hprocess.into_param().abi(), pbdebuggerpresent)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_System_SystemInformation\"`*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_System_SystemInformation")]
#[inline]
pub unsafe fn CheckSumMappedFile(baseaddress: *const ::core::ffi::c_void, filelength: u32, headersum: *mut u32, checksum: *mut u32) -> *mut IMAGE_NT_HEADERS64 {
    ::windows::imp::link ! ( "imagehlp.dll""system" fn CheckSumMappedFile ( baseaddress : *const ::core::ffi::c_void , filelength : u32 , headersum : *mut u32 , checksum : *mut u32 ) -> *mut IMAGE_NT_HEADERS64 );
    CheckSumMappedFile(baseaddress, filelength, headersum, checksum)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_System_SystemInformation\"`*"]
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_System_SystemInformation")]
#[inline]
pub unsafe fn CheckSumMappedFile(baseaddress: *const ::core::ffi::c_void, filelength: u32, headersum: *mut u32, checksum: *mut u32) -> *mut IMAGE_NT_HEADERS32 {
    ::windows::imp::link ! ( "imagehlp.dll""system" fn CheckSumMappedFile ( baseaddress : *const ::core::ffi::c_void , filelength : u32 , headersum : *mut u32 , checksum : *mut u32 ) -> *mut IMAGE_NT_HEADERS32 );
    CheckSumMappedFile(baseaddress, filelength, headersum, checksum)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[inline]
pub unsafe fn CloseThreadWaitChainSession(wcthandle: *const ::core::ffi::c_void) {
    ::windows::imp::link ! ( "advapi32.dll""system" fn CloseThreadWaitChainSession ( wcthandle : *const ::core::ffi::c_void ) -> ( ) );
    CloseThreadWaitChainSession(wcthandle)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ContinueDebugEvent<P0>(dwprocessid: u32, dwthreadid: u32, dwcontinuestatus: P0) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::NTSTATUS>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn ContinueDebugEvent ( dwprocessid : u32 , dwthreadid : u32 , dwcontinuestatus : super::super::super::Foundation:: NTSTATUS ) -> super::super::super::Foundation:: BOOL );
    ContinueDebugEvent(dwprocessid, dwthreadid, dwcontinuestatus.into_param().abi())
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`, `\"Win32_System_Kernel\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn CopyContext(destination: *mut CONTEXT, contextflags: u32, source: *const CONTEXT) -> super::super::super::Foundation::BOOL {
    ::windows::imp::link ! ( "kernel32.dll""system" fn CopyContext ( destination : *mut CONTEXT , contextflags : u32 , source : *const CONTEXT ) -> super::super::super::Foundation:: BOOL );
    CopyContext(destination, contextflags, source)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[inline]
pub unsafe fn CreateDataModelManager<P0>(debughost: P0) -> ::windows::core::Result<IDataModelManager>
where
    P0: ::windows::core::IntoParam<IDebugHost>,
{
    ::windows::imp::link ! ( "dbgmodel.dll""system" fn CreateDataModelManager ( debughost : * mut::core::ffi::c_void , manager : *mut * mut::core::ffi::c_void ) -> :: windows::core::HRESULT );
    let mut result__ = ::windows::core::zeroed::<IDataModelManager>();
    CreateDataModelManager(debughost.into_param().abi(), &mut result__).from_abi(result__)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn DbgHelpCreateUserDump<P0>(filename: P0, callback: PDBGHELP_CREATE_USER_DUMP_CALLBACK, userdata: ::core::option::Option<*const ::core::ffi::c_void>) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn DbgHelpCreateUserDump ( filename : :: windows::core::PCSTR , callback : PDBGHELP_CREATE_USER_DUMP_CALLBACK , userdata : *const ::core::ffi::c_void ) -> super::super::super::Foundation:: BOOL );
    DbgHelpCreateUserDump(filename.into_param().abi(), callback, ::core::mem::transmute(userdata.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn DbgHelpCreateUserDumpW<P0>(filename: P0, callback: PDBGHELP_CREATE_USER_DUMP_CALLBACK, userdata: ::core::option::Option<*const ::core::ffi::c_void>) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn DbgHelpCreateUserDumpW ( filename : :: windows::core::PCWSTR , callback : PDBGHELP_CREATE_USER_DUMP_CALLBACK , userdata : *const ::core::ffi::c_void ) -> super::super::super::Foundation:: BOOL );
    DbgHelpCreateUserDumpW(filename.into_param().abi(), callback, ::core::mem::transmute(userdata.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn DebugActiveProcess(dwprocessid: u32) -> super::super::super::Foundation::BOOL {
    ::windows::imp::link ! ( "kernel32.dll""system" fn DebugActiveProcess ( dwprocessid : u32 ) -> super::super::super::Foundation:: BOOL );
    DebugActiveProcess(dwprocessid)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn DebugActiveProcessStop(dwprocessid: u32) -> super::super::super::Foundation::BOOL {
    ::windows::imp::link ! ( "kernel32.dll""system" fn DebugActiveProcessStop ( dwprocessid : u32 ) -> super::super::super::Foundation:: BOOL );
    DebugActiveProcessStop(dwprocessid)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[inline]
pub unsafe fn DebugBreak() {
    ::windows::imp::link ! ( "kernel32.dll""system" fn DebugBreak ( ) -> ( ) );
    DebugBreak()
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn DebugBreakProcess<P0>(process: P0) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn DebugBreakProcess ( process : super::super::super::Foundation:: HANDLE ) -> super::super::super::Foundation:: BOOL );
    DebugBreakProcess(process.into_param().abi())
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[inline]
pub unsafe fn DebugConnect<P0>(remoteoptions: P0, interfaceid: *const ::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::Result<()>
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "dbgeng.dll""system" fn DebugConnect ( remoteoptions : :: windows::core::PCSTR , interfaceid : *const :: windows::core::GUID , interface : *mut *mut ::core::ffi::c_void ) -> :: windows::core::HRESULT );
    DebugConnect(remoteoptions.into_param().abi(), interfaceid, interface).ok()
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[inline]
pub unsafe fn DebugConnectWide<P0>(remoteoptions: P0, interfaceid: *const ::windows::core::GUID, interface: *mut *mut ::core::ffi::c_void) -> ::windows::core::Result<()>
where
    P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "dbgeng.dll""system" fn DebugConnectWide ( remoteoptions : :: windows::core::PCWSTR , interfaceid : *const :: windows::core::GUID , interface : *mut *mut ::core::ffi::c_void ) -> :: windows::core::HRESULT );
    DebugConnectWide(remoteoptions.into_param().abi(), interfaceid, interface).ok()
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[inline]
pub unsafe fn DebugCreate<T>() -> ::windows::core::Result<T>
where
    T: ::windows::core::ComInterface,
{
    ::windows::imp::link ! ( "dbgeng.dll""system" fn DebugCreate ( interfaceid : *const :: windows::core::GUID , interface : *mut *mut ::core::ffi::c_void ) -> :: windows::core::HRESULT );
    let mut result__ = ::std::ptr::null_mut();
    DebugCreate(&<T as ::windows::core::ComInterface>::IID, &mut result__).from_abi(result__)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[inline]
pub unsafe fn DebugCreateEx<T>(dbgengoptions: u32) -> ::windows::core::Result<T>
where
    T: ::windows::core::ComInterface,
{
    ::windows::imp::link ! ( "dbgeng.dll""system" fn DebugCreateEx ( interfaceid : *const :: windows::core::GUID , dbgengoptions : u32 , interface : *mut *mut ::core::ffi::c_void ) -> :: windows::core::HRESULT );
    let mut result__ = ::std::ptr::null_mut();
    DebugCreateEx(&<T as ::windows::core::ComInterface>::IID, dbgengoptions, &mut result__).from_abi(result__)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn DebugSetProcessKillOnExit<P0>(killonexit: P0) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::BOOL>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn DebugSetProcessKillOnExit ( killonexit : super::super::super::Foundation:: BOOL ) -> super::super::super::Foundation:: BOOL );
    DebugSetProcessKillOnExit(killonexit.into_param().abi())
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[inline]
pub unsafe fn DecodePointer(ptr: ::core::option::Option<*const ::core::ffi::c_void>) -> *mut ::core::ffi::c_void {
    ::windows::imp::link ! ( "kernel32.dll""system" fn DecodePointer ( ptr : *const ::core::ffi::c_void ) -> *mut ::core::ffi::c_void );
    DecodePointer(::core::mem::transmute(ptr.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn DecodeRemotePointer<P0>(processhandle: P0, ptr: ::core::option::Option<*const ::core::ffi::c_void>, decodedptr: *mut *mut ::core::ffi::c_void) -> ::windows::core::Result<()>
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "api-ms-win-core-util-l1-1-1.dll""system" fn DecodeRemotePointer ( processhandle : super::super::super::Foundation:: HANDLE , ptr : *const ::core::ffi::c_void , decodedptr : *mut *mut ::core::ffi::c_void ) -> :: windows::core::HRESULT );
    DecodeRemotePointer(processhandle.into_param().abi(), ::core::mem::transmute(ptr.unwrap_or(::std::ptr::null())), decodedptr).ok()
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[inline]
pub unsafe fn DecodeSystemPointer(ptr: ::core::option::Option<*const ::core::ffi::c_void>) -> *mut ::core::ffi::c_void {
    ::windows::imp::link ! ( "kernel32.dll""system" fn DecodeSystemPointer ( ptr : *const ::core::ffi::c_void ) -> *mut ::core::ffi::c_void );
    DecodeSystemPointer(::core::mem::transmute(ptr.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[inline]
pub unsafe fn EncodePointer(ptr: ::core::option::Option<*const ::core::ffi::c_void>) -> *mut ::core::ffi::c_void {
    ::windows::imp::link ! ( "kernel32.dll""system" fn EncodePointer ( ptr : *const ::core::ffi::c_void ) -> *mut ::core::ffi::c_void );
    EncodePointer(::core::mem::transmute(ptr.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn EncodeRemotePointer<P0>(processhandle: P0, ptr: ::core::option::Option<*const ::core::ffi::c_void>, encodedptr: *mut *mut ::core::ffi::c_void) -> ::windows::core::Result<()>
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "api-ms-win-core-util-l1-1-1.dll""system" fn EncodeRemotePointer ( processhandle : super::super::super::Foundation:: HANDLE , ptr : *const ::core::ffi::c_void , encodedptr : *mut *mut ::core::ffi::c_void ) -> :: windows::core::HRESULT );
    EncodeRemotePointer(processhandle.into_param().abi(), ::core::mem::transmute(ptr.unwrap_or(::std::ptr::null())), encodedptr).ok()
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[inline]
pub unsafe fn EncodeSystemPointer(ptr: ::core::option::Option<*const ::core::ffi::c_void>) -> *mut ::core::ffi::c_void {
    ::windows::imp::link ! ( "kernel32.dll""system" fn EncodeSystemPointer ( ptr : *const ::core::ffi::c_void ) -> *mut ::core::ffi::c_void );
    EncodeSystemPointer(::core::mem::transmute(ptr.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn EnumDirTree<P0, P1, P2>(hprocess: P0, rootpath: P1, inputpathname: P2, outputpathbuffer: ::windows::core::PSTR, cb: PENUMDIRTREE_CALLBACK, data: ::core::option::Option<*const ::core::ffi::c_void>) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P2: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn EnumDirTree ( hprocess : super::super::super::Foundation:: HANDLE , rootpath : :: windows::core::PCSTR , inputpathname : :: windows::core::PCSTR , outputpathbuffer : :: windows::core::PSTR , cb : PENUMDIRTREE_CALLBACK , data : *const ::core::ffi::c_void ) -> super::super::super::Foundation:: BOOL );
    EnumDirTree(hprocess.into_param().abi(), rootpath.into_param().abi(), inputpathname.into_param().abi(), ::core::mem::transmute(outputpathbuffer), cb, ::core::mem::transmute(data.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn EnumDirTreeW<P0, P1, P2>(hprocess: P0, rootpath: P1, inputpathname: P2, outputpathbuffer: ::windows::core::PWSTR, cb: PENUMDIRTREE_CALLBACKW, data: ::core::option::Option<*const ::core::ffi::c_void>) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    P2: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn EnumDirTreeW ( hprocess : super::super::super::Foundation:: HANDLE , rootpath : :: windows::core::PCWSTR , inputpathname : :: windows::core::PCWSTR , outputpathbuffer : :: windows::core::PWSTR , cb : PENUMDIRTREE_CALLBACKW , data : *const ::core::ffi::c_void ) -> super::super::super::Foundation:: BOOL );
    EnumDirTreeW(hprocess.into_param().abi(), rootpath.into_param().abi(), inputpathname.into_param().abi(), ::core::mem::transmute(outputpathbuffer), cb, ::core::mem::transmute(data.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn EnumerateLoadedModules<P0>(hprocess: P0, enumloadedmodulescallback: PENUMLOADED_MODULES_CALLBACK, usercontext: ::core::option::Option<*const ::core::ffi::c_void>) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn EnumerateLoadedModules ( hprocess : super::super::super::Foundation:: HANDLE , enumloadedmodulescallback : PENUMLOADED_MODULES_CALLBACK , usercontext : *const ::core::ffi::c_void ) -> super::super::super::Foundation:: BOOL );
    EnumerateLoadedModules(hprocess.into_param().abi(), enumloadedmodulescallback, ::core::mem::transmute(usercontext.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn EnumerateLoadedModules64<P0>(hprocess: P0, enumloadedmodulescallback: PENUMLOADED_MODULES_CALLBACK64, usercontext: ::core::option::Option<*const ::core::ffi::c_void>) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn EnumerateLoadedModules64 ( hprocess : super::super::super::Foundation:: HANDLE , enumloadedmodulescallback : PENUMLOADED_MODULES_CALLBACK64 , usercontext : *const ::core::ffi::c_void ) -> super::super::super::Foundation:: BOOL );
    EnumerateLoadedModules64(hprocess.into_param().abi(), enumloadedmodulescallback, ::core::mem::transmute(usercontext.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn EnumerateLoadedModulesEx<P0>(hprocess: P0, enumloadedmodulescallback: PENUMLOADED_MODULES_CALLBACK64, usercontext: ::core::option::Option<*const ::core::ffi::c_void>) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn EnumerateLoadedModulesEx ( hprocess : super::super::super::Foundation:: HANDLE , enumloadedmodulescallback : PENUMLOADED_MODULES_CALLBACK64 , usercontext : *const ::core::ffi::c_void ) -> super::super::super::Foundation:: BOOL );
    EnumerateLoadedModulesEx(hprocess.into_param().abi(), enumloadedmodulescallback, ::core::mem::transmute(usercontext.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn EnumerateLoadedModulesExW<P0>(hprocess: P0, enumloadedmodulescallback: PENUMLOADED_MODULES_CALLBACKW64, usercontext: ::core::option::Option<*const ::core::ffi::c_void>) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn EnumerateLoadedModulesExW ( hprocess : super::super::super::Foundation:: HANDLE , enumloadedmodulescallback : PENUMLOADED_MODULES_CALLBACKW64 , usercontext : *const ::core::ffi::c_void ) -> super::super::super::Foundation:: BOOL );
    EnumerateLoadedModulesExW(hprocess.into_param().abi(), enumloadedmodulescallback, ::core::mem::transmute(usercontext.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn EnumerateLoadedModulesW64<P0>(hprocess: P0, enumloadedmodulescallback: PENUMLOADED_MODULES_CALLBACKW64, usercontext: ::core::option::Option<*const ::core::ffi::c_void>) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn EnumerateLoadedModulesW64 ( hprocess : super::super::super::Foundation:: HANDLE , enumloadedmodulescallback : PENUMLOADED_MODULES_CALLBACKW64 , usercontext : *const ::core::ffi::c_void ) -> super::super::super::Foundation:: BOOL );
    EnumerateLoadedModulesW64(hprocess.into_param().abi(), enumloadedmodulescallback, ::core::mem::transmute(usercontext.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[inline]
pub unsafe fn FatalAppExitA<P0>(uaction: u32, lpmessagetext: P0)
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn FatalAppExitA ( uaction : u32 , lpmessagetext : :: windows::core::PCSTR ) -> ( ) );
    FatalAppExitA(uaction, lpmessagetext.into_param().abi())
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[inline]
pub unsafe fn FatalAppExitW<P0>(uaction: u32, lpmessagetext: P0)
where
    P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn FatalAppExitW ( uaction : u32 , lpmessagetext : :: windows::core::PCWSTR ) -> ( ) );
    FatalAppExitW(uaction, lpmessagetext.into_param().abi())
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[inline]
pub unsafe fn FatalExit(exitcode: i32) -> ! {
    ::windows::imp::link ! ( "kernel32.dll""system" fn FatalExit ( exitcode : i32 ) -> ! );
    FatalExit(exitcode)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn FindDebugInfoFile<P0, P1>(filename: P0, symbolpath: P1, debugfilepath: ::windows::core::PSTR) -> ::windows::core::Result<super::super::super::Foundation::HANDLE>
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn FindDebugInfoFile ( filename : :: windows::core::PCSTR , symbolpath : :: windows::core::PCSTR , debugfilepath : :: windows::core::PSTR ) -> super::super::super::Foundation:: HANDLE );
    let result__ = FindDebugInfoFile(filename.into_param().abi(), symbolpath.into_param().abi(), ::core::mem::transmute(debugfilepath));
    ::windows::imp::then(!result__.is_invalid(), || result__).ok_or_else(::windows::core::Error::from_win32)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn FindDebugInfoFileEx<P0, P1>(filename: P0, symbolpath: P1, debugfilepath: ::windows::core::PSTR, callback: PFIND_DEBUG_FILE_CALLBACK, callerdata: ::core::option::Option<*const ::core::ffi::c_void>) -> ::windows::core::Result<super::super::super::Foundation::HANDLE>
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn FindDebugInfoFileEx ( filename : :: windows::core::PCSTR , symbolpath : :: windows::core::PCSTR , debugfilepath : :: windows::core::PSTR , callback : PFIND_DEBUG_FILE_CALLBACK , callerdata : *const ::core::ffi::c_void ) -> super::super::super::Foundation:: HANDLE );
    let result__ = FindDebugInfoFileEx(filename.into_param().abi(), symbolpath.into_param().abi(), ::core::mem::transmute(debugfilepath), callback, ::core::mem::transmute(callerdata.unwrap_or(::std::ptr::null())));
    ::windows::imp::then(!result__.is_invalid(), || result__).ok_or_else(::windows::core::Error::from_win32)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn FindDebugInfoFileExW<P0, P1>(filename: P0, symbolpath: P1, debugfilepath: ::windows::core::PWSTR, callback: PFIND_DEBUG_FILE_CALLBACKW, callerdata: ::core::option::Option<*const ::core::ffi::c_void>) -> ::windows::core::Result<super::super::super::Foundation::HANDLE>
where
    P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn FindDebugInfoFileExW ( filename : :: windows::core::PCWSTR , symbolpath : :: windows::core::PCWSTR , debugfilepath : :: windows::core::PWSTR , callback : PFIND_DEBUG_FILE_CALLBACKW , callerdata : *const ::core::ffi::c_void ) -> super::super::super::Foundation:: HANDLE );
    let result__ = FindDebugInfoFileExW(filename.into_param().abi(), symbolpath.into_param().abi(), ::core::mem::transmute(debugfilepath), callback, ::core::mem::transmute(callerdata.unwrap_or(::std::ptr::null())));
    ::windows::imp::then(!result__.is_invalid(), || result__).ok_or_else(::windows::core::Error::from_win32)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn FindExecutableImage<P0, P1>(filename: P0, symbolpath: P1, imagefilepath: ::windows::core::PSTR) -> ::windows::core::Result<super::super::super::Foundation::HANDLE>
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn FindExecutableImage ( filename : :: windows::core::PCSTR , symbolpath : :: windows::core::PCSTR , imagefilepath : :: windows::core::PSTR ) -> super::super::super::Foundation:: HANDLE );
    let result__ = FindExecutableImage(filename.into_param().abi(), symbolpath.into_param().abi(), ::core::mem::transmute(imagefilepath));
    ::windows::imp::then(!result__.is_invalid(), || result__).ok_or_else(::windows::core::Error::from_win32)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn FindExecutableImageEx<P0, P1>(filename: P0, symbolpath: P1, imagefilepath: ::windows::core::PSTR, callback: PFIND_EXE_FILE_CALLBACK, callerdata: ::core::option::Option<*const ::core::ffi::c_void>) -> ::windows::core::Result<super::super::super::Foundation::HANDLE>
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn FindExecutableImageEx ( filename : :: windows::core::PCSTR , symbolpath : :: windows::core::PCSTR , imagefilepath : :: windows::core::PSTR , callback : PFIND_EXE_FILE_CALLBACK , callerdata : *const ::core::ffi::c_void ) -> super::super::super::Foundation:: HANDLE );
    let result__ = FindExecutableImageEx(filename.into_param().abi(), symbolpath.into_param().abi(), ::core::mem::transmute(imagefilepath), callback, ::core::mem::transmute(callerdata.unwrap_or(::std::ptr::null())));
    ::windows::imp::then(!result__.is_invalid(), || result__).ok_or_else(::windows::core::Error::from_win32)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn FindExecutableImageExW<P0, P1>(filename: P0, symbolpath: P1, imagefilepath: ::windows::core::PWSTR, callback: PFIND_EXE_FILE_CALLBACKW, callerdata: *const ::core::ffi::c_void) -> ::windows::core::Result<super::super::super::Foundation::HANDLE>
where
    P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn FindExecutableImageExW ( filename : :: windows::core::PCWSTR , symbolpath : :: windows::core::PCWSTR , imagefilepath : :: windows::core::PWSTR , callback : PFIND_EXE_FILE_CALLBACKW , callerdata : *const ::core::ffi::c_void ) -> super::super::super::Foundation:: HANDLE );
    let result__ = FindExecutableImageExW(filename.into_param().abi(), symbolpath.into_param().abi(), ::core::mem::transmute(imagefilepath), callback, callerdata);
    ::windows::imp::then(!result__.is_invalid(), || result__).ok_or_else(::windows::core::Error::from_win32)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn FindFileInPath<P0, P1, P2>(hprocess: P0, searchpatha: P1, filename: P2, id: *const ::core::ffi::c_void, two: u32, three: u32, flags: u32, filepath: ::windows::core::PSTR) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P2: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn FindFileInPath ( hprocess : super::super::super::Foundation:: HANDLE , searchpatha : :: windows::core::PCSTR , filename : :: windows::core::PCSTR , id : *const ::core::ffi::c_void , two : u32 , three : u32 , flags : u32 , filepath : :: windows::core::PSTR ) -> super::super::super::Foundation:: BOOL );
    FindFileInPath(hprocess.into_param().abi(), searchpatha.into_param().abi(), filename.into_param().abi(), id, two, three, flags, ::core::mem::transmute(filepath))
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn FindFileInSearchPath<P0, P1, P2>(hprocess: P0, searchpatha: P1, filename: P2, one: u32, two: u32, three: u32, filepath: ::windows::core::PSTR) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P2: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn FindFileInSearchPath ( hprocess : super::super::super::Foundation:: HANDLE , searchpatha : :: windows::core::PCSTR , filename : :: windows::core::PCSTR , one : u32 , two : u32 , three : u32 , filepath : :: windows::core::PSTR ) -> super::super::super::Foundation:: BOOL );
    FindFileInSearchPath(hprocess.into_param().abi(), searchpatha.into_param().abi(), filename.into_param().abi(), one, two, three, ::core::mem::transmute(filepath))
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn FlushInstructionCache<P0>(hprocess: P0, lpbaseaddress: ::core::option::Option<*const ::core::ffi::c_void>, dwsize: usize) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn FlushInstructionCache ( hprocess : super::super::super::Foundation:: HANDLE , lpbaseaddress : *const ::core::ffi::c_void , dwsize : usize ) -> super::super::super::Foundation:: BOOL );
    FlushInstructionCache(hprocess.into_param().abi(), ::core::mem::transmute(lpbaseaddress.unwrap_or(::std::ptr::null())), dwsize)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[inline]
pub unsafe fn FormatMessageA(dwflags: FORMAT_MESSAGE_OPTIONS, lpsource: ::core::option::Option<*const ::core::ffi::c_void>, dwmessageid: u32, dwlanguageid: u32, lpbuffer: ::windows::core::PSTR, nsize: u32, arguments: ::core::option::Option<*const *const i8>) -> u32 {
    ::windows::imp::link ! ( "kernel32.dll""system" fn FormatMessageA ( dwflags : FORMAT_MESSAGE_OPTIONS , lpsource : *const ::core::ffi::c_void , dwmessageid : u32 , dwlanguageid : u32 , lpbuffer : :: windows::core::PSTR , nsize : u32 , arguments : *const *const i8 ) -> u32 );
    FormatMessageA(dwflags, ::core::mem::transmute(lpsource.unwrap_or(::std::ptr::null())), dwmessageid, dwlanguageid, ::core::mem::transmute(lpbuffer), nsize, ::core::mem::transmute(arguments.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[inline]
pub unsafe fn FormatMessageW(dwflags: FORMAT_MESSAGE_OPTIONS, lpsource: ::core::option::Option<*const ::core::ffi::c_void>, dwmessageid: u32, dwlanguageid: u32, lpbuffer: ::windows::core::PWSTR, nsize: u32, arguments: ::core::option::Option<*const *const i8>) -> u32 {
    ::windows::imp::link ! ( "kernel32.dll""system" fn FormatMessageW ( dwflags : FORMAT_MESSAGE_OPTIONS , lpsource : *const ::core::ffi::c_void , dwmessageid : u32 , dwlanguageid : u32 , lpbuffer : :: windows::core::PWSTR , nsize : u32 , arguments : *const *const i8 ) -> u32 );
    FormatMessageW(dwflags, ::core::mem::transmute(lpsource.unwrap_or(::std::ptr::null())), dwmessageid, dwlanguageid, ::core::mem::transmute(lpbuffer), nsize, ::core::mem::transmute(arguments.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[cfg(any(target_arch = "x86", target_arch = "x86_64"))]
#[inline]
pub unsafe fn GetEnabledXStateFeatures() -> u64 {
    ::windows::imp::link ! ( "kernel32.dll""system" fn GetEnabledXStateFeatures ( ) -> u64 );
    GetEnabledXStateFeatures()
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[inline]
pub unsafe fn GetErrorMode() -> u32 {
    ::windows::imp::link ! ( "kernel32.dll""system" fn GetErrorMode ( ) -> u32 );
    GetErrorMode()
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`, `\"Win32_System_Kernel\"`, `\"Win32_System_SystemInformation\"`*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Kernel", feature = "Win32_System_SystemInformation"))]
#[inline]
pub unsafe fn GetImageConfigInformation(loadedimage: *const LOADED_IMAGE, imageconfiginformation: *mut IMAGE_LOAD_CONFIG_DIRECTORY64) -> super::super::super::Foundation::BOOL {
    ::windows::imp::link ! ( "imagehlp.dll""system" fn GetImageConfigInformation ( loadedimage : *const LOADED_IMAGE , imageconfiginformation : *mut IMAGE_LOAD_CONFIG_DIRECTORY64 ) -> super::super::super::Foundation:: BOOL );
    GetImageConfigInformation(loadedimage, imageconfiginformation)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`, `\"Win32_System_Kernel\"`, `\"Win32_System_SystemInformation\"`*"]
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Kernel", feature = "Win32_System_SystemInformation"))]
#[inline]
pub unsafe fn GetImageConfigInformation(loadedimage: *const LOADED_IMAGE, imageconfiginformation: *mut IMAGE_LOAD_CONFIG_DIRECTORY32) -> super::super::super::Foundation::BOOL {
    ::windows::imp::link ! ( "imagehlp.dll""system" fn GetImageConfigInformation ( loadedimage : *const LOADED_IMAGE , imageconfiginformation : *mut IMAGE_LOAD_CONFIG_DIRECTORY32 ) -> super::super::super::Foundation:: BOOL );
    GetImageConfigInformation(loadedimage, imageconfiginformation)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`, `\"Win32_System_Kernel\"`, `\"Win32_System_SystemInformation\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Kernel", feature = "Win32_System_SystemInformation"))]
#[inline]
pub unsafe fn GetImageUnusedHeaderBytes(loadedimage: *const LOADED_IMAGE, sizeunusedheaderbytes: *mut u32) -> u32 {
    ::windows::imp::link ! ( "imagehlp.dll""system" fn GetImageUnusedHeaderBytes ( loadedimage : *const LOADED_IMAGE , sizeunusedheaderbytes : *mut u32 ) -> u32 );
    GetImageUnusedHeaderBytes(loadedimage, sizeunusedheaderbytes)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[inline]
pub unsafe fn GetSymLoadError() -> u32 {
    ::windows::imp::link ! ( "dbghelp.dll""system" fn GetSymLoadError ( ) -> u32 );
    GetSymLoadError()
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`, `\"Win32_System_Kernel\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn GetThreadContext<P0>(hthread: P0, lpcontext: *mut CONTEXT) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn GetThreadContext ( hthread : super::super::super::Foundation:: HANDLE , lpcontext : *mut CONTEXT ) -> super::super::super::Foundation:: BOOL );
    GetThreadContext(hthread.into_param().abi(), lpcontext)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[inline]
pub unsafe fn GetThreadErrorMode() -> u32 {
    ::windows::imp::link ! ( "kernel32.dll""system" fn GetThreadErrorMode ( ) -> u32 );
    GetThreadErrorMode()
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetThreadSelectorEntry<P0>(hthread: P0, dwselector: u32, lpselectorentry: *mut LDT_ENTRY) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn GetThreadSelectorEntry ( hthread : super::super::super::Foundation:: HANDLE , dwselector : u32 , lpselectorentry : *mut LDT_ENTRY ) -> super::super::super::Foundation:: BOOL );
    GetThreadSelectorEntry(hthread.into_param().abi(), dwselector, lpselectorentry)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetThreadWaitChain(wcthandle: *const ::core::ffi::c_void, context: usize, flags: WAIT_CHAIN_THREAD_OPTIONS, threadid: u32, nodecount: *mut u32, nodeinfoarray: *mut WAITCHAIN_NODE_INFO, iscycle: *mut i32) -> super::super::super::Foundation::BOOL {
    ::windows::imp::link ! ( "advapi32.dll""system" fn GetThreadWaitChain ( wcthandle : *const ::core::ffi::c_void , context : usize , flags : WAIT_CHAIN_THREAD_OPTIONS , threadid : u32 , nodecount : *mut u32 , nodeinfoarray : *mut WAITCHAIN_NODE_INFO , iscycle : *mut i32 ) -> super::super::super::Foundation:: BOOL );
    GetThreadWaitChain(wcthandle, context, flags, threadid, nodecount, nodeinfoarray, iscycle)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetTimestampForLoadedLibrary<P0>(module: P0) -> u32
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HINSTANCE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn GetTimestampForLoadedLibrary ( module : super::super::super::Foundation:: HINSTANCE ) -> u32 );
    GetTimestampForLoadedLibrary(module.into_param().abi())
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`, `\"Win32_System_Kernel\"`*"]
#[cfg(any(target_arch = "x86", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn GetXStateFeaturesMask(context: *const CONTEXT, featuremask: *mut u64) -> super::super::super::Foundation::BOOL {
    ::windows::imp::link ! ( "kernel32.dll""system" fn GetXStateFeaturesMask ( context : *const CONTEXT , featuremask : *mut u64 ) -> super::super::super::Foundation:: BOOL );
    GetXStateFeaturesMask(context, featuremask)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`, `\"Win32_Security_WinTrust\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Security_WinTrust"))]
#[inline]
pub unsafe fn ImageAddCertificate<P0>(filehandle: P0, certificate: *const super::super::super::Security::WinTrust::WIN_CERTIFICATE, index: *mut u32) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "imagehlp.dll""system" fn ImageAddCertificate ( filehandle : super::super::super::Foundation:: HANDLE , certificate : *const super::super::super::Security::WinTrust:: WIN_CERTIFICATE , index : *mut u32 ) -> super::super::super::Foundation:: BOOL );
    ImageAddCertificate(filehandle.into_param().abi(), certificate, index)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ImageDirectoryEntryToData<P0>(base: *const ::core::ffi::c_void, mappedasimage: P0, directoryentry: IMAGE_DIRECTORY_ENTRY, size: *mut u32) -> *mut ::core::ffi::c_void
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::BOOLEAN>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn ImageDirectoryEntryToData ( base : *const ::core::ffi::c_void , mappedasimage : super::super::super::Foundation:: BOOLEAN , directoryentry : IMAGE_DIRECTORY_ENTRY , size : *mut u32 ) -> *mut ::core::ffi::c_void );
    ImageDirectoryEntryToData(base, mappedasimage.into_param().abi(), directoryentry, size)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ImageDirectoryEntryToDataEx<P0>(base: *const ::core::ffi::c_void, mappedasimage: P0, directoryentry: IMAGE_DIRECTORY_ENTRY, size: *mut u32, foundheader: ::core::option::Option<*mut *mut IMAGE_SECTION_HEADER>) -> *mut ::core::ffi::c_void
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::BOOLEAN>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn ImageDirectoryEntryToDataEx ( base : *const ::core::ffi::c_void , mappedasimage : super::super::super::Foundation:: BOOLEAN , directoryentry : IMAGE_DIRECTORY_ENTRY , size : *mut u32 , foundheader : *mut *mut IMAGE_SECTION_HEADER ) -> *mut ::core::ffi::c_void );
    ImageDirectoryEntryToDataEx(base, mappedasimage.into_param().abi(), directoryentry, size, ::core::mem::transmute(foundheader.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ImageEnumerateCertificates<P0>(filehandle: P0, typefilter: u16, certificatecount: *mut u32, indices: ::core::option::Option<&mut [u32]>) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "imagehlp.dll""system" fn ImageEnumerateCertificates ( filehandle : super::super::super::Foundation:: HANDLE , typefilter : u16 , certificatecount : *mut u32 , indices : *mut u32 , indexcount : u32 ) -> super::super::super::Foundation:: BOOL );
    ImageEnumerateCertificates(filehandle.into_param().abi(), typefilter, certificatecount, ::core::mem::transmute(indices.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), indices.as_deref().map_or(0, |slice| slice.len() as _))
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`, `\"Win32_Security_WinTrust\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Security_WinTrust"))]
#[inline]
pub unsafe fn ImageGetCertificateData<P0>(filehandle: P0, certificateindex: u32, certificate: *mut super::super::super::Security::WinTrust::WIN_CERTIFICATE, requiredlength: *mut u32) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "imagehlp.dll""system" fn ImageGetCertificateData ( filehandle : super::super::super::Foundation:: HANDLE , certificateindex : u32 , certificate : *mut super::super::super::Security::WinTrust:: WIN_CERTIFICATE , requiredlength : *mut u32 ) -> super::super::super::Foundation:: BOOL );
    ImageGetCertificateData(filehandle.into_param().abi(), certificateindex, certificate, requiredlength)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`, `\"Win32_Security_WinTrust\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Security_WinTrust"))]
#[inline]
pub unsafe fn ImageGetCertificateHeader<P0>(filehandle: P0, certificateindex: u32, certificateheader: *mut super::super::super::Security::WinTrust::WIN_CERTIFICATE) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "imagehlp.dll""system" fn ImageGetCertificateHeader ( filehandle : super::super::super::Foundation:: HANDLE , certificateindex : u32 , certificateheader : *mut super::super::super::Security::WinTrust:: WIN_CERTIFICATE ) -> super::super::super::Foundation:: BOOL );
    ImageGetCertificateHeader(filehandle.into_param().abi(), certificateindex, certificateheader)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ImageGetDigestStream<P0>(filehandle: P0, digestlevel: u32, digestfunction: DIGEST_FUNCTION, digesthandle: *const ::core::ffi::c_void) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "imagehlp.dll""system" fn ImageGetDigestStream ( filehandle : super::super::super::Foundation:: HANDLE , digestlevel : u32 , digestfunction : DIGEST_FUNCTION , digesthandle : *const ::core::ffi::c_void ) -> super::super::super::Foundation:: BOOL );
    ImageGetDigestStream(filehandle.into_param().abi(), digestlevel, digestfunction, digesthandle)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`, `\"Win32_System_Kernel\"`, `\"Win32_System_SystemInformation\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Kernel", feature = "Win32_System_SystemInformation"))]
#[inline]
pub unsafe fn ImageLoad<P0, P1>(dllname: P0, dllpath: P1) -> *mut LOADED_IMAGE
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "imagehlp.dll""system" fn ImageLoad ( dllname : :: windows::core::PCSTR , dllpath : :: windows::core::PCSTR ) -> *mut LOADED_IMAGE );
    ImageLoad(dllname.into_param().abi(), dllpath.into_param().abi())
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_System_SystemInformation\"`*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_System_SystemInformation")]
#[inline]
pub unsafe fn ImageNtHeader(base: *const ::core::ffi::c_void) -> *mut IMAGE_NT_HEADERS64 {
    ::windows::imp::link ! ( "dbghelp.dll""system" fn ImageNtHeader ( base : *const ::core::ffi::c_void ) -> *mut IMAGE_NT_HEADERS64 );
    ImageNtHeader(base)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_System_SystemInformation\"`*"]
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_System_SystemInformation")]
#[inline]
pub unsafe fn ImageNtHeader(base: *const ::core::ffi::c_void) -> *mut IMAGE_NT_HEADERS32 {
    ::windows::imp::link ! ( "dbghelp.dll""system" fn ImageNtHeader ( base : *const ::core::ffi::c_void ) -> *mut IMAGE_NT_HEADERS32 );
    ImageNtHeader(base)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ImageRemoveCertificate<P0>(filehandle: P0, index: u32) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "imagehlp.dll""system" fn ImageRemoveCertificate ( filehandle : super::super::super::Foundation:: HANDLE , index : u32 ) -> super::super::super::Foundation:: BOOL );
    ImageRemoveCertificate(filehandle.into_param().abi(), index)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_System_SystemInformation\"`*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_System_SystemInformation")]
#[inline]
pub unsafe fn ImageRvaToSection(ntheaders: *const IMAGE_NT_HEADERS64, base: *const ::core::ffi::c_void, rva: u32) -> *mut IMAGE_SECTION_HEADER {
    ::windows::imp::link ! ( "dbghelp.dll""system" fn ImageRvaToSection ( ntheaders : *const IMAGE_NT_HEADERS64 , base : *const ::core::ffi::c_void , rva : u32 ) -> *mut IMAGE_SECTION_HEADER );
    ImageRvaToSection(ntheaders, base, rva)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_System_SystemInformation\"`*"]
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_System_SystemInformation")]
#[inline]
pub unsafe fn ImageRvaToSection(ntheaders: *const IMAGE_NT_HEADERS32, base: *const ::core::ffi::c_void, rva: u32) -> *mut IMAGE_SECTION_HEADER {
    ::windows::imp::link ! ( "dbghelp.dll""system" fn ImageRvaToSection ( ntheaders : *const IMAGE_NT_HEADERS32 , base : *const ::core::ffi::c_void , rva : u32 ) -> *mut IMAGE_SECTION_HEADER );
    ImageRvaToSection(ntheaders, base, rva)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_System_SystemInformation\"`*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_System_SystemInformation")]
#[inline]
pub unsafe fn ImageRvaToVa(ntheaders: *const IMAGE_NT_HEADERS64, base: *const ::core::ffi::c_void, rva: u32, lastrvasection: ::core::option::Option<*const *const IMAGE_SECTION_HEADER>) -> *mut ::core::ffi::c_void {
    ::windows::imp::link ! ( "dbghelp.dll""system" fn ImageRvaToVa ( ntheaders : *const IMAGE_NT_HEADERS64 , base : *const ::core::ffi::c_void , rva : u32 , lastrvasection : *const *const IMAGE_SECTION_HEADER ) -> *mut ::core::ffi::c_void );
    ImageRvaToVa(ntheaders, base, rva, ::core::mem::transmute(lastrvasection.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_System_SystemInformation\"`*"]
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_System_SystemInformation")]
#[inline]
pub unsafe fn ImageRvaToVa(ntheaders: *const IMAGE_NT_HEADERS32, base: *const ::core::ffi::c_void, rva: u32, lastrvasection: ::core::option::Option<*const *const IMAGE_SECTION_HEADER>) -> *mut ::core::ffi::c_void {
    ::windows::imp::link ! ( "dbghelp.dll""system" fn ImageRvaToVa ( ntheaders : *const IMAGE_NT_HEADERS32 , base : *const ::core::ffi::c_void , rva : u32 , lastrvasection : *const *const IMAGE_SECTION_HEADER ) -> *mut ::core::ffi::c_void );
    ImageRvaToVa(ntheaders, base, rva, ::core::mem::transmute(lastrvasection.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`, `\"Win32_System_Kernel\"`, `\"Win32_System_SystemInformation\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Kernel", feature = "Win32_System_SystemInformation"))]
#[inline]
pub unsafe fn ImageUnload(loadedimage: *mut LOADED_IMAGE) -> super::super::super::Foundation::BOOL {
    ::windows::imp::link ! ( "imagehlp.dll""system" fn ImageUnload ( loadedimage : *mut LOADED_IMAGE ) -> super::super::super::Foundation:: BOOL );
    ImageUnload(loadedimage)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[inline]
pub unsafe fn ImagehlpApiVersion() -> *mut API_VERSION {
    ::windows::imp::link ! ( "dbghelp.dll""system" fn ImagehlpApiVersion ( ) -> *mut API_VERSION );
    ImagehlpApiVersion()
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[inline]
pub unsafe fn ImagehlpApiVersionEx(appversion: *const API_VERSION) -> *mut API_VERSION {
    ::windows::imp::link ! ( "dbghelp.dll""system" fn ImagehlpApiVersionEx ( appversion : *const API_VERSION ) -> *mut API_VERSION );
    ImagehlpApiVersionEx(appversion)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`, `\"Win32_System_Kernel\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn InitializeContext(buffer: ::core::option::Option<*mut ::core::ffi::c_void>, contextflags: u32, context: *mut *mut CONTEXT, contextlength: *mut u32) -> super::super::super::Foundation::BOOL {
    ::windows::imp::link ! ( "kernel32.dll""system" fn InitializeContext ( buffer : *mut ::core::ffi::c_void , contextflags : u32 , context : *mut *mut CONTEXT , contextlength : *mut u32 ) -> super::super::super::Foundation:: BOOL );
    InitializeContext(::core::mem::transmute(buffer.unwrap_or(::std::ptr::null_mut())), contextflags, context, contextlength)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`, `\"Win32_System_Kernel\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn InitializeContext2(buffer: ::core::option::Option<*mut ::core::ffi::c_void>, contextflags: u32, context: *mut *mut CONTEXT, contextlength: *mut u32, xstatecompactionmask: u64) -> super::super::super::Foundation::BOOL {
    ::windows::imp::link ! ( "kernel32.dll""system" fn InitializeContext2 ( buffer : *mut ::core::ffi::c_void , contextflags : u32 , context : *mut *mut CONTEXT , contextlength : *mut u32 , xstatecompactionmask : u64 ) -> super::super::super::Foundation:: BOOL );
    InitializeContext2(::core::mem::transmute(buffer.unwrap_or(::std::ptr::null_mut())), contextflags, context, contextlength, xstatecompactionmask)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn IsDebuggerPresent() -> super::super::super::Foundation::BOOL {
    ::windows::imp::link ! ( "kernel32.dll""system" fn IsDebuggerPresent ( ) -> super::super::super::Foundation:: BOOL );
    IsDebuggerPresent()
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_System_Kernel\"`*"]
#[cfg(any(target_arch = "x86", target_arch = "x86_64"))]
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn LocateXStateFeature(context: *const CONTEXT, featureid: u32, length: ::core::option::Option<*mut u32>) -> *mut ::core::ffi::c_void {
    ::windows::imp::link ! ( "kernel32.dll""system" fn LocateXStateFeature ( context : *const CONTEXT , featureid : u32 , length : *mut u32 ) -> *mut ::core::ffi::c_void );
    LocateXStateFeature(context, featureid, ::core::mem::transmute(length.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn MakeSureDirectoryPathExists<P0>(dirpath: P0) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn MakeSureDirectoryPathExists ( dirpath : :: windows::core::PCSTR ) -> super::super::super::Foundation:: BOOL );
    MakeSureDirectoryPathExists(dirpath.into_param().abi())
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`, `\"Win32_System_Kernel\"`, `\"Win32_System_SystemInformation\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Kernel", feature = "Win32_System_SystemInformation"))]
#[inline]
pub unsafe fn MapAndLoad<P0, P1, P2, P3>(imagename: P0, dllpath: P1, loadedimage: *mut LOADED_IMAGE, dotdll: P2, readonly: P3) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P2: ::windows::core::IntoParam<super::super::super::Foundation::BOOL>,
    P3: ::windows::core::IntoParam<super::super::super::Foundation::BOOL>,
{
    ::windows::imp::link ! ( "imagehlp.dll""system" fn MapAndLoad ( imagename : :: windows::core::PCSTR , dllpath : :: windows::core::PCSTR , loadedimage : *mut LOADED_IMAGE , dotdll : super::super::super::Foundation:: BOOL , readonly : super::super::super::Foundation:: BOOL ) -> super::super::super::Foundation:: BOOL );
    MapAndLoad(imagename.into_param().abi(), dllpath.into_param().abi(), loadedimage, dotdll.into_param().abi(), readonly.into_param().abi())
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[inline]
pub unsafe fn MapFileAndCheckSumA<P0>(filename: P0, headersum: *mut u32, checksum: *mut u32) -> u32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "imagehlp.dll""system" fn MapFileAndCheckSumA ( filename : :: windows::core::PCSTR , headersum : *mut u32 , checksum : *mut u32 ) -> u32 );
    MapFileAndCheckSumA(filename.into_param().abi(), headersum, checksum)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[inline]
pub unsafe fn MapFileAndCheckSumW<P0>(filename: P0, headersum: *mut u32, checksum: *mut u32) -> u32
where
    P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "imagehlp.dll""system" fn MapFileAndCheckSumW ( filename : :: windows::core::PCWSTR , headersum : *mut u32 , checksum : *mut u32 ) -> u32 );
    MapFileAndCheckSumW(filename.into_param().abi(), headersum, checksum)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`, `\"Win32_UI_WindowsAndMessaging\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
#[inline]
pub unsafe fn MessageBeep(utype: super::super::super::UI::WindowsAndMessaging::MESSAGEBOX_STYLE) -> super::super::super::Foundation::BOOL {
    ::windows::imp::link ! ( "user32.dll""system" fn MessageBeep ( utype : super::super::super::UI::WindowsAndMessaging:: MESSAGEBOX_STYLE ) -> super::super::super::Foundation:: BOOL );
    MessageBeep(utype)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn MiniDumpReadDumpStream(baseofdump: *const ::core::ffi::c_void, streamnumber: u32, dir: *mut *mut MINIDUMP_DIRECTORY, streampointer: *mut *mut ::core::ffi::c_void, streamsize: ::core::option::Option<*mut u32>) -> super::super::super::Foundation::BOOL {
    ::windows::imp::link ! ( "dbghelp.dll""system" fn MiniDumpReadDumpStream ( baseofdump : *const ::core::ffi::c_void , streamnumber : u32 , dir : *mut *mut MINIDUMP_DIRECTORY , streampointer : *mut *mut ::core::ffi::c_void , streamsize : *mut u32 ) -> super::super::super::Foundation:: BOOL );
    MiniDumpReadDumpStream(baseofdump, streamnumber, dir, streampointer, ::core::mem::transmute(streamsize.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`, `\"Win32_Storage_FileSystem\"`, `\"Win32_System_Kernel\"`, `\"Win32_System_Memory\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_FileSystem", feature = "Win32_System_Kernel", feature = "Win32_System_Memory"))]
#[inline]
pub unsafe fn MiniDumpWriteDump<P0, P1>(hprocess: P0, processid: u32, hfile: P1, dumptype: MINIDUMP_TYPE, exceptionparam: ::core::option::Option<*const MINIDUMP_EXCEPTION_INFORMATION>, userstreamparam: ::core::option::Option<*const MINIDUMP_USER_STREAM_INFORMATION>, callbackparam: ::core::option::Option<*const MINIDUMP_CALLBACK_INFORMATION>) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn MiniDumpWriteDump ( hprocess : super::super::super::Foundation:: HANDLE , processid : u32 , hfile : super::super::super::Foundation:: HANDLE , dumptype : MINIDUMP_TYPE , exceptionparam : *const MINIDUMP_EXCEPTION_INFORMATION , userstreamparam : *const MINIDUMP_USER_STREAM_INFORMATION , callbackparam : *const MINIDUMP_CALLBACK_INFORMATION ) -> super::super::super::Foundation:: BOOL );
    MiniDumpWriteDump(hprocess.into_param().abi(), processid, hfile.into_param().abi(), dumptype, ::core::mem::transmute(exceptionparam.unwrap_or(::std::ptr::null())), ::core::mem::transmute(userstreamparam.unwrap_or(::std::ptr::null())), ::core::mem::transmute(callbackparam.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn OpenThreadWaitChainSession(flags: OPEN_THREAD_WAIT_CHAIN_SESSION_FLAGS, callback: PWAITCHAINCALLBACK) -> *mut ::core::ffi::c_void {
    ::windows::imp::link ! ( "advapi32.dll""system" fn OpenThreadWaitChainSession ( flags : OPEN_THREAD_WAIT_CHAIN_SESSION_FLAGS , callback : PWAITCHAINCALLBACK ) -> *mut ::core::ffi::c_void );
    OpenThreadWaitChainSession(flags, callback)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[inline]
pub unsafe fn OutputDebugStringA<P0>(lpoutputstring: P0)
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn OutputDebugStringA ( lpoutputstring : :: windows::core::PCSTR ) -> ( ) );
    OutputDebugStringA(lpoutputstring.into_param().abi())
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[inline]
pub unsafe fn OutputDebugStringW<P0>(lpoutputstring: P0)
where
    P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn OutputDebugStringW ( lpoutputstring : :: windows::core::PCWSTR ) -> ( ) );
    OutputDebugStringW(lpoutputstring.into_param().abi())
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[inline]
pub unsafe fn RaiseException(dwexceptioncode: u32, dwexceptionflags: u32, lparguments: ::core::option::Option<&[usize]>) {
    ::windows::imp::link ! ( "kernel32.dll""system" fn RaiseException ( dwexceptioncode : u32 , dwexceptionflags : u32 , nnumberofarguments : u32 , lparguments : *const usize ) -> ( ) );
    RaiseException(dwexceptioncode, dwexceptionflags, lparguments.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(lparguments.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())))
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`, `\"Win32_System_Kernel\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn RaiseFailFastException(pexceptionrecord: ::core::option::Option<*const EXCEPTION_RECORD>, pcontextrecord: ::core::option::Option<*const CONTEXT>, dwflags: u32) {
    ::windows::imp::link ! ( "kernel32.dll""system" fn RaiseFailFastException ( pexceptionrecord : *const EXCEPTION_RECORD , pcontextrecord : *const CONTEXT , dwflags : u32 ) -> ( ) );
    RaiseFailFastException(::core::mem::transmute(pexceptionrecord.unwrap_or(::std::ptr::null())), ::core::mem::transmute(pcontextrecord.unwrap_or(::std::ptr::null())), dwflags)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn RangeMapAddPeImageSections<P0>(rmaphandle: *const ::core::ffi::c_void, imagename: P0, mappedimage: *const ::core::ffi::c_void, mappingbytes: u32, imagebase: u64, usertag: u64, mappingflags: u32) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn RangeMapAddPeImageSections ( rmaphandle : *const ::core::ffi::c_void , imagename : :: windows::core::PCWSTR , mappedimage : *const ::core::ffi::c_void , mappingbytes : u32 , imagebase : u64 , usertag : u64 , mappingflags : u32 ) -> super::super::super::Foundation:: BOOL );
    RangeMapAddPeImageSections(rmaphandle, imagename.into_param().abi(), mappedimage, mappingbytes, imagebase, usertag, mappingflags)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[inline]
pub unsafe fn RangeMapCreate() -> *mut ::core::ffi::c_void {
    ::windows::imp::link ! ( "dbghelp.dll""system" fn RangeMapCreate ( ) -> *mut ::core::ffi::c_void );
    RangeMapCreate()
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[inline]
pub unsafe fn RangeMapFree(rmaphandle: ::core::option::Option<*const ::core::ffi::c_void>) {
    ::windows::imp::link ! ( "dbghelp.dll""system" fn RangeMapFree ( rmaphandle : *const ::core::ffi::c_void ) -> ( ) );
    RangeMapFree(::core::mem::transmute(rmaphandle.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn RangeMapRead(rmaphandle: *const ::core::ffi::c_void, offset: u64, buffer: *mut ::core::ffi::c_void, requestbytes: u32, flags: u32, donebytes: ::core::option::Option<*mut u32>) -> super::super::super::Foundation::BOOL {
    ::windows::imp::link ! ( "dbghelp.dll""system" fn RangeMapRead ( rmaphandle : *const ::core::ffi::c_void , offset : u64 , buffer : *mut ::core::ffi::c_void , requestbytes : u32 , flags : u32 , donebytes : *mut u32 ) -> super::super::super::Foundation:: BOOL );
    RangeMapRead(rmaphandle, offset, buffer, requestbytes, flags, ::core::mem::transmute(donebytes.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn RangeMapRemove(rmaphandle: *const ::core::ffi::c_void, usertag: u64) -> super::super::super::Foundation::BOOL {
    ::windows::imp::link ! ( "dbghelp.dll""system" fn RangeMapRemove ( rmaphandle : *const ::core::ffi::c_void , usertag : u64 ) -> super::super::super::Foundation:: BOOL );
    RangeMapRemove(rmaphandle, usertag)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn RangeMapWrite(rmaphandle: *const ::core::ffi::c_void, offset: u64, buffer: *const ::core::ffi::c_void, requestbytes: u32, flags: u32, donebytes: ::core::option::Option<*mut u32>) -> super::super::super::Foundation::BOOL {
    ::windows::imp::link ! ( "dbghelp.dll""system" fn RangeMapWrite ( rmaphandle : *const ::core::ffi::c_void , offset : u64 , buffer : *const ::core::ffi::c_void , requestbytes : u32 , flags : u32 , donebytes : *mut u32 ) -> super::super::super::Foundation:: BOOL );
    RangeMapWrite(rmaphandle, offset, buffer, requestbytes, flags, ::core::mem::transmute(donebytes.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ReBaseImage<P0, P1, P2, P3, P4>(currentimagename: P0, symbolpath: P1, frebase: P2, frebasesysfileok: P3, fgoingdown: P4, checkimagesize: u32, oldimagesize: *mut u32, oldimagebase: *mut usize, newimagesize: *mut u32, newimagebase: *mut usize, timestamp: u32) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P2: ::windows::core::IntoParam<super::super::super::Foundation::BOOL>,
    P3: ::windows::core::IntoParam<super::super::super::Foundation::BOOL>,
    P4: ::windows::core::IntoParam<super::super::super::Foundation::BOOL>,
{
    ::windows::imp::link ! ( "imagehlp.dll""system" fn ReBaseImage ( currentimagename : :: windows::core::PCSTR , symbolpath : :: windows::core::PCSTR , frebase : super::super::super::Foundation:: BOOL , frebasesysfileok : super::super::super::Foundation:: BOOL , fgoingdown : super::super::super::Foundation:: BOOL , checkimagesize : u32 , oldimagesize : *mut u32 , oldimagebase : *mut usize , newimagesize : *mut u32 , newimagebase : *mut usize , timestamp : u32 ) -> super::super::super::Foundation:: BOOL );
    ReBaseImage(currentimagename.into_param().abi(), symbolpath.into_param().abi(), frebase.into_param().abi(), frebasesysfileok.into_param().abi(), fgoingdown.into_param().abi(), checkimagesize, oldimagesize, oldimagebase, newimagesize, newimagebase, timestamp)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ReBaseImage64<P0, P1, P2, P3, P4>(currentimagename: P0, symbolpath: P1, frebase: P2, frebasesysfileok: P3, fgoingdown: P4, checkimagesize: u32, oldimagesize: *mut u32, oldimagebase: *mut u64, newimagesize: *mut u32, newimagebase: *mut u64, timestamp: u32) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P2: ::windows::core::IntoParam<super::super::super::Foundation::BOOL>,
    P3: ::windows::core::IntoParam<super::super::super::Foundation::BOOL>,
    P4: ::windows::core::IntoParam<super::super::super::Foundation::BOOL>,
{
    ::windows::imp::link ! ( "imagehlp.dll""system" fn ReBaseImage64 ( currentimagename : :: windows::core::PCSTR , symbolpath : :: windows::core::PCSTR , frebase : super::super::super::Foundation:: BOOL , frebasesysfileok : super::super::super::Foundation:: BOOL , fgoingdown : super::super::super::Foundation:: BOOL , checkimagesize : u32 , oldimagesize : *mut u32 , oldimagebase : *mut u64 , newimagesize : *mut u32 , newimagebase : *mut u64 , timestamp : u32 ) -> super::super::super::Foundation:: BOOL );
    ReBaseImage64(currentimagename.into_param().abi(), symbolpath.into_param().abi(), frebase.into_param().abi(), frebasesysfileok.into_param().abi(), fgoingdown.into_param().abi(), checkimagesize, oldimagesize, oldimagebase, newimagesize, newimagebase, timestamp)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ReadProcessMemory<P0>(hprocess: P0, lpbaseaddress: *const ::core::ffi::c_void, lpbuffer: *mut ::core::ffi::c_void, nsize: usize, lpnumberofbytesread: ::core::option::Option<*mut usize>) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn ReadProcessMemory ( hprocess : super::super::super::Foundation:: HANDLE , lpbaseaddress : *const ::core::ffi::c_void , lpbuffer : *mut ::core::ffi::c_void , nsize : usize , lpnumberofbytesread : *mut usize ) -> super::super::super::Foundation:: BOOL );
    ReadProcessMemory(hprocess.into_param().abi(), lpbaseaddress, lpbuffer, nsize, ::core::mem::transmute(lpnumberofbytesread.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[inline]
pub unsafe fn RegisterWaitChainCOMCallback(callstatecallback: PCOGETCALLSTATE, activationstatecallback: PCOGETACTIVATIONSTATE) {
    ::windows::imp::link ! ( "advapi32.dll""system" fn RegisterWaitChainCOMCallback ( callstatecallback : PCOGETCALLSTATE , activationstatecallback : PCOGETACTIVATIONSTATE ) -> ( ) );
    RegisterWaitChainCOMCallback(callstatecallback, activationstatecallback)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn RemoveInvalidModuleList<P0>(hprocess: P0)
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn RemoveInvalidModuleList ( hprocess : super::super::super::Foundation:: HANDLE ) -> ( ) );
    RemoveInvalidModuleList(hprocess.into_param().abi())
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[inline]
pub unsafe fn RemoveVectoredContinueHandler(handle: *const ::core::ffi::c_void) -> u32 {
    ::windows::imp::link ! ( "kernel32.dll""system" fn RemoveVectoredContinueHandler ( handle : *const ::core::ffi::c_void ) -> u32 );
    RemoveVectoredContinueHandler(handle)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[inline]
pub unsafe fn RemoveVectoredExceptionHandler(handle: *const ::core::ffi::c_void) -> u32 {
    ::windows::imp::link ! ( "kernel32.dll""system" fn RemoveVectoredExceptionHandler ( handle : *const ::core::ffi::c_void ) -> u32 );
    RemoveVectoredExceptionHandler(handle)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ReportSymbolLoadSummary<P0, P1>(hprocess: P0, ploadmodule: P1, psymboldata: *const DBGHELP_DATA_REPORT_STRUCT) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn ReportSymbolLoadSummary ( hprocess : super::super::super::Foundation:: HANDLE , ploadmodule : :: windows::core::PCWSTR , psymboldata : *const DBGHELP_DATA_REPORT_STRUCT ) -> super::super::super::Foundation:: BOOL );
    ReportSymbolLoadSummary(hprocess.into_param().abi(), ploadmodule.into_param().abi(), psymboldata)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(target_arch = "aarch64")]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn RtlAddFunctionTable(functiontable: &[IMAGE_ARM64_RUNTIME_FUNCTION_ENTRY], baseaddress: usize) -> super::super::super::Foundation::BOOLEAN {
    ::windows::imp::link ! ( "kernel32.dll""system" fn RtlAddFunctionTable ( functiontable : *const IMAGE_ARM64_RUNTIME_FUNCTION_ENTRY , entrycount : u32 , baseaddress : usize ) -> super::super::super::Foundation:: BOOLEAN );
    RtlAddFunctionTable(::core::mem::transmute(functiontable.as_ptr()), functiontable.len() as _, baseaddress)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(target_arch = "x86_64")]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn RtlAddFunctionTable(functiontable: &[IMAGE_RUNTIME_FUNCTION_ENTRY], baseaddress: u64) -> super::super::super::Foundation::BOOLEAN {
    ::windows::imp::link ! ( "kernel32.dll""system" fn RtlAddFunctionTable ( functiontable : *const IMAGE_RUNTIME_FUNCTION_ENTRY , entrycount : u32 , baseaddress : u64 ) -> super::super::super::Foundation:: BOOLEAN );
    RtlAddFunctionTable(::core::mem::transmute(functiontable.as_ptr()), functiontable.len() as _, baseaddress)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[cfg(target_arch = "aarch64")]
#[inline]
pub unsafe fn RtlAddGrowableFunctionTable(dynamictable: *mut *mut ::core::ffi::c_void, functiontable: &[IMAGE_ARM64_RUNTIME_FUNCTION_ENTRY], entrycount: u32, rangebase: usize, rangeend: usize) -> u32 {
    ::windows::imp::link ! ( "ntdll.dll""system" fn RtlAddGrowableFunctionTable ( dynamictable : *mut *mut ::core::ffi::c_void , functiontable : *const IMAGE_ARM64_RUNTIME_FUNCTION_ENTRY , entrycount : u32 , maximumentrycount : u32 , rangebase : usize , rangeend : usize ) -> u32 );
    RtlAddGrowableFunctionTable(dynamictable, ::core::mem::transmute(functiontable.as_ptr()), entrycount, functiontable.len() as _, rangebase, rangeend)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[cfg(target_arch = "x86_64")]
#[inline]
pub unsafe fn RtlAddGrowableFunctionTable(dynamictable: *mut *mut ::core::ffi::c_void, functiontable: &[IMAGE_RUNTIME_FUNCTION_ENTRY], entrycount: u32, rangebase: usize, rangeend: usize) -> u32 {
    ::windows::imp::link ! ( "ntdll.dll""system" fn RtlAddGrowableFunctionTable ( dynamictable : *mut *mut ::core::ffi::c_void , functiontable : *const IMAGE_RUNTIME_FUNCTION_ENTRY , entrycount : u32 , maximumentrycount : u32 , rangebase : usize , rangeend : usize ) -> u32 );
    RtlAddGrowableFunctionTable(dynamictable, ::core::mem::transmute(functiontable.as_ptr()), entrycount, functiontable.len() as _, rangebase, rangeend)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_System_Kernel\"`*"]
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn RtlCaptureContext(contextrecord: *mut CONTEXT) {
    ::windows::imp::link ! ( "kernel32.dll""system" fn RtlCaptureContext ( contextrecord : *mut CONTEXT ) -> ( ) );
    RtlCaptureContext(contextrecord)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_System_Kernel\"`*"]
#[cfg(target_arch = "x86_64")]
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn RtlCaptureContext2(contextrecord: *mut CONTEXT) {
    ::windows::imp::link ! ( "kernel32.dll""system" fn RtlCaptureContext2 ( contextrecord : *mut CONTEXT ) -> ( ) );
    RtlCaptureContext2(contextrecord)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[inline]
pub unsafe fn RtlCaptureStackBackTrace(framestoskip: u32, backtrace: &mut [*mut ::core::ffi::c_void], backtracehash: ::core::option::Option<*mut u32>) -> u16 {
    ::windows::imp::link ! ( "kernel32.dll""system" fn RtlCaptureStackBackTrace ( framestoskip : u32 , framestocapture : u32 , backtrace : *mut *mut ::core::ffi::c_void , backtracehash : *mut u32 ) -> u16 );
    RtlCaptureStackBackTrace(framestoskip, backtrace.len() as _, ::core::mem::transmute(backtrace.as_ptr()), ::core::mem::transmute(backtracehash.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(target_arch = "aarch64")]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn RtlDeleteFunctionTable(functiontable: *const IMAGE_ARM64_RUNTIME_FUNCTION_ENTRY) -> super::super::super::Foundation::BOOLEAN {
    ::windows::imp::link ! ( "kernel32.dll""system" fn RtlDeleteFunctionTable ( functiontable : *const IMAGE_ARM64_RUNTIME_FUNCTION_ENTRY ) -> super::super::super::Foundation:: BOOLEAN );
    RtlDeleteFunctionTable(functiontable)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(target_arch = "x86_64")]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn RtlDeleteFunctionTable(functiontable: *const IMAGE_RUNTIME_FUNCTION_ENTRY) -> super::super::super::Foundation::BOOLEAN {
    ::windows::imp::link ! ( "kernel32.dll""system" fn RtlDeleteFunctionTable ( functiontable : *const IMAGE_RUNTIME_FUNCTION_ENTRY ) -> super::super::super::Foundation:: BOOLEAN );
    RtlDeleteFunctionTable(functiontable)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[inline]
pub unsafe fn RtlDeleteGrowableFunctionTable(dynamictable: *const ::core::ffi::c_void) {
    ::windows::imp::link ! ( "ntdll.dll""system" fn RtlDeleteGrowableFunctionTable ( dynamictable : *const ::core::ffi::c_void ) -> ( ) );
    RtlDeleteGrowableFunctionTable(dynamictable)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[inline]
pub unsafe fn RtlGrowFunctionTable(dynamictable: *mut ::core::ffi::c_void, newentrycount: u32) {
    ::windows::imp::link ! ( "ntdll.dll""system" fn RtlGrowFunctionTable ( dynamictable : *mut ::core::ffi::c_void , newentrycount : u32 ) -> ( ) );
    RtlGrowFunctionTable(dynamictable, newentrycount)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(target_arch = "aarch64")]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn RtlInstallFunctionTableCallback<P0>(tableidentifier: u64, baseaddress: u64, length: u32, callback: PGET_RUNTIME_FUNCTION_CALLBACK, context: ::core::option::Option<*const ::core::ffi::c_void>, outofprocesscallbackdll: P0) -> super::super::super::Foundation::BOOLEAN
where
    P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn RtlInstallFunctionTableCallback ( tableidentifier : u64 , baseaddress : u64 , length : u32 , callback : PGET_RUNTIME_FUNCTION_CALLBACK , context : *const ::core::ffi::c_void , outofprocesscallbackdll : :: windows::core::PCWSTR ) -> super::super::super::Foundation:: BOOLEAN );
    RtlInstallFunctionTableCallback(tableidentifier, baseaddress, length, callback, ::core::mem::transmute(context.unwrap_or(::std::ptr::null())), outofprocesscallbackdll.into_param().abi())
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(target_arch = "x86_64")]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn RtlInstallFunctionTableCallback<P0>(tableidentifier: u64, baseaddress: u64, length: u32, callback: PGET_RUNTIME_FUNCTION_CALLBACK, context: ::core::option::Option<*const ::core::ffi::c_void>, outofprocesscallbackdll: P0) -> super::super::super::Foundation::BOOLEAN
where
    P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn RtlInstallFunctionTableCallback ( tableidentifier : u64 , baseaddress : u64 , length : u32 , callback : PGET_RUNTIME_FUNCTION_CALLBACK , context : *const ::core::ffi::c_void , outofprocesscallbackdll : :: windows::core::PCWSTR ) -> super::super::super::Foundation:: BOOLEAN );
    RtlInstallFunctionTableCallback(tableidentifier, baseaddress, length, callback, ::core::mem::transmute(context.unwrap_or(::std::ptr::null())), outofprocesscallbackdll.into_param().abi())
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[cfg(target_arch = "aarch64")]
#[inline]
pub unsafe fn RtlLookupFunctionEntry(controlpc: usize, imagebase: *mut usize, historytable: ::core::option::Option<*mut UNWIND_HISTORY_TABLE>) -> *mut IMAGE_ARM64_RUNTIME_FUNCTION_ENTRY {
    ::windows::imp::link ! ( "kernel32.dll""system" fn RtlLookupFunctionEntry ( controlpc : usize , imagebase : *mut usize , historytable : *mut UNWIND_HISTORY_TABLE ) -> *mut IMAGE_ARM64_RUNTIME_FUNCTION_ENTRY );
    RtlLookupFunctionEntry(controlpc, imagebase, ::core::mem::transmute(historytable.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[cfg(target_arch = "x86_64")]
#[inline]
pub unsafe fn RtlLookupFunctionEntry(controlpc: u64, imagebase: *mut u64, historytable: ::core::option::Option<*mut UNWIND_HISTORY_TABLE>) -> *mut IMAGE_RUNTIME_FUNCTION_ENTRY {
    ::windows::imp::link ! ( "kernel32.dll""system" fn RtlLookupFunctionEntry ( controlpc : u64 , imagebase : *mut u64 , historytable : *mut UNWIND_HISTORY_TABLE ) -> *mut IMAGE_RUNTIME_FUNCTION_ENTRY );
    RtlLookupFunctionEntry(controlpc, imagebase, ::core::mem::transmute(historytable.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[inline]
pub unsafe fn RtlPcToFileHeader(pcvalue: *const ::core::ffi::c_void, baseofimage: *mut *mut ::core::ffi::c_void) -> *mut ::core::ffi::c_void {
    ::windows::imp::link ! ( "kernel32.dll""system" fn RtlPcToFileHeader ( pcvalue : *const ::core::ffi::c_void , baseofimage : *mut *mut ::core::ffi::c_void ) -> *mut ::core::ffi::c_void );
    RtlPcToFileHeader(pcvalue, baseofimage)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn RtlRaiseException(exceptionrecord: *const EXCEPTION_RECORD) {
    ::windows::imp::link ! ( "kernel32.dll""system" fn RtlRaiseException ( exceptionrecord : *const EXCEPTION_RECORD ) -> ( ) );
    RtlRaiseException(exceptionrecord)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`, `\"Win32_System_Kernel\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn RtlRestoreContext(contextrecord: *const CONTEXT, exceptionrecord: ::core::option::Option<*const EXCEPTION_RECORD>) {
    ::windows::imp::link ! ( "kernel32.dll""cdecl" fn RtlRestoreContext ( contextrecord : *const CONTEXT , exceptionrecord : *const EXCEPTION_RECORD ) -> ( ) );
    RtlRestoreContext(contextrecord, ::core::mem::transmute(exceptionrecord.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn RtlUnwind(targetframe: ::core::option::Option<*const ::core::ffi::c_void>, targetip: ::core::option::Option<*const ::core::ffi::c_void>, exceptionrecord: ::core::option::Option<*const EXCEPTION_RECORD>, returnvalue: *const ::core::ffi::c_void) {
    ::windows::imp::link ! ( "kernel32.dll""system" fn RtlUnwind ( targetframe : *const ::core::ffi::c_void , targetip : *const ::core::ffi::c_void , exceptionrecord : *const EXCEPTION_RECORD , returnvalue : *const ::core::ffi::c_void ) -> ( ) );
    RtlUnwind(::core::mem::transmute(targetframe.unwrap_or(::std::ptr::null())), ::core::mem::transmute(targetip.unwrap_or(::std::ptr::null())), ::core::mem::transmute(exceptionrecord.unwrap_or(::std::ptr::null())), returnvalue)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`, `\"Win32_System_Kernel\"`*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn RtlUnwindEx(targetframe: ::core::option::Option<*const ::core::ffi::c_void>, targetip: ::core::option::Option<*const ::core::ffi::c_void>, exceptionrecord: ::core::option::Option<*const EXCEPTION_RECORD>, returnvalue: *const ::core::ffi::c_void, contextrecord: *const CONTEXT, historytable: ::core::option::Option<*const UNWIND_HISTORY_TABLE>) {
    ::windows::imp::link ! ( "kernel32.dll""system" fn RtlUnwindEx ( targetframe : *const ::core::ffi::c_void , targetip : *const ::core::ffi::c_void , exceptionrecord : *const EXCEPTION_RECORD , returnvalue : *const ::core::ffi::c_void , contextrecord : *const CONTEXT , historytable : *const UNWIND_HISTORY_TABLE ) -> ( ) );
    RtlUnwindEx(::core::mem::transmute(targetframe.unwrap_or(::std::ptr::null())), ::core::mem::transmute(targetip.unwrap_or(::std::ptr::null())), ::core::mem::transmute(exceptionrecord.unwrap_or(::std::ptr::null())), returnvalue, contextrecord, ::core::mem::transmute(historytable.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`, `\"Win32_System_Kernel\"`*"]
#[cfg(target_arch = "aarch64")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn RtlVirtualUnwind(handlertype: RTL_VIRTUAL_UNWIND_HANDLER_TYPE, imagebase: usize, controlpc: usize, functionentry: *const IMAGE_ARM64_RUNTIME_FUNCTION_ENTRY, contextrecord: *mut CONTEXT, handlerdata: *mut *mut ::core::ffi::c_void, establisherframe: *mut usize, contextpointers: ::core::option::Option<*mut KNONVOLATILE_CONTEXT_POINTERS_ARM64>) -> super::super::Kernel::EXCEPTION_ROUTINE {
    ::windows::imp::link ! ( "kernel32.dll""system" fn RtlVirtualUnwind ( handlertype : RTL_VIRTUAL_UNWIND_HANDLER_TYPE , imagebase : usize , controlpc : usize , functionentry : *const IMAGE_ARM64_RUNTIME_FUNCTION_ENTRY , contextrecord : *mut CONTEXT , handlerdata : *mut *mut ::core::ffi::c_void , establisherframe : *mut usize , contextpointers : *mut KNONVOLATILE_CONTEXT_POINTERS_ARM64 ) -> super::super::Kernel:: EXCEPTION_ROUTINE );
    RtlVirtualUnwind(handlertype, imagebase, controlpc, functionentry, contextrecord, handlerdata, establisherframe, ::core::mem::transmute(contextpointers.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`, `\"Win32_System_Kernel\"`*"]
#[cfg(target_arch = "x86_64")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn RtlVirtualUnwind(handlertype: RTL_VIRTUAL_UNWIND_HANDLER_TYPE, imagebase: u64, controlpc: u64, functionentry: *const IMAGE_RUNTIME_FUNCTION_ENTRY, contextrecord: *mut CONTEXT, handlerdata: *mut *mut ::core::ffi::c_void, establisherframe: *mut u64, contextpointers: ::core::option::Option<*mut KNONVOLATILE_CONTEXT_POINTERS>) -> super::super::Kernel::EXCEPTION_ROUTINE {
    ::windows::imp::link ! ( "kernel32.dll""system" fn RtlVirtualUnwind ( handlertype : RTL_VIRTUAL_UNWIND_HANDLER_TYPE , imagebase : u64 , controlpc : u64 , functionentry : *const IMAGE_RUNTIME_FUNCTION_ENTRY , contextrecord : *mut CONTEXT , handlerdata : *mut *mut ::core::ffi::c_void , establisherframe : *mut u64 , contextpointers : *mut KNONVOLATILE_CONTEXT_POINTERS ) -> super::super::Kernel:: EXCEPTION_ROUTINE );
    RtlVirtualUnwind(handlertype, imagebase, controlpc, functionentry, contextrecord, handlerdata, establisherframe, ::core::mem::transmute(contextpointers.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SearchTreeForFile<P0, P1>(rootpath: P0, inputpathname: P1, outputpathbuffer: ::windows::core::PSTR) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SearchTreeForFile ( rootpath : :: windows::core::PCSTR , inputpathname : :: windows::core::PCSTR , outputpathbuffer : :: windows::core::PSTR ) -> super::super::super::Foundation:: BOOL );
    SearchTreeForFile(rootpath.into_param().abi(), inputpathname.into_param().abi(), ::core::mem::transmute(outputpathbuffer))
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SearchTreeForFileW<P0, P1>(rootpath: P0, inputpathname: P1, outputpathbuffer: ::windows::core::PWSTR) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SearchTreeForFileW ( rootpath : :: windows::core::PCWSTR , inputpathname : :: windows::core::PCWSTR , outputpathbuffer : :: windows::core::PWSTR ) -> super::super::super::Foundation:: BOOL );
    SearchTreeForFileW(rootpath.into_param().abi(), inputpathname.into_param().abi(), ::core::mem::transmute(outputpathbuffer))
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[inline]
pub unsafe fn SetCheckUserInterruptShared(lpstartaddress: LPCALL_BACK_USER_INTERRUPT_ROUTINE) {
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SetCheckUserInterruptShared ( lpstartaddress : LPCALL_BACK_USER_INTERRUPT_ROUTINE ) -> ( ) );
    SetCheckUserInterruptShared(lpstartaddress)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[inline]
pub unsafe fn SetErrorMode(umode: THREAD_ERROR_MODE) -> u32 {
    ::windows::imp::link ! ( "kernel32.dll""system" fn SetErrorMode ( umode : THREAD_ERROR_MODE ) -> u32 );
    SetErrorMode(umode)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`, `\"Win32_System_Kernel\"`, `\"Win32_System_SystemInformation\"`*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Kernel", feature = "Win32_System_SystemInformation"))]
#[inline]
pub unsafe fn SetImageConfigInformation(loadedimage: *mut LOADED_IMAGE, imageconfiginformation: *const IMAGE_LOAD_CONFIG_DIRECTORY64) -> super::super::super::Foundation::BOOL {
    ::windows::imp::link ! ( "imagehlp.dll""system" fn SetImageConfigInformation ( loadedimage : *mut LOADED_IMAGE , imageconfiginformation : *const IMAGE_LOAD_CONFIG_DIRECTORY64 ) -> super::super::super::Foundation:: BOOL );
    SetImageConfigInformation(loadedimage, imageconfiginformation)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`, `\"Win32_System_Kernel\"`, `\"Win32_System_SystemInformation\"`*"]
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Kernel", feature = "Win32_System_SystemInformation"))]
#[inline]
pub unsafe fn SetImageConfigInformation(loadedimage: *mut LOADED_IMAGE, imageconfiginformation: *const IMAGE_LOAD_CONFIG_DIRECTORY32) -> super::super::super::Foundation::BOOL {
    ::windows::imp::link ! ( "imagehlp.dll""system" fn SetImageConfigInformation ( loadedimage : *mut LOADED_IMAGE , imageconfiginformation : *const IMAGE_LOAD_CONFIG_DIRECTORY32 ) -> super::super::super::Foundation:: BOOL );
    SetImageConfigInformation(loadedimage, imageconfiginformation)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[inline]
pub unsafe fn SetSymLoadError(error: u32) {
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SetSymLoadError ( error : u32 ) -> ( ) );
    SetSymLoadError(error)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`, `\"Win32_System_Kernel\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn SetThreadContext<P0>(hthread: P0, lpcontext: *const CONTEXT) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn SetThreadContext ( hthread : super::super::super::Foundation:: HANDLE , lpcontext : *const CONTEXT ) -> super::super::super::Foundation:: BOOL );
    SetThreadContext(hthread.into_param().abi(), lpcontext)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SetThreadErrorMode(dwnewmode: THREAD_ERROR_MODE, lpoldmode: ::core::option::Option<*const THREAD_ERROR_MODE>) -> super::super::super::Foundation::BOOL {
    ::windows::imp::link ! ( "kernel32.dll""system" fn SetThreadErrorMode ( dwnewmode : THREAD_ERROR_MODE , lpoldmode : *const THREAD_ERROR_MODE ) -> super::super::super::Foundation:: BOOL );
    SetThreadErrorMode(dwnewmode, ::core::mem::transmute(lpoldmode.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`, `\"Win32_System_Kernel\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn SetUnhandledExceptionFilter(lptoplevelexceptionfilter: LPTOP_LEVEL_EXCEPTION_FILTER) -> LPTOP_LEVEL_EXCEPTION_FILTER {
    ::windows::imp::link ! ( "kernel32.dll""system" fn SetUnhandledExceptionFilter ( lptoplevelexceptionfilter : LPTOP_LEVEL_EXCEPTION_FILTER ) -> LPTOP_LEVEL_EXCEPTION_FILTER );
    SetUnhandledExceptionFilter(lptoplevelexceptionfilter)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`, `\"Win32_System_Kernel\"`*"]
#[cfg(any(target_arch = "x86", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn SetXStateFeaturesMask(context: *mut CONTEXT, featuremask: u64) -> super::super::super::Foundation::BOOL {
    ::windows::imp::link ! ( "kernel32.dll""system" fn SetXStateFeaturesMask ( context : *mut CONTEXT , featuremask : u64 ) -> super::super::super::Foundation:: BOOL );
    SetXStateFeaturesMask(context, featuremask)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn StackWalk<P0, P1>(machinetype: u32, hprocess: P0, hthread: P1, stackframe: *mut STACKFRAME, contextrecord: *mut ::core::ffi::c_void, readmemoryroutine: PREAD_PROCESS_MEMORY_ROUTINE, functiontableaccessroutine: PFUNCTION_TABLE_ACCESS_ROUTINE, getmodulebaseroutine: PGET_MODULE_BASE_ROUTINE, translateaddress: PTRANSLATE_ADDRESS_ROUTINE) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn StackWalk ( machinetype : u32 , hprocess : super::super::super::Foundation:: HANDLE , hthread : super::super::super::Foundation:: HANDLE , stackframe : *mut STACKFRAME , contextrecord : *mut ::core::ffi::c_void , readmemoryroutine : PREAD_PROCESS_MEMORY_ROUTINE , functiontableaccessroutine : PFUNCTION_TABLE_ACCESS_ROUTINE , getmodulebaseroutine : PGET_MODULE_BASE_ROUTINE , translateaddress : PTRANSLATE_ADDRESS_ROUTINE ) -> super::super::super::Foundation:: BOOL );
    StackWalk(machinetype, hprocess.into_param().abi(), hthread.into_param().abi(), stackframe, contextrecord, readmemoryroutine, functiontableaccessroutine, getmodulebaseroutine, translateaddress)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn StackWalk64<P0, P1>(machinetype: u32, hprocess: P0, hthread: P1, stackframe: *mut STACKFRAME64, contextrecord: *mut ::core::ffi::c_void, readmemoryroutine: PREAD_PROCESS_MEMORY_ROUTINE64, functiontableaccessroutine: PFUNCTION_TABLE_ACCESS_ROUTINE64, getmodulebaseroutine: PGET_MODULE_BASE_ROUTINE64, translateaddress: PTRANSLATE_ADDRESS_ROUTINE64) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn StackWalk64 ( machinetype : u32 , hprocess : super::super::super::Foundation:: HANDLE , hthread : super::super::super::Foundation:: HANDLE , stackframe : *mut STACKFRAME64 , contextrecord : *mut ::core::ffi::c_void , readmemoryroutine : PREAD_PROCESS_MEMORY_ROUTINE64 , functiontableaccessroutine : PFUNCTION_TABLE_ACCESS_ROUTINE64 , getmodulebaseroutine : PGET_MODULE_BASE_ROUTINE64 , translateaddress : PTRANSLATE_ADDRESS_ROUTINE64 ) -> super::super::super::Foundation:: BOOL );
    StackWalk64(machinetype, hprocess.into_param().abi(), hthread.into_param().abi(), stackframe, contextrecord, readmemoryroutine, functiontableaccessroutine, getmodulebaseroutine, translateaddress)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn StackWalkEx<P0, P1>(machinetype: u32, hprocess: P0, hthread: P1, stackframe: *mut STACKFRAME_EX, contextrecord: *mut ::core::ffi::c_void, readmemoryroutine: PREAD_PROCESS_MEMORY_ROUTINE64, functiontableaccessroutine: PFUNCTION_TABLE_ACCESS_ROUTINE64, getmodulebaseroutine: PGET_MODULE_BASE_ROUTINE64, translateaddress: PTRANSLATE_ADDRESS_ROUTINE64, flags: u32) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn StackWalkEx ( machinetype : u32 , hprocess : super::super::super::Foundation:: HANDLE , hthread : super::super::super::Foundation:: HANDLE , stackframe : *mut STACKFRAME_EX , contextrecord : *mut ::core::ffi::c_void , readmemoryroutine : PREAD_PROCESS_MEMORY_ROUTINE64 , functiontableaccessroutine : PFUNCTION_TABLE_ACCESS_ROUTINE64 , getmodulebaseroutine : PGET_MODULE_BASE_ROUTINE64 , translateaddress : PTRANSLATE_ADDRESS_ROUTINE64 , flags : u32 ) -> super::super::super::Foundation:: BOOL );
    StackWalkEx(machinetype, hprocess.into_param().abi(), hthread.into_param().abi(), stackframe, contextrecord, readmemoryroutine, functiontableaccessroutine, getmodulebaseroutine, translateaddress, flags)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymAddSourceStream<P0, P1>(hprocess: P0, base: u64, streamfile: P1, buffer: ::core::option::Option<&[u8]>) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymAddSourceStream ( hprocess : super::super::super::Foundation:: HANDLE , base : u64 , streamfile : :: windows::core::PCSTR , buffer : *const u8 , size : usize ) -> super::super::super::Foundation:: BOOL );
    SymAddSourceStream(hprocess.into_param().abi(), base, streamfile.into_param().abi(), ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _))
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymAddSourceStreamA<P0, P1>(hprocess: P0, base: u64, streamfile: P1, buffer: ::core::option::Option<&[u8]>) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymAddSourceStreamA ( hprocess : super::super::super::Foundation:: HANDLE , base : u64 , streamfile : :: windows::core::PCSTR , buffer : *const u8 , size : usize ) -> super::super::super::Foundation:: BOOL );
    SymAddSourceStreamA(hprocess.into_param().abi(), base, streamfile.into_param().abi(), ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _))
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymAddSourceStreamW<P0, P1>(hprocess: P0, base: u64, filespec: P1, buffer: ::core::option::Option<&[u8]>) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymAddSourceStreamW ( hprocess : super::super::super::Foundation:: HANDLE , base : u64 , filespec : :: windows::core::PCWSTR , buffer : *const u8 , size : usize ) -> super::super::super::Foundation:: BOOL );
    SymAddSourceStreamW(hprocess.into_param().abi(), base, filespec.into_param().abi(), ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _))
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymAddSymbol<P0, P1>(hprocess: P0, baseofdll: u64, name: P1, address: u64, size: u32, flags: u32) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymAddSymbol ( hprocess : super::super::super::Foundation:: HANDLE , baseofdll : u64 , name : :: windows::core::PCSTR , address : u64 , size : u32 , flags : u32 ) -> super::super::super::Foundation:: BOOL );
    SymAddSymbol(hprocess.into_param().abi(), baseofdll, name.into_param().abi(), address, size, flags)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymAddSymbolW<P0, P1>(hprocess: P0, baseofdll: u64, name: P1, address: u64, size: u32, flags: u32) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymAddSymbolW ( hprocess : super::super::super::Foundation:: HANDLE , baseofdll : u64 , name : :: windows::core::PCWSTR , address : u64 , size : u32 , flags : u32 ) -> super::super::super::Foundation:: BOOL );
    SymAddSymbolW(hprocess.into_param().abi(), baseofdll, name.into_param().abi(), address, size, flags)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymAddrIncludeInlineTrace<P0>(hprocess: P0, address: u64) -> u32
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymAddrIncludeInlineTrace ( hprocess : super::super::super::Foundation:: HANDLE , address : u64 ) -> u32 );
    SymAddrIncludeInlineTrace(hprocess.into_param().abi(), address)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymCleanup<P0>(hprocess: P0) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymCleanup ( hprocess : super::super::super::Foundation:: HANDLE ) -> super::super::super::Foundation:: BOOL );
    SymCleanup(hprocess.into_param().abi())
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymCompareInlineTrace<P0>(hprocess: P0, address1: u64, inlinecontext1: u32, retaddress1: u64, address2: u64, retaddress2: u64) -> u32
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymCompareInlineTrace ( hprocess : super::super::super::Foundation:: HANDLE , address1 : u64 , inlinecontext1 : u32 , retaddress1 : u64 , address2 : u64 , retaddress2 : u64 ) -> u32 );
    SymCompareInlineTrace(hprocess.into_param().abi(), address1, inlinecontext1, retaddress1, address2, retaddress2)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymDeleteSymbol<P0, P1>(hprocess: P0, baseofdll: u64, name: P1, address: u64, flags: u32) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymDeleteSymbol ( hprocess : super::super::super::Foundation:: HANDLE , baseofdll : u64 , name : :: windows::core::PCSTR , address : u64 , flags : u32 ) -> super::super::super::Foundation:: BOOL );
    SymDeleteSymbol(hprocess.into_param().abi(), baseofdll, name.into_param().abi(), address, flags)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymDeleteSymbolW<P0, P1>(hprocess: P0, baseofdll: u64, name: P1, address: u64, flags: u32) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymDeleteSymbolW ( hprocess : super::super::super::Foundation:: HANDLE , baseofdll : u64 , name : :: windows::core::PCWSTR , address : u64 , flags : u32 ) -> super::super::super::Foundation:: BOOL );
    SymDeleteSymbolW(hprocess.into_param().abi(), baseofdll, name.into_param().abi(), address, flags)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymEnumLines<P0, P1, P2>(hprocess: P0, base: u64, obj: P1, file: P2, enumlinescallback: PSYM_ENUMLINES_CALLBACK, usercontext: ::core::option::Option<*const ::core::ffi::c_void>) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P2: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymEnumLines ( hprocess : super::super::super::Foundation:: HANDLE , base : u64 , obj : :: windows::core::PCSTR , file : :: windows::core::PCSTR , enumlinescallback : PSYM_ENUMLINES_CALLBACK , usercontext : *const ::core::ffi::c_void ) -> super::super::super::Foundation:: BOOL );
    SymEnumLines(hprocess.into_param().abi(), base, obj.into_param().abi(), file.into_param().abi(), enumlinescallback, ::core::mem::transmute(usercontext.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymEnumLinesW<P0, P1, P2>(hprocess: P0, base: u64, obj: P1, file: P2, enumlinescallback: PSYM_ENUMLINES_CALLBACKW, usercontext: ::core::option::Option<*const ::core::ffi::c_void>) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    P2: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymEnumLinesW ( hprocess : super::super::super::Foundation:: HANDLE , base : u64 , obj : :: windows::core::PCWSTR , file : :: windows::core::PCWSTR , enumlinescallback : PSYM_ENUMLINES_CALLBACKW , usercontext : *const ::core::ffi::c_void ) -> super::super::super::Foundation:: BOOL );
    SymEnumLinesW(hprocess.into_param().abi(), base, obj.into_param().abi(), file.into_param().abi(), enumlinescallback, ::core::mem::transmute(usercontext.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymEnumProcesses(enumprocessescallback: PSYM_ENUMPROCESSES_CALLBACK, usercontext: *const ::core::ffi::c_void) -> super::super::super::Foundation::BOOL {
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymEnumProcesses ( enumprocessescallback : PSYM_ENUMPROCESSES_CALLBACK , usercontext : *const ::core::ffi::c_void ) -> super::super::super::Foundation:: BOOL );
    SymEnumProcesses(enumprocessescallback, usercontext)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymEnumSourceFileTokens<P0>(hprocess: P0, base: u64, callback: PENUMSOURCEFILETOKENSCALLBACK) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymEnumSourceFileTokens ( hprocess : super::super::super::Foundation:: HANDLE , base : u64 , callback : PENUMSOURCEFILETOKENSCALLBACK ) -> super::super::super::Foundation:: BOOL );
    SymEnumSourceFileTokens(hprocess.into_param().abi(), base, callback)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymEnumSourceFiles<P0, P1>(hprocess: P0, modbase: u64, mask: P1, cbsrcfiles: PSYM_ENUMSOURCEFILES_CALLBACK, usercontext: ::core::option::Option<*const ::core::ffi::c_void>) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymEnumSourceFiles ( hprocess : super::super::super::Foundation:: HANDLE , modbase : u64 , mask : :: windows::core::PCSTR , cbsrcfiles : PSYM_ENUMSOURCEFILES_CALLBACK , usercontext : *const ::core::ffi::c_void ) -> super::super::super::Foundation:: BOOL );
    SymEnumSourceFiles(hprocess.into_param().abi(), modbase, mask.into_param().abi(), cbsrcfiles, ::core::mem::transmute(usercontext.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymEnumSourceFilesW<P0, P1>(hprocess: P0, modbase: u64, mask: P1, cbsrcfiles: PSYM_ENUMSOURCEFILES_CALLBACKW, usercontext: ::core::option::Option<*const ::core::ffi::c_void>) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymEnumSourceFilesW ( hprocess : super::super::super::Foundation:: HANDLE , modbase : u64 , mask : :: windows::core::PCWSTR , cbsrcfiles : PSYM_ENUMSOURCEFILES_CALLBACKW , usercontext : *const ::core::ffi::c_void ) -> super::super::super::Foundation:: BOOL );
    SymEnumSourceFilesW(hprocess.into_param().abi(), modbase, mask.into_param().abi(), cbsrcfiles, ::core::mem::transmute(usercontext.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymEnumSourceLines<P0, P1, P2>(hprocess: P0, base: u64, obj: P1, file: P2, line: u32, flags: u32, enumlinescallback: PSYM_ENUMLINES_CALLBACK, usercontext: ::core::option::Option<*const ::core::ffi::c_void>) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P2: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymEnumSourceLines ( hprocess : super::super::super::Foundation:: HANDLE , base : u64 , obj : :: windows::core::PCSTR , file : :: windows::core::PCSTR , line : u32 , flags : u32 , enumlinescallback : PSYM_ENUMLINES_CALLBACK , usercontext : *const ::core::ffi::c_void ) -> super::super::super::Foundation:: BOOL );
    SymEnumSourceLines(hprocess.into_param().abi(), base, obj.into_param().abi(), file.into_param().abi(), line, flags, enumlinescallback, ::core::mem::transmute(usercontext.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymEnumSourceLinesW<P0, P1, P2>(hprocess: P0, base: u64, obj: P1, file: P2, line: u32, flags: u32, enumlinescallback: PSYM_ENUMLINES_CALLBACKW, usercontext: ::core::option::Option<*const ::core::ffi::c_void>) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    P2: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymEnumSourceLinesW ( hprocess : super::super::super::Foundation:: HANDLE , base : u64 , obj : :: windows::core::PCWSTR , file : :: windows::core::PCWSTR , line : u32 , flags : u32 , enumlinescallback : PSYM_ENUMLINES_CALLBACKW , usercontext : *const ::core::ffi::c_void ) -> super::super::super::Foundation:: BOOL );
    SymEnumSourceLinesW(hprocess.into_param().abi(), base, obj.into_param().abi(), file.into_param().abi(), line, flags, enumlinescallback, ::core::mem::transmute(usercontext.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymEnumSym<P0>(hprocess: P0, baseofdll: u64, enumsymbolscallback: PSYM_ENUMERATESYMBOLS_CALLBACK, usercontext: ::core::option::Option<*const ::core::ffi::c_void>) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymEnumSym ( hprocess : super::super::super::Foundation:: HANDLE , baseofdll : u64 , enumsymbolscallback : PSYM_ENUMERATESYMBOLS_CALLBACK , usercontext : *const ::core::ffi::c_void ) -> super::super::super::Foundation:: BOOL );
    SymEnumSym(hprocess.into_param().abi(), baseofdll, enumsymbolscallback, ::core::mem::transmute(usercontext.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymEnumSymbols<P0, P1>(hprocess: P0, baseofdll: u64, mask: P1, enumsymbolscallback: PSYM_ENUMERATESYMBOLS_CALLBACK, usercontext: ::core::option::Option<*const ::core::ffi::c_void>) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymEnumSymbols ( hprocess : super::super::super::Foundation:: HANDLE , baseofdll : u64 , mask : :: windows::core::PCSTR , enumsymbolscallback : PSYM_ENUMERATESYMBOLS_CALLBACK , usercontext : *const ::core::ffi::c_void ) -> super::super::super::Foundation:: BOOL );
    SymEnumSymbols(hprocess.into_param().abi(), baseofdll, mask.into_param().abi(), enumsymbolscallback, ::core::mem::transmute(usercontext.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymEnumSymbolsEx<P0, P1>(hprocess: P0, baseofdll: u64, mask: P1, enumsymbolscallback: PSYM_ENUMERATESYMBOLS_CALLBACK, usercontext: ::core::option::Option<*const ::core::ffi::c_void>, options: u32) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymEnumSymbolsEx ( hprocess : super::super::super::Foundation:: HANDLE , baseofdll : u64 , mask : :: windows::core::PCSTR , enumsymbolscallback : PSYM_ENUMERATESYMBOLS_CALLBACK , usercontext : *const ::core::ffi::c_void , options : u32 ) -> super::super::super::Foundation:: BOOL );
    SymEnumSymbolsEx(hprocess.into_param().abi(), baseofdll, mask.into_param().abi(), enumsymbolscallback, ::core::mem::transmute(usercontext.unwrap_or(::std::ptr::null())), options)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymEnumSymbolsExW<P0, P1>(hprocess: P0, baseofdll: u64, mask: P1, enumsymbolscallback: PSYM_ENUMERATESYMBOLS_CALLBACKW, usercontext: ::core::option::Option<*const ::core::ffi::c_void>, options: u32) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymEnumSymbolsExW ( hprocess : super::super::super::Foundation:: HANDLE , baseofdll : u64 , mask : :: windows::core::PCWSTR , enumsymbolscallback : PSYM_ENUMERATESYMBOLS_CALLBACKW , usercontext : *const ::core::ffi::c_void , options : u32 ) -> super::super::super::Foundation:: BOOL );
    SymEnumSymbolsExW(hprocess.into_param().abi(), baseofdll, mask.into_param().abi(), enumsymbolscallback, ::core::mem::transmute(usercontext.unwrap_or(::std::ptr::null())), options)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymEnumSymbolsForAddr<P0>(hprocess: P0, address: u64, enumsymbolscallback: PSYM_ENUMERATESYMBOLS_CALLBACK, usercontext: ::core::option::Option<*const ::core::ffi::c_void>) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymEnumSymbolsForAddr ( hprocess : super::super::super::Foundation:: HANDLE , address : u64 , enumsymbolscallback : PSYM_ENUMERATESYMBOLS_CALLBACK , usercontext : *const ::core::ffi::c_void ) -> super::super::super::Foundation:: BOOL );
    SymEnumSymbolsForAddr(hprocess.into_param().abi(), address, enumsymbolscallback, ::core::mem::transmute(usercontext.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymEnumSymbolsForAddrW<P0>(hprocess: P0, address: u64, enumsymbolscallback: PSYM_ENUMERATESYMBOLS_CALLBACKW, usercontext: ::core::option::Option<*const ::core::ffi::c_void>) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymEnumSymbolsForAddrW ( hprocess : super::super::super::Foundation:: HANDLE , address : u64 , enumsymbolscallback : PSYM_ENUMERATESYMBOLS_CALLBACKW , usercontext : *const ::core::ffi::c_void ) -> super::super::super::Foundation:: BOOL );
    SymEnumSymbolsForAddrW(hprocess.into_param().abi(), address, enumsymbolscallback, ::core::mem::transmute(usercontext.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymEnumSymbolsW<P0, P1>(hprocess: P0, baseofdll: u64, mask: P1, enumsymbolscallback: PSYM_ENUMERATESYMBOLS_CALLBACKW, usercontext: ::core::option::Option<*const ::core::ffi::c_void>) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymEnumSymbolsW ( hprocess : super::super::super::Foundation:: HANDLE , baseofdll : u64 , mask : :: windows::core::PCWSTR , enumsymbolscallback : PSYM_ENUMERATESYMBOLS_CALLBACKW , usercontext : *const ::core::ffi::c_void ) -> super::super::super::Foundation:: BOOL );
    SymEnumSymbolsW(hprocess.into_param().abi(), baseofdll, mask.into_param().abi(), enumsymbolscallback, ::core::mem::transmute(usercontext.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymEnumTypes<P0>(hprocess: P0, baseofdll: u64, enumsymbolscallback: PSYM_ENUMERATESYMBOLS_CALLBACK, usercontext: ::core::option::Option<*const ::core::ffi::c_void>) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymEnumTypes ( hprocess : super::super::super::Foundation:: HANDLE , baseofdll : u64 , enumsymbolscallback : PSYM_ENUMERATESYMBOLS_CALLBACK , usercontext : *const ::core::ffi::c_void ) -> super::super::super::Foundation:: BOOL );
    SymEnumTypes(hprocess.into_param().abi(), baseofdll, enumsymbolscallback, ::core::mem::transmute(usercontext.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymEnumTypesByName<P0, P1>(hprocess: P0, baseofdll: u64, mask: P1, enumsymbolscallback: PSYM_ENUMERATESYMBOLS_CALLBACK, usercontext: ::core::option::Option<*const ::core::ffi::c_void>) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymEnumTypesByName ( hprocess : super::super::super::Foundation:: HANDLE , baseofdll : u64 , mask : :: windows::core::PCSTR , enumsymbolscallback : PSYM_ENUMERATESYMBOLS_CALLBACK , usercontext : *const ::core::ffi::c_void ) -> super::super::super::Foundation:: BOOL );
    SymEnumTypesByName(hprocess.into_param().abi(), baseofdll, mask.into_param().abi(), enumsymbolscallback, ::core::mem::transmute(usercontext.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymEnumTypesByNameW<P0, P1>(hprocess: P0, baseofdll: u64, mask: P1, enumsymbolscallback: PSYM_ENUMERATESYMBOLS_CALLBACKW, usercontext: ::core::option::Option<*const ::core::ffi::c_void>) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymEnumTypesByNameW ( hprocess : super::super::super::Foundation:: HANDLE , baseofdll : u64 , mask : :: windows::core::PCWSTR , enumsymbolscallback : PSYM_ENUMERATESYMBOLS_CALLBACKW , usercontext : *const ::core::ffi::c_void ) -> super::super::super::Foundation:: BOOL );
    SymEnumTypesByNameW(hprocess.into_param().abi(), baseofdll, mask.into_param().abi(), enumsymbolscallback, ::core::mem::transmute(usercontext.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymEnumTypesW<P0>(hprocess: P0, baseofdll: u64, enumsymbolscallback: PSYM_ENUMERATESYMBOLS_CALLBACKW, usercontext: ::core::option::Option<*const ::core::ffi::c_void>) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymEnumTypesW ( hprocess : super::super::super::Foundation:: HANDLE , baseofdll : u64 , enumsymbolscallback : PSYM_ENUMERATESYMBOLS_CALLBACKW , usercontext : *const ::core::ffi::c_void ) -> super::super::super::Foundation:: BOOL );
    SymEnumTypesW(hprocess.into_param().abi(), baseofdll, enumsymbolscallback, ::core::mem::transmute(usercontext.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymEnumerateModules<P0>(hprocess: P0, enummodulescallback: PSYM_ENUMMODULES_CALLBACK, usercontext: ::core::option::Option<*const ::core::ffi::c_void>) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymEnumerateModules ( hprocess : super::super::super::Foundation:: HANDLE , enummodulescallback : PSYM_ENUMMODULES_CALLBACK , usercontext : *const ::core::ffi::c_void ) -> super::super::super::Foundation:: BOOL );
    SymEnumerateModules(hprocess.into_param().abi(), enummodulescallback, ::core::mem::transmute(usercontext.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymEnumerateModules64<P0>(hprocess: P0, enummodulescallback: PSYM_ENUMMODULES_CALLBACK64, usercontext: ::core::option::Option<*const ::core::ffi::c_void>) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymEnumerateModules64 ( hprocess : super::super::super::Foundation:: HANDLE , enummodulescallback : PSYM_ENUMMODULES_CALLBACK64 , usercontext : *const ::core::ffi::c_void ) -> super::super::super::Foundation:: BOOL );
    SymEnumerateModules64(hprocess.into_param().abi(), enummodulescallback, ::core::mem::transmute(usercontext.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymEnumerateModulesW64<P0>(hprocess: P0, enummodulescallback: PSYM_ENUMMODULES_CALLBACKW64, usercontext: ::core::option::Option<*const ::core::ffi::c_void>) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymEnumerateModulesW64 ( hprocess : super::super::super::Foundation:: HANDLE , enummodulescallback : PSYM_ENUMMODULES_CALLBACKW64 , usercontext : *const ::core::ffi::c_void ) -> super::super::super::Foundation:: BOOL );
    SymEnumerateModulesW64(hprocess.into_param().abi(), enummodulescallback, ::core::mem::transmute(usercontext.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymEnumerateSymbols<P0>(hprocess: P0, baseofdll: u32, enumsymbolscallback: PSYM_ENUMSYMBOLS_CALLBACK, usercontext: ::core::option::Option<*const ::core::ffi::c_void>) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymEnumerateSymbols ( hprocess : super::super::super::Foundation:: HANDLE , baseofdll : u32 , enumsymbolscallback : PSYM_ENUMSYMBOLS_CALLBACK , usercontext : *const ::core::ffi::c_void ) -> super::super::super::Foundation:: BOOL );
    SymEnumerateSymbols(hprocess.into_param().abi(), baseofdll, enumsymbolscallback, ::core::mem::transmute(usercontext.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymEnumerateSymbols64<P0>(hprocess: P0, baseofdll: u64, enumsymbolscallback: PSYM_ENUMSYMBOLS_CALLBACK64, usercontext: ::core::option::Option<*const ::core::ffi::c_void>) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymEnumerateSymbols64 ( hprocess : super::super::super::Foundation:: HANDLE , baseofdll : u64 , enumsymbolscallback : PSYM_ENUMSYMBOLS_CALLBACK64 , usercontext : *const ::core::ffi::c_void ) -> super::super::super::Foundation:: BOOL );
    SymEnumerateSymbols64(hprocess.into_param().abi(), baseofdll, enumsymbolscallback, ::core::mem::transmute(usercontext.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymEnumerateSymbolsW<P0>(hprocess: P0, baseofdll: u32, enumsymbolscallback: PSYM_ENUMSYMBOLS_CALLBACKW, usercontext: ::core::option::Option<*const ::core::ffi::c_void>) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymEnumerateSymbolsW ( hprocess : super::super::super::Foundation:: HANDLE , baseofdll : u32 , enumsymbolscallback : PSYM_ENUMSYMBOLS_CALLBACKW , usercontext : *const ::core::ffi::c_void ) -> super::super::super::Foundation:: BOOL );
    SymEnumerateSymbolsW(hprocess.into_param().abi(), baseofdll, enumsymbolscallback, ::core::mem::transmute(usercontext.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymEnumerateSymbolsW64<P0>(hprocess: P0, baseofdll: u64, enumsymbolscallback: PSYM_ENUMSYMBOLS_CALLBACK64W, usercontext: ::core::option::Option<*const ::core::ffi::c_void>) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymEnumerateSymbolsW64 ( hprocess : super::super::super::Foundation:: HANDLE , baseofdll : u64 , enumsymbolscallback : PSYM_ENUMSYMBOLS_CALLBACK64W , usercontext : *const ::core::ffi::c_void ) -> super::super::super::Foundation:: BOOL );
    SymEnumerateSymbolsW64(hprocess.into_param().abi(), baseofdll, enumsymbolscallback, ::core::mem::transmute(usercontext.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymFindDebugInfoFile<P0, P1>(hprocess: P0, filename: P1, debugfilepath: ::windows::core::PSTR, callback: PFIND_DEBUG_FILE_CALLBACK, callerdata: ::core::option::Option<*const ::core::ffi::c_void>) -> ::windows::core::Result<super::super::super::Foundation::HANDLE>
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymFindDebugInfoFile ( hprocess : super::super::super::Foundation:: HANDLE , filename : :: windows::core::PCSTR , debugfilepath : :: windows::core::PSTR , callback : PFIND_DEBUG_FILE_CALLBACK , callerdata : *const ::core::ffi::c_void ) -> super::super::super::Foundation:: HANDLE );
    let result__ = SymFindDebugInfoFile(hprocess.into_param().abi(), filename.into_param().abi(), ::core::mem::transmute(debugfilepath), callback, ::core::mem::transmute(callerdata.unwrap_or(::std::ptr::null())));
    ::windows::imp::then(!result__.is_invalid(), || result__).ok_or_else(::windows::core::Error::from_win32)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymFindDebugInfoFileW<P0, P1>(hprocess: P0, filename: P1, debugfilepath: ::windows::core::PWSTR, callback: PFIND_DEBUG_FILE_CALLBACKW, callerdata: ::core::option::Option<*const ::core::ffi::c_void>) -> ::windows::core::Result<super::super::super::Foundation::HANDLE>
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymFindDebugInfoFileW ( hprocess : super::super::super::Foundation:: HANDLE , filename : :: windows::core::PCWSTR , debugfilepath : :: windows::core::PWSTR , callback : PFIND_DEBUG_FILE_CALLBACKW , callerdata : *const ::core::ffi::c_void ) -> super::super::super::Foundation:: HANDLE );
    let result__ = SymFindDebugInfoFileW(hprocess.into_param().abi(), filename.into_param().abi(), ::core::mem::transmute(debugfilepath), callback, ::core::mem::transmute(callerdata.unwrap_or(::std::ptr::null())));
    ::windows::imp::then(!result__.is_invalid(), || result__).ok_or_else(::windows::core::Error::from_win32)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymFindExecutableImage<P0, P1>(hprocess: P0, filename: P1, imagefilepath: ::windows::core::PSTR, callback: PFIND_EXE_FILE_CALLBACK, callerdata: *const ::core::ffi::c_void) -> ::windows::core::Result<super::super::super::Foundation::HANDLE>
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymFindExecutableImage ( hprocess : super::super::super::Foundation:: HANDLE , filename : :: windows::core::PCSTR , imagefilepath : :: windows::core::PSTR , callback : PFIND_EXE_FILE_CALLBACK , callerdata : *const ::core::ffi::c_void ) -> super::super::super::Foundation:: HANDLE );
    let result__ = SymFindExecutableImage(hprocess.into_param().abi(), filename.into_param().abi(), ::core::mem::transmute(imagefilepath), callback, callerdata);
    ::windows::imp::then(!result__.is_invalid(), || result__).ok_or_else(::windows::core::Error::from_win32)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymFindExecutableImageW<P0, P1>(hprocess: P0, filename: P1, imagefilepath: ::windows::core::PWSTR, callback: PFIND_EXE_FILE_CALLBACKW, callerdata: *const ::core::ffi::c_void) -> ::windows::core::Result<super::super::super::Foundation::HANDLE>
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymFindExecutableImageW ( hprocess : super::super::super::Foundation:: HANDLE , filename : :: windows::core::PCWSTR , imagefilepath : :: windows::core::PWSTR , callback : PFIND_EXE_FILE_CALLBACKW , callerdata : *const ::core::ffi::c_void ) -> super::super::super::Foundation:: HANDLE );
    let result__ = SymFindExecutableImageW(hprocess.into_param().abi(), filename.into_param().abi(), ::core::mem::transmute(imagefilepath), callback, callerdata);
    ::windows::imp::then(!result__.is_invalid(), || result__).ok_or_else(::windows::core::Error::from_win32)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymFindFileInPath<P0, P1, P2>(hprocess: P0, searchpatha: P1, filename: P2, id: ::core::option::Option<*const ::core::ffi::c_void>, two: u32, three: u32, flags: SYM_FIND_ID_OPTION, foundfile: ::windows::core::PSTR, callback: PFINDFILEINPATHCALLBACK, context: ::core::option::Option<*const ::core::ffi::c_void>) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P2: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymFindFileInPath ( hprocess : super::super::super::Foundation:: HANDLE , searchpatha : :: windows::core::PCSTR , filename : :: windows::core::PCSTR , id : *const ::core::ffi::c_void , two : u32 , three : u32 , flags : SYM_FIND_ID_OPTION , foundfile : :: windows::core::PSTR , callback : PFINDFILEINPATHCALLBACK , context : *const ::core::ffi::c_void ) -> super::super::super::Foundation:: BOOL );
    SymFindFileInPath(hprocess.into_param().abi(), searchpatha.into_param().abi(), filename.into_param().abi(), ::core::mem::transmute(id.unwrap_or(::std::ptr::null())), two, three, flags, ::core::mem::transmute(foundfile), callback, ::core::mem::transmute(context.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymFindFileInPathW<P0, P1, P2>(hprocess: P0, searchpatha: P1, filename: P2, id: ::core::option::Option<*const ::core::ffi::c_void>, two: u32, three: u32, flags: SYM_FIND_ID_OPTION, foundfile: ::windows::core::PWSTR, callback: PFINDFILEINPATHCALLBACKW, context: ::core::option::Option<*const ::core::ffi::c_void>) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    P2: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymFindFileInPathW ( hprocess : super::super::super::Foundation:: HANDLE , searchpatha : :: windows::core::PCWSTR , filename : :: windows::core::PCWSTR , id : *const ::core::ffi::c_void , two : u32 , three : u32 , flags : SYM_FIND_ID_OPTION , foundfile : :: windows::core::PWSTR , callback : PFINDFILEINPATHCALLBACKW , context : *const ::core::ffi::c_void ) -> super::super::super::Foundation:: BOOL );
    SymFindFileInPathW(hprocess.into_param().abi(), searchpatha.into_param().abi(), filename.into_param().abi(), ::core::mem::transmute(id.unwrap_or(::std::ptr::null())), two, three, flags, ::core::mem::transmute(foundfile), callback, ::core::mem::transmute(context.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymFromAddr<P0>(hprocess: P0, address: u64, displacement: ::core::option::Option<*mut u64>, symbol: *mut SYMBOL_INFO) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymFromAddr ( hprocess : super::super::super::Foundation:: HANDLE , address : u64 , displacement : *mut u64 , symbol : *mut SYMBOL_INFO ) -> super::super::super::Foundation:: BOOL );
    SymFromAddr(hprocess.into_param().abi(), address, ::core::mem::transmute(displacement.unwrap_or(::std::ptr::null_mut())), symbol)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymFromAddrW<P0>(hprocess: P0, address: u64, displacement: ::core::option::Option<*mut u64>, symbol: *mut SYMBOL_INFOW) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymFromAddrW ( hprocess : super::super::super::Foundation:: HANDLE , address : u64 , displacement : *mut u64 , symbol : *mut SYMBOL_INFOW ) -> super::super::super::Foundation:: BOOL );
    SymFromAddrW(hprocess.into_param().abi(), address, ::core::mem::transmute(displacement.unwrap_or(::std::ptr::null_mut())), symbol)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymFromIndex<P0>(hprocess: P0, baseofdll: u64, index: u32, symbol: *mut SYMBOL_INFO) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymFromIndex ( hprocess : super::super::super::Foundation:: HANDLE , baseofdll : u64 , index : u32 , symbol : *mut SYMBOL_INFO ) -> super::super::super::Foundation:: BOOL );
    SymFromIndex(hprocess.into_param().abi(), baseofdll, index, symbol)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymFromIndexW<P0>(hprocess: P0, baseofdll: u64, index: u32, symbol: *mut SYMBOL_INFOW) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymFromIndexW ( hprocess : super::super::super::Foundation:: HANDLE , baseofdll : u64 , index : u32 , symbol : *mut SYMBOL_INFOW ) -> super::super::super::Foundation:: BOOL );
    SymFromIndexW(hprocess.into_param().abi(), baseofdll, index, symbol)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymFromInlineContext<P0>(hprocess: P0, address: u64, inlinecontext: u32, displacement: ::core::option::Option<*mut u64>, symbol: *mut SYMBOL_INFO) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymFromInlineContext ( hprocess : super::super::super::Foundation:: HANDLE , address : u64 , inlinecontext : u32 , displacement : *mut u64 , symbol : *mut SYMBOL_INFO ) -> super::super::super::Foundation:: BOOL );
    SymFromInlineContext(hprocess.into_param().abi(), address, inlinecontext, ::core::mem::transmute(displacement.unwrap_or(::std::ptr::null_mut())), symbol)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymFromInlineContextW<P0>(hprocess: P0, address: u64, inlinecontext: u32, displacement: ::core::option::Option<*mut u64>, symbol: *mut SYMBOL_INFOW) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymFromInlineContextW ( hprocess : super::super::super::Foundation:: HANDLE , address : u64 , inlinecontext : u32 , displacement : *mut u64 , symbol : *mut SYMBOL_INFOW ) -> super::super::super::Foundation:: BOOL );
    SymFromInlineContextW(hprocess.into_param().abi(), address, inlinecontext, ::core::mem::transmute(displacement.unwrap_or(::std::ptr::null_mut())), symbol)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymFromName<P0, P1>(hprocess: P0, name: P1, symbol: *mut SYMBOL_INFO) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymFromName ( hprocess : super::super::super::Foundation:: HANDLE , name : :: windows::core::PCSTR , symbol : *mut SYMBOL_INFO ) -> super::super::super::Foundation:: BOOL );
    SymFromName(hprocess.into_param().abi(), name.into_param().abi(), symbol)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymFromNameW<P0, P1>(hprocess: P0, name: P1, symbol: *mut SYMBOL_INFOW) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymFromNameW ( hprocess : super::super::super::Foundation:: HANDLE , name : :: windows::core::PCWSTR , symbol : *mut SYMBOL_INFOW ) -> super::super::super::Foundation:: BOOL );
    SymFromNameW(hprocess.into_param().abi(), name.into_param().abi(), symbol)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymFromToken<P0>(hprocess: P0, base: u64, token: u32, symbol: *mut SYMBOL_INFO) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymFromToken ( hprocess : super::super::super::Foundation:: HANDLE , base : u64 , token : u32 , symbol : *mut SYMBOL_INFO ) -> super::super::super::Foundation:: BOOL );
    SymFromToken(hprocess.into_param().abi(), base, token, symbol)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymFromTokenW<P0>(hprocess: P0, base: u64, token: u32, symbol: *mut SYMBOL_INFOW) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymFromTokenW ( hprocess : super::super::super::Foundation:: HANDLE , base : u64 , token : u32 , symbol : *mut SYMBOL_INFOW ) -> super::super::super::Foundation:: BOOL );
    SymFromTokenW(hprocess.into_param().abi(), base, token, symbol)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymFunctionTableAccess<P0>(hprocess: P0, addrbase: u32) -> *mut ::core::ffi::c_void
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymFunctionTableAccess ( hprocess : super::super::super::Foundation:: HANDLE , addrbase : u32 ) -> *mut ::core::ffi::c_void );
    SymFunctionTableAccess(hprocess.into_param().abi(), addrbase)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymFunctionTableAccess64<P0>(hprocess: P0, addrbase: u64) -> *mut ::core::ffi::c_void
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymFunctionTableAccess64 ( hprocess : super::super::super::Foundation:: HANDLE , addrbase : u64 ) -> *mut ::core::ffi::c_void );
    SymFunctionTableAccess64(hprocess.into_param().abi(), addrbase)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymFunctionTableAccess64AccessRoutines<P0>(hprocess: P0, addrbase: u64, readmemoryroutine: PREAD_PROCESS_MEMORY_ROUTINE64, getmodulebaseroutine: PGET_MODULE_BASE_ROUTINE64) -> *mut ::core::ffi::c_void
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymFunctionTableAccess64AccessRoutines ( hprocess : super::super::super::Foundation:: HANDLE , addrbase : u64 , readmemoryroutine : PREAD_PROCESS_MEMORY_ROUTINE64 , getmodulebaseroutine : PGET_MODULE_BASE_ROUTINE64 ) -> *mut ::core::ffi::c_void );
    SymFunctionTableAccess64AccessRoutines(hprocess.into_param().abi(), addrbase, readmemoryroutine, getmodulebaseroutine)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymGetExtendedOption(option: IMAGEHLP_EXTENDED_OPTIONS) -> super::super::super::Foundation::BOOL {
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymGetExtendedOption ( option : IMAGEHLP_EXTENDED_OPTIONS ) -> super::super::super::Foundation:: BOOL );
    SymGetExtendedOption(option)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymGetFileLineOffsets64<P0, P1, P2>(hprocess: P0, modulename: P1, filename: P2, buffer: &mut [u64]) -> u32
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P2: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymGetFileLineOffsets64 ( hprocess : super::super::super::Foundation:: HANDLE , modulename : :: windows::core::PCSTR , filename : :: windows::core::PCSTR , buffer : *mut u64 , bufferlines : u32 ) -> u32 );
    SymGetFileLineOffsets64(hprocess.into_param().abi(), modulename.into_param().abi(), filename.into_param().abi(), ::core::mem::transmute(buffer.as_ptr()), buffer.len() as _)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[inline]
pub unsafe fn SymGetHomeDirectory(r#type: IMAGEHLP_HD_TYPE, dir: &mut [u8]) -> ::windows::core::PSTR {
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymGetHomeDirectory ( r#type : IMAGEHLP_HD_TYPE , dir : :: windows::core::PSTR , size : usize ) -> :: windows::core::PSTR );
    SymGetHomeDirectory(r#type, ::core::mem::transmute(dir.as_ptr()), dir.len() as _)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[inline]
pub unsafe fn SymGetHomeDirectoryW(r#type: IMAGEHLP_HD_TYPE, dir: &mut [u16]) -> ::windows::core::PWSTR {
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymGetHomeDirectoryW ( r#type : IMAGEHLP_HD_TYPE , dir : :: windows::core::PWSTR , size : usize ) -> :: windows::core::PWSTR );
    SymGetHomeDirectoryW(r#type, ::core::mem::transmute(dir.as_ptr()), dir.len() as _)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymGetLineFromAddr<P0>(hprocess: P0, dwaddr: u32, pdwdisplacement: *mut u32, line: *mut IMAGEHLP_LINE) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymGetLineFromAddr ( hprocess : super::super::super::Foundation:: HANDLE , dwaddr : u32 , pdwdisplacement : *mut u32 , line : *mut IMAGEHLP_LINE ) -> super::super::super::Foundation:: BOOL );
    SymGetLineFromAddr(hprocess.into_param().abi(), dwaddr, pdwdisplacement, line)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymGetLineFromAddr64<P0>(hprocess: P0, qwaddr: u64, pdwdisplacement: *mut u32, line64: *mut IMAGEHLP_LINE64) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymGetLineFromAddr64 ( hprocess : super::super::super::Foundation:: HANDLE , qwaddr : u64 , pdwdisplacement : *mut u32 , line64 : *mut IMAGEHLP_LINE64 ) -> super::super::super::Foundation:: BOOL );
    SymGetLineFromAddr64(hprocess.into_param().abi(), qwaddr, pdwdisplacement, line64)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymGetLineFromAddrW64<P0>(hprocess: P0, dwaddr: u64, pdwdisplacement: *mut u32, line: *mut IMAGEHLP_LINEW64) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymGetLineFromAddrW64 ( hprocess : super::super::super::Foundation:: HANDLE , dwaddr : u64 , pdwdisplacement : *mut u32 , line : *mut IMAGEHLP_LINEW64 ) -> super::super::super::Foundation:: BOOL );
    SymGetLineFromAddrW64(hprocess.into_param().abi(), dwaddr, pdwdisplacement, line)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymGetLineFromInlineContext<P0>(hprocess: P0, qwaddr: u64, inlinecontext: u32, qwmodulebaseaddress: u64, pdwdisplacement: *mut u32, line64: *mut IMAGEHLP_LINE64) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymGetLineFromInlineContext ( hprocess : super::super::super::Foundation:: HANDLE , qwaddr : u64 , inlinecontext : u32 , qwmodulebaseaddress : u64 , pdwdisplacement : *mut u32 , line64 : *mut IMAGEHLP_LINE64 ) -> super::super::super::Foundation:: BOOL );
    SymGetLineFromInlineContext(hprocess.into_param().abi(), qwaddr, inlinecontext, qwmodulebaseaddress, pdwdisplacement, line64)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymGetLineFromInlineContextW<P0>(hprocess: P0, dwaddr: u64, inlinecontext: u32, qwmodulebaseaddress: u64, pdwdisplacement: *mut u32, line: *mut IMAGEHLP_LINEW64) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymGetLineFromInlineContextW ( hprocess : super::super::super::Foundation:: HANDLE , dwaddr : u64 , inlinecontext : u32 , qwmodulebaseaddress : u64 , pdwdisplacement : *mut u32 , line : *mut IMAGEHLP_LINEW64 ) -> super::super::super::Foundation:: BOOL );
    SymGetLineFromInlineContextW(hprocess.into_param().abi(), dwaddr, inlinecontext, qwmodulebaseaddress, pdwdisplacement, line)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymGetLineFromName<P0, P1, P2>(hprocess: P0, modulename: P1, filename: P2, dwlinenumber: u32, pldisplacement: *mut i32, line: *mut IMAGEHLP_LINE) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P2: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymGetLineFromName ( hprocess : super::super::super::Foundation:: HANDLE , modulename : :: windows::core::PCSTR , filename : :: windows::core::PCSTR , dwlinenumber : u32 , pldisplacement : *mut i32 , line : *mut IMAGEHLP_LINE ) -> super::super::super::Foundation:: BOOL );
    SymGetLineFromName(hprocess.into_param().abi(), modulename.into_param().abi(), filename.into_param().abi(), dwlinenumber, pldisplacement, line)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymGetLineFromName64<P0, P1, P2>(hprocess: P0, modulename: P1, filename: P2, dwlinenumber: u32, pldisplacement: *mut i32, line: *mut IMAGEHLP_LINE64) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P2: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymGetLineFromName64 ( hprocess : super::super::super::Foundation:: HANDLE , modulename : :: windows::core::PCSTR , filename : :: windows::core::PCSTR , dwlinenumber : u32 , pldisplacement : *mut i32 , line : *mut IMAGEHLP_LINE64 ) -> super::super::super::Foundation:: BOOL );
    SymGetLineFromName64(hprocess.into_param().abi(), modulename.into_param().abi(), filename.into_param().abi(), dwlinenumber, pldisplacement, line)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymGetLineFromNameW64<P0, P1, P2>(hprocess: P0, modulename: P1, filename: P2, dwlinenumber: u32, pldisplacement: *mut i32, line: *mut IMAGEHLP_LINEW64) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    P2: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymGetLineFromNameW64 ( hprocess : super::super::super::Foundation:: HANDLE , modulename : :: windows::core::PCWSTR , filename : :: windows::core::PCWSTR , dwlinenumber : u32 , pldisplacement : *mut i32 , line : *mut IMAGEHLP_LINEW64 ) -> super::super::super::Foundation:: BOOL );
    SymGetLineFromNameW64(hprocess.into_param().abi(), modulename.into_param().abi(), filename.into_param().abi(), dwlinenumber, pldisplacement, line)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymGetLineNext<P0>(hprocess: P0, line: *mut IMAGEHLP_LINE) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymGetLineNext ( hprocess : super::super::super::Foundation:: HANDLE , line : *mut IMAGEHLP_LINE ) -> super::super::super::Foundation:: BOOL );
    SymGetLineNext(hprocess.into_param().abi(), line)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymGetLineNext64<P0>(hprocess: P0, line: *mut IMAGEHLP_LINE64) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymGetLineNext64 ( hprocess : super::super::super::Foundation:: HANDLE , line : *mut IMAGEHLP_LINE64 ) -> super::super::super::Foundation:: BOOL );
    SymGetLineNext64(hprocess.into_param().abi(), line)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymGetLineNextW64<P0>(hprocess: P0, line: *mut IMAGEHLP_LINEW64) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymGetLineNextW64 ( hprocess : super::super::super::Foundation:: HANDLE , line : *mut IMAGEHLP_LINEW64 ) -> super::super::super::Foundation:: BOOL );
    SymGetLineNextW64(hprocess.into_param().abi(), line)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymGetLinePrev<P0>(hprocess: P0, line: *mut IMAGEHLP_LINE) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymGetLinePrev ( hprocess : super::super::super::Foundation:: HANDLE , line : *mut IMAGEHLP_LINE ) -> super::super::super::Foundation:: BOOL );
    SymGetLinePrev(hprocess.into_param().abi(), line)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymGetLinePrev64<P0>(hprocess: P0, line: *mut IMAGEHLP_LINE64) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymGetLinePrev64 ( hprocess : super::super::super::Foundation:: HANDLE , line : *mut IMAGEHLP_LINE64 ) -> super::super::super::Foundation:: BOOL );
    SymGetLinePrev64(hprocess.into_param().abi(), line)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymGetLinePrevW64<P0>(hprocess: P0, line: *mut IMAGEHLP_LINEW64) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymGetLinePrevW64 ( hprocess : super::super::super::Foundation:: HANDLE , line : *mut IMAGEHLP_LINEW64 ) -> super::super::super::Foundation:: BOOL );
    SymGetLinePrevW64(hprocess.into_param().abi(), line)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymGetModuleBase<P0>(hprocess: P0, dwaddr: u32) -> u32
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymGetModuleBase ( hprocess : super::super::super::Foundation:: HANDLE , dwaddr : u32 ) -> u32 );
    SymGetModuleBase(hprocess.into_param().abi(), dwaddr)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymGetModuleBase64<P0>(hprocess: P0, qwaddr: u64) -> u64
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymGetModuleBase64 ( hprocess : super::super::super::Foundation:: HANDLE , qwaddr : u64 ) -> u64 );
    SymGetModuleBase64(hprocess.into_param().abi(), qwaddr)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymGetModuleInfo<P0>(hprocess: P0, dwaddr: u32, moduleinfo: *mut IMAGEHLP_MODULE) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymGetModuleInfo ( hprocess : super::super::super::Foundation:: HANDLE , dwaddr : u32 , moduleinfo : *mut IMAGEHLP_MODULE ) -> super::super::super::Foundation:: BOOL );
    SymGetModuleInfo(hprocess.into_param().abi(), dwaddr, moduleinfo)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymGetModuleInfo64<P0>(hprocess: P0, qwaddr: u64, moduleinfo: *mut IMAGEHLP_MODULE64) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymGetModuleInfo64 ( hprocess : super::super::super::Foundation:: HANDLE , qwaddr : u64 , moduleinfo : *mut IMAGEHLP_MODULE64 ) -> super::super::super::Foundation:: BOOL );
    SymGetModuleInfo64(hprocess.into_param().abi(), qwaddr, moduleinfo)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymGetModuleInfoW<P0>(hprocess: P0, dwaddr: u32, moduleinfo: *mut IMAGEHLP_MODULEW) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymGetModuleInfoW ( hprocess : super::super::super::Foundation:: HANDLE , dwaddr : u32 , moduleinfo : *mut IMAGEHLP_MODULEW ) -> super::super::super::Foundation:: BOOL );
    SymGetModuleInfoW(hprocess.into_param().abi(), dwaddr, moduleinfo)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymGetModuleInfoW64<P0>(hprocess: P0, qwaddr: u64, moduleinfo: *mut IMAGEHLP_MODULEW64) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymGetModuleInfoW64 ( hprocess : super::super::super::Foundation:: HANDLE , qwaddr : u64 , moduleinfo : *mut IMAGEHLP_MODULEW64 ) -> super::super::super::Foundation:: BOOL );
    SymGetModuleInfoW64(hprocess.into_param().abi(), qwaddr, moduleinfo)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymGetOmaps<P0>(hprocess: P0, baseofdll: u64, omapto: *mut *mut OMAP, comapto: *mut u64, omapfrom: *mut *mut OMAP, comapfrom: *mut u64) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymGetOmaps ( hprocess : super::super::super::Foundation:: HANDLE , baseofdll : u64 , omapto : *mut *mut OMAP , comapto : *mut u64 , omapfrom : *mut *mut OMAP , comapfrom : *mut u64 ) -> super::super::super::Foundation:: BOOL );
    SymGetOmaps(hprocess.into_param().abi(), baseofdll, omapto, comapto, omapfrom, comapfrom)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[inline]
pub unsafe fn SymGetOptions() -> u32 {
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymGetOptions ( ) -> u32 );
    SymGetOptions()
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymGetScope<P0>(hprocess: P0, baseofdll: u64, index: u32, symbol: *mut SYMBOL_INFO) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymGetScope ( hprocess : super::super::super::Foundation:: HANDLE , baseofdll : u64 , index : u32 , symbol : *mut SYMBOL_INFO ) -> super::super::super::Foundation:: BOOL );
    SymGetScope(hprocess.into_param().abi(), baseofdll, index, symbol)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymGetScopeW<P0>(hprocess: P0, baseofdll: u64, index: u32, symbol: *mut SYMBOL_INFOW) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymGetScopeW ( hprocess : super::super::super::Foundation:: HANDLE , baseofdll : u64 , index : u32 , symbol : *mut SYMBOL_INFOW ) -> super::super::super::Foundation:: BOOL );
    SymGetScopeW(hprocess.into_param().abi(), baseofdll, index, symbol)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymGetSearchPath<P0>(hprocess: P0, searchpatha: &mut [u8]) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymGetSearchPath ( hprocess : super::super::super::Foundation:: HANDLE , searchpatha : :: windows::core::PSTR , searchpathlength : u32 ) -> super::super::super::Foundation:: BOOL );
    SymGetSearchPath(hprocess.into_param().abi(), ::core::mem::transmute(searchpatha.as_ptr()), searchpatha.len() as _)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymGetSearchPathW<P0>(hprocess: P0, searchpatha: &mut [u16]) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymGetSearchPathW ( hprocess : super::super::super::Foundation:: HANDLE , searchpatha : :: windows::core::PWSTR , searchpathlength : u32 ) -> super::super::super::Foundation:: BOOL );
    SymGetSearchPathW(hprocess.into_param().abi(), ::core::mem::transmute(searchpatha.as_ptr()), searchpatha.len() as _)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymGetSourceFile<P0, P1, P2>(hprocess: P0, base: u64, params: P1, filespec: P2, filepath: &mut [u8]) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P2: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymGetSourceFile ( hprocess : super::super::super::Foundation:: HANDLE , base : u64 , params : :: windows::core::PCSTR , filespec : :: windows::core::PCSTR , filepath : :: windows::core::PSTR , size : u32 ) -> super::super::super::Foundation:: BOOL );
    SymGetSourceFile(hprocess.into_param().abi(), base, params.into_param().abi(), filespec.into_param().abi(), ::core::mem::transmute(filepath.as_ptr()), filepath.len() as _)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymGetSourceFileChecksum<P0, P1>(hprocess: P0, base: u64, filespec: P1, pchecksumtype: *mut u32, pchecksum: &mut [u8], pactualbyteswritten: *mut u32) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymGetSourceFileChecksum ( hprocess : super::super::super::Foundation:: HANDLE , base : u64 , filespec : :: windows::core::PCSTR , pchecksumtype : *mut u32 , pchecksum : *mut u8 , checksumsize : u32 , pactualbyteswritten : *mut u32 ) -> super::super::super::Foundation:: BOOL );
    SymGetSourceFileChecksum(hprocess.into_param().abi(), base, filespec.into_param().abi(), pchecksumtype, ::core::mem::transmute(pchecksum.as_ptr()), pchecksum.len() as _, pactualbyteswritten)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymGetSourceFileChecksumW<P0, P1>(hprocess: P0, base: u64, filespec: P1, pchecksumtype: *mut u32, pchecksum: &mut [u8], pactualbyteswritten: *mut u32) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymGetSourceFileChecksumW ( hprocess : super::super::super::Foundation:: HANDLE , base : u64 , filespec : :: windows::core::PCWSTR , pchecksumtype : *mut u32 , pchecksum : *mut u8 , checksumsize : u32 , pactualbyteswritten : *mut u32 ) -> super::super::super::Foundation:: BOOL );
    SymGetSourceFileChecksumW(hprocess.into_param().abi(), base, filespec.into_param().abi(), pchecksumtype, ::core::mem::transmute(pchecksum.as_ptr()), pchecksum.len() as _, pactualbyteswritten)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymGetSourceFileFromToken<P0, P1>(hprocess: P0, token: *const ::core::ffi::c_void, params: P1, filepath: &mut [u8]) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymGetSourceFileFromToken ( hprocess : super::super::super::Foundation:: HANDLE , token : *const ::core::ffi::c_void , params : :: windows::core::PCSTR , filepath : :: windows::core::PSTR , size : u32 ) -> super::super::super::Foundation:: BOOL );
    SymGetSourceFileFromToken(hprocess.into_param().abi(), token, params.into_param().abi(), ::core::mem::transmute(filepath.as_ptr()), filepath.len() as _)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymGetSourceFileFromTokenByTokenName<P0, P1, P2>(hprocess: P0, token: *const ::core::ffi::c_void, tokenname: P1, params: P2, filepath: &mut [u8]) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P2: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymGetSourceFileFromTokenByTokenName ( hprocess : super::super::super::Foundation:: HANDLE , token : *const ::core::ffi::c_void , tokenname : :: windows::core::PCSTR , params : :: windows::core::PCSTR , filepath : :: windows::core::PSTR , size : u32 ) -> super::super::super::Foundation:: BOOL );
    SymGetSourceFileFromTokenByTokenName(hprocess.into_param().abi(), token, tokenname.into_param().abi(), params.into_param().abi(), ::core::mem::transmute(filepath.as_ptr()), filepath.len() as _)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymGetSourceFileFromTokenByTokenNameW<P0, P1, P2>(hprocess: P0, token: *const ::core::ffi::c_void, tokenname: P1, params: P2, filepath: &mut [u16]) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    P2: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymGetSourceFileFromTokenByTokenNameW ( hprocess : super::super::super::Foundation:: HANDLE , token : *const ::core::ffi::c_void , tokenname : :: windows::core::PCWSTR , params : :: windows::core::PCWSTR , filepath : :: windows::core::PWSTR , size : u32 ) -> super::super::super::Foundation:: BOOL );
    SymGetSourceFileFromTokenByTokenNameW(hprocess.into_param().abi(), token, tokenname.into_param().abi(), params.into_param().abi(), ::core::mem::transmute(filepath.as_ptr()), filepath.len() as _)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymGetSourceFileFromTokenW<P0, P1>(hprocess: P0, token: *const ::core::ffi::c_void, params: P1, filepath: &mut [u16]) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymGetSourceFileFromTokenW ( hprocess : super::super::super::Foundation:: HANDLE , token : *const ::core::ffi::c_void , params : :: windows::core::PCWSTR , filepath : :: windows::core::PWSTR , size : u32 ) -> super::super::super::Foundation:: BOOL );
    SymGetSourceFileFromTokenW(hprocess.into_param().abi(), token, params.into_param().abi(), ::core::mem::transmute(filepath.as_ptr()), filepath.len() as _)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymGetSourceFileToken<P0, P1>(hprocess: P0, base: u64, filespec: P1, token: *mut *mut ::core::ffi::c_void, size: *mut u32) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymGetSourceFileToken ( hprocess : super::super::super::Foundation:: HANDLE , base : u64 , filespec : :: windows::core::PCSTR , token : *mut *mut ::core::ffi::c_void , size : *mut u32 ) -> super::super::super::Foundation:: BOOL );
    SymGetSourceFileToken(hprocess.into_param().abi(), base, filespec.into_param().abi(), token, size)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymGetSourceFileTokenByTokenName<P0, P1, P2, P3>(hprocess: P0, base: u64, filespec: P1, tokenname: P2, tokenparameters: P3, token: *mut *mut ::core::ffi::c_void, size: *mut u32) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P2: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P3: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymGetSourceFileTokenByTokenName ( hprocess : super::super::super::Foundation:: HANDLE , base : u64 , filespec : :: windows::core::PCSTR , tokenname : :: windows::core::PCSTR , tokenparameters : :: windows::core::PCSTR , token : *mut *mut ::core::ffi::c_void , size : *mut u32 ) -> super::super::super::Foundation:: BOOL );
    SymGetSourceFileTokenByTokenName(hprocess.into_param().abi(), base, filespec.into_param().abi(), tokenname.into_param().abi(), tokenparameters.into_param().abi(), token, size)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymGetSourceFileTokenByTokenNameW<P0, P1, P2, P3>(hprocess: P0, base: u64, filespec: P1, tokenname: P2, tokenparameters: P3, token: *mut *mut ::core::ffi::c_void, size: *mut u32) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    P2: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    P3: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymGetSourceFileTokenByTokenNameW ( hprocess : super::super::super::Foundation:: HANDLE , base : u64 , filespec : :: windows::core::PCWSTR , tokenname : :: windows::core::PCWSTR , tokenparameters : :: windows::core::PCWSTR , token : *mut *mut ::core::ffi::c_void , size : *mut u32 ) -> super::super::super::Foundation:: BOOL );
    SymGetSourceFileTokenByTokenNameW(hprocess.into_param().abi(), base, filespec.into_param().abi(), tokenname.into_param().abi(), tokenparameters.into_param().abi(), token, size)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymGetSourceFileTokenW<P0, P1>(hprocess: P0, base: u64, filespec: P1, token: *mut *mut ::core::ffi::c_void, size: *mut u32) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymGetSourceFileTokenW ( hprocess : super::super::super::Foundation:: HANDLE , base : u64 , filespec : :: windows::core::PCWSTR , token : *mut *mut ::core::ffi::c_void , size : *mut u32 ) -> super::super::super::Foundation:: BOOL );
    SymGetSourceFileTokenW(hprocess.into_param().abi(), base, filespec.into_param().abi(), token, size)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymGetSourceFileW<P0, P1, P2>(hprocess: P0, base: u64, params: P1, filespec: P2, filepath: &mut [u16]) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    P2: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymGetSourceFileW ( hprocess : super::super::super::Foundation:: HANDLE , base : u64 , params : :: windows::core::PCWSTR , filespec : :: windows::core::PCWSTR , filepath : :: windows::core::PWSTR , size : u32 ) -> super::super::super::Foundation:: BOOL );
    SymGetSourceFileW(hprocess.into_param().abi(), base, params.into_param().abi(), filespec.into_param().abi(), ::core::mem::transmute(filepath.as_ptr()), filepath.len() as _)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymGetSourceVarFromToken<P0, P1, P2>(hprocess: P0, token: *const ::core::ffi::c_void, params: P1, varname: P2, value: &mut [u8]) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P2: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymGetSourceVarFromToken ( hprocess : super::super::super::Foundation:: HANDLE , token : *const ::core::ffi::c_void , params : :: windows::core::PCSTR , varname : :: windows::core::PCSTR , value : :: windows::core::PSTR , size : u32 ) -> super::super::super::Foundation:: BOOL );
    SymGetSourceVarFromToken(hprocess.into_param().abi(), token, params.into_param().abi(), varname.into_param().abi(), ::core::mem::transmute(value.as_ptr()), value.len() as _)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymGetSourceVarFromTokenW<P0, P1, P2>(hprocess: P0, token: *const ::core::ffi::c_void, params: P1, varname: P2, value: &mut [u16]) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    P2: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymGetSourceVarFromTokenW ( hprocess : super::super::super::Foundation:: HANDLE , token : *const ::core::ffi::c_void , params : :: windows::core::PCWSTR , varname : :: windows::core::PCWSTR , value : :: windows::core::PWSTR , size : u32 ) -> super::super::super::Foundation:: BOOL );
    SymGetSourceVarFromTokenW(hprocess.into_param().abi(), token, params.into_param().abi(), varname.into_param().abi(), ::core::mem::transmute(value.as_ptr()), value.len() as _)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymGetSymFromAddr<P0>(hprocess: P0, dwaddr: u32, pdwdisplacement: ::core::option::Option<*mut u32>, symbol: *mut IMAGEHLP_SYMBOL) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymGetSymFromAddr ( hprocess : super::super::super::Foundation:: HANDLE , dwaddr : u32 , pdwdisplacement : *mut u32 , symbol : *mut IMAGEHLP_SYMBOL ) -> super::super::super::Foundation:: BOOL );
    SymGetSymFromAddr(hprocess.into_param().abi(), dwaddr, ::core::mem::transmute(pdwdisplacement.unwrap_or(::std::ptr::null_mut())), symbol)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymGetSymFromAddr64<P0>(hprocess: P0, qwaddr: u64, pdwdisplacement: ::core::option::Option<*mut u64>, symbol: *mut IMAGEHLP_SYMBOL64) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymGetSymFromAddr64 ( hprocess : super::super::super::Foundation:: HANDLE , qwaddr : u64 , pdwdisplacement : *mut u64 , symbol : *mut IMAGEHLP_SYMBOL64 ) -> super::super::super::Foundation:: BOOL );
    SymGetSymFromAddr64(hprocess.into_param().abi(), qwaddr, ::core::mem::transmute(pdwdisplacement.unwrap_or(::std::ptr::null_mut())), symbol)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymGetSymFromName<P0, P1>(hprocess: P0, name: P1, symbol: *mut IMAGEHLP_SYMBOL) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymGetSymFromName ( hprocess : super::super::super::Foundation:: HANDLE , name : :: windows::core::PCSTR , symbol : *mut IMAGEHLP_SYMBOL ) -> super::super::super::Foundation:: BOOL );
    SymGetSymFromName(hprocess.into_param().abi(), name.into_param().abi(), symbol)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymGetSymFromName64<P0, P1>(hprocess: P0, name: P1, symbol: *mut IMAGEHLP_SYMBOL64) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymGetSymFromName64 ( hprocess : super::super::super::Foundation:: HANDLE , name : :: windows::core::PCSTR , symbol : *mut IMAGEHLP_SYMBOL64 ) -> super::super::super::Foundation:: BOOL );
    SymGetSymFromName64(hprocess.into_param().abi(), name.into_param().abi(), symbol)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymGetSymNext<P0>(hprocess: P0, symbol: *mut IMAGEHLP_SYMBOL) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymGetSymNext ( hprocess : super::super::super::Foundation:: HANDLE , symbol : *mut IMAGEHLP_SYMBOL ) -> super::super::super::Foundation:: BOOL );
    SymGetSymNext(hprocess.into_param().abi(), symbol)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymGetSymNext64<P0>(hprocess: P0, symbol: *mut IMAGEHLP_SYMBOL64) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymGetSymNext64 ( hprocess : super::super::super::Foundation:: HANDLE , symbol : *mut IMAGEHLP_SYMBOL64 ) -> super::super::super::Foundation:: BOOL );
    SymGetSymNext64(hprocess.into_param().abi(), symbol)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymGetSymPrev<P0>(hprocess: P0, symbol: *mut IMAGEHLP_SYMBOL) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymGetSymPrev ( hprocess : super::super::super::Foundation:: HANDLE , symbol : *mut IMAGEHLP_SYMBOL ) -> super::super::super::Foundation:: BOOL );
    SymGetSymPrev(hprocess.into_param().abi(), symbol)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymGetSymPrev64<P0>(hprocess: P0, symbol: *mut IMAGEHLP_SYMBOL64) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymGetSymPrev64 ( hprocess : super::super::super::Foundation:: HANDLE , symbol : *mut IMAGEHLP_SYMBOL64 ) -> super::super::super::Foundation:: BOOL );
    SymGetSymPrev64(hprocess.into_param().abi(), symbol)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymGetSymbolFile<P0, P1, P2>(hprocess: P0, sympath: P1, imagefile: P2, r#type: IMAGEHLP_SF_TYPE, symbolfile: &mut [u8], dbgfile: &mut [u8]) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P2: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymGetSymbolFile ( hprocess : super::super::super::Foundation:: HANDLE , sympath : :: windows::core::PCSTR , imagefile : :: windows::core::PCSTR , r#type : IMAGEHLP_SF_TYPE , symbolfile : :: windows::core::PSTR , csymbolfile : usize , dbgfile : :: windows::core::PSTR , cdbgfile : usize ) -> super::super::super::Foundation:: BOOL );
    SymGetSymbolFile(hprocess.into_param().abi(), sympath.into_param().abi(), imagefile.into_param().abi(), r#type, ::core::mem::transmute(symbolfile.as_ptr()), symbolfile.len() as _, ::core::mem::transmute(dbgfile.as_ptr()), dbgfile.len() as _)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymGetSymbolFileW<P0, P1, P2>(hprocess: P0, sympath: P1, imagefile: P2, r#type: IMAGEHLP_SF_TYPE, symbolfile: &mut [u16], dbgfile: &mut [u16]) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    P2: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymGetSymbolFileW ( hprocess : super::super::super::Foundation:: HANDLE , sympath : :: windows::core::PCWSTR , imagefile : :: windows::core::PCWSTR , r#type : IMAGEHLP_SF_TYPE , symbolfile : :: windows::core::PWSTR , csymbolfile : usize , dbgfile : :: windows::core::PWSTR , cdbgfile : usize ) -> super::super::super::Foundation:: BOOL );
    SymGetSymbolFileW(hprocess.into_param().abi(), sympath.into_param().abi(), imagefile.into_param().abi(), r#type, ::core::mem::transmute(symbolfile.as_ptr()), symbolfile.len() as _, ::core::mem::transmute(dbgfile.as_ptr()), dbgfile.len() as _)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymGetTypeFromName<P0, P1>(hprocess: P0, baseofdll: u64, name: P1, symbol: *mut SYMBOL_INFO) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymGetTypeFromName ( hprocess : super::super::super::Foundation:: HANDLE , baseofdll : u64 , name : :: windows::core::PCSTR , symbol : *mut SYMBOL_INFO ) -> super::super::super::Foundation:: BOOL );
    SymGetTypeFromName(hprocess.into_param().abi(), baseofdll, name.into_param().abi(), symbol)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymGetTypeFromNameW<P0, P1>(hprocess: P0, baseofdll: u64, name: P1, symbol: *mut SYMBOL_INFOW) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymGetTypeFromNameW ( hprocess : super::super::super::Foundation:: HANDLE , baseofdll : u64 , name : :: windows::core::PCWSTR , symbol : *mut SYMBOL_INFOW ) -> super::super::super::Foundation:: BOOL );
    SymGetTypeFromNameW(hprocess.into_param().abi(), baseofdll, name.into_param().abi(), symbol)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymGetTypeInfo<P0>(hprocess: P0, modbase: u64, typeid: u32, gettype: IMAGEHLP_SYMBOL_TYPE_INFO, pinfo: *mut ::core::ffi::c_void) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymGetTypeInfo ( hprocess : super::super::super::Foundation:: HANDLE , modbase : u64 , typeid : u32 , gettype : IMAGEHLP_SYMBOL_TYPE_INFO , pinfo : *mut ::core::ffi::c_void ) -> super::super::super::Foundation:: BOOL );
    SymGetTypeInfo(hprocess.into_param().abi(), modbase, typeid, gettype, pinfo)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymGetTypeInfoEx<P0>(hprocess: P0, modbase: u64, params: *mut IMAGEHLP_GET_TYPE_INFO_PARAMS) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymGetTypeInfoEx ( hprocess : super::super::super::Foundation:: HANDLE , modbase : u64 , params : *mut IMAGEHLP_GET_TYPE_INFO_PARAMS ) -> super::super::super::Foundation:: BOOL );
    SymGetTypeInfoEx(hprocess.into_param().abi(), modbase, params)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymGetUnwindInfo<P0>(hprocess: P0, address: u64, buffer: ::core::option::Option<*mut ::core::ffi::c_void>, size: *mut u32) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymGetUnwindInfo ( hprocess : super::super::super::Foundation:: HANDLE , address : u64 , buffer : *mut ::core::ffi::c_void , size : *mut u32 ) -> super::super::super::Foundation:: BOOL );
    SymGetUnwindInfo(hprocess.into_param().abi(), address, ::core::mem::transmute(buffer.unwrap_or(::std::ptr::null_mut())), size)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymInitialize<P0, P1, P2>(hprocess: P0, usersearchpath: P1, finvadeprocess: P2) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P2: ::windows::core::IntoParam<super::super::super::Foundation::BOOL>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymInitialize ( hprocess : super::super::super::Foundation:: HANDLE , usersearchpath : :: windows::core::PCSTR , finvadeprocess : super::super::super::Foundation:: BOOL ) -> super::super::super::Foundation:: BOOL );
    SymInitialize(hprocess.into_param().abi(), usersearchpath.into_param().abi(), finvadeprocess.into_param().abi())
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymInitializeW<P0, P1, P2>(hprocess: P0, usersearchpath: P1, finvadeprocess: P2) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    P2: ::windows::core::IntoParam<super::super::super::Foundation::BOOL>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymInitializeW ( hprocess : super::super::super::Foundation:: HANDLE , usersearchpath : :: windows::core::PCWSTR , finvadeprocess : super::super::super::Foundation:: BOOL ) -> super::super::super::Foundation:: BOOL );
    SymInitializeW(hprocess.into_param().abi(), usersearchpath.into_param().abi(), finvadeprocess.into_param().abi())
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymLoadModule<P0, P1, P2, P3>(hprocess: P0, hfile: P1, imagename: P2, modulename: P3, baseofdll: u32, sizeofdll: u32) -> u32
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P2: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P3: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymLoadModule ( hprocess : super::super::super::Foundation:: HANDLE , hfile : super::super::super::Foundation:: HANDLE , imagename : :: windows::core::PCSTR , modulename : :: windows::core::PCSTR , baseofdll : u32 , sizeofdll : u32 ) -> u32 );
    SymLoadModule(hprocess.into_param().abi(), hfile.into_param().abi(), imagename.into_param().abi(), modulename.into_param().abi(), baseofdll, sizeofdll)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymLoadModule64<P0, P1, P2, P3>(hprocess: P0, hfile: P1, imagename: P2, modulename: P3, baseofdll: u64, sizeofdll: u32) -> u64
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P2: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P3: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymLoadModule64 ( hprocess : super::super::super::Foundation:: HANDLE , hfile : super::super::super::Foundation:: HANDLE , imagename : :: windows::core::PCSTR , modulename : :: windows::core::PCSTR , baseofdll : u64 , sizeofdll : u32 ) -> u64 );
    SymLoadModule64(hprocess.into_param().abi(), hfile.into_param().abi(), imagename.into_param().abi(), modulename.into_param().abi(), baseofdll, sizeofdll)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymLoadModuleEx<P0, P1, P2, P3>(hprocess: P0, hfile: P1, imagename: P2, modulename: P3, baseofdll: u64, dllsize: u32, data: ::core::option::Option<*const MODLOAD_DATA>, flags: SYM_LOAD_FLAGS) -> u64
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P2: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P3: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymLoadModuleEx ( hprocess : super::super::super::Foundation:: HANDLE , hfile : super::super::super::Foundation:: HANDLE , imagename : :: windows::core::PCSTR , modulename : :: windows::core::PCSTR , baseofdll : u64 , dllsize : u32 , data : *const MODLOAD_DATA , flags : SYM_LOAD_FLAGS ) -> u64 );
    SymLoadModuleEx(hprocess.into_param().abi(), hfile.into_param().abi(), imagename.into_param().abi(), modulename.into_param().abi(), baseofdll, dllsize, ::core::mem::transmute(data.unwrap_or(::std::ptr::null())), flags)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymLoadModuleExW<P0, P1, P2, P3>(hprocess: P0, hfile: P1, imagename: P2, modulename: P3, baseofdll: u64, dllsize: u32, data: ::core::option::Option<*const MODLOAD_DATA>, flags: SYM_LOAD_FLAGS) -> u64
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P2: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    P3: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymLoadModuleExW ( hprocess : super::super::super::Foundation:: HANDLE , hfile : super::super::super::Foundation:: HANDLE , imagename : :: windows::core::PCWSTR , modulename : :: windows::core::PCWSTR , baseofdll : u64 , dllsize : u32 , data : *const MODLOAD_DATA , flags : SYM_LOAD_FLAGS ) -> u64 );
    SymLoadModuleExW(hprocess.into_param().abi(), hfile.into_param().abi(), imagename.into_param().abi(), modulename.into_param().abi(), baseofdll, dllsize, ::core::mem::transmute(data.unwrap_or(::std::ptr::null())), flags)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymMatchFileName<P0, P1>(filename: P0, r#match: P1, filenamestop: ::core::option::Option<*mut ::windows::core::PSTR>, matchstop: ::core::option::Option<*mut ::windows::core::PSTR>) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymMatchFileName ( filename : :: windows::core::PCSTR , r#match : :: windows::core::PCSTR , filenamestop : *mut :: windows::core::PSTR , matchstop : *mut :: windows::core::PSTR ) -> super::super::super::Foundation:: BOOL );
    SymMatchFileName(filename.into_param().abi(), r#match.into_param().abi(), ::core::mem::transmute(filenamestop.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(matchstop.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymMatchFileNameW<P0, P1>(filename: P0, r#match: P1, filenamestop: ::core::option::Option<*mut ::windows::core::PWSTR>, matchstop: ::core::option::Option<*mut ::windows::core::PWSTR>) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymMatchFileNameW ( filename : :: windows::core::PCWSTR , r#match : :: windows::core::PCWSTR , filenamestop : *mut :: windows::core::PWSTR , matchstop : *mut :: windows::core::PWSTR ) -> super::super::super::Foundation:: BOOL );
    SymMatchFileNameW(filename.into_param().abi(), r#match.into_param().abi(), ::core::mem::transmute(filenamestop.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(matchstop.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymMatchString<P0, P1, P2>(string: P0, expression: P1, fcase: P2) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P2: ::windows::core::IntoParam<super::super::super::Foundation::BOOL>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymMatchString ( string : :: windows::core::PCSTR , expression : :: windows::core::PCSTR , fcase : super::super::super::Foundation:: BOOL ) -> super::super::super::Foundation:: BOOL );
    SymMatchString(string.into_param().abi(), expression.into_param().abi(), fcase.into_param().abi())
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymMatchStringA<P0, P1, P2>(string: P0, expression: P1, fcase: P2) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P2: ::windows::core::IntoParam<super::super::super::Foundation::BOOL>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymMatchStringA ( string : :: windows::core::PCSTR , expression : :: windows::core::PCSTR , fcase : super::super::super::Foundation:: BOOL ) -> super::super::super::Foundation:: BOOL );
    SymMatchStringA(string.into_param().abi(), expression.into_param().abi(), fcase.into_param().abi())
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymMatchStringW<P0, P1, P2>(string: P0, expression: P1, fcase: P2) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    P2: ::windows::core::IntoParam<super::super::super::Foundation::BOOL>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymMatchStringW ( string : :: windows::core::PCWSTR , expression : :: windows::core::PCWSTR , fcase : super::super::super::Foundation:: BOOL ) -> super::super::super::Foundation:: BOOL );
    SymMatchStringW(string.into_param().abi(), expression.into_param().abi(), fcase.into_param().abi())
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymNext<P0>(hprocess: P0, si: *mut SYMBOL_INFO) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymNext ( hprocess : super::super::super::Foundation:: HANDLE , si : *mut SYMBOL_INFO ) -> super::super::super::Foundation:: BOOL );
    SymNext(hprocess.into_param().abi(), si)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymNextW<P0>(hprocess: P0, siw: *mut SYMBOL_INFOW) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymNextW ( hprocess : super::super::super::Foundation:: HANDLE , siw : *mut SYMBOL_INFOW ) -> super::super::super::Foundation:: BOOL );
    SymNextW(hprocess.into_param().abi(), siw)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymPrev<P0>(hprocess: P0, si: *mut SYMBOL_INFO) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymPrev ( hprocess : super::super::super::Foundation:: HANDLE , si : *mut SYMBOL_INFO ) -> super::super::super::Foundation:: BOOL );
    SymPrev(hprocess.into_param().abi(), si)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymPrevW<P0>(hprocess: P0, siw: *mut SYMBOL_INFOW) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymPrevW ( hprocess : super::super::super::Foundation:: HANDLE , siw : *mut SYMBOL_INFOW ) -> super::super::super::Foundation:: BOOL );
    SymPrevW(hprocess.into_param().abi(), siw)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymQueryInlineTrace<P0>(hprocess: P0, startaddress: u64, startcontext: u32, startretaddress: u64, curaddress: u64, curcontext: *mut u32, curframeindex: *mut u32) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymQueryInlineTrace ( hprocess : super::super::super::Foundation:: HANDLE , startaddress : u64 , startcontext : u32 , startretaddress : u64 , curaddress : u64 , curcontext : *mut u32 , curframeindex : *mut u32 ) -> super::super::super::Foundation:: BOOL );
    SymQueryInlineTrace(hprocess.into_param().abi(), startaddress, startcontext, startretaddress, curaddress, curcontext, curframeindex)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymRefreshModuleList<P0>(hprocess: P0) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymRefreshModuleList ( hprocess : super::super::super::Foundation:: HANDLE ) -> super::super::super::Foundation:: BOOL );
    SymRefreshModuleList(hprocess.into_param().abi())
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymRegisterCallback<P0>(hprocess: P0, callbackfunction: PSYMBOL_REGISTERED_CALLBACK, usercontext: ::core::option::Option<*const ::core::ffi::c_void>) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymRegisterCallback ( hprocess : super::super::super::Foundation:: HANDLE , callbackfunction : PSYMBOL_REGISTERED_CALLBACK , usercontext : *const ::core::ffi::c_void ) -> super::super::super::Foundation:: BOOL );
    SymRegisterCallback(hprocess.into_param().abi(), callbackfunction, ::core::mem::transmute(usercontext.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymRegisterCallback64<P0>(hprocess: P0, callbackfunction: PSYMBOL_REGISTERED_CALLBACK64, usercontext: u64) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymRegisterCallback64 ( hprocess : super::super::super::Foundation:: HANDLE , callbackfunction : PSYMBOL_REGISTERED_CALLBACK64 , usercontext : u64 ) -> super::super::super::Foundation:: BOOL );
    SymRegisterCallback64(hprocess.into_param().abi(), callbackfunction, usercontext)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymRegisterCallbackW64<P0>(hprocess: P0, callbackfunction: PSYMBOL_REGISTERED_CALLBACK64, usercontext: u64) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymRegisterCallbackW64 ( hprocess : super::super::super::Foundation:: HANDLE , callbackfunction : PSYMBOL_REGISTERED_CALLBACK64 , usercontext : u64 ) -> super::super::super::Foundation:: BOOL );
    SymRegisterCallbackW64(hprocess.into_param().abi(), callbackfunction, usercontext)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymRegisterFunctionEntryCallback<P0>(hprocess: P0, callbackfunction: PSYMBOL_FUNCENTRY_CALLBACK, usercontext: ::core::option::Option<*const ::core::ffi::c_void>) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymRegisterFunctionEntryCallback ( hprocess : super::super::super::Foundation:: HANDLE , callbackfunction : PSYMBOL_FUNCENTRY_CALLBACK , usercontext : *const ::core::ffi::c_void ) -> super::super::super::Foundation:: BOOL );
    SymRegisterFunctionEntryCallback(hprocess.into_param().abi(), callbackfunction, ::core::mem::transmute(usercontext.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymRegisterFunctionEntryCallback64<P0>(hprocess: P0, callbackfunction: PSYMBOL_FUNCENTRY_CALLBACK64, usercontext: u64) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymRegisterFunctionEntryCallback64 ( hprocess : super::super::super::Foundation:: HANDLE , callbackfunction : PSYMBOL_FUNCENTRY_CALLBACK64 , usercontext : u64 ) -> super::super::super::Foundation:: BOOL );
    SymRegisterFunctionEntryCallback64(hprocess.into_param().abi(), callbackfunction, usercontext)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymSearch<P0, P1>(hprocess: P0, baseofdll: u64, index: u32, symtag: u32, mask: P1, address: u64, enumsymbolscallback: PSYM_ENUMERATESYMBOLS_CALLBACK, usercontext: ::core::option::Option<*const ::core::ffi::c_void>, options: u32) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymSearch ( hprocess : super::super::super::Foundation:: HANDLE , baseofdll : u64 , index : u32 , symtag : u32 , mask : :: windows::core::PCSTR , address : u64 , enumsymbolscallback : PSYM_ENUMERATESYMBOLS_CALLBACK , usercontext : *const ::core::ffi::c_void , options : u32 ) -> super::super::super::Foundation:: BOOL );
    SymSearch(hprocess.into_param().abi(), baseofdll, index, symtag, mask.into_param().abi(), address, enumsymbolscallback, ::core::mem::transmute(usercontext.unwrap_or(::std::ptr::null())), options)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymSearchW<P0, P1>(hprocess: P0, baseofdll: u64, index: u32, symtag: u32, mask: P1, address: u64, enumsymbolscallback: PSYM_ENUMERATESYMBOLS_CALLBACKW, usercontext: ::core::option::Option<*const ::core::ffi::c_void>, options: u32) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymSearchW ( hprocess : super::super::super::Foundation:: HANDLE , baseofdll : u64 , index : u32 , symtag : u32 , mask : :: windows::core::PCWSTR , address : u64 , enumsymbolscallback : PSYM_ENUMERATESYMBOLS_CALLBACKW , usercontext : *const ::core::ffi::c_void , options : u32 ) -> super::super::super::Foundation:: BOOL );
    SymSearchW(hprocess.into_param().abi(), baseofdll, index, symtag, mask.into_param().abi(), address, enumsymbolscallback, ::core::mem::transmute(usercontext.unwrap_or(::std::ptr::null())), options)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymSetContext<P0>(hprocess: P0, stackframe: *const IMAGEHLP_STACK_FRAME, context: ::core::option::Option<*const ::core::ffi::c_void>) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymSetContext ( hprocess : super::super::super::Foundation:: HANDLE , stackframe : *const IMAGEHLP_STACK_FRAME , context : *const ::core::ffi::c_void ) -> super::super::super::Foundation:: BOOL );
    SymSetContext(hprocess.into_param().abi(), stackframe, ::core::mem::transmute(context.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymSetExtendedOption<P0>(option: IMAGEHLP_EXTENDED_OPTIONS, value: P0) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::BOOL>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymSetExtendedOption ( option : IMAGEHLP_EXTENDED_OPTIONS , value : super::super::super::Foundation:: BOOL ) -> super::super::super::Foundation:: BOOL );
    SymSetExtendedOption(option, value.into_param().abi())
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymSetHomeDirectory<P0, P1>(hprocess: P0, dir: P1) -> ::windows::core::PSTR
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymSetHomeDirectory ( hprocess : super::super::super::Foundation:: HANDLE , dir : :: windows::core::PCSTR ) -> :: windows::core::PSTR );
    SymSetHomeDirectory(hprocess.into_param().abi(), dir.into_param().abi())
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymSetHomeDirectoryW<P0, P1>(hprocess: P0, dir: P1) -> ::windows::core::PWSTR
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymSetHomeDirectoryW ( hprocess : super::super::super::Foundation:: HANDLE , dir : :: windows::core::PCWSTR ) -> :: windows::core::PWSTR );
    SymSetHomeDirectoryW(hprocess.into_param().abi(), dir.into_param().abi())
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[inline]
pub unsafe fn SymSetOptions(symoptions: u32) -> u32 {
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymSetOptions ( symoptions : u32 ) -> u32 );
    SymSetOptions(symoptions)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymSetParentWindow<P0>(hwnd: P0) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HWND>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymSetParentWindow ( hwnd : super::super::super::Foundation:: HWND ) -> super::super::super::Foundation:: BOOL );
    SymSetParentWindow(hwnd.into_param().abi())
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymSetScopeFromAddr<P0>(hprocess: P0, address: u64) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymSetScopeFromAddr ( hprocess : super::super::super::Foundation:: HANDLE , address : u64 ) -> super::super::super::Foundation:: BOOL );
    SymSetScopeFromAddr(hprocess.into_param().abi(), address)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymSetScopeFromIndex<P0>(hprocess: P0, baseofdll: u64, index: u32) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymSetScopeFromIndex ( hprocess : super::super::super::Foundation:: HANDLE , baseofdll : u64 , index : u32 ) -> super::super::super::Foundation:: BOOL );
    SymSetScopeFromIndex(hprocess.into_param().abi(), baseofdll, index)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymSetScopeFromInlineContext<P0>(hprocess: P0, address: u64, inlinecontext: u32) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymSetScopeFromInlineContext ( hprocess : super::super::super::Foundation:: HANDLE , address : u64 , inlinecontext : u32 ) -> super::super::super::Foundation:: BOOL );
    SymSetScopeFromInlineContext(hprocess.into_param().abi(), address, inlinecontext)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymSetSearchPath<P0, P1>(hprocess: P0, searchpatha: P1) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymSetSearchPath ( hprocess : super::super::super::Foundation:: HANDLE , searchpatha : :: windows::core::PCSTR ) -> super::super::super::Foundation:: BOOL );
    SymSetSearchPath(hprocess.into_param().abi(), searchpatha.into_param().abi())
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymSetSearchPathW<P0, P1>(hprocess: P0, searchpatha: P1) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymSetSearchPathW ( hprocess : super::super::super::Foundation:: HANDLE , searchpatha : :: windows::core::PCWSTR ) -> super::super::super::Foundation:: BOOL );
    SymSetSearchPathW(hprocess.into_param().abi(), searchpatha.into_param().abi())
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymSrvDeltaName<P0, P1, P2, P3, P4>(hprocess: P0, sympath: P1, r#type: P2, file1: P3, file2: P4) -> ::windows::core::PSTR
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P2: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P3: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P4: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymSrvDeltaName ( hprocess : super::super::super::Foundation:: HANDLE , sympath : :: windows::core::PCSTR , r#type : :: windows::core::PCSTR , file1 : :: windows::core::PCSTR , file2 : :: windows::core::PCSTR ) -> :: windows::core::PSTR );
    SymSrvDeltaName(hprocess.into_param().abi(), sympath.into_param().abi(), r#type.into_param().abi(), file1.into_param().abi(), file2.into_param().abi())
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymSrvDeltaNameW<P0, P1, P2, P3, P4>(hprocess: P0, sympath: P1, r#type: P2, file1: P3, file2: P4) -> ::windows::core::PWSTR
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    P2: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    P3: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    P4: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymSrvDeltaNameW ( hprocess : super::super::super::Foundation:: HANDLE , sympath : :: windows::core::PCWSTR , r#type : :: windows::core::PCWSTR , file1 : :: windows::core::PCWSTR , file2 : :: windows::core::PCWSTR ) -> :: windows::core::PWSTR );
    SymSrvDeltaNameW(hprocess.into_param().abi(), sympath.into_param().abi(), r#type.into_param().abi(), file1.into_param().abi(), file2.into_param().abi())
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymSrvGetFileIndexInfo<P0>(file: P0, info: *mut SYMSRV_INDEX_INFO, flags: u32) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymSrvGetFileIndexInfo ( file : :: windows::core::PCSTR , info : *mut SYMSRV_INDEX_INFO , flags : u32 ) -> super::super::super::Foundation:: BOOL );
    SymSrvGetFileIndexInfo(file.into_param().abi(), info, flags)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymSrvGetFileIndexInfoW<P0>(file: P0, info: *mut SYMSRV_INDEX_INFOW, flags: u32) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymSrvGetFileIndexInfoW ( file : :: windows::core::PCWSTR , info : *mut SYMSRV_INDEX_INFOW , flags : u32 ) -> super::super::super::Foundation:: BOOL );
    SymSrvGetFileIndexInfoW(file.into_param().abi(), info, flags)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymSrvGetFileIndexString<P0, P1, P2>(hprocess: P0, srvpath: P1, file: P2, index: &mut [u8], flags: u32) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P2: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymSrvGetFileIndexString ( hprocess : super::super::super::Foundation:: HANDLE , srvpath : :: windows::core::PCSTR , file : :: windows::core::PCSTR , index : :: windows::core::PSTR , size : usize , flags : u32 ) -> super::super::super::Foundation:: BOOL );
    SymSrvGetFileIndexString(hprocess.into_param().abi(), srvpath.into_param().abi(), file.into_param().abi(), ::core::mem::transmute(index.as_ptr()), index.len() as _, flags)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymSrvGetFileIndexStringW<P0, P1, P2>(hprocess: P0, srvpath: P1, file: P2, index: &mut [u16], flags: u32) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    P2: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymSrvGetFileIndexStringW ( hprocess : super::super::super::Foundation:: HANDLE , srvpath : :: windows::core::PCWSTR , file : :: windows::core::PCWSTR , index : :: windows::core::PWSTR , size : usize , flags : u32 ) -> super::super::super::Foundation:: BOOL );
    SymSrvGetFileIndexStringW(hprocess.into_param().abi(), srvpath.into_param().abi(), file.into_param().abi(), ::core::mem::transmute(index.as_ptr()), index.len() as _, flags)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymSrvGetFileIndexes<P0>(file: P0, id: *mut ::windows::core::GUID, val1: *mut u32, val2: ::core::option::Option<*mut u32>, flags: u32) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymSrvGetFileIndexes ( file : :: windows::core::PCSTR , id : *mut :: windows::core::GUID , val1 : *mut u32 , val2 : *mut u32 , flags : u32 ) -> super::super::super::Foundation:: BOOL );
    SymSrvGetFileIndexes(file.into_param().abi(), id, val1, ::core::mem::transmute(val2.unwrap_or(::std::ptr::null_mut())), flags)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymSrvGetFileIndexesW<P0>(file: P0, id: *mut ::windows::core::GUID, val1: *mut u32, val2: ::core::option::Option<*mut u32>, flags: u32) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymSrvGetFileIndexesW ( file : :: windows::core::PCWSTR , id : *mut :: windows::core::GUID , val1 : *mut u32 , val2 : *mut u32 , flags : u32 ) -> super::super::super::Foundation:: BOOL );
    SymSrvGetFileIndexesW(file.into_param().abi(), id, val1, ::core::mem::transmute(val2.unwrap_or(::std::ptr::null_mut())), flags)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymSrvGetSupplement<P0, P1, P2, P3>(hprocess: P0, sympath: P1, node: P2, file: P3) -> ::windows::core::PSTR
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P2: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P3: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymSrvGetSupplement ( hprocess : super::super::super::Foundation:: HANDLE , sympath : :: windows::core::PCSTR , node : :: windows::core::PCSTR , file : :: windows::core::PCSTR ) -> :: windows::core::PSTR );
    SymSrvGetSupplement(hprocess.into_param().abi(), sympath.into_param().abi(), node.into_param().abi(), file.into_param().abi())
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymSrvGetSupplementW<P0, P1, P2, P3>(hprocess: P0, sympath: P1, node: P2, file: P3) -> ::windows::core::PWSTR
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    P2: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    P3: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymSrvGetSupplementW ( hprocess : super::super::super::Foundation:: HANDLE , sympath : :: windows::core::PCWSTR , node : :: windows::core::PCWSTR , file : :: windows::core::PCWSTR ) -> :: windows::core::PWSTR );
    SymSrvGetSupplementW(hprocess.into_param().abi(), sympath.into_param().abi(), node.into_param().abi(), file.into_param().abi())
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymSrvIsStore<P0, P1>(hprocess: P0, path: P1) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymSrvIsStore ( hprocess : super::super::super::Foundation:: HANDLE , path : :: windows::core::PCSTR ) -> super::super::super::Foundation:: BOOL );
    SymSrvIsStore(hprocess.into_param().abi(), path.into_param().abi())
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymSrvIsStoreW<P0, P1>(hprocess: P0, path: P1) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymSrvIsStoreW ( hprocess : super::super::super::Foundation:: HANDLE , path : :: windows::core::PCWSTR ) -> super::super::super::Foundation:: BOOL );
    SymSrvIsStoreW(hprocess.into_param().abi(), path.into_param().abi())
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymSrvStoreFile<P0, P1, P2>(hprocess: P0, srvpath: P1, file: P2, flags: SYM_SRV_STORE_FILE_FLAGS) -> ::windows::core::PSTR
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P2: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymSrvStoreFile ( hprocess : super::super::super::Foundation:: HANDLE , srvpath : :: windows::core::PCSTR , file : :: windows::core::PCSTR , flags : SYM_SRV_STORE_FILE_FLAGS ) -> :: windows::core::PSTR );
    SymSrvStoreFile(hprocess.into_param().abi(), srvpath.into_param().abi(), file.into_param().abi(), flags)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymSrvStoreFileW<P0, P1, P2>(hprocess: P0, srvpath: P1, file: P2, flags: SYM_SRV_STORE_FILE_FLAGS) -> ::windows::core::PWSTR
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    P2: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymSrvStoreFileW ( hprocess : super::super::super::Foundation:: HANDLE , srvpath : :: windows::core::PCWSTR , file : :: windows::core::PCWSTR , flags : SYM_SRV_STORE_FILE_FLAGS ) -> :: windows::core::PWSTR );
    SymSrvStoreFileW(hprocess.into_param().abi(), srvpath.into_param().abi(), file.into_param().abi(), flags)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymSrvStoreSupplement<P0, P1, P2, P3>(hprocess: P0, srvpath: P1, node: P2, file: P3, flags: u32) -> ::windows::core::PSTR
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P2: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P3: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymSrvStoreSupplement ( hprocess : super::super::super::Foundation:: HANDLE , srvpath : :: windows::core::PCSTR , node : :: windows::core::PCSTR , file : :: windows::core::PCSTR , flags : u32 ) -> :: windows::core::PSTR );
    SymSrvStoreSupplement(hprocess.into_param().abi(), srvpath.into_param().abi(), node.into_param().abi(), file.into_param().abi(), flags)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymSrvStoreSupplementW<P0, P1, P2, P3>(hprocess: P0, sympath: P1, node: P2, file: P3, flags: u32) -> ::windows::core::PWSTR
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
    P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    P2: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    P3: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymSrvStoreSupplementW ( hprocess : super::super::super::Foundation:: HANDLE , sympath : :: windows::core::PCWSTR , node : :: windows::core::PCWSTR , file : :: windows::core::PCWSTR , flags : u32 ) -> :: windows::core::PWSTR );
    SymSrvStoreSupplementW(hprocess.into_param().abi(), sympath.into_param().abi(), node.into_param().abi(), file.into_param().abi(), flags)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymUnDName(sym: *const IMAGEHLP_SYMBOL, undecname: &mut [u8]) -> super::super::super::Foundation::BOOL {
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymUnDName ( sym : *const IMAGEHLP_SYMBOL , undecname : :: windows::core::PSTR , undecnamelength : u32 ) -> super::super::super::Foundation:: BOOL );
    SymUnDName(sym, ::core::mem::transmute(undecname.as_ptr()), undecname.len() as _)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymUnDName64(sym: *const IMAGEHLP_SYMBOL64, undecname: &mut [u8]) -> super::super::super::Foundation::BOOL {
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymUnDName64 ( sym : *const IMAGEHLP_SYMBOL64 , undecname : :: windows::core::PSTR , undecnamelength : u32 ) -> super::super::super::Foundation:: BOOL );
    SymUnDName64(sym, ::core::mem::transmute(undecname.as_ptr()), undecname.len() as _)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymUnloadModule<P0>(hprocess: P0, baseofdll: u32) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymUnloadModule ( hprocess : super::super::super::Foundation:: HANDLE , baseofdll : u32 ) -> super::super::super::Foundation:: BOOL );
    SymUnloadModule(hprocess.into_param().abi(), baseofdll)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SymUnloadModule64<P0>(hprocess: P0, baseofdll: u64) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn SymUnloadModule64 ( hprocess : super::super::super::Foundation:: HANDLE , baseofdll : u64 ) -> super::super::super::Foundation:: BOOL );
    SymUnloadModule64(hprocess.into_param().abi(), baseofdll)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[inline]
pub unsafe fn TerminateProcessOnMemoryExhaustion(failedallocationsize: usize) {
    ::windows::imp::link ! ( "api-ms-win-core-errorhandling-l1-1-3.dll""system" fn TerminateProcessOnMemoryExhaustion ( failedallocationsize : usize ) -> ( ) );
    TerminateProcessOnMemoryExhaustion(failedallocationsize)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn TouchFileTimes<P0>(filehandle: P0, psystemtime: ::core::option::Option<*const super::super::super::Foundation::SYSTEMTIME>) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "imagehlp.dll""system" fn TouchFileTimes ( filehandle : super::super::super::Foundation:: HANDLE , psystemtime : *const super::super::super::Foundation:: SYSTEMTIME ) -> super::super::super::Foundation:: BOOL );
    TouchFileTimes(filehandle.into_param().abi(), ::core::mem::transmute(psystemtime.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[inline]
pub unsafe fn UnDecorateSymbolName<P0>(name: P0, outputstring: &mut [u8], flags: u32) -> u32
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn UnDecorateSymbolName ( name : :: windows::core::PCSTR , outputstring : :: windows::core::PSTR , maxstringlength : u32 , flags : u32 ) -> u32 );
    UnDecorateSymbolName(name.into_param().abi(), ::core::mem::transmute(outputstring.as_ptr()), outputstring.len() as _, flags)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[inline]
pub unsafe fn UnDecorateSymbolNameW<P0>(name: P0, outputstring: &mut [u16], flags: u32) -> u32
where
    P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
{
    ::windows::imp::link ! ( "dbghelp.dll""system" fn UnDecorateSymbolNameW ( name : :: windows::core::PCWSTR , outputstring : :: windows::core::PWSTR , maxstringlength : u32 , flags : u32 ) -> u32 );
    UnDecorateSymbolNameW(name.into_param().abi(), ::core::mem::transmute(outputstring.as_ptr()), outputstring.len() as _, flags)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`, `\"Win32_System_Kernel\"`, `\"Win32_System_SystemInformation\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Kernel", feature = "Win32_System_SystemInformation"))]
#[inline]
pub unsafe fn UnMapAndLoad(loadedimage: *mut LOADED_IMAGE) -> super::super::super::Foundation::BOOL {
    ::windows::imp::link ! ( "imagehlp.dll""system" fn UnMapAndLoad ( loadedimage : *mut LOADED_IMAGE ) -> super::super::super::Foundation:: BOOL );
    UnMapAndLoad(loadedimage)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`, `\"Win32_System_Kernel\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn UnhandledExceptionFilter(exceptioninfo: *const EXCEPTION_POINTERS) -> i32 {
    ::windows::imp::link ! ( "kernel32.dll""system" fn UnhandledExceptionFilter ( exceptioninfo : *const EXCEPTION_POINTERS ) -> i32 );
    UnhandledExceptionFilter(exceptioninfo)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`, `\"Win32_System_SystemInformation\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_SystemInformation"))]
#[inline]
pub unsafe fn UpdateDebugInfoFile<P0, P1>(imagefilename: P0, symbolpath: P1, debugfilepath: ::windows::core::PSTR, ntheaders: *const IMAGE_NT_HEADERS32) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "imagehlp.dll""system" fn UpdateDebugInfoFile ( imagefilename : :: windows::core::PCSTR , symbolpath : :: windows::core::PCSTR , debugfilepath : :: windows::core::PSTR , ntheaders : *const IMAGE_NT_HEADERS32 ) -> super::super::super::Foundation:: BOOL );
    UpdateDebugInfoFile(imagefilename.into_param().abi(), symbolpath.into_param().abi(), ::core::mem::transmute(debugfilepath), ntheaders)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`, `\"Win32_System_SystemInformation\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_SystemInformation"))]
#[inline]
pub unsafe fn UpdateDebugInfoFileEx<P0, P1>(imagefilename: P0, symbolpath: P1, debugfilepath: ::windows::core::PSTR, ntheaders: *const IMAGE_NT_HEADERS32, oldchecksum: u32) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
{
    ::windows::imp::link ! ( "imagehlp.dll""system" fn UpdateDebugInfoFileEx ( imagefilename : :: windows::core::PCSTR , symbolpath : :: windows::core::PCSTR , debugfilepath : :: windows::core::PSTR , ntheaders : *const IMAGE_NT_HEADERS32 , oldchecksum : u32 ) -> super::super::super::Foundation:: BOOL );
    UpdateDebugInfoFileEx(imagefilename.into_param().abi(), symbolpath.into_param().abi(), ::core::mem::transmute(debugfilepath), ntheaders, oldchecksum)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`, `\"Win32_System_Threading\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Threading"))]
#[inline]
pub unsafe fn WaitForDebugEvent(lpdebugevent: *mut DEBUG_EVENT, dwmilliseconds: u32) -> super::super::super::Foundation::BOOL {
    ::windows::imp::link ! ( "kernel32.dll""system" fn WaitForDebugEvent ( lpdebugevent : *mut DEBUG_EVENT , dwmilliseconds : u32 ) -> super::super::super::Foundation:: BOOL );
    WaitForDebugEvent(lpdebugevent, dwmilliseconds)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`, `\"Win32_System_Threading\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Threading"))]
#[inline]
pub unsafe fn WaitForDebugEventEx(lpdebugevent: *mut DEBUG_EVENT, dwmilliseconds: u32) -> super::super::super::Foundation::BOOL {
    ::windows::imp::link ! ( "kernel32.dll""system" fn WaitForDebugEventEx ( lpdebugevent : *mut DEBUG_EVENT , dwmilliseconds : u32 ) -> super::super::super::Foundation:: BOOL );
    WaitForDebugEventEx(lpdebugevent, dwmilliseconds)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn Wow64GetThreadContext<P0>(hthread: P0, lpcontext: *mut WOW64_CONTEXT) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn Wow64GetThreadContext ( hthread : super::super::super::Foundation:: HANDLE , lpcontext : *mut WOW64_CONTEXT ) -> super::super::super::Foundation:: BOOL );
    Wow64GetThreadContext(hthread.into_param().abi(), lpcontext)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn Wow64GetThreadSelectorEntry<P0>(hthread: P0, dwselector: u32, lpselectorentry: *mut WOW64_LDT_ENTRY) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn Wow64GetThreadSelectorEntry ( hthread : super::super::super::Foundation:: HANDLE , dwselector : u32 , lpselectorentry : *mut WOW64_LDT_ENTRY ) -> super::super::super::Foundation:: BOOL );
    Wow64GetThreadSelectorEntry(hthread.into_param().abi(), dwselector, lpselectorentry)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn Wow64SetThreadContext<P0>(hthread: P0, lpcontext: *const WOW64_CONTEXT) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn Wow64SetThreadContext ( hthread : super::super::super::Foundation:: HANDLE , lpcontext : *const WOW64_CONTEXT ) -> super::super::super::Foundation:: BOOL );
    Wow64SetThreadContext(hthread.into_param().abi(), lpcontext)
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WriteProcessMemory<P0>(hprocess: P0, lpbaseaddress: *const ::core::ffi::c_void, lpbuffer: *const ::core::ffi::c_void, nsize: usize, lpnumberofbyteswritten: ::core::option::Option<*mut usize>) -> super::super::super::Foundation::BOOL
where
    P0: ::windows::core::IntoParam<super::super::super::Foundation::HANDLE>,
{
    ::windows::imp::link ! ( "kernel32.dll""system" fn WriteProcessMemory ( hprocess : super::super::super::Foundation:: HANDLE , lpbaseaddress : *const ::core::ffi::c_void , lpbuffer : *const ::core::ffi::c_void , nsize : usize , lpnumberofbyteswritten : *mut usize ) -> super::super::super::Foundation:: BOOL );
    WriteProcessMemory(hprocess.into_param().abi(), lpbaseaddress, lpbuffer, nsize, ::core::mem::transmute(lpnumberofbyteswritten.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct AsyncIDebugApplicationNodeEvents(::windows::core::IUnknown);
impl AsyncIDebugApplicationNodeEvents {
    pub unsafe fn Begin_onAddChild<P0>(&self, prddpchild: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugApplicationNode>,
    {
        (::windows::core::Interface::vtable(self).Begin_onAddChild)(::windows::core::Interface::as_raw(self), prddpchild.into_param().abi()).ok()
    }
    pub unsafe fn Finish_onAddChild(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Finish_onAddChild)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Begin_onRemoveChild<P0>(&self, prddpchild: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugApplicationNode>,
    {
        (::windows::core::Interface::vtable(self).Begin_onRemoveChild)(::windows::core::Interface::as_raw(self), prddpchild.into_param().abi()).ok()
    }
    pub unsafe fn Finish_onRemoveChild(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Finish_onRemoveChild)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Begin_onDetach(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Begin_onDetach)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Finish_onDetach(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Finish_onDetach)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Begin_onAttach<P0>(&self, prddpparent: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugApplicationNode>,
    {
        (::windows::core::Interface::vtable(self).Begin_onAttach)(::windows::core::Interface::as_raw(self), prddpparent.into_param().abi()).ok()
    }
    pub unsafe fn Finish_onAttach(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Finish_onAttach)(::windows::core::Interface::as_raw(self)).ok()
    }
}
::windows::imp::interface_hierarchy!(AsyncIDebugApplicationNodeEvents, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for AsyncIDebugApplicationNodeEvents {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for AsyncIDebugApplicationNodeEvents {}
impl ::core::fmt::Debug for AsyncIDebugApplicationNodeEvents {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("AsyncIDebugApplicationNodeEvents").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for AsyncIDebugApplicationNodeEvents {
    type Vtable = AsyncIDebugApplicationNodeEvents_Vtbl;
}
impl ::core::clone::Clone for AsyncIDebugApplicationNodeEvents {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for AsyncIDebugApplicationNodeEvents {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa2e3aa3b_aa8d_4ebf_84cd_648b737b8c13);
}
#[repr(C)]
#[doc(hidden)]
pub struct AsyncIDebugApplicationNodeEvents_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub Begin_onAddChild: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, prddpchild: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub Finish_onAddChild: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub Begin_onRemoveChild: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, prddpchild: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub Finish_onRemoveChild: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub Begin_onDetach: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub Finish_onDetach: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub Begin_onAttach: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, prddpparent: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub Finish_onAttach: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct DebugBaseEventCallbacks(::windows::core::IUnknown);
impl DebugBaseEventCallbacks {
    pub unsafe fn GetInterestMask(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).base__.GetInterestMask)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn Breakpoint<P0>(&self, bp: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugBreakpoint>,
    {
        (::windows::core::Interface::vtable(self).base__.Breakpoint)(::windows::core::Interface::as_raw(self), bp.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Exception(&self, exception: *const EXCEPTION_RECORD64, firstchance: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.Exception)(::windows::core::Interface::as_raw(self), exception, firstchance).ok()
    }
    pub unsafe fn CreateThread(&self, handle: u64, dataoffset: u64, startoffset: u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.CreateThread)(::windows::core::Interface::as_raw(self), handle, dataoffset, startoffset).ok()
    }
    pub unsafe fn ExitThread(&self, exitcode: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.ExitThread)(::windows::core::Interface::as_raw(self), exitcode).ok()
    }
    pub unsafe fn CreateProcessA<P0, P1>(&self, imagefilehandle: u64, handle: u64, baseoffset: u64, modulesize: u32, modulename: P0, imagename: P1, checksum: u32, timedatestamp: u32, initialthreadhandle: u64, threaddataoffset: u64, startoffset: u64) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
        P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).base__.CreateProcessA)(::windows::core::Interface::as_raw(self), imagefilehandle, handle, baseoffset, modulesize, modulename.into_param().abi(), imagename.into_param().abi(), checksum, timedatestamp, initialthreadhandle, threaddataoffset, startoffset).ok()
    }
    pub unsafe fn ExitProcess(&self, exitcode: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.ExitProcess)(::windows::core::Interface::as_raw(self), exitcode).ok()
    }
    pub unsafe fn LoadModule<P0, P1>(&self, imagefilehandle: u64, baseoffset: u64, modulesize: u32, modulename: P0, imagename: P1, checksum: u32, timedatestamp: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
        P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).base__.LoadModule)(::windows::core::Interface::as_raw(self), imagefilehandle, baseoffset, modulesize, modulename.into_param().abi(), imagename.into_param().abi(), checksum, timedatestamp).ok()
    }
    pub unsafe fn UnloadModule<P0>(&self, imagebasename: P0, baseoffset: u64) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).base__.UnloadModule)(::windows::core::Interface::as_raw(self), imagebasename.into_param().abi(), baseoffset).ok()
    }
    pub unsafe fn SystemError(&self, error: u32, level: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.SystemError)(::windows::core::Interface::as_raw(self), error, level).ok()
    }
    pub unsafe fn SessionStatus(&self, status: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.SessionStatus)(::windows::core::Interface::as_raw(self), status).ok()
    }
    pub unsafe fn ChangeDebuggeeState(&self, flags: u32, argument: u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.ChangeDebuggeeState)(::windows::core::Interface::as_raw(self), flags, argument).ok()
    }
    pub unsafe fn ChangeEngineState(&self, flags: u32, argument: u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.ChangeEngineState)(::windows::core::Interface::as_raw(self), flags, argument).ok()
    }
    pub unsafe fn ChangeSymbolState(&self, flags: u32, argument: u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.ChangeSymbolState)(::windows::core::Interface::as_raw(self), flags, argument).ok()
    }
}
::windows::imp::interface_hierarchy!(DebugBaseEventCallbacks, ::windows::core::IUnknown, IDebugEventCallbacks);
impl ::core::cmp::PartialEq for DebugBaseEventCallbacks {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for DebugBaseEventCallbacks {}
impl ::core::fmt::Debug for DebugBaseEventCallbacks {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DebugBaseEventCallbacks").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for DebugBaseEventCallbacks {
    type Vtable = DebugBaseEventCallbacks_Vtbl;
}
impl ::core::clone::Clone for DebugBaseEventCallbacks {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for DebugBaseEventCallbacks {
    const IID: ::windows::core::GUID = ::windows::core::GUID::zeroed();
}
#[repr(C)]
#[doc(hidden)]
pub struct DebugBaseEventCallbacks_Vtbl {
    pub base__: IDebugEventCallbacks_Vtbl,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct DebugBaseEventCallbacksWide(::windows::core::IUnknown);
impl DebugBaseEventCallbacksWide {
    pub unsafe fn GetInterestMask(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).base__.GetInterestMask)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn Breakpoint<P0>(&self, bp: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugBreakpoint2>,
    {
        (::windows::core::Interface::vtable(self).base__.Breakpoint)(::windows::core::Interface::as_raw(self), bp.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Exception(&self, exception: *const EXCEPTION_RECORD64, firstchance: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.Exception)(::windows::core::Interface::as_raw(self), exception, firstchance).ok()
    }
    pub unsafe fn CreateThread(&self, handle: u64, dataoffset: u64, startoffset: u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.CreateThread)(::windows::core::Interface::as_raw(self), handle, dataoffset, startoffset).ok()
    }
    pub unsafe fn ExitThread(&self, exitcode: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.ExitThread)(::windows::core::Interface::as_raw(self), exitcode).ok()
    }
    pub unsafe fn CreateProcessA<P0, P1>(&self, imagefilehandle: u64, handle: u64, baseoffset: u64, modulesize: u32, modulename: P0, imagename: P1, checksum: u32, timedatestamp: u32, initialthreadhandle: u64, threaddataoffset: u64, startoffset: u64) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).base__.CreateProcessA)(::windows::core::Interface::as_raw(self), imagefilehandle, handle, baseoffset, modulesize, modulename.into_param().abi(), imagename.into_param().abi(), checksum, timedatestamp, initialthreadhandle, threaddataoffset, startoffset).ok()
    }
    pub unsafe fn ExitProcess(&self, exitcode: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.ExitProcess)(::windows::core::Interface::as_raw(self), exitcode).ok()
    }
    pub unsafe fn LoadModule<P0, P1>(&self, imagefilehandle: u64, baseoffset: u64, modulesize: u32, modulename: P0, imagename: P1, checksum: u32, timedatestamp: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).base__.LoadModule)(::windows::core::Interface::as_raw(self), imagefilehandle, baseoffset, modulesize, modulename.into_param().abi(), imagename.into_param().abi(), checksum, timedatestamp).ok()
    }
    pub unsafe fn UnloadModule<P0>(&self, imagebasename: P0, baseoffset: u64) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).base__.UnloadModule)(::windows::core::Interface::as_raw(self), imagebasename.into_param().abi(), baseoffset).ok()
    }
    pub unsafe fn SystemError(&self, error: u32, level: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.SystemError)(::windows::core::Interface::as_raw(self), error, level).ok()
    }
    pub unsafe fn SessionStatus(&self, status: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.SessionStatus)(::windows::core::Interface::as_raw(self), status).ok()
    }
    pub unsafe fn ChangeDebuggeeState(&self, flags: u32, argument: u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.ChangeDebuggeeState)(::windows::core::Interface::as_raw(self), flags, argument).ok()
    }
    pub unsafe fn ChangeEngineState(&self, flags: u32, argument: u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.ChangeEngineState)(::windows::core::Interface::as_raw(self), flags, argument).ok()
    }
    pub unsafe fn ChangeSymbolState(&self, flags: u32, argument: u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.ChangeSymbolState)(::windows::core::Interface::as_raw(self), flags, argument).ok()
    }
}
::windows::imp::interface_hierarchy!(DebugBaseEventCallbacksWide, ::windows::core::IUnknown, IDebugEventCallbacksWide);
impl ::core::cmp::PartialEq for DebugBaseEventCallbacksWide {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for DebugBaseEventCallbacksWide {}
impl ::core::fmt::Debug for DebugBaseEventCallbacksWide {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DebugBaseEventCallbacksWide").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for DebugBaseEventCallbacksWide {
    type Vtable = DebugBaseEventCallbacksWide_Vtbl;
}
impl ::core::clone::Clone for DebugBaseEventCallbacksWide {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for DebugBaseEventCallbacksWide {
    const IID: ::windows::core::GUID = ::windows::core::GUID::zeroed();
}
#[repr(C)]
#[doc(hidden)]
pub struct DebugBaseEventCallbacksWide_Vtbl {
    pub base__: IDebugEventCallbacksWide_Vtbl,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IActiveScript(::windows::core::IUnknown);
impl IActiveScript {
    pub unsafe fn SetScriptSite<P0>(&self, pass: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IActiveScriptSite>,
    {
        (::windows::core::Interface::vtable(self).SetScriptSite)(::windows::core::Interface::as_raw(self), pass.into_param().abi()).ok()
    }
    pub unsafe fn GetScriptSite<T>(&self) -> ::windows::core::Result<T>
    where
        T: ::windows::core::ComInterface,
    {
        let mut result__ = ::std::ptr::null_mut();
        (::windows::core::Interface::vtable(self).GetScriptSite)(::windows::core::Interface::as_raw(self), &<T as ::windows::core::ComInterface>::IID, &mut result__).from_abi(result__)
    }
    pub unsafe fn SetScriptState(&self, ss: SCRIPTSTATE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetScriptState)(::windows::core::Interface::as_raw(self), ss).ok()
    }
    pub unsafe fn GetScriptState(&self) -> ::windows::core::Result<SCRIPTSTATE> {
        let mut result__ = ::windows::core::zeroed::<SCRIPTSTATE>();
        (::windows::core::Interface::vtable(self).GetScriptState)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn Close(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Close)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn AddNamedItem<P0>(&self, pstrname: P0, dwflags: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).AddNamedItem)(::windows::core::Interface::as_raw(self), pstrname.into_param().abi(), dwflags).ok()
    }
    pub unsafe fn AddTypeLib(&self, rguidtypelib: *const ::windows::core::GUID, dwmajor: u32, dwminor: u32, dwflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).AddTypeLib)(::windows::core::Interface::as_raw(self), rguidtypelib, dwmajor, dwminor, dwflags).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetScriptDispatch<P0>(&self, pstritemname: P0) -> ::windows::core::Result<super::super::Com::IDispatch>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        let mut result__ = ::windows::core::zeroed::<super::super::Com::IDispatch>();
        (::windows::core::Interface::vtable(self).GetScriptDispatch)(::windows::core::Interface::as_raw(self), pstritemname.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetCurrentScriptThreadID(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetCurrentScriptThreadID)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetScriptThreadID(&self, dwwin32threadid: u32) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetScriptThreadID)(::windows::core::Interface::as_raw(self), dwwin32threadid, &mut result__).from_abi(result__)
    }
    pub unsafe fn GetScriptThreadState(&self, stidthread: u32) -> ::windows::core::Result<SCRIPTTHREADSTATE> {
        let mut result__ = ::windows::core::zeroed::<SCRIPTTHREADSTATE>();
        (::windows::core::Interface::vtable(self).GetScriptThreadState)(::windows::core::Interface::as_raw(self), stidthread, &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn InterruptScriptThread(&self, stidthread: u32, pexcepinfo: *const super::super::Com::EXCEPINFO, dwflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).InterruptScriptThread)(::windows::core::Interface::as_raw(self), stidthread, pexcepinfo, dwflags).ok()
    }
    pub unsafe fn Clone(&self) -> ::windows::core::Result<IActiveScript> {
        let mut result__ = ::windows::core::zeroed::<IActiveScript>();
        (::windows::core::Interface::vtable(self).Clone)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
}
::windows::imp::interface_hierarchy!(IActiveScript, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IActiveScript {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IActiveScript {}
impl ::core::fmt::Debug for IActiveScript {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IActiveScript").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IActiveScript {
    type Vtable = IActiveScript_Vtbl;
}
impl ::core::clone::Clone for IActiveScript {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IActiveScript {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xbb1a2ae1_a4f9_11cf_8f20_00805f2cd064);
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScript_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub SetScriptSite: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pass: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetScriptSite: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, ppvobject: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub SetScriptState: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ss: SCRIPTSTATE) -> ::windows::core::HRESULT,
    pub GetScriptState: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pssstate: *mut SCRIPTSTATE) -> ::windows::core::HRESULT,
    pub Close: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub AddNamedItem: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstrname: ::windows::core::PCWSTR, dwflags: u32) -> ::windows::core::HRESULT,
    pub AddTypeLib: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, rguidtypelib: *const ::windows::core::GUID, dwmajor: u32, dwminor: u32, dwflags: u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub GetScriptDispatch: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstritemname: ::windows::core::PCWSTR, ppdisp: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    GetScriptDispatch: usize,
    pub GetCurrentScriptThreadID: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstidthread: *mut u32) -> ::windows::core::HRESULT,
    pub GetScriptThreadID: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwwin32threadid: u32, pstidthread: *mut u32) -> ::windows::core::HRESULT,
    pub GetScriptThreadState: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, stidthread: u32, pstsstate: *mut SCRIPTTHREADSTATE) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub InterruptScriptThread: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, stidthread: u32, pexcepinfo: *const super::super::Com::EXCEPINFO, dwflags: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    InterruptScriptThread: usize,
    pub Clone: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppscript: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IActiveScriptAuthor(::windows::core::IUnknown);
impl IActiveScriptAuthor {
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn AddNamedItem<P0, P1>(&self, pszname: P0, dwflags: u32, pdisp: P1) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P1: ::windows::core::IntoParam<super::super::Com::IDispatch>,
    {
        (::windows::core::Interface::vtable(self).AddNamedItem)(::windows::core::Interface::as_raw(self), pszname.into_param().abi(), dwflags, pdisp.into_param().abi()).ok()
    }
    pub unsafe fn AddScriptlet<P0, P1, P2, P3, P4, P5>(&self, pszdefaultname: P0, pszcode: P1, pszitemname: P2, pszsubitemname: P3, pszeventname: P4, pszdelimiter: P5, dwcookie: u32, dwflags: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P2: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P3: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P4: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P5: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).AddScriptlet)(::windows::core::Interface::as_raw(self), pszdefaultname.into_param().abi(), pszcode.into_param().abi(), pszitemname.into_param().abi(), pszsubitemname.into_param().abi(), pszeventname.into_param().abi(), pszdelimiter.into_param().abi(), dwcookie, dwflags).ok()
    }
    pub unsafe fn ParseScriptText<P0, P1, P2>(&self, pszcode: P0, pszitemname: P1, pszdelimiter: P2, dwcookie: u32, dwflags: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P2: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).ParseScriptText)(::windows::core::Interface::as_raw(self), pszcode.into_param().abi(), pszitemname.into_param().abi(), pszdelimiter.into_param().abi(), dwcookie, dwflags).ok()
    }
    pub unsafe fn GetScriptTextAttributes<P0, P1>(&self, pszcode: P0, cch: u32, pszdelimiter: P1, dwflags: u32, pattr: *mut u16) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).GetScriptTextAttributes)(::windows::core::Interface::as_raw(self), pszcode.into_param().abi(), cch, pszdelimiter.into_param().abi(), dwflags, pattr).ok()
    }
    pub unsafe fn GetScriptletTextAttributes<P0, P1>(&self, pszcode: P0, cch: u32, pszdelimiter: P1, dwflags: u32, pattr: *mut u16) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).GetScriptletTextAttributes)(::windows::core::Interface::as_raw(self), pszcode.into_param().abi(), cch, pszdelimiter.into_param().abi(), dwflags, pattr).ok()
    }
    pub unsafe fn GetRoot(&self) -> ::windows::core::Result<IScriptNode> {
        let mut result__ = ::windows::core::zeroed::<IScriptNode>();
        (::windows::core::Interface::vtable(self).GetRoot)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetLanguageFlags(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetLanguageFlags)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetEventHandler<P0, P1, P2, P3>(&self, pdisp: P0, pszitem: P1, pszsubitem: P2, pszevent: P3) -> ::windows::core::Result<IScriptEntry>
    where
        P0: ::windows::core::IntoParam<super::super::Com::IDispatch>,
        P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P2: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P3: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        let mut result__ = ::windows::core::zeroed::<IScriptEntry>();
        (::windows::core::Interface::vtable(self).GetEventHandler)(::windows::core::Interface::as_raw(self), pdisp.into_param().abi(), pszitem.into_param().abi(), pszsubitem.into_param().abi(), pszevent.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn RemoveNamedItem<P0>(&self, pszname: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).RemoveNamedItem)(::windows::core::Interface::as_raw(self), pszname.into_param().abi()).ok()
    }
    pub unsafe fn AddTypeLib(&self, rguidtypelib: *const ::windows::core::GUID, dwmajor: u32, dwminor: u32, dwflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).AddTypeLib)(::windows::core::Interface::as_raw(self), rguidtypelib, dwmajor, dwminor, dwflags).ok()
    }
    pub unsafe fn RemoveTypeLib(&self, rguidtypelib: *const ::windows::core::GUID, dwmajor: u32, dwminor: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).RemoveTypeLib)(::windows::core::Interface::as_raw(self), rguidtypelib, dwmajor, dwminor).ok()
    }
    pub unsafe fn GetChars(&self, frequestedlist: u32) -> ::windows::core::Result<::windows::core::BSTR> {
        let mut result__ = ::windows::core::zeroed::<::windows::core::BSTR>();
        (::windows::core::Interface::vtable(self).GetChars)(::windows::core::Interface::as_raw(self), frequestedlist, &mut result__).from_abi(result__)
    }
    pub unsafe fn GetInfoFromContext<P0>(&self, pszcode: P0, cchcode: u32, ichcurrentposition: u32, dwlisttypesrequested: u32, pdwlisttypesprovided: *mut u32, pichlistanchorposition: *mut u32, pichfuncanchorposition: *mut u32, pmemid: *mut i32, picurrentparameter: *mut i32, ppunk: *mut ::core::option::Option<::windows::core::IUnknown>) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).GetInfoFromContext)(::windows::core::Interface::as_raw(self), pszcode.into_param().abi(), cchcode, ichcurrentposition, dwlisttypesrequested, pdwlisttypesprovided, pichlistanchorposition, pichfuncanchorposition, pmemid, picurrentparameter, ::core::mem::transmute(ppunk)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IsCommitChar(&self, ch: u16) -> ::windows::core::Result<super::super::super::Foundation::BOOL> {
        let mut result__ = ::windows::core::zeroed::<super::super::super::Foundation::BOOL>();
        (::windows::core::Interface::vtable(self).IsCommitChar)(::windows::core::Interface::as_raw(self), ch, &mut result__).from_abi(result__)
    }
}
::windows::imp::interface_hierarchy!(IActiveScriptAuthor, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IActiveScriptAuthor {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IActiveScriptAuthor {}
impl ::core::fmt::Debug for IActiveScriptAuthor {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IActiveScriptAuthor").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptAuthor {
    type Vtable = IActiveScriptAuthor_Vtbl;
}
impl ::core::clone::Clone for IActiveScriptAuthor {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IActiveScriptAuthor {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x9c109da0_7006_11d1_b36c_00a0c911e8b2);
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptAuthor_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub AddNamedItem: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszname: ::windows::core::PCWSTR, dwflags: u32, pdisp: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    AddNamedItem: usize,
    pub AddScriptlet: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszdefaultname: ::windows::core::PCWSTR, pszcode: ::windows::core::PCWSTR, pszitemname: ::windows::core::PCWSTR, pszsubitemname: ::windows::core::PCWSTR, pszeventname: ::windows::core::PCWSTR, pszdelimiter: ::windows::core::PCWSTR, dwcookie: u32, dwflags: u32) -> ::windows::core::HRESULT,
    pub ParseScriptText: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszcode: ::windows::core::PCWSTR, pszitemname: ::windows::core::PCWSTR, pszdelimiter: ::windows::core::PCWSTR, dwcookie: u32, dwflags: u32) -> ::windows::core::HRESULT,
    pub GetScriptTextAttributes: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszcode: ::windows::core::PCWSTR, cch: u32, pszdelimiter: ::windows::core::PCWSTR, dwflags: u32, pattr: *mut u16) -> ::windows::core::HRESULT,
    pub GetScriptletTextAttributes: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszcode: ::windows::core::PCWSTR, cch: u32, pszdelimiter: ::windows::core::PCWSTR, dwflags: u32, pattr: *mut u16) -> ::windows::core::HRESULT,
    pub GetRoot: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppsp: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetLanguageFlags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pgrfasa: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub GetEventHandler: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdisp: *mut ::core::ffi::c_void, pszitem: ::windows::core::PCWSTR, pszsubitem: ::windows::core::PCWSTR, pszevent: ::windows::core::PCWSTR, ppse: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    GetEventHandler: usize,
    pub RemoveNamedItem: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszname: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub AddTypeLib: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, rguidtypelib: *const ::windows::core::GUID, dwmajor: u32, dwminor: u32, dwflags: u32) -> ::windows::core::HRESULT,
    pub RemoveTypeLib: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, rguidtypelib: *const ::windows::core::GUID, dwmajor: u32, dwminor: u32) -> ::windows::core::HRESULT,
    pub GetChars: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, frequestedlist: u32, pbstrchars: *mut ::std::mem::MaybeUninit<::windows::core::BSTR>) -> ::windows::core::HRESULT,
    pub GetInfoFromContext: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszcode: ::windows::core::PCWSTR, cchcode: u32, ichcurrentposition: u32, dwlisttypesrequested: u32, pdwlisttypesprovided: *mut u32, pichlistanchorposition: *mut u32, pichfuncanchorposition: *mut u32, pmemid: *mut i32, picurrentparameter: *mut i32, ppunk: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub IsCommitChar: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ch: u16, pfcommit: *mut super::super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    IsCommitChar: usize,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IActiveScriptAuthorProcedure(::windows::core::IUnknown);
impl IActiveScriptAuthorProcedure {
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn ParseProcedureText<P0, P1, P2, P3, P4, P5>(&self, pszcode: P0, pszformalparams: P1, pszprocedurename: P2, pszitemname: P3, pszdelimiter: P4, dwcookie: u32, dwflags: u32, pdispfor: P5) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P2: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P3: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P4: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P5: ::windows::core::IntoParam<super::super::Com::IDispatch>,
    {
        (::windows::core::Interface::vtable(self).ParseProcedureText)(::windows::core::Interface::as_raw(self), pszcode.into_param().abi(), pszformalparams.into_param().abi(), pszprocedurename.into_param().abi(), pszitemname.into_param().abi(), pszdelimiter.into_param().abi(), dwcookie, dwflags, pdispfor.into_param().abi()).ok()
    }
}
::windows::imp::interface_hierarchy!(IActiveScriptAuthorProcedure, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IActiveScriptAuthorProcedure {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IActiveScriptAuthorProcedure {}
impl ::core::fmt::Debug for IActiveScriptAuthorProcedure {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IActiveScriptAuthorProcedure").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptAuthorProcedure {
    type Vtable = IActiveScriptAuthorProcedure_Vtbl;
}
impl ::core::clone::Clone for IActiveScriptAuthorProcedure {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IActiveScriptAuthorProcedure {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x7e2d4b70_bd9a_11d0_9336_00a0c90dcaa9);
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptAuthorProcedure_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub ParseProcedureText: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszcode: ::windows::core::PCWSTR, pszformalparams: ::windows::core::PCWSTR, pszprocedurename: ::windows::core::PCWSTR, pszitemname: ::windows::core::PCWSTR, pszdelimiter: ::windows::core::PCWSTR, dwcookie: u32, dwflags: u32, pdispfor: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    ParseProcedureText: usize,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IActiveScriptDebug32(::windows::core::IUnknown);
impl IActiveScriptDebug32 {
    pub unsafe fn GetScriptTextAttributes<P0, P1>(&self, pstrcode: P0, unumcodechars: u32, pstrdelimiter: P1, dwflags: u32, pattr: *mut u16) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).GetScriptTextAttributes)(::windows::core::Interface::as_raw(self), pstrcode.into_param().abi(), unumcodechars, pstrdelimiter.into_param().abi(), dwflags, pattr).ok()
    }
    pub unsafe fn GetScriptletTextAttributes<P0, P1>(&self, pstrcode: P0, unumcodechars: u32, pstrdelimiter: P1, dwflags: u32, pattr: *mut u16) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).GetScriptletTextAttributes)(::windows::core::Interface::as_raw(self), pstrcode.into_param().abi(), unumcodechars, pstrdelimiter.into_param().abi(), dwflags, pattr).ok()
    }
    pub unsafe fn EnumCodeContextsOfPosition(&self, dwsourcecontext: u32, ucharacteroffset: u32, unumchars: u32) -> ::windows::core::Result<IEnumDebugCodeContexts> {
        let mut result__ = ::windows::core::zeroed::<IEnumDebugCodeContexts>();
        (::windows::core::Interface::vtable(self).EnumCodeContextsOfPosition)(::windows::core::Interface::as_raw(self), dwsourcecontext, ucharacteroffset, unumchars, &mut result__).from_abi(result__)
    }
}
::windows::imp::interface_hierarchy!(IActiveScriptDebug32, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IActiveScriptDebug32 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IActiveScriptDebug32 {}
impl ::core::fmt::Debug for IActiveScriptDebug32 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IActiveScriptDebug32").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptDebug32 {
    type Vtable = IActiveScriptDebug32_Vtbl;
}
impl ::core::clone::Clone for IActiveScriptDebug32 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IActiveScriptDebug32 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x51973c10_cb0c_11d0_b5c9_00a0244a0e7a);
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptDebug32_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub GetScriptTextAttributes: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstrcode: ::windows::core::PCWSTR, unumcodechars: u32, pstrdelimiter: ::windows::core::PCWSTR, dwflags: u32, pattr: *mut u16) -> ::windows::core::HRESULT,
    pub GetScriptletTextAttributes: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstrcode: ::windows::core::PCWSTR, unumcodechars: u32, pstrdelimiter: ::windows::core::PCWSTR, dwflags: u32, pattr: *mut u16) -> ::windows::core::HRESULT,
    pub EnumCodeContextsOfPosition: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwsourcecontext: u32, ucharacteroffset: u32, unumchars: u32, ppescc: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IActiveScriptDebug64(::windows::core::IUnknown);
impl IActiveScriptDebug64 {
    pub unsafe fn GetScriptTextAttributes<P0, P1>(&self, pstrcode: P0, unumcodechars: u32, pstrdelimiter: P1, dwflags: u32, pattr: *mut u16) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).GetScriptTextAttributes)(::windows::core::Interface::as_raw(self), pstrcode.into_param().abi(), unumcodechars, pstrdelimiter.into_param().abi(), dwflags, pattr).ok()
    }
    pub unsafe fn GetScriptletTextAttributes<P0, P1>(&self, pstrcode: P0, unumcodechars: u32, pstrdelimiter: P1, dwflags: u32, pattr: *mut u16) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).GetScriptletTextAttributes)(::windows::core::Interface::as_raw(self), pstrcode.into_param().abi(), unumcodechars, pstrdelimiter.into_param().abi(), dwflags, pattr).ok()
    }
    pub unsafe fn EnumCodeContextsOfPosition(&self, dwsourcecontext: u64, ucharacteroffset: u32, unumchars: u32) -> ::windows::core::Result<IEnumDebugCodeContexts> {
        let mut result__ = ::windows::core::zeroed::<IEnumDebugCodeContexts>();
        (::windows::core::Interface::vtable(self).EnumCodeContextsOfPosition)(::windows::core::Interface::as_raw(self), dwsourcecontext, ucharacteroffset, unumchars, &mut result__).from_abi(result__)
    }
}
::windows::imp::interface_hierarchy!(IActiveScriptDebug64, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IActiveScriptDebug64 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IActiveScriptDebug64 {}
impl ::core::fmt::Debug for IActiveScriptDebug64 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IActiveScriptDebug64").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptDebug64 {
    type Vtable = IActiveScriptDebug64_Vtbl;
}
impl ::core::clone::Clone for IActiveScriptDebug64 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IActiveScriptDebug64 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xbc437e23_f5b8_47f4_bb79_7d1ce5483b86);
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptDebug64_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub GetScriptTextAttributes: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstrcode: ::windows::core::PCWSTR, unumcodechars: u32, pstrdelimiter: ::windows::core::PCWSTR, dwflags: u32, pattr: *mut u16) -> ::windows::core::HRESULT,
    pub GetScriptletTextAttributes: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstrcode: ::windows::core::PCWSTR, unumcodechars: u32, pstrdelimiter: ::windows::core::PCWSTR, dwflags: u32, pattr: *mut u16) -> ::windows::core::HRESULT,
    pub EnumCodeContextsOfPosition: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwsourcecontext: u64, ucharacteroffset: u32, unumchars: u32, ppescc: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IActiveScriptEncode(::windows::core::IUnknown);
impl IActiveScriptEncode {
    pub unsafe fn EncodeSection<P0>(&self, pchin: P0, cchin: u32, pchout: ::windows::core::PWSTR, cchout: u32, pcchret: *mut u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).EncodeSection)(::windows::core::Interface::as_raw(self), pchin.into_param().abi(), cchin, ::core::mem::transmute(pchout), cchout, pcchret).ok()
    }
    pub unsafe fn DecodeScript<P0>(&self, pchin: P0, cchin: u32, pchout: ::windows::core::PWSTR, cchout: u32, pcchret: *mut u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).DecodeScript)(::windows::core::Interface::as_raw(self), pchin.into_param().abi(), cchin, ::core::mem::transmute(pchout), cchout, pcchret).ok()
    }
    pub unsafe fn GetEncodeProgId(&self, pbstrout: *mut ::windows::core::BSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetEncodeProgId)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pbstrout)).ok()
    }
}
::windows::imp::interface_hierarchy!(IActiveScriptEncode, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IActiveScriptEncode {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IActiveScriptEncode {}
impl ::core::fmt::Debug for IActiveScriptEncode {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IActiveScriptEncode").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptEncode {
    type Vtable = IActiveScriptEncode_Vtbl;
}
impl ::core::clone::Clone for IActiveScriptEncode {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IActiveScriptEncode {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xbb1a2ae3_a4f9_11cf_8f20_00805f2cd064);
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptEncode_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub EncodeSection: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pchin: ::windows::core::PCWSTR, cchin: u32, pchout: ::windows::core::PWSTR, cchout: u32, pcchret: *mut u32) -> ::windows::core::HRESULT,
    pub DecodeScript: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pchin: ::windows::core::PCWSTR, cchin: u32, pchout: ::windows::core::PWSTR, cchout: u32, pcchret: *mut u32) -> ::windows::core::HRESULT,
    pub GetEncodeProgId: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrout: *mut ::std::mem::MaybeUninit<::windows::core::BSTR>) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IActiveScriptError(::windows::core::IUnknown);
impl IActiveScriptError {
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetExceptionInfo(&self, pexcepinfo: *mut super::super::Com::EXCEPINFO) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetExceptionInfo)(::windows::core::Interface::as_raw(self), pexcepinfo).ok()
    }
    pub unsafe fn GetSourcePosition(&self, pdwsourcecontext: *mut u32, pullinenumber: *mut u32, plcharacterposition: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetSourcePosition)(::windows::core::Interface::as_raw(self), pdwsourcecontext, pullinenumber, plcharacterposition).ok()
    }
    pub unsafe fn GetSourceLineText(&self) -> ::windows::core::Result<::windows::core::BSTR> {
        let mut result__ = ::windows::core::zeroed::<::windows::core::BSTR>();
        (::windows::core::Interface::vtable(self).GetSourceLineText)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
}
::windows::imp::interface_hierarchy!(IActiveScriptError, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IActiveScriptError {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IActiveScriptError {}
impl ::core::fmt::Debug for IActiveScriptError {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IActiveScriptError").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptError {
    type Vtable = IActiveScriptError_Vtbl;
}
impl ::core::clone::Clone for IActiveScriptError {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IActiveScriptError {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xeae1ba61_a4ed_11cf_8f20_00805f2cd064);
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptError_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub GetExceptionInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pexcepinfo: *mut super::super::Com::EXCEPINFO) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    GetExceptionInfo: usize,
    pub GetSourcePosition: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwsourcecontext: *mut u32, pullinenumber: *mut u32, plcharacterposition: *mut i32) -> ::windows::core::HRESULT,
    pub GetSourceLineText: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrsourceline: *mut ::std::mem::MaybeUninit<::windows::core::BSTR>) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IActiveScriptError64(::windows::core::IUnknown);
impl IActiveScriptError64 {
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetExceptionInfo(&self, pexcepinfo: *mut super::super::Com::EXCEPINFO) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.GetExceptionInfo)(::windows::core::Interface::as_raw(self), pexcepinfo).ok()
    }
    pub unsafe fn GetSourcePosition(&self, pdwsourcecontext: *mut u32, pullinenumber: *mut u32, plcharacterposition: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.GetSourcePosition)(::windows::core::Interface::as_raw(self), pdwsourcecontext, pullinenumber, plcharacterposition).ok()
    }
    pub unsafe fn GetSourceLineText(&self) -> ::windows::core::Result<::windows::core::BSTR> {
        let mut result__ = ::windows::core::zeroed::<::windows::core::BSTR>();
        (::windows::core::Interface::vtable(self).base__.GetSourceLineText)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetSourcePosition64(&self, pdwsourcecontext: *mut u64, pullinenumber: *mut u32, plcharacterposition: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetSourcePosition64)(::windows::core::Interface::as_raw(self), pdwsourcecontext, pullinenumber, plcharacterposition).ok()
    }
}
::windows::imp::interface_hierarchy!(IActiveScriptError64, ::windows::core::IUnknown, IActiveScriptError);
impl ::core::cmp::PartialEq for IActiveScriptError64 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IActiveScriptError64 {}
impl ::core::fmt::Debug for IActiveScriptError64 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IActiveScriptError64").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptError64 {
    type Vtable = IActiveScriptError64_Vtbl;
}
impl ::core::clone::Clone for IActiveScriptError64 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IActiveScriptError64 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xb21fb2a1_5b8f_4963_8c21_21450f84ed7f);
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptError64_Vtbl {
    pub base__: IActiveScriptError_Vtbl,
    pub GetSourcePosition64: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwsourcecontext: *mut u64, pullinenumber: *mut u32, plcharacterposition: *mut i32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IActiveScriptErrorDebug(::windows::core::IUnknown);
impl IActiveScriptErrorDebug {
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetExceptionInfo(&self, pexcepinfo: *mut super::super::Com::EXCEPINFO) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.GetExceptionInfo)(::windows::core::Interface::as_raw(self), pexcepinfo).ok()
    }
    pub unsafe fn GetSourcePosition(&self, pdwsourcecontext: *mut u32, pullinenumber: *mut u32, plcharacterposition: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.GetSourcePosition)(::windows::core::Interface::as_raw(self), pdwsourcecontext, pullinenumber, plcharacterposition).ok()
    }
    pub unsafe fn GetSourceLineText(&self) -> ::windows::core::Result<::windows::core::BSTR> {
        let mut result__ = ::windows::core::zeroed::<::windows::core::BSTR>();
        (::windows::core::Interface::vtable(self).base__.GetSourceLineText)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetDocumentContext(&self) -> ::windows::core::Result<IDebugDocumentContext> {
        let mut result__ = ::windows::core::zeroed::<IDebugDocumentContext>();
        (::windows::core::Interface::vtable(self).GetDocumentContext)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetStackFrame(&self) -> ::windows::core::Result<IDebugStackFrame> {
        let mut result__ = ::windows::core::zeroed::<IDebugStackFrame>();
        (::windows::core::Interface::vtable(self).GetStackFrame)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
}
::windows::imp::interface_hierarchy!(IActiveScriptErrorDebug, ::windows::core::IUnknown, IActiveScriptError);
impl ::core::cmp::PartialEq for IActiveScriptErrorDebug {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IActiveScriptErrorDebug {}
impl ::core::fmt::Debug for IActiveScriptErrorDebug {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IActiveScriptErrorDebug").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptErrorDebug {
    type Vtable = IActiveScriptErrorDebug_Vtbl;
}
impl ::core::clone::Clone for IActiveScriptErrorDebug {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IActiveScriptErrorDebug {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x51973c12_cb0c_11d0_b5c9_00a0244a0e7a);
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptErrorDebug_Vtbl {
    pub base__: IActiveScriptError_Vtbl,
    pub GetDocumentContext: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppssc: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetStackFrame: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppdsf: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IActiveScriptErrorDebug110(::windows::core::IUnknown);
impl IActiveScriptErrorDebug110 {
    pub unsafe fn GetExceptionThrownKind(&self) -> ::windows::core::Result<SCRIPT_ERROR_DEBUG_EXCEPTION_THROWN_KIND> {
        let mut result__ = ::windows::core::zeroed::<SCRIPT_ERROR_DEBUG_EXCEPTION_THROWN_KIND>();
        (::windows::core::Interface::vtable(self).GetExceptionThrownKind)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
}
::windows::imp::interface_hierarchy!(IActiveScriptErrorDebug110, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IActiveScriptErrorDebug110 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IActiveScriptErrorDebug110 {}
impl ::core::fmt::Debug for IActiveScriptErrorDebug110 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IActiveScriptErrorDebug110").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptErrorDebug110 {
    type Vtable = IActiveScriptErrorDebug110_Vtbl;
}
impl ::core::clone::Clone for IActiveScriptErrorDebug110 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IActiveScriptErrorDebug110 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x516e42b6_89a8_4530_937b_5f0708431442);
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptErrorDebug110_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub GetExceptionThrownKind: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pexceptionkind: *mut SCRIPT_ERROR_DEBUG_EXCEPTION_THROWN_KIND) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IActiveScriptGarbageCollector(::windows::core::IUnknown);
impl IActiveScriptGarbageCollector {
    pub unsafe fn CollectGarbage(&self, scriptgctype: SCRIPTGCTYPE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).CollectGarbage)(::windows::core::Interface::as_raw(self), scriptgctype).ok()
    }
}
::windows::imp::interface_hierarchy!(IActiveScriptGarbageCollector, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IActiveScriptGarbageCollector {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IActiveScriptGarbageCollector {}
impl ::core::fmt::Debug for IActiveScriptGarbageCollector {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IActiveScriptGarbageCollector").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptGarbageCollector {
    type Vtable = IActiveScriptGarbageCollector_Vtbl;
}
impl ::core::clone::Clone for IActiveScriptGarbageCollector {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IActiveScriptGarbageCollector {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x6aa2c4a0_2b53_11d4_a2a0_00104bd35090);
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptGarbageCollector_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub CollectGarbage: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, scriptgctype: SCRIPTGCTYPE) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IActiveScriptHostEncode(::windows::core::IUnknown);
impl IActiveScriptHostEncode {
    pub unsafe fn EncodeScriptHostFile<P0, P1>(&self, bstrinfile: P0, pbstroutfile: *mut ::windows::core::BSTR, cflags: u32, bstrdefaultlang: P1) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::BSTR>,
        P1: ::windows::core::IntoParam<::windows::core::BSTR>,
    {
        (::windows::core::Interface::vtable(self).EncodeScriptHostFile)(::windows::core::Interface::as_raw(self), bstrinfile.into_param().abi(), ::core::mem::transmute(pbstroutfile), cflags, bstrdefaultlang.into_param().abi()).ok()
    }
}
::windows::imp::interface_hierarchy!(IActiveScriptHostEncode, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IActiveScriptHostEncode {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IActiveScriptHostEncode {}
impl ::core::fmt::Debug for IActiveScriptHostEncode {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IActiveScriptHostEncode").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptHostEncode {
    type Vtable = IActiveScriptHostEncode_Vtbl;
}
impl ::core::clone::Clone for IActiveScriptHostEncode {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IActiveScriptHostEncode {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xbee9b76e_cfe3_11d1_b747_00c04fc2b085);
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptHostEncode_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub EncodeScriptHostFile: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bstrinfile: ::std::mem::MaybeUninit<::windows::core::BSTR>, pbstroutfile: *mut ::std::mem::MaybeUninit<::windows::core::BSTR>, cflags: u32, bstrdefaultlang: ::std::mem::MaybeUninit<::windows::core::BSTR>) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IActiveScriptParse32(::windows::core::IUnknown);
impl IActiveScriptParse32 {
    pub unsafe fn InitNew(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).InitNew)(::windows::core::Interface::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn AddScriptlet<P0, P1, P2, P3, P4, P5>(&self, pstrdefaultname: P0, pstrcode: P1, pstritemname: P2, pstrsubitemname: P3, pstreventname: P4, pstrdelimiter: P5, dwsourcecontextcookie: u32, ulstartinglinenumber: u32, dwflags: u32, pbstrname: *mut ::windows::core::BSTR, pexcepinfo: *mut super::super::Com::EXCEPINFO) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P2: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P3: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P4: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P5: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).AddScriptlet)(::windows::core::Interface::as_raw(self), pstrdefaultname.into_param().abi(), pstrcode.into_param().abi(), pstritemname.into_param().abi(), pstrsubitemname.into_param().abi(), pstreventname.into_param().abi(), pstrdelimiter.into_param().abi(), dwsourcecontextcookie, ulstartinglinenumber, dwflags, ::core::mem::transmute(pbstrname), pexcepinfo).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn ParseScriptText<P0, P1, P2, P3>(&self, pstrcode: P0, pstritemname: P1, punkcontext: P2, pstrdelimiter: P3, dwsourcecontextcookie: u32, ulstartinglinenumber: u32, dwflags: u32, pvarresult: *mut super::super::Com::VARIANT, pexcepinfo: *mut super::super::Com::EXCEPINFO) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P2: ::windows::core::IntoParam<::windows::core::IUnknown>,
        P3: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).ParseScriptText)(::windows::core::Interface::as_raw(self), pstrcode.into_param().abi(), pstritemname.into_param().abi(), punkcontext.into_param().abi(), pstrdelimiter.into_param().abi(), dwsourcecontextcookie, ulstartinglinenumber, dwflags, pvarresult, pexcepinfo).ok()
    }
}
::windows::imp::interface_hierarchy!(IActiveScriptParse32, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IActiveScriptParse32 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IActiveScriptParse32 {}
impl ::core::fmt::Debug for IActiveScriptParse32 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IActiveScriptParse32").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptParse32 {
    type Vtable = IActiveScriptParse32_Vtbl;
}
impl ::core::clone::Clone for IActiveScriptParse32 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IActiveScriptParse32 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xbb1a2ae2_a4f9_11cf_8f20_00805f2cd064);
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptParse32_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub InitNew: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub AddScriptlet: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstrdefaultname: ::windows::core::PCWSTR, pstrcode: ::windows::core::PCWSTR, pstritemname: ::windows::core::PCWSTR, pstrsubitemname: ::windows::core::PCWSTR, pstreventname: ::windows::core::PCWSTR, pstrdelimiter: ::windows::core::PCWSTR, dwsourcecontextcookie: u32, ulstartinglinenumber: u32, dwflags: u32, pbstrname: *mut ::std::mem::MaybeUninit<::windows::core::BSTR>, pexcepinfo: *mut super::super::Com::EXCEPINFO) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    AddScriptlet: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub ParseScriptText: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstrcode: ::windows::core::PCWSTR, pstritemname: ::windows::core::PCWSTR, punkcontext: *mut ::core::ffi::c_void, pstrdelimiter: ::windows::core::PCWSTR, dwsourcecontextcookie: u32, ulstartinglinenumber: u32, dwflags: u32, pvarresult: *mut super::super::Com::VARIANT, pexcepinfo: *mut super::super::Com::EXCEPINFO) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    ParseScriptText: usize,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IActiveScriptParse64(::windows::core::IUnknown);
impl IActiveScriptParse64 {
    pub unsafe fn InitNew(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).InitNew)(::windows::core::Interface::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn AddScriptlet<P0, P1, P2, P3, P4, P5>(&self, pstrdefaultname: P0, pstrcode: P1, pstritemname: P2, pstrsubitemname: P3, pstreventname: P4, pstrdelimiter: P5, dwsourcecontextcookie: u64, ulstartinglinenumber: u32, dwflags: u32, pbstrname: *mut ::windows::core::BSTR, pexcepinfo: *mut super::super::Com::EXCEPINFO) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P2: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P3: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P4: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P5: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).AddScriptlet)(::windows::core::Interface::as_raw(self), pstrdefaultname.into_param().abi(), pstrcode.into_param().abi(), pstritemname.into_param().abi(), pstrsubitemname.into_param().abi(), pstreventname.into_param().abi(), pstrdelimiter.into_param().abi(), dwsourcecontextcookie, ulstartinglinenumber, dwflags, ::core::mem::transmute(pbstrname), pexcepinfo).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn ParseScriptText<P0, P1, P2, P3>(&self, pstrcode: P0, pstritemname: P1, punkcontext: P2, pstrdelimiter: P3, dwsourcecontextcookie: u64, ulstartinglinenumber: u32, dwflags: u32, pvarresult: *mut super::super::Com::VARIANT, pexcepinfo: *mut super::super::Com::EXCEPINFO) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P2: ::windows::core::IntoParam<::windows::core::IUnknown>,
        P3: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).ParseScriptText)(::windows::core::Interface::as_raw(self), pstrcode.into_param().abi(), pstritemname.into_param().abi(), punkcontext.into_param().abi(), pstrdelimiter.into_param().abi(), dwsourcecontextcookie, ulstartinglinenumber, dwflags, pvarresult, pexcepinfo).ok()
    }
}
::windows::imp::interface_hierarchy!(IActiveScriptParse64, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IActiveScriptParse64 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IActiveScriptParse64 {}
impl ::core::fmt::Debug for IActiveScriptParse64 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IActiveScriptParse64").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptParse64 {
    type Vtable = IActiveScriptParse64_Vtbl;
}
impl ::core::clone::Clone for IActiveScriptParse64 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IActiveScriptParse64 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc7ef7658_e1ee_480e_97ea_d52cb4d76d17);
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptParse64_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub InitNew: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub AddScriptlet: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstrdefaultname: ::windows::core::PCWSTR, pstrcode: ::windows::core::PCWSTR, pstritemname: ::windows::core::PCWSTR, pstrsubitemname: ::windows::core::PCWSTR, pstreventname: ::windows::core::PCWSTR, pstrdelimiter: ::windows::core::PCWSTR, dwsourcecontextcookie: u64, ulstartinglinenumber: u32, dwflags: u32, pbstrname: *mut ::std::mem::MaybeUninit<::windows::core::BSTR>, pexcepinfo: *mut super::super::Com::EXCEPINFO) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    AddScriptlet: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub ParseScriptText: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstrcode: ::windows::core::PCWSTR, pstritemname: ::windows::core::PCWSTR, punkcontext: *mut ::core::ffi::c_void, pstrdelimiter: ::windows::core::PCWSTR, dwsourcecontextcookie: u64, ulstartinglinenumber: u32, dwflags: u32, pvarresult: *mut super::super::Com::VARIANT, pexcepinfo: *mut super::super::Com::EXCEPINFO) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    ParseScriptText: usize,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IActiveScriptParseProcedure2_32(::windows::core::IUnknown);
impl IActiveScriptParseProcedure2_32 {
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn ParseProcedureText<P0, P1, P2, P3, P4, P5>(&self, pstrcode: P0, pstrformalparams: P1, pstrprocedurename: P2, pstritemname: P3, punkcontext: P4, pstrdelimiter: P5, dwsourcecontextcookie: u32, ulstartinglinenumber: u32, dwflags: u32) -> ::windows::core::Result<super::super::Com::IDispatch>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P2: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P3: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P4: ::windows::core::IntoParam<::windows::core::IUnknown>,
        P5: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        let mut result__ = ::windows::core::zeroed::<super::super::Com::IDispatch>();
        (::windows::core::Interface::vtable(self).base__.ParseProcedureText)(::windows::core::Interface::as_raw(self), pstrcode.into_param().abi(), pstrformalparams.into_param().abi(), pstrprocedurename.into_param().abi(), pstritemname.into_param().abi(), punkcontext.into_param().abi(), pstrdelimiter.into_param().abi(), dwsourcecontextcookie, ulstartinglinenumber, dwflags, &mut result__).from_abi(result__)
    }
}
::windows::imp::interface_hierarchy!(IActiveScriptParseProcedure2_32, ::windows::core::IUnknown, IActiveScriptParseProcedure32);
impl ::core::cmp::PartialEq for IActiveScriptParseProcedure2_32 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IActiveScriptParseProcedure2_32 {}
impl ::core::fmt::Debug for IActiveScriptParseProcedure2_32 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IActiveScriptParseProcedure2_32").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptParseProcedure2_32 {
    type Vtable = IActiveScriptParseProcedure2_32_Vtbl;
}
impl ::core::clone::Clone for IActiveScriptParseProcedure2_32 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IActiveScriptParseProcedure2_32 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x71ee5b20_fb04_11d1_b3a8_00a0c911e8b2);
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptParseProcedure2_32_Vtbl {
    pub base__: IActiveScriptParseProcedure32_Vtbl,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IActiveScriptParseProcedure2_64(::windows::core::IUnknown);
impl IActiveScriptParseProcedure2_64 {
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn ParseProcedureText<P0, P1, P2, P3, P4, P5>(&self, pstrcode: P0, pstrformalparams: P1, pstrprocedurename: P2, pstritemname: P3, punkcontext: P4, pstrdelimiter: P5, dwsourcecontextcookie: u64, ulstartinglinenumber: u32, dwflags: u32) -> ::windows::core::Result<super::super::Com::IDispatch>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P2: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P3: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P4: ::windows::core::IntoParam<::windows::core::IUnknown>,
        P5: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        let mut result__ = ::windows::core::zeroed::<super::super::Com::IDispatch>();
        (::windows::core::Interface::vtable(self).base__.ParseProcedureText)(::windows::core::Interface::as_raw(self), pstrcode.into_param().abi(), pstrformalparams.into_param().abi(), pstrprocedurename.into_param().abi(), pstritemname.into_param().abi(), punkcontext.into_param().abi(), pstrdelimiter.into_param().abi(), dwsourcecontextcookie, ulstartinglinenumber, dwflags, &mut result__).from_abi(result__)
    }
}
::windows::imp::interface_hierarchy!(IActiveScriptParseProcedure2_64, ::windows::core::IUnknown, IActiveScriptParseProcedure64);
impl ::core::cmp::PartialEq for IActiveScriptParseProcedure2_64 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IActiveScriptParseProcedure2_64 {}
impl ::core::fmt::Debug for IActiveScriptParseProcedure2_64 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IActiveScriptParseProcedure2_64").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptParseProcedure2_64 {
    type Vtable = IActiveScriptParseProcedure2_64_Vtbl;
}
impl ::core::clone::Clone for IActiveScriptParseProcedure2_64 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IActiveScriptParseProcedure2_64 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xfe7c4271_210c_448d_9f54_76dab7047b28);
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptParseProcedure2_64_Vtbl {
    pub base__: IActiveScriptParseProcedure64_Vtbl,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IActiveScriptParseProcedure32(::windows::core::IUnknown);
impl IActiveScriptParseProcedure32 {
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn ParseProcedureText<P0, P1, P2, P3, P4, P5>(&self, pstrcode: P0, pstrformalparams: P1, pstrprocedurename: P2, pstritemname: P3, punkcontext: P4, pstrdelimiter: P5, dwsourcecontextcookie: u32, ulstartinglinenumber: u32, dwflags: u32) -> ::windows::core::Result<super::super::Com::IDispatch>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P2: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P3: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P4: ::windows::core::IntoParam<::windows::core::IUnknown>,
        P5: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        let mut result__ = ::windows::core::zeroed::<super::super::Com::IDispatch>();
        (::windows::core::Interface::vtable(self).ParseProcedureText)(::windows::core::Interface::as_raw(self), pstrcode.into_param().abi(), pstrformalparams.into_param().abi(), pstrprocedurename.into_param().abi(), pstritemname.into_param().abi(), punkcontext.into_param().abi(), pstrdelimiter.into_param().abi(), dwsourcecontextcookie, ulstartinglinenumber, dwflags, &mut result__).from_abi(result__)
    }
}
::windows::imp::interface_hierarchy!(IActiveScriptParseProcedure32, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IActiveScriptParseProcedure32 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IActiveScriptParseProcedure32 {}
impl ::core::fmt::Debug for IActiveScriptParseProcedure32 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IActiveScriptParseProcedure32").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptParseProcedure32 {
    type Vtable = IActiveScriptParseProcedure32_Vtbl;
}
impl ::core::clone::Clone for IActiveScriptParseProcedure32 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IActiveScriptParseProcedure32 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xaa5b6a80_b834_11d0_932f_00a0c90dcaa9);
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptParseProcedure32_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub ParseProcedureText: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstrcode: ::windows::core::PCWSTR, pstrformalparams: ::windows::core::PCWSTR, pstrprocedurename: ::windows::core::PCWSTR, pstritemname: ::windows::core::PCWSTR, punkcontext: *mut ::core::ffi::c_void, pstrdelimiter: ::windows::core::PCWSTR, dwsourcecontextcookie: u32, ulstartinglinenumber: u32, dwflags: u32, ppdisp: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    ParseProcedureText: usize,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IActiveScriptParseProcedure64(::windows::core::IUnknown);
impl IActiveScriptParseProcedure64 {
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn ParseProcedureText<P0, P1, P2, P3, P4, P5>(&self, pstrcode: P0, pstrformalparams: P1, pstrprocedurename: P2, pstritemname: P3, punkcontext: P4, pstrdelimiter: P5, dwsourcecontextcookie: u64, ulstartinglinenumber: u32, dwflags: u32) -> ::windows::core::Result<super::super::Com::IDispatch>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P2: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P3: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P4: ::windows::core::IntoParam<::windows::core::IUnknown>,
        P5: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        let mut result__ = ::windows::core::zeroed::<super::super::Com::IDispatch>();
        (::windows::core::Interface::vtable(self).ParseProcedureText)(::windows::core::Interface::as_raw(self), pstrcode.into_param().abi(), pstrformalparams.into_param().abi(), pstrprocedurename.into_param().abi(), pstritemname.into_param().abi(), punkcontext.into_param().abi(), pstrdelimiter.into_param().abi(), dwsourcecontextcookie, ulstartinglinenumber, dwflags, &mut result__).from_abi(result__)
    }
}
::windows::imp::interface_hierarchy!(IActiveScriptParseProcedure64, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IActiveScriptParseProcedure64 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IActiveScriptParseProcedure64 {}
impl ::core::fmt::Debug for IActiveScriptParseProcedure64 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IActiveScriptParseProcedure64").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptParseProcedure64 {
    type Vtable = IActiveScriptParseProcedure64_Vtbl;
}
impl ::core::clone::Clone for IActiveScriptParseProcedure64 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IActiveScriptParseProcedure64 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc64713b6_e029_4cc5_9200_438b72890b6a);
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptParseProcedure64_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub ParseProcedureText: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstrcode: ::windows::core::PCWSTR, pstrformalparams: ::windows::core::PCWSTR, pstrprocedurename: ::windows::core::PCWSTR, pstritemname: ::windows::core::PCWSTR, punkcontext: *mut ::core::ffi::c_void, pstrdelimiter: ::windows::core::PCWSTR, dwsourcecontextcookie: u64, ulstartinglinenumber: u32, dwflags: u32, ppdisp: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    ParseProcedureText: usize,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IActiveScriptParseProcedureOld32(::windows::core::IUnknown);
impl IActiveScriptParseProcedureOld32 {
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn ParseProcedureText<P0, P1, P2, P3, P4>(&self, pstrcode: P0, pstrformalparams: P1, pstritemname: P2, punkcontext: P3, pstrdelimiter: P4, dwsourcecontextcookie: u32, ulstartinglinenumber: u32, dwflags: u32) -> ::windows::core::Result<super::super::Com::IDispatch>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P2: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P3: ::windows::core::IntoParam<::windows::core::IUnknown>,
        P4: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        let mut result__ = ::windows::core::zeroed::<super::super::Com::IDispatch>();
        (::windows::core::Interface::vtable(self).ParseProcedureText)(::windows::core::Interface::as_raw(self), pstrcode.into_param().abi(), pstrformalparams.into_param().abi(), pstritemname.into_param().abi(), punkcontext.into_param().abi(), pstrdelimiter.into_param().abi(), dwsourcecontextcookie, ulstartinglinenumber, dwflags, &mut result__).from_abi(result__)
    }
}
::windows::imp::interface_hierarchy!(IActiveScriptParseProcedureOld32, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IActiveScriptParseProcedureOld32 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IActiveScriptParseProcedureOld32 {}
impl ::core::fmt::Debug for IActiveScriptParseProcedureOld32 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IActiveScriptParseProcedureOld32").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptParseProcedureOld32 {
    type Vtable = IActiveScriptParseProcedureOld32_Vtbl;
}
impl ::core::clone::Clone for IActiveScriptParseProcedureOld32 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IActiveScriptParseProcedureOld32 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1cff0050_6fdd_11d0_9328_00a0c90dcaa9);
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptParseProcedureOld32_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub ParseProcedureText: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstrcode: ::windows::core::PCWSTR, pstrformalparams: ::windows::core::PCWSTR, pstritemname: ::windows::core::PCWSTR, punkcontext: *mut ::core::ffi::c_void, pstrdelimiter: ::windows::core::PCWSTR, dwsourcecontextcookie: u32, ulstartinglinenumber: u32, dwflags: u32, ppdisp: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    ParseProcedureText: usize,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IActiveScriptParseProcedureOld64(::windows::core::IUnknown);
impl IActiveScriptParseProcedureOld64 {
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn ParseProcedureText<P0, P1, P2, P3, P4>(&self, pstrcode: P0, pstrformalparams: P1, pstritemname: P2, punkcontext: P3, pstrdelimiter: P4, dwsourcecontextcookie: u64, ulstartinglinenumber: u32, dwflags: u32) -> ::windows::core::Result<super::super::Com::IDispatch>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P2: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P3: ::windows::core::IntoParam<::windows::core::IUnknown>,
        P4: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        let mut result__ = ::windows::core::zeroed::<super::super::Com::IDispatch>();
        (::windows::core::Interface::vtable(self).ParseProcedureText)(::windows::core::Interface::as_raw(self), pstrcode.into_param().abi(), pstrformalparams.into_param().abi(), pstritemname.into_param().abi(), punkcontext.into_param().abi(), pstrdelimiter.into_param().abi(), dwsourcecontextcookie, ulstartinglinenumber, dwflags, &mut result__).from_abi(result__)
    }
}
::windows::imp::interface_hierarchy!(IActiveScriptParseProcedureOld64, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IActiveScriptParseProcedureOld64 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IActiveScriptParseProcedureOld64 {}
impl ::core::fmt::Debug for IActiveScriptParseProcedureOld64 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IActiveScriptParseProcedureOld64").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptParseProcedureOld64 {
    type Vtable = IActiveScriptParseProcedureOld64_Vtbl;
}
impl ::core::clone::Clone for IActiveScriptParseProcedureOld64 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IActiveScriptParseProcedureOld64 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x21f57128_08c9_4638_ba12_22d15d88dc5c);
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptParseProcedureOld64_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub ParseProcedureText: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstrcode: ::windows::core::PCWSTR, pstrformalparams: ::windows::core::PCWSTR, pstritemname: ::windows::core::PCWSTR, punkcontext: *mut ::core::ffi::c_void, pstrdelimiter: ::windows::core::PCWSTR, dwsourcecontextcookie: u64, ulstartinglinenumber: u32, dwflags: u32, ppdisp: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    ParseProcedureText: usize,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IActiveScriptProfilerCallback(::windows::core::IUnknown);
impl IActiveScriptProfilerCallback {
    pub unsafe fn Initialize(&self, dwcontext: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Initialize)(::windows::core::Interface::as_raw(self), dwcontext).ok()
    }
    pub unsafe fn Shutdown(&self, hrreason: ::windows::core::HRESULT) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Shutdown)(::windows::core::Interface::as_raw(self), hrreason).ok()
    }
    pub unsafe fn ScriptCompiled<P0>(&self, scriptid: i32, r#type: PROFILER_SCRIPT_TYPE, pidebugdocumentcontext: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::IUnknown>,
    {
        (::windows::core::Interface::vtable(self).ScriptCompiled)(::windows::core::Interface::as_raw(self), scriptid, r#type, pidebugdocumentcontext.into_param().abi()).ok()
    }
    pub unsafe fn FunctionCompiled<P0, P1, P2>(&self, functionid: i32, scriptid: i32, pwszfunctionname: P0, pwszfunctionnamehint: P1, pidebugdocumentcontext: P2) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P2: ::windows::core::IntoParam<::windows::core::IUnknown>,
    {
        (::windows::core::Interface::vtable(self).FunctionCompiled)(::windows::core::Interface::as_raw(self), functionid, scriptid, pwszfunctionname.into_param().abi(), pwszfunctionnamehint.into_param().abi(), pidebugdocumentcontext.into_param().abi()).ok()
    }
    pub unsafe fn OnFunctionEnter(&self, scriptid: i32, functionid: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).OnFunctionEnter)(::windows::core::Interface::as_raw(self), scriptid, functionid).ok()
    }
    pub unsafe fn OnFunctionExit(&self, scriptid: i32, functionid: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).OnFunctionExit)(::windows::core::Interface::as_raw(self), scriptid, functionid).ok()
    }
}
::windows::imp::interface_hierarchy!(IActiveScriptProfilerCallback, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IActiveScriptProfilerCallback {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IActiveScriptProfilerCallback {}
impl ::core::fmt::Debug for IActiveScriptProfilerCallback {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IActiveScriptProfilerCallback").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptProfilerCallback {
    type Vtable = IActiveScriptProfilerCallback_Vtbl;
}
impl ::core::clone::Clone for IActiveScriptProfilerCallback {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IActiveScriptProfilerCallback {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x740eca23_7d9d_42e5_ba9d_f8b24b1c7a9b);
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptProfilerCallback_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub Initialize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwcontext: u32) -> ::windows::core::HRESULT,
    pub Shutdown: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hrreason: ::windows::core::HRESULT) -> ::windows::core::HRESULT,
    pub ScriptCompiled: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, scriptid: i32, r#type: PROFILER_SCRIPT_TYPE, pidebugdocumentcontext: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub FunctionCompiled: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, functionid: i32, scriptid: i32, pwszfunctionname: ::windows::core::PCWSTR, pwszfunctionnamehint: ::windows::core::PCWSTR, pidebugdocumentcontext: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub OnFunctionEnter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, scriptid: i32, functionid: i32) -> ::windows::core::HRESULT,
    pub OnFunctionExit: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, scriptid: i32, functionid: i32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IActiveScriptProfilerCallback2(::windows::core::IUnknown);
impl IActiveScriptProfilerCallback2 {
    pub unsafe fn Initialize(&self, dwcontext: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.Initialize)(::windows::core::Interface::as_raw(self), dwcontext).ok()
    }
    pub unsafe fn Shutdown(&self, hrreason: ::windows::core::HRESULT) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.Shutdown)(::windows::core::Interface::as_raw(self), hrreason).ok()
    }
    pub unsafe fn ScriptCompiled<P0>(&self, scriptid: i32, r#type: PROFILER_SCRIPT_TYPE, pidebugdocumentcontext: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::IUnknown>,
    {
        (::windows::core::Interface::vtable(self).base__.ScriptCompiled)(::windows::core::Interface::as_raw(self), scriptid, r#type, pidebugdocumentcontext.into_param().abi()).ok()
    }
    pub unsafe fn FunctionCompiled<P0, P1, P2>(&self, functionid: i32, scriptid: i32, pwszfunctionname: P0, pwszfunctionnamehint: P1, pidebugdocumentcontext: P2) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P2: ::windows::core::IntoParam<::windows::core::IUnknown>,
    {
        (::windows::core::Interface::vtable(self).base__.FunctionCompiled)(::windows::core::Interface::as_raw(self), functionid, scriptid, pwszfunctionname.into_param().abi(), pwszfunctionnamehint.into_param().abi(), pidebugdocumentcontext.into_param().abi()).ok()
    }
    pub unsafe fn OnFunctionEnter(&self, scriptid: i32, functionid: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.OnFunctionEnter)(::windows::core::Interface::as_raw(self), scriptid, functionid).ok()
    }
    pub unsafe fn OnFunctionExit(&self, scriptid: i32, functionid: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.OnFunctionExit)(::windows::core::Interface::as_raw(self), scriptid, functionid).ok()
    }
    pub unsafe fn OnFunctionEnterByName<P0>(&self, pwszfunctionname: P0, r#type: PROFILER_SCRIPT_TYPE) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).OnFunctionEnterByName)(::windows::core::Interface::as_raw(self), pwszfunctionname.into_param().abi(), r#type).ok()
    }
    pub unsafe fn OnFunctionExitByName<P0>(&self, pwszfunctionname: P0, r#type: PROFILER_SCRIPT_TYPE) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).OnFunctionExitByName)(::windows::core::Interface::as_raw(self), pwszfunctionname.into_param().abi(), r#type).ok()
    }
}
::windows::imp::interface_hierarchy!(IActiveScriptProfilerCallback2, ::windows::core::IUnknown, IActiveScriptProfilerCallback);
impl ::core::cmp::PartialEq for IActiveScriptProfilerCallback2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IActiveScriptProfilerCallback2 {}
impl ::core::fmt::Debug for IActiveScriptProfilerCallback2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IActiveScriptProfilerCallback2").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptProfilerCallback2 {
    type Vtable = IActiveScriptProfilerCallback2_Vtbl;
}
impl ::core::clone::Clone for IActiveScriptProfilerCallback2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IActiveScriptProfilerCallback2 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x31b7f8ad_a637_409c_b22f_040995b6103d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptProfilerCallback2_Vtbl {
    pub base__: IActiveScriptProfilerCallback_Vtbl,
    pub OnFunctionEnterByName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pwszfunctionname: ::windows::core::PCWSTR, r#type: PROFILER_SCRIPT_TYPE) -> ::windows::core::HRESULT,
    pub OnFunctionExitByName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pwszfunctionname: ::windows::core::PCWSTR, r#type: PROFILER_SCRIPT_TYPE) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IActiveScriptProfilerCallback3(::windows::core::IUnknown);
impl IActiveScriptProfilerCallback3 {
    pub unsafe fn Initialize(&self, dwcontext: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.Initialize)(::windows::core::Interface::as_raw(self), dwcontext).ok()
    }
    pub unsafe fn Shutdown(&self, hrreason: ::windows::core::HRESULT) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.Shutdown)(::windows::core::Interface::as_raw(self), hrreason).ok()
    }
    pub unsafe fn ScriptCompiled<P0>(&self, scriptid: i32, r#type: PROFILER_SCRIPT_TYPE, pidebugdocumentcontext: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::IUnknown>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.ScriptCompiled)(::windows::core::Interface::as_raw(self), scriptid, r#type, pidebugdocumentcontext.into_param().abi()).ok()
    }
    pub unsafe fn FunctionCompiled<P0, P1, P2>(&self, functionid: i32, scriptid: i32, pwszfunctionname: P0, pwszfunctionnamehint: P1, pidebugdocumentcontext: P2) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P2: ::windows::core::IntoParam<::windows::core::IUnknown>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.FunctionCompiled)(::windows::core::Interface::as_raw(self), functionid, scriptid, pwszfunctionname.into_param().abi(), pwszfunctionnamehint.into_param().abi(), pidebugdocumentcontext.into_param().abi()).ok()
    }
    pub unsafe fn OnFunctionEnter(&self, scriptid: i32, functionid: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.OnFunctionEnter)(::windows::core::Interface::as_raw(self), scriptid, functionid).ok()
    }
    pub unsafe fn OnFunctionExit(&self, scriptid: i32, functionid: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.OnFunctionExit)(::windows::core::Interface::as_raw(self), scriptid, functionid).ok()
    }
    pub unsafe fn OnFunctionEnterByName<P0>(&self, pwszfunctionname: P0, r#type: PROFILER_SCRIPT_TYPE) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).base__.OnFunctionEnterByName)(::windows::core::Interface::as_raw(self), pwszfunctionname.into_param().abi(), r#type).ok()
    }
    pub unsafe fn OnFunctionExitByName<P0>(&self, pwszfunctionname: P0, r#type: PROFILER_SCRIPT_TYPE) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).base__.OnFunctionExitByName)(::windows::core::Interface::as_raw(self), pwszfunctionname.into_param().abi(), r#type).ok()
    }
    pub unsafe fn SetWebWorkerId(&self, webworkerid: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetWebWorkerId)(::windows::core::Interface::as_raw(self), webworkerid).ok()
    }
}
::windows::imp::interface_hierarchy!(IActiveScriptProfilerCallback3, ::windows::core::IUnknown, IActiveScriptProfilerCallback, IActiveScriptProfilerCallback2);
impl ::core::cmp::PartialEq for IActiveScriptProfilerCallback3 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IActiveScriptProfilerCallback3 {}
impl ::core::fmt::Debug for IActiveScriptProfilerCallback3 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IActiveScriptProfilerCallback3").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptProfilerCallback3 {
    type Vtable = IActiveScriptProfilerCallback3_Vtbl;
}
impl ::core::clone::Clone for IActiveScriptProfilerCallback3 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IActiveScriptProfilerCallback3 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x6ac5ad25_2037_4687_91df_b59979d93d73);
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptProfilerCallback3_Vtbl {
    pub base__: IActiveScriptProfilerCallback2_Vtbl,
    pub SetWebWorkerId: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, webworkerid: u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IActiveScriptProfilerControl(::windows::core::IUnknown);
impl IActiveScriptProfilerControl {
    pub unsafe fn StartProfiling(&self, clsidprofilerobject: *const ::windows::core::GUID, dweventmask: u32, dwcontext: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).StartProfiling)(::windows::core::Interface::as_raw(self), clsidprofilerobject, dweventmask, dwcontext).ok()
    }
    pub unsafe fn SetProfilerEventMask(&self, dweventmask: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetProfilerEventMask)(::windows::core::Interface::as_raw(self), dweventmask).ok()
    }
    pub unsafe fn StopProfiling(&self, hrshutdownreason: ::windows::core::HRESULT) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).StopProfiling)(::windows::core::Interface::as_raw(self), hrshutdownreason).ok()
    }
}
::windows::imp::interface_hierarchy!(IActiveScriptProfilerControl, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IActiveScriptProfilerControl {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IActiveScriptProfilerControl {}
impl ::core::fmt::Debug for IActiveScriptProfilerControl {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IActiveScriptProfilerControl").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptProfilerControl {
    type Vtable = IActiveScriptProfilerControl_Vtbl;
}
impl ::core::clone::Clone for IActiveScriptProfilerControl {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IActiveScriptProfilerControl {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x784b5ff0_69b0_47d1_a7dc_2518f4230e90);
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptProfilerControl_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub StartProfiling: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, clsidprofilerobject: *const ::windows::core::GUID, dweventmask: u32, dwcontext: u32) -> ::windows::core::HRESULT,
    pub SetProfilerEventMask: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dweventmask: u32) -> ::windows::core::HRESULT,
    pub StopProfiling: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hrshutdownreason: ::windows::core::HRESULT) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IActiveScriptProfilerControl2(::windows::core::IUnknown);
impl IActiveScriptProfilerControl2 {
    pub unsafe fn StartProfiling(&self, clsidprofilerobject: *const ::windows::core::GUID, dweventmask: u32, dwcontext: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.StartProfiling)(::windows::core::Interface::as_raw(self), clsidprofilerobject, dweventmask, dwcontext).ok()
    }
    pub unsafe fn SetProfilerEventMask(&self, dweventmask: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.SetProfilerEventMask)(::windows::core::Interface::as_raw(self), dweventmask).ok()
    }
    pub unsafe fn StopProfiling(&self, hrshutdownreason: ::windows::core::HRESULT) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.StopProfiling)(::windows::core::Interface::as_raw(self), hrshutdownreason).ok()
    }
    pub unsafe fn CompleteProfilerStart(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).CompleteProfilerStart)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn PrepareProfilerStop(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).PrepareProfilerStop)(::windows::core::Interface::as_raw(self)).ok()
    }
}
::windows::imp::interface_hierarchy!(IActiveScriptProfilerControl2, ::windows::core::IUnknown, IActiveScriptProfilerControl);
impl ::core::cmp::PartialEq for IActiveScriptProfilerControl2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IActiveScriptProfilerControl2 {}
impl ::core::fmt::Debug for IActiveScriptProfilerControl2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IActiveScriptProfilerControl2").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptProfilerControl2 {
    type Vtable = IActiveScriptProfilerControl2_Vtbl;
}
impl ::core::clone::Clone for IActiveScriptProfilerControl2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IActiveScriptProfilerControl2 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x47810165_498f_40be_94f1_653557e9e7da);
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptProfilerControl2_Vtbl {
    pub base__: IActiveScriptProfilerControl_Vtbl,
    pub CompleteProfilerStart: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub PrepareProfilerStop: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IActiveScriptProfilerControl3(::windows::core::IUnknown);
impl IActiveScriptProfilerControl3 {
    pub unsafe fn StartProfiling(&self, clsidprofilerobject: *const ::windows::core::GUID, dweventmask: u32, dwcontext: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.StartProfiling)(::windows::core::Interface::as_raw(self), clsidprofilerobject, dweventmask, dwcontext).ok()
    }
    pub unsafe fn SetProfilerEventMask(&self, dweventmask: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.SetProfilerEventMask)(::windows::core::Interface::as_raw(self), dweventmask).ok()
    }
    pub unsafe fn StopProfiling(&self, hrshutdownreason: ::windows::core::HRESULT) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.StopProfiling)(::windows::core::Interface::as_raw(self), hrshutdownreason).ok()
    }
    pub unsafe fn CompleteProfilerStart(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.CompleteProfilerStart)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn PrepareProfilerStop(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.PrepareProfilerStop)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn EnumHeap(&self) -> ::windows::core::Result<IActiveScriptProfilerHeapEnum> {
        let mut result__ = ::windows::core::zeroed::<IActiveScriptProfilerHeapEnum>();
        (::windows::core::Interface::vtable(self).EnumHeap)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
}
::windows::imp::interface_hierarchy!(IActiveScriptProfilerControl3, ::windows::core::IUnknown, IActiveScriptProfilerControl, IActiveScriptProfilerControl2);
impl ::core::cmp::PartialEq for IActiveScriptProfilerControl3 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IActiveScriptProfilerControl3 {}
impl ::core::fmt::Debug for IActiveScriptProfilerControl3 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IActiveScriptProfilerControl3").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptProfilerControl3 {
    type Vtable = IActiveScriptProfilerControl3_Vtbl;
}
impl ::core::clone::Clone for IActiveScriptProfilerControl3 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IActiveScriptProfilerControl3 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0b403015_f381_4023_a5d0_6fed076de716);
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptProfilerControl3_Vtbl {
    pub base__: IActiveScriptProfilerControl2_Vtbl,
    pub EnumHeap: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppenum: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IActiveScriptProfilerControl4(::windows::core::IUnknown);
impl IActiveScriptProfilerControl4 {
    pub unsafe fn StartProfiling(&self, clsidprofilerobject: *const ::windows::core::GUID, dweventmask: u32, dwcontext: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.base__.StartProfiling)(::windows::core::Interface::as_raw(self), clsidprofilerobject, dweventmask, dwcontext).ok()
    }
    pub unsafe fn SetProfilerEventMask(&self, dweventmask: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.base__.SetProfilerEventMask)(::windows::core::Interface::as_raw(self), dweventmask).ok()
    }
    pub unsafe fn StopProfiling(&self, hrshutdownreason: ::windows::core::HRESULT) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.base__.StopProfiling)(::windows::core::Interface::as_raw(self), hrshutdownreason).ok()
    }
    pub unsafe fn CompleteProfilerStart(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.CompleteProfilerStart)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn PrepareProfilerStop(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.PrepareProfilerStop)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn EnumHeap(&self) -> ::windows::core::Result<IActiveScriptProfilerHeapEnum> {
        let mut result__ = ::windows::core::zeroed::<IActiveScriptProfilerHeapEnum>();
        (::windows::core::Interface::vtable(self).base__.EnumHeap)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SummarizeHeap(&self, heapsummary: *mut PROFILER_HEAP_SUMMARY) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SummarizeHeap)(::windows::core::Interface::as_raw(self), heapsummary).ok()
    }
}
::windows::imp::interface_hierarchy!(IActiveScriptProfilerControl4, ::windows::core::IUnknown, IActiveScriptProfilerControl, IActiveScriptProfilerControl2, IActiveScriptProfilerControl3);
impl ::core::cmp::PartialEq for IActiveScriptProfilerControl4 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IActiveScriptProfilerControl4 {}
impl ::core::fmt::Debug for IActiveScriptProfilerControl4 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IActiveScriptProfilerControl4").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptProfilerControl4 {
    type Vtable = IActiveScriptProfilerControl4_Vtbl;
}
impl ::core::clone::Clone for IActiveScriptProfilerControl4 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IActiveScriptProfilerControl4 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x160f94fd_9dbc_40d4_9eac_2b71db3132f4);
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptProfilerControl4_Vtbl {
    pub base__: IActiveScriptProfilerControl3_Vtbl,
    pub SummarizeHeap: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, heapsummary: *mut PROFILER_HEAP_SUMMARY) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IActiveScriptProfilerControl5(::windows::core::IUnknown);
impl IActiveScriptProfilerControl5 {
    pub unsafe fn StartProfiling(&self, clsidprofilerobject: *const ::windows::core::GUID, dweventmask: u32, dwcontext: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.base__.base__.StartProfiling)(::windows::core::Interface::as_raw(self), clsidprofilerobject, dweventmask, dwcontext).ok()
    }
    pub unsafe fn SetProfilerEventMask(&self, dweventmask: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.base__.base__.SetProfilerEventMask)(::windows::core::Interface::as_raw(self), dweventmask).ok()
    }
    pub unsafe fn StopProfiling(&self, hrshutdownreason: ::windows::core::HRESULT) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.base__.base__.StopProfiling)(::windows::core::Interface::as_raw(self), hrshutdownreason).ok()
    }
    pub unsafe fn CompleteProfilerStart(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.base__.CompleteProfilerStart)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn PrepareProfilerStop(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.base__.PrepareProfilerStop)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn EnumHeap(&self) -> ::windows::core::Result<IActiveScriptProfilerHeapEnum> {
        let mut result__ = ::windows::core::zeroed::<IActiveScriptProfilerHeapEnum>();
        (::windows::core::Interface::vtable(self).base__.base__.EnumHeap)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SummarizeHeap(&self, heapsummary: *mut PROFILER_HEAP_SUMMARY) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.SummarizeHeap)(::windows::core::Interface::as_raw(self), heapsummary).ok()
    }
    pub unsafe fn EnumHeap2(&self, enumflags: PROFILER_HEAP_ENUM_FLAGS) -> ::windows::core::Result<IActiveScriptProfilerHeapEnum> {
        let mut result__ = ::windows::core::zeroed::<IActiveScriptProfilerHeapEnum>();
        (::windows::core::Interface::vtable(self).EnumHeap2)(::windows::core::Interface::as_raw(self), enumflags, &mut result__).from_abi(result__)
    }
}
::windows::imp::interface_hierarchy!(IActiveScriptProfilerControl5, ::windows::core::IUnknown, IActiveScriptProfilerControl, IActiveScriptProfilerControl2, IActiveScriptProfilerControl3, IActiveScriptProfilerControl4);
impl ::core::cmp::PartialEq for IActiveScriptProfilerControl5 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IActiveScriptProfilerControl5 {}
impl ::core::fmt::Debug for IActiveScriptProfilerControl5 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IActiveScriptProfilerControl5").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptProfilerControl5 {
    type Vtable = IActiveScriptProfilerControl5_Vtbl;
}
impl ::core::clone::Clone for IActiveScriptProfilerControl5 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IActiveScriptProfilerControl5 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1c01a2d1_8f0f_46a5_9720_0d7ed2c62f0a);
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptProfilerControl5_Vtbl {
    pub base__: IActiveScriptProfilerControl4_Vtbl,
    pub EnumHeap2: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, enumflags: PROFILER_HEAP_ENUM_FLAGS, ppenum: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IActiveScriptProfilerHeapEnum(::windows::core::IUnknown);
impl IActiveScriptProfilerHeapEnum {
    pub unsafe fn Next(&self, heapobjects: &mut [*mut PROFILER_HEAP_OBJECT], pceltfetched: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Next)(::windows::core::Interface::as_raw(self), heapobjects.len() as _, ::core::mem::transmute(heapobjects.as_ptr()), pceltfetched).ok()
    }
    pub unsafe fn GetOptionalInfo(&self, heapobject: *const PROFILER_HEAP_OBJECT, optionalinfo: &mut [PROFILER_HEAP_OBJECT_OPTIONAL_INFO]) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetOptionalInfo)(::windows::core::Interface::as_raw(self), heapobject, optionalinfo.len() as _, ::core::mem::transmute(optionalinfo.as_ptr())).ok()
    }
    pub unsafe fn FreeObjectAndOptionalInfo(&self, heapobjects: &[*const PROFILER_HEAP_OBJECT]) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).FreeObjectAndOptionalInfo)(::windows::core::Interface::as_raw(self), heapobjects.len() as _, ::core::mem::transmute(heapobjects.as_ptr())).ok()
    }
    pub unsafe fn GetNameIdMap(&self, pnamelist: *mut *mut *mut ::windows::core::PWSTR, pcelt: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetNameIdMap)(::windows::core::Interface::as_raw(self), pnamelist, pcelt).ok()
    }
}
::windows::imp::interface_hierarchy!(IActiveScriptProfilerHeapEnum, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IActiveScriptProfilerHeapEnum {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IActiveScriptProfilerHeapEnum {}
impl ::core::fmt::Debug for IActiveScriptProfilerHeapEnum {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IActiveScriptProfilerHeapEnum").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptProfilerHeapEnum {
    type Vtable = IActiveScriptProfilerHeapEnum_Vtbl;
}
impl ::core::clone::Clone for IActiveScriptProfilerHeapEnum {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IActiveScriptProfilerHeapEnum {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x32e4694e_0d37_419b_b93d_fa20ded6e8ea);
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptProfilerHeapEnum_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub Next: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, celt: u32, heapobjects: *mut *mut PROFILER_HEAP_OBJECT, pceltfetched: *mut u32) -> ::windows::core::HRESULT,
    pub GetOptionalInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, heapobject: *const PROFILER_HEAP_OBJECT, celt: u32, optionalinfo: *mut PROFILER_HEAP_OBJECT_OPTIONAL_INFO) -> ::windows::core::HRESULT,
    pub FreeObjectAndOptionalInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, celt: u32, heapobjects: *const *const PROFILER_HEAP_OBJECT) -> ::windows::core::HRESULT,
    pub GetNameIdMap: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pnamelist: *mut *mut *mut ::windows::core::PWSTR, pcelt: *mut u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IActiveScriptProperty(::windows::core::IUnknown);
impl IActiveScriptProperty {
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetProperty(&self, dwproperty: u32, pvarindex: *const super::super::Com::VARIANT) -> ::windows::core::Result<super::super::Com::VARIANT> {
        let mut result__ = ::windows::core::zeroed::<super::super::Com::VARIANT>();
        (::windows::core::Interface::vtable(self).GetProperty)(::windows::core::Interface::as_raw(self), dwproperty, pvarindex, &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn SetProperty(&self, dwproperty: u32, pvarindex: *const super::super::Com::VARIANT, pvarvalue: *const super::super::Com::VARIANT) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetProperty)(::windows::core::Interface::as_raw(self), dwproperty, pvarindex, pvarvalue).ok()
    }
}
::windows::imp::interface_hierarchy!(IActiveScriptProperty, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IActiveScriptProperty {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IActiveScriptProperty {}
impl ::core::fmt::Debug for IActiveScriptProperty {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IActiveScriptProperty").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptProperty {
    type Vtable = IActiveScriptProperty_Vtbl;
}
impl ::core::clone::Clone for IActiveScriptProperty {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IActiveScriptProperty {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x4954e0d0_fbc7_11d1_8410_006008c3fbfc);
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptProperty_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub GetProperty: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwproperty: u32, pvarindex: *const super::super::Com::VARIANT, pvarvalue: *mut super::super::Com::VARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    GetProperty: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub SetProperty: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwproperty: u32, pvarindex: *const super::super::Com::VARIANT, pvarvalue: *const super::super::Com::VARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    SetProperty: usize,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IActiveScriptSIPInfo(::windows::core::IUnknown);
impl IActiveScriptSIPInfo {
    pub unsafe fn GetSIPOID(&self) -> ::windows::core::Result<::windows::core::GUID> {
        let mut result__ = ::windows::core::zeroed::<::windows::core::GUID>();
        (::windows::core::Interface::vtable(self).GetSIPOID)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
}
::windows::imp::interface_hierarchy!(IActiveScriptSIPInfo, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IActiveScriptSIPInfo {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IActiveScriptSIPInfo {}
impl ::core::fmt::Debug for IActiveScriptSIPInfo {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IActiveScriptSIPInfo").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptSIPInfo {
    type Vtable = IActiveScriptSIPInfo_Vtbl;
}
impl ::core::clone::Clone for IActiveScriptSIPInfo {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IActiveScriptSIPInfo {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x764651d0_38de_11d4_a2a3_00104bd35090);
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptSIPInfo_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub GetSIPOID: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, poid_sip: *mut ::windows::core::GUID) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IActiveScriptSite(::windows::core::IUnknown);
impl IActiveScriptSite {
    pub unsafe fn GetLCID(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetLCID)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetItemInfo<P0>(&self, pstrname: P0, dwreturnmask: u32, ppiunkitem: *mut ::core::option::Option<::windows::core::IUnknown>, ppti: *mut ::core::option::Option<super::super::Com::ITypeInfo>) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).GetItemInfo)(::windows::core::Interface::as_raw(self), pstrname.into_param().abi(), dwreturnmask, ::core::mem::transmute(ppiunkitem), ::core::mem::transmute(ppti)).ok()
    }
    pub unsafe fn GetDocVersionString(&self) -> ::windows::core::Result<::windows::core::BSTR> {
        let mut result__ = ::windows::core::zeroed::<::windows::core::BSTR>();
        (::windows::core::Interface::vtable(self).GetDocVersionString)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn OnScriptTerminate(&self, pvarresult: *const super::super::Com::VARIANT, pexcepinfo: *const super::super::Com::EXCEPINFO) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).OnScriptTerminate)(::windows::core::Interface::as_raw(self), pvarresult, pexcepinfo).ok()
    }
    pub unsafe fn OnStateChange(&self, ssscriptstate: SCRIPTSTATE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).OnStateChange)(::windows::core::Interface::as_raw(self), ssscriptstate).ok()
    }
    pub unsafe fn OnScriptError<P0>(&self, pscripterror: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IActiveScriptError>,
    {
        (::windows::core::Interface::vtable(self).OnScriptError)(::windows::core::Interface::as_raw(self), pscripterror.into_param().abi()).ok()
    }
    pub unsafe fn OnEnterScript(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).OnEnterScript)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn OnLeaveScript(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).OnLeaveScript)(::windows::core::Interface::as_raw(self)).ok()
    }
}
::windows::imp::interface_hierarchy!(IActiveScriptSite, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IActiveScriptSite {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IActiveScriptSite {}
impl ::core::fmt::Debug for IActiveScriptSite {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IActiveScriptSite").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptSite {
    type Vtable = IActiveScriptSite_Vtbl;
}
impl ::core::clone::Clone for IActiveScriptSite {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IActiveScriptSite {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xdb01a1e3_a42b_11cf_8f20_00805f2cd064);
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptSite_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub GetLCID: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plcid: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub GetItemInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstrname: ::windows::core::PCWSTR, dwreturnmask: u32, ppiunkitem: *mut *mut ::core::ffi::c_void, ppti: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    GetItemInfo: usize,
    pub GetDocVersionString: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrversion: *mut ::std::mem::MaybeUninit<::windows::core::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub OnScriptTerminate: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvarresult: *const super::super::Com::VARIANT, pexcepinfo: *const super::super::Com::EXCEPINFO) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    OnScriptTerminate: usize,
    pub OnStateChange: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ssscriptstate: SCRIPTSTATE) -> ::windows::core::HRESULT,
    pub OnScriptError: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pscripterror: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub OnEnterScript: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub OnLeaveScript: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IActiveScriptSiteDebug32(::windows::core::IUnknown);
impl IActiveScriptSiteDebug32 {
    pub unsafe fn GetDocumentContextFromPosition(&self, dwsourcecontext: u32, ucharacteroffset: u32, unumchars: u32) -> ::windows::core::Result<IDebugDocumentContext> {
        let mut result__ = ::windows::core::zeroed::<IDebugDocumentContext>();
        (::windows::core::Interface::vtable(self).GetDocumentContextFromPosition)(::windows::core::Interface::as_raw(self), dwsourcecontext, ucharacteroffset, unumchars, &mut result__).from_abi(result__)
    }
    pub unsafe fn GetApplication(&self) -> ::windows::core::Result<IDebugApplication32> {
        let mut result__ = ::windows::core::zeroed::<IDebugApplication32>();
        (::windows::core::Interface::vtable(self).GetApplication)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetRootApplicationNode(&self) -> ::windows::core::Result<IDebugApplicationNode> {
        let mut result__ = ::windows::core::zeroed::<IDebugApplicationNode>();
        (::windows::core::Interface::vtable(self).GetRootApplicationNode)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnScriptErrorDebug<P0>(&self, perrordebug: P0, pfenterdebugger: *mut super::super::super::Foundation::BOOL, pfcallonscripterrorwhencontinuing: *mut super::super::super::Foundation::BOOL) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IActiveScriptErrorDebug>,
    {
        (::windows::core::Interface::vtable(self).OnScriptErrorDebug)(::windows::core::Interface::as_raw(self), perrordebug.into_param().abi(), pfenterdebugger, pfcallonscripterrorwhencontinuing).ok()
    }
}
::windows::imp::interface_hierarchy!(IActiveScriptSiteDebug32, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IActiveScriptSiteDebug32 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IActiveScriptSiteDebug32 {}
impl ::core::fmt::Debug for IActiveScriptSiteDebug32 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IActiveScriptSiteDebug32").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptSiteDebug32 {
    type Vtable = IActiveScriptSiteDebug32_Vtbl;
}
impl ::core::clone::Clone for IActiveScriptSiteDebug32 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IActiveScriptSiteDebug32 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x51973c11_cb0c_11d0_b5c9_00a0244a0e7a);
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptSiteDebug32_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub GetDocumentContextFromPosition: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwsourcecontext: u32, ucharacteroffset: u32, unumchars: u32, ppsc: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetApplication: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppda: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetRootApplicationNode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppdanroot: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub OnScriptErrorDebug: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, perrordebug: *mut ::core::ffi::c_void, pfenterdebugger: *mut super::super::super::Foundation::BOOL, pfcallonscripterrorwhencontinuing: *mut super::super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    OnScriptErrorDebug: usize,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IActiveScriptSiteDebug64(::windows::core::IUnknown);
impl IActiveScriptSiteDebug64 {
    pub unsafe fn GetDocumentContextFromPosition(&self, dwsourcecontext: u64, ucharacteroffset: u32, unumchars: u32) -> ::windows::core::Result<IDebugDocumentContext> {
        let mut result__ = ::windows::core::zeroed::<IDebugDocumentContext>();
        (::windows::core::Interface::vtable(self).GetDocumentContextFromPosition)(::windows::core::Interface::as_raw(self), dwsourcecontext, ucharacteroffset, unumchars, &mut result__).from_abi(result__)
    }
    pub unsafe fn GetApplication(&self) -> ::windows::core::Result<IDebugApplication64> {
        let mut result__ = ::windows::core::zeroed::<IDebugApplication64>();
        (::windows::core::Interface::vtable(self).GetApplication)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetRootApplicationNode(&self) -> ::windows::core::Result<IDebugApplicationNode> {
        let mut result__ = ::windows::core::zeroed::<IDebugApplicationNode>();
        (::windows::core::Interface::vtable(self).GetRootApplicationNode)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnScriptErrorDebug<P0>(&self, perrordebug: P0, pfenterdebugger: *mut super::super::super::Foundation::BOOL, pfcallonscripterrorwhencontinuing: *mut super::super::super::Foundation::BOOL) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IActiveScriptErrorDebug>,
    {
        (::windows::core::Interface::vtable(self).OnScriptErrorDebug)(::windows::core::Interface::as_raw(self), perrordebug.into_param().abi(), pfenterdebugger, pfcallonscripterrorwhencontinuing).ok()
    }
}
::windows::imp::interface_hierarchy!(IActiveScriptSiteDebug64, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IActiveScriptSiteDebug64 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IActiveScriptSiteDebug64 {}
impl ::core::fmt::Debug for IActiveScriptSiteDebug64 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IActiveScriptSiteDebug64").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptSiteDebug64 {
    type Vtable = IActiveScriptSiteDebug64_Vtbl;
}
impl ::core::clone::Clone for IActiveScriptSiteDebug64 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IActiveScriptSiteDebug64 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xd6b96b0a_7463_402c_92ac_89984226942f);
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptSiteDebug64_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub GetDocumentContextFromPosition: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwsourcecontext: u64, ucharacteroffset: u32, unumchars: u32, ppsc: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetApplication: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppda: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetRootApplicationNode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppdanroot: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub OnScriptErrorDebug: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, perrordebug: *mut ::core::ffi::c_void, pfenterdebugger: *mut super::super::super::Foundation::BOOL, pfcallonscripterrorwhencontinuing: *mut super::super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    OnScriptErrorDebug: usize,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IActiveScriptSiteDebugEx(::windows::core::IUnknown);
impl IActiveScriptSiteDebugEx {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnCanNotJITScriptErrorDebug<P0>(&self, perrordebug: P0) -> ::windows::core::Result<super::super::super::Foundation::BOOL>
    where
        P0: ::windows::core::IntoParam<IActiveScriptErrorDebug>,
    {
        let mut result__ = ::windows::core::zeroed::<super::super::super::Foundation::BOOL>();
        (::windows::core::Interface::vtable(self).OnCanNotJITScriptErrorDebug)(::windows::core::Interface::as_raw(self), perrordebug.into_param().abi(), &mut result__).from_abi(result__)
    }
}
::windows::imp::interface_hierarchy!(IActiveScriptSiteDebugEx, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IActiveScriptSiteDebugEx {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IActiveScriptSiteDebugEx {}
impl ::core::fmt::Debug for IActiveScriptSiteDebugEx {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IActiveScriptSiteDebugEx").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptSiteDebugEx {
    type Vtable = IActiveScriptSiteDebugEx_Vtbl;
}
impl ::core::clone::Clone for IActiveScriptSiteDebugEx {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IActiveScriptSiteDebugEx {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xbb722ccb_6ad2_41c6_b780_af9c03ee69f5);
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptSiteDebugEx_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub OnCanNotJITScriptErrorDebug: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, perrordebug: *mut ::core::ffi::c_void, pfcallonscripterrorwhencontinuing: *mut super::super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    OnCanNotJITScriptErrorDebug: usize,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IActiveScriptSiteInterruptPoll(::windows::core::IUnknown);
impl IActiveScriptSiteInterruptPoll {
    pub unsafe fn QueryContinue(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).QueryContinue)(::windows::core::Interface::as_raw(self)).ok()
    }
}
::windows::imp::interface_hierarchy!(IActiveScriptSiteInterruptPoll, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IActiveScriptSiteInterruptPoll {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IActiveScriptSiteInterruptPoll {}
impl ::core::fmt::Debug for IActiveScriptSiteInterruptPoll {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IActiveScriptSiteInterruptPoll").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptSiteInterruptPoll {
    type Vtable = IActiveScriptSiteInterruptPoll_Vtbl;
}
impl ::core::clone::Clone for IActiveScriptSiteInterruptPoll {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IActiveScriptSiteInterruptPoll {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x539698a0_cdca_11cf_a5eb_00aa0047a063);
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptSiteInterruptPoll_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub QueryContinue: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IActiveScriptSiteTraceInfo(::windows::core::IUnknown);
impl IActiveScriptSiteTraceInfo {
    pub unsafe fn SendScriptTraceInfo(&self, stieventtype: SCRIPTTRACEINFO, guidcontextid: ::windows::core::GUID, dwscriptcontextcookie: u32, lscriptstatementstart: i32, lscriptstatementend: i32, dwreserved: u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SendScriptTraceInfo)(::windows::core::Interface::as_raw(self), stieventtype, ::core::mem::transmute(guidcontextid), dwscriptcontextcookie, lscriptstatementstart, lscriptstatementend, dwreserved).ok()
    }
}
::windows::imp::interface_hierarchy!(IActiveScriptSiteTraceInfo, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IActiveScriptSiteTraceInfo {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IActiveScriptSiteTraceInfo {}
impl ::core::fmt::Debug for IActiveScriptSiteTraceInfo {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IActiveScriptSiteTraceInfo").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptSiteTraceInfo {
    type Vtable = IActiveScriptSiteTraceInfo_Vtbl;
}
impl ::core::clone::Clone for IActiveScriptSiteTraceInfo {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IActiveScriptSiteTraceInfo {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x4b7272ae_1955_4bfe_98b0_780621888569);
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptSiteTraceInfo_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub SendScriptTraceInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, stieventtype: SCRIPTTRACEINFO, guidcontextid: ::windows::core::GUID, dwscriptcontextcookie: u32, lscriptstatementstart: i32, lscriptstatementend: i32, dwreserved: u64) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IActiveScriptSiteUIControl(::windows::core::IUnknown);
impl IActiveScriptSiteUIControl {
    pub unsafe fn GetUIBehavior(&self, uicitem: SCRIPTUICITEM) -> ::windows::core::Result<SCRIPTUICHANDLING> {
        let mut result__ = ::windows::core::zeroed::<SCRIPTUICHANDLING>();
        (::windows::core::Interface::vtable(self).GetUIBehavior)(::windows::core::Interface::as_raw(self), uicitem, &mut result__).from_abi(result__)
    }
}
::windows::imp::interface_hierarchy!(IActiveScriptSiteUIControl, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IActiveScriptSiteUIControl {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IActiveScriptSiteUIControl {}
impl ::core::fmt::Debug for IActiveScriptSiteUIControl {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IActiveScriptSiteUIControl").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptSiteUIControl {
    type Vtable = IActiveScriptSiteUIControl_Vtbl;
}
impl ::core::clone::Clone for IActiveScriptSiteUIControl {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IActiveScriptSiteUIControl {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xaedae97e_d7ee_4796_b960_7f092ae844ab);
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptSiteUIControl_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub GetUIBehavior: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, uicitem: SCRIPTUICITEM, puichandling: *mut SCRIPTUICHANDLING) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IActiveScriptSiteWindow(::windows::core::IUnknown);
impl IActiveScriptSiteWindow {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetWindow(&self) -> ::windows::core::Result<super::super::super::Foundation::HWND> {
        let mut result__ = ::windows::core::zeroed::<super::super::super::Foundation::HWND>();
        (::windows::core::Interface::vtable(self).GetWindow)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn EnableModeless<P0>(&self, fenable: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<super::super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).EnableModeless)(::windows::core::Interface::as_raw(self), fenable.into_param().abi()).ok()
    }
}
::windows::imp::interface_hierarchy!(IActiveScriptSiteWindow, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IActiveScriptSiteWindow {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IActiveScriptSiteWindow {}
impl ::core::fmt::Debug for IActiveScriptSiteWindow {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IActiveScriptSiteWindow").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptSiteWindow {
    type Vtable = IActiveScriptSiteWindow_Vtbl;
}
impl ::core::clone::Clone for IActiveScriptSiteWindow {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IActiveScriptSiteWindow {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xd10f6761_83e9_11cf_8f20_00805f2cd064);
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptSiteWindow_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub GetWindow: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, phwnd: *mut super::super::super::Foundation::HWND) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetWindow: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub EnableModeless: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fenable: super::super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    EnableModeless: usize,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IActiveScriptStats(::windows::core::IUnknown);
impl IActiveScriptStats {
    pub unsafe fn GetStat(&self, stid: u32, pluhi: *mut u32, plulo: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetStat)(::windows::core::Interface::as_raw(self), stid, pluhi, plulo).ok()
    }
    pub unsafe fn GetStatEx(&self, guid: *const ::windows::core::GUID, pluhi: *mut u32, plulo: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetStatEx)(::windows::core::Interface::as_raw(self), guid, pluhi, plulo).ok()
    }
    pub unsafe fn ResetStats(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).ResetStats)(::windows::core::Interface::as_raw(self)).ok()
    }
}
::windows::imp::interface_hierarchy!(IActiveScriptStats, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IActiveScriptStats {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IActiveScriptStats {}
impl ::core::fmt::Debug for IActiveScriptStats {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IActiveScriptStats").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptStats {
    type Vtable = IActiveScriptStats_Vtbl;
}
impl ::core::clone::Clone for IActiveScriptStats {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IActiveScriptStats {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xb8da6310_e19b_11d0_933c_00a0c90dcaa9);
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptStats_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub GetStat: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, stid: u32, pluhi: *mut u32, plulo: *mut u32) -> ::windows::core::HRESULT,
    pub GetStatEx: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, guid: *const ::windows::core::GUID, pluhi: *mut u32, plulo: *mut u32) -> ::windows::core::HRESULT,
    pub ResetStats: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IActiveScriptStringCompare(::windows::core::IUnknown);
impl IActiveScriptStringCompare {
    pub unsafe fn StrComp<P0, P1>(&self, bszstr1: P0, bszstr2: P1) -> ::windows::core::Result<i32>
    where
        P0: ::windows::core::IntoParam<::windows::core::BSTR>,
        P1: ::windows::core::IntoParam<::windows::core::BSTR>,
    {
        let mut result__ = ::windows::core::zeroed::<i32>();
        (::windows::core::Interface::vtable(self).StrComp)(::windows::core::Interface::as_raw(self), bszstr1.into_param().abi(), bszstr2.into_param().abi(), &mut result__).from_abi(result__)
    }
}
::windows::imp::interface_hierarchy!(IActiveScriptStringCompare, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IActiveScriptStringCompare {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IActiveScriptStringCompare {}
impl ::core::fmt::Debug for IActiveScriptStringCompare {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IActiveScriptStringCompare").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptStringCompare {
    type Vtable = IActiveScriptStringCompare_Vtbl;
}
impl ::core::clone::Clone for IActiveScriptStringCompare {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IActiveScriptStringCompare {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x58562769_ed52_42f7_8403_4963514e1f11);
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptStringCompare_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub StrComp: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bszstr1: ::std::mem::MaybeUninit<::windows::core::BSTR>, bszstr2: ::std::mem::MaybeUninit<::windows::core::BSTR>, iret: *mut i32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IActiveScriptTraceInfo(::windows::core::IUnknown);
impl IActiveScriptTraceInfo {
    pub unsafe fn StartScriptTracing<P0>(&self, psitetraceinfo: P0, guidcontextid: ::windows::core::GUID) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IActiveScriptSiteTraceInfo>,
    {
        (::windows::core::Interface::vtable(self).StartScriptTracing)(::windows::core::Interface::as_raw(self), psitetraceinfo.into_param().abi(), ::core::mem::transmute(guidcontextid)).ok()
    }
    pub unsafe fn StopScriptTracing(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).StopScriptTracing)(::windows::core::Interface::as_raw(self)).ok()
    }
}
::windows::imp::interface_hierarchy!(IActiveScriptTraceInfo, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IActiveScriptTraceInfo {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IActiveScriptTraceInfo {}
impl ::core::fmt::Debug for IActiveScriptTraceInfo {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IActiveScriptTraceInfo").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptTraceInfo {
    type Vtable = IActiveScriptTraceInfo_Vtbl;
}
impl ::core::clone::Clone for IActiveScriptTraceInfo {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IActiveScriptTraceInfo {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc35456e7_bebf_4a1b_86a9_24d56be8b369);
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptTraceInfo_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub StartScriptTracing: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, psitetraceinfo: *mut ::core::ffi::c_void, guidcontextid: ::windows::core::GUID) -> ::windows::core::HRESULT,
    pub StopScriptTracing: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IActiveScriptWinRTErrorDebug(::windows::core::IUnknown);
impl IActiveScriptWinRTErrorDebug {
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetExceptionInfo(&self, pexcepinfo: *mut super::super::Com::EXCEPINFO) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.GetExceptionInfo)(::windows::core::Interface::as_raw(self), pexcepinfo).ok()
    }
    pub unsafe fn GetSourcePosition(&self, pdwsourcecontext: *mut u32, pullinenumber: *mut u32, plcharacterposition: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.GetSourcePosition)(::windows::core::Interface::as_raw(self), pdwsourcecontext, pullinenumber, plcharacterposition).ok()
    }
    pub unsafe fn GetSourceLineText(&self) -> ::windows::core::Result<::windows::core::BSTR> {
        let mut result__ = ::windows::core::zeroed::<::windows::core::BSTR>();
        (::windows::core::Interface::vtable(self).base__.GetSourceLineText)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetRestrictedErrorString(&self) -> ::windows::core::Result<::windows::core::BSTR> {
        let mut result__ = ::windows::core::zeroed::<::windows::core::BSTR>();
        (::windows::core::Interface::vtable(self).GetRestrictedErrorString)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetRestrictedErrorReference(&self) -> ::windows::core::Result<::windows::core::BSTR> {
        let mut result__ = ::windows::core::zeroed::<::windows::core::BSTR>();
        (::windows::core::Interface::vtable(self).GetRestrictedErrorReference)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetCapabilitySid(&self) -> ::windows::core::Result<::windows::core::BSTR> {
        let mut result__ = ::windows::core::zeroed::<::windows::core::BSTR>();
        (::windows::core::Interface::vtable(self).GetCapabilitySid)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
}
::windows::imp::interface_hierarchy!(IActiveScriptWinRTErrorDebug, ::windows::core::IUnknown, IActiveScriptError);
impl ::core::cmp::PartialEq for IActiveScriptWinRTErrorDebug {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IActiveScriptWinRTErrorDebug {}
impl ::core::fmt::Debug for IActiveScriptWinRTErrorDebug {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IActiveScriptWinRTErrorDebug").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IActiveScriptWinRTErrorDebug {
    type Vtable = IActiveScriptWinRTErrorDebug_Vtbl;
}
impl ::core::clone::Clone for IActiveScriptWinRTErrorDebug {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IActiveScriptWinRTErrorDebug {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x73a3f82a_0fe9_4b33_ba3b_fe095f697e0a);
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveScriptWinRTErrorDebug_Vtbl {
    pub base__: IActiveScriptError_Vtbl,
    pub GetRestrictedErrorString: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, errorstring: *mut ::std::mem::MaybeUninit<::windows::core::BSTR>) -> ::windows::core::HRESULT,
    pub GetRestrictedErrorReference: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, referencestring: *mut ::std::mem::MaybeUninit<::windows::core::BSTR>) -> ::windows::core::HRESULT,
    pub GetCapabilitySid: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, capabilitysid: *mut ::std::mem::MaybeUninit<::windows::core::BSTR>) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IApplicationDebugger(::windows::core::IUnknown);
impl IApplicationDebugger {
    pub unsafe fn QueryAlive(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).QueryAlive)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn CreateInstanceAtDebugger<P0>(&self, rclsid: *const ::windows::core::GUID, punkouter: P0, dwclscontext: u32, riid: *const ::windows::core::GUID) -> ::windows::core::Result<::windows::core::IUnknown>
    where
        P0: ::windows::core::IntoParam<::windows::core::IUnknown>,
    {
        let mut result__ = ::windows::core::zeroed::<::windows::core::IUnknown>();
        (::windows::core::Interface::vtable(self).CreateInstanceAtDebugger)(::windows::core::Interface::as_raw(self), rclsid, punkouter.into_param().abi(), dwclscontext, riid, &mut result__).from_abi(result__)
    }
    pub unsafe fn onDebugOutput<P0>(&self, pstr: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).onDebugOutput)(::windows::core::Interface::as_raw(self), pstr.into_param().abi()).ok()
    }
    pub unsafe fn onHandleBreakPoint<P0, P1>(&self, prpt: P0, br: BREAKREASON, perror: P1) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IRemoteDebugApplicationThread>,
        P1: ::windows::core::IntoParam<IActiveScriptErrorDebug>,
    {
        (::windows::core::Interface::vtable(self).onHandleBreakPoint)(::windows::core::Interface::as_raw(self), prpt.into_param().abi(), br, perror.into_param().abi()).ok()
    }
    pub unsafe fn onClose(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).onClose)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn onDebuggerEvent<P0>(&self, riid: *const ::windows::core::GUID, punk: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::IUnknown>,
    {
        (::windows::core::Interface::vtable(self).onDebuggerEvent)(::windows::core::Interface::as_raw(self), riid, punk.into_param().abi()).ok()
    }
}
::windows::imp::interface_hierarchy!(IApplicationDebugger, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IApplicationDebugger {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IApplicationDebugger {}
impl ::core::fmt::Debug for IApplicationDebugger {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IApplicationDebugger").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IApplicationDebugger {
    type Vtable = IApplicationDebugger_Vtbl;
}
impl ::core::clone::Clone for IApplicationDebugger {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IApplicationDebugger {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x51973c2a_cb0c_11d0_b5c9_00a0244a0e7a);
}
#[repr(C)]
#[doc(hidden)]
pub struct IApplicationDebugger_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub QueryAlive: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub CreateInstanceAtDebugger: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, rclsid: *const ::windows::core::GUID, punkouter: *mut ::core::ffi::c_void, dwclscontext: u32, riid: *const ::windows::core::GUID, ppvobject: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub onDebugOutput: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstr: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub onHandleBreakPoint: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, prpt: *mut ::core::ffi::c_void, br: BREAKREASON, perror: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub onClose: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub onDebuggerEvent: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, punk: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IApplicationDebuggerUI(::windows::core::IUnknown);
impl IApplicationDebuggerUI {
    pub unsafe fn BringDocumentToTop<P0>(&self, pddt: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugDocumentText>,
    {
        (::windows::core::Interface::vtable(self).BringDocumentToTop)(::windows::core::Interface::as_raw(self), pddt.into_param().abi()).ok()
    }
    pub unsafe fn BringDocumentContextToTop<P0>(&self, pddc: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugDocumentContext>,
    {
        (::windows::core::Interface::vtable(self).BringDocumentContextToTop)(::windows::core::Interface::as_raw(self), pddc.into_param().abi()).ok()
    }
}
::windows::imp::interface_hierarchy!(IApplicationDebuggerUI, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IApplicationDebuggerUI {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IApplicationDebuggerUI {}
impl ::core::fmt::Debug for IApplicationDebuggerUI {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IApplicationDebuggerUI").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IApplicationDebuggerUI {
    type Vtable = IApplicationDebuggerUI_Vtbl;
}
impl ::core::clone::Clone for IApplicationDebuggerUI {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IApplicationDebuggerUI {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x51973c2b_cb0c_11d0_b5c9_00a0244a0e7a);
}
#[repr(C)]
#[doc(hidden)]
pub struct IApplicationDebuggerUI_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub BringDocumentToTop: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pddt: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub BringDocumentContextToTop: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pddc: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IBindEventHandler(::windows::core::IUnknown);
impl IBindEventHandler {
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn BindHandler<P0, P1>(&self, pstrevent: P0, pdisp: P1) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P1: ::windows::core::IntoParam<super::super::Com::IDispatch>,
    {
        (::windows::core::Interface::vtable(self).BindHandler)(::windows::core::Interface::as_raw(self), pstrevent.into_param().abi(), pdisp.into_param().abi()).ok()
    }
}
::windows::imp::interface_hierarchy!(IBindEventHandler, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IBindEventHandler {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBindEventHandler {}
impl ::core::fmt::Debug for IBindEventHandler {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBindEventHandler").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IBindEventHandler {
    type Vtable = IBindEventHandler_Vtbl;
}
impl ::core::clone::Clone for IBindEventHandler {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IBindEventHandler {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x63cdbcb0_c1b1_11d0_9336_00a0c90dcaa9);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBindEventHandler_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub BindHandler: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstrevent: ::windows::core::PCWSTR, pdisp: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    BindHandler: usize,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct ICodeAddressConcept(::windows::core::IUnknown);
impl ICodeAddressConcept {
    pub unsafe fn GetContainingSymbol<P0>(&self, pcontextobject: P0) -> ::windows::core::Result<IDebugHostSymbol>
    where
        P0: ::windows::core::IntoParam<IModelObject>,
    {
        let mut result__ = ::windows::core::zeroed::<IDebugHostSymbol>();
        (::windows::core::Interface::vtable(self).GetContainingSymbol)(::windows::core::Interface::as_raw(self), pcontextobject.into_param().abi(), &mut result__).from_abi(result__)
    }
}
::windows::imp::interface_hierarchy!(ICodeAddressConcept, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for ICodeAddressConcept {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICodeAddressConcept {}
impl ::core::fmt::Debug for ICodeAddressConcept {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICodeAddressConcept").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ICodeAddressConcept {
    type Vtable = ICodeAddressConcept_Vtbl;
}
impl ::core::clone::Clone for ICodeAddressConcept {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for ICodeAddressConcept {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc7371568_5c78_4a00_a4ab_6ef8823184cb);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICodeAddressConcept_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub GetContainingSymbol: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcontextobject: *mut ::core::ffi::c_void, ppsymbol: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IComparableConcept(::windows::core::IUnknown);
impl IComparableConcept {
    pub unsafe fn CompareObjects<P0, P1>(&self, contextobject: P0, otherobject: P1) -> ::windows::core::Result<i32>
    where
        P0: ::windows::core::IntoParam<IModelObject>,
        P1: ::windows::core::IntoParam<IModelObject>,
    {
        let mut result__ = ::windows::core::zeroed::<i32>();
        (::windows::core::Interface::vtable(self).CompareObjects)(::windows::core::Interface::as_raw(self), contextobject.into_param().abi(), otherobject.into_param().abi(), &mut result__).from_abi(result__)
    }
}
::windows::imp::interface_hierarchy!(IComparableConcept, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IComparableConcept {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IComparableConcept {}
impl ::core::fmt::Debug for IComparableConcept {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IComparableConcept").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IComparableConcept {
    type Vtable = IComparableConcept_Vtbl;
}
impl ::core::clone::Clone for IComparableConcept {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IComparableConcept {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa7830646_9f0c_4a31_ba19_503f33e6c8a3);
}
#[repr(C)]
#[doc(hidden)]
pub struct IComparableConcept_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub CompareObjects: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, contextobject: *mut ::core::ffi::c_void, otherobject: *mut ::core::ffi::c_void, comparisonresult: *mut i32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IDataModelConcept(::windows::core::IUnknown);
impl IDataModelConcept {
    pub unsafe fn InitializeObject<P0, P1, P2>(&self, modelobject: P0, matchingtypesignature: P1, wildcardmatches: P2) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IModelObject>,
        P1: ::windows::core::IntoParam<IDebugHostTypeSignature>,
        P2: ::windows::core::IntoParam<IDebugHostSymbolEnumerator>,
    {
        (::windows::core::Interface::vtable(self).InitializeObject)(::windows::core::Interface::as_raw(self), modelobject.into_param().abi(), matchingtypesignature.into_param().abi(), wildcardmatches.into_param().abi()).ok()
    }
    pub unsafe fn GetName(&self) -> ::windows::core::Result<::windows::core::BSTR> {
        let mut result__ = ::windows::core::zeroed::<::windows::core::BSTR>();
        (::windows::core::Interface::vtable(self).GetName)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
}
::windows::imp::interface_hierarchy!(IDataModelConcept, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IDataModelConcept {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDataModelConcept {}
impl ::core::fmt::Debug for IDataModelConcept {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDataModelConcept").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDataModelConcept {
    type Vtable = IDataModelConcept_Vtbl;
}
impl ::core::clone::Clone for IDataModelConcept {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IDataModelConcept {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xfcb98d1d_1114_4fbf_b24c_effcb5def0d3);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDataModelConcept_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub InitializeObject: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, modelobject: *mut ::core::ffi::c_void, matchingtypesignature: *mut ::core::ffi::c_void, wildcardmatches: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, modelname: *mut ::std::mem::MaybeUninit<::windows::core::BSTR>) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IDataModelManager(::windows::core::IUnknown);
impl IDataModelManager {
    pub unsafe fn Close(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Close)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn CreateNoValue(&self) -> ::windows::core::Result<IModelObject> {
        let mut result__ = ::windows::core::zeroed::<IModelObject>();
        (::windows::core::Interface::vtable(self).CreateNoValue)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn CreateErrorObject<P0>(&self, hrerror: ::windows::core::HRESULT, pwszmessage: P0) -> ::windows::core::Result<IModelObject>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        let mut result__ = ::windows::core::zeroed::<IModelObject>();
        (::windows::core::Interface::vtable(self).CreateErrorObject)(::windows::core::Interface::as_raw(self), hrerror, pwszmessage.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn CreateTypedObject<P0, P1>(&self, context: P0, objectlocation: Location, objecttype: P1) -> ::windows::core::Result<IModelObject>
    where
        P0: ::windows::core::IntoParam<IDebugHostContext>,
        P1: ::windows::core::IntoParam<IDebugHostType>,
    {
        let mut result__ = ::windows::core::zeroed::<IModelObject>();
        (::windows::core::Interface::vtable(self).CreateTypedObject)(::windows::core::Interface::as_raw(self), context.into_param().abi(), ::core::mem::transmute(objectlocation), objecttype.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn CreateTypedObjectReference<P0, P1>(&self, context: P0, objectlocation: Location, objecttype: P1) -> ::windows::core::Result<IModelObject>
    where
        P0: ::windows::core::IntoParam<IDebugHostContext>,
        P1: ::windows::core::IntoParam<IDebugHostType>,
    {
        let mut result__ = ::windows::core::zeroed::<IModelObject>();
        (::windows::core::Interface::vtable(self).CreateTypedObjectReference)(::windows::core::Interface::as_raw(self), context.into_param().abi(), ::core::mem::transmute(objectlocation), objecttype.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn CreateSyntheticObject<P0>(&self, context: P0) -> ::windows::core::Result<IModelObject>
    where
        P0: ::windows::core::IntoParam<IDebugHostContext>,
    {
        let mut result__ = ::windows::core::zeroed::<IModelObject>();
        (::windows::core::Interface::vtable(self).CreateSyntheticObject)(::windows::core::Interface::as_raw(self), context.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn CreateDataModelObject<P0>(&self, datamodel: P0) -> ::windows::core::Result<IModelObject>
    where
        P0: ::windows::core::IntoParam<IDataModelConcept>,
    {
        let mut result__ = ::windows::core::zeroed::<IModelObject>();
        (::windows::core::Interface::vtable(self).CreateDataModelObject)(::windows::core::Interface::as_raw(self), datamodel.into_param().abi(), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn CreateIntrinsicObject(&self, objectkind: ModelObjectKind, intrinsicdata: *const super::super::Com::VARIANT) -> ::windows::core::Result<IModelObject> {
        let mut result__ = ::windows::core::zeroed::<IModelObject>();
        (::windows::core::Interface::vtable(self).CreateIntrinsicObject)(::windows::core::Interface::as_raw(self), objectkind, intrinsicdata, &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn CreateTypedIntrinsicObject<P0>(&self, intrinsicdata: *const super::super::Com::VARIANT, r#type: P0) -> ::windows::core::Result<IModelObject>
    where
        P0: ::windows::core::IntoParam<IDebugHostType>,
    {
        let mut result__ = ::windows::core::zeroed::<IModelObject>();
        (::windows::core::Interface::vtable(self).CreateTypedIntrinsicObject)(::windows::core::Interface::as_raw(self), intrinsicdata, r#type.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetModelForTypeSignature<P0>(&self, typesignature: P0) -> ::windows::core::Result<IModelObject>
    where
        P0: ::windows::core::IntoParam<IDebugHostTypeSignature>,
    {
        let mut result__ = ::windows::core::zeroed::<IModelObject>();
        (::windows::core::Interface::vtable(self).GetModelForTypeSignature)(::windows::core::Interface::as_raw(self), typesignature.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetModelForType<P0>(&self, r#type: P0, datamodel: *mut ::core::option::Option<IModelObject>, typesignature: ::core::option::Option<*mut ::core::option::Option<IDebugHostTypeSignature>>, wildcardmatches: ::core::option::Option<*mut ::core::option::Option<IDebugHostSymbolEnumerator>>) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugHostType>,
    {
        (::windows::core::Interface::vtable(self).GetModelForType)(::windows::core::Interface::as_raw(self), r#type.into_param().abi(), ::core::mem::transmute(datamodel), ::core::mem::transmute(typesignature.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(wildcardmatches.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn RegisterModelForTypeSignature<P0, P1>(&self, typesignature: P0, datamodel: P1) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugHostTypeSignature>,
        P1: ::windows::core::IntoParam<IModelObject>,
    {
        (::windows::core::Interface::vtable(self).RegisterModelForTypeSignature)(::windows::core::Interface::as_raw(self), typesignature.into_param().abi(), datamodel.into_param().abi()).ok()
    }
    pub unsafe fn UnregisterModelForTypeSignature<P0, P1>(&self, datamodel: P0, typesignature: P1) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IModelObject>,
        P1: ::windows::core::IntoParam<IDebugHostTypeSignature>,
    {
        (::windows::core::Interface::vtable(self).UnregisterModelForTypeSignature)(::windows::core::Interface::as_raw(self), datamodel.into_param().abi(), typesignature.into_param().abi()).ok()
    }
    pub unsafe fn RegisterExtensionForTypeSignature<P0, P1>(&self, typesignature: P0, datamodel: P1) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugHostTypeSignature>,
        P1: ::windows::core::IntoParam<IModelObject>,
    {
        (::windows::core::Interface::vtable(self).RegisterExtensionForTypeSignature)(::windows::core::Interface::as_raw(self), typesignature.into_param().abi(), datamodel.into_param().abi()).ok()
    }
    pub unsafe fn UnregisterExtensionForTypeSignature<P0, P1>(&self, datamodel: P0, typesignature: P1) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IModelObject>,
        P1: ::windows::core::IntoParam<IDebugHostTypeSignature>,
    {
        (::windows::core::Interface::vtable(self).UnregisterExtensionForTypeSignature)(::windows::core::Interface::as_raw(self), datamodel.into_param().abi(), typesignature.into_param().abi()).ok()
    }
    pub unsafe fn CreateMetadataStore<P0>(&self, parentstore: P0) -> ::windows::core::Result<IKeyStore>
    where
        P0: ::windows::core::IntoParam<IKeyStore>,
    {
        let mut result__ = ::windows::core::zeroed::<IKeyStore>();
        (::windows::core::Interface::vtable(self).CreateMetadataStore)(::windows::core::Interface::as_raw(self), parentstore.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetRootNamespace(&self) -> ::windows::core::Result<IModelObject> {
        let mut result__ = ::windows::core::zeroed::<IModelObject>();
        (::windows::core::Interface::vtable(self).GetRootNamespace)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn RegisterNamedModel<P0, P1>(&self, modelname: P0, modeobject: P1) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P1: ::windows::core::IntoParam<IModelObject>,
    {
        (::windows::core::Interface::vtable(self).RegisterNamedModel)(::windows::core::Interface::as_raw(self), modelname.into_param().abi(), modeobject.into_param().abi()).ok()
    }
    pub unsafe fn UnregisterNamedModel<P0>(&self, modelname: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).UnregisterNamedModel)(::windows::core::Interface::as_raw(self), modelname.into_param().abi()).ok()
    }
    pub unsafe fn AcquireNamedModel<P0>(&self, modelname: P0) -> ::windows::core::Result<IModelObject>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        let mut result__ = ::windows::core::zeroed::<IModelObject>();
        (::windows::core::Interface::vtable(self).AcquireNamedModel)(::windows::core::Interface::as_raw(self), modelname.into_param().abi(), &mut result__).from_abi(result__)
    }
}
::windows::imp::interface_hierarchy!(IDataModelManager, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IDataModelManager {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDataModelManager {}
impl ::core::fmt::Debug for IDataModelManager {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDataModelManager").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDataModelManager {
    type Vtable = IDataModelManager_Vtbl;
}
impl ::core::clone::Clone for IDataModelManager {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IDataModelManager {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x73fe19f4_a110_4500_8ed9_3c28896f508c);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDataModelManager_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub Close: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub CreateNoValue: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, object: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub CreateErrorObject: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hrerror: ::windows::core::HRESULT, pwszmessage: ::windows::core::PCWSTR, object: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub CreateTypedObject: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, context: *mut ::core::ffi::c_void, objectlocation: Location, objecttype: *mut ::core::ffi::c_void, object: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub CreateTypedObjectReference: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, context: *mut ::core::ffi::c_void, objectlocation: Location, objecttype: *mut ::core::ffi::c_void, object: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub CreateSyntheticObject: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, context: *mut ::core::ffi::c_void, object: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub CreateDataModelObject: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, datamodel: *mut ::core::ffi::c_void, object: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub CreateIntrinsicObject: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, objectkind: ModelObjectKind, intrinsicdata: *const super::super::Com::VARIANT, object: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    CreateIntrinsicObject: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub CreateTypedIntrinsicObject: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, intrinsicdata: *const super::super::Com::VARIANT, r#type: *mut ::core::ffi::c_void, object: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    CreateTypedIntrinsicObject: usize,
    pub GetModelForTypeSignature: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, typesignature: *mut ::core::ffi::c_void, datamodel: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetModelForType: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, r#type: *mut ::core::ffi::c_void, datamodel: *mut *mut ::core::ffi::c_void, typesignature: *mut *mut ::core::ffi::c_void, wildcardmatches: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub RegisterModelForTypeSignature: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, typesignature: *mut ::core::ffi::c_void, datamodel: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub UnregisterModelForTypeSignature: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, datamodel: *mut ::core::ffi::c_void, typesignature: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub RegisterExtensionForTypeSignature: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, typesignature: *mut ::core::ffi::c_void, datamodel: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub UnregisterExtensionForTypeSignature: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, datamodel: *mut ::core::ffi::c_void, typesignature: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub CreateMetadataStore: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, parentstore: *mut ::core::ffi::c_void, metadatastore: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetRootNamespace: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, rootnamespace: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub RegisterNamedModel: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, modelname: ::windows::core::PCWSTR, modeobject: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub UnregisterNamedModel: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, modelname: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub AcquireNamedModel: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, modelname: ::windows::core::PCWSTR, modelobject: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IDataModelManager2(::windows::core::IUnknown);
impl IDataModelManager2 {
    pub unsafe fn Close(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.Close)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn CreateNoValue(&self) -> ::windows::core::Result<IModelObject> {
        let mut result__ = ::windows::core::zeroed::<IModelObject>();
        (::windows::core::Interface::vtable(self).base__.CreateNoValue)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn CreateErrorObject<P0>(&self, hrerror: ::windows::core::HRESULT, pwszmessage: P0) -> ::windows::core::Result<IModelObject>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        let mut result__ = ::windows::core::zeroed::<IModelObject>();
        (::windows::core::Interface::vtable(self).base__.CreateErrorObject)(::windows::core::Interface::as_raw(self), hrerror, pwszmessage.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn CreateTypedObject<P0, P1>(&self, context: P0, objectlocation: Location, objecttype: P1) -> ::windows::core::Result<IModelObject>
    where
        P0: ::windows::core::IntoParam<IDebugHostContext>,
        P1: ::windows::core::IntoParam<IDebugHostType>,
    {
        let mut result__ = ::windows::core::zeroed::<IModelObject>();
        (::windows::core::Interface::vtable(self).base__.CreateTypedObject)(::windows::core::Interface::as_raw(self), context.into_param().abi(), ::core::mem::transmute(objectlocation), objecttype.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn CreateTypedObjectReference<P0, P1>(&self, context: P0, objectlocation: Location, objecttype: P1) -> ::windows::core::Result<IModelObject>
    where
        P0: ::windows::core::IntoParam<IDebugHostContext>,
        P1: ::windows::core::IntoParam<IDebugHostType>,
    {
        let mut result__ = ::windows::core::zeroed::<IModelObject>();
        (::windows::core::Interface::vtable(self).base__.CreateTypedObjectReference)(::windows::core::Interface::as_raw(self), context.into_param().abi(), ::core::mem::transmute(objectlocation), objecttype.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn CreateSyntheticObject<P0>(&self, context: P0) -> ::windows::core::Result<IModelObject>
    where
        P0: ::windows::core::IntoParam<IDebugHostContext>,
    {
        let mut result__ = ::windows::core::zeroed::<IModelObject>();
        (::windows::core::Interface::vtable(self).base__.CreateSyntheticObject)(::windows::core::Interface::as_raw(self), context.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn CreateDataModelObject<P0>(&self, datamodel: P0) -> ::windows::core::Result<IModelObject>
    where
        P0: ::windows::core::IntoParam<IDataModelConcept>,
    {
        let mut result__ = ::windows::core::zeroed::<IModelObject>();
        (::windows::core::Interface::vtable(self).base__.CreateDataModelObject)(::windows::core::Interface::as_raw(self), datamodel.into_param().abi(), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn CreateIntrinsicObject(&self, objectkind: ModelObjectKind, intrinsicdata: *const super::super::Com::VARIANT) -> ::windows::core::Result<IModelObject> {
        let mut result__ = ::windows::core::zeroed::<IModelObject>();
        (::windows::core::Interface::vtable(self).base__.CreateIntrinsicObject)(::windows::core::Interface::as_raw(self), objectkind, intrinsicdata, &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn CreateTypedIntrinsicObject<P0>(&self, intrinsicdata: *const super::super::Com::VARIANT, r#type: P0) -> ::windows::core::Result<IModelObject>
    where
        P0: ::windows::core::IntoParam<IDebugHostType>,
    {
        let mut result__ = ::windows::core::zeroed::<IModelObject>();
        (::windows::core::Interface::vtable(self).base__.CreateTypedIntrinsicObject)(::windows::core::Interface::as_raw(self), intrinsicdata, r#type.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetModelForTypeSignature<P0>(&self, typesignature: P0) -> ::windows::core::Result<IModelObject>
    where
        P0: ::windows::core::IntoParam<IDebugHostTypeSignature>,
    {
        let mut result__ = ::windows::core::zeroed::<IModelObject>();
        (::windows::core::Interface::vtable(self).base__.GetModelForTypeSignature)(::windows::core::Interface::as_raw(self), typesignature.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetModelForType<P0>(&self, r#type: P0, datamodel: *mut ::core::option::Option<IModelObject>, typesignature: ::core::option::Option<*mut ::core::option::Option<IDebugHostTypeSignature>>, wildcardmatches: ::core::option::Option<*mut ::core::option::Option<IDebugHostSymbolEnumerator>>) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugHostType>,
    {
        (::windows::core::Interface::vtable(self).base__.GetModelForType)(::windows::core::Interface::as_raw(self), r#type.into_param().abi(), ::core::mem::transmute(datamodel), ::core::mem::transmute(typesignature.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(wildcardmatches.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn RegisterModelForTypeSignature<P0, P1>(&self, typesignature: P0, datamodel: P1) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugHostTypeSignature>,
        P1: ::windows::core::IntoParam<IModelObject>,
    {
        (::windows::core::Interface::vtable(self).base__.RegisterModelForTypeSignature)(::windows::core::Interface::as_raw(self), typesignature.into_param().abi(), datamodel.into_param().abi()).ok()
    }
    pub unsafe fn UnregisterModelForTypeSignature<P0, P1>(&self, datamodel: P0, typesignature: P1) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IModelObject>,
        P1: ::windows::core::IntoParam<IDebugHostTypeSignature>,
    {
        (::windows::core::Interface::vtable(self).base__.UnregisterModelForTypeSignature)(::windows::core::Interface::as_raw(self), datamodel.into_param().abi(), typesignature.into_param().abi()).ok()
    }
    pub unsafe fn RegisterExtensionForTypeSignature<P0, P1>(&self, typesignature: P0, datamodel: P1) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugHostTypeSignature>,
        P1: ::windows::core::IntoParam<IModelObject>,
    {
        (::windows::core::Interface::vtable(self).base__.RegisterExtensionForTypeSignature)(::windows::core::Interface::as_raw(self), typesignature.into_param().abi(), datamodel.into_param().abi()).ok()
    }
    pub unsafe fn UnregisterExtensionForTypeSignature<P0, P1>(&self, datamodel: P0, typesignature: P1) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IModelObject>,
        P1: ::windows::core::IntoParam<IDebugHostTypeSignature>,
    {
        (::windows::core::Interface::vtable(self).base__.UnregisterExtensionForTypeSignature)(::windows::core::Interface::as_raw(self), datamodel.into_param().abi(), typesignature.into_param().abi()).ok()
    }
    pub unsafe fn CreateMetadataStore<P0>(&self, parentstore: P0) -> ::windows::core::Result<IKeyStore>
    where
        P0: ::windows::core::IntoParam<IKeyStore>,
    {
        let mut result__ = ::windows::core::zeroed::<IKeyStore>();
        (::windows::core::Interface::vtable(self).base__.CreateMetadataStore)(::windows::core::Interface::as_raw(self), parentstore.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetRootNamespace(&self) -> ::windows::core::Result<IModelObject> {
        let mut result__ = ::windows::core::zeroed::<IModelObject>();
        (::windows::core::Interface::vtable(self).base__.GetRootNamespace)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn RegisterNamedModel<P0, P1>(&self, modelname: P0, modeobject: P1) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P1: ::windows::core::IntoParam<IModelObject>,
    {
        (::windows::core::Interface::vtable(self).base__.RegisterNamedModel)(::windows::core::Interface::as_raw(self), modelname.into_param().abi(), modeobject.into_param().abi()).ok()
    }
    pub unsafe fn UnregisterNamedModel<P0>(&self, modelname: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).base__.UnregisterNamedModel)(::windows::core::Interface::as_raw(self), modelname.into_param().abi()).ok()
    }
    pub unsafe fn AcquireNamedModel<P0>(&self, modelname: P0) -> ::windows::core::Result<IModelObject>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        let mut result__ = ::windows::core::zeroed::<IModelObject>();
        (::windows::core::Interface::vtable(self).base__.AcquireNamedModel)(::windows::core::Interface::as_raw(self), modelname.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn AcquireSubNamespace<P0, P1, P2, P3>(&self, modelname: P0, subnamespacemodelname: P1, accessname: P2, metadata: P3) -> ::windows::core::Result<IModelObject>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P2: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P3: ::windows::core::IntoParam<IKeyStore>,
    {
        let mut result__ = ::windows::core::zeroed::<IModelObject>();
        (::windows::core::Interface::vtable(self).AcquireSubNamespace)(::windows::core::Interface::as_raw(self), modelname.into_param().abi(), subnamespacemodelname.into_param().abi(), accessname.into_param().abi(), metadata.into_param().abi(), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn CreateTypedIntrinsicObjectEx<P0, P1>(&self, context: P0, intrinsicdata: *const super::super::Com::VARIANT, r#type: P1) -> ::windows::core::Result<IModelObject>
    where
        P0: ::windows::core::IntoParam<IDebugHostContext>,
        P1: ::windows::core::IntoParam<IDebugHostType>,
    {
        let mut result__ = ::windows::core::zeroed::<IModelObject>();
        (::windows::core::Interface::vtable(self).CreateTypedIntrinsicObjectEx)(::windows::core::Interface::as_raw(self), context.into_param().abi(), intrinsicdata, r#type.into_param().abi(), &mut result__).from_abi(result__)
    }
}
::windows::imp::interface_hierarchy!(IDataModelManager2, ::windows::core::IUnknown, IDataModelManager);
impl ::core::cmp::PartialEq for IDataModelManager2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDataModelManager2 {}
impl ::core::fmt::Debug for IDataModelManager2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDataModelManager2").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDataModelManager2 {
    type Vtable = IDataModelManager2_Vtbl;
}
impl ::core::clone::Clone for IDataModelManager2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IDataModelManager2 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf412c5ea_2284_4622_a660_a697160d3312);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDataModelManager2_Vtbl {
    pub base__: IDataModelManager_Vtbl,
    pub AcquireSubNamespace: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, modelname: ::windows::core::PCWSTR, subnamespacemodelname: ::windows::core::PCWSTR, accessname: ::windows::core::PCWSTR, metadata: *mut ::core::ffi::c_void, namespacemodelobject: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub CreateTypedIntrinsicObjectEx: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, context: *mut ::core::ffi::c_void, intrinsicdata: *const super::super::Com::VARIANT, r#type: *mut ::core::ffi::c_void, object: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    CreateTypedIntrinsicObjectEx: usize,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IDataModelNameBinder(::windows::core::IUnknown);
impl IDataModelNameBinder {
    pub unsafe fn BindValue<P0, P1>(&self, contextobject: P0, name: P1, value: *mut ::core::option::Option<IModelObject>, metadata: ::core::option::Option<*mut ::core::option::Option<IKeyStore>>) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IModelObject>,
        P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).BindValue)(::windows::core::Interface::as_raw(self), contextobject.into_param().abi(), name.into_param().abi(), ::core::mem::transmute(value), ::core::mem::transmute(metadata.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn BindReference<P0, P1>(&self, contextobject: P0, name: P1, reference: *mut ::core::option::Option<IModelObject>, metadata: ::core::option::Option<*mut ::core::option::Option<IKeyStore>>) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IModelObject>,
        P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).BindReference)(::windows::core::Interface::as_raw(self), contextobject.into_param().abi(), name.into_param().abi(), ::core::mem::transmute(reference), ::core::mem::transmute(metadata.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn EnumerateValues<P0>(&self, contextobject: P0) -> ::windows::core::Result<IKeyEnumerator>
    where
        P0: ::windows::core::IntoParam<IModelObject>,
    {
        let mut result__ = ::windows::core::zeroed::<IKeyEnumerator>();
        (::windows::core::Interface::vtable(self).EnumerateValues)(::windows::core::Interface::as_raw(self), contextobject.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn EnumerateReferences<P0>(&self, contextobject: P0) -> ::windows::core::Result<IKeyEnumerator>
    where
        P0: ::windows::core::IntoParam<IModelObject>,
    {
        let mut result__ = ::windows::core::zeroed::<IKeyEnumerator>();
        (::windows::core::Interface::vtable(self).EnumerateReferences)(::windows::core::Interface::as_raw(self), contextobject.into_param().abi(), &mut result__).from_abi(result__)
    }
}
::windows::imp::interface_hierarchy!(IDataModelNameBinder, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IDataModelNameBinder {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDataModelNameBinder {}
impl ::core::fmt::Debug for IDataModelNameBinder {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDataModelNameBinder").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDataModelNameBinder {
    type Vtable = IDataModelNameBinder_Vtbl;
}
impl ::core::clone::Clone for IDataModelNameBinder {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IDataModelNameBinder {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xaf352b7b_8292_4c01_b360_2dc3696c65e7);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDataModelNameBinder_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub BindValue: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, contextobject: *mut ::core::ffi::c_void, name: ::windows::core::PCWSTR, value: *mut *mut ::core::ffi::c_void, metadata: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub BindReference: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, contextobject: *mut ::core::ffi::c_void, name: ::windows::core::PCWSTR, reference: *mut *mut ::core::ffi::c_void, metadata: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub EnumerateValues: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, contextobject: *mut ::core::ffi::c_void, enumerator: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub EnumerateReferences: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, contextobject: *mut ::core::ffi::c_void, enumerator: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IDataModelScript(::windows::core::IUnknown);
impl IDataModelScript {
    pub unsafe fn GetName(&self) -> ::windows::core::Result<::windows::core::BSTR> {
        let mut result__ = ::windows::core::zeroed::<::windows::core::BSTR>();
        (::windows::core::Interface::vtable(self).GetName)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn Rename<P0>(&self, scriptname: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).Rename)(::windows::core::Interface::as_raw(self), scriptname.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Populate<P0>(&self, contentstream: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<super::super::Com::IStream>,
    {
        (::windows::core::Interface::vtable(self).Populate)(::windows::core::Interface::as_raw(self), contentstream.into_param().abi()).ok()
    }
    pub unsafe fn Execute<P0>(&self, client: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDataModelScriptClient>,
    {
        (::windows::core::Interface::vtable(self).Execute)(::windows::core::Interface::as_raw(self), client.into_param().abi()).ok()
    }
    pub unsafe fn Unlink(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Unlink)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn IsInvocable(&self) -> ::windows::core::Result<bool> {
        let mut result__ = ::windows::core::zeroed::<bool>();
        (::windows::core::Interface::vtable(self).IsInvocable)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn InvokeMain<P0>(&self, client: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDataModelScriptClient>,
    {
        (::windows::core::Interface::vtable(self).InvokeMain)(::windows::core::Interface::as_raw(self), client.into_param().abi()).ok()
    }
}
::windows::imp::interface_hierarchy!(IDataModelScript, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IDataModelScript {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDataModelScript {}
impl ::core::fmt::Debug for IDataModelScript {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDataModelScript").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDataModelScript {
    type Vtable = IDataModelScript_Vtbl;
}
impl ::core::clone::Clone for IDataModelScript {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IDataModelScript {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x7b4d30fc_b14a_49f8_8d87_d9a1480c97f7);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDataModelScript_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub GetName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, scriptname: *mut ::std::mem::MaybeUninit<::windows::core::BSTR>) -> ::windows::core::HRESULT,
    pub Rename: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, scriptname: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub Populate: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, contentstream: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Populate: usize,
    pub Execute: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, client: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub Unlink: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub IsInvocable: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, isinvocable: *mut bool) -> ::windows::core::HRESULT,
    pub InvokeMain: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, client: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IDataModelScriptClient(::windows::core::IUnknown);
impl IDataModelScriptClient {
    pub unsafe fn ReportError<P0>(&self, errclass: ErrorClass, hrfail: ::windows::core::HRESULT, message: P0, line: u32, position: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).ReportError)(::windows::core::Interface::as_raw(self), errclass, hrfail, message.into_param().abi(), line, position).ok()
    }
}
::windows::imp::interface_hierarchy!(IDataModelScriptClient, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IDataModelScriptClient {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDataModelScriptClient {}
impl ::core::fmt::Debug for IDataModelScriptClient {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDataModelScriptClient").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDataModelScriptClient {
    type Vtable = IDataModelScriptClient_Vtbl;
}
impl ::core::clone::Clone for IDataModelScriptClient {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IDataModelScriptClient {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x3b362b0e_89f0_46c6_a663_dfdc95194aef);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDataModelScriptClient_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub ReportError: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, errclass: ErrorClass, hrfail: ::windows::core::HRESULT, message: ::windows::core::PCWSTR, line: u32, position: u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IDataModelScriptDebug(::windows::core::IUnknown);
impl IDataModelScriptDebug {
    pub unsafe fn GetDebugState(&self) -> ScriptDebugState {
        (::windows::core::Interface::vtable(self).GetDebugState)(::windows::core::Interface::as_raw(self))
    }
    pub unsafe fn GetCurrentPosition(&self, currentposition: *mut ScriptDebugPosition, positionspanend: ::core::option::Option<*mut ScriptDebugPosition>, linetext: ::core::option::Option<*mut ::windows::core::BSTR>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetCurrentPosition)(::windows::core::Interface::as_raw(self), currentposition, ::core::mem::transmute(positionspanend.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(linetext.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetStack(&self) -> ::windows::core::Result<IDataModelScriptDebugStack> {
        let mut result__ = ::windows::core::zeroed::<IDataModelScriptDebugStack>();
        (::windows::core::Interface::vtable(self).GetStack)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetBreakpoint(&self, lineposition: u32, columnposition: u32) -> ::windows::core::Result<IDataModelScriptDebugBreakpoint> {
        let mut result__ = ::windows::core::zeroed::<IDataModelScriptDebugBreakpoint>();
        (::windows::core::Interface::vtable(self).SetBreakpoint)(::windows::core::Interface::as_raw(self), lineposition, columnposition, &mut result__).from_abi(result__)
    }
    pub unsafe fn FindBreakpointById(&self, breakpointid: u64) -> ::windows::core::Result<IDataModelScriptDebugBreakpoint> {
        let mut result__ = ::windows::core::zeroed::<IDataModelScriptDebugBreakpoint>();
        (::windows::core::Interface::vtable(self).FindBreakpointById)(::windows::core::Interface::as_raw(self), breakpointid, &mut result__).from_abi(result__)
    }
    pub unsafe fn EnumerateBreakpoints(&self) -> ::windows::core::Result<IDataModelScriptDebugBreakpointEnumerator> {
        let mut result__ = ::windows::core::zeroed::<IDataModelScriptDebugBreakpointEnumerator>();
        (::windows::core::Interface::vtable(self).EnumerateBreakpoints)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetEventFilter(&self, eventfilter: ScriptDebugEventFilter) -> ::windows::core::Result<bool> {
        let mut result__ = ::windows::core::zeroed::<bool>();
        (::windows::core::Interface::vtable(self).GetEventFilter)(::windows::core::Interface::as_raw(self), eventfilter, &mut result__).from_abi(result__)
    }
    pub unsafe fn SetEventFilter(&self, eventfilter: ScriptDebugEventFilter, isbreakenabled: u8) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetEventFilter)(::windows::core::Interface::as_raw(self), eventfilter, isbreakenabled).ok()
    }
    pub unsafe fn StartDebugging<P0>(&self, debugclient: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDataModelScriptDebugClient>,
    {
        (::windows::core::Interface::vtable(self).StartDebugging)(::windows::core::Interface::as_raw(self), debugclient.into_param().abi()).ok()
    }
    pub unsafe fn StopDebugging<P0>(&self, debugclient: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDataModelScriptDebugClient>,
    {
        (::windows::core::Interface::vtable(self).StopDebugging)(::windows::core::Interface::as_raw(self), debugclient.into_param().abi()).ok()
    }
}
::windows::imp::interface_hierarchy!(IDataModelScriptDebug, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IDataModelScriptDebug {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDataModelScriptDebug {}
impl ::core::fmt::Debug for IDataModelScriptDebug {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDataModelScriptDebug").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDataModelScriptDebug {
    type Vtable = IDataModelScriptDebug_Vtbl;
}
impl ::core::clone::Clone for IDataModelScriptDebug {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IDataModelScriptDebug {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xde8e0945_9750_4471_ab76_a8f79d6ec350);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDataModelScriptDebug_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub GetDebugState: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ScriptDebugState,
    pub GetCurrentPosition: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, currentposition: *mut ScriptDebugPosition, positionspanend: *mut ScriptDebugPosition, linetext: *mut ::std::mem::MaybeUninit<::windows::core::BSTR>) -> ::windows::core::HRESULT,
    pub GetStack: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, stack: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub SetBreakpoint: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lineposition: u32, columnposition: u32, breakpoint: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub FindBreakpointById: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, breakpointid: u64, breakpoint: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub EnumerateBreakpoints: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, breakpointenum: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetEventFilter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, eventfilter: ScriptDebugEventFilter, isbreakenabled: *mut bool) -> ::windows::core::HRESULT,
    pub SetEventFilter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, eventfilter: ScriptDebugEventFilter, isbreakenabled: u8) -> ::windows::core::HRESULT,
    pub StartDebugging: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, debugclient: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub StopDebugging: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, debugclient: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IDataModelScriptDebug2(::windows::core::IUnknown);
impl IDataModelScriptDebug2 {
    pub unsafe fn GetDebugState(&self) -> ScriptDebugState {
        (::windows::core::Interface::vtable(self).base__.GetDebugState)(::windows::core::Interface::as_raw(self))
    }
    pub unsafe fn GetCurrentPosition(&self, currentposition: *mut ScriptDebugPosition, positionspanend: ::core::option::Option<*mut ScriptDebugPosition>, linetext: ::core::option::Option<*mut ::windows::core::BSTR>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.GetCurrentPosition)(::windows::core::Interface::as_raw(self), currentposition, ::core::mem::transmute(positionspanend.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(linetext.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetStack(&self) -> ::windows::core::Result<IDataModelScriptDebugStack> {
        let mut result__ = ::windows::core::zeroed::<IDataModelScriptDebugStack>();
        (::windows::core::Interface::vtable(self).base__.GetStack)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetBreakpoint(&self, lineposition: u32, columnposition: u32) -> ::windows::core::Result<IDataModelScriptDebugBreakpoint> {
        let mut result__ = ::windows::core::zeroed::<IDataModelScriptDebugBreakpoint>();
        (::windows::core::Interface::vtable(self).base__.SetBreakpoint)(::windows::core::Interface::as_raw(self), lineposition, columnposition, &mut result__).from_abi(result__)
    }
    pub unsafe fn FindBreakpointById(&self, breakpointid: u64) -> ::windows::core::Result<IDataModelScriptDebugBreakpoint> {
        let mut result__ = ::windows::core::zeroed::<IDataModelScriptDebugBreakpoint>();
        (::windows::core::Interface::vtable(self).base__.FindBreakpointById)(::windows::core::Interface::as_raw(self), breakpointid, &mut result__).from_abi(result__)
    }
    pub unsafe fn EnumerateBreakpoints(&self) -> ::windows::core::Result<IDataModelScriptDebugBreakpointEnumerator> {
        let mut result__ = ::windows::core::zeroed::<IDataModelScriptDebugBreakpointEnumerator>();
        (::windows::core::Interface::vtable(self).base__.EnumerateBreakpoints)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetEventFilter(&self, eventfilter: ScriptDebugEventFilter) -> ::windows::core::Result<bool> {
        let mut result__ = ::windows::core::zeroed::<bool>();
        (::windows::core::Interface::vtable(self).base__.GetEventFilter)(::windows::core::Interface::as_raw(self), eventfilter, &mut result__).from_abi(result__)
    }
    pub unsafe fn SetEventFilter(&self, eventfilter: ScriptDebugEventFilter, isbreakenabled: u8) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.SetEventFilter)(::windows::core::Interface::as_raw(self), eventfilter, isbreakenabled).ok()
    }
    pub unsafe fn StartDebugging<P0>(&self, debugclient: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDataModelScriptDebugClient>,
    {
        (::windows::core::Interface::vtable(self).base__.StartDebugging)(::windows::core::Interface::as_raw(self), debugclient.into_param().abi()).ok()
    }
    pub unsafe fn StopDebugging<P0>(&self, debugclient: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDataModelScriptDebugClient>,
    {
        (::windows::core::Interface::vtable(self).base__.StopDebugging)(::windows::core::Interface::as_raw(self), debugclient.into_param().abi()).ok()
    }
    pub unsafe fn SetBreakpointAtFunction<P0>(&self, functionname: P0) -> ::windows::core::Result<IDataModelScriptDebugBreakpoint>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        let mut result__ = ::windows::core::zeroed::<IDataModelScriptDebugBreakpoint>();
        (::windows::core::Interface::vtable(self).SetBreakpointAtFunction)(::windows::core::Interface::as_raw(self), functionname.into_param().abi(), &mut result__).from_abi(result__)
    }
}
::windows::imp::interface_hierarchy!(IDataModelScriptDebug2, ::windows::core::IUnknown, IDataModelScriptDebug);
impl ::core::cmp::PartialEq for IDataModelScriptDebug2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDataModelScriptDebug2 {}
impl ::core::fmt::Debug for IDataModelScriptDebug2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDataModelScriptDebug2").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDataModelScriptDebug2 {
    type Vtable = IDataModelScriptDebug2_Vtbl;
}
impl ::core::clone::Clone for IDataModelScriptDebug2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IDataModelScriptDebug2 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xcbb10ed3_839e_426c_9243_e23535c1ae1a);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDataModelScriptDebug2_Vtbl {
    pub base__: IDataModelScriptDebug_Vtbl,
    pub SetBreakpointAtFunction: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, functionname: ::windows::core::PCWSTR, breakpoint: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IDataModelScriptDebugBreakpoint(::windows::core::IUnknown);
impl IDataModelScriptDebugBreakpoint {
    pub unsafe fn GetId(&self) -> u64 {
        (::windows::core::Interface::vtable(self).GetId)(::windows::core::Interface::as_raw(self))
    }
    pub unsafe fn IsEnabled(&self) -> bool {
        (::windows::core::Interface::vtable(self).IsEnabled)(::windows::core::Interface::as_raw(self))
    }
    pub unsafe fn Enable(&self) {
        (::windows::core::Interface::vtable(self).Enable)(::windows::core::Interface::as_raw(self))
    }
    pub unsafe fn Disable(&self) {
        (::windows::core::Interface::vtable(self).Disable)(::windows::core::Interface::as_raw(self))
    }
    pub unsafe fn Remove(&self) {
        (::windows::core::Interface::vtable(self).Remove)(::windows::core::Interface::as_raw(self))
    }
    pub unsafe fn GetPosition(&self, position: *mut ScriptDebugPosition, positionspanend: ::core::option::Option<*mut ScriptDebugPosition>, linetext: ::core::option::Option<*mut ::windows::core::BSTR>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetPosition)(::windows::core::Interface::as_raw(self), position, ::core::mem::transmute(positionspanend.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(linetext.unwrap_or(::std::ptr::null_mut()))).ok()
    }
}
::windows::imp::interface_hierarchy!(IDataModelScriptDebugBreakpoint, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IDataModelScriptDebugBreakpoint {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDataModelScriptDebugBreakpoint {}
impl ::core::fmt::Debug for IDataModelScriptDebugBreakpoint {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDataModelScriptDebugBreakpoint").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDataModelScriptDebugBreakpoint {
    type Vtable = IDataModelScriptDebugBreakpoint_Vtbl;
}
impl ::core::clone::Clone for IDataModelScriptDebugBreakpoint {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IDataModelScriptDebugBreakpoint {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x6bb27b35_02e6_47cb_90a0_5371244032de);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDataModelScriptDebugBreakpoint_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub GetId: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u64,
    pub IsEnabled: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> bool,
    pub Enable: unsafe extern "system" fn(this: *mut ::core::ffi::c_void),
    pub Disable: unsafe extern "system" fn(this: *mut ::core::ffi::c_void),
    pub Remove: unsafe extern "system" fn(this: *mut ::core::ffi::c_void),
    pub GetPosition: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, position: *mut ScriptDebugPosition, positionspanend: *mut ScriptDebugPosition, linetext: *mut ::std::mem::MaybeUninit<::windows::core::BSTR>) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IDataModelScriptDebugBreakpointEnumerator(::windows::core::IUnknown);
impl IDataModelScriptDebugBreakpointEnumerator {
    pub unsafe fn Reset(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Reset)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetNext(&self) -> ::windows::core::Result<IDataModelScriptDebugBreakpoint> {
        let mut result__ = ::windows::core::zeroed::<IDataModelScriptDebugBreakpoint>();
        (::windows::core::Interface::vtable(self).GetNext)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
}
::windows::imp::interface_hierarchy!(IDataModelScriptDebugBreakpointEnumerator, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IDataModelScriptDebugBreakpointEnumerator {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDataModelScriptDebugBreakpointEnumerator {}
impl ::core::fmt::Debug for IDataModelScriptDebugBreakpointEnumerator {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDataModelScriptDebugBreakpointEnumerator").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDataModelScriptDebugBreakpointEnumerator {
    type Vtable = IDataModelScriptDebugBreakpointEnumerator_Vtbl;
}
impl ::core::clone::Clone for IDataModelScriptDebugBreakpointEnumerator {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IDataModelScriptDebugBreakpointEnumerator {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x39484a75_b4f3_4799_86da_691afa57b299);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDataModelScriptDebugBreakpointEnumerator_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub Reset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetNext: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, breakpoint: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IDataModelScriptDebugClient(::windows::core::IUnknown);
impl IDataModelScriptDebugClient {
    pub unsafe fn NotifyDebugEvent<P0, P1>(&self, peventinfo: *const ScriptDebugEventInformation, pscript: P0, peventdataobject: P1, resumeeventkind: *mut ScriptExecutionKind) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDataModelScript>,
        P1: ::windows::core::IntoParam<IModelObject>,
    {
        (::windows::core::Interface::vtable(self).NotifyDebugEvent)(::windows::core::Interface::as_raw(self), peventinfo, pscript.into_param().abi(), peventdataobject.into_param().abi(), resumeeventkind).ok()
    }
}
::windows::imp::interface_hierarchy!(IDataModelScriptDebugClient, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IDataModelScriptDebugClient {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDataModelScriptDebugClient {}
impl ::core::fmt::Debug for IDataModelScriptDebugClient {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDataModelScriptDebugClient").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDataModelScriptDebugClient {
    type Vtable = IDataModelScriptDebugClient_Vtbl;
}
impl ::core::clone::Clone for IDataModelScriptDebugClient {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IDataModelScriptDebugClient {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x53159b6d_d4c4_471b_a863_5b110ca800ca);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDataModelScriptDebugClient_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub NotifyDebugEvent: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, peventinfo: *const ScriptDebugEventInformation, pscript: *mut ::core::ffi::c_void, peventdataobject: *mut ::core::ffi::c_void, resumeeventkind: *mut ScriptExecutionKind) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IDataModelScriptDebugStack(::windows::core::IUnknown);
impl IDataModelScriptDebugStack {
    pub unsafe fn GetFrameCount(&self) -> u64 {
        (::windows::core::Interface::vtable(self).GetFrameCount)(::windows::core::Interface::as_raw(self))
    }
    pub unsafe fn GetStackFrame(&self, framenumber: u64) -> ::windows::core::Result<IDataModelScriptDebugStackFrame> {
        let mut result__ = ::windows::core::zeroed::<IDataModelScriptDebugStackFrame>();
        (::windows::core::Interface::vtable(self).GetStackFrame)(::windows::core::Interface::as_raw(self), framenumber, &mut result__).from_abi(result__)
    }
}
::windows::imp::interface_hierarchy!(IDataModelScriptDebugStack, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IDataModelScriptDebugStack {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDataModelScriptDebugStack {}
impl ::core::fmt::Debug for IDataModelScriptDebugStack {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDataModelScriptDebugStack").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDataModelScriptDebugStack {
    type Vtable = IDataModelScriptDebugStack_Vtbl;
}
impl ::core::clone::Clone for IDataModelScriptDebugStack {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IDataModelScriptDebugStack {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x051364dd_e449_443e_9762_fe578f4a5473);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDataModelScriptDebugStack_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub GetFrameCount: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u64,
    pub GetStackFrame: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, framenumber: u64, stackframe: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IDataModelScriptDebugStackFrame(::windows::core::IUnknown);
impl IDataModelScriptDebugStackFrame {
    pub unsafe fn GetName(&self) -> ::windows::core::Result<::windows::core::BSTR> {
        let mut result__ = ::windows::core::zeroed::<::windows::core::BSTR>();
        (::windows::core::Interface::vtable(self).GetName)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetPosition(&self, position: *mut ScriptDebugPosition, positionspanend: ::core::option::Option<*mut ScriptDebugPosition>, linetext: ::core::option::Option<*mut ::windows::core::BSTR>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetPosition)(::windows::core::Interface::as_raw(self), position, ::core::mem::transmute(positionspanend.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(linetext.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn IsTransitionPoint(&self) -> ::windows::core::Result<bool> {
        let mut result__ = ::windows::core::zeroed::<bool>();
        (::windows::core::Interface::vtable(self).IsTransitionPoint)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetTransition(&self, transitionscript: *mut ::core::option::Option<IDataModelScript>, istransitioncontiguous: *mut bool) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetTransition)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(transitionscript), istransitioncontiguous).ok()
    }
    pub unsafe fn Evaluate<P0>(&self, pwszexpression: P0) -> ::windows::core::Result<IModelObject>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        let mut result__ = ::windows::core::zeroed::<IModelObject>();
        (::windows::core::Interface::vtable(self).Evaluate)(::windows::core::Interface::as_raw(self), pwszexpression.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn EnumerateLocals(&self) -> ::windows::core::Result<IDataModelScriptDebugVariableSetEnumerator> {
        let mut result__ = ::windows::core::zeroed::<IDataModelScriptDebugVariableSetEnumerator>();
        (::windows::core::Interface::vtable(self).EnumerateLocals)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn EnumerateArguments(&self) -> ::windows::core::Result<IDataModelScriptDebugVariableSetEnumerator> {
        let mut result__ = ::windows::core::zeroed::<IDataModelScriptDebugVariableSetEnumerator>();
        (::windows::core::Interface::vtable(self).EnumerateArguments)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
}
::windows::imp::interface_hierarchy!(IDataModelScriptDebugStackFrame, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IDataModelScriptDebugStackFrame {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDataModelScriptDebugStackFrame {}
impl ::core::fmt::Debug for IDataModelScriptDebugStackFrame {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDataModelScriptDebugStackFrame").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDataModelScriptDebugStackFrame {
    type Vtable = IDataModelScriptDebugStackFrame_Vtbl;
}
impl ::core::clone::Clone for IDataModelScriptDebugStackFrame {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IDataModelScriptDebugStackFrame {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xdec6ed5e_6360_4941_ab4c_a26409de4f82);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDataModelScriptDebugStackFrame_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub GetName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, name: *mut ::std::mem::MaybeUninit<::windows::core::BSTR>) -> ::windows::core::HRESULT,
    pub GetPosition: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, position: *mut ScriptDebugPosition, positionspanend: *mut ScriptDebugPosition, linetext: *mut ::std::mem::MaybeUninit<::windows::core::BSTR>) -> ::windows::core::HRESULT,
    pub IsTransitionPoint: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, istransitionpoint: *mut bool) -> ::windows::core::HRESULT,
    pub GetTransition: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, transitionscript: *mut *mut ::core::ffi::c_void, istransitioncontiguous: *mut bool) -> ::windows::core::HRESULT,
    pub Evaluate: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pwszexpression: ::windows::core::PCWSTR, ppresult: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub EnumerateLocals: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, variablesenum: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub EnumerateArguments: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, variablesenum: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IDataModelScriptDebugVariableSetEnumerator(::windows::core::IUnknown);
impl IDataModelScriptDebugVariableSetEnumerator {
    pub unsafe fn Reset(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Reset)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetNext(&self, variablename: *mut ::windows::core::BSTR, variablevalue: ::core::option::Option<*mut ::core::option::Option<IModelObject>>, variablemetadata: ::core::option::Option<*mut ::core::option::Option<IKeyStore>>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetNext)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(variablename), ::core::mem::transmute(variablevalue.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(variablemetadata.unwrap_or(::std::ptr::null_mut()))).ok()
    }
}
::windows::imp::interface_hierarchy!(IDataModelScriptDebugVariableSetEnumerator, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IDataModelScriptDebugVariableSetEnumerator {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDataModelScriptDebugVariableSetEnumerator {}
impl ::core::fmt::Debug for IDataModelScriptDebugVariableSetEnumerator {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDataModelScriptDebugVariableSetEnumerator").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDataModelScriptDebugVariableSetEnumerator {
    type Vtable = IDataModelScriptDebugVariableSetEnumerator_Vtbl;
}
impl ::core::clone::Clone for IDataModelScriptDebugVariableSetEnumerator {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IDataModelScriptDebugVariableSetEnumerator {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0f9feed7_d045_4ac3_98a8_a98942cf6a35);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDataModelScriptDebugVariableSetEnumerator_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub Reset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetNext: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, variablename: *mut ::std::mem::MaybeUninit<::windows::core::BSTR>, variablevalue: *mut *mut ::core::ffi::c_void, variablemetadata: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IDataModelScriptHostContext(::windows::core::IUnknown);
impl IDataModelScriptHostContext {
    pub unsafe fn NotifyScriptChange<P0>(&self, script: P0, changekind: ScriptChangeKind) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDataModelScript>,
    {
        (::windows::core::Interface::vtable(self).NotifyScriptChange)(::windows::core::Interface::as_raw(self), script.into_param().abi(), changekind).ok()
    }
    pub unsafe fn GetNamespaceObject(&self) -> ::windows::core::Result<IModelObject> {
        let mut result__ = ::windows::core::zeroed::<IModelObject>();
        (::windows::core::Interface::vtable(self).GetNamespaceObject)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
}
::windows::imp::interface_hierarchy!(IDataModelScriptHostContext, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IDataModelScriptHostContext {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDataModelScriptHostContext {}
impl ::core::fmt::Debug for IDataModelScriptHostContext {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDataModelScriptHostContext").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDataModelScriptHostContext {
    type Vtable = IDataModelScriptHostContext_Vtbl;
}
impl ::core::clone::Clone for IDataModelScriptHostContext {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IDataModelScriptHostContext {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x014d366a_1f23_4981_9219_b2db8b402054);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDataModelScriptHostContext_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub NotifyScriptChange: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, script: *mut ::core::ffi::c_void, changekind: ScriptChangeKind) -> ::windows::core::HRESULT,
    pub GetNamespaceObject: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, namespaceobject: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IDataModelScriptManager(::windows::core::IUnknown);
impl IDataModelScriptManager {
    pub unsafe fn GetDefaultNameBinder(&self) -> ::windows::core::Result<IDataModelNameBinder> {
        let mut result__ = ::windows::core::zeroed::<IDataModelNameBinder>();
        (::windows::core::Interface::vtable(self).GetDefaultNameBinder)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn RegisterScriptProvider<P0>(&self, provider: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDataModelScriptProvider>,
    {
        (::windows::core::Interface::vtable(self).RegisterScriptProvider)(::windows::core::Interface::as_raw(self), provider.into_param().abi()).ok()
    }
    pub unsafe fn UnregisterScriptProvider<P0>(&self, provider: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDataModelScriptProvider>,
    {
        (::windows::core::Interface::vtable(self).UnregisterScriptProvider)(::windows::core::Interface::as_raw(self), provider.into_param().abi()).ok()
    }
    pub unsafe fn FindProviderForScriptType<P0>(&self, scripttype: P0) -> ::windows::core::Result<IDataModelScriptProvider>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        let mut result__ = ::windows::core::zeroed::<IDataModelScriptProvider>();
        (::windows::core::Interface::vtable(self).FindProviderForScriptType)(::windows::core::Interface::as_raw(self), scripttype.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn FindProviderForScriptExtension<P0>(&self, scriptextension: P0) -> ::windows::core::Result<IDataModelScriptProvider>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        let mut result__ = ::windows::core::zeroed::<IDataModelScriptProvider>();
        (::windows::core::Interface::vtable(self).FindProviderForScriptExtension)(::windows::core::Interface::as_raw(self), scriptextension.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn EnumerateScriptProviders(&self) -> ::windows::core::Result<IDataModelScriptProviderEnumerator> {
        let mut result__ = ::windows::core::zeroed::<IDataModelScriptProviderEnumerator>();
        (::windows::core::Interface::vtable(self).EnumerateScriptProviders)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
}
::windows::imp::interface_hierarchy!(IDataModelScriptManager, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IDataModelScriptManager {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDataModelScriptManager {}
impl ::core::fmt::Debug for IDataModelScriptManager {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDataModelScriptManager").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDataModelScriptManager {
    type Vtable = IDataModelScriptManager_Vtbl;
}
impl ::core::clone::Clone for IDataModelScriptManager {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IDataModelScriptManager {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x6fd11e33_e5ad_410b_8011_68c6bc4bf80d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDataModelScriptManager_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub GetDefaultNameBinder: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppnamebinder: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub RegisterScriptProvider: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, provider: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub UnregisterScriptProvider: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, provider: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub FindProviderForScriptType: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, scripttype: ::windows::core::PCWSTR, provider: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub FindProviderForScriptExtension: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, scriptextension: ::windows::core::PCWSTR, provider: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub EnumerateScriptProviders: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, enumerator: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IDataModelScriptProvider(::windows::core::IUnknown);
impl IDataModelScriptProvider {
    pub unsafe fn GetName(&self) -> ::windows::core::Result<::windows::core::BSTR> {
        let mut result__ = ::windows::core::zeroed::<::windows::core::BSTR>();
        (::windows::core::Interface::vtable(self).GetName)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetExtension(&self) -> ::windows::core::Result<::windows::core::BSTR> {
        let mut result__ = ::windows::core::zeroed::<::windows::core::BSTR>();
        (::windows::core::Interface::vtable(self).GetExtension)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn CreateScript(&self) -> ::windows::core::Result<IDataModelScript> {
        let mut result__ = ::windows::core::zeroed::<IDataModelScript>();
        (::windows::core::Interface::vtable(self).CreateScript)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetDefaultTemplateContent(&self) -> ::windows::core::Result<IDataModelScriptTemplate> {
        let mut result__ = ::windows::core::zeroed::<IDataModelScriptTemplate>();
        (::windows::core::Interface::vtable(self).GetDefaultTemplateContent)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn EnumerateTemplates(&self) -> ::windows::core::Result<IDataModelScriptTemplateEnumerator> {
        let mut result__ = ::windows::core::zeroed::<IDataModelScriptTemplateEnumerator>();
        (::windows::core::Interface::vtable(self).EnumerateTemplates)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
}
::windows::imp::interface_hierarchy!(IDataModelScriptProvider, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IDataModelScriptProvider {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDataModelScriptProvider {}
impl ::core::fmt::Debug for IDataModelScriptProvider {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDataModelScriptProvider").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDataModelScriptProvider {
    type Vtable = IDataModelScriptProvider_Vtbl;
}
impl ::core::clone::Clone for IDataModelScriptProvider {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IDataModelScriptProvider {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x513461e0_4fca_48ce_8658_32f3e2056f3b);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDataModelScriptProvider_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub GetName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, name: *mut ::std::mem::MaybeUninit<::windows::core::BSTR>) -> ::windows::core::HRESULT,
    pub GetExtension: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, extension: *mut ::std::mem::MaybeUninit<::windows::core::BSTR>) -> ::windows::core::HRESULT,
    pub CreateScript: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, script: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetDefaultTemplateContent: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, templatecontent: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub EnumerateTemplates: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, enumerator: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IDataModelScriptProviderEnumerator(::windows::core::IUnknown);
impl IDataModelScriptProviderEnumerator {
    pub unsafe fn Reset(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Reset)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetNext(&self) -> ::windows::core::Result<IDataModelScriptProvider> {
        let mut result__ = ::windows::core::zeroed::<IDataModelScriptProvider>();
        (::windows::core::Interface::vtable(self).GetNext)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
}
::windows::imp::interface_hierarchy!(IDataModelScriptProviderEnumerator, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IDataModelScriptProviderEnumerator {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDataModelScriptProviderEnumerator {}
impl ::core::fmt::Debug for IDataModelScriptProviderEnumerator {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDataModelScriptProviderEnumerator").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDataModelScriptProviderEnumerator {
    type Vtable = IDataModelScriptProviderEnumerator_Vtbl;
}
impl ::core::clone::Clone for IDataModelScriptProviderEnumerator {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IDataModelScriptProviderEnumerator {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x95ba00e2_704a_4fe2_a8f1_a7e7d8fb0941);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDataModelScriptProviderEnumerator_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub Reset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetNext: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, provider: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IDataModelScriptTemplate(::windows::core::IUnknown);
impl IDataModelScriptTemplate {
    pub unsafe fn GetName(&self) -> ::windows::core::Result<::windows::core::BSTR> {
        let mut result__ = ::windows::core::zeroed::<::windows::core::BSTR>();
        (::windows::core::Interface::vtable(self).GetName)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetDescription(&self) -> ::windows::core::Result<::windows::core::BSTR> {
        let mut result__ = ::windows::core::zeroed::<::windows::core::BSTR>();
        (::windows::core::Interface::vtable(self).GetDescription)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetContent(&self) -> ::windows::core::Result<super::super::Com::IStream> {
        let mut result__ = ::windows::core::zeroed::<super::super::Com::IStream>();
        (::windows::core::Interface::vtable(self).GetContent)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
}
::windows::imp::interface_hierarchy!(IDataModelScriptTemplate, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IDataModelScriptTemplate {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDataModelScriptTemplate {}
impl ::core::fmt::Debug for IDataModelScriptTemplate {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDataModelScriptTemplate").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDataModelScriptTemplate {
    type Vtable = IDataModelScriptTemplate_Vtbl;
}
impl ::core::clone::Clone for IDataModelScriptTemplate {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IDataModelScriptTemplate {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1303dec4_fa3b_4f1b_9224_b953d16babb5);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDataModelScriptTemplate_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub GetName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, templatename: *mut ::std::mem::MaybeUninit<::windows::core::BSTR>) -> ::windows::core::HRESULT,
    pub GetDescription: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, templatedescription: *mut ::std::mem::MaybeUninit<::windows::core::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub GetContent: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, contentstream: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    GetContent: usize,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IDataModelScriptTemplateEnumerator(::windows::core::IUnknown);
impl IDataModelScriptTemplateEnumerator {
    pub unsafe fn Reset(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Reset)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetNext(&self) -> ::windows::core::Result<IDataModelScriptTemplate> {
        let mut result__ = ::windows::core::zeroed::<IDataModelScriptTemplate>();
        (::windows::core::Interface::vtable(self).GetNext)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
}
::windows::imp::interface_hierarchy!(IDataModelScriptTemplateEnumerator, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IDataModelScriptTemplateEnumerator {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDataModelScriptTemplateEnumerator {}
impl ::core::fmt::Debug for IDataModelScriptTemplateEnumerator {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDataModelScriptTemplateEnumerator").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDataModelScriptTemplateEnumerator {
    type Vtable = IDataModelScriptTemplateEnumerator_Vtbl;
}
impl ::core::clone::Clone for IDataModelScriptTemplateEnumerator {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IDataModelScriptTemplateEnumerator {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x69ce6ae2_2268_4e6f_b062_20ce62bfe677);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDataModelScriptTemplateEnumerator_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub Reset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetNext: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, templatecontent: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IDebugAdvanced(::windows::core::IUnknown);
impl IDebugAdvanced {
    pub unsafe fn GetThreadContext(&self, context: *mut ::core::ffi::c_void, contextsize: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetThreadContext)(::windows::core::Interface::as_raw(self), context, contextsize).ok()
    }
    pub unsafe fn SetThreadContext(&self, context: *const ::core::ffi::c_void, contextsize: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetThreadContext)(::windows::core::Interface::as_raw(self), context, contextsize).ok()
    }
}
::windows::imp::interface_hierarchy!(IDebugAdvanced, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IDebugAdvanced {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDebugAdvanced {}
impl ::core::fmt::Debug for IDebugAdvanced {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDebugAdvanced").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDebugAdvanced {
    type Vtable = IDebugAdvanced_Vtbl;
}
impl ::core::clone::Clone for IDebugAdvanced {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IDebugAdvanced {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2df5f53_071f_47bd_9de6_5734c3fed689);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDebugAdvanced_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub GetThreadContext: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, context: *mut ::core::ffi::c_void, contextsize: u32) -> ::windows::core::HRESULT,
    pub SetThreadContext: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, context: *const ::core::ffi::c_void, contextsize: u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IDebugAdvanced2(::windows::core::IUnknown);
impl IDebugAdvanced2 {
    pub unsafe fn GetThreadContext(&self, context: *mut ::core::ffi::c_void, contextsize: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetThreadContext)(::windows::core::Interface::as_raw(self), context, contextsize).ok()
    }
    pub unsafe fn SetThreadContext(&self, context: *const ::core::ffi::c_void, contextsize: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetThreadContext)(::windows::core::Interface::as_raw(self), context, contextsize).ok()
    }
    pub unsafe fn Request(&self, request: u32, inbuffer: ::core::option::Option<*const ::core::ffi::c_void>, inbuffersize: u32, outbuffer: ::core::option::Option<*mut ::core::ffi::c_void>, outbuffersize: u32, outsize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Request)(::windows::core::Interface::as_raw(self), request, ::core::mem::transmute(inbuffer.unwrap_or(::std::ptr::null())), inbuffersize, ::core::mem::transmute(outbuffer.unwrap_or(::std::ptr::null_mut())), outbuffersize, ::core::mem::transmute(outsize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetSourceFileInformation<P0>(&self, which: u32, sourcefile: P0, arg64: u64, arg32: u32, buffer: ::core::option::Option<*mut ::core::ffi::c_void>, buffersize: u32, infosize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).GetSourceFileInformation)(::windows::core::Interface::as_raw(self), which, sourcefile.into_param().abi(), arg64, arg32, ::core::mem::transmute(buffer.unwrap_or(::std::ptr::null_mut())), buffersize, ::core::mem::transmute(infosize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn FindSourceFileAndToken<P0>(&self, startelement: u32, modaddr: u64, file: P0, flags: u32, filetoken: ::core::option::Option<*const ::core::ffi::c_void>, filetokensize: u32, foundelement: ::core::option::Option<*mut u32>, buffer: ::core::option::Option<&mut [u8]>, foundsize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).FindSourceFileAndToken)(::windows::core::Interface::as_raw(self), startelement, modaddr, file.into_param().abi(), flags, ::core::mem::transmute(filetoken.unwrap_or(::std::ptr::null())), filetokensize, ::core::mem::transmute(foundelement.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(foundsize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetSymbolInformation(&self, which: u32, arg64: u64, arg32: u32, buffer: ::core::option::Option<*mut ::core::ffi::c_void>, buffersize: u32, infosize: ::core::option::Option<*mut u32>, stringbuffer: ::core::option::Option<&mut [u8]>, stringsize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetSymbolInformation)(::windows::core::Interface::as_raw(self), which, arg64, arg32, ::core::mem::transmute(buffer.unwrap_or(::std::ptr::null_mut())), buffersize, ::core::mem::transmute(infosize.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(stringbuffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), stringbuffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(stringsize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetSystemObjectInformation(&self, which: u32, arg64: u64, arg32: u32, buffer: ::core::option::Option<*mut ::core::ffi::c_void>, buffersize: u32, infosize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetSystemObjectInformation)(::windows::core::Interface::as_raw(self), which, arg64, arg32, ::core::mem::transmute(buffer.unwrap_or(::std::ptr::null_mut())), buffersize, ::core::mem::transmute(infosize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
}
::windows::imp::interface_hierarchy!(IDebugAdvanced2, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IDebugAdvanced2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDebugAdvanced2 {}
impl ::core::fmt::Debug for IDebugAdvanced2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDebugAdvanced2").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDebugAdvanced2 {
    type Vtable = IDebugAdvanced2_Vtbl;
}
impl ::core::clone::Clone for IDebugAdvanced2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IDebugAdvanced2 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x716d14c9_119b_4ba5_af1f_0890e672416a);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDebugAdvanced2_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub GetThreadContext: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, context: *mut ::core::ffi::c_void, contextsize: u32) -> ::windows::core::HRESULT,
    pub SetThreadContext: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, context: *const ::core::ffi::c_void, contextsize: u32) -> ::windows::core::HRESULT,
    pub Request: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, request: u32, inbuffer: *const ::core::ffi::c_void, inbuffersize: u32, outbuffer: *mut ::core::ffi::c_void, outbuffersize: u32, outsize: *mut u32) -> ::windows::core::HRESULT,
    pub GetSourceFileInformation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, which: u32, sourcefile: ::windows::core::PCSTR, arg64: u64, arg32: u32, buffer: *mut ::core::ffi::c_void, buffersize: u32, infosize: *mut u32) -> ::windows::core::HRESULT,
    pub FindSourceFileAndToken: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, startelement: u32, modaddr: u64, file: ::windows::core::PCSTR, flags: u32, filetoken: *const ::core::ffi::c_void, filetokensize: u32, foundelement: *mut u32, buffer: ::windows::core::PSTR, buffersize: u32, foundsize: *mut u32) -> ::windows::core::HRESULT,
    pub GetSymbolInformation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, which: u32, arg64: u64, arg32: u32, buffer: *mut ::core::ffi::c_void, buffersize: u32, infosize: *mut u32, stringbuffer: ::windows::core::PSTR, stringbuffersize: u32, stringsize: *mut u32) -> ::windows::core::HRESULT,
    pub GetSystemObjectInformation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, which: u32, arg64: u64, arg32: u32, buffer: *mut ::core::ffi::c_void, buffersize: u32, infosize: *mut u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IDebugAdvanced3(::windows::core::IUnknown);
impl IDebugAdvanced3 {
    pub unsafe fn GetThreadContext(&self, context: *mut ::core::ffi::c_void, contextsize: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetThreadContext)(::windows::core::Interface::as_raw(self), context, contextsize).ok()
    }
    pub unsafe fn SetThreadContext(&self, context: *const ::core::ffi::c_void, contextsize: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetThreadContext)(::windows::core::Interface::as_raw(self), context, contextsize).ok()
    }
    pub unsafe fn Request(&self, request: u32, inbuffer: ::core::option::Option<*const ::core::ffi::c_void>, inbuffersize: u32, outbuffer: ::core::option::Option<*mut ::core::ffi::c_void>, outbuffersize: u32, outsize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Request)(::windows::core::Interface::as_raw(self), request, ::core::mem::transmute(inbuffer.unwrap_or(::std::ptr::null())), inbuffersize, ::core::mem::transmute(outbuffer.unwrap_or(::std::ptr::null_mut())), outbuffersize, ::core::mem::transmute(outsize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetSourceFileInformation<P0>(&self, which: u32, sourcefile: P0, arg64: u64, arg32: u32, buffer: ::core::option::Option<*mut ::core::ffi::c_void>, buffersize: u32, infosize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).GetSourceFileInformation)(::windows::core::Interface::as_raw(self), which, sourcefile.into_param().abi(), arg64, arg32, ::core::mem::transmute(buffer.unwrap_or(::std::ptr::null_mut())), buffersize, ::core::mem::transmute(infosize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn FindSourceFileAndToken<P0>(&self, startelement: u32, modaddr: u64, file: P0, flags: u32, filetoken: ::core::option::Option<*const ::core::ffi::c_void>, filetokensize: u32, foundelement: ::core::option::Option<*mut u32>, buffer: ::core::option::Option<&mut [u8]>, foundsize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).FindSourceFileAndToken)(::windows::core::Interface::as_raw(self), startelement, modaddr, file.into_param().abi(), flags, ::core::mem::transmute(filetoken.unwrap_or(::std::ptr::null())), filetokensize, ::core::mem::transmute(foundelement.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(foundsize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetSymbolInformation(&self, which: u32, arg64: u64, arg32: u32, buffer: ::core::option::Option<*mut ::core::ffi::c_void>, buffersize: u32, infosize: ::core::option::Option<*mut u32>, stringbuffer: ::core::option::Option<&mut [u8]>, stringsize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetSymbolInformation)(::windows::core::Interface::as_raw(self), which, arg64, arg32, ::core::mem::transmute(buffer.unwrap_or(::std::ptr::null_mut())), buffersize, ::core::mem::transmute(infosize.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(stringbuffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), stringbuffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(stringsize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetSystemObjectInformation(&self, which: u32, arg64: u64, arg32: u32, buffer: ::core::option::Option<*mut ::core::ffi::c_void>, buffersize: u32, infosize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetSystemObjectInformation)(::windows::core::Interface::as_raw(self), which, arg64, arg32, ::core::mem::transmute(buffer.unwrap_or(::std::ptr::null_mut())), buffersize, ::core::mem::transmute(infosize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetSourceFileInformationWide<P0>(&self, which: u32, sourcefile: P0, arg64: u64, arg32: u32, buffer: ::core::option::Option<*mut ::core::ffi::c_void>, buffersize: u32, infosize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).GetSourceFileInformationWide)(::windows::core::Interface::as_raw(self), which, sourcefile.into_param().abi(), arg64, arg32, ::core::mem::transmute(buffer.unwrap_or(::std::ptr::null_mut())), buffersize, ::core::mem::transmute(infosize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn FindSourceFileAndTokenWide<P0>(&self, startelement: u32, modaddr: u64, file: P0, flags: u32, filetoken: ::core::option::Option<*const ::core::ffi::c_void>, filetokensize: u32, foundelement: ::core::option::Option<*mut u32>, buffer: ::core::option::Option<&mut [u16]>, foundsize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).FindSourceFileAndTokenWide)(::windows::core::Interface::as_raw(self), startelement, modaddr, file.into_param().abi(), flags, ::core::mem::transmute(filetoken.unwrap_or(::std::ptr::null())), filetokensize, ::core::mem::transmute(foundelement.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(foundsize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetSymbolInformationWide(&self, which: u32, arg64: u64, arg32: u32, buffer: ::core::option::Option<*mut ::core::ffi::c_void>, buffersize: u32, infosize: ::core::option::Option<*mut u32>, stringbuffer: ::core::option::Option<&mut [u16]>, stringsize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetSymbolInformationWide)(::windows::core::Interface::as_raw(self), which, arg64, arg32, ::core::mem::transmute(buffer.unwrap_or(::std::ptr::null_mut())), buffersize, ::core::mem::transmute(infosize.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(stringbuffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), stringbuffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(stringsize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
}
::windows::imp::interface_hierarchy!(IDebugAdvanced3, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IDebugAdvanced3 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDebugAdvanced3 {}
impl ::core::fmt::Debug for IDebugAdvanced3 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDebugAdvanced3").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDebugAdvanced3 {
    type Vtable = IDebugAdvanced3_Vtbl;
}
impl ::core::clone::Clone for IDebugAdvanced3 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IDebugAdvanced3 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xcba4abb4_84c4_444d_87ca_a04e13286739);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDebugAdvanced3_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub GetThreadContext: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, context: *mut ::core::ffi::c_void, contextsize: u32) -> ::windows::core::HRESULT,
    pub SetThreadContext: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, context: *const ::core::ffi::c_void, contextsize: u32) -> ::windows::core::HRESULT,
    pub Request: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, request: u32, inbuffer: *const ::core::ffi::c_void, inbuffersize: u32, outbuffer: *mut ::core::ffi::c_void, outbuffersize: u32, outsize: *mut u32) -> ::windows::core::HRESULT,
    pub GetSourceFileInformation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, which: u32, sourcefile: ::windows::core::PCSTR, arg64: u64, arg32: u32, buffer: *mut ::core::ffi::c_void, buffersize: u32, infosize: *mut u32) -> ::windows::core::HRESULT,
    pub FindSourceFileAndToken: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, startelement: u32, modaddr: u64, file: ::windows::core::PCSTR, flags: u32, filetoken: *const ::core::ffi::c_void, filetokensize: u32, foundelement: *mut u32, buffer: ::windows::core::PSTR, buffersize: u32, foundsize: *mut u32) -> ::windows::core::HRESULT,
    pub GetSymbolInformation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, which: u32, arg64: u64, arg32: u32, buffer: *mut ::core::ffi::c_void, buffersize: u32, infosize: *mut u32, stringbuffer: ::windows::core::PSTR, stringbuffersize: u32, stringsize: *mut u32) -> ::windows::core::HRESULT,
    pub GetSystemObjectInformation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, which: u32, arg64: u64, arg32: u32, buffer: *mut ::core::ffi::c_void, buffersize: u32, infosize: *mut u32) -> ::windows::core::HRESULT,
    pub GetSourceFileInformationWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, which: u32, sourcefile: ::windows::core::PCWSTR, arg64: u64, arg32: u32, buffer: *mut ::core::ffi::c_void, buffersize: u32, infosize: *mut u32) -> ::windows::core::HRESULT,
    pub FindSourceFileAndTokenWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, startelement: u32, modaddr: u64, file: ::windows::core::PCWSTR, flags: u32, filetoken: *const ::core::ffi::c_void, filetokensize: u32, foundelement: *mut u32, buffer: ::windows::core::PWSTR, buffersize: u32, foundsize: *mut u32) -> ::windows::core::HRESULT,
    pub GetSymbolInformationWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, which: u32, arg64: u64, arg32: u32, buffer: *mut ::core::ffi::c_void, buffersize: u32, infosize: *mut u32, stringbuffer: ::windows::core::PWSTR, stringbuffersize: u32, stringsize: *mut u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IDebugAdvanced4(::windows::core::IUnknown);
impl IDebugAdvanced4 {
    pub unsafe fn GetThreadContext(&self, context: *mut ::core::ffi::c_void, contextsize: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetThreadContext)(::windows::core::Interface::as_raw(self), context, contextsize).ok()
    }
    pub unsafe fn SetThreadContext(&self, context: *const ::core::ffi::c_void, contextsize: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetThreadContext)(::windows::core::Interface::as_raw(self), context, contextsize).ok()
    }
    pub unsafe fn Request(&self, request: u32, inbuffer: ::core::option::Option<*const ::core::ffi::c_void>, inbuffersize: u32, outbuffer: ::core::option::Option<*mut ::core::ffi::c_void>, outbuffersize: u32, outsize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Request)(::windows::core::Interface::as_raw(self), request, ::core::mem::transmute(inbuffer.unwrap_or(::std::ptr::null())), inbuffersize, ::core::mem::transmute(outbuffer.unwrap_or(::std::ptr::null_mut())), outbuffersize, ::core::mem::transmute(outsize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetSourceFileInformation<P0>(&self, which: u32, sourcefile: P0, arg64: u64, arg32: u32, buffer: ::core::option::Option<*mut ::core::ffi::c_void>, buffersize: u32, infosize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).GetSourceFileInformation)(::windows::core::Interface::as_raw(self), which, sourcefile.into_param().abi(), arg64, arg32, ::core::mem::transmute(buffer.unwrap_or(::std::ptr::null_mut())), buffersize, ::core::mem::transmute(infosize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn FindSourceFileAndToken<P0>(&self, startelement: u32, modaddr: u64, file: P0, flags: u32, filetoken: ::core::option::Option<*const ::core::ffi::c_void>, filetokensize: u32, foundelement: ::core::option::Option<*mut u32>, buffer: ::core::option::Option<&mut [u8]>, foundsize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).FindSourceFileAndToken)(::windows::core::Interface::as_raw(self), startelement, modaddr, file.into_param().abi(), flags, ::core::mem::transmute(filetoken.unwrap_or(::std::ptr::null())), filetokensize, ::core::mem::transmute(foundelement.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(foundsize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetSymbolInformation(&self, which: u32, arg64: u64, arg32: u32, buffer: ::core::option::Option<*mut ::core::ffi::c_void>, buffersize: u32, infosize: ::core::option::Option<*mut u32>, stringbuffer: ::core::option::Option<&mut [u8]>, stringsize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetSymbolInformation)(::windows::core::Interface::as_raw(self), which, arg64, arg32, ::core::mem::transmute(buffer.unwrap_or(::std::ptr::null_mut())), buffersize, ::core::mem::transmute(infosize.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(stringbuffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), stringbuffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(stringsize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetSystemObjectInformation(&self, which: u32, arg64: u64, arg32: u32, buffer: ::core::option::Option<*mut ::core::ffi::c_void>, buffersize: u32, infosize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetSystemObjectInformation)(::windows::core::Interface::as_raw(self), which, arg64, arg32, ::core::mem::transmute(buffer.unwrap_or(::std::ptr::null_mut())), buffersize, ::core::mem::transmute(infosize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetSourceFileInformationWide<P0>(&self, which: u32, sourcefile: P0, arg64: u64, arg32: u32, buffer: ::core::option::Option<*mut ::core::ffi::c_void>, buffersize: u32, infosize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).GetSourceFileInformationWide)(::windows::core::Interface::as_raw(self), which, sourcefile.into_param().abi(), arg64, arg32, ::core::mem::transmute(buffer.unwrap_or(::std::ptr::null_mut())), buffersize, ::core::mem::transmute(infosize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn FindSourceFileAndTokenWide<P0>(&self, startelement: u32, modaddr: u64, file: P0, flags: u32, filetoken: ::core::option::Option<*const ::core::ffi::c_void>, filetokensize: u32, foundelement: ::core::option::Option<*mut u32>, buffer: ::core::option::Option<&mut [u16]>, foundsize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).FindSourceFileAndTokenWide)(::windows::core::Interface::as_raw(self), startelement, modaddr, file.into_param().abi(), flags, ::core::mem::transmute(filetoken.unwrap_or(::std::ptr::null())), filetokensize, ::core::mem::transmute(foundelement.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(foundsize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetSymbolInformationWide(&self, which: u32, arg64: u64, arg32: u32, buffer: ::core::option::Option<*mut ::core::ffi::c_void>, buffersize: u32, infosize: ::core::option::Option<*mut u32>, stringbuffer: ::core::option::Option<&mut [u16]>, stringsize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetSymbolInformationWide)(::windows::core::Interface::as_raw(self), which, arg64, arg32, ::core::mem::transmute(buffer.unwrap_or(::std::ptr::null_mut())), buffersize, ::core::mem::transmute(infosize.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(stringbuffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), stringbuffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(stringsize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetSymbolInformationWideEx(&self, which: u32, arg64: u64, arg32: u32, buffer: ::core::option::Option<*mut ::core::ffi::c_void>, buffersize: u32, infosize: ::core::option::Option<*mut u32>, stringbuffer: ::core::option::Option<&mut [u16]>, stringsize: ::core::option::Option<*mut u32>, pinfoex: ::core::option::Option<*mut SYMBOL_INFO_EX>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetSymbolInformationWideEx)(
            ::windows::core::Interface::as_raw(self),
            which,
            arg64,
            arg32,
            ::core::mem::transmute(buffer.unwrap_or(::std::ptr::null_mut())),
            buffersize,
            ::core::mem::transmute(infosize.unwrap_or(::std::ptr::null_mut())),
            ::core::mem::transmute(stringbuffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
            stringbuffer.as_deref().map_or(0, |slice| slice.len() as _),
            ::core::mem::transmute(stringsize.unwrap_or(::std::ptr::null_mut())),
            ::core::mem::transmute(pinfoex.unwrap_or(::std::ptr::null_mut())),
        )
        .ok()
    }
}
::windows::imp::interface_hierarchy!(IDebugAdvanced4, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IDebugAdvanced4 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDebugAdvanced4 {}
impl ::core::fmt::Debug for IDebugAdvanced4 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDebugAdvanced4").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDebugAdvanced4 {
    type Vtable = IDebugAdvanced4_Vtbl;
}
impl ::core::clone::Clone for IDebugAdvanced4 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IDebugAdvanced4 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xd1069067_2a65_4bf0_ae97_76184b67856b);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDebugAdvanced4_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub GetThreadContext: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, context: *mut ::core::ffi::c_void, contextsize: u32) -> ::windows::core::HRESULT,
    pub SetThreadContext: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, context: *const ::core::ffi::c_void, contextsize: u32) -> ::windows::core::HRESULT,
    pub Request: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, request: u32, inbuffer: *const ::core::ffi::c_void, inbuffersize: u32, outbuffer: *mut ::core::ffi::c_void, outbuffersize: u32, outsize: *mut u32) -> ::windows::core::HRESULT,
    pub GetSourceFileInformation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, which: u32, sourcefile: ::windows::core::PCSTR, arg64: u64, arg32: u32, buffer: *mut ::core::ffi::c_void, buffersize: u32, infosize: *mut u32) -> ::windows::core::HRESULT,
    pub FindSourceFileAndToken: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, startelement: u32, modaddr: u64, file: ::windows::core::PCSTR, flags: u32, filetoken: *const ::core::ffi::c_void, filetokensize: u32, foundelement: *mut u32, buffer: ::windows::core::PSTR, buffersize: u32, foundsize: *mut u32) -> ::windows::core::HRESULT,
    pub GetSymbolInformation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, which: u32, arg64: u64, arg32: u32, buffer: *mut ::core::ffi::c_void, buffersize: u32, infosize: *mut u32, stringbuffer: ::windows::core::PSTR, stringbuffersize: u32, stringsize: *mut u32) -> ::windows::core::HRESULT,
    pub GetSystemObjectInformation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, which: u32, arg64: u64, arg32: u32, buffer: *mut ::core::ffi::c_void, buffersize: u32, infosize: *mut u32) -> ::windows::core::HRESULT,
    pub GetSourceFileInformationWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, which: u32, sourcefile: ::windows::core::PCWSTR, arg64: u64, arg32: u32, buffer: *mut ::core::ffi::c_void, buffersize: u32, infosize: *mut u32) -> ::windows::core::HRESULT,
    pub FindSourceFileAndTokenWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, startelement: u32, modaddr: u64, file: ::windows::core::PCWSTR, flags: u32, filetoken: *const ::core::ffi::c_void, filetokensize: u32, foundelement: *mut u32, buffer: ::windows::core::PWSTR, buffersize: u32, foundsize: *mut u32) -> ::windows::core::HRESULT,
    pub GetSymbolInformationWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, which: u32, arg64: u64, arg32: u32, buffer: *mut ::core::ffi::c_void, buffersize: u32, infosize: *mut u32, stringbuffer: ::windows::core::PWSTR, stringbuffersize: u32, stringsize: *mut u32) -> ::windows::core::HRESULT,
    pub GetSymbolInformationWideEx: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, which: u32, arg64: u64, arg32: u32, buffer: *mut ::core::ffi::c_void, buffersize: u32, infosize: *mut u32, stringbuffer: ::windows::core::PWSTR, stringbuffersize: u32, stringsize: *mut u32, pinfoex: *mut SYMBOL_INFO_EX) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IDebugApplication11032(::windows::core::IUnknown);
impl IDebugApplication11032 {
    pub unsafe fn SetDebuggerOptions(&self, mask: SCRIPT_DEBUGGER_OPTIONS, value: SCRIPT_DEBUGGER_OPTIONS) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.SetDebuggerOptions)(::windows::core::Interface::as_raw(self), mask, value).ok()
    }
    pub unsafe fn GetCurrentDebuggerOptions(&self) -> ::windows::core::Result<SCRIPT_DEBUGGER_OPTIONS> {
        let mut result__ = ::windows::core::zeroed::<SCRIPT_DEBUGGER_OPTIONS>();
        (::windows::core::Interface::vtable(self).base__.GetCurrentDebuggerOptions)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetMainThread(&self) -> ::windows::core::Result<IRemoteDebugApplicationThread> {
        let mut result__ = ::windows::core::zeroed::<IRemoteDebugApplicationThread>();
        (::windows::core::Interface::vtable(self).base__.GetMainThread)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SynchronousCallInMainThread<P0>(&self, pptc: P0, dwparam1: usize, dwparam2: usize, dwparam3: usize) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugThreadCall32>,
    {
        (::windows::core::Interface::vtable(self).SynchronousCallInMainThread)(::windows::core::Interface::as_raw(self), pptc.into_param().abi(), dwparam1, dwparam2, dwparam3).ok()
    }
    pub unsafe fn AsynchronousCallInMainThread<P0>(&self, pptc: P0, dwparam1: usize, dwparam2: usize, dwparam3: usize) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugThreadCall32>,
    {
        (::windows::core::Interface::vtable(self).AsynchronousCallInMainThread)(::windows::core::Interface::as_raw(self), pptc.into_param().abi(), dwparam1, dwparam2, dwparam3).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CallableWaitForHandles(&self, phandles: &[super::super::super::Foundation::HANDLE]) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).CallableWaitForHandles)(::windows::core::Interface::as_raw(self), phandles.len() as _, ::core::mem::transmute(phandles.as_ptr()), &mut result__).from_abi(result__)
    }
}
::windows::imp::interface_hierarchy!(IDebugApplication11032, ::windows::core::IUnknown, IRemoteDebugApplication110);
impl ::core::cmp::PartialEq for IDebugApplication11032 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDebugApplication11032 {}
impl ::core::fmt::Debug for IDebugApplication11032 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDebugApplication11032").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDebugApplication11032 {
    type Vtable = IDebugApplication11032_Vtbl;
}
impl ::core::clone::Clone for IDebugApplication11032 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IDebugApplication11032 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xbdb3b5de_89f2_4e11_84a5_97445f941c7d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDebugApplication11032_Vtbl {
    pub base__: IRemoteDebugApplication110_Vtbl,
    pub SynchronousCallInMainThread: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pptc: *mut ::core::ffi::c_void, dwparam1: usize, dwparam2: usize, dwparam3: usize) -> ::windows::core::HRESULT,
    pub AsynchronousCallInMainThread: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pptc: *mut ::core::ffi::c_void, dwparam1: usize, dwparam2: usize, dwparam3: usize) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub CallableWaitForHandles: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, handlecount: u32, phandles: *const super::super::super::Foundation::HANDLE, pindex: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    CallableWaitForHandles: usize,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IDebugApplication11064(::windows::core::IUnknown);
impl IDebugApplication11064 {
    pub unsafe fn SetDebuggerOptions(&self, mask: SCRIPT_DEBUGGER_OPTIONS, value: SCRIPT_DEBUGGER_OPTIONS) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.SetDebuggerOptions)(::windows::core::Interface::as_raw(self), mask, value).ok()
    }
    pub unsafe fn GetCurrentDebuggerOptions(&self) -> ::windows::core::Result<SCRIPT_DEBUGGER_OPTIONS> {
        let mut result__ = ::windows::core::zeroed::<SCRIPT_DEBUGGER_OPTIONS>();
        (::windows::core::Interface::vtable(self).base__.GetCurrentDebuggerOptions)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetMainThread(&self) -> ::windows::core::Result<IRemoteDebugApplicationThread> {
        let mut result__ = ::windows::core::zeroed::<IRemoteDebugApplicationThread>();
        (::windows::core::Interface::vtable(self).base__.GetMainThread)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SynchronousCallInMainThread<P0>(&self, pptc: P0, dwparam1: usize, dwparam2: usize, dwparam3: usize) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugThreadCall64>,
    {
        (::windows::core::Interface::vtable(self).SynchronousCallInMainThread)(::windows::core::Interface::as_raw(self), pptc.into_param().abi(), dwparam1, dwparam2, dwparam3).ok()
    }
    pub unsafe fn AsynchronousCallInMainThread<P0>(&self, pptc: P0, dwparam1: usize, dwparam2: usize, dwparam3: usize) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugThreadCall64>,
    {
        (::windows::core::Interface::vtable(self).AsynchronousCallInMainThread)(::windows::core::Interface::as_raw(self), pptc.into_param().abi(), dwparam1, dwparam2, dwparam3).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CallableWaitForHandles(&self, phandles: &[super::super::super::Foundation::HANDLE]) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).CallableWaitForHandles)(::windows::core::Interface::as_raw(self), phandles.len() as _, ::core::mem::transmute(phandles.as_ptr()), &mut result__).from_abi(result__)
    }
}
::windows::imp::interface_hierarchy!(IDebugApplication11064, ::windows::core::IUnknown, IRemoteDebugApplication110);
impl ::core::cmp::PartialEq for IDebugApplication11064 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDebugApplication11064 {}
impl ::core::fmt::Debug for IDebugApplication11064 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDebugApplication11064").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDebugApplication11064 {
    type Vtable = IDebugApplication11064_Vtbl;
}
impl ::core::clone::Clone for IDebugApplication11064 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IDebugApplication11064 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x2039d958_4eeb_496a_87bb_2e5201eadeef);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDebugApplication11064_Vtbl {
    pub base__: IRemoteDebugApplication110_Vtbl,
    pub SynchronousCallInMainThread: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pptc: *mut ::core::ffi::c_void, dwparam1: usize, dwparam2: usize, dwparam3: usize) -> ::windows::core::HRESULT,
    pub AsynchronousCallInMainThread: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pptc: *mut ::core::ffi::c_void, dwparam1: usize, dwparam2: usize, dwparam3: usize) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub CallableWaitForHandles: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, handlecount: u32, phandles: *const super::super::super::Foundation::HANDLE, pindex: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    CallableWaitForHandles: usize,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IDebugApplication32(::windows::core::IUnknown);
impl IDebugApplication32 {
    pub unsafe fn ResumeFromBreakPoint<P0>(&self, prptfocus: P0, bra: BREAKRESUMEACTION, era: ERRORRESUMEACTION) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IRemoteDebugApplicationThread>,
    {
        (::windows::core::Interface::vtable(self).base__.ResumeFromBreakPoint)(::windows::core::Interface::as_raw(self), prptfocus.into_param().abi(), bra, era).ok()
    }
    pub unsafe fn CauseBreak(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.CauseBreak)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn ConnectDebugger<P0>(&self, pad: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IApplicationDebugger>,
    {
        (::windows::core::Interface::vtable(self).base__.ConnectDebugger)(::windows::core::Interface::as_raw(self), pad.into_param().abi()).ok()
    }
    pub unsafe fn DisconnectDebugger(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.DisconnectDebugger)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetDebugger(&self) -> ::windows::core::Result<IApplicationDebugger> {
        let mut result__ = ::windows::core::zeroed::<IApplicationDebugger>();
        (::windows::core::Interface::vtable(self).base__.GetDebugger)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn CreateInstanceAtApplication<P0>(&self, rclsid: *const ::windows::core::GUID, punkouter: P0, dwclscontext: u32, riid: *const ::windows::core::GUID) -> ::windows::core::Result<::windows::core::IUnknown>
    where
        P0: ::windows::core::IntoParam<::windows::core::IUnknown>,
    {
        let mut result__ = ::windows::core::zeroed::<::windows::core::IUnknown>();
        (::windows::core::Interface::vtable(self).base__.CreateInstanceAtApplication)(::windows::core::Interface::as_raw(self), rclsid, punkouter.into_param().abi(), dwclscontext, riid, &mut result__).from_abi(result__)
    }
    pub unsafe fn QueryAlive(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.QueryAlive)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn EnumThreads(&self) -> ::windows::core::Result<IEnumRemoteDebugApplicationThreads> {
        let mut result__ = ::windows::core::zeroed::<IEnumRemoteDebugApplicationThreads>();
        (::windows::core::Interface::vtable(self).base__.EnumThreads)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetName(&self) -> ::windows::core::Result<::windows::core::BSTR> {
        let mut result__ = ::windows::core::zeroed::<::windows::core::BSTR>();
        (::windows::core::Interface::vtable(self).base__.GetName)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetRootNode(&self) -> ::windows::core::Result<IDebugApplicationNode> {
        let mut result__ = ::windows::core::zeroed::<IDebugApplicationNode>();
        (::windows::core::Interface::vtable(self).base__.GetRootNode)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn EnumGlobalExpressionContexts(&self) -> ::windows::core::Result<IEnumDebugExpressionContexts> {
        let mut result__ = ::windows::core::zeroed::<IEnumDebugExpressionContexts>();
        (::windows::core::Interface::vtable(self).base__.EnumGlobalExpressionContexts)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetName<P0>(&self, pstrname: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).SetName)(::windows::core::Interface::as_raw(self), pstrname.into_param().abi()).ok()
    }
    pub unsafe fn StepOutComplete(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).StepOutComplete)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn DebugOutput<P0>(&self, pstr: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).DebugOutput)(::windows::core::Interface::as_raw(self), pstr.into_param().abi()).ok()
    }
    pub unsafe fn StartDebugSession(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).StartDebugSession)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn HandleBreakPoint(&self, br: BREAKREASON) -> ::windows::core::Result<BREAKRESUMEACTION> {
        let mut result__ = ::windows::core::zeroed::<BREAKRESUMEACTION>();
        (::windows::core::Interface::vtable(self).HandleBreakPoint)(::windows::core::Interface::as_raw(self), br, &mut result__).from_abi(result__)
    }
    pub unsafe fn Close(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Close)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetBreakFlags(&self, pabf: *mut u32, pprdatsteppingthread: *mut ::core::option::Option<IRemoteDebugApplicationThread>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetBreakFlags)(::windows::core::Interface::as_raw(self), pabf, ::core::mem::transmute(pprdatsteppingthread)).ok()
    }
    pub unsafe fn GetCurrentThread(&self) -> ::windows::core::Result<IDebugApplicationThread> {
        let mut result__ = ::windows::core::zeroed::<IDebugApplicationThread>();
        (::windows::core::Interface::vtable(self).GetCurrentThread)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn CreateAsyncDebugOperation<P0>(&self, psdo: P0) -> ::windows::core::Result<IDebugAsyncOperation>
    where
        P0: ::windows::core::IntoParam<IDebugSyncOperation>,
    {
        let mut result__ = ::windows::core::zeroed::<IDebugAsyncOperation>();
        (::windows::core::Interface::vtable(self).CreateAsyncDebugOperation)(::windows::core::Interface::as_raw(self), psdo.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn AddStackFrameSniffer<P0>(&self, pdsfs: P0) -> ::windows::core::Result<u32>
    where
        P0: ::windows::core::IntoParam<IDebugStackFrameSniffer>,
    {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).AddStackFrameSniffer)(::windows::core::Interface::as_raw(self), pdsfs.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn RemoveStackFrameSniffer(&self, dwcookie: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).RemoveStackFrameSniffer)(::windows::core::Interface::as_raw(self), dwcookie).ok()
    }
    pub unsafe fn QueryCurrentThreadIsDebuggerThread(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).QueryCurrentThreadIsDebuggerThread)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn SynchronousCallInDebuggerThread<P0>(&self, pptc: P0, dwparam1: u32, dwparam2: u32, dwparam3: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugThreadCall32>,
    {
        (::windows::core::Interface::vtable(self).SynchronousCallInDebuggerThread)(::windows::core::Interface::as_raw(self), pptc.into_param().abi(), dwparam1, dwparam2, dwparam3).ok()
    }
    pub unsafe fn CreateApplicationNode(&self) -> ::windows::core::Result<IDebugApplicationNode> {
        let mut result__ = ::windows::core::zeroed::<IDebugApplicationNode>();
        (::windows::core::Interface::vtable(self).CreateApplicationNode)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn FireDebuggerEvent<P0>(&self, riid: *const ::windows::core::GUID, punk: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::IUnknown>,
    {
        (::windows::core::Interface::vtable(self).FireDebuggerEvent)(::windows::core::Interface::as_raw(self), riid, punk.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn HandleRuntimeError<P0, P1>(&self, perrordebug: P0, pscriptsite: P1, pbra: *mut BREAKRESUMEACTION, perra: *mut ERRORRESUMEACTION, pfcallonscripterror: *mut super::super::super::Foundation::BOOL) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IActiveScriptErrorDebug>,
        P1: ::windows::core::IntoParam<IActiveScriptSite>,
    {
        (::windows::core::Interface::vtable(self).HandleRuntimeError)(::windows::core::Interface::as_raw(self), perrordebug.into_param().abi(), pscriptsite.into_param().abi(), pbra, perra, pfcallonscripterror).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn FCanJitDebug(&self) -> super::super::super::Foundation::BOOL {
        (::windows::core::Interface::vtable(self).FCanJitDebug)(::windows::core::Interface::as_raw(self))
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn FIsAutoJitDebugEnabled(&self) -> super::super::super::Foundation::BOOL {
        (::windows::core::Interface::vtable(self).FIsAutoJitDebugEnabled)(::windows::core::Interface::as_raw(self))
    }
    pub unsafe fn AddGlobalExpressionContextProvider<P0>(&self, pdsfs: P0) -> ::windows::core::Result<u32>
    where
        P0: ::windows::core::IntoParam<IProvideExpressionContexts>,
    {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).AddGlobalExpressionContextProvider)(::windows::core::Interface::as_raw(self), pdsfs.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn RemoveGlobalExpressionContextProvider(&self, dwcookie: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).RemoveGlobalExpressionContextProvider)(::windows::core::Interface::as_raw(self), dwcookie).ok()
    }
}
::windows::imp::interface_hierarchy!(IDebugApplication32, ::windows::core::IUnknown, IRemoteDebugApplication);
impl ::core::cmp::PartialEq for IDebugApplication32 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDebugApplication32 {}
impl ::core::fmt::Debug for IDebugApplication32 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDebugApplication32").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDebugApplication32 {
    type Vtable = IDebugApplication32_Vtbl;
}
impl ::core::clone::Clone for IDebugApplication32 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IDebugApplication32 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x51973c32_cb0c_11d0_b5c9_00a0244a0e7a);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDebugApplication32_Vtbl {
    pub base__: IRemoteDebugApplication_Vtbl,
    pub SetName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstrname: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub StepOutComplete: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub DebugOutput: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstr: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub StartDebugSession: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub HandleBreakPoint: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, br: BREAKREASON, pbra: *mut BREAKRESUMEACTION) -> ::windows::core::HRESULT,
    pub Close: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetBreakFlags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pabf: *mut u32, pprdatsteppingthread: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetCurrentThread: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pat: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub CreateAsyncDebugOperation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, psdo: *mut ::core::ffi::c_void, ppado: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub AddStackFrameSniffer: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdsfs: *mut ::core::ffi::c_void, pdwcookie: *mut u32) -> ::windows::core::HRESULT,
    pub RemoveStackFrameSniffer: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwcookie: u32) -> ::windows::core::HRESULT,
    pub QueryCurrentThreadIsDebuggerThread: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub SynchronousCallInDebuggerThread: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pptc: *mut ::core::ffi::c_void, dwparam1: u32, dwparam2: u32, dwparam3: u32) -> ::windows::core::HRESULT,
    pub CreateApplicationNode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppdannew: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub FireDebuggerEvent: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, punk: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub HandleRuntimeError: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, perrordebug: *mut ::core::ffi::c_void, pscriptsite: *mut ::core::ffi::c_void, pbra: *mut BREAKRESUMEACTION, perra: *mut ERRORRESUMEACTION, pfcallonscripterror: *mut super::super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    HandleRuntimeError: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub FCanJitDebug: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> super::super::super::Foundation::BOOL,
    #[cfg(not(feature = "Win32_Foundation"))]
    FCanJitDebug: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub FIsAutoJitDebugEnabled: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> super::super::super::Foundation::BOOL,
    #[cfg(not(feature = "Win32_Foundation"))]
    FIsAutoJitDebugEnabled: usize,
    pub AddGlobalExpressionContextProvider: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdsfs: *mut ::core::ffi::c_void, pdwcookie: *mut u32) -> ::windows::core::HRESULT,
    pub RemoveGlobalExpressionContextProvider: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwcookie: u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IDebugApplication64(::windows::core::IUnknown);
impl IDebugApplication64 {
    pub unsafe fn ResumeFromBreakPoint<P0>(&self, prptfocus: P0, bra: BREAKRESUMEACTION, era: ERRORRESUMEACTION) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IRemoteDebugApplicationThread>,
    {
        (::windows::core::Interface::vtable(self).base__.ResumeFromBreakPoint)(::windows::core::Interface::as_raw(self), prptfocus.into_param().abi(), bra, era).ok()
    }
    pub unsafe fn CauseBreak(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.CauseBreak)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn ConnectDebugger<P0>(&self, pad: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IApplicationDebugger>,
    {
        (::windows::core::Interface::vtable(self).base__.ConnectDebugger)(::windows::core::Interface::as_raw(self), pad.into_param().abi()).ok()
    }
    pub unsafe fn DisconnectDebugger(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.DisconnectDebugger)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetDebugger(&self) -> ::windows::core::Result<IApplicationDebugger> {
        let mut result__ = ::windows::core::zeroed::<IApplicationDebugger>();
        (::windows::core::Interface::vtable(self).base__.GetDebugger)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn CreateInstanceAtApplication<P0>(&self, rclsid: *const ::windows::core::GUID, punkouter: P0, dwclscontext: u32, riid: *const ::windows::core::GUID) -> ::windows::core::Result<::windows::core::IUnknown>
    where
        P0: ::windows::core::IntoParam<::windows::core::IUnknown>,
    {
        let mut result__ = ::windows::core::zeroed::<::windows::core::IUnknown>();
        (::windows::core::Interface::vtable(self).base__.CreateInstanceAtApplication)(::windows::core::Interface::as_raw(self), rclsid, punkouter.into_param().abi(), dwclscontext, riid, &mut result__).from_abi(result__)
    }
    pub unsafe fn QueryAlive(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.QueryAlive)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn EnumThreads(&self) -> ::windows::core::Result<IEnumRemoteDebugApplicationThreads> {
        let mut result__ = ::windows::core::zeroed::<IEnumRemoteDebugApplicationThreads>();
        (::windows::core::Interface::vtable(self).base__.EnumThreads)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetName(&self) -> ::windows::core::Result<::windows::core::BSTR> {
        let mut result__ = ::windows::core::zeroed::<::windows::core::BSTR>();
        (::windows::core::Interface::vtable(self).base__.GetName)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetRootNode(&self) -> ::windows::core::Result<IDebugApplicationNode> {
        let mut result__ = ::windows::core::zeroed::<IDebugApplicationNode>();
        (::windows::core::Interface::vtable(self).base__.GetRootNode)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn EnumGlobalExpressionContexts(&self) -> ::windows::core::Result<IEnumDebugExpressionContexts> {
        let mut result__ = ::windows::core::zeroed::<IEnumDebugExpressionContexts>();
        (::windows::core::Interface::vtable(self).base__.EnumGlobalExpressionContexts)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetName<P0>(&self, pstrname: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).SetName)(::windows::core::Interface::as_raw(self), pstrname.into_param().abi()).ok()
    }
    pub unsafe fn StepOutComplete(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).StepOutComplete)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn DebugOutput<P0>(&self, pstr: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).DebugOutput)(::windows::core::Interface::as_raw(self), pstr.into_param().abi()).ok()
    }
    pub unsafe fn StartDebugSession(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).StartDebugSession)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn HandleBreakPoint(&self, br: BREAKREASON) -> ::windows::core::Result<BREAKRESUMEACTION> {
        let mut result__ = ::windows::core::zeroed::<BREAKRESUMEACTION>();
        (::windows::core::Interface::vtable(self).HandleBreakPoint)(::windows::core::Interface::as_raw(self), br, &mut result__).from_abi(result__)
    }
    pub unsafe fn Close(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Close)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetBreakFlags(&self, pabf: *mut u32, pprdatsteppingthread: *mut ::core::option::Option<IRemoteDebugApplicationThread>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetBreakFlags)(::windows::core::Interface::as_raw(self), pabf, ::core::mem::transmute(pprdatsteppingthread)).ok()
    }
    pub unsafe fn GetCurrentThread(&self) -> ::windows::core::Result<IDebugApplicationThread> {
        let mut result__ = ::windows::core::zeroed::<IDebugApplicationThread>();
        (::windows::core::Interface::vtable(self).GetCurrentThread)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn CreateAsyncDebugOperation<P0>(&self, psdo: P0) -> ::windows::core::Result<IDebugAsyncOperation>
    where
        P0: ::windows::core::IntoParam<IDebugSyncOperation>,
    {
        let mut result__ = ::windows::core::zeroed::<IDebugAsyncOperation>();
        (::windows::core::Interface::vtable(self).CreateAsyncDebugOperation)(::windows::core::Interface::as_raw(self), psdo.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn AddStackFrameSniffer<P0>(&self, pdsfs: P0) -> ::windows::core::Result<u32>
    where
        P0: ::windows::core::IntoParam<IDebugStackFrameSniffer>,
    {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).AddStackFrameSniffer)(::windows::core::Interface::as_raw(self), pdsfs.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn RemoveStackFrameSniffer(&self, dwcookie: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).RemoveStackFrameSniffer)(::windows::core::Interface::as_raw(self), dwcookie).ok()
    }
    pub unsafe fn QueryCurrentThreadIsDebuggerThread(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).QueryCurrentThreadIsDebuggerThread)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn SynchronousCallInDebuggerThread<P0>(&self, pptc: P0, dwparam1: u64, dwparam2: u64, dwparam3: u64) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugThreadCall64>,
    {
        (::windows::core::Interface::vtable(self).SynchronousCallInDebuggerThread)(::windows::core::Interface::as_raw(self), pptc.into_param().abi(), dwparam1, dwparam2, dwparam3).ok()
    }
    pub unsafe fn CreateApplicationNode(&self) -> ::windows::core::Result<IDebugApplicationNode> {
        let mut result__ = ::windows::core::zeroed::<IDebugApplicationNode>();
        (::windows::core::Interface::vtable(self).CreateApplicationNode)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn FireDebuggerEvent<P0>(&self, riid: *const ::windows::core::GUID, punk: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::IUnknown>,
    {
        (::windows::core::Interface::vtable(self).FireDebuggerEvent)(::windows::core::Interface::as_raw(self), riid, punk.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn HandleRuntimeError<P0, P1>(&self, perrordebug: P0, pscriptsite: P1, pbra: *mut BREAKRESUMEACTION, perra: *mut ERRORRESUMEACTION, pfcallonscripterror: *mut super::super::super::Foundation::BOOL) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IActiveScriptErrorDebug>,
        P1: ::windows::core::IntoParam<IActiveScriptSite>,
    {
        (::windows::core::Interface::vtable(self).HandleRuntimeError)(::windows::core::Interface::as_raw(self), perrordebug.into_param().abi(), pscriptsite.into_param().abi(), pbra, perra, pfcallonscripterror).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn FCanJitDebug(&self) -> super::super::super::Foundation::BOOL {
        (::windows::core::Interface::vtable(self).FCanJitDebug)(::windows::core::Interface::as_raw(self))
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn FIsAutoJitDebugEnabled(&self) -> super::super::super::Foundation::BOOL {
        (::windows::core::Interface::vtable(self).FIsAutoJitDebugEnabled)(::windows::core::Interface::as_raw(self))
    }
    pub unsafe fn AddGlobalExpressionContextProvider<P0>(&self, pdsfs: P0) -> ::windows::core::Result<u64>
    where
        P0: ::windows::core::IntoParam<IProvideExpressionContexts>,
    {
        let mut result__ = ::windows::core::zeroed::<u64>();
        (::windows::core::Interface::vtable(self).AddGlobalExpressionContextProvider)(::windows::core::Interface::as_raw(self), pdsfs.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn RemoveGlobalExpressionContextProvider(&self, dwcookie: u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).RemoveGlobalExpressionContextProvider)(::windows::core::Interface::as_raw(self), dwcookie).ok()
    }
}
::windows::imp::interface_hierarchy!(IDebugApplication64, ::windows::core::IUnknown, IRemoteDebugApplication);
impl ::core::cmp::PartialEq for IDebugApplication64 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDebugApplication64 {}
impl ::core::fmt::Debug for IDebugApplication64 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDebugApplication64").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDebugApplication64 {
    type Vtable = IDebugApplication64_Vtbl;
}
impl ::core::clone::Clone for IDebugApplication64 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IDebugApplication64 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x4dedc754_04c7_4f10_9e60_16a390fe6e62);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDebugApplication64_Vtbl {
    pub base__: IRemoteDebugApplication_Vtbl,
    pub SetName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstrname: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub StepOutComplete: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub DebugOutput: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstr: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub StartDebugSession: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub HandleBreakPoint: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, br: BREAKREASON, pbra: *mut BREAKRESUMEACTION) -> ::windows::core::HRESULT,
    pub Close: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetBreakFlags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pabf: *mut u32, pprdatsteppingthread: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetCurrentThread: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pat: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub CreateAsyncDebugOperation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, psdo: *mut ::core::ffi::c_void, ppado: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub AddStackFrameSniffer: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdsfs: *mut ::core::ffi::c_void, pdwcookie: *mut u32) -> ::windows::core::HRESULT,
    pub RemoveStackFrameSniffer: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwcookie: u32) -> ::windows::core::HRESULT,
    pub QueryCurrentThreadIsDebuggerThread: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub SynchronousCallInDebuggerThread: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pptc: *mut ::core::ffi::c_void, dwparam1: u64, dwparam2: u64, dwparam3: u64) -> ::windows::core::HRESULT,
    pub CreateApplicationNode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppdannew: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub FireDebuggerEvent: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, punk: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub HandleRuntimeError: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, perrordebug: *mut ::core::ffi::c_void, pscriptsite: *mut ::core::ffi::c_void, pbra: *mut BREAKRESUMEACTION, perra: *mut ERRORRESUMEACTION, pfcallonscripterror: *mut super::super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    HandleRuntimeError: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub FCanJitDebug: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> super::super::super::Foundation::BOOL,
    #[cfg(not(feature = "Win32_Foundation"))]
    FCanJitDebug: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub FIsAutoJitDebugEnabled: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> super::super::super::Foundation::BOOL,
    #[cfg(not(feature = "Win32_Foundation"))]
    FIsAutoJitDebugEnabled: usize,
    pub AddGlobalExpressionContextProvider: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdsfs: *mut ::core::ffi::c_void, pdwcookie: *mut u64) -> ::windows::core::HRESULT,
    pub RemoveGlobalExpressionContextProvider: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwcookie: u64) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IDebugApplicationNode(::windows::core::IUnknown);
impl IDebugApplicationNode {
    pub unsafe fn GetName(&self, dnt: DOCUMENTNAMETYPE) -> ::windows::core::Result<::windows::core::BSTR> {
        let mut result__ = ::windows::core::zeroed::<::windows::core::BSTR>();
        (::windows::core::Interface::vtable(self).base__.base__.GetName)(::windows::core::Interface::as_raw(self), dnt, &mut result__).from_abi(result__)
    }
    pub unsafe fn GetDocumentClassId(&self) -> ::windows::core::Result<::windows::core::GUID> {
        let mut result__ = ::windows::core::zeroed::<::windows::core::GUID>();
        (::windows::core::Interface::vtable(self).base__.base__.GetDocumentClassId)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetDocument(&self) -> ::windows::core::Result<IDebugDocument> {
        let mut result__ = ::windows::core::zeroed::<IDebugDocument>();
        (::windows::core::Interface::vtable(self).base__.GetDocument)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn EnumChildren(&self) -> ::windows::core::Result<IEnumDebugApplicationNodes> {
        let mut result__ = ::windows::core::zeroed::<IEnumDebugApplicationNodes>();
        (::windows::core::Interface::vtable(self).EnumChildren)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetParent(&self) -> ::windows::core::Result<IDebugApplicationNode> {
        let mut result__ = ::windows::core::zeroed::<IDebugApplicationNode>();
        (::windows::core::Interface::vtable(self).GetParent)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetDocumentProvider<P0>(&self, pddp: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugDocumentProvider>,
    {
        (::windows::core::Interface::vtable(self).SetDocumentProvider)(::windows::core::Interface::as_raw(self), pddp.into_param().abi()).ok()
    }
    pub unsafe fn Close(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Close)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Attach<P0>(&self, pdanparent: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugApplicationNode>,
    {
        (::windows::core::Interface::vtable(self).Attach)(::windows::core::Interface::as_raw(self), pdanparent.into_param().abi()).ok()
    }
    pub unsafe fn Detach(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Detach)(::windows::core::Interface::as_raw(self)).ok()
    }
}
::windows::imp::interface_hierarchy!(IDebugApplicationNode, ::windows::core::IUnknown, IDebugDocumentInfo, IDebugDocumentProvider);
impl ::core::cmp::PartialEq for IDebugApplicationNode {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDebugApplicationNode {}
impl ::core::fmt::Debug for IDebugApplicationNode {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDebugApplicationNode").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDebugApplicationNode {
    type Vtable = IDebugApplicationNode_Vtbl;
}
impl ::core::clone::Clone for IDebugApplicationNode {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IDebugApplicationNode {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x51973c34_cb0c_11d0_b5c9_00a0244a0e7a);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDebugApplicationNode_Vtbl {
    pub base__: IDebugDocumentProvider_Vtbl,
    pub EnumChildren: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pperddp: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetParent: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pprddp: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub SetDocumentProvider: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pddp: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub Close: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub Attach: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdanparent: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub Detach: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IDebugApplicationNode100(::windows::core::IUnknown);
impl IDebugApplicationNode100 {
    pub unsafe fn SetFilterForEventSink(&self, dwcookie: u32, filter: APPLICATION_NODE_EVENT_FILTER) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetFilterForEventSink)(::windows::core::Interface::as_raw(self), dwcookie, filter).ok()
    }
    pub unsafe fn GetExcludedDocuments(&self, filter: APPLICATION_NODE_EVENT_FILTER) -> ::windows::core::Result<TEXT_DOCUMENT_ARRAY> {
        let mut result__ = ::windows::core::zeroed::<TEXT_DOCUMENT_ARRAY>();
        (::windows::core::Interface::vtable(self).GetExcludedDocuments)(::windows::core::Interface::as_raw(self), filter, &mut result__).from_abi(result__)
    }
    pub unsafe fn QueryIsChildNode<P0>(&self, psearchkey: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugDocument>,
    {
        (::windows::core::Interface::vtable(self).QueryIsChildNode)(::windows::core::Interface::as_raw(self), psearchkey.into_param().abi()).ok()
    }
}
::windows::imp::interface_hierarchy!(IDebugApplicationNode100, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IDebugApplicationNode100 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDebugApplicationNode100 {}
impl ::core::fmt::Debug for IDebugApplicationNode100 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDebugApplicationNode100").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDebugApplicationNode100 {
    type Vtable = IDebugApplicationNode100_Vtbl;
}
impl ::core::clone::Clone for IDebugApplicationNode100 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IDebugApplicationNode100 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x90a7734e_841b_4f77_9384_a2891e76e7e2);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDebugApplicationNode100_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub SetFilterForEventSink: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwcookie: u32, filter: APPLICATION_NODE_EVENT_FILTER) -> ::windows::core::HRESULT,
    pub GetExcludedDocuments: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, filter: APPLICATION_NODE_EVENT_FILTER, pdocuments: *mut TEXT_DOCUMENT_ARRAY) -> ::windows::core::HRESULT,
    pub QueryIsChildNode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, psearchkey: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IDebugApplicationNodeEvents(::windows::core::IUnknown);
impl IDebugApplicationNodeEvents {
    pub unsafe fn onAddChild<P0>(&self, prddpchild: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugApplicationNode>,
    {
        (::windows::core::Interface::vtable(self).onAddChild)(::windows::core::Interface::as_raw(self), prddpchild.into_param().abi()).ok()
    }
    pub unsafe fn onRemoveChild<P0>(&self, prddpchild: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugApplicationNode>,
    {
        (::windows::core::Interface::vtable(self).onRemoveChild)(::windows::core::Interface::as_raw(self), prddpchild.into_param().abi()).ok()
    }
    pub unsafe fn onDetach(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).onDetach)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn onAttach<P0>(&self, prddpparent: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugApplicationNode>,
    {
        (::windows::core::Interface::vtable(self).onAttach)(::windows::core::Interface::as_raw(self), prddpparent.into_param().abi()).ok()
    }
}
::windows::imp::interface_hierarchy!(IDebugApplicationNodeEvents, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IDebugApplicationNodeEvents {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDebugApplicationNodeEvents {}
impl ::core::fmt::Debug for IDebugApplicationNodeEvents {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDebugApplicationNodeEvents").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDebugApplicationNodeEvents {
    type Vtable = IDebugApplicationNodeEvents_Vtbl;
}
impl ::core::clone::Clone for IDebugApplicationNodeEvents {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IDebugApplicationNodeEvents {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x51973c35_cb0c_11d0_b5c9_00a0244a0e7a);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDebugApplicationNodeEvents_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub onAddChild: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, prddpchild: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub onRemoveChild: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, prddpchild: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub onDetach: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub onAttach: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, prddpparent: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IDebugApplicationThread(::windows::core::IUnknown);
impl IDebugApplicationThread {
    pub unsafe fn GetSystemThreadId(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).base__.GetSystemThreadId)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetApplication(&self) -> ::windows::core::Result<IRemoteDebugApplication> {
        let mut result__ = ::windows::core::zeroed::<IRemoteDebugApplication>();
        (::windows::core::Interface::vtable(self).base__.GetApplication)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn EnumStackFrames(&self) -> ::windows::core::Result<IEnumDebugStackFrames> {
        let mut result__ = ::windows::core::zeroed::<IEnumDebugStackFrames>();
        (::windows::core::Interface::vtable(self).base__.EnumStackFrames)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetDescription(&self, pbstrdescription: *mut ::windows::core::BSTR, pbstrstate: *mut ::windows::core::BSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.GetDescription)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pbstrdescription), ::core::mem::transmute(pbstrstate)).ok()
    }
    pub unsafe fn SetNextStatement<P0, P1>(&self, pstackframe: P0, pcodecontext: P1) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugStackFrame>,
        P1: ::windows::core::IntoParam<IDebugCodeContext>,
    {
        (::windows::core::Interface::vtable(self).base__.SetNextStatement)(::windows::core::Interface::as_raw(self), pstackframe.into_param().abi(), pcodecontext.into_param().abi()).ok()
    }
    pub unsafe fn GetState(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).base__.GetState)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn Suspend(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).base__.Suspend)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn Resume(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).base__.Resume)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetSuspendCount(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).base__.GetSuspendCount)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SynchronousCallIntoThread32<P0>(&self, pstcb: P0, dwparam1: u32, dwparam2: u32, dwparam3: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugThreadCall32>,
    {
        (::windows::core::Interface::vtable(self).SynchronousCallIntoThread32)(::windows::core::Interface::as_raw(self), pstcb.into_param().abi(), dwparam1, dwparam2, dwparam3).ok()
    }
    pub unsafe fn QueryIsCurrentThread(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).QueryIsCurrentThread)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn QueryIsDebuggerThread(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).QueryIsDebuggerThread)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn SetDescription<P0>(&self, pstrdescription: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).SetDescription)(::windows::core::Interface::as_raw(self), pstrdescription.into_param().abi()).ok()
    }
    pub unsafe fn SetStateString<P0>(&self, pstrstate: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).SetStateString)(::windows::core::Interface::as_raw(self), pstrstate.into_param().abi()).ok()
    }
}
::windows::imp::interface_hierarchy!(IDebugApplicationThread, ::windows::core::IUnknown, IRemoteDebugApplicationThread);
impl ::core::cmp::PartialEq for IDebugApplicationThread {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDebugApplicationThread {}
impl ::core::fmt::Debug for IDebugApplicationThread {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDebugApplicationThread").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDebugApplicationThread {
    type Vtable = IDebugApplicationThread_Vtbl;
}
impl ::core::clone::Clone for IDebugApplicationThread {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IDebugApplicationThread {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x51973c38_cb0c_11d0_b5c9_00a0244a0e7a);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDebugApplicationThread_Vtbl {
    pub base__: IRemoteDebugApplicationThread_Vtbl,
    pub SynchronousCallIntoThread32: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstcb: *mut ::core::ffi::c_void, dwparam1: u32, dwparam2: u32, dwparam3: u32) -> ::windows::core::HRESULT,
    pub QueryIsCurrentThread: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub QueryIsDebuggerThread: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub SetDescription: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstrdescription: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub SetStateString: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstrstate: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IDebugApplicationThread11032(::windows::core::IUnknown);
impl IDebugApplicationThread11032 {
    pub unsafe fn GetActiveThreadRequestCount(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetActiveThreadRequestCount)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IsSuspendedForBreakPoint(&self) -> ::windows::core::Result<super::super::super::Foundation::BOOL> {
        let mut result__ = ::windows::core::zeroed::<super::super::super::Foundation::BOOL>();
        (::windows::core::Interface::vtable(self).IsSuspendedForBreakPoint)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IsThreadCallable(&self) -> ::windows::core::Result<super::super::super::Foundation::BOOL> {
        let mut result__ = ::windows::core::zeroed::<super::super::super::Foundation::BOOL>();
        (::windows::core::Interface::vtable(self).IsThreadCallable)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn AsynchronousCallIntoThread<P0>(&self, pptc: P0, dwparam1: usize, dwparam2: usize, dwparam3: usize) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugThreadCall32>,
    {
        (::windows::core::Interface::vtable(self).AsynchronousCallIntoThread)(::windows::core::Interface::as_raw(self), pptc.into_param().abi(), dwparam1, dwparam2, dwparam3).ok()
    }
}
::windows::imp::interface_hierarchy!(IDebugApplicationThread11032, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IDebugApplicationThread11032 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDebugApplicationThread11032 {}
impl ::core::fmt::Debug for IDebugApplicationThread11032 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDebugApplicationThread11032").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDebugApplicationThread11032 {
    type Vtable = IDebugApplicationThread11032_Vtbl;
}
impl ::core::clone::Clone for IDebugApplicationThread11032 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IDebugApplicationThread11032 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x2194ac5c_6561_404a_a2e9_f57d72de3702);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDebugApplicationThread11032_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub GetActiveThreadRequestCount: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, puithreadrequests: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub IsSuspendedForBreakPoint: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfissuspended: *mut super::super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    IsSuspendedForBreakPoint: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub IsThreadCallable: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfiscallable: *mut super::super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    IsThreadCallable: usize,
    pub AsynchronousCallIntoThread: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pptc: *mut ::core::ffi::c_void, dwparam1: usize, dwparam2: usize, dwparam3: usize) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IDebugApplicationThread11064(::windows::core::IUnknown);
impl IDebugApplicationThread11064 {
    pub unsafe fn GetActiveThreadRequestCount(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetActiveThreadRequestCount)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IsSuspendedForBreakPoint(&self) -> ::windows::core::Result<super::super::super::Foundation::BOOL> {
        let mut result__ = ::windows::core::zeroed::<super::super::super::Foundation::BOOL>();
        (::windows::core::Interface::vtable(self).IsSuspendedForBreakPoint)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IsThreadCallable(&self) -> ::windows::core::Result<super::super::super::Foundation::BOOL> {
        let mut result__ = ::windows::core::zeroed::<super::super::super::Foundation::BOOL>();
        (::windows::core::Interface::vtable(self).IsThreadCallable)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn AsynchronousCallIntoThread<P0>(&self, pptc: P0, dwparam1: usize, dwparam2: usize, dwparam3: usize) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugThreadCall64>,
    {
        (::windows::core::Interface::vtable(self).AsynchronousCallIntoThread)(::windows::core::Interface::as_raw(self), pptc.into_param().abi(), dwparam1, dwparam2, dwparam3).ok()
    }
}
::windows::imp::interface_hierarchy!(IDebugApplicationThread11064, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IDebugApplicationThread11064 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDebugApplicationThread11064 {}
impl ::core::fmt::Debug for IDebugApplicationThread11064 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDebugApplicationThread11064").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDebugApplicationThread11064 {
    type Vtable = IDebugApplicationThread11064_Vtbl;
}
impl ::core::clone::Clone for IDebugApplicationThread11064 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IDebugApplicationThread11064 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x420aa4cc_efd8_4dac_983b_47127826917d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDebugApplicationThread11064_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub GetActiveThreadRequestCount: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, puithreadrequests: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub IsSuspendedForBreakPoint: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfissuspended: *mut super::super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    IsSuspendedForBreakPoint: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub IsThreadCallable: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfiscallable: *mut super::super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    IsThreadCallable: usize,
    pub AsynchronousCallIntoThread: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pptc: *mut ::core::ffi::c_void, dwparam1: usize, dwparam2: usize, dwparam3: usize) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IDebugApplicationThread64(::windows::core::IUnknown);
impl IDebugApplicationThread64 {
    pub unsafe fn GetSystemThreadId(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).base__.base__.GetSystemThreadId)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetApplication(&self) -> ::windows::core::Result<IRemoteDebugApplication> {
        let mut result__ = ::windows::core::zeroed::<IRemoteDebugApplication>();
        (::windows::core::Interface::vtable(self).base__.base__.GetApplication)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn EnumStackFrames(&self) -> ::windows::core::Result<IEnumDebugStackFrames> {
        let mut result__ = ::windows::core::zeroed::<IEnumDebugStackFrames>();
        (::windows::core::Interface::vtable(self).base__.base__.EnumStackFrames)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetDescription(&self, pbstrdescription: *mut ::windows::core::BSTR, pbstrstate: *mut ::windows::core::BSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.base__.GetDescription)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(pbstrdescription), ::core::mem::transmute(pbstrstate)).ok()
    }
    pub unsafe fn SetNextStatement<P0, P1>(&self, pstackframe: P0, pcodecontext: P1) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugStackFrame>,
        P1: ::windows::core::IntoParam<IDebugCodeContext>,
    {
        (::windows::core::Interface::vtable(self).base__.base__.SetNextStatement)(::windows::core::Interface::as_raw(self), pstackframe.into_param().abi(), pcodecontext.into_param().abi()).ok()
    }
    pub unsafe fn GetState(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).base__.base__.GetState)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn Suspend(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).base__.base__.Suspend)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn Resume(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).base__.base__.Resume)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetSuspendCount(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).base__.base__.GetSuspendCount)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SynchronousCallIntoThread32<P0>(&self, pstcb: P0, dwparam1: u32, dwparam2: u32, dwparam3: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugThreadCall32>,
    {
        (::windows::core::Interface::vtable(self).base__.SynchronousCallIntoThread32)(::windows::core::Interface::as_raw(self), pstcb.into_param().abi(), dwparam1, dwparam2, dwparam3).ok()
    }
    pub unsafe fn QueryIsCurrentThread(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.QueryIsCurrentThread)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn QueryIsDebuggerThread(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base__.QueryIsDebuggerThread)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn SetDescription<P0>(&self, pstrdescription: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).base__.SetDescription)(::windows::core::Interface::as_raw(self), pstrdescription.into_param().abi()).ok()
    }
    pub unsafe fn SetStateString<P0>(&self, pstrstate: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).base__.SetStateString)(::windows::core::Interface::as_raw(self), pstrstate.into_param().abi()).ok()
    }
    pub unsafe fn SynchronousCallIntoThread64<P0>(&self, pstcb: P0, dwparam1: u64, dwparam2: u64, dwparam3: u64) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugThreadCall64>,
    {
        (::windows::core::Interface::vtable(self).SynchronousCallIntoThread64)(::windows::core::Interface::as_raw(self), pstcb.into_param().abi(), dwparam1, dwparam2, dwparam3).ok()
    }
}
::windows::imp::interface_hierarchy!(IDebugApplicationThread64, ::windows::core::IUnknown, IRemoteDebugApplicationThread, IDebugApplicationThread);
impl ::core::cmp::PartialEq for IDebugApplicationThread64 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDebugApplicationThread64 {}
impl ::core::fmt::Debug for IDebugApplicationThread64 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDebugApplicationThread64").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDebugApplicationThread64 {
    type Vtable = IDebugApplicationThread64_Vtbl;
}
impl ::core::clone::Clone for IDebugApplicationThread64 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IDebugApplicationThread64 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x9dac5886_dbad_456d_9dee_5dec39ab3dda);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDebugApplicationThread64_Vtbl {
    pub base__: IDebugApplicationThread_Vtbl,
    pub SynchronousCallIntoThread64: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstcb: *mut ::core::ffi::c_void, dwparam1: u64, dwparam2: u64, dwparam3: u64) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IDebugApplicationThreadEvents110(::windows::core::IUnknown);
impl IDebugApplicationThreadEvents110 {
    pub unsafe fn OnSuspendForBreakPoint(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).OnSuspendForBreakPoint)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn OnResumeFromBreakPoint(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).OnResumeFromBreakPoint)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn OnThreadRequestComplete(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).OnThreadRequestComplete)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn OnBeginThreadRequest(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).OnBeginThreadRequest)(::windows::core::Interface::as_raw(self)).ok()
    }
}
::windows::imp::interface_hierarchy!(IDebugApplicationThreadEvents110, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IDebugApplicationThreadEvents110 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDebugApplicationThreadEvents110 {}
impl ::core::fmt::Debug for IDebugApplicationThreadEvents110 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDebugApplicationThreadEvents110").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDebugApplicationThreadEvents110 {
    type Vtable = IDebugApplicationThreadEvents110_Vtbl;
}
impl ::core::clone::Clone for IDebugApplicationThreadEvents110 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IDebugApplicationThreadEvents110 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x84e5e468_d5da_48a8_83f4_40366429007b);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDebugApplicationThreadEvents110_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub OnSuspendForBreakPoint: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub OnResumeFromBreakPoint: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub OnThreadRequestComplete: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub OnBeginThreadRequest: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IDebugAsyncOperation(::windows::core::IUnknown);
impl IDebugAsyncOperation {
    pub unsafe fn GetSyncDebugOperation(&self) -> ::windows::core::Result<IDebugSyncOperation> {
        let mut result__ = ::windows::core::zeroed::<IDebugSyncOperation>();
        (::windows::core::Interface::vtable(self).GetSyncDebugOperation)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn Start<P0>(&self, padocb: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugAsyncOperationCallBack>,
    {
        (::windows::core::Interface::vtable(self).Start)(::windows::core::Interface::as_raw(self), padocb.into_param().abi()).ok()
    }
    pub unsafe fn Abort(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Abort)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn QueryIsComplete(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).QueryIsComplete)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetResult(&self, phrresult: *mut ::windows::core::HRESULT, ppunkresult: *mut ::core::option::Option<::windows::core::IUnknown>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetResult)(::windows::core::Interface::as_raw(self), phrresult, ::core::mem::transmute(ppunkresult)).ok()
    }
}
::windows::imp::interface_hierarchy!(IDebugAsyncOperation, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IDebugAsyncOperation {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDebugAsyncOperation {}
impl ::core::fmt::Debug for IDebugAsyncOperation {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDebugAsyncOperation").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDebugAsyncOperation {
    type Vtable = IDebugAsyncOperation_Vtbl;
}
impl ::core::clone::Clone for IDebugAsyncOperation {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IDebugAsyncOperation {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x51973c1b_cb0c_11d0_b5c9_00a0244a0e7a);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDebugAsyncOperation_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub GetSyncDebugOperation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppsdo: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub Start: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, padocb: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub Abort: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub QueryIsComplete: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetResult: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, phrresult: *mut ::windows::core::HRESULT, ppunkresult: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IDebugAsyncOperationCallBack(::windows::core::IUnknown);
impl IDebugAsyncOperationCallBack {
    pub unsafe fn onComplete(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).onComplete)(::windows::core::Interface::as_raw(self)).ok()
    }
}
::windows::imp::interface_hierarchy!(IDebugAsyncOperationCallBack, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IDebugAsyncOperationCallBack {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDebugAsyncOperationCallBack {}
impl ::core::fmt::Debug for IDebugAsyncOperationCallBack {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDebugAsyncOperationCallBack").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDebugAsyncOperationCallBack {
    type Vtable = IDebugAsyncOperationCallBack_Vtbl;
}
impl ::core::clone::Clone for IDebugAsyncOperationCallBack {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IDebugAsyncOperationCallBack {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x51973c1c_cb0c_11d0_b5c9_00a0244a0e7a);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDebugAsyncOperationCallBack_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub onComplete: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IDebugBreakpoint(::windows::core::IUnknown);
impl IDebugBreakpoint {
    pub unsafe fn GetId(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetId)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetType(&self, breaktype: *mut u32, proctype: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetType)(::windows::core::Interface::as_raw(self), breaktype, proctype).ok()
    }
    pub unsafe fn GetAdder(&self) -> ::windows::core::Result<IDebugClient> {
        let mut result__ = ::windows::core::zeroed::<IDebugClient>();
        (::windows::core::Interface::vtable(self).GetAdder)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetFlags(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetFlags)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn AddFlags(&self, flags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).AddFlags)(::windows::core::Interface::as_raw(self), flags).ok()
    }
    pub unsafe fn RemoveFlags(&self, flags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).RemoveFlags)(::windows::core::Interface::as_raw(self), flags).ok()
    }
    pub unsafe fn SetFlags(&self, flags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetFlags)(::windows::core::Interface::as_raw(self), flags).ok()
    }
    pub unsafe fn GetOffset(&self) -> ::windows::core::Result<u64> {
        let mut result__ = ::windows::core::zeroed::<u64>();
        (::windows::core::Interface::vtable(self).GetOffset)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetOffset(&self, offset: u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetOffset)(::windows::core::Interface::as_raw(self), offset).ok()
    }
    pub unsafe fn GetDataParameters(&self, size: *mut u32, accesstype: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetDataParameters)(::windows::core::Interface::as_raw(self), size, accesstype).ok()
    }
    pub unsafe fn SetDataParameters(&self, size: u32, accesstype: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetDataParameters)(::windows::core::Interface::as_raw(self), size, accesstype).ok()
    }
    pub unsafe fn GetPassCount(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetPassCount)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetPassCount(&self, count: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetPassCount)(::windows::core::Interface::as_raw(self), count).ok()
    }
    pub unsafe fn GetCurrentPassCount(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetCurrentPassCount)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetMatchThreadId(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetMatchThreadId)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetMatchThreadId(&self, thread: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetMatchThreadId)(::windows::core::Interface::as_raw(self), thread).ok()
    }
    pub unsafe fn GetCommand(&self, buffer: ::core::option::Option<&mut [u8]>, commandsize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetCommand)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(commandsize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetCommand<P0>(&self, command: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).SetCommand)(::windows::core::Interface::as_raw(self), command.into_param().abi()).ok()
    }
    pub unsafe fn GetOffsetExpression(&self, buffer: ::core::option::Option<&mut [u8]>, expressionsize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetOffsetExpression)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(expressionsize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetOffsetExpression<P0>(&self, expression: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).SetOffsetExpression)(::windows::core::Interface::as_raw(self), expression.into_param().abi()).ok()
    }
    pub unsafe fn GetParameters(&self, params: *mut DEBUG_BREAKPOINT_PARAMETERS) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetParameters)(::windows::core::Interface::as_raw(self), params).ok()
    }
}
::windows::imp::interface_hierarchy!(IDebugBreakpoint, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IDebugBreakpoint {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDebugBreakpoint {}
impl ::core::fmt::Debug for IDebugBreakpoint {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDebugBreakpoint").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDebugBreakpoint {
    type Vtable = IDebugBreakpoint_Vtbl;
}
impl ::core::clone::Clone for IDebugBreakpoint {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IDebugBreakpoint {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x5bd9d474_5975_423a_b88b_65a8e7110e65);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDebugBreakpoint_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub GetId: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, id: *mut u32) -> ::windows::core::HRESULT,
    pub GetType: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, breaktype: *mut u32, proctype: *mut u32) -> ::windows::core::HRESULT,
    pub GetAdder: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, adder: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetFlags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flags: *mut u32) -> ::windows::core::HRESULT,
    pub AddFlags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flags: u32) -> ::windows::core::HRESULT,
    pub RemoveFlags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flags: u32) -> ::windows::core::HRESULT,
    pub SetFlags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flags: u32) -> ::windows::core::HRESULT,
    pub GetOffset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, offset: *mut u64) -> ::windows::core::HRESULT,
    pub SetOffset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, offset: u64) -> ::windows::core::HRESULT,
    pub GetDataParameters: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, size: *mut u32, accesstype: *mut u32) -> ::windows::core::HRESULT,
    pub SetDataParameters: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, size: u32, accesstype: u32) -> ::windows::core::HRESULT,
    pub GetPassCount: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, count: *mut u32) -> ::windows::core::HRESULT,
    pub SetPassCount: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, count: u32) -> ::windows::core::HRESULT,
    pub GetCurrentPassCount: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, count: *mut u32) -> ::windows::core::HRESULT,
    pub GetMatchThreadId: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, id: *mut u32) -> ::windows::core::HRESULT,
    pub SetMatchThreadId: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, thread: u32) -> ::windows::core::HRESULT,
    pub GetCommand: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, buffer: ::windows::core::PSTR, buffersize: u32, commandsize: *mut u32) -> ::windows::core::HRESULT,
    pub SetCommand: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, command: ::windows::core::PCSTR) -> ::windows::core::HRESULT,
    pub GetOffsetExpression: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, buffer: ::windows::core::PSTR, buffersize: u32, expressionsize: *mut u32) -> ::windows::core::HRESULT,
    pub SetOffsetExpression: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, expression: ::windows::core::PCSTR) -> ::windows::core::HRESULT,
    pub GetParameters: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, params: *mut DEBUG_BREAKPOINT_PARAMETERS) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IDebugBreakpoint2(::windows::core::IUnknown);
impl IDebugBreakpoint2 {
    pub unsafe fn GetId(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetId)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetType(&self, breaktype: *mut u32, proctype: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetType)(::windows::core::Interface::as_raw(self), breaktype, proctype).ok()
    }
    pub unsafe fn GetAdder(&self) -> ::windows::core::Result<IDebugClient> {
        let mut result__ = ::windows::core::zeroed::<IDebugClient>();
        (::windows::core::Interface::vtable(self).GetAdder)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetFlags(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetFlags)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn AddFlags(&self, flags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).AddFlags)(::windows::core::Interface::as_raw(self), flags).ok()
    }
    pub unsafe fn RemoveFlags(&self, flags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).RemoveFlags)(::windows::core::Interface::as_raw(self), flags).ok()
    }
    pub unsafe fn SetFlags(&self, flags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetFlags)(::windows::core::Interface::as_raw(self), flags).ok()
    }
    pub unsafe fn GetOffset(&self) -> ::windows::core::Result<u64> {
        let mut result__ = ::windows::core::zeroed::<u64>();
        (::windows::core::Interface::vtable(self).GetOffset)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetOffset(&self, offset: u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetOffset)(::windows::core::Interface::as_raw(self), offset).ok()
    }
    pub unsafe fn GetDataParameters(&self, size: *mut u32, accesstype: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetDataParameters)(::windows::core::Interface::as_raw(self), size, accesstype).ok()
    }
    pub unsafe fn SetDataParameters(&self, size: u32, accesstype: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetDataParameters)(::windows::core::Interface::as_raw(self), size, accesstype).ok()
    }
    pub unsafe fn GetPassCount(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetPassCount)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetPassCount(&self, count: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetPassCount)(::windows::core::Interface::as_raw(self), count).ok()
    }
    pub unsafe fn GetCurrentPassCount(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetCurrentPassCount)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetMatchThreadId(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetMatchThreadId)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetMatchThreadId(&self, thread: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetMatchThreadId)(::windows::core::Interface::as_raw(self), thread).ok()
    }
    pub unsafe fn GetCommand(&self, buffer: ::core::option::Option<&mut [u8]>, commandsize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetCommand)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(commandsize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetCommand<P0>(&self, command: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).SetCommand)(::windows::core::Interface::as_raw(self), command.into_param().abi()).ok()
    }
    pub unsafe fn GetOffsetExpression(&self, buffer: ::core::option::Option<&mut [u8]>, expressionsize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetOffsetExpression)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(expressionsize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetOffsetExpression<P0>(&self, expression: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).SetOffsetExpression)(::windows::core::Interface::as_raw(self), expression.into_param().abi()).ok()
    }
    pub unsafe fn GetParameters(&self, params: *mut DEBUG_BREAKPOINT_PARAMETERS) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetParameters)(::windows::core::Interface::as_raw(self), params).ok()
    }
    pub unsafe fn GetCommandWide(&self, buffer: ::core::option::Option<&mut [u16]>, commandsize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetCommandWide)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(commandsize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetCommandWide<P0>(&self, command: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).SetCommandWide)(::windows::core::Interface::as_raw(self), command.into_param().abi()).ok()
    }
    pub unsafe fn GetOffsetExpressionWide(&self, buffer: ::core::option::Option<&mut [u16]>, expressionsize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetOffsetExpressionWide)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(expressionsize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetOffsetExpressionWide<P0>(&self, expression: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).SetOffsetExpressionWide)(::windows::core::Interface::as_raw(self), expression.into_param().abi()).ok()
    }
}
::windows::imp::interface_hierarchy!(IDebugBreakpoint2, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IDebugBreakpoint2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDebugBreakpoint2 {}
impl ::core::fmt::Debug for IDebugBreakpoint2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDebugBreakpoint2").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDebugBreakpoint2 {
    type Vtable = IDebugBreakpoint2_Vtbl;
}
impl ::core::clone::Clone for IDebugBreakpoint2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IDebugBreakpoint2 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1b278d20_79f2_426e_a3f9_c1ddf375d48e);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDebugBreakpoint2_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub GetId: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, id: *mut u32) -> ::windows::core::HRESULT,
    pub GetType: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, breaktype: *mut u32, proctype: *mut u32) -> ::windows::core::HRESULT,
    pub GetAdder: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, adder: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetFlags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flags: *mut u32) -> ::windows::core::HRESULT,
    pub AddFlags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flags: u32) -> ::windows::core::HRESULT,
    pub RemoveFlags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flags: u32) -> ::windows::core::HRESULT,
    pub SetFlags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flags: u32) -> ::windows::core::HRESULT,
    pub GetOffset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, offset: *mut u64) -> ::windows::core::HRESULT,
    pub SetOffset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, offset: u64) -> ::windows::core::HRESULT,
    pub GetDataParameters: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, size: *mut u32, accesstype: *mut u32) -> ::windows::core::HRESULT,
    pub SetDataParameters: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, size: u32, accesstype: u32) -> ::windows::core::HRESULT,
    pub GetPassCount: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, count: *mut u32) -> ::windows::core::HRESULT,
    pub SetPassCount: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, count: u32) -> ::windows::core::HRESULT,
    pub GetCurrentPassCount: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, count: *mut u32) -> ::windows::core::HRESULT,
    pub GetMatchThreadId: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, id: *mut u32) -> ::windows::core::HRESULT,
    pub SetMatchThreadId: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, thread: u32) -> ::windows::core::HRESULT,
    pub GetCommand: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, buffer: ::windows::core::PSTR, buffersize: u32, commandsize: *mut u32) -> ::windows::core::HRESULT,
    pub SetCommand: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, command: ::windows::core::PCSTR) -> ::windows::core::HRESULT,
    pub GetOffsetExpression: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, buffer: ::windows::core::PSTR, buffersize: u32, expressionsize: *mut u32) -> ::windows::core::HRESULT,
    pub SetOffsetExpression: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, expression: ::windows::core::PCSTR) -> ::windows::core::HRESULT,
    pub GetParameters: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, params: *mut DEBUG_BREAKPOINT_PARAMETERS) -> ::windows::core::HRESULT,
    pub GetCommandWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, buffer: ::windows::core::PWSTR, buffersize: u32, commandsize: *mut u32) -> ::windows::core::HRESULT,
    pub SetCommandWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, command: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub GetOffsetExpressionWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, buffer: ::windows::core::PWSTR, buffersize: u32, expressionsize: *mut u32) -> ::windows::core::HRESULT,
    pub SetOffsetExpressionWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, expression: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IDebugBreakpoint3(::windows::core::IUnknown);
impl IDebugBreakpoint3 {
    pub unsafe fn GetId(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetId)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetType(&self, breaktype: *mut u32, proctype: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetType)(::windows::core::Interface::as_raw(self), breaktype, proctype).ok()
    }
    pub unsafe fn GetAdder(&self) -> ::windows::core::Result<IDebugClient> {
        let mut result__ = ::windows::core::zeroed::<IDebugClient>();
        (::windows::core::Interface::vtable(self).GetAdder)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetFlags(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetFlags)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn AddFlags(&self, flags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).AddFlags)(::windows::core::Interface::as_raw(self), flags).ok()
    }
    pub unsafe fn RemoveFlags(&self, flags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).RemoveFlags)(::windows::core::Interface::as_raw(self), flags).ok()
    }
    pub unsafe fn SetFlags(&self, flags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetFlags)(::windows::core::Interface::as_raw(self), flags).ok()
    }
    pub unsafe fn GetOffset(&self) -> ::windows::core::Result<u64> {
        let mut result__ = ::windows::core::zeroed::<u64>();
        (::windows::core::Interface::vtable(self).GetOffset)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetOffset(&self, offset: u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetOffset)(::windows::core::Interface::as_raw(self), offset).ok()
    }
    pub unsafe fn GetDataParameters(&self, size: *mut u32, accesstype: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetDataParameters)(::windows::core::Interface::as_raw(self), size, accesstype).ok()
    }
    pub unsafe fn SetDataParameters(&self, size: u32, accesstype: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetDataParameters)(::windows::core::Interface::as_raw(self), size, accesstype).ok()
    }
    pub unsafe fn GetPassCount(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetPassCount)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetPassCount(&self, count: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetPassCount)(::windows::core::Interface::as_raw(self), count).ok()
    }
    pub unsafe fn GetCurrentPassCount(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetCurrentPassCount)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetMatchThreadId(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetMatchThreadId)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetMatchThreadId(&self, thread: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetMatchThreadId)(::windows::core::Interface::as_raw(self), thread).ok()
    }
    pub unsafe fn GetCommand(&self, buffer: ::core::option::Option<&mut [u8]>, commandsize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetCommand)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(commandsize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetCommand<P0>(&self, command: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).SetCommand)(::windows::core::Interface::as_raw(self), command.into_param().abi()).ok()
    }
    pub unsafe fn GetOffsetExpression(&self, buffer: ::core::option::Option<&mut [u8]>, expressionsize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetOffsetExpression)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(expressionsize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetOffsetExpression<P0>(&self, expression: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).SetOffsetExpression)(::windows::core::Interface::as_raw(self), expression.into_param().abi()).ok()
    }
    pub unsafe fn GetParameters(&self, params: *mut DEBUG_BREAKPOINT_PARAMETERS) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetParameters)(::windows::core::Interface::as_raw(self), params).ok()
    }
    pub unsafe fn GetCommandWide(&self, buffer: ::core::option::Option<&mut [u16]>, commandsize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetCommandWide)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(commandsize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetCommandWide<P0>(&self, command: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).SetCommandWide)(::windows::core::Interface::as_raw(self), command.into_param().abi()).ok()
    }
    pub unsafe fn GetOffsetExpressionWide(&self, buffer: ::core::option::Option<&mut [u16]>, expressionsize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetOffsetExpressionWide)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(expressionsize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetOffsetExpressionWide<P0>(&self, expression: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).SetOffsetExpressionWide)(::windows::core::Interface::as_raw(self), expression.into_param().abi()).ok()
    }
    pub unsafe fn GetGuid(&self) -> ::windows::core::Result<::windows::core::GUID> {
        let mut result__ = ::windows::core::zeroed::<::windows::core::GUID>();
        (::windows::core::Interface::vtable(self).GetGuid)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
}
::windows::imp::interface_hierarchy!(IDebugBreakpoint3, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IDebugBreakpoint3 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDebugBreakpoint3 {}
impl ::core::fmt::Debug for IDebugBreakpoint3 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDebugBreakpoint3").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDebugBreakpoint3 {
    type Vtable = IDebugBreakpoint3_Vtbl;
}
impl ::core::clone::Clone for IDebugBreakpoint3 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IDebugBreakpoint3 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x38f5c249_b448_43bb_9835_579d4ec02249);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDebugBreakpoint3_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub GetId: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, id: *mut u32) -> ::windows::core::HRESULT,
    pub GetType: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, breaktype: *mut u32, proctype: *mut u32) -> ::windows::core::HRESULT,
    pub GetAdder: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, adder: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetFlags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flags: *mut u32) -> ::windows::core::HRESULT,
    pub AddFlags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flags: u32) -> ::windows::core::HRESULT,
    pub RemoveFlags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flags: u32) -> ::windows::core::HRESULT,
    pub SetFlags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flags: u32) -> ::windows::core::HRESULT,
    pub GetOffset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, offset: *mut u64) -> ::windows::core::HRESULT,
    pub SetOffset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, offset: u64) -> ::windows::core::HRESULT,
    pub GetDataParameters: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, size: *mut u32, accesstype: *mut u32) -> ::windows::core::HRESULT,
    pub SetDataParameters: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, size: u32, accesstype: u32) -> ::windows::core::HRESULT,
    pub GetPassCount: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, count: *mut u32) -> ::windows::core::HRESULT,
    pub SetPassCount: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, count: u32) -> ::windows::core::HRESULT,
    pub GetCurrentPassCount: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, count: *mut u32) -> ::windows::core::HRESULT,
    pub GetMatchThreadId: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, id: *mut u32) -> ::windows::core::HRESULT,
    pub SetMatchThreadId: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, thread: u32) -> ::windows::core::HRESULT,
    pub GetCommand: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, buffer: ::windows::core::PSTR, buffersize: u32, commandsize: *mut u32) -> ::windows::core::HRESULT,
    pub SetCommand: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, command: ::windows::core::PCSTR) -> ::windows::core::HRESULT,
    pub GetOffsetExpression: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, buffer: ::windows::core::PSTR, buffersize: u32, expressionsize: *mut u32) -> ::windows::core::HRESULT,
    pub SetOffsetExpression: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, expression: ::windows::core::PCSTR) -> ::windows::core::HRESULT,
    pub GetParameters: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, params: *mut DEBUG_BREAKPOINT_PARAMETERS) -> ::windows::core::HRESULT,
    pub GetCommandWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, buffer: ::windows::core::PWSTR, buffersize: u32, commandsize: *mut u32) -> ::windows::core::HRESULT,
    pub SetCommandWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, command: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub GetOffsetExpressionWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, buffer: ::windows::core::PWSTR, buffersize: u32, expressionsize: *mut u32) -> ::windows::core::HRESULT,
    pub SetOffsetExpressionWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, expression: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub GetGuid: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, guid: *mut ::windows::core::GUID) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IDebugClient(::windows::core::IUnknown);
impl IDebugClient {
    pub unsafe fn AttachKernel<P0>(&self, flags: u32, connectoptions: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).AttachKernel)(::windows::core::Interface::as_raw(self), flags, connectoptions.into_param().abi()).ok()
    }
    pub unsafe fn GetKernelConnectionOptions(&self, buffer: ::core::option::Option<&mut [u8]>, optionssize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetKernelConnectionOptions)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(optionssize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetKernelConnectionOptions<P0>(&self, options: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).SetKernelConnectionOptions)(::windows::core::Interface::as_raw(self), options.into_param().abi()).ok()
    }
    pub unsafe fn StartProcessServer<P0>(&self, flags: u32, options: P0, reserved: ::core::option::Option<*const ::core::ffi::c_void>) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).StartProcessServer)(::windows::core::Interface::as_raw(self), flags, options.into_param().abi(), ::core::mem::transmute(reserved.unwrap_or(::std::ptr::null()))).ok()
    }
    pub unsafe fn ConnectProcessServer<P0>(&self, remoteoptions: P0) -> ::windows::core::Result<u64>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        let mut result__ = ::windows::core::zeroed::<u64>();
        (::windows::core::Interface::vtable(self).ConnectProcessServer)(::windows::core::Interface::as_raw(self), remoteoptions.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn DisconnectProcessServer(&self, server: u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).DisconnectProcessServer)(::windows::core::Interface::as_raw(self), server).ok()
    }
    pub unsafe fn GetRunningProcessSystemIds(&self, server: u64, ids: ::core::option::Option<&mut [u32]>, actualcount: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetRunningProcessSystemIds)(::windows::core::Interface::as_raw(self), server, ::core::mem::transmute(ids.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), ids.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(actualcount.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetRunningProcessSystemIdByExecutableName<P0>(&self, server: u64, exename: P0, flags: u32) -> ::windows::core::Result<u32>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetRunningProcessSystemIdByExecutableName)(::windows::core::Interface::as_raw(self), server, exename.into_param().abi(), flags, &mut result__).from_abi(result__)
    }
    pub unsafe fn GetRunningProcessDescription(&self, server: u64, systemid: u32, flags: u32, exename: ::core::option::Option<&mut [u8]>, actualexenamesize: ::core::option::Option<*mut u32>, description: ::core::option::Option<&mut [u8]>, actualdescriptionsize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetRunningProcessDescription)(
            ::windows::core::Interface::as_raw(self),
            server,
            systemid,
            flags,
            ::core::mem::transmute(exename.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
            exename.as_deref().map_or(0, |slice| slice.len() as _),
            ::core::mem::transmute(actualexenamesize.unwrap_or(::std::ptr::null_mut())),
            ::core::mem::transmute(description.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
            description.as_deref().map_or(0, |slice| slice.len() as _),
            ::core::mem::transmute(actualdescriptionsize.unwrap_or(::std::ptr::null_mut())),
        )
        .ok()
    }
    pub unsafe fn AttachProcess(&self, server: u64, processid: u32, attachflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).AttachProcess)(::windows::core::Interface::as_raw(self), server, processid, attachflags).ok()
    }
    pub unsafe fn CreateProcessA<P0>(&self, server: u64, commandline: P0, createflags: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).CreateProcessA)(::windows::core::Interface::as_raw(self), server, commandline.into_param().abi(), createflags).ok()
    }
    pub unsafe fn CreateProcessAndAttach<P0>(&self, server: u64, commandline: P0, createflags: u32, processid: u32, attachflags: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).CreateProcessAndAttach)(::windows::core::Interface::as_raw(self), server, commandline.into_param().abi(), createflags, processid, attachflags).ok()
    }
    pub unsafe fn GetProcessOptions(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetProcessOptions)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn AddProcessOptions(&self, options: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).AddProcessOptions)(::windows::core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn RemoveProcessOptions(&self, options: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).RemoveProcessOptions)(::windows::core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn SetProcessOptions(&self, options: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetProcessOptions)(::windows::core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn OpenDumpFile<P0>(&self, dumpfile: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).OpenDumpFile)(::windows::core::Interface::as_raw(self), dumpfile.into_param().abi()).ok()
    }
    pub unsafe fn WriteDumpFile<P0>(&self, dumpfile: P0, qualifier: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).WriteDumpFile)(::windows::core::Interface::as_raw(self), dumpfile.into_param().abi(), qualifier).ok()
    }
    pub unsafe fn ConnectSession(&self, flags: u32, historylimit: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).ConnectSession)(::windows::core::Interface::as_raw(self), flags, historylimit).ok()
    }
    pub unsafe fn StartServer<P0>(&self, options: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).StartServer)(::windows::core::Interface::as_raw(self), options.into_param().abi()).ok()
    }
    pub unsafe fn OutputServers<P0>(&self, outputcontrol: u32, machine: P0, flags: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).OutputServers)(::windows::core::Interface::as_raw(self), outputcontrol, machine.into_param().abi(), flags).ok()
    }
    pub unsafe fn TerminateProcesses(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).TerminateProcesses)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn DetachProcesses(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).DetachProcesses)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn EndSession(&self, flags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).EndSession)(::windows::core::Interface::as_raw(self), flags).ok()
    }
    pub unsafe fn GetExitCode(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetExitCode)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn DispatchCallbacks(&self, timeout: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).DispatchCallbacks)(::windows::core::Interface::as_raw(self), timeout).ok()
    }
    pub unsafe fn ExitDispatch<P0>(&self, client: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugClient>,
    {
        (::windows::core::Interface::vtable(self).ExitDispatch)(::windows::core::Interface::as_raw(self), client.into_param().abi()).ok()
    }
    pub unsafe fn CreateClient(&self) -> ::windows::core::Result<IDebugClient> {
        let mut result__ = ::windows::core::zeroed::<IDebugClient>();
        (::windows::core::Interface::vtable(self).CreateClient)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetInputCallbacks(&self) -> ::windows::core::Result<IDebugInputCallbacks> {
        let mut result__ = ::windows::core::zeroed::<IDebugInputCallbacks>();
        (::windows::core::Interface::vtable(self).GetInputCallbacks)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetInputCallbacks<P0>(&self, callbacks: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugInputCallbacks>,
    {
        (::windows::core::Interface::vtable(self).SetInputCallbacks)(::windows::core::Interface::as_raw(self), callbacks.into_param().abi()).ok()
    }
    pub unsafe fn GetOutputCallbacks(&self) -> ::windows::core::Result<IDebugOutputCallbacks> {
        let mut result__ = ::windows::core::zeroed::<IDebugOutputCallbacks>();
        (::windows::core::Interface::vtable(self).GetOutputCallbacks)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetOutputCallbacks<P0>(&self, callbacks: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugOutputCallbacks>,
    {
        (::windows::core::Interface::vtable(self).SetOutputCallbacks)(::windows::core::Interface::as_raw(self), callbacks.into_param().abi()).ok()
    }
    pub unsafe fn GetOutputMask(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetOutputMask)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetOutputMask(&self, mask: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetOutputMask)(::windows::core::Interface::as_raw(self), mask).ok()
    }
    pub unsafe fn GetOtherOutputMask<P0>(&self, client: P0) -> ::windows::core::Result<u32>
    where
        P0: ::windows::core::IntoParam<IDebugClient>,
    {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetOtherOutputMask)(::windows::core::Interface::as_raw(self), client.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetOtherOutputMask<P0>(&self, client: P0, mask: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugClient>,
    {
        (::windows::core::Interface::vtable(self).SetOtherOutputMask)(::windows::core::Interface::as_raw(self), client.into_param().abi(), mask).ok()
    }
    pub unsafe fn GetOutputWidth(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetOutputWidth)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetOutputWidth(&self, columns: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetOutputWidth)(::windows::core::Interface::as_raw(self), columns).ok()
    }
    pub unsafe fn GetOutputLinePrefix(&self, buffer: ::core::option::Option<&mut [u8]>, prefixsize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetOutputLinePrefix)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(prefixsize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetOutputLinePrefix<P0>(&self, prefix: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).SetOutputLinePrefix)(::windows::core::Interface::as_raw(self), prefix.into_param().abi()).ok()
    }
    pub unsafe fn GetIdentity(&self, buffer: ::core::option::Option<&mut [u8]>, identitysize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetIdentity)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(identitysize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn OutputIdentity<P0>(&self, outputcontrol: u32, flags: u32, format: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).OutputIdentity)(::windows::core::Interface::as_raw(self), outputcontrol, flags, format.into_param().abi()).ok()
    }
    pub unsafe fn GetEventCallbacks(&self) -> ::windows::core::Result<IDebugEventCallbacks> {
        let mut result__ = ::windows::core::zeroed::<IDebugEventCallbacks>();
        (::windows::core::Interface::vtable(self).GetEventCallbacks)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetEventCallbacks<P0>(&self, callbacks: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugEventCallbacks>,
    {
        (::windows::core::Interface::vtable(self).SetEventCallbacks)(::windows::core::Interface::as_raw(self), callbacks.into_param().abi()).ok()
    }
    pub unsafe fn FlushCallbacks(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).FlushCallbacks)(::windows::core::Interface::as_raw(self)).ok()
    }
}
::windows::imp::interface_hierarchy!(IDebugClient, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IDebugClient {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDebugClient {}
impl ::core::fmt::Debug for IDebugClient {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDebugClient").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDebugClient {
    type Vtable = IDebugClient_Vtbl;
}
impl ::core::clone::Clone for IDebugClient {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IDebugClient {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x27fe5639_8407_4f47_8364_ee118fb08ac8);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDebugClient_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub AttachKernel: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flags: u32, connectoptions: ::windows::core::PCSTR) -> ::windows::core::HRESULT,
    pub GetKernelConnectionOptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, buffer: ::windows::core::PSTR, buffersize: u32, optionssize: *mut u32) -> ::windows::core::HRESULT,
    pub SetKernelConnectionOptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, options: ::windows::core::PCSTR) -> ::windows::core::HRESULT,
    pub StartProcessServer: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flags: u32, options: ::windows::core::PCSTR, reserved: *const ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub ConnectProcessServer: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, remoteoptions: ::windows::core::PCSTR, server: *mut u64) -> ::windows::core::HRESULT,
    pub DisconnectProcessServer: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64) -> ::windows::core::HRESULT,
    pub GetRunningProcessSystemIds: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, ids: *mut u32, count: u32, actualcount: *mut u32) -> ::windows::core::HRESULT,
    pub GetRunningProcessSystemIdByExecutableName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, exename: ::windows::core::PCSTR, flags: u32, id: *mut u32) -> ::windows::core::HRESULT,
    pub GetRunningProcessDescription: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, systemid: u32, flags: u32, exename: ::windows::core::PSTR, exenamesize: u32, actualexenamesize: *mut u32, description: ::windows::core::PSTR, descriptionsize: u32, actualdescriptionsize: *mut u32) -> ::windows::core::HRESULT,
    pub AttachProcess: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, processid: u32, attachflags: u32) -> ::windows::core::HRESULT,
    pub CreateProcessA: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, commandline: ::windows::core::PCSTR, createflags: u32) -> ::windows::core::HRESULT,
    pub CreateProcessAndAttach: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, commandline: ::windows::core::PCSTR, createflags: u32, processid: u32, attachflags: u32) -> ::windows::core::HRESULT,
    pub GetProcessOptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, options: *mut u32) -> ::windows::core::HRESULT,
    pub AddProcessOptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, options: u32) -> ::windows::core::HRESULT,
    pub RemoveProcessOptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, options: u32) -> ::windows::core::HRESULT,
    pub SetProcessOptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, options: u32) -> ::windows::core::HRESULT,
    pub OpenDumpFile: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dumpfile: ::windows::core::PCSTR) -> ::windows::core::HRESULT,
    pub WriteDumpFile: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dumpfile: ::windows::core::PCSTR, qualifier: u32) -> ::windows::core::HRESULT,
    pub ConnectSession: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flags: u32, historylimit: u32) -> ::windows::core::HRESULT,
    pub StartServer: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, options: ::windows::core::PCSTR) -> ::windows::core::HRESULT,
    pub OutputServers: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, outputcontrol: u32, machine: ::windows::core::PCSTR, flags: u32) -> ::windows::core::HRESULT,
    pub TerminateProcesses: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub DetachProcesses: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub EndSession: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flags: u32) -> ::windows::core::HRESULT,
    pub GetExitCode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, code: *mut u32) -> ::windows::core::HRESULT,
    pub DispatchCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, timeout: u32) -> ::windows::core::HRESULT,
    pub ExitDispatch: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, client: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub CreateClient: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, client: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetInputCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, callbacks: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub SetInputCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, callbacks: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetOutputCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, callbacks: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub SetOutputCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, callbacks: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetOutputMask: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, mask: *mut u32) -> ::windows::core::HRESULT,
    pub SetOutputMask: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, mask: u32) -> ::windows::core::HRESULT,
    pub GetOtherOutputMask: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, client: *mut ::core::ffi::c_void, mask: *mut u32) -> ::windows::core::HRESULT,
    pub SetOtherOutputMask: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, client: *mut ::core::ffi::c_void, mask: u32) -> ::windows::core::HRESULT,
    pub GetOutputWidth: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, columns: *mut u32) -> ::windows::core::HRESULT,
    pub SetOutputWidth: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, columns: u32) -> ::windows::core::HRESULT,
    pub GetOutputLinePrefix: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, buffer: ::windows::core::PSTR, buffersize: u32, prefixsize: *mut u32) -> ::windows::core::HRESULT,
    pub SetOutputLinePrefix: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, prefix: ::windows::core::PCSTR) -> ::windows::core::HRESULT,
    pub GetIdentity: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, buffer: ::windows::core::PSTR, buffersize: u32, identitysize: *mut u32) -> ::windows::core::HRESULT,
    pub OutputIdentity: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, outputcontrol: u32, flags: u32, format: ::windows::core::PCSTR) -> ::windows::core::HRESULT,
    pub GetEventCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, callbacks: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub SetEventCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, callbacks: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub FlushCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IDebugClient2(::windows::core::IUnknown);
impl IDebugClient2 {
    pub unsafe fn AttachKernel<P0>(&self, flags: u32, connectoptions: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).AttachKernel)(::windows::core::Interface::as_raw(self), flags, connectoptions.into_param().abi()).ok()
    }
    pub unsafe fn GetKernelConnectionOptions(&self, buffer: ::core::option::Option<&mut [u8]>, optionssize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetKernelConnectionOptions)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(optionssize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetKernelConnectionOptions<P0>(&self, options: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).SetKernelConnectionOptions)(::windows::core::Interface::as_raw(self), options.into_param().abi()).ok()
    }
    pub unsafe fn StartProcessServer<P0>(&self, flags: u32, options: P0, reserved: ::core::option::Option<*const ::core::ffi::c_void>) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).StartProcessServer)(::windows::core::Interface::as_raw(self), flags, options.into_param().abi(), ::core::mem::transmute(reserved.unwrap_or(::std::ptr::null()))).ok()
    }
    pub unsafe fn ConnectProcessServer<P0>(&self, remoteoptions: P0) -> ::windows::core::Result<u64>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        let mut result__ = ::windows::core::zeroed::<u64>();
        (::windows::core::Interface::vtable(self).ConnectProcessServer)(::windows::core::Interface::as_raw(self), remoteoptions.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn DisconnectProcessServer(&self, server: u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).DisconnectProcessServer)(::windows::core::Interface::as_raw(self), server).ok()
    }
    pub unsafe fn GetRunningProcessSystemIds(&self, server: u64, ids: ::core::option::Option<&mut [u32]>, actualcount: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetRunningProcessSystemIds)(::windows::core::Interface::as_raw(self), server, ::core::mem::transmute(ids.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), ids.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(actualcount.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetRunningProcessSystemIdByExecutableName<P0>(&self, server: u64, exename: P0, flags: u32) -> ::windows::core::Result<u32>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetRunningProcessSystemIdByExecutableName)(::windows::core::Interface::as_raw(self), server, exename.into_param().abi(), flags, &mut result__).from_abi(result__)
    }
    pub unsafe fn GetRunningProcessDescription(&self, server: u64, systemid: u32, flags: u32, exename: ::core::option::Option<&mut [u8]>, actualexenamesize: ::core::option::Option<*mut u32>, description: ::core::option::Option<&mut [u8]>, actualdescriptionsize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetRunningProcessDescription)(
            ::windows::core::Interface::as_raw(self),
            server,
            systemid,
            flags,
            ::core::mem::transmute(exename.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
            exename.as_deref().map_or(0, |slice| slice.len() as _),
            ::core::mem::transmute(actualexenamesize.unwrap_or(::std::ptr::null_mut())),
            ::core::mem::transmute(description.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
            description.as_deref().map_or(0, |slice| slice.len() as _),
            ::core::mem::transmute(actualdescriptionsize.unwrap_or(::std::ptr::null_mut())),
        )
        .ok()
    }
    pub unsafe fn AttachProcess(&self, server: u64, processid: u32, attachflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).AttachProcess)(::windows::core::Interface::as_raw(self), server, processid, attachflags).ok()
    }
    pub unsafe fn CreateProcessA<P0>(&self, server: u64, commandline: P0, createflags: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).CreateProcessA)(::windows::core::Interface::as_raw(self), server, commandline.into_param().abi(), createflags).ok()
    }
    pub unsafe fn CreateProcessAndAttach<P0>(&self, server: u64, commandline: P0, createflags: u32, processid: u32, attachflags: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).CreateProcessAndAttach)(::windows::core::Interface::as_raw(self), server, commandline.into_param().abi(), createflags, processid, attachflags).ok()
    }
    pub unsafe fn GetProcessOptions(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetProcessOptions)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn AddProcessOptions(&self, options: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).AddProcessOptions)(::windows::core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn RemoveProcessOptions(&self, options: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).RemoveProcessOptions)(::windows::core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn SetProcessOptions(&self, options: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetProcessOptions)(::windows::core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn OpenDumpFile<P0>(&self, dumpfile: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).OpenDumpFile)(::windows::core::Interface::as_raw(self), dumpfile.into_param().abi()).ok()
    }
    pub unsafe fn WriteDumpFile<P0>(&self, dumpfile: P0, qualifier: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).WriteDumpFile)(::windows::core::Interface::as_raw(self), dumpfile.into_param().abi(), qualifier).ok()
    }
    pub unsafe fn ConnectSession(&self, flags: u32, historylimit: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).ConnectSession)(::windows::core::Interface::as_raw(self), flags, historylimit).ok()
    }
    pub unsafe fn StartServer<P0>(&self, options: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).StartServer)(::windows::core::Interface::as_raw(self), options.into_param().abi()).ok()
    }
    pub unsafe fn OutputServers<P0>(&self, outputcontrol: u32, machine: P0, flags: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).OutputServers)(::windows::core::Interface::as_raw(self), outputcontrol, machine.into_param().abi(), flags).ok()
    }
    pub unsafe fn TerminateProcesses(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).TerminateProcesses)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn DetachProcesses(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).DetachProcesses)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn EndSession(&self, flags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).EndSession)(::windows::core::Interface::as_raw(self), flags).ok()
    }
    pub unsafe fn GetExitCode(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetExitCode)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn DispatchCallbacks(&self, timeout: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).DispatchCallbacks)(::windows::core::Interface::as_raw(self), timeout).ok()
    }
    pub unsafe fn ExitDispatch<P0>(&self, client: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugClient>,
    {
        (::windows::core::Interface::vtable(self).ExitDispatch)(::windows::core::Interface::as_raw(self), client.into_param().abi()).ok()
    }
    pub unsafe fn CreateClient(&self) -> ::windows::core::Result<IDebugClient> {
        let mut result__ = ::windows::core::zeroed::<IDebugClient>();
        (::windows::core::Interface::vtable(self).CreateClient)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetInputCallbacks(&self) -> ::windows::core::Result<IDebugInputCallbacks> {
        let mut result__ = ::windows::core::zeroed::<IDebugInputCallbacks>();
        (::windows::core::Interface::vtable(self).GetInputCallbacks)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetInputCallbacks<P0>(&self, callbacks: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugInputCallbacks>,
    {
        (::windows::core::Interface::vtable(self).SetInputCallbacks)(::windows::core::Interface::as_raw(self), callbacks.into_param().abi()).ok()
    }
    pub unsafe fn GetOutputCallbacks(&self) -> ::windows::core::Result<IDebugOutputCallbacks> {
        let mut result__ = ::windows::core::zeroed::<IDebugOutputCallbacks>();
        (::windows::core::Interface::vtable(self).GetOutputCallbacks)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetOutputCallbacks<P0>(&self, callbacks: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugOutputCallbacks>,
    {
        (::windows::core::Interface::vtable(self).SetOutputCallbacks)(::windows::core::Interface::as_raw(self), callbacks.into_param().abi()).ok()
    }
    pub unsafe fn GetOutputMask(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetOutputMask)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetOutputMask(&self, mask: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetOutputMask)(::windows::core::Interface::as_raw(self), mask).ok()
    }
    pub unsafe fn GetOtherOutputMask<P0>(&self, client: P0) -> ::windows::core::Result<u32>
    where
        P0: ::windows::core::IntoParam<IDebugClient>,
    {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetOtherOutputMask)(::windows::core::Interface::as_raw(self), client.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetOtherOutputMask<P0>(&self, client: P0, mask: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugClient>,
    {
        (::windows::core::Interface::vtable(self).SetOtherOutputMask)(::windows::core::Interface::as_raw(self), client.into_param().abi(), mask).ok()
    }
    pub unsafe fn GetOutputWidth(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetOutputWidth)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetOutputWidth(&self, columns: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetOutputWidth)(::windows::core::Interface::as_raw(self), columns).ok()
    }
    pub unsafe fn GetOutputLinePrefix(&self, buffer: ::core::option::Option<&mut [u8]>, prefixsize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetOutputLinePrefix)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(prefixsize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetOutputLinePrefix<P0>(&self, prefix: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).SetOutputLinePrefix)(::windows::core::Interface::as_raw(self), prefix.into_param().abi()).ok()
    }
    pub unsafe fn GetIdentity(&self, buffer: ::core::option::Option<&mut [u8]>, identitysize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetIdentity)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(identitysize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn OutputIdentity<P0>(&self, outputcontrol: u32, flags: u32, format: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).OutputIdentity)(::windows::core::Interface::as_raw(self), outputcontrol, flags, format.into_param().abi()).ok()
    }
    pub unsafe fn GetEventCallbacks(&self) -> ::windows::core::Result<IDebugEventCallbacks> {
        let mut result__ = ::windows::core::zeroed::<IDebugEventCallbacks>();
        (::windows::core::Interface::vtable(self).GetEventCallbacks)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetEventCallbacks<P0>(&self, callbacks: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugEventCallbacks>,
    {
        (::windows::core::Interface::vtable(self).SetEventCallbacks)(::windows::core::Interface::as_raw(self), callbacks.into_param().abi()).ok()
    }
    pub unsafe fn FlushCallbacks(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).FlushCallbacks)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn WriteDumpFile2<P0, P1>(&self, dumpfile: P0, qualifier: u32, formatflags: u32, comment: P1) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
        P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).WriteDumpFile2)(::windows::core::Interface::as_raw(self), dumpfile.into_param().abi(), qualifier, formatflags, comment.into_param().abi()).ok()
    }
    pub unsafe fn AddDumpInformationFile<P0>(&self, infofile: P0, r#type: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).AddDumpInformationFile)(::windows::core::Interface::as_raw(self), infofile.into_param().abi(), r#type).ok()
    }
    pub unsafe fn EndProcessServer(&self, server: u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).EndProcessServer)(::windows::core::Interface::as_raw(self), server).ok()
    }
    pub unsafe fn WaitForProcessServerEnd(&self, timeout: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).WaitForProcessServerEnd)(::windows::core::Interface::as_raw(self), timeout).ok()
    }
    pub unsafe fn IsKernelDebuggerEnabled(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).IsKernelDebuggerEnabled)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn TerminateCurrentProcess(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).TerminateCurrentProcess)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn DetachCurrentProcess(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).DetachCurrentProcess)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn AbandonCurrentProcess(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).AbandonCurrentProcess)(::windows::core::Interface::as_raw(self)).ok()
    }
}
::windows::imp::interface_hierarchy!(IDebugClient2, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IDebugClient2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDebugClient2 {}
impl ::core::fmt::Debug for IDebugClient2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDebugClient2").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDebugClient2 {
    type Vtable = IDebugClient2_Vtbl;
}
impl ::core::clone::Clone for IDebugClient2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IDebugClient2 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xedbed635_372e_4dab_bbfe_ed0d2f63be81);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDebugClient2_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub AttachKernel: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flags: u32, connectoptions: ::windows::core::PCSTR) -> ::windows::core::HRESULT,
    pub GetKernelConnectionOptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, buffer: ::windows::core::PSTR, buffersize: u32, optionssize: *mut u32) -> ::windows::core::HRESULT,
    pub SetKernelConnectionOptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, options: ::windows::core::PCSTR) -> ::windows::core::HRESULT,
    pub StartProcessServer: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flags: u32, options: ::windows::core::PCSTR, reserved: *const ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub ConnectProcessServer: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, remoteoptions: ::windows::core::PCSTR, server: *mut u64) -> ::windows::core::HRESULT,
    pub DisconnectProcessServer: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64) -> ::windows::core::HRESULT,
    pub GetRunningProcessSystemIds: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, ids: *mut u32, count: u32, actualcount: *mut u32) -> ::windows::core::HRESULT,
    pub GetRunningProcessSystemIdByExecutableName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, exename: ::windows::core::PCSTR, flags: u32, id: *mut u32) -> ::windows::core::HRESULT,
    pub GetRunningProcessDescription: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, systemid: u32, flags: u32, exename: ::windows::core::PSTR, exenamesize: u32, actualexenamesize: *mut u32, description: ::windows::core::PSTR, descriptionsize: u32, actualdescriptionsize: *mut u32) -> ::windows::core::HRESULT,
    pub AttachProcess: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, processid: u32, attachflags: u32) -> ::windows::core::HRESULT,
    pub CreateProcessA: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, commandline: ::windows::core::PCSTR, createflags: u32) -> ::windows::core::HRESULT,
    pub CreateProcessAndAttach: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, commandline: ::windows::core::PCSTR, createflags: u32, processid: u32, attachflags: u32) -> ::windows::core::HRESULT,
    pub GetProcessOptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, options: *mut u32) -> ::windows::core::HRESULT,
    pub AddProcessOptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, options: u32) -> ::windows::core::HRESULT,
    pub RemoveProcessOptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, options: u32) -> ::windows::core::HRESULT,
    pub SetProcessOptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, options: u32) -> ::windows::core::HRESULT,
    pub OpenDumpFile: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dumpfile: ::windows::core::PCSTR) -> ::windows::core::HRESULT,
    pub WriteDumpFile: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dumpfile: ::windows::core::PCSTR, qualifier: u32) -> ::windows::core::HRESULT,
    pub ConnectSession: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flags: u32, historylimit: u32) -> ::windows::core::HRESULT,
    pub StartServer: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, options: ::windows::core::PCSTR) -> ::windows::core::HRESULT,
    pub OutputServers: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, outputcontrol: u32, machine: ::windows::core::PCSTR, flags: u32) -> ::windows::core::HRESULT,
    pub TerminateProcesses: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub DetachProcesses: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub EndSession: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flags: u32) -> ::windows::core::HRESULT,
    pub GetExitCode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, code: *mut u32) -> ::windows::core::HRESULT,
    pub DispatchCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, timeout: u32) -> ::windows::core::HRESULT,
    pub ExitDispatch: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, client: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub CreateClient: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, client: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetInputCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, callbacks: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub SetInputCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, callbacks: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetOutputCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, callbacks: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub SetOutputCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, callbacks: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetOutputMask: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, mask: *mut u32) -> ::windows::core::HRESULT,
    pub SetOutputMask: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, mask: u32) -> ::windows::core::HRESULT,
    pub GetOtherOutputMask: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, client: *mut ::core::ffi::c_void, mask: *mut u32) -> ::windows::core::HRESULT,
    pub SetOtherOutputMask: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, client: *mut ::core::ffi::c_void, mask: u32) -> ::windows::core::HRESULT,
    pub GetOutputWidth: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, columns: *mut u32) -> ::windows::core::HRESULT,
    pub SetOutputWidth: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, columns: u32) -> ::windows::core::HRESULT,
    pub GetOutputLinePrefix: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, buffer: ::windows::core::PSTR, buffersize: u32, prefixsize: *mut u32) -> ::windows::core::HRESULT,
    pub SetOutputLinePrefix: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, prefix: ::windows::core::PCSTR) -> ::windows::core::HRESULT,
    pub GetIdentity: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, buffer: ::windows::core::PSTR, buffersize: u32, identitysize: *mut u32) -> ::windows::core::HRESULT,
    pub OutputIdentity: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, outputcontrol: u32, flags: u32, format: ::windows::core::PCSTR) -> ::windows::core::HRESULT,
    pub GetEventCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, callbacks: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub SetEventCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, callbacks: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub FlushCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub WriteDumpFile2: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dumpfile: ::windows::core::PCSTR, qualifier: u32, formatflags: u32, comment: ::windows::core::PCSTR) -> ::windows::core::HRESULT,
    pub AddDumpInformationFile: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, infofile: ::windows::core::PCSTR, r#type: u32) -> ::windows::core::HRESULT,
    pub EndProcessServer: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64) -> ::windows::core::HRESULT,
    pub WaitForProcessServerEnd: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, timeout: u32) -> ::windows::core::HRESULT,
    pub IsKernelDebuggerEnabled: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub TerminateCurrentProcess: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub DetachCurrentProcess: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub AbandonCurrentProcess: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IDebugClient3(::windows::core::IUnknown);
impl IDebugClient3 {
    pub unsafe fn AttachKernel<P0>(&self, flags: u32, connectoptions: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).AttachKernel)(::windows::core::Interface::as_raw(self), flags, connectoptions.into_param().abi()).ok()
    }
    pub unsafe fn GetKernelConnectionOptions(&self, buffer: ::core::option::Option<&mut [u8]>, optionssize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetKernelConnectionOptions)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(optionssize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetKernelConnectionOptions<P0>(&self, options: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).SetKernelConnectionOptions)(::windows::core::Interface::as_raw(self), options.into_param().abi()).ok()
    }
    pub unsafe fn StartProcessServer<P0>(&self, flags: u32, options: P0, reserved: ::core::option::Option<*const ::core::ffi::c_void>) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).StartProcessServer)(::windows::core::Interface::as_raw(self), flags, options.into_param().abi(), ::core::mem::transmute(reserved.unwrap_or(::std::ptr::null()))).ok()
    }
    pub unsafe fn ConnectProcessServer<P0>(&self, remoteoptions: P0) -> ::windows::core::Result<u64>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        let mut result__ = ::windows::core::zeroed::<u64>();
        (::windows::core::Interface::vtable(self).ConnectProcessServer)(::windows::core::Interface::as_raw(self), remoteoptions.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn DisconnectProcessServer(&self, server: u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).DisconnectProcessServer)(::windows::core::Interface::as_raw(self), server).ok()
    }
    pub unsafe fn GetRunningProcessSystemIds(&self, server: u64, ids: ::core::option::Option<&mut [u32]>, actualcount: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetRunningProcessSystemIds)(::windows::core::Interface::as_raw(self), server, ::core::mem::transmute(ids.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), ids.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(actualcount.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetRunningProcessSystemIdByExecutableName<P0>(&self, server: u64, exename: P0, flags: u32) -> ::windows::core::Result<u32>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetRunningProcessSystemIdByExecutableName)(::windows::core::Interface::as_raw(self), server, exename.into_param().abi(), flags, &mut result__).from_abi(result__)
    }
    pub unsafe fn GetRunningProcessDescription(&self, server: u64, systemid: u32, flags: u32, exename: ::core::option::Option<&mut [u8]>, actualexenamesize: ::core::option::Option<*mut u32>, description: ::core::option::Option<&mut [u8]>, actualdescriptionsize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetRunningProcessDescription)(
            ::windows::core::Interface::as_raw(self),
            server,
            systemid,
            flags,
            ::core::mem::transmute(exename.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
            exename.as_deref().map_or(0, |slice| slice.len() as _),
            ::core::mem::transmute(actualexenamesize.unwrap_or(::std::ptr::null_mut())),
            ::core::mem::transmute(description.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
            description.as_deref().map_or(0, |slice| slice.len() as _),
            ::core::mem::transmute(actualdescriptionsize.unwrap_or(::std::ptr::null_mut())),
        )
        .ok()
    }
    pub unsafe fn AttachProcess(&self, server: u64, processid: u32, attachflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).AttachProcess)(::windows::core::Interface::as_raw(self), server, processid, attachflags).ok()
    }
    pub unsafe fn CreateProcessA<P0>(&self, server: u64, commandline: P0, createflags: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).CreateProcessA)(::windows::core::Interface::as_raw(self), server, commandline.into_param().abi(), createflags).ok()
    }
    pub unsafe fn CreateProcessAndAttach<P0>(&self, server: u64, commandline: P0, createflags: u32, processid: u32, attachflags: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).CreateProcessAndAttach)(::windows::core::Interface::as_raw(self), server, commandline.into_param().abi(), createflags, processid, attachflags).ok()
    }
    pub unsafe fn GetProcessOptions(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetProcessOptions)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn AddProcessOptions(&self, options: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).AddProcessOptions)(::windows::core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn RemoveProcessOptions(&self, options: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).RemoveProcessOptions)(::windows::core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn SetProcessOptions(&self, options: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetProcessOptions)(::windows::core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn OpenDumpFile<P0>(&self, dumpfile: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).OpenDumpFile)(::windows::core::Interface::as_raw(self), dumpfile.into_param().abi()).ok()
    }
    pub unsafe fn WriteDumpFile<P0>(&self, dumpfile: P0, qualifier: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).WriteDumpFile)(::windows::core::Interface::as_raw(self), dumpfile.into_param().abi(), qualifier).ok()
    }
    pub unsafe fn ConnectSession(&self, flags: u32, historylimit: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).ConnectSession)(::windows::core::Interface::as_raw(self), flags, historylimit).ok()
    }
    pub unsafe fn StartServer<P0>(&self, options: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).StartServer)(::windows::core::Interface::as_raw(self), options.into_param().abi()).ok()
    }
    pub unsafe fn OutputServers<P0>(&self, outputcontrol: u32, machine: P0, flags: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).OutputServers)(::windows::core::Interface::as_raw(self), outputcontrol, machine.into_param().abi(), flags).ok()
    }
    pub unsafe fn TerminateProcesses(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).TerminateProcesses)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn DetachProcesses(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).DetachProcesses)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn EndSession(&self, flags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).EndSession)(::windows::core::Interface::as_raw(self), flags).ok()
    }
    pub unsafe fn GetExitCode(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetExitCode)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn DispatchCallbacks(&self, timeout: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).DispatchCallbacks)(::windows::core::Interface::as_raw(self), timeout).ok()
    }
    pub unsafe fn ExitDispatch<P0>(&self, client: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugClient>,
    {
        (::windows::core::Interface::vtable(self).ExitDispatch)(::windows::core::Interface::as_raw(self), client.into_param().abi()).ok()
    }
    pub unsafe fn CreateClient(&self) -> ::windows::core::Result<IDebugClient> {
        let mut result__ = ::windows::core::zeroed::<IDebugClient>();
        (::windows::core::Interface::vtable(self).CreateClient)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetInputCallbacks(&self) -> ::windows::core::Result<IDebugInputCallbacks> {
        let mut result__ = ::windows::core::zeroed::<IDebugInputCallbacks>();
        (::windows::core::Interface::vtable(self).GetInputCallbacks)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetInputCallbacks<P0>(&self, callbacks: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugInputCallbacks>,
    {
        (::windows::core::Interface::vtable(self).SetInputCallbacks)(::windows::core::Interface::as_raw(self), callbacks.into_param().abi()).ok()
    }
    pub unsafe fn GetOutputCallbacks(&self) -> ::windows::core::Result<IDebugOutputCallbacks> {
        let mut result__ = ::windows::core::zeroed::<IDebugOutputCallbacks>();
        (::windows::core::Interface::vtable(self).GetOutputCallbacks)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetOutputCallbacks<P0>(&self, callbacks: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugOutputCallbacks>,
    {
        (::windows::core::Interface::vtable(self).SetOutputCallbacks)(::windows::core::Interface::as_raw(self), callbacks.into_param().abi()).ok()
    }
    pub unsafe fn GetOutputMask(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetOutputMask)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetOutputMask(&self, mask: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetOutputMask)(::windows::core::Interface::as_raw(self), mask).ok()
    }
    pub unsafe fn GetOtherOutputMask<P0>(&self, client: P0) -> ::windows::core::Result<u32>
    where
        P0: ::windows::core::IntoParam<IDebugClient>,
    {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetOtherOutputMask)(::windows::core::Interface::as_raw(self), client.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetOtherOutputMask<P0>(&self, client: P0, mask: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugClient>,
    {
        (::windows::core::Interface::vtable(self).SetOtherOutputMask)(::windows::core::Interface::as_raw(self), client.into_param().abi(), mask).ok()
    }
    pub unsafe fn GetOutputWidth(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetOutputWidth)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetOutputWidth(&self, columns: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetOutputWidth)(::windows::core::Interface::as_raw(self), columns).ok()
    }
    pub unsafe fn GetOutputLinePrefix(&self, buffer: ::core::option::Option<&mut [u8]>, prefixsize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetOutputLinePrefix)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(prefixsize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetOutputLinePrefix<P0>(&self, prefix: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).SetOutputLinePrefix)(::windows::core::Interface::as_raw(self), prefix.into_param().abi()).ok()
    }
    pub unsafe fn GetIdentity(&self, buffer: ::core::option::Option<&mut [u8]>, identitysize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetIdentity)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(identitysize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn OutputIdentity<P0>(&self, outputcontrol: u32, flags: u32, format: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).OutputIdentity)(::windows::core::Interface::as_raw(self), outputcontrol, flags, format.into_param().abi()).ok()
    }
    pub unsafe fn GetEventCallbacks(&self) -> ::windows::core::Result<IDebugEventCallbacks> {
        let mut result__ = ::windows::core::zeroed::<IDebugEventCallbacks>();
        (::windows::core::Interface::vtable(self).GetEventCallbacks)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetEventCallbacks<P0>(&self, callbacks: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugEventCallbacks>,
    {
        (::windows::core::Interface::vtable(self).SetEventCallbacks)(::windows::core::Interface::as_raw(self), callbacks.into_param().abi()).ok()
    }
    pub unsafe fn FlushCallbacks(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).FlushCallbacks)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn WriteDumpFile2<P0, P1>(&self, dumpfile: P0, qualifier: u32, formatflags: u32, comment: P1) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
        P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).WriteDumpFile2)(::windows::core::Interface::as_raw(self), dumpfile.into_param().abi(), qualifier, formatflags, comment.into_param().abi()).ok()
    }
    pub unsafe fn AddDumpInformationFile<P0>(&self, infofile: P0, r#type: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).AddDumpInformationFile)(::windows::core::Interface::as_raw(self), infofile.into_param().abi(), r#type).ok()
    }
    pub unsafe fn EndProcessServer(&self, server: u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).EndProcessServer)(::windows::core::Interface::as_raw(self), server).ok()
    }
    pub unsafe fn WaitForProcessServerEnd(&self, timeout: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).WaitForProcessServerEnd)(::windows::core::Interface::as_raw(self), timeout).ok()
    }
    pub unsafe fn IsKernelDebuggerEnabled(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).IsKernelDebuggerEnabled)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn TerminateCurrentProcess(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).TerminateCurrentProcess)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn DetachCurrentProcess(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).DetachCurrentProcess)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn AbandonCurrentProcess(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).AbandonCurrentProcess)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetRunningProcessSystemIdByExecutableNameWide<P0>(&self, server: u64, exename: P0, flags: u32) -> ::windows::core::Result<u32>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetRunningProcessSystemIdByExecutableNameWide)(::windows::core::Interface::as_raw(self), server, exename.into_param().abi(), flags, &mut result__).from_abi(result__)
    }
    pub unsafe fn GetRunningProcessDescriptionWide(&self, server: u64, systemid: u32, flags: u32, exename: ::core::option::Option<&mut [u16]>, actualexenamesize: ::core::option::Option<*mut u32>, description: ::core::option::Option<&mut [u16]>, actualdescriptionsize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetRunningProcessDescriptionWide)(
            ::windows::core::Interface::as_raw(self),
            server,
            systemid,
            flags,
            ::core::mem::transmute(exename.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
            exename.as_deref().map_or(0, |slice| slice.len() as _),
            ::core::mem::transmute(actualexenamesize.unwrap_or(::std::ptr::null_mut())),
            ::core::mem::transmute(description.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
            description.as_deref().map_or(0, |slice| slice.len() as _),
            ::core::mem::transmute(actualdescriptionsize.unwrap_or(::std::ptr::null_mut())),
        )
        .ok()
    }
    pub unsafe fn CreateProcessWide<P0>(&self, server: u64, commandline: P0, createflags: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).CreateProcessWide)(::windows::core::Interface::as_raw(self), server, commandline.into_param().abi(), createflags).ok()
    }
    pub unsafe fn CreateProcessAndAttachWide<P0>(&self, server: u64, commandline: P0, createflags: u32, processid: u32, attachflags: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).CreateProcessAndAttachWide)(::windows::core::Interface::as_raw(self), server, commandline.into_param().abi(), createflags, processid, attachflags).ok()
    }
}
::windows::imp::interface_hierarchy!(IDebugClient3, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IDebugClient3 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDebugClient3 {}
impl ::core::fmt::Debug for IDebugClient3 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDebugClient3").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDebugClient3 {
    type Vtable = IDebugClient3_Vtbl;
}
impl ::core::clone::Clone for IDebugClient3 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IDebugClient3 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xdd492d7f_71b8_4ad6_a8dc_1c887479ff91);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDebugClient3_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub AttachKernel: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flags: u32, connectoptions: ::windows::core::PCSTR) -> ::windows::core::HRESULT,
    pub GetKernelConnectionOptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, buffer: ::windows::core::PSTR, buffersize: u32, optionssize: *mut u32) -> ::windows::core::HRESULT,
    pub SetKernelConnectionOptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, options: ::windows::core::PCSTR) -> ::windows::core::HRESULT,
    pub StartProcessServer: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flags: u32, options: ::windows::core::PCSTR, reserved: *const ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub ConnectProcessServer: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, remoteoptions: ::windows::core::PCSTR, server: *mut u64) -> ::windows::core::HRESULT,
    pub DisconnectProcessServer: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64) -> ::windows::core::HRESULT,
    pub GetRunningProcessSystemIds: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, ids: *mut u32, count: u32, actualcount: *mut u32) -> ::windows::core::HRESULT,
    pub GetRunningProcessSystemIdByExecutableName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, exename: ::windows::core::PCSTR, flags: u32, id: *mut u32) -> ::windows::core::HRESULT,
    pub GetRunningProcessDescription: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, systemid: u32, flags: u32, exename: ::windows::core::PSTR, exenamesize: u32, actualexenamesize: *mut u32, description: ::windows::core::PSTR, descriptionsize: u32, actualdescriptionsize: *mut u32) -> ::windows::core::HRESULT,
    pub AttachProcess: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, processid: u32, attachflags: u32) -> ::windows::core::HRESULT,
    pub CreateProcessA: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, commandline: ::windows::core::PCSTR, createflags: u32) -> ::windows::core::HRESULT,
    pub CreateProcessAndAttach: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, commandline: ::windows::core::PCSTR, createflags: u32, processid: u32, attachflags: u32) -> ::windows::core::HRESULT,
    pub GetProcessOptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, options: *mut u32) -> ::windows::core::HRESULT,
    pub AddProcessOptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, options: u32) -> ::windows::core::HRESULT,
    pub RemoveProcessOptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, options: u32) -> ::windows::core::HRESULT,
    pub SetProcessOptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, options: u32) -> ::windows::core::HRESULT,
    pub OpenDumpFile: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dumpfile: ::windows::core::PCSTR) -> ::windows::core::HRESULT,
    pub WriteDumpFile: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dumpfile: ::windows::core::PCSTR, qualifier: u32) -> ::windows::core::HRESULT,
    pub ConnectSession: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flags: u32, historylimit: u32) -> ::windows::core::HRESULT,
    pub StartServer: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, options: ::windows::core::PCSTR) -> ::windows::core::HRESULT,
    pub OutputServers: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, outputcontrol: u32, machine: ::windows::core::PCSTR, flags: u32) -> ::windows::core::HRESULT,
    pub TerminateProcesses: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub DetachProcesses: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub EndSession: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flags: u32) -> ::windows::core::HRESULT,
    pub GetExitCode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, code: *mut u32) -> ::windows::core::HRESULT,
    pub DispatchCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, timeout: u32) -> ::windows::core::HRESULT,
    pub ExitDispatch: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, client: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub CreateClient: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, client: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetInputCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, callbacks: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub SetInputCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, callbacks: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetOutputCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, callbacks: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub SetOutputCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, callbacks: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetOutputMask: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, mask: *mut u32) -> ::windows::core::HRESULT,
    pub SetOutputMask: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, mask: u32) -> ::windows::core::HRESULT,
    pub GetOtherOutputMask: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, client: *mut ::core::ffi::c_void, mask: *mut u32) -> ::windows::core::HRESULT,
    pub SetOtherOutputMask: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, client: *mut ::core::ffi::c_void, mask: u32) -> ::windows::core::HRESULT,
    pub GetOutputWidth: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, columns: *mut u32) -> ::windows::core::HRESULT,
    pub SetOutputWidth: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, columns: u32) -> ::windows::core::HRESULT,
    pub GetOutputLinePrefix: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, buffer: ::windows::core::PSTR, buffersize: u32, prefixsize: *mut u32) -> ::windows::core::HRESULT,
    pub SetOutputLinePrefix: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, prefix: ::windows::core::PCSTR) -> ::windows::core::HRESULT,
    pub GetIdentity: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, buffer: ::windows::core::PSTR, buffersize: u32, identitysize: *mut u32) -> ::windows::core::HRESULT,
    pub OutputIdentity: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, outputcontrol: u32, flags: u32, format: ::windows::core::PCSTR) -> ::windows::core::HRESULT,
    pub GetEventCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, callbacks: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub SetEventCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, callbacks: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub FlushCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub WriteDumpFile2: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dumpfile: ::windows::core::PCSTR, qualifier: u32, formatflags: u32, comment: ::windows::core::PCSTR) -> ::windows::core::HRESULT,
    pub AddDumpInformationFile: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, infofile: ::windows::core::PCSTR, r#type: u32) -> ::windows::core::HRESULT,
    pub EndProcessServer: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64) -> ::windows::core::HRESULT,
    pub WaitForProcessServerEnd: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, timeout: u32) -> ::windows::core::HRESULT,
    pub IsKernelDebuggerEnabled: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub TerminateCurrentProcess: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub DetachCurrentProcess: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub AbandonCurrentProcess: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetRunningProcessSystemIdByExecutableNameWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, exename: ::windows::core::PCWSTR, flags: u32, id: *mut u32) -> ::windows::core::HRESULT,
    pub GetRunningProcessDescriptionWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, systemid: u32, flags: u32, exename: ::windows::core::PWSTR, exenamesize: u32, actualexenamesize: *mut u32, description: ::windows::core::PWSTR, descriptionsize: u32, actualdescriptionsize: *mut u32) -> ::windows::core::HRESULT,
    pub CreateProcessWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, commandline: ::windows::core::PCWSTR, createflags: u32) -> ::windows::core::HRESULT,
    pub CreateProcessAndAttachWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, commandline: ::windows::core::PCWSTR, createflags: u32, processid: u32, attachflags: u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IDebugClient4(::windows::core::IUnknown);
impl IDebugClient4 {
    pub unsafe fn AttachKernel<P0>(&self, flags: u32, connectoptions: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).AttachKernel)(::windows::core::Interface::as_raw(self), flags, connectoptions.into_param().abi()).ok()
    }
    pub unsafe fn GetKernelConnectionOptions(&self, buffer: ::core::option::Option<&mut [u8]>, optionssize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetKernelConnectionOptions)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(optionssize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetKernelConnectionOptions<P0>(&self, options: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).SetKernelConnectionOptions)(::windows::core::Interface::as_raw(self), options.into_param().abi()).ok()
    }
    pub unsafe fn StartProcessServer<P0>(&self, flags: u32, options: P0, reserved: ::core::option::Option<*const ::core::ffi::c_void>) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).StartProcessServer)(::windows::core::Interface::as_raw(self), flags, options.into_param().abi(), ::core::mem::transmute(reserved.unwrap_or(::std::ptr::null()))).ok()
    }
    pub unsafe fn ConnectProcessServer<P0>(&self, remoteoptions: P0) -> ::windows::core::Result<u64>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        let mut result__ = ::windows::core::zeroed::<u64>();
        (::windows::core::Interface::vtable(self).ConnectProcessServer)(::windows::core::Interface::as_raw(self), remoteoptions.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn DisconnectProcessServer(&self, server: u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).DisconnectProcessServer)(::windows::core::Interface::as_raw(self), server).ok()
    }
    pub unsafe fn GetRunningProcessSystemIds(&self, server: u64, ids: ::core::option::Option<&mut [u32]>, actualcount: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetRunningProcessSystemIds)(::windows::core::Interface::as_raw(self), server, ::core::mem::transmute(ids.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), ids.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(actualcount.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetRunningProcessSystemIdByExecutableName<P0>(&self, server: u64, exename: P0, flags: u32) -> ::windows::core::Result<u32>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetRunningProcessSystemIdByExecutableName)(::windows::core::Interface::as_raw(self), server, exename.into_param().abi(), flags, &mut result__).from_abi(result__)
    }
    pub unsafe fn GetRunningProcessDescription(&self, server: u64, systemid: u32, flags: u32, exename: ::core::option::Option<&mut [u8]>, actualexenamesize: ::core::option::Option<*mut u32>, description: ::core::option::Option<&mut [u8]>, actualdescriptionsize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetRunningProcessDescription)(
            ::windows::core::Interface::as_raw(self),
            server,
            systemid,
            flags,
            ::core::mem::transmute(exename.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
            exename.as_deref().map_or(0, |slice| slice.len() as _),
            ::core::mem::transmute(actualexenamesize.unwrap_or(::std::ptr::null_mut())),
            ::core::mem::transmute(description.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
            description.as_deref().map_or(0, |slice| slice.len() as _),
            ::core::mem::transmute(actualdescriptionsize.unwrap_or(::std::ptr::null_mut())),
        )
        .ok()
    }
    pub unsafe fn AttachProcess(&self, server: u64, processid: u32, attachflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).AttachProcess)(::windows::core::Interface::as_raw(self), server, processid, attachflags).ok()
    }
    pub unsafe fn CreateProcessA<P0>(&self, server: u64, commandline: P0, createflags: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).CreateProcessA)(::windows::core::Interface::as_raw(self), server, commandline.into_param().abi(), createflags).ok()
    }
    pub unsafe fn CreateProcessAndAttach<P0>(&self, server: u64, commandline: P0, createflags: u32, processid: u32, attachflags: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).CreateProcessAndAttach)(::windows::core::Interface::as_raw(self), server, commandline.into_param().abi(), createflags, processid, attachflags).ok()
    }
    pub unsafe fn GetProcessOptions(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetProcessOptions)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn AddProcessOptions(&self, options: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).AddProcessOptions)(::windows::core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn RemoveProcessOptions(&self, options: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).RemoveProcessOptions)(::windows::core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn SetProcessOptions(&self, options: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetProcessOptions)(::windows::core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn OpenDumpFile<P0>(&self, dumpfile: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).OpenDumpFile)(::windows::core::Interface::as_raw(self), dumpfile.into_param().abi()).ok()
    }
    pub unsafe fn WriteDumpFile<P0>(&self, dumpfile: P0, qualifier: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).WriteDumpFile)(::windows::core::Interface::as_raw(self), dumpfile.into_param().abi(), qualifier).ok()
    }
    pub unsafe fn ConnectSession(&self, flags: u32, historylimit: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).ConnectSession)(::windows::core::Interface::as_raw(self), flags, historylimit).ok()
    }
    pub unsafe fn StartServer<P0>(&self, options: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).StartServer)(::windows::core::Interface::as_raw(self), options.into_param().abi()).ok()
    }
    pub unsafe fn OutputServers<P0>(&self, outputcontrol: u32, machine: P0, flags: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).OutputServers)(::windows::core::Interface::as_raw(self), outputcontrol, machine.into_param().abi(), flags).ok()
    }
    pub unsafe fn TerminateProcesses(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).TerminateProcesses)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn DetachProcesses(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).DetachProcesses)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn EndSession(&self, flags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).EndSession)(::windows::core::Interface::as_raw(self), flags).ok()
    }
    pub unsafe fn GetExitCode(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetExitCode)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn DispatchCallbacks(&self, timeout: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).DispatchCallbacks)(::windows::core::Interface::as_raw(self), timeout).ok()
    }
    pub unsafe fn ExitDispatch<P0>(&self, client: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugClient>,
    {
        (::windows::core::Interface::vtable(self).ExitDispatch)(::windows::core::Interface::as_raw(self), client.into_param().abi()).ok()
    }
    pub unsafe fn CreateClient(&self) -> ::windows::core::Result<IDebugClient> {
        let mut result__ = ::windows::core::zeroed::<IDebugClient>();
        (::windows::core::Interface::vtable(self).CreateClient)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetInputCallbacks(&self) -> ::windows::core::Result<IDebugInputCallbacks> {
        let mut result__ = ::windows::core::zeroed::<IDebugInputCallbacks>();
        (::windows::core::Interface::vtable(self).GetInputCallbacks)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetInputCallbacks<P0>(&self, callbacks: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugInputCallbacks>,
    {
        (::windows::core::Interface::vtable(self).SetInputCallbacks)(::windows::core::Interface::as_raw(self), callbacks.into_param().abi()).ok()
    }
    pub unsafe fn GetOutputCallbacks(&self) -> ::windows::core::Result<IDebugOutputCallbacks> {
        let mut result__ = ::windows::core::zeroed::<IDebugOutputCallbacks>();
        (::windows::core::Interface::vtable(self).GetOutputCallbacks)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetOutputCallbacks<P0>(&self, callbacks: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugOutputCallbacks>,
    {
        (::windows::core::Interface::vtable(self).SetOutputCallbacks)(::windows::core::Interface::as_raw(self), callbacks.into_param().abi()).ok()
    }
    pub unsafe fn GetOutputMask(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetOutputMask)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetOutputMask(&self, mask: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetOutputMask)(::windows::core::Interface::as_raw(self), mask).ok()
    }
    pub unsafe fn GetOtherOutputMask<P0>(&self, client: P0) -> ::windows::core::Result<u32>
    where
        P0: ::windows::core::IntoParam<IDebugClient>,
    {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetOtherOutputMask)(::windows::core::Interface::as_raw(self), client.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetOtherOutputMask<P0>(&self, client: P0, mask: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugClient>,
    {
        (::windows::core::Interface::vtable(self).SetOtherOutputMask)(::windows::core::Interface::as_raw(self), client.into_param().abi(), mask).ok()
    }
    pub unsafe fn GetOutputWidth(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetOutputWidth)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetOutputWidth(&self, columns: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetOutputWidth)(::windows::core::Interface::as_raw(self), columns).ok()
    }
    pub unsafe fn GetOutputLinePrefix(&self, buffer: ::core::option::Option<&mut [u8]>, prefixsize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetOutputLinePrefix)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(prefixsize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetOutputLinePrefix<P0>(&self, prefix: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).SetOutputLinePrefix)(::windows::core::Interface::as_raw(self), prefix.into_param().abi()).ok()
    }
    pub unsafe fn GetIdentity(&self, buffer: ::core::option::Option<&mut [u8]>, identitysize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetIdentity)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(identitysize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn OutputIdentity<P0>(&self, outputcontrol: u32, flags: u32, format: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).OutputIdentity)(::windows::core::Interface::as_raw(self), outputcontrol, flags, format.into_param().abi()).ok()
    }
    pub unsafe fn GetEventCallbacks(&self) -> ::windows::core::Result<IDebugEventCallbacks> {
        let mut result__ = ::windows::core::zeroed::<IDebugEventCallbacks>();
        (::windows::core::Interface::vtable(self).GetEventCallbacks)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetEventCallbacks<P0>(&self, callbacks: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugEventCallbacks>,
    {
        (::windows::core::Interface::vtable(self).SetEventCallbacks)(::windows::core::Interface::as_raw(self), callbacks.into_param().abi()).ok()
    }
    pub unsafe fn FlushCallbacks(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).FlushCallbacks)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn WriteDumpFile2<P0, P1>(&self, dumpfile: P0, qualifier: u32, formatflags: u32, comment: P1) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
        P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).WriteDumpFile2)(::windows::core::Interface::as_raw(self), dumpfile.into_param().abi(), qualifier, formatflags, comment.into_param().abi()).ok()
    }
    pub unsafe fn AddDumpInformationFile<P0>(&self, infofile: P0, r#type: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).AddDumpInformationFile)(::windows::core::Interface::as_raw(self), infofile.into_param().abi(), r#type).ok()
    }
    pub unsafe fn EndProcessServer(&self, server: u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).EndProcessServer)(::windows::core::Interface::as_raw(self), server).ok()
    }
    pub unsafe fn WaitForProcessServerEnd(&self, timeout: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).WaitForProcessServerEnd)(::windows::core::Interface::as_raw(self), timeout).ok()
    }
    pub unsafe fn IsKernelDebuggerEnabled(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).IsKernelDebuggerEnabled)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn TerminateCurrentProcess(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).TerminateCurrentProcess)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn DetachCurrentProcess(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).DetachCurrentProcess)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn AbandonCurrentProcess(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).AbandonCurrentProcess)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetRunningProcessSystemIdByExecutableNameWide<P0>(&self, server: u64, exename: P0, flags: u32) -> ::windows::core::Result<u32>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetRunningProcessSystemIdByExecutableNameWide)(::windows::core::Interface::as_raw(self), server, exename.into_param().abi(), flags, &mut result__).from_abi(result__)
    }
    pub unsafe fn GetRunningProcessDescriptionWide(&self, server: u64, systemid: u32, flags: u32, exename: ::core::option::Option<&mut [u16]>, actualexenamesize: ::core::option::Option<*mut u32>, description: ::core::option::Option<&mut [u16]>, actualdescriptionsize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetRunningProcessDescriptionWide)(
            ::windows::core::Interface::as_raw(self),
            server,
            systemid,
            flags,
            ::core::mem::transmute(exename.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
            exename.as_deref().map_or(0, |slice| slice.len() as _),
            ::core::mem::transmute(actualexenamesize.unwrap_or(::std::ptr::null_mut())),
            ::core::mem::transmute(description.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
            description.as_deref().map_or(0, |slice| slice.len() as _),
            ::core::mem::transmute(actualdescriptionsize.unwrap_or(::std::ptr::null_mut())),
        )
        .ok()
    }
    pub unsafe fn CreateProcessWide<P0>(&self, server: u64, commandline: P0, createflags: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).CreateProcessWide)(::windows::core::Interface::as_raw(self), server, commandline.into_param().abi(), createflags).ok()
    }
    pub unsafe fn CreateProcessAndAttachWide<P0>(&self, server: u64, commandline: P0, createflags: u32, processid: u32, attachflags: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).CreateProcessAndAttachWide)(::windows::core::Interface::as_raw(self), server, commandline.into_param().abi(), createflags, processid, attachflags).ok()
    }
    pub unsafe fn OpenDumpFileWide<P0>(&self, filename: P0, filehandle: u64) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).OpenDumpFileWide)(::windows::core::Interface::as_raw(self), filename.into_param().abi(), filehandle).ok()
    }
    pub unsafe fn WriteDumpFileWide<P0, P1>(&self, filename: P0, filehandle: u64, qualifier: u32, formatflags: u32, comment: P1) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).WriteDumpFileWide)(::windows::core::Interface::as_raw(self), filename.into_param().abi(), filehandle, qualifier, formatflags, comment.into_param().abi()).ok()
    }
    pub unsafe fn AddDumpInformationFileWide<P0>(&self, filename: P0, filehandle: u64, r#type: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).AddDumpInformationFileWide)(::windows::core::Interface::as_raw(self), filename.into_param().abi(), filehandle, r#type).ok()
    }
    pub unsafe fn GetNumberDumpFiles(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetNumberDumpFiles)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetDumpFile(&self, index: u32, buffer: ::core::option::Option<&mut [u8]>, namesize: ::core::option::Option<*mut u32>, handle: ::core::option::Option<*mut u64>, r#type: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetDumpFile)(::windows::core::Interface::as_raw(self), index, ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(namesize.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(handle.unwrap_or(::std::ptr::null_mut())), r#type).ok()
    }
    pub unsafe fn GetDumpFileWide(&self, index: u32, buffer: ::core::option::Option<&mut [u16]>, namesize: ::core::option::Option<*mut u32>, handle: ::core::option::Option<*mut u64>, r#type: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetDumpFileWide)(::windows::core::Interface::as_raw(self), index, ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(namesize.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(handle.unwrap_or(::std::ptr::null_mut())), r#type).ok()
    }
}
::windows::imp::interface_hierarchy!(IDebugClient4, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IDebugClient4 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDebugClient4 {}
impl ::core::fmt::Debug for IDebugClient4 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDebugClient4").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDebugClient4 {
    type Vtable = IDebugClient4_Vtbl;
}
impl ::core::clone::Clone for IDebugClient4 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IDebugClient4 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xca83c3de_5089_4cf8_93c8_d892387f2a5e);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDebugClient4_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub AttachKernel: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flags: u32, connectoptions: ::windows::core::PCSTR) -> ::windows::core::HRESULT,
    pub GetKernelConnectionOptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, buffer: ::windows::core::PSTR, buffersize: u32, optionssize: *mut u32) -> ::windows::core::HRESULT,
    pub SetKernelConnectionOptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, options: ::windows::core::PCSTR) -> ::windows::core::HRESULT,
    pub StartProcessServer: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flags: u32, options: ::windows::core::PCSTR, reserved: *const ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub ConnectProcessServer: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, remoteoptions: ::windows::core::PCSTR, server: *mut u64) -> ::windows::core::HRESULT,
    pub DisconnectProcessServer: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64) -> ::windows::core::HRESULT,
    pub GetRunningProcessSystemIds: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, ids: *mut u32, count: u32, actualcount: *mut u32) -> ::windows::core::HRESULT,
    pub GetRunningProcessSystemIdByExecutableName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, exename: ::windows::core::PCSTR, flags: u32, id: *mut u32) -> ::windows::core::HRESULT,
    pub GetRunningProcessDescription: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, systemid: u32, flags: u32, exename: ::windows::core::PSTR, exenamesize: u32, actualexenamesize: *mut u32, description: ::windows::core::PSTR, descriptionsize: u32, actualdescriptionsize: *mut u32) -> ::windows::core::HRESULT,
    pub AttachProcess: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, processid: u32, attachflags: u32) -> ::windows::core::HRESULT,
    pub CreateProcessA: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, commandline: ::windows::core::PCSTR, createflags: u32) -> ::windows::core::HRESULT,
    pub CreateProcessAndAttach: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, commandline: ::windows::core::PCSTR, createflags: u32, processid: u32, attachflags: u32) -> ::windows::core::HRESULT,
    pub GetProcessOptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, options: *mut u32) -> ::windows::core::HRESULT,
    pub AddProcessOptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, options: u32) -> ::windows::core::HRESULT,
    pub RemoveProcessOptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, options: u32) -> ::windows::core::HRESULT,
    pub SetProcessOptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, options: u32) -> ::windows::core::HRESULT,
    pub OpenDumpFile: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dumpfile: ::windows::core::PCSTR) -> ::windows::core::HRESULT,
    pub WriteDumpFile: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dumpfile: ::windows::core::PCSTR, qualifier: u32) -> ::windows::core::HRESULT,
    pub ConnectSession: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flags: u32, historylimit: u32) -> ::windows::core::HRESULT,
    pub StartServer: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, options: ::windows::core::PCSTR) -> ::windows::core::HRESULT,
    pub OutputServers: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, outputcontrol: u32, machine: ::windows::core::PCSTR, flags: u32) -> ::windows::core::HRESULT,
    pub TerminateProcesses: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub DetachProcesses: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub EndSession: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flags: u32) -> ::windows::core::HRESULT,
    pub GetExitCode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, code: *mut u32) -> ::windows::core::HRESULT,
    pub DispatchCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, timeout: u32) -> ::windows::core::HRESULT,
    pub ExitDispatch: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, client: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub CreateClient: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, client: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetInputCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, callbacks: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub SetInputCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, callbacks: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetOutputCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, callbacks: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub SetOutputCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, callbacks: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetOutputMask: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, mask: *mut u32) -> ::windows::core::HRESULT,
    pub SetOutputMask: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, mask: u32) -> ::windows::core::HRESULT,
    pub GetOtherOutputMask: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, client: *mut ::core::ffi::c_void, mask: *mut u32) -> ::windows::core::HRESULT,
    pub SetOtherOutputMask: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, client: *mut ::core::ffi::c_void, mask: u32) -> ::windows::core::HRESULT,
    pub GetOutputWidth: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, columns: *mut u32) -> ::windows::core::HRESULT,
    pub SetOutputWidth: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, columns: u32) -> ::windows::core::HRESULT,
    pub GetOutputLinePrefix: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, buffer: ::windows::core::PSTR, buffersize: u32, prefixsize: *mut u32) -> ::windows::core::HRESULT,
    pub SetOutputLinePrefix: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, prefix: ::windows::core::PCSTR) -> ::windows::core::HRESULT,
    pub GetIdentity: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, buffer: ::windows::core::PSTR, buffersize: u32, identitysize: *mut u32) -> ::windows::core::HRESULT,
    pub OutputIdentity: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, outputcontrol: u32, flags: u32, format: ::windows::core::PCSTR) -> ::windows::core::HRESULT,
    pub GetEventCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, callbacks: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub SetEventCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, callbacks: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub FlushCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub WriteDumpFile2: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dumpfile: ::windows::core::PCSTR, qualifier: u32, formatflags: u32, comment: ::windows::core::PCSTR) -> ::windows::core::HRESULT,
    pub AddDumpInformationFile: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, infofile: ::windows::core::PCSTR, r#type: u32) -> ::windows::core::HRESULT,
    pub EndProcessServer: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64) -> ::windows::core::HRESULT,
    pub WaitForProcessServerEnd: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, timeout: u32) -> ::windows::core::HRESULT,
    pub IsKernelDebuggerEnabled: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub TerminateCurrentProcess: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub DetachCurrentProcess: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub AbandonCurrentProcess: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetRunningProcessSystemIdByExecutableNameWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, exename: ::windows::core::PCWSTR, flags: u32, id: *mut u32) -> ::windows::core::HRESULT,
    pub GetRunningProcessDescriptionWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, systemid: u32, flags: u32, exename: ::windows::core::PWSTR, exenamesize: u32, actualexenamesize: *mut u32, description: ::windows::core::PWSTR, descriptionsize: u32, actualdescriptionsize: *mut u32) -> ::windows::core::HRESULT,
    pub CreateProcessWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, commandline: ::windows::core::PCWSTR, createflags: u32) -> ::windows::core::HRESULT,
    pub CreateProcessAndAttachWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, commandline: ::windows::core::PCWSTR, createflags: u32, processid: u32, attachflags: u32) -> ::windows::core::HRESULT,
    pub OpenDumpFileWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, filename: ::windows::core::PCWSTR, filehandle: u64) -> ::windows::core::HRESULT,
    pub WriteDumpFileWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, filename: ::windows::core::PCWSTR, filehandle: u64, qualifier: u32, formatflags: u32, comment: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub AddDumpInformationFileWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, filename: ::windows::core::PCWSTR, filehandle: u64, r#type: u32) -> ::windows::core::HRESULT,
    pub GetNumberDumpFiles: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, number: *mut u32) -> ::windows::core::HRESULT,
    pub GetDumpFile: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, index: u32, buffer: ::windows::core::PSTR, buffersize: u32, namesize: *mut u32, handle: *mut u64, r#type: *mut u32) -> ::windows::core::HRESULT,
    pub GetDumpFileWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, index: u32, buffer: ::windows::core::PWSTR, buffersize: u32, namesize: *mut u32, handle: *mut u64, r#type: *mut u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IDebugClient5(::windows::core::IUnknown);
impl IDebugClient5 {
    pub unsafe fn AttachKernel<P0>(&self, flags: u32, connectoptions: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).AttachKernel)(::windows::core::Interface::as_raw(self), flags, connectoptions.into_param().abi()).ok()
    }
    pub unsafe fn GetKernelConnectionOptions(&self, buffer: ::core::option::Option<&mut [u8]>, optionssize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetKernelConnectionOptions)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(optionssize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetKernelConnectionOptions<P0>(&self, options: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).SetKernelConnectionOptions)(::windows::core::Interface::as_raw(self), options.into_param().abi()).ok()
    }
    pub unsafe fn StartProcessServer<P0>(&self, flags: u32, options: P0, reserved: ::core::option::Option<*const ::core::ffi::c_void>) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).StartProcessServer)(::windows::core::Interface::as_raw(self), flags, options.into_param().abi(), ::core::mem::transmute(reserved.unwrap_or(::std::ptr::null()))).ok()
    }
    pub unsafe fn ConnectProcessServer<P0>(&self, remoteoptions: P0) -> ::windows::core::Result<u64>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        let mut result__ = ::windows::core::zeroed::<u64>();
        (::windows::core::Interface::vtable(self).ConnectProcessServer)(::windows::core::Interface::as_raw(self), remoteoptions.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn DisconnectProcessServer(&self, server: u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).DisconnectProcessServer)(::windows::core::Interface::as_raw(self), server).ok()
    }
    pub unsafe fn GetRunningProcessSystemIds(&self, server: u64, ids: ::core::option::Option<&mut [u32]>, actualcount: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetRunningProcessSystemIds)(::windows::core::Interface::as_raw(self), server, ::core::mem::transmute(ids.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), ids.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(actualcount.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetRunningProcessSystemIdByExecutableName<P0>(&self, server: u64, exename: P0, flags: u32) -> ::windows::core::Result<u32>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetRunningProcessSystemIdByExecutableName)(::windows::core::Interface::as_raw(self), server, exename.into_param().abi(), flags, &mut result__).from_abi(result__)
    }
    pub unsafe fn GetRunningProcessDescription(&self, server: u64, systemid: u32, flags: u32, exename: ::core::option::Option<&mut [u8]>, actualexenamesize: ::core::option::Option<*mut u32>, description: ::core::option::Option<&mut [u8]>, actualdescriptionsize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetRunningProcessDescription)(
            ::windows::core::Interface::as_raw(self),
            server,
            systemid,
            flags,
            ::core::mem::transmute(exename.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
            exename.as_deref().map_or(0, |slice| slice.len() as _),
            ::core::mem::transmute(actualexenamesize.unwrap_or(::std::ptr::null_mut())),
            ::core::mem::transmute(description.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
            description.as_deref().map_or(0, |slice| slice.len() as _),
            ::core::mem::transmute(actualdescriptionsize.unwrap_or(::std::ptr::null_mut())),
        )
        .ok()
    }
    pub unsafe fn AttachProcess(&self, server: u64, processid: u32, attachflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).AttachProcess)(::windows::core::Interface::as_raw(self), server, processid, attachflags).ok()
    }
    pub unsafe fn CreateProcessA<P0>(&self, server: u64, commandline: P0, createflags: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).CreateProcessA)(::windows::core::Interface::as_raw(self), server, commandline.into_param().abi(), createflags).ok()
    }
    pub unsafe fn CreateProcessAndAttach<P0>(&self, server: u64, commandline: P0, createflags: u32, processid: u32, attachflags: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).CreateProcessAndAttach)(::windows::core::Interface::as_raw(self), server, commandline.into_param().abi(), createflags, processid, attachflags).ok()
    }
    pub unsafe fn GetProcessOptions(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetProcessOptions)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn AddProcessOptions(&self, options: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).AddProcessOptions)(::windows::core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn RemoveProcessOptions(&self, options: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).RemoveProcessOptions)(::windows::core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn SetProcessOptions(&self, options: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetProcessOptions)(::windows::core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn OpenDumpFile<P0>(&self, dumpfile: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).OpenDumpFile)(::windows::core::Interface::as_raw(self), dumpfile.into_param().abi()).ok()
    }
    pub unsafe fn WriteDumpFile<P0>(&self, dumpfile: P0, qualifier: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).WriteDumpFile)(::windows::core::Interface::as_raw(self), dumpfile.into_param().abi(), qualifier).ok()
    }
    pub unsafe fn ConnectSession(&self, flags: u32, historylimit: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).ConnectSession)(::windows::core::Interface::as_raw(self), flags, historylimit).ok()
    }
    pub unsafe fn StartServer<P0>(&self, options: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).StartServer)(::windows::core::Interface::as_raw(self), options.into_param().abi()).ok()
    }
    pub unsafe fn OutputServers<P0>(&self, outputcontrol: u32, machine: P0, flags: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).OutputServers)(::windows::core::Interface::as_raw(self), outputcontrol, machine.into_param().abi(), flags).ok()
    }
    pub unsafe fn TerminateProcesses(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).TerminateProcesses)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn DetachProcesses(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).DetachProcesses)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn EndSession(&self, flags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).EndSession)(::windows::core::Interface::as_raw(self), flags).ok()
    }
    pub unsafe fn GetExitCode(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetExitCode)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn DispatchCallbacks(&self, timeout: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).DispatchCallbacks)(::windows::core::Interface::as_raw(self), timeout).ok()
    }
    pub unsafe fn ExitDispatch<P0>(&self, client: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugClient>,
    {
        (::windows::core::Interface::vtable(self).ExitDispatch)(::windows::core::Interface::as_raw(self), client.into_param().abi()).ok()
    }
    pub unsafe fn CreateClient(&self) -> ::windows::core::Result<IDebugClient> {
        let mut result__ = ::windows::core::zeroed::<IDebugClient>();
        (::windows::core::Interface::vtable(self).CreateClient)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetInputCallbacks(&self) -> ::windows::core::Result<IDebugInputCallbacks> {
        let mut result__ = ::windows::core::zeroed::<IDebugInputCallbacks>();
        (::windows::core::Interface::vtable(self).GetInputCallbacks)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetInputCallbacks<P0>(&self, callbacks: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugInputCallbacks>,
    {
        (::windows::core::Interface::vtable(self).SetInputCallbacks)(::windows::core::Interface::as_raw(self), callbacks.into_param().abi()).ok()
    }
    pub unsafe fn GetOutputCallbacks(&self) -> ::windows::core::Result<IDebugOutputCallbacks> {
        let mut result__ = ::windows::core::zeroed::<IDebugOutputCallbacks>();
        (::windows::core::Interface::vtable(self).GetOutputCallbacks)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetOutputCallbacks<P0>(&self, callbacks: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugOutputCallbacks>,
    {
        (::windows::core::Interface::vtable(self).SetOutputCallbacks)(::windows::core::Interface::as_raw(self), callbacks.into_param().abi()).ok()
    }
    pub unsafe fn GetOutputMask(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetOutputMask)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetOutputMask(&self, mask: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetOutputMask)(::windows::core::Interface::as_raw(self), mask).ok()
    }
    pub unsafe fn GetOtherOutputMask<P0>(&self, client: P0) -> ::windows::core::Result<u32>
    where
        P0: ::windows::core::IntoParam<IDebugClient>,
    {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetOtherOutputMask)(::windows::core::Interface::as_raw(self), client.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetOtherOutputMask<P0>(&self, client: P0, mask: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugClient>,
    {
        (::windows::core::Interface::vtable(self).SetOtherOutputMask)(::windows::core::Interface::as_raw(self), client.into_param().abi(), mask).ok()
    }
    pub unsafe fn GetOutputWidth(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetOutputWidth)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetOutputWidth(&self, columns: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetOutputWidth)(::windows::core::Interface::as_raw(self), columns).ok()
    }
    pub unsafe fn GetOutputLinePrefix(&self, buffer: ::core::option::Option<&mut [u8]>, prefixsize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetOutputLinePrefix)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(prefixsize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetOutputLinePrefix<P0>(&self, prefix: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).SetOutputLinePrefix)(::windows::core::Interface::as_raw(self), prefix.into_param().abi()).ok()
    }
    pub unsafe fn GetIdentity(&self, buffer: ::core::option::Option<&mut [u8]>, identitysize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetIdentity)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(identitysize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn OutputIdentity<P0>(&self, outputcontrol: u32, flags: u32, format: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).OutputIdentity)(::windows::core::Interface::as_raw(self), outputcontrol, flags, format.into_param().abi()).ok()
    }
    pub unsafe fn GetEventCallbacks(&self) -> ::windows::core::Result<IDebugEventCallbacks> {
        let mut result__ = ::windows::core::zeroed::<IDebugEventCallbacks>();
        (::windows::core::Interface::vtable(self).GetEventCallbacks)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetEventCallbacks<P0>(&self, callbacks: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugEventCallbacks>,
    {
        (::windows::core::Interface::vtable(self).SetEventCallbacks)(::windows::core::Interface::as_raw(self), callbacks.into_param().abi()).ok()
    }
    pub unsafe fn FlushCallbacks(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).FlushCallbacks)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn WriteDumpFile2<P0, P1>(&self, dumpfile: P0, qualifier: u32, formatflags: u32, comment: P1) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
        P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).WriteDumpFile2)(::windows::core::Interface::as_raw(self), dumpfile.into_param().abi(), qualifier, formatflags, comment.into_param().abi()).ok()
    }
    pub unsafe fn AddDumpInformationFile<P0>(&self, infofile: P0, r#type: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).AddDumpInformationFile)(::windows::core::Interface::as_raw(self), infofile.into_param().abi(), r#type).ok()
    }
    pub unsafe fn EndProcessServer(&self, server: u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).EndProcessServer)(::windows::core::Interface::as_raw(self), server).ok()
    }
    pub unsafe fn WaitForProcessServerEnd(&self, timeout: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).WaitForProcessServerEnd)(::windows::core::Interface::as_raw(self), timeout).ok()
    }
    pub unsafe fn IsKernelDebuggerEnabled(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).IsKernelDebuggerEnabled)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn TerminateCurrentProcess(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).TerminateCurrentProcess)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn DetachCurrentProcess(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).DetachCurrentProcess)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn AbandonCurrentProcess(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).AbandonCurrentProcess)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetRunningProcessSystemIdByExecutableNameWide<P0>(&self, server: u64, exename: P0, flags: u32) -> ::windows::core::Result<u32>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetRunningProcessSystemIdByExecutableNameWide)(::windows::core::Interface::as_raw(self), server, exename.into_param().abi(), flags, &mut result__).from_abi(result__)
    }
    pub unsafe fn GetRunningProcessDescriptionWide(&self, server: u64, systemid: u32, flags: u32, exename: ::core::option::Option<&mut [u16]>, actualexenamesize: ::core::option::Option<*mut u32>, description: ::core::option::Option<&mut [u16]>, actualdescriptionsize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetRunningProcessDescriptionWide)(
            ::windows::core::Interface::as_raw(self),
            server,
            systemid,
            flags,
            ::core::mem::transmute(exename.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
            exename.as_deref().map_or(0, |slice| slice.len() as _),
            ::core::mem::transmute(actualexenamesize.unwrap_or(::std::ptr::null_mut())),
            ::core::mem::transmute(description.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
            description.as_deref().map_or(0, |slice| slice.len() as _),
            ::core::mem::transmute(actualdescriptionsize.unwrap_or(::std::ptr::null_mut())),
        )
        .ok()
    }
    pub unsafe fn CreateProcessWide<P0>(&self, server: u64, commandline: P0, createflags: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).CreateProcessWide)(::windows::core::Interface::as_raw(self), server, commandline.into_param().abi(), createflags).ok()
    }
    pub unsafe fn CreateProcessAndAttachWide<P0>(&self, server: u64, commandline: P0, createflags: u32, processid: u32, attachflags: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).CreateProcessAndAttachWide)(::windows::core::Interface::as_raw(self), server, commandline.into_param().abi(), createflags, processid, attachflags).ok()
    }
    pub unsafe fn OpenDumpFileWide<P0>(&self, filename: P0, filehandle: u64) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).OpenDumpFileWide)(::windows::core::Interface::as_raw(self), filename.into_param().abi(), filehandle).ok()
    }
    pub unsafe fn WriteDumpFileWide<P0, P1>(&self, filename: P0, filehandle: u64, qualifier: u32, formatflags: u32, comment: P1) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).WriteDumpFileWide)(::windows::core::Interface::as_raw(self), filename.into_param().abi(), filehandle, qualifier, formatflags, comment.into_param().abi()).ok()
    }
    pub unsafe fn AddDumpInformationFileWide<P0>(&self, filename: P0, filehandle: u64, r#type: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).AddDumpInformationFileWide)(::windows::core::Interface::as_raw(self), filename.into_param().abi(), filehandle, r#type).ok()
    }
    pub unsafe fn GetNumberDumpFiles(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetNumberDumpFiles)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetDumpFile(&self, index: u32, buffer: ::core::option::Option<&mut [u8]>, namesize: ::core::option::Option<*mut u32>, handle: ::core::option::Option<*mut u64>, r#type: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetDumpFile)(::windows::core::Interface::as_raw(self), index, ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(namesize.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(handle.unwrap_or(::std::ptr::null_mut())), r#type).ok()
    }
    pub unsafe fn GetDumpFileWide(&self, index: u32, buffer: ::core::option::Option<&mut [u16]>, namesize: ::core::option::Option<*mut u32>, handle: ::core::option::Option<*mut u64>, r#type: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetDumpFileWide)(::windows::core::Interface::as_raw(self), index, ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(namesize.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(handle.unwrap_or(::std::ptr::null_mut())), r#type).ok()
    }
    pub unsafe fn AttachKernelWide<P0>(&self, flags: u32, connectoptions: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).AttachKernelWide)(::windows::core::Interface::as_raw(self), flags, connectoptions.into_param().abi()).ok()
    }
    pub unsafe fn GetKernelConnectionOptionsWide(&self, buffer: ::core::option::Option<&mut [u16]>, optionssize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetKernelConnectionOptionsWide)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(optionssize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetKernelConnectionOptionsWide<P0>(&self, options: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).SetKernelConnectionOptionsWide)(::windows::core::Interface::as_raw(self), options.into_param().abi()).ok()
    }
    pub unsafe fn StartProcessServerWide<P0>(&self, flags: u32, options: P0, reserved: ::core::option::Option<*const ::core::ffi::c_void>) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).StartProcessServerWide)(::windows::core::Interface::as_raw(self), flags, options.into_param().abi(), ::core::mem::transmute(reserved.unwrap_or(::std::ptr::null()))).ok()
    }
    pub unsafe fn ConnectProcessServerWide<P0>(&self, remoteoptions: P0) -> ::windows::core::Result<u64>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        let mut result__ = ::windows::core::zeroed::<u64>();
        (::windows::core::Interface::vtable(self).ConnectProcessServerWide)(::windows::core::Interface::as_raw(self), remoteoptions.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn StartServerWide<P0>(&self, options: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).StartServerWide)(::windows::core::Interface::as_raw(self), options.into_param().abi()).ok()
    }
    pub unsafe fn OutputServersWide<P0>(&self, outputcontrol: u32, machine: P0, flags: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).OutputServersWide)(::windows::core::Interface::as_raw(self), outputcontrol, machine.into_param().abi(), flags).ok()
    }
    pub unsafe fn GetOutputCallbacksWide(&self) -> ::windows::core::Result<IDebugOutputCallbacksWide> {
        let mut result__ = ::windows::core::zeroed::<IDebugOutputCallbacksWide>();
        (::windows::core::Interface::vtable(self).GetOutputCallbacksWide)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetOutputCallbacksWide<P0>(&self, callbacks: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugOutputCallbacksWide>,
    {
        (::windows::core::Interface::vtable(self).SetOutputCallbacksWide)(::windows::core::Interface::as_raw(self), callbacks.into_param().abi()).ok()
    }
    pub unsafe fn GetOutputLinePrefixWide(&self, buffer: ::core::option::Option<&mut [u16]>, prefixsize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetOutputLinePrefixWide)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(prefixsize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetOutputLinePrefixWide<P0>(&self, prefix: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).SetOutputLinePrefixWide)(::windows::core::Interface::as_raw(self), prefix.into_param().abi()).ok()
    }
    pub unsafe fn GetIdentityWide(&self, buffer: ::core::option::Option<&mut [u16]>, identitysize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetIdentityWide)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(identitysize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn OutputIdentityWide<P0>(&self, outputcontrol: u32, flags: u32, format: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).OutputIdentityWide)(::windows::core::Interface::as_raw(self), outputcontrol, flags, format.into_param().abi()).ok()
    }
    pub unsafe fn GetEventCallbacksWide(&self) -> ::windows::core::Result<IDebugEventCallbacksWide> {
        let mut result__ = ::windows::core::zeroed::<IDebugEventCallbacksWide>();
        (::windows::core::Interface::vtable(self).GetEventCallbacksWide)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetEventCallbacksWide<P0>(&self, callbacks: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugEventCallbacksWide>,
    {
        (::windows::core::Interface::vtable(self).SetEventCallbacksWide)(::windows::core::Interface::as_raw(self), callbacks.into_param().abi()).ok()
    }
    pub unsafe fn CreateProcess2<P0, P1, P2>(&self, server: u64, commandline: P0, optionsbuffer: *const ::core::ffi::c_void, optionsbuffersize: u32, initialdirectory: P1, environment: P2) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
        P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
        P2: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).CreateProcess2)(::windows::core::Interface::as_raw(self), server, commandline.into_param().abi(), optionsbuffer, optionsbuffersize, initialdirectory.into_param().abi(), environment.into_param().abi()).ok()
    }
    pub unsafe fn CreateProcess2Wide<P0, P1, P2>(&self, server: u64, commandline: P0, optionsbuffer: *const ::core::ffi::c_void, optionsbuffersize: u32, initialdirectory: P1, environment: P2) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P2: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).CreateProcess2Wide)(::windows::core::Interface::as_raw(self), server, commandline.into_param().abi(), optionsbuffer, optionsbuffersize, initialdirectory.into_param().abi(), environment.into_param().abi()).ok()
    }
    pub unsafe fn CreateProcessAndAttach2<P0, P1, P2>(&self, server: u64, commandline: P0, optionsbuffer: *const ::core::ffi::c_void, optionsbuffersize: u32, initialdirectory: P1, environment: P2, processid: u32, attachflags: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
        P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
        P2: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).CreateProcessAndAttach2)(::windows::core::Interface::as_raw(self), server, commandline.into_param().abi(), optionsbuffer, optionsbuffersize, initialdirectory.into_param().abi(), environment.into_param().abi(), processid, attachflags).ok()
    }
    pub unsafe fn CreateProcessAndAttach2Wide<P0, P1, P2>(&self, server: u64, commandline: P0, optionsbuffer: *const ::core::ffi::c_void, optionsbuffersize: u32, initialdirectory: P1, environment: P2, processid: u32, attachflags: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P2: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).CreateProcessAndAttach2Wide)(::windows::core::Interface::as_raw(self), server, commandline.into_param().abi(), optionsbuffer, optionsbuffersize, initialdirectory.into_param().abi(), environment.into_param().abi(), processid, attachflags).ok()
    }
    pub unsafe fn PushOutputLinePrefix<P0>(&self, newprefix: P0) -> ::windows::core::Result<u64>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        let mut result__ = ::windows::core::zeroed::<u64>();
        (::windows::core::Interface::vtable(self).PushOutputLinePrefix)(::windows::core::Interface::as_raw(self), newprefix.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn PushOutputLinePrefixWide<P0>(&self, newprefix: P0) -> ::windows::core::Result<u64>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        let mut result__ = ::windows::core::zeroed::<u64>();
        (::windows::core::Interface::vtable(self).PushOutputLinePrefixWide)(::windows::core::Interface::as_raw(self), newprefix.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn PopOutputLinePrefix(&self, handle: u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).PopOutputLinePrefix)(::windows::core::Interface::as_raw(self), handle).ok()
    }
    pub unsafe fn GetNumberInputCallbacks(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetNumberInputCallbacks)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetNumberOutputCallbacks(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetNumberOutputCallbacks)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetNumberEventCallbacks(&self, eventflags: u32) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetNumberEventCallbacks)(::windows::core::Interface::as_raw(self), eventflags, &mut result__).from_abi(result__)
    }
    pub unsafe fn GetQuitLockString(&self, buffer: ::core::option::Option<&mut [u8]>, stringsize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetQuitLockString)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(stringsize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetQuitLockString<P0>(&self, string: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).SetQuitLockString)(::windows::core::Interface::as_raw(self), string.into_param().abi()).ok()
    }
    pub unsafe fn GetQuitLockStringWide(&self, buffer: ::core::option::Option<&mut [u16]>, stringsize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetQuitLockStringWide)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(stringsize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetQuitLockStringWide<P0>(&self, string: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).SetQuitLockStringWide)(::windows::core::Interface::as_raw(self), string.into_param().abi()).ok()
    }
}
::windows::imp::interface_hierarchy!(IDebugClient5, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IDebugClient5 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDebugClient5 {}
impl ::core::fmt::Debug for IDebugClient5 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDebugClient5").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDebugClient5 {
    type Vtable = IDebugClient5_Vtbl;
}
impl ::core::clone::Clone for IDebugClient5 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IDebugClient5 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xe3acb9d7_7ec2_4f0c_a0da_e81e0cbbe628);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDebugClient5_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub AttachKernel: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flags: u32, connectoptions: ::windows::core::PCSTR) -> ::windows::core::HRESULT,
    pub GetKernelConnectionOptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, buffer: ::windows::core::PSTR, buffersize: u32, optionssize: *mut u32) -> ::windows::core::HRESULT,
    pub SetKernelConnectionOptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, options: ::windows::core::PCSTR) -> ::windows::core::HRESULT,
    pub StartProcessServer: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flags: u32, options: ::windows::core::PCSTR, reserved: *const ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub ConnectProcessServer: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, remoteoptions: ::windows::core::PCSTR, server: *mut u64) -> ::windows::core::HRESULT,
    pub DisconnectProcessServer: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64) -> ::windows::core::HRESULT,
    pub GetRunningProcessSystemIds: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, ids: *mut u32, count: u32, actualcount: *mut u32) -> ::windows::core::HRESULT,
    pub GetRunningProcessSystemIdByExecutableName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, exename: ::windows::core::PCSTR, flags: u32, id: *mut u32) -> ::windows::core::HRESULT,
    pub GetRunningProcessDescription: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, systemid: u32, flags: u32, exename: ::windows::core::PSTR, exenamesize: u32, actualexenamesize: *mut u32, description: ::windows::core::PSTR, descriptionsize: u32, actualdescriptionsize: *mut u32) -> ::windows::core::HRESULT,
    pub AttachProcess: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, processid: u32, attachflags: u32) -> ::windows::core::HRESULT,
    pub CreateProcessA: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, commandline: ::windows::core::PCSTR, createflags: u32) -> ::windows::core::HRESULT,
    pub CreateProcessAndAttach: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, commandline: ::windows::core::PCSTR, createflags: u32, processid: u32, attachflags: u32) -> ::windows::core::HRESULT,
    pub GetProcessOptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, options: *mut u32) -> ::windows::core::HRESULT,
    pub AddProcessOptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, options: u32) -> ::windows::core::HRESULT,
    pub RemoveProcessOptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, options: u32) -> ::windows::core::HRESULT,
    pub SetProcessOptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, options: u32) -> ::windows::core::HRESULT,
    pub OpenDumpFile: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dumpfile: ::windows::core::PCSTR) -> ::windows::core::HRESULT,
    pub WriteDumpFile: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dumpfile: ::windows::core::PCSTR, qualifier: u32) -> ::windows::core::HRESULT,
    pub ConnectSession: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flags: u32, historylimit: u32) -> ::windows::core::HRESULT,
    pub StartServer: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, options: ::windows::core::PCSTR) -> ::windows::core::HRESULT,
    pub OutputServers: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, outputcontrol: u32, machine: ::windows::core::PCSTR, flags: u32) -> ::windows::core::HRESULT,
    pub TerminateProcesses: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub DetachProcesses: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub EndSession: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flags: u32) -> ::windows::core::HRESULT,
    pub GetExitCode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, code: *mut u32) -> ::windows::core::HRESULT,
    pub DispatchCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, timeout: u32) -> ::windows::core::HRESULT,
    pub ExitDispatch: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, client: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub CreateClient: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, client: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetInputCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, callbacks: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub SetInputCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, callbacks: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetOutputCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, callbacks: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub SetOutputCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, callbacks: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetOutputMask: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, mask: *mut u32) -> ::windows::core::HRESULT,
    pub SetOutputMask: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, mask: u32) -> ::windows::core::HRESULT,
    pub GetOtherOutputMask: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, client: *mut ::core::ffi::c_void, mask: *mut u32) -> ::windows::core::HRESULT,
    pub SetOtherOutputMask: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, client: *mut ::core::ffi::c_void, mask: u32) -> ::windows::core::HRESULT,
    pub GetOutputWidth: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, columns: *mut u32) -> ::windows::core::HRESULT,
    pub SetOutputWidth: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, columns: u32) -> ::windows::core::HRESULT,
    pub GetOutputLinePrefix: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, buffer: ::windows::core::PSTR, buffersize: u32, prefixsize: *mut u32) -> ::windows::core::HRESULT,
    pub SetOutputLinePrefix: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, prefix: ::windows::core::PCSTR) -> ::windows::core::HRESULT,
    pub GetIdentity: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, buffer: ::windows::core::PSTR, buffersize: u32, identitysize: *mut u32) -> ::windows::core::HRESULT,
    pub OutputIdentity: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, outputcontrol: u32, flags: u32, format: ::windows::core::PCSTR) -> ::windows::core::HRESULT,
    pub GetEventCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, callbacks: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub SetEventCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, callbacks: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub FlushCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub WriteDumpFile2: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dumpfile: ::windows::core::PCSTR, qualifier: u32, formatflags: u32, comment: ::windows::core::PCSTR) -> ::windows::core::HRESULT,
    pub AddDumpInformationFile: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, infofile: ::windows::core::PCSTR, r#type: u32) -> ::windows::core::HRESULT,
    pub EndProcessServer: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64) -> ::windows::core::HRESULT,
    pub WaitForProcessServerEnd: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, timeout: u32) -> ::windows::core::HRESULT,
    pub IsKernelDebuggerEnabled: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub TerminateCurrentProcess: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub DetachCurrentProcess: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub AbandonCurrentProcess: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetRunningProcessSystemIdByExecutableNameWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, exename: ::windows::core::PCWSTR, flags: u32, id: *mut u32) -> ::windows::core::HRESULT,
    pub GetRunningProcessDescriptionWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, systemid: u32, flags: u32, exename: ::windows::core::PWSTR, exenamesize: u32, actualexenamesize: *mut u32, description: ::windows::core::PWSTR, descriptionsize: u32, actualdescriptionsize: *mut u32) -> ::windows::core::HRESULT,
    pub CreateProcessWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, commandline: ::windows::core::PCWSTR, createflags: u32) -> ::windows::core::HRESULT,
    pub CreateProcessAndAttachWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, commandline: ::windows::core::PCWSTR, createflags: u32, processid: u32, attachflags: u32) -> ::windows::core::HRESULT,
    pub OpenDumpFileWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, filename: ::windows::core::PCWSTR, filehandle: u64) -> ::windows::core::HRESULT,
    pub WriteDumpFileWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, filename: ::windows::core::PCWSTR, filehandle: u64, qualifier: u32, formatflags: u32, comment: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub AddDumpInformationFileWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, filename: ::windows::core::PCWSTR, filehandle: u64, r#type: u32) -> ::windows::core::HRESULT,
    pub GetNumberDumpFiles: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, number: *mut u32) -> ::windows::core::HRESULT,
    pub GetDumpFile: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, index: u32, buffer: ::windows::core::PSTR, buffersize: u32, namesize: *mut u32, handle: *mut u64, r#type: *mut u32) -> ::windows::core::HRESULT,
    pub GetDumpFileWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, index: u32, buffer: ::windows::core::PWSTR, buffersize: u32, namesize: *mut u32, handle: *mut u64, r#type: *mut u32) -> ::windows::core::HRESULT,
    pub AttachKernelWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flags: u32, connectoptions: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub GetKernelConnectionOptionsWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, buffer: ::windows::core::PWSTR, buffersize: u32, optionssize: *mut u32) -> ::windows::core::HRESULT,
    pub SetKernelConnectionOptionsWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, options: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub StartProcessServerWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flags: u32, options: ::windows::core::PCWSTR, reserved: *const ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub ConnectProcessServerWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, remoteoptions: ::windows::core::PCWSTR, server: *mut u64) -> ::windows::core::HRESULT,
    pub StartServerWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, options: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub OutputServersWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, outputcontrol: u32, machine: ::windows::core::PCWSTR, flags: u32) -> ::windows::core::HRESULT,
    pub GetOutputCallbacksWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, callbacks: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub SetOutputCallbacksWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, callbacks: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetOutputLinePrefixWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, buffer: ::windows::core::PWSTR, buffersize: u32, prefixsize: *mut u32) -> ::windows::core::HRESULT,
    pub SetOutputLinePrefixWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, prefix: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub GetIdentityWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, buffer: ::windows::core::PWSTR, buffersize: u32, identitysize: *mut u32) -> ::windows::core::HRESULT,
    pub OutputIdentityWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, outputcontrol: u32, flags: u32, format: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub GetEventCallbacksWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, callbacks: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub SetEventCallbacksWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, callbacks: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub CreateProcess2: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, commandline: ::windows::core::PCSTR, optionsbuffer: *const ::core::ffi::c_void, optionsbuffersize: u32, initialdirectory: ::windows::core::PCSTR, environment: ::windows::core::PCSTR) -> ::windows::core::HRESULT,
    pub CreateProcess2Wide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, commandline: ::windows::core::PCWSTR, optionsbuffer: *const ::core::ffi::c_void, optionsbuffersize: u32, initialdirectory: ::windows::core::PCWSTR, environment: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub CreateProcessAndAttach2: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, commandline: ::windows::core::PCSTR, optionsbuffer: *const ::core::ffi::c_void, optionsbuffersize: u32, initialdirectory: ::windows::core::PCSTR, environment: ::windows::core::PCSTR, processid: u32, attachflags: u32) -> ::windows::core::HRESULT,
    pub CreateProcessAndAttach2Wide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, commandline: ::windows::core::PCWSTR, optionsbuffer: *const ::core::ffi::c_void, optionsbuffersize: u32, initialdirectory: ::windows::core::PCWSTR, environment: ::windows::core::PCWSTR, processid: u32, attachflags: u32) -> ::windows::core::HRESULT,
    pub PushOutputLinePrefix: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, newprefix: ::windows::core::PCSTR, handle: *mut u64) -> ::windows::core::HRESULT,
    pub PushOutputLinePrefixWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, newprefix: ::windows::core::PCWSTR, handle: *mut u64) -> ::windows::core::HRESULT,
    pub PopOutputLinePrefix: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, handle: u64) -> ::windows::core::HRESULT,
    pub GetNumberInputCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, count: *mut u32) -> ::windows::core::HRESULT,
    pub GetNumberOutputCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, count: *mut u32) -> ::windows::core::HRESULT,
    pub GetNumberEventCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, eventflags: u32, count: *mut u32) -> ::windows::core::HRESULT,
    pub GetQuitLockString: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, buffer: ::windows::core::PSTR, buffersize: u32, stringsize: *mut u32) -> ::windows::core::HRESULT,
    pub SetQuitLockString: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, string: ::windows::core::PCSTR) -> ::windows::core::HRESULT,
    pub GetQuitLockStringWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, buffer: ::windows::core::PWSTR, buffersize: u32, stringsize: *mut u32) -> ::windows::core::HRESULT,
    pub SetQuitLockStringWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, string: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IDebugClient6(::windows::core::IUnknown);
impl IDebugClient6 {
    pub unsafe fn AttachKernel<P0>(&self, flags: u32, connectoptions: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).AttachKernel)(::windows::core::Interface::as_raw(self), flags, connectoptions.into_param().abi()).ok()
    }
    pub unsafe fn GetKernelConnectionOptions(&self, buffer: ::core::option::Option<&mut [u8]>, optionssize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetKernelConnectionOptions)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(optionssize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetKernelConnectionOptions<P0>(&self, options: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).SetKernelConnectionOptions)(::windows::core::Interface::as_raw(self), options.into_param().abi()).ok()
    }
    pub unsafe fn StartProcessServer<P0>(&self, flags: u32, options: P0, reserved: ::core::option::Option<*const ::core::ffi::c_void>) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).StartProcessServer)(::windows::core::Interface::as_raw(self), flags, options.into_param().abi(), ::core::mem::transmute(reserved.unwrap_or(::std::ptr::null()))).ok()
    }
    pub unsafe fn ConnectProcessServer<P0>(&self, remoteoptions: P0) -> ::windows::core::Result<u64>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        let mut result__ = ::windows::core::zeroed::<u64>();
        (::windows::core::Interface::vtable(self).ConnectProcessServer)(::windows::core::Interface::as_raw(self), remoteoptions.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn DisconnectProcessServer(&self, server: u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).DisconnectProcessServer)(::windows::core::Interface::as_raw(self), server).ok()
    }
    pub unsafe fn GetRunningProcessSystemIds(&self, server: u64, ids: ::core::option::Option<&mut [u32]>, actualcount: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetRunningProcessSystemIds)(::windows::core::Interface::as_raw(self), server, ::core::mem::transmute(ids.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), ids.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(actualcount.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetRunningProcessSystemIdByExecutableName<P0>(&self, server: u64, exename: P0, flags: u32) -> ::windows::core::Result<u32>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetRunningProcessSystemIdByExecutableName)(::windows::core::Interface::as_raw(self), server, exename.into_param().abi(), flags, &mut result__).from_abi(result__)
    }
    pub unsafe fn GetRunningProcessDescription(&self, server: u64, systemid: u32, flags: u32, exename: ::core::option::Option<&mut [u8]>, actualexenamesize: ::core::option::Option<*mut u32>, description: ::core::option::Option<&mut [u8]>, actualdescriptionsize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetRunningProcessDescription)(
            ::windows::core::Interface::as_raw(self),
            server,
            systemid,
            flags,
            ::core::mem::transmute(exename.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
            exename.as_deref().map_or(0, |slice| slice.len() as _),
            ::core::mem::transmute(actualexenamesize.unwrap_or(::std::ptr::null_mut())),
            ::core::mem::transmute(description.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
            description.as_deref().map_or(0, |slice| slice.len() as _),
            ::core::mem::transmute(actualdescriptionsize.unwrap_or(::std::ptr::null_mut())),
        )
        .ok()
    }
    pub unsafe fn AttachProcess(&self, server: u64, processid: u32, attachflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).AttachProcess)(::windows::core::Interface::as_raw(self), server, processid, attachflags).ok()
    }
    pub unsafe fn CreateProcessA<P0>(&self, server: u64, commandline: P0, createflags: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).CreateProcessA)(::windows::core::Interface::as_raw(self), server, commandline.into_param().abi(), createflags).ok()
    }
    pub unsafe fn CreateProcessAndAttach<P0>(&self, server: u64, commandline: P0, createflags: u32, processid: u32, attachflags: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).CreateProcessAndAttach)(::windows::core::Interface::as_raw(self), server, commandline.into_param().abi(), createflags, processid, attachflags).ok()
    }
    pub unsafe fn GetProcessOptions(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetProcessOptions)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn AddProcessOptions(&self, options: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).AddProcessOptions)(::windows::core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn RemoveProcessOptions(&self, options: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).RemoveProcessOptions)(::windows::core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn SetProcessOptions(&self, options: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetProcessOptions)(::windows::core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn OpenDumpFile<P0>(&self, dumpfile: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).OpenDumpFile)(::windows::core::Interface::as_raw(self), dumpfile.into_param().abi()).ok()
    }
    pub unsafe fn WriteDumpFile<P0>(&self, dumpfile: P0, qualifier: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).WriteDumpFile)(::windows::core::Interface::as_raw(self), dumpfile.into_param().abi(), qualifier).ok()
    }
    pub unsafe fn ConnectSession(&self, flags: u32, historylimit: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).ConnectSession)(::windows::core::Interface::as_raw(self), flags, historylimit).ok()
    }
    pub unsafe fn StartServer<P0>(&self, options: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).StartServer)(::windows::core::Interface::as_raw(self), options.into_param().abi()).ok()
    }
    pub unsafe fn OutputServers<P0>(&self, outputcontrol: u32, machine: P0, flags: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).OutputServers)(::windows::core::Interface::as_raw(self), outputcontrol, machine.into_param().abi(), flags).ok()
    }
    pub unsafe fn TerminateProcesses(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).TerminateProcesses)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn DetachProcesses(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).DetachProcesses)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn EndSession(&self, flags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).EndSession)(::windows::core::Interface::as_raw(self), flags).ok()
    }
    pub unsafe fn GetExitCode(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetExitCode)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn DispatchCallbacks(&self, timeout: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).DispatchCallbacks)(::windows::core::Interface::as_raw(self), timeout).ok()
    }
    pub unsafe fn ExitDispatch<P0>(&self, client: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugClient>,
    {
        (::windows::core::Interface::vtable(self).ExitDispatch)(::windows::core::Interface::as_raw(self), client.into_param().abi()).ok()
    }
    pub unsafe fn CreateClient(&self) -> ::windows::core::Result<IDebugClient> {
        let mut result__ = ::windows::core::zeroed::<IDebugClient>();
        (::windows::core::Interface::vtable(self).CreateClient)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetInputCallbacks(&self) -> ::windows::core::Result<IDebugInputCallbacks> {
        let mut result__ = ::windows::core::zeroed::<IDebugInputCallbacks>();
        (::windows::core::Interface::vtable(self).GetInputCallbacks)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetInputCallbacks<P0>(&self, callbacks: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugInputCallbacks>,
    {
        (::windows::core::Interface::vtable(self).SetInputCallbacks)(::windows::core::Interface::as_raw(self), callbacks.into_param().abi()).ok()
    }
    pub unsafe fn GetOutputCallbacks(&self) -> ::windows::core::Result<IDebugOutputCallbacks> {
        let mut result__ = ::windows::core::zeroed::<IDebugOutputCallbacks>();
        (::windows::core::Interface::vtable(self).GetOutputCallbacks)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetOutputCallbacks<P0>(&self, callbacks: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugOutputCallbacks>,
    {
        (::windows::core::Interface::vtable(self).SetOutputCallbacks)(::windows::core::Interface::as_raw(self), callbacks.into_param().abi()).ok()
    }
    pub unsafe fn GetOutputMask(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetOutputMask)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetOutputMask(&self, mask: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetOutputMask)(::windows::core::Interface::as_raw(self), mask).ok()
    }
    pub unsafe fn GetOtherOutputMask<P0>(&self, client: P0) -> ::windows::core::Result<u32>
    where
        P0: ::windows::core::IntoParam<IDebugClient>,
    {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetOtherOutputMask)(::windows::core::Interface::as_raw(self), client.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetOtherOutputMask<P0>(&self, client: P0, mask: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugClient>,
    {
        (::windows::core::Interface::vtable(self).SetOtherOutputMask)(::windows::core::Interface::as_raw(self), client.into_param().abi(), mask).ok()
    }
    pub unsafe fn GetOutputWidth(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetOutputWidth)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetOutputWidth(&self, columns: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetOutputWidth)(::windows::core::Interface::as_raw(self), columns).ok()
    }
    pub unsafe fn GetOutputLinePrefix(&self, buffer: ::core::option::Option<&mut [u8]>, prefixsize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetOutputLinePrefix)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(prefixsize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetOutputLinePrefix<P0>(&self, prefix: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).SetOutputLinePrefix)(::windows::core::Interface::as_raw(self), prefix.into_param().abi()).ok()
    }
    pub unsafe fn GetIdentity(&self, buffer: ::core::option::Option<&mut [u8]>, identitysize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetIdentity)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(identitysize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn OutputIdentity<P0>(&self, outputcontrol: u32, flags: u32, format: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).OutputIdentity)(::windows::core::Interface::as_raw(self), outputcontrol, flags, format.into_param().abi()).ok()
    }
    pub unsafe fn GetEventCallbacks(&self) -> ::windows::core::Result<IDebugEventCallbacks> {
        let mut result__ = ::windows::core::zeroed::<IDebugEventCallbacks>();
        (::windows::core::Interface::vtable(self).GetEventCallbacks)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetEventCallbacks<P0>(&self, callbacks: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugEventCallbacks>,
    {
        (::windows::core::Interface::vtable(self).SetEventCallbacks)(::windows::core::Interface::as_raw(self), callbacks.into_param().abi()).ok()
    }
    pub unsafe fn FlushCallbacks(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).FlushCallbacks)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn WriteDumpFile2<P0, P1>(&self, dumpfile: P0, qualifier: u32, formatflags: u32, comment: P1) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
        P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).WriteDumpFile2)(::windows::core::Interface::as_raw(self), dumpfile.into_param().abi(), qualifier, formatflags, comment.into_param().abi()).ok()
    }
    pub unsafe fn AddDumpInformationFile<P0>(&self, infofile: P0, r#type: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).AddDumpInformationFile)(::windows::core::Interface::as_raw(self), infofile.into_param().abi(), r#type).ok()
    }
    pub unsafe fn EndProcessServer(&self, server: u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).EndProcessServer)(::windows::core::Interface::as_raw(self), server).ok()
    }
    pub unsafe fn WaitForProcessServerEnd(&self, timeout: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).WaitForProcessServerEnd)(::windows::core::Interface::as_raw(self), timeout).ok()
    }
    pub unsafe fn IsKernelDebuggerEnabled(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).IsKernelDebuggerEnabled)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn TerminateCurrentProcess(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).TerminateCurrentProcess)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn DetachCurrentProcess(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).DetachCurrentProcess)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn AbandonCurrentProcess(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).AbandonCurrentProcess)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetRunningProcessSystemIdByExecutableNameWide<P0>(&self, server: u64, exename: P0, flags: u32) -> ::windows::core::Result<u32>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetRunningProcessSystemIdByExecutableNameWide)(::windows::core::Interface::as_raw(self), server, exename.into_param().abi(), flags, &mut result__).from_abi(result__)
    }
    pub unsafe fn GetRunningProcessDescriptionWide(&self, server: u64, systemid: u32, flags: u32, exename: ::core::option::Option<&mut [u16]>, actualexenamesize: ::core::option::Option<*mut u32>, description: ::core::option::Option<&mut [u16]>, actualdescriptionsize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetRunningProcessDescriptionWide)(
            ::windows::core::Interface::as_raw(self),
            server,
            systemid,
            flags,
            ::core::mem::transmute(exename.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
            exename.as_deref().map_or(0, |slice| slice.len() as _),
            ::core::mem::transmute(actualexenamesize.unwrap_or(::std::ptr::null_mut())),
            ::core::mem::transmute(description.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
            description.as_deref().map_or(0, |slice| slice.len() as _),
            ::core::mem::transmute(actualdescriptionsize.unwrap_or(::std::ptr::null_mut())),
        )
        .ok()
    }
    pub unsafe fn CreateProcessWide<P0>(&self, server: u64, commandline: P0, createflags: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).CreateProcessWide)(::windows::core::Interface::as_raw(self), server, commandline.into_param().abi(), createflags).ok()
    }
    pub unsafe fn CreateProcessAndAttachWide<P0>(&self, server: u64, commandline: P0, createflags: u32, processid: u32, attachflags: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).CreateProcessAndAttachWide)(::windows::core::Interface::as_raw(self), server, commandline.into_param().abi(), createflags, processid, attachflags).ok()
    }
    pub unsafe fn OpenDumpFileWide<P0>(&self, filename: P0, filehandle: u64) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).OpenDumpFileWide)(::windows::core::Interface::as_raw(self), filename.into_param().abi(), filehandle).ok()
    }
    pub unsafe fn WriteDumpFileWide<P0, P1>(&self, filename: P0, filehandle: u64, qualifier: u32, formatflags: u32, comment: P1) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).WriteDumpFileWide)(::windows::core::Interface::as_raw(self), filename.into_param().abi(), filehandle, qualifier, formatflags, comment.into_param().abi()).ok()
    }
    pub unsafe fn AddDumpInformationFileWide<P0>(&self, filename: P0, filehandle: u64, r#type: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).AddDumpInformationFileWide)(::windows::core::Interface::as_raw(self), filename.into_param().abi(), filehandle, r#type).ok()
    }
    pub unsafe fn GetNumberDumpFiles(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetNumberDumpFiles)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetDumpFile(&self, index: u32, buffer: ::core::option::Option<&mut [u8]>, namesize: ::core::option::Option<*mut u32>, handle: ::core::option::Option<*mut u64>, r#type: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetDumpFile)(::windows::core::Interface::as_raw(self), index, ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(namesize.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(handle.unwrap_or(::std::ptr::null_mut())), r#type).ok()
    }
    pub unsafe fn GetDumpFileWide(&self, index: u32, buffer: ::core::option::Option<&mut [u16]>, namesize: ::core::option::Option<*mut u32>, handle: ::core::option::Option<*mut u64>, r#type: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetDumpFileWide)(::windows::core::Interface::as_raw(self), index, ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(namesize.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(handle.unwrap_or(::std::ptr::null_mut())), r#type).ok()
    }
    pub unsafe fn AttachKernelWide<P0>(&self, flags: u32, connectoptions: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).AttachKernelWide)(::windows::core::Interface::as_raw(self), flags, connectoptions.into_param().abi()).ok()
    }
    pub unsafe fn GetKernelConnectionOptionsWide(&self, buffer: ::core::option::Option<&mut [u16]>, optionssize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetKernelConnectionOptionsWide)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(optionssize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetKernelConnectionOptionsWide<P0>(&self, options: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).SetKernelConnectionOptionsWide)(::windows::core::Interface::as_raw(self), options.into_param().abi()).ok()
    }
    pub unsafe fn StartProcessServerWide<P0>(&self, flags: u32, options: P0, reserved: ::core::option::Option<*const ::core::ffi::c_void>) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).StartProcessServerWide)(::windows::core::Interface::as_raw(self), flags, options.into_param().abi(), ::core::mem::transmute(reserved.unwrap_or(::std::ptr::null()))).ok()
    }
    pub unsafe fn ConnectProcessServerWide<P0>(&self, remoteoptions: P0) -> ::windows::core::Result<u64>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        let mut result__ = ::windows::core::zeroed::<u64>();
        (::windows::core::Interface::vtable(self).ConnectProcessServerWide)(::windows::core::Interface::as_raw(self), remoteoptions.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn StartServerWide<P0>(&self, options: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).StartServerWide)(::windows::core::Interface::as_raw(self), options.into_param().abi()).ok()
    }
    pub unsafe fn OutputServersWide<P0>(&self, outputcontrol: u32, machine: P0, flags: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).OutputServersWide)(::windows::core::Interface::as_raw(self), outputcontrol, machine.into_param().abi(), flags).ok()
    }
    pub unsafe fn GetOutputCallbacksWide(&self) -> ::windows::core::Result<IDebugOutputCallbacksWide> {
        let mut result__ = ::windows::core::zeroed::<IDebugOutputCallbacksWide>();
        (::windows::core::Interface::vtable(self).GetOutputCallbacksWide)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetOutputCallbacksWide<P0>(&self, callbacks: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugOutputCallbacksWide>,
    {
        (::windows::core::Interface::vtable(self).SetOutputCallbacksWide)(::windows::core::Interface::as_raw(self), callbacks.into_param().abi()).ok()
    }
    pub unsafe fn GetOutputLinePrefixWide(&self, buffer: ::core::option::Option<&mut [u16]>, prefixsize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetOutputLinePrefixWide)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(prefixsize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetOutputLinePrefixWide<P0>(&self, prefix: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).SetOutputLinePrefixWide)(::windows::core::Interface::as_raw(self), prefix.into_param().abi()).ok()
    }
    pub unsafe fn GetIdentityWide(&self, buffer: ::core::option::Option<&mut [u16]>, identitysize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetIdentityWide)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(identitysize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn OutputIdentityWide<P0>(&self, outputcontrol: u32, flags: u32, format: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).OutputIdentityWide)(::windows::core::Interface::as_raw(self), outputcontrol, flags, format.into_param().abi()).ok()
    }
    pub unsafe fn GetEventCallbacksWide(&self) -> ::windows::core::Result<IDebugEventCallbacksWide> {
        let mut result__ = ::windows::core::zeroed::<IDebugEventCallbacksWide>();
        (::windows::core::Interface::vtable(self).GetEventCallbacksWide)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetEventCallbacksWide<P0>(&self, callbacks: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugEventCallbacksWide>,
    {
        (::windows::core::Interface::vtable(self).SetEventCallbacksWide)(::windows::core::Interface::as_raw(self), callbacks.into_param().abi()).ok()
    }
    pub unsafe fn CreateProcess2<P0, P1, P2>(&self, server: u64, commandline: P0, optionsbuffer: *const ::core::ffi::c_void, optionsbuffersize: u32, initialdirectory: P1, environment: P2) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
        P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
        P2: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).CreateProcess2)(::windows::core::Interface::as_raw(self), server, commandline.into_param().abi(), optionsbuffer, optionsbuffersize, initialdirectory.into_param().abi(), environment.into_param().abi()).ok()
    }
    pub unsafe fn CreateProcess2Wide<P0, P1, P2>(&self, server: u64, commandline: P0, optionsbuffer: *const ::core::ffi::c_void, optionsbuffersize: u32, initialdirectory: P1, environment: P2) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P2: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).CreateProcess2Wide)(::windows::core::Interface::as_raw(self), server, commandline.into_param().abi(), optionsbuffer, optionsbuffersize, initialdirectory.into_param().abi(), environment.into_param().abi()).ok()
    }
    pub unsafe fn CreateProcessAndAttach2<P0, P1, P2>(&self, server: u64, commandline: P0, optionsbuffer: *const ::core::ffi::c_void, optionsbuffersize: u32, initialdirectory: P1, environment: P2, processid: u32, attachflags: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
        P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
        P2: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).CreateProcessAndAttach2)(::windows::core::Interface::as_raw(self), server, commandline.into_param().abi(), optionsbuffer, optionsbuffersize, initialdirectory.into_param().abi(), environment.into_param().abi(), processid, attachflags).ok()
    }
    pub unsafe fn CreateProcessAndAttach2Wide<P0, P1, P2>(&self, server: u64, commandline: P0, optionsbuffer: *const ::core::ffi::c_void, optionsbuffersize: u32, initialdirectory: P1, environment: P2, processid: u32, attachflags: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P2: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).CreateProcessAndAttach2Wide)(::windows::core::Interface::as_raw(self), server, commandline.into_param().abi(), optionsbuffer, optionsbuffersize, initialdirectory.into_param().abi(), environment.into_param().abi(), processid, attachflags).ok()
    }
    pub unsafe fn PushOutputLinePrefix<P0>(&self, newprefix: P0) -> ::windows::core::Result<u64>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        let mut result__ = ::windows::core::zeroed::<u64>();
        (::windows::core::Interface::vtable(self).PushOutputLinePrefix)(::windows::core::Interface::as_raw(self), newprefix.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn PushOutputLinePrefixWide<P0>(&self, newprefix: P0) -> ::windows::core::Result<u64>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        let mut result__ = ::windows::core::zeroed::<u64>();
        (::windows::core::Interface::vtable(self).PushOutputLinePrefixWide)(::windows::core::Interface::as_raw(self), newprefix.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn PopOutputLinePrefix(&self, handle: u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).PopOutputLinePrefix)(::windows::core::Interface::as_raw(self), handle).ok()
    }
    pub unsafe fn GetNumberInputCallbacks(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetNumberInputCallbacks)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetNumberOutputCallbacks(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetNumberOutputCallbacks)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetNumberEventCallbacks(&self, eventflags: u32) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetNumberEventCallbacks)(::windows::core::Interface::as_raw(self), eventflags, &mut result__).from_abi(result__)
    }
    pub unsafe fn GetQuitLockString(&self, buffer: ::core::option::Option<&mut [u8]>, stringsize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetQuitLockString)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(stringsize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetQuitLockString<P0>(&self, string: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).SetQuitLockString)(::windows::core::Interface::as_raw(self), string.into_param().abi()).ok()
    }
    pub unsafe fn GetQuitLockStringWide(&self, buffer: ::core::option::Option<&mut [u16]>, stringsize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetQuitLockStringWide)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(stringsize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetQuitLockStringWide<P0>(&self, string: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).SetQuitLockStringWide)(::windows::core::Interface::as_raw(self), string.into_param().abi()).ok()
    }
    pub unsafe fn SetEventContextCallbacks<P0>(&self, callbacks: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugEventContextCallbacks>,
    {
        (::windows::core::Interface::vtable(self).SetEventContextCallbacks)(::windows::core::Interface::as_raw(self), callbacks.into_param().abi()).ok()
    }
}
::windows::imp::interface_hierarchy!(IDebugClient6, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IDebugClient6 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDebugClient6 {}
impl ::core::fmt::Debug for IDebugClient6 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDebugClient6").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDebugClient6 {
    type Vtable = IDebugClient6_Vtbl;
}
impl ::core::clone::Clone for IDebugClient6 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IDebugClient6 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xfd28b4c5_c498_4686_a28e_62cad2154eb3);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDebugClient6_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub AttachKernel: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flags: u32, connectoptions: ::windows::core::PCSTR) -> ::windows::core::HRESULT,
    pub GetKernelConnectionOptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, buffer: ::windows::core::PSTR, buffersize: u32, optionssize: *mut u32) -> ::windows::core::HRESULT,
    pub SetKernelConnectionOptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, options: ::windows::core::PCSTR) -> ::windows::core::HRESULT,
    pub StartProcessServer: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flags: u32, options: ::windows::core::PCSTR, reserved: *const ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub ConnectProcessServer: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, remoteoptions: ::windows::core::PCSTR, server: *mut u64) -> ::windows::core::HRESULT,
    pub DisconnectProcessServer: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64) -> ::windows::core::HRESULT,
    pub GetRunningProcessSystemIds: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, ids: *mut u32, count: u32, actualcount: *mut u32) -> ::windows::core::HRESULT,
    pub GetRunningProcessSystemIdByExecutableName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, exename: ::windows::core::PCSTR, flags: u32, id: *mut u32) -> ::windows::core::HRESULT,
    pub GetRunningProcessDescription: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, systemid: u32, flags: u32, exename: ::windows::core::PSTR, exenamesize: u32, actualexenamesize: *mut u32, description: ::windows::core::PSTR, descriptionsize: u32, actualdescriptionsize: *mut u32) -> ::windows::core::HRESULT,
    pub AttachProcess: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, processid: u32, attachflags: u32) -> ::windows::core::HRESULT,
    pub CreateProcessA: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, commandline: ::windows::core::PCSTR, createflags: u32) -> ::windows::core::HRESULT,
    pub CreateProcessAndAttach: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, commandline: ::windows::core::PCSTR, createflags: u32, processid: u32, attachflags: u32) -> ::windows::core::HRESULT,
    pub GetProcessOptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, options: *mut u32) -> ::windows::core::HRESULT,
    pub AddProcessOptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, options: u32) -> ::windows::core::HRESULT,
    pub RemoveProcessOptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, options: u32) -> ::windows::core::HRESULT,
    pub SetProcessOptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, options: u32) -> ::windows::core::HRESULT,
    pub OpenDumpFile: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dumpfile: ::windows::core::PCSTR) -> ::windows::core::HRESULT,
    pub WriteDumpFile: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dumpfile: ::windows::core::PCSTR, qualifier: u32) -> ::windows::core::HRESULT,
    pub ConnectSession: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flags: u32, historylimit: u32) -> ::windows::core::HRESULT,
    pub StartServer: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, options: ::windows::core::PCSTR) -> ::windows::core::HRESULT,
    pub OutputServers: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, outputcontrol: u32, machine: ::windows::core::PCSTR, flags: u32) -> ::windows::core::HRESULT,
    pub TerminateProcesses: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub DetachProcesses: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub EndSession: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flags: u32) -> ::windows::core::HRESULT,
    pub GetExitCode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, code: *mut u32) -> ::windows::core::HRESULT,
    pub DispatchCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, timeout: u32) -> ::windows::core::HRESULT,
    pub ExitDispatch: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, client: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub CreateClient: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, client: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetInputCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, callbacks: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub SetInputCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, callbacks: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetOutputCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, callbacks: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub SetOutputCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, callbacks: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetOutputMask: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, mask: *mut u32) -> ::windows::core::HRESULT,
    pub SetOutputMask: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, mask: u32) -> ::windows::core::HRESULT,
    pub GetOtherOutputMask: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, client: *mut ::core::ffi::c_void, mask: *mut u32) -> ::windows::core::HRESULT,
    pub SetOtherOutputMask: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, client: *mut ::core::ffi::c_void, mask: u32) -> ::windows::core::HRESULT,
    pub GetOutputWidth: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, columns: *mut u32) -> ::windows::core::HRESULT,
    pub SetOutputWidth: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, columns: u32) -> ::windows::core::HRESULT,
    pub GetOutputLinePrefix: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, buffer: ::windows::core::PSTR, buffersize: u32, prefixsize: *mut u32) -> ::windows::core::HRESULT,
    pub SetOutputLinePrefix: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, prefix: ::windows::core::PCSTR) -> ::windows::core::HRESULT,
    pub GetIdentity: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, buffer: ::windows::core::PSTR, buffersize: u32, identitysize: *mut u32) -> ::windows::core::HRESULT,
    pub OutputIdentity: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, outputcontrol: u32, flags: u32, format: ::windows::core::PCSTR) -> ::windows::core::HRESULT,
    pub GetEventCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, callbacks: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub SetEventCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, callbacks: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub FlushCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub WriteDumpFile2: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dumpfile: ::windows::core::PCSTR, qualifier: u32, formatflags: u32, comment: ::windows::core::PCSTR) -> ::windows::core::HRESULT,
    pub AddDumpInformationFile: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, infofile: ::windows::core::PCSTR, r#type: u32) -> ::windows::core::HRESULT,
    pub EndProcessServer: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64) -> ::windows::core::HRESULT,
    pub WaitForProcessServerEnd: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, timeout: u32) -> ::windows::core::HRESULT,
    pub IsKernelDebuggerEnabled: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub TerminateCurrentProcess: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub DetachCurrentProcess: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub AbandonCurrentProcess: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetRunningProcessSystemIdByExecutableNameWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, exename: ::windows::core::PCWSTR, flags: u32, id: *mut u32) -> ::windows::core::HRESULT,
    pub GetRunningProcessDescriptionWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, systemid: u32, flags: u32, exename: ::windows::core::PWSTR, exenamesize: u32, actualexenamesize: *mut u32, description: ::windows::core::PWSTR, descriptionsize: u32, actualdescriptionsize: *mut u32) -> ::windows::core::HRESULT,
    pub CreateProcessWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, commandline: ::windows::core::PCWSTR, createflags: u32) -> ::windows::core::HRESULT,
    pub CreateProcessAndAttachWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, commandline: ::windows::core::PCWSTR, createflags: u32, processid: u32, attachflags: u32) -> ::windows::core::HRESULT,
    pub OpenDumpFileWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, filename: ::windows::core::PCWSTR, filehandle: u64) -> ::windows::core::HRESULT,
    pub WriteDumpFileWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, filename: ::windows::core::PCWSTR, filehandle: u64, qualifier: u32, formatflags: u32, comment: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub AddDumpInformationFileWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, filename: ::windows::core::PCWSTR, filehandle: u64, r#type: u32) -> ::windows::core::HRESULT,
    pub GetNumberDumpFiles: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, number: *mut u32) -> ::windows::core::HRESULT,
    pub GetDumpFile: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, index: u32, buffer: ::windows::core::PSTR, buffersize: u32, namesize: *mut u32, handle: *mut u64, r#type: *mut u32) -> ::windows::core::HRESULT,
    pub GetDumpFileWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, index: u32, buffer: ::windows::core::PWSTR, buffersize: u32, namesize: *mut u32, handle: *mut u64, r#type: *mut u32) -> ::windows::core::HRESULT,
    pub AttachKernelWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flags: u32, connectoptions: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub GetKernelConnectionOptionsWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, buffer: ::windows::core::PWSTR, buffersize: u32, optionssize: *mut u32) -> ::windows::core::HRESULT,
    pub SetKernelConnectionOptionsWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, options: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub StartProcessServerWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flags: u32, options: ::windows::core::PCWSTR, reserved: *const ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub ConnectProcessServerWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, remoteoptions: ::windows::core::PCWSTR, server: *mut u64) -> ::windows::core::HRESULT,
    pub StartServerWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, options: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub OutputServersWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, outputcontrol: u32, machine: ::windows::core::PCWSTR, flags: u32) -> ::windows::core::HRESULT,
    pub GetOutputCallbacksWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, callbacks: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub SetOutputCallbacksWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, callbacks: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetOutputLinePrefixWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, buffer: ::windows::core::PWSTR, buffersize: u32, prefixsize: *mut u32) -> ::windows::core::HRESULT,
    pub SetOutputLinePrefixWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, prefix: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub GetIdentityWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, buffer: ::windows::core::PWSTR, buffersize: u32, identitysize: *mut u32) -> ::windows::core::HRESULT,
    pub OutputIdentityWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, outputcontrol: u32, flags: u32, format: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub GetEventCallbacksWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, callbacks: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub SetEventCallbacksWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, callbacks: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub CreateProcess2: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, commandline: ::windows::core::PCSTR, optionsbuffer: *const ::core::ffi::c_void, optionsbuffersize: u32, initialdirectory: ::windows::core::PCSTR, environment: ::windows::core::PCSTR) -> ::windows::core::HRESULT,
    pub CreateProcess2Wide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, commandline: ::windows::core::PCWSTR, optionsbuffer: *const ::core::ffi::c_void, optionsbuffersize: u32, initialdirectory: ::windows::core::PCWSTR, environment: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub CreateProcessAndAttach2: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, commandline: ::windows::core::PCSTR, optionsbuffer: *const ::core::ffi::c_void, optionsbuffersize: u32, initialdirectory: ::windows::core::PCSTR, environment: ::windows::core::PCSTR, processid: u32, attachflags: u32) -> ::windows::core::HRESULT,
    pub CreateProcessAndAttach2Wide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, commandline: ::windows::core::PCWSTR, optionsbuffer: *const ::core::ffi::c_void, optionsbuffersize: u32, initialdirectory: ::windows::core::PCWSTR, environment: ::windows::core::PCWSTR, processid: u32, attachflags: u32) -> ::windows::core::HRESULT,
    pub PushOutputLinePrefix: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, newprefix: ::windows::core::PCSTR, handle: *mut u64) -> ::windows::core::HRESULT,
    pub PushOutputLinePrefixWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, newprefix: ::windows::core::PCWSTR, handle: *mut u64) -> ::windows::core::HRESULT,
    pub PopOutputLinePrefix: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, handle: u64) -> ::windows::core::HRESULT,
    pub GetNumberInputCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, count: *mut u32) -> ::windows::core::HRESULT,
    pub GetNumberOutputCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, count: *mut u32) -> ::windows::core::HRESULT,
    pub GetNumberEventCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, eventflags: u32, count: *mut u32) -> ::windows::core::HRESULT,
    pub GetQuitLockString: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, buffer: ::windows::core::PSTR, buffersize: u32, stringsize: *mut u32) -> ::windows::core::HRESULT,
    pub SetQuitLockString: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, string: ::windows::core::PCSTR) -> ::windows::core::HRESULT,
    pub GetQuitLockStringWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, buffer: ::windows::core::PWSTR, buffersize: u32, stringsize: *mut u32) -> ::windows::core::HRESULT,
    pub SetQuitLockStringWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, string: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub SetEventContextCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, callbacks: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IDebugClient7(::windows::core::IUnknown);
impl IDebugClient7 {
    pub unsafe fn AttachKernel<P0>(&self, flags: u32, connectoptions: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).AttachKernel)(::windows::core::Interface::as_raw(self), flags, connectoptions.into_param().abi()).ok()
    }
    pub unsafe fn GetKernelConnectionOptions(&self, buffer: ::core::option::Option<&mut [u8]>, optionssize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetKernelConnectionOptions)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(optionssize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetKernelConnectionOptions<P0>(&self, options: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).SetKernelConnectionOptions)(::windows::core::Interface::as_raw(self), options.into_param().abi()).ok()
    }
    pub unsafe fn StartProcessServer<P0>(&self, flags: u32, options: P0, reserved: ::core::option::Option<*const ::core::ffi::c_void>) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).StartProcessServer)(::windows::core::Interface::as_raw(self), flags, options.into_param().abi(), ::core::mem::transmute(reserved.unwrap_or(::std::ptr::null()))).ok()
    }
    pub unsafe fn ConnectProcessServer<P0>(&self, remoteoptions: P0) -> ::windows::core::Result<u64>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        let mut result__ = ::windows::core::zeroed::<u64>();
        (::windows::core::Interface::vtable(self).ConnectProcessServer)(::windows::core::Interface::as_raw(self), remoteoptions.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn DisconnectProcessServer(&self, server: u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).DisconnectProcessServer)(::windows::core::Interface::as_raw(self), server).ok()
    }
    pub unsafe fn GetRunningProcessSystemIds(&self, server: u64, ids: ::core::option::Option<&mut [u32]>, actualcount: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetRunningProcessSystemIds)(::windows::core::Interface::as_raw(self), server, ::core::mem::transmute(ids.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), ids.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(actualcount.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetRunningProcessSystemIdByExecutableName<P0>(&self, server: u64, exename: P0, flags: u32) -> ::windows::core::Result<u32>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetRunningProcessSystemIdByExecutableName)(::windows::core::Interface::as_raw(self), server, exename.into_param().abi(), flags, &mut result__).from_abi(result__)
    }
    pub unsafe fn GetRunningProcessDescription(&self, server: u64, systemid: u32, flags: u32, exename: ::core::option::Option<&mut [u8]>, actualexenamesize: ::core::option::Option<*mut u32>, description: ::core::option::Option<&mut [u8]>, actualdescriptionsize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetRunningProcessDescription)(
            ::windows::core::Interface::as_raw(self),
            server,
            systemid,
            flags,
            ::core::mem::transmute(exename.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
            exename.as_deref().map_or(0, |slice| slice.len() as _),
            ::core::mem::transmute(actualexenamesize.unwrap_or(::std::ptr::null_mut())),
            ::core::mem::transmute(description.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
            description.as_deref().map_or(0, |slice| slice.len() as _),
            ::core::mem::transmute(actualdescriptionsize.unwrap_or(::std::ptr::null_mut())),
        )
        .ok()
    }
    pub unsafe fn AttachProcess(&self, server: u64, processid: u32, attachflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).AttachProcess)(::windows::core::Interface::as_raw(self), server, processid, attachflags).ok()
    }
    pub unsafe fn CreateProcessA<P0>(&self, server: u64, commandline: P0, createflags: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).CreateProcessA)(::windows::core::Interface::as_raw(self), server, commandline.into_param().abi(), createflags).ok()
    }
    pub unsafe fn CreateProcessAndAttach<P0>(&self, server: u64, commandline: P0, createflags: u32, processid: u32, attachflags: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).CreateProcessAndAttach)(::windows::core::Interface::as_raw(self), server, commandline.into_param().abi(), createflags, processid, attachflags).ok()
    }
    pub unsafe fn GetProcessOptions(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetProcessOptions)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn AddProcessOptions(&self, options: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).AddProcessOptions)(::windows::core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn RemoveProcessOptions(&self, options: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).RemoveProcessOptions)(::windows::core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn SetProcessOptions(&self, options: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetProcessOptions)(::windows::core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn OpenDumpFile<P0>(&self, dumpfile: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).OpenDumpFile)(::windows::core::Interface::as_raw(self), dumpfile.into_param().abi()).ok()
    }
    pub unsafe fn WriteDumpFile<P0>(&self, dumpfile: P0, qualifier: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).WriteDumpFile)(::windows::core::Interface::as_raw(self), dumpfile.into_param().abi(), qualifier).ok()
    }
    pub unsafe fn ConnectSession(&self, flags: u32, historylimit: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).ConnectSession)(::windows::core::Interface::as_raw(self), flags, historylimit).ok()
    }
    pub unsafe fn StartServer<P0>(&self, options: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).StartServer)(::windows::core::Interface::as_raw(self), options.into_param().abi()).ok()
    }
    pub unsafe fn OutputServers<P0>(&self, outputcontrol: u32, machine: P0, flags: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).OutputServers)(::windows::core::Interface::as_raw(self), outputcontrol, machine.into_param().abi(), flags).ok()
    }
    pub unsafe fn TerminateProcesses(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).TerminateProcesses)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn DetachProcesses(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).DetachProcesses)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn EndSession(&self, flags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).EndSession)(::windows::core::Interface::as_raw(self), flags).ok()
    }
    pub unsafe fn GetExitCode(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetExitCode)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn DispatchCallbacks(&self, timeout: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).DispatchCallbacks)(::windows::core::Interface::as_raw(self), timeout).ok()
    }
    pub unsafe fn ExitDispatch<P0>(&self, client: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugClient>,
    {
        (::windows::core::Interface::vtable(self).ExitDispatch)(::windows::core::Interface::as_raw(self), client.into_param().abi()).ok()
    }
    pub unsafe fn CreateClient(&self) -> ::windows::core::Result<IDebugClient> {
        let mut result__ = ::windows::core::zeroed::<IDebugClient>();
        (::windows::core::Interface::vtable(self).CreateClient)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetInputCallbacks(&self) -> ::windows::core::Result<IDebugInputCallbacks> {
        let mut result__ = ::windows::core::zeroed::<IDebugInputCallbacks>();
        (::windows::core::Interface::vtable(self).GetInputCallbacks)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetInputCallbacks<P0>(&self, callbacks: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugInputCallbacks>,
    {
        (::windows::core::Interface::vtable(self).SetInputCallbacks)(::windows::core::Interface::as_raw(self), callbacks.into_param().abi()).ok()
    }
    pub unsafe fn GetOutputCallbacks(&self) -> ::windows::core::Result<IDebugOutputCallbacks> {
        let mut result__ = ::windows::core::zeroed::<IDebugOutputCallbacks>();
        (::windows::core::Interface::vtable(self).GetOutputCallbacks)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetOutputCallbacks<P0>(&self, callbacks: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugOutputCallbacks>,
    {
        (::windows::core::Interface::vtable(self).SetOutputCallbacks)(::windows::core::Interface::as_raw(self), callbacks.into_param().abi()).ok()
    }
    pub unsafe fn GetOutputMask(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetOutputMask)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetOutputMask(&self, mask: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetOutputMask)(::windows::core::Interface::as_raw(self), mask).ok()
    }
    pub unsafe fn GetOtherOutputMask<P0>(&self, client: P0) -> ::windows::core::Result<u32>
    where
        P0: ::windows::core::IntoParam<IDebugClient>,
    {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetOtherOutputMask)(::windows::core::Interface::as_raw(self), client.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetOtherOutputMask<P0>(&self, client: P0, mask: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugClient>,
    {
        (::windows::core::Interface::vtable(self).SetOtherOutputMask)(::windows::core::Interface::as_raw(self), client.into_param().abi(), mask).ok()
    }
    pub unsafe fn GetOutputWidth(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetOutputWidth)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetOutputWidth(&self, columns: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetOutputWidth)(::windows::core::Interface::as_raw(self), columns).ok()
    }
    pub unsafe fn GetOutputLinePrefix(&self, buffer: ::core::option::Option<&mut [u8]>, prefixsize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetOutputLinePrefix)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(prefixsize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetOutputLinePrefix<P0>(&self, prefix: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).SetOutputLinePrefix)(::windows::core::Interface::as_raw(self), prefix.into_param().abi()).ok()
    }
    pub unsafe fn GetIdentity(&self, buffer: ::core::option::Option<&mut [u8]>, identitysize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetIdentity)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(identitysize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn OutputIdentity<P0>(&self, outputcontrol: u32, flags: u32, format: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).OutputIdentity)(::windows::core::Interface::as_raw(self), outputcontrol, flags, format.into_param().abi()).ok()
    }
    pub unsafe fn GetEventCallbacks(&self) -> ::windows::core::Result<IDebugEventCallbacks> {
        let mut result__ = ::windows::core::zeroed::<IDebugEventCallbacks>();
        (::windows::core::Interface::vtable(self).GetEventCallbacks)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetEventCallbacks<P0>(&self, callbacks: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugEventCallbacks>,
    {
        (::windows::core::Interface::vtable(self).SetEventCallbacks)(::windows::core::Interface::as_raw(self), callbacks.into_param().abi()).ok()
    }
    pub unsafe fn FlushCallbacks(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).FlushCallbacks)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn WriteDumpFile2<P0, P1>(&self, dumpfile: P0, qualifier: u32, formatflags: u32, comment: P1) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
        P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).WriteDumpFile2)(::windows::core::Interface::as_raw(self), dumpfile.into_param().abi(), qualifier, formatflags, comment.into_param().abi()).ok()
    }
    pub unsafe fn AddDumpInformationFile<P0>(&self, infofile: P0, r#type: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).AddDumpInformationFile)(::windows::core::Interface::as_raw(self), infofile.into_param().abi(), r#type).ok()
    }
    pub unsafe fn EndProcessServer(&self, server: u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).EndProcessServer)(::windows::core::Interface::as_raw(self), server).ok()
    }
    pub unsafe fn WaitForProcessServerEnd(&self, timeout: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).WaitForProcessServerEnd)(::windows::core::Interface::as_raw(self), timeout).ok()
    }
    pub unsafe fn IsKernelDebuggerEnabled(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).IsKernelDebuggerEnabled)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn TerminateCurrentProcess(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).TerminateCurrentProcess)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn DetachCurrentProcess(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).DetachCurrentProcess)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn AbandonCurrentProcess(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).AbandonCurrentProcess)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetRunningProcessSystemIdByExecutableNameWide<P0>(&self, server: u64, exename: P0, flags: u32) -> ::windows::core::Result<u32>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetRunningProcessSystemIdByExecutableNameWide)(::windows::core::Interface::as_raw(self), server, exename.into_param().abi(), flags, &mut result__).from_abi(result__)
    }
    pub unsafe fn GetRunningProcessDescriptionWide(&self, server: u64, systemid: u32, flags: u32, exename: ::core::option::Option<&mut [u16]>, actualexenamesize: ::core::option::Option<*mut u32>, description: ::core::option::Option<&mut [u16]>, actualdescriptionsize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetRunningProcessDescriptionWide)(
            ::windows::core::Interface::as_raw(self),
            server,
            systemid,
            flags,
            ::core::mem::transmute(exename.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
            exename.as_deref().map_or(0, |slice| slice.len() as _),
            ::core::mem::transmute(actualexenamesize.unwrap_or(::std::ptr::null_mut())),
            ::core::mem::transmute(description.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
            description.as_deref().map_or(0, |slice| slice.len() as _),
            ::core::mem::transmute(actualdescriptionsize.unwrap_or(::std::ptr::null_mut())),
        )
        .ok()
    }
    pub unsafe fn CreateProcessWide<P0>(&self, server: u64, commandline: P0, createflags: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).CreateProcessWide)(::windows::core::Interface::as_raw(self), server, commandline.into_param().abi(), createflags).ok()
    }
    pub unsafe fn CreateProcessAndAttachWide<P0>(&self, server: u64, commandline: P0, createflags: u32, processid: u32, attachflags: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).CreateProcessAndAttachWide)(::windows::core::Interface::as_raw(self), server, commandline.into_param().abi(), createflags, processid, attachflags).ok()
    }
    pub unsafe fn OpenDumpFileWide<P0>(&self, filename: P0, filehandle: u64) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).OpenDumpFileWide)(::windows::core::Interface::as_raw(self), filename.into_param().abi(), filehandle).ok()
    }
    pub unsafe fn WriteDumpFileWide<P0, P1>(&self, filename: P0, filehandle: u64, qualifier: u32, formatflags: u32, comment: P1) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).WriteDumpFileWide)(::windows::core::Interface::as_raw(self), filename.into_param().abi(), filehandle, qualifier, formatflags, comment.into_param().abi()).ok()
    }
    pub unsafe fn AddDumpInformationFileWide<P0>(&self, filename: P0, filehandle: u64, r#type: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).AddDumpInformationFileWide)(::windows::core::Interface::as_raw(self), filename.into_param().abi(), filehandle, r#type).ok()
    }
    pub unsafe fn GetNumberDumpFiles(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetNumberDumpFiles)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetDumpFile(&self, index: u32, buffer: ::core::option::Option<&mut [u8]>, namesize: ::core::option::Option<*mut u32>, handle: ::core::option::Option<*mut u64>, r#type: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetDumpFile)(::windows::core::Interface::as_raw(self), index, ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(namesize.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(handle.unwrap_or(::std::ptr::null_mut())), r#type).ok()
    }
    pub unsafe fn GetDumpFileWide(&self, index: u32, buffer: ::core::option::Option<&mut [u16]>, namesize: ::core::option::Option<*mut u32>, handle: ::core::option::Option<*mut u64>, r#type: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetDumpFileWide)(::windows::core::Interface::as_raw(self), index, ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(namesize.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(handle.unwrap_or(::std::ptr::null_mut())), r#type).ok()
    }
    pub unsafe fn AttachKernelWide<P0>(&self, flags: u32, connectoptions: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).AttachKernelWide)(::windows::core::Interface::as_raw(self), flags, connectoptions.into_param().abi()).ok()
    }
    pub unsafe fn GetKernelConnectionOptionsWide(&self, buffer: ::core::option::Option<&mut [u16]>, optionssize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetKernelConnectionOptionsWide)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(optionssize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetKernelConnectionOptionsWide<P0>(&self, options: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).SetKernelConnectionOptionsWide)(::windows::core::Interface::as_raw(self), options.into_param().abi()).ok()
    }
    pub unsafe fn StartProcessServerWide<P0>(&self, flags: u32, options: P0, reserved: ::core::option::Option<*const ::core::ffi::c_void>) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).StartProcessServerWide)(::windows::core::Interface::as_raw(self), flags, options.into_param().abi(), ::core::mem::transmute(reserved.unwrap_or(::std::ptr::null()))).ok()
    }
    pub unsafe fn ConnectProcessServerWide<P0>(&self, remoteoptions: P0) -> ::windows::core::Result<u64>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        let mut result__ = ::windows::core::zeroed::<u64>();
        (::windows::core::Interface::vtable(self).ConnectProcessServerWide)(::windows::core::Interface::as_raw(self), remoteoptions.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn StartServerWide<P0>(&self, options: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).StartServerWide)(::windows::core::Interface::as_raw(self), options.into_param().abi()).ok()
    }
    pub unsafe fn OutputServersWide<P0>(&self, outputcontrol: u32, machine: P0, flags: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).OutputServersWide)(::windows::core::Interface::as_raw(self), outputcontrol, machine.into_param().abi(), flags).ok()
    }
    pub unsafe fn GetOutputCallbacksWide(&self) -> ::windows::core::Result<IDebugOutputCallbacksWide> {
        let mut result__ = ::windows::core::zeroed::<IDebugOutputCallbacksWide>();
        (::windows::core::Interface::vtable(self).GetOutputCallbacksWide)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetOutputCallbacksWide<P0>(&self, callbacks: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugOutputCallbacksWide>,
    {
        (::windows::core::Interface::vtable(self).SetOutputCallbacksWide)(::windows::core::Interface::as_raw(self), callbacks.into_param().abi()).ok()
    }
    pub unsafe fn GetOutputLinePrefixWide(&self, buffer: ::core::option::Option<&mut [u16]>, prefixsize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetOutputLinePrefixWide)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(prefixsize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetOutputLinePrefixWide<P0>(&self, prefix: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).SetOutputLinePrefixWide)(::windows::core::Interface::as_raw(self), prefix.into_param().abi()).ok()
    }
    pub unsafe fn GetIdentityWide(&self, buffer: ::core::option::Option<&mut [u16]>, identitysize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetIdentityWide)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(identitysize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn OutputIdentityWide<P0>(&self, outputcontrol: u32, flags: u32, format: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).OutputIdentityWide)(::windows::core::Interface::as_raw(self), outputcontrol, flags, format.into_param().abi()).ok()
    }
    pub unsafe fn GetEventCallbacksWide(&self) -> ::windows::core::Result<IDebugEventCallbacksWide> {
        let mut result__ = ::windows::core::zeroed::<IDebugEventCallbacksWide>();
        (::windows::core::Interface::vtable(self).GetEventCallbacksWide)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetEventCallbacksWide<P0>(&self, callbacks: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugEventCallbacksWide>,
    {
        (::windows::core::Interface::vtable(self).SetEventCallbacksWide)(::windows::core::Interface::as_raw(self), callbacks.into_param().abi()).ok()
    }
    pub unsafe fn CreateProcess2<P0, P1, P2>(&self, server: u64, commandline: P0, optionsbuffer: *const ::core::ffi::c_void, optionsbuffersize: u32, initialdirectory: P1, environment: P2) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
        P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
        P2: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).CreateProcess2)(::windows::core::Interface::as_raw(self), server, commandline.into_param().abi(), optionsbuffer, optionsbuffersize, initialdirectory.into_param().abi(), environment.into_param().abi()).ok()
    }
    pub unsafe fn CreateProcess2Wide<P0, P1, P2>(&self, server: u64, commandline: P0, optionsbuffer: *const ::core::ffi::c_void, optionsbuffersize: u32, initialdirectory: P1, environment: P2) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P2: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).CreateProcess2Wide)(::windows::core::Interface::as_raw(self), server, commandline.into_param().abi(), optionsbuffer, optionsbuffersize, initialdirectory.into_param().abi(), environment.into_param().abi()).ok()
    }
    pub unsafe fn CreateProcessAndAttach2<P0, P1, P2>(&self, server: u64, commandline: P0, optionsbuffer: *const ::core::ffi::c_void, optionsbuffersize: u32, initialdirectory: P1, environment: P2, processid: u32, attachflags: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
        P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
        P2: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).CreateProcessAndAttach2)(::windows::core::Interface::as_raw(self), server, commandline.into_param().abi(), optionsbuffer, optionsbuffersize, initialdirectory.into_param().abi(), environment.into_param().abi(), processid, attachflags).ok()
    }
    pub unsafe fn CreateProcessAndAttach2Wide<P0, P1, P2>(&self, server: u64, commandline: P0, optionsbuffer: *const ::core::ffi::c_void, optionsbuffersize: u32, initialdirectory: P1, environment: P2, processid: u32, attachflags: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P2: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).CreateProcessAndAttach2Wide)(::windows::core::Interface::as_raw(self), server, commandline.into_param().abi(), optionsbuffer, optionsbuffersize, initialdirectory.into_param().abi(), environment.into_param().abi(), processid, attachflags).ok()
    }
    pub unsafe fn PushOutputLinePrefix<P0>(&self, newprefix: P0) -> ::windows::core::Result<u64>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        let mut result__ = ::windows::core::zeroed::<u64>();
        (::windows::core::Interface::vtable(self).PushOutputLinePrefix)(::windows::core::Interface::as_raw(self), newprefix.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn PushOutputLinePrefixWide<P0>(&self, newprefix: P0) -> ::windows::core::Result<u64>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        let mut result__ = ::windows::core::zeroed::<u64>();
        (::windows::core::Interface::vtable(self).PushOutputLinePrefixWide)(::windows::core::Interface::as_raw(self), newprefix.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn PopOutputLinePrefix(&self, handle: u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).PopOutputLinePrefix)(::windows::core::Interface::as_raw(self), handle).ok()
    }
    pub unsafe fn GetNumberInputCallbacks(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetNumberInputCallbacks)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetNumberOutputCallbacks(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetNumberOutputCallbacks)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetNumberEventCallbacks(&self, eventflags: u32) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetNumberEventCallbacks)(::windows::core::Interface::as_raw(self), eventflags, &mut result__).from_abi(result__)
    }
    pub unsafe fn GetQuitLockString(&self, buffer: ::core::option::Option<&mut [u8]>, stringsize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetQuitLockString)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(stringsize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetQuitLockString<P0>(&self, string: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).SetQuitLockString)(::windows::core::Interface::as_raw(self), string.into_param().abi()).ok()
    }
    pub unsafe fn GetQuitLockStringWide(&self, buffer: ::core::option::Option<&mut [u16]>, stringsize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetQuitLockStringWide)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(stringsize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetQuitLockStringWide<P0>(&self, string: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).SetQuitLockStringWide)(::windows::core::Interface::as_raw(self), string.into_param().abi()).ok()
    }
    pub unsafe fn SetEventContextCallbacks<P0>(&self, callbacks: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugEventContextCallbacks>,
    {
        (::windows::core::Interface::vtable(self).SetEventContextCallbacks)(::windows::core::Interface::as_raw(self), callbacks.into_param().abi()).ok()
    }
    pub unsafe fn SetClientContext(&self, context: *const ::core::ffi::c_void, contextsize: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetClientContext)(::windows::core::Interface::as_raw(self), context, contextsize).ok()
    }
}
::windows::imp::interface_hierarchy!(IDebugClient7, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IDebugClient7 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDebugClient7 {}
impl ::core::fmt::Debug for IDebugClient7 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDebugClient7").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDebugClient7 {
    type Vtable = IDebugClient7_Vtbl;
}
impl ::core::clone::Clone for IDebugClient7 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IDebugClient7 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x13586be3_542e_481e_b1f2_8497ba74f9a9);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDebugClient7_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub AttachKernel: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flags: u32, connectoptions: ::windows::core::PCSTR) -> ::windows::core::HRESULT,
    pub GetKernelConnectionOptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, buffer: ::windows::core::PSTR, buffersize: u32, optionssize: *mut u32) -> ::windows::core::HRESULT,
    pub SetKernelConnectionOptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, options: ::windows::core::PCSTR) -> ::windows::core::HRESULT,
    pub StartProcessServer: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flags: u32, options: ::windows::core::PCSTR, reserved: *const ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub ConnectProcessServer: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, remoteoptions: ::windows::core::PCSTR, server: *mut u64) -> ::windows::core::HRESULT,
    pub DisconnectProcessServer: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64) -> ::windows::core::HRESULT,
    pub GetRunningProcessSystemIds: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, ids: *mut u32, count: u32, actualcount: *mut u32) -> ::windows::core::HRESULT,
    pub GetRunningProcessSystemIdByExecutableName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, exename: ::windows::core::PCSTR, flags: u32, id: *mut u32) -> ::windows::core::HRESULT,
    pub GetRunningProcessDescription: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, systemid: u32, flags: u32, exename: ::windows::core::PSTR, exenamesize: u32, actualexenamesize: *mut u32, description: ::windows::core::PSTR, descriptionsize: u32, actualdescriptionsize: *mut u32) -> ::windows::core::HRESULT,
    pub AttachProcess: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, processid: u32, attachflags: u32) -> ::windows::core::HRESULT,
    pub CreateProcessA: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, commandline: ::windows::core::PCSTR, createflags: u32) -> ::windows::core::HRESULT,
    pub CreateProcessAndAttach: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, commandline: ::windows::core::PCSTR, createflags: u32, processid: u32, attachflags: u32) -> ::windows::core::HRESULT,
    pub GetProcessOptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, options: *mut u32) -> ::windows::core::HRESULT,
    pub AddProcessOptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, options: u32) -> ::windows::core::HRESULT,
    pub RemoveProcessOptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, options: u32) -> ::windows::core::HRESULT,
    pub SetProcessOptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, options: u32) -> ::windows::core::HRESULT,
    pub OpenDumpFile: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dumpfile: ::windows::core::PCSTR) -> ::windows::core::HRESULT,
    pub WriteDumpFile: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dumpfile: ::windows::core::PCSTR, qualifier: u32) -> ::windows::core::HRESULT,
    pub ConnectSession: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flags: u32, historylimit: u32) -> ::windows::core::HRESULT,
    pub StartServer: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, options: ::windows::core::PCSTR) -> ::windows::core::HRESULT,
    pub OutputServers: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, outputcontrol: u32, machine: ::windows::core::PCSTR, flags: u32) -> ::windows::core::HRESULT,
    pub TerminateProcesses: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub DetachProcesses: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub EndSession: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flags: u32) -> ::windows::core::HRESULT,
    pub GetExitCode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, code: *mut u32) -> ::windows::core::HRESULT,
    pub DispatchCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, timeout: u32) -> ::windows::core::HRESULT,
    pub ExitDispatch: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, client: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub CreateClient: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, client: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetInputCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, callbacks: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub SetInputCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, callbacks: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetOutputCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, callbacks: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub SetOutputCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, callbacks: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetOutputMask: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, mask: *mut u32) -> ::windows::core::HRESULT,
    pub SetOutputMask: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, mask: u32) -> ::windows::core::HRESULT,
    pub GetOtherOutputMask: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, client: *mut ::core::ffi::c_void, mask: *mut u32) -> ::windows::core::HRESULT,
    pub SetOtherOutputMask: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, client: *mut ::core::ffi::c_void, mask: u32) -> ::windows::core::HRESULT,
    pub GetOutputWidth: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, columns: *mut u32) -> ::windows::core::HRESULT,
    pub SetOutputWidth: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, columns: u32) -> ::windows::core::HRESULT,
    pub GetOutputLinePrefix: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, buffer: ::windows::core::PSTR, buffersize: u32, prefixsize: *mut u32) -> ::windows::core::HRESULT,
    pub SetOutputLinePrefix: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, prefix: ::windows::core::PCSTR) -> ::windows::core::HRESULT,
    pub GetIdentity: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, buffer: ::windows::core::PSTR, buffersize: u32, identitysize: *mut u32) -> ::windows::core::HRESULT,
    pub OutputIdentity: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, outputcontrol: u32, flags: u32, format: ::windows::core::PCSTR) -> ::windows::core::HRESULT,
    pub GetEventCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, callbacks: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub SetEventCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, callbacks: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub FlushCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub WriteDumpFile2: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dumpfile: ::windows::core::PCSTR, qualifier: u32, formatflags: u32, comment: ::windows::core::PCSTR) -> ::windows::core::HRESULT,
    pub AddDumpInformationFile: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, infofile: ::windows::core::PCSTR, r#type: u32) -> ::windows::core::HRESULT,
    pub EndProcessServer: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64) -> ::windows::core::HRESULT,
    pub WaitForProcessServerEnd: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, timeout: u32) -> ::windows::core::HRESULT,
    pub IsKernelDebuggerEnabled: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub TerminateCurrentProcess: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub DetachCurrentProcess: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub AbandonCurrentProcess: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetRunningProcessSystemIdByExecutableNameWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, exename: ::windows::core::PCWSTR, flags: u32, id: *mut u32) -> ::windows::core::HRESULT,
    pub GetRunningProcessDescriptionWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, systemid: u32, flags: u32, exename: ::windows::core::PWSTR, exenamesize: u32, actualexenamesize: *mut u32, description: ::windows::core::PWSTR, descriptionsize: u32, actualdescriptionsize: *mut u32) -> ::windows::core::HRESULT,
    pub CreateProcessWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, commandline: ::windows::core::PCWSTR, createflags: u32) -> ::windows::core::HRESULT,
    pub CreateProcessAndAttachWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, commandline: ::windows::core::PCWSTR, createflags: u32, processid: u32, attachflags: u32) -> ::windows::core::HRESULT,
    pub OpenDumpFileWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, filename: ::windows::core::PCWSTR, filehandle: u64) -> ::windows::core::HRESULT,
    pub WriteDumpFileWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, filename: ::windows::core::PCWSTR, filehandle: u64, qualifier: u32, formatflags: u32, comment: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub AddDumpInformationFileWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, filename: ::windows::core::PCWSTR, filehandle: u64, r#type: u32) -> ::windows::core::HRESULT,
    pub GetNumberDumpFiles: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, number: *mut u32) -> ::windows::core::HRESULT,
    pub GetDumpFile: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, index: u32, buffer: ::windows::core::PSTR, buffersize: u32, namesize: *mut u32, handle: *mut u64, r#type: *mut u32) -> ::windows::core::HRESULT,
    pub GetDumpFileWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, index: u32, buffer: ::windows::core::PWSTR, buffersize: u32, namesize: *mut u32, handle: *mut u64, r#type: *mut u32) -> ::windows::core::HRESULT,
    pub AttachKernelWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flags: u32, connectoptions: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub GetKernelConnectionOptionsWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, buffer: ::windows::core::PWSTR, buffersize: u32, optionssize: *mut u32) -> ::windows::core::HRESULT,
    pub SetKernelConnectionOptionsWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, options: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub StartProcessServerWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flags: u32, options: ::windows::core::PCWSTR, reserved: *const ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub ConnectProcessServerWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, remoteoptions: ::windows::core::PCWSTR, server: *mut u64) -> ::windows::core::HRESULT,
    pub StartServerWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, options: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub OutputServersWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, outputcontrol: u32, machine: ::windows::core::PCWSTR, flags: u32) -> ::windows::core::HRESULT,
    pub GetOutputCallbacksWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, callbacks: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub SetOutputCallbacksWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, callbacks: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetOutputLinePrefixWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, buffer: ::windows::core::PWSTR, buffersize: u32, prefixsize: *mut u32) -> ::windows::core::HRESULT,
    pub SetOutputLinePrefixWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, prefix: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub GetIdentityWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, buffer: ::windows::core::PWSTR, buffersize: u32, identitysize: *mut u32) -> ::windows::core::HRESULT,
    pub OutputIdentityWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, outputcontrol: u32, flags: u32, format: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub GetEventCallbacksWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, callbacks: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub SetEventCallbacksWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, callbacks: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub CreateProcess2: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, commandline: ::windows::core::PCSTR, optionsbuffer: *const ::core::ffi::c_void, optionsbuffersize: u32, initialdirectory: ::windows::core::PCSTR, environment: ::windows::core::PCSTR) -> ::windows::core::HRESULT,
    pub CreateProcess2Wide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, commandline: ::windows::core::PCWSTR, optionsbuffer: *const ::core::ffi::c_void, optionsbuffersize: u32, initialdirectory: ::windows::core::PCWSTR, environment: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub CreateProcessAndAttach2: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, commandline: ::windows::core::PCSTR, optionsbuffer: *const ::core::ffi::c_void, optionsbuffersize: u32, initialdirectory: ::windows::core::PCSTR, environment: ::windows::core::PCSTR, processid: u32, attachflags: u32) -> ::windows::core::HRESULT,
    pub CreateProcessAndAttach2Wide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, commandline: ::windows::core::PCWSTR, optionsbuffer: *const ::core::ffi::c_void, optionsbuffersize: u32, initialdirectory: ::windows::core::PCWSTR, environment: ::windows::core::PCWSTR, processid: u32, attachflags: u32) -> ::windows::core::HRESULT,
    pub PushOutputLinePrefix: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, newprefix: ::windows::core::PCSTR, handle: *mut u64) -> ::windows::core::HRESULT,
    pub PushOutputLinePrefixWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, newprefix: ::windows::core::PCWSTR, handle: *mut u64) -> ::windows::core::HRESULT,
    pub PopOutputLinePrefix: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, handle: u64) -> ::windows::core::HRESULT,
    pub GetNumberInputCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, count: *mut u32) -> ::windows::core::HRESULT,
    pub GetNumberOutputCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, count: *mut u32) -> ::windows::core::HRESULT,
    pub GetNumberEventCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, eventflags: u32, count: *mut u32) -> ::windows::core::HRESULT,
    pub GetQuitLockString: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, buffer: ::windows::core::PSTR, buffersize: u32, stringsize: *mut u32) -> ::windows::core::HRESULT,
    pub SetQuitLockString: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, string: ::windows::core::PCSTR) -> ::windows::core::HRESULT,
    pub GetQuitLockStringWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, buffer: ::windows::core::PWSTR, buffersize: u32, stringsize: *mut u32) -> ::windows::core::HRESULT,
    pub SetQuitLockStringWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, string: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub SetEventContextCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, callbacks: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub SetClientContext: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, context: *const ::core::ffi::c_void, contextsize: u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IDebugClient8(::windows::core::IUnknown);
impl IDebugClient8 {
    pub unsafe fn AttachKernel<P0>(&self, flags: u32, connectoptions: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).AttachKernel)(::windows::core::Interface::as_raw(self), flags, connectoptions.into_param().abi()).ok()
    }
    pub unsafe fn GetKernelConnectionOptions(&self, buffer: ::core::option::Option<&mut [u8]>, optionssize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetKernelConnectionOptions)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(optionssize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetKernelConnectionOptions<P0>(&self, options: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).SetKernelConnectionOptions)(::windows::core::Interface::as_raw(self), options.into_param().abi()).ok()
    }
    pub unsafe fn StartProcessServer<P0>(&self, flags: u32, options: P0, reserved: ::core::option::Option<*const ::core::ffi::c_void>) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).StartProcessServer)(::windows::core::Interface::as_raw(self), flags, options.into_param().abi(), ::core::mem::transmute(reserved.unwrap_or(::std::ptr::null()))).ok()
    }
    pub unsafe fn ConnectProcessServer<P0>(&self, remoteoptions: P0) -> ::windows::core::Result<u64>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        let mut result__ = ::windows::core::zeroed::<u64>();
        (::windows::core::Interface::vtable(self).ConnectProcessServer)(::windows::core::Interface::as_raw(self), remoteoptions.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn DisconnectProcessServer(&self, server: u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).DisconnectProcessServer)(::windows::core::Interface::as_raw(self), server).ok()
    }
    pub unsafe fn GetRunningProcessSystemIds(&self, server: u64, ids: ::core::option::Option<&mut [u32]>, actualcount: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetRunningProcessSystemIds)(::windows::core::Interface::as_raw(self), server, ::core::mem::transmute(ids.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), ids.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(actualcount.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetRunningProcessSystemIdByExecutableName<P0>(&self, server: u64, exename: P0, flags: u32) -> ::windows::core::Result<u32>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetRunningProcessSystemIdByExecutableName)(::windows::core::Interface::as_raw(self), server, exename.into_param().abi(), flags, &mut result__).from_abi(result__)
    }
    pub unsafe fn GetRunningProcessDescription(&self, server: u64, systemid: u32, flags: u32, exename: ::core::option::Option<&mut [u8]>, actualexenamesize: ::core::option::Option<*mut u32>, description: ::core::option::Option<&mut [u8]>, actualdescriptionsize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetRunningProcessDescription)(
            ::windows::core::Interface::as_raw(self),
            server,
            systemid,
            flags,
            ::core::mem::transmute(exename.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
            exename.as_deref().map_or(0, |slice| slice.len() as _),
            ::core::mem::transmute(actualexenamesize.unwrap_or(::std::ptr::null_mut())),
            ::core::mem::transmute(description.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
            description.as_deref().map_or(0, |slice| slice.len() as _),
            ::core::mem::transmute(actualdescriptionsize.unwrap_or(::std::ptr::null_mut())),
        )
        .ok()
    }
    pub unsafe fn AttachProcess(&self, server: u64, processid: u32, attachflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).AttachProcess)(::windows::core::Interface::as_raw(self), server, processid, attachflags).ok()
    }
    pub unsafe fn CreateProcessA<P0>(&self, server: u64, commandline: P0, createflags: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).CreateProcessA)(::windows::core::Interface::as_raw(self), server, commandline.into_param().abi(), createflags).ok()
    }
    pub unsafe fn CreateProcessAndAttach<P0>(&self, server: u64, commandline: P0, createflags: u32, processid: u32, attachflags: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).CreateProcessAndAttach)(::windows::core::Interface::as_raw(self), server, commandline.into_param().abi(), createflags, processid, attachflags).ok()
    }
    pub unsafe fn GetProcessOptions(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetProcessOptions)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn AddProcessOptions(&self, options: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).AddProcessOptions)(::windows::core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn RemoveProcessOptions(&self, options: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).RemoveProcessOptions)(::windows::core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn SetProcessOptions(&self, options: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetProcessOptions)(::windows::core::Interface::as_raw(self), options).ok()
    }
    pub unsafe fn OpenDumpFile<P0>(&self, dumpfile: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).OpenDumpFile)(::windows::core::Interface::as_raw(self), dumpfile.into_param().abi()).ok()
    }
    pub unsafe fn WriteDumpFile<P0>(&self, dumpfile: P0, qualifier: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).WriteDumpFile)(::windows::core::Interface::as_raw(self), dumpfile.into_param().abi(), qualifier).ok()
    }
    pub unsafe fn ConnectSession(&self, flags: u32, historylimit: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).ConnectSession)(::windows::core::Interface::as_raw(self), flags, historylimit).ok()
    }
    pub unsafe fn StartServer<P0>(&self, options: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).StartServer)(::windows::core::Interface::as_raw(self), options.into_param().abi()).ok()
    }
    pub unsafe fn OutputServers<P0>(&self, outputcontrol: u32, machine: P0, flags: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).OutputServers)(::windows::core::Interface::as_raw(self), outputcontrol, machine.into_param().abi(), flags).ok()
    }
    pub unsafe fn TerminateProcesses(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).TerminateProcesses)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn DetachProcesses(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).DetachProcesses)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn EndSession(&self, flags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).EndSession)(::windows::core::Interface::as_raw(self), flags).ok()
    }
    pub unsafe fn GetExitCode(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetExitCode)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn DispatchCallbacks(&self, timeout: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).DispatchCallbacks)(::windows::core::Interface::as_raw(self), timeout).ok()
    }
    pub unsafe fn ExitDispatch<P0>(&self, client: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugClient>,
    {
        (::windows::core::Interface::vtable(self).ExitDispatch)(::windows::core::Interface::as_raw(self), client.into_param().abi()).ok()
    }
    pub unsafe fn CreateClient(&self) -> ::windows::core::Result<IDebugClient> {
        let mut result__ = ::windows::core::zeroed::<IDebugClient>();
        (::windows::core::Interface::vtable(self).CreateClient)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetInputCallbacks(&self) -> ::windows::core::Result<IDebugInputCallbacks> {
        let mut result__ = ::windows::core::zeroed::<IDebugInputCallbacks>();
        (::windows::core::Interface::vtable(self).GetInputCallbacks)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetInputCallbacks<P0>(&self, callbacks: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugInputCallbacks>,
    {
        (::windows::core::Interface::vtable(self).SetInputCallbacks)(::windows::core::Interface::as_raw(self), callbacks.into_param().abi()).ok()
    }
    pub unsafe fn GetOutputCallbacks(&self) -> ::windows::core::Result<IDebugOutputCallbacks> {
        let mut result__ = ::windows::core::zeroed::<IDebugOutputCallbacks>();
        (::windows::core::Interface::vtable(self).GetOutputCallbacks)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetOutputCallbacks<P0>(&self, callbacks: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugOutputCallbacks>,
    {
        (::windows::core::Interface::vtable(self).SetOutputCallbacks)(::windows::core::Interface::as_raw(self), callbacks.into_param().abi()).ok()
    }
    pub unsafe fn GetOutputMask(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetOutputMask)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetOutputMask(&self, mask: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetOutputMask)(::windows::core::Interface::as_raw(self), mask).ok()
    }
    pub unsafe fn GetOtherOutputMask<P0>(&self, client: P0) -> ::windows::core::Result<u32>
    where
        P0: ::windows::core::IntoParam<IDebugClient>,
    {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetOtherOutputMask)(::windows::core::Interface::as_raw(self), client.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetOtherOutputMask<P0>(&self, client: P0, mask: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugClient>,
    {
        (::windows::core::Interface::vtable(self).SetOtherOutputMask)(::windows::core::Interface::as_raw(self), client.into_param().abi(), mask).ok()
    }
    pub unsafe fn GetOutputWidth(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetOutputWidth)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetOutputWidth(&self, columns: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetOutputWidth)(::windows::core::Interface::as_raw(self), columns).ok()
    }
    pub unsafe fn GetOutputLinePrefix(&self, buffer: ::core::option::Option<&mut [u8]>, prefixsize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetOutputLinePrefix)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(prefixsize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetOutputLinePrefix<P0>(&self, prefix: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).SetOutputLinePrefix)(::windows::core::Interface::as_raw(self), prefix.into_param().abi()).ok()
    }
    pub unsafe fn GetIdentity(&self, buffer: ::core::option::Option<&mut [u8]>, identitysize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetIdentity)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(identitysize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn OutputIdentity<P0>(&self, outputcontrol: u32, flags: u32, format: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).OutputIdentity)(::windows::core::Interface::as_raw(self), outputcontrol, flags, format.into_param().abi()).ok()
    }
    pub unsafe fn GetEventCallbacks(&self) -> ::windows::core::Result<IDebugEventCallbacks> {
        let mut result__ = ::windows::core::zeroed::<IDebugEventCallbacks>();
        (::windows::core::Interface::vtable(self).GetEventCallbacks)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetEventCallbacks<P0>(&self, callbacks: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugEventCallbacks>,
    {
        (::windows::core::Interface::vtable(self).SetEventCallbacks)(::windows::core::Interface::as_raw(self), callbacks.into_param().abi()).ok()
    }
    pub unsafe fn FlushCallbacks(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).FlushCallbacks)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn WriteDumpFile2<P0, P1>(&self, dumpfile: P0, qualifier: u32, formatflags: u32, comment: P1) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
        P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).WriteDumpFile2)(::windows::core::Interface::as_raw(self), dumpfile.into_param().abi(), qualifier, formatflags, comment.into_param().abi()).ok()
    }
    pub unsafe fn AddDumpInformationFile<P0>(&self, infofile: P0, r#type: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).AddDumpInformationFile)(::windows::core::Interface::as_raw(self), infofile.into_param().abi(), r#type).ok()
    }
    pub unsafe fn EndProcessServer(&self, server: u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).EndProcessServer)(::windows::core::Interface::as_raw(self), server).ok()
    }
    pub unsafe fn WaitForProcessServerEnd(&self, timeout: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).WaitForProcessServerEnd)(::windows::core::Interface::as_raw(self), timeout).ok()
    }
    pub unsafe fn IsKernelDebuggerEnabled(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).IsKernelDebuggerEnabled)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn TerminateCurrentProcess(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).TerminateCurrentProcess)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn DetachCurrentProcess(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).DetachCurrentProcess)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn AbandonCurrentProcess(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).AbandonCurrentProcess)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetRunningProcessSystemIdByExecutableNameWide<P0>(&self, server: u64, exename: P0, flags: u32) -> ::windows::core::Result<u32>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetRunningProcessSystemIdByExecutableNameWide)(::windows::core::Interface::as_raw(self), server, exename.into_param().abi(), flags, &mut result__).from_abi(result__)
    }
    pub unsafe fn GetRunningProcessDescriptionWide(&self, server: u64, systemid: u32, flags: u32, exename: ::core::option::Option<&mut [u16]>, actualexenamesize: ::core::option::Option<*mut u32>, description: ::core::option::Option<&mut [u16]>, actualdescriptionsize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetRunningProcessDescriptionWide)(
            ::windows::core::Interface::as_raw(self),
            server,
            systemid,
            flags,
            ::core::mem::transmute(exename.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
            exename.as_deref().map_or(0, |slice| slice.len() as _),
            ::core::mem::transmute(actualexenamesize.unwrap_or(::std::ptr::null_mut())),
            ::core::mem::transmute(description.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
            description.as_deref().map_or(0, |slice| slice.len() as _),
            ::core::mem::transmute(actualdescriptionsize.unwrap_or(::std::ptr::null_mut())),
        )
        .ok()
    }
    pub unsafe fn CreateProcessWide<P0>(&self, server: u64, commandline: P0, createflags: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).CreateProcessWide)(::windows::core::Interface::as_raw(self), server, commandline.into_param().abi(), createflags).ok()
    }
    pub unsafe fn CreateProcessAndAttachWide<P0>(&self, server: u64, commandline: P0, createflags: u32, processid: u32, attachflags: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).CreateProcessAndAttachWide)(::windows::core::Interface::as_raw(self), server, commandline.into_param().abi(), createflags, processid, attachflags).ok()
    }
    pub unsafe fn OpenDumpFileWide<P0>(&self, filename: P0, filehandle: u64) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).OpenDumpFileWide)(::windows::core::Interface::as_raw(self), filename.into_param().abi(), filehandle).ok()
    }
    pub unsafe fn WriteDumpFileWide<P0, P1>(&self, filename: P0, filehandle: u64, qualifier: u32, formatflags: u32, comment: P1) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).WriteDumpFileWide)(::windows::core::Interface::as_raw(self), filename.into_param().abi(), filehandle, qualifier, formatflags, comment.into_param().abi()).ok()
    }
    pub unsafe fn AddDumpInformationFileWide<P0>(&self, filename: P0, filehandle: u64, r#type: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).AddDumpInformationFileWide)(::windows::core::Interface::as_raw(self), filename.into_param().abi(), filehandle, r#type).ok()
    }
    pub unsafe fn GetNumberDumpFiles(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetNumberDumpFiles)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetDumpFile(&self, index: u32, buffer: ::core::option::Option<&mut [u8]>, namesize: ::core::option::Option<*mut u32>, handle: ::core::option::Option<*mut u64>, r#type: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetDumpFile)(::windows::core::Interface::as_raw(self), index, ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(namesize.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(handle.unwrap_or(::std::ptr::null_mut())), r#type).ok()
    }
    pub unsafe fn GetDumpFileWide(&self, index: u32, buffer: ::core::option::Option<&mut [u16]>, namesize: ::core::option::Option<*mut u32>, handle: ::core::option::Option<*mut u64>, r#type: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetDumpFileWide)(::windows::core::Interface::as_raw(self), index, ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(namesize.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(handle.unwrap_or(::std::ptr::null_mut())), r#type).ok()
    }
    pub unsafe fn AttachKernelWide<P0>(&self, flags: u32, connectoptions: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).AttachKernelWide)(::windows::core::Interface::as_raw(self), flags, connectoptions.into_param().abi()).ok()
    }
    pub unsafe fn GetKernelConnectionOptionsWide(&self, buffer: ::core::option::Option<&mut [u16]>, optionssize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetKernelConnectionOptionsWide)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(optionssize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetKernelConnectionOptionsWide<P0>(&self, options: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).SetKernelConnectionOptionsWide)(::windows::core::Interface::as_raw(self), options.into_param().abi()).ok()
    }
    pub unsafe fn StartProcessServerWide<P0>(&self, flags: u32, options: P0, reserved: ::core::option::Option<*const ::core::ffi::c_void>) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).StartProcessServerWide)(::windows::core::Interface::as_raw(self), flags, options.into_param().abi(), ::core::mem::transmute(reserved.unwrap_or(::std::ptr::null()))).ok()
    }
    pub unsafe fn ConnectProcessServerWide<P0>(&self, remoteoptions: P0) -> ::windows::core::Result<u64>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        let mut result__ = ::windows::core::zeroed::<u64>();
        (::windows::core::Interface::vtable(self).ConnectProcessServerWide)(::windows::core::Interface::as_raw(self), remoteoptions.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn StartServerWide<P0>(&self, options: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).StartServerWide)(::windows::core::Interface::as_raw(self), options.into_param().abi()).ok()
    }
    pub unsafe fn OutputServersWide<P0>(&self, outputcontrol: u32, machine: P0, flags: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).OutputServersWide)(::windows::core::Interface::as_raw(self), outputcontrol, machine.into_param().abi(), flags).ok()
    }
    pub unsafe fn GetOutputCallbacksWide(&self) -> ::windows::core::Result<IDebugOutputCallbacksWide> {
        let mut result__ = ::windows::core::zeroed::<IDebugOutputCallbacksWide>();
        (::windows::core::Interface::vtable(self).GetOutputCallbacksWide)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetOutputCallbacksWide<P0>(&self, callbacks: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugOutputCallbacksWide>,
    {
        (::windows::core::Interface::vtable(self).SetOutputCallbacksWide)(::windows::core::Interface::as_raw(self), callbacks.into_param().abi()).ok()
    }
    pub unsafe fn GetOutputLinePrefixWide(&self, buffer: ::core::option::Option<&mut [u16]>, prefixsize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetOutputLinePrefixWide)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(prefixsize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetOutputLinePrefixWide<P0>(&self, prefix: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).SetOutputLinePrefixWide)(::windows::core::Interface::as_raw(self), prefix.into_param().abi()).ok()
    }
    pub unsafe fn GetIdentityWide(&self, buffer: ::core::option::Option<&mut [u16]>, identitysize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetIdentityWide)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(identitysize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn OutputIdentityWide<P0>(&self, outputcontrol: u32, flags: u32, format: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).OutputIdentityWide)(::windows::core::Interface::as_raw(self), outputcontrol, flags, format.into_param().abi()).ok()
    }
    pub unsafe fn GetEventCallbacksWide(&self) -> ::windows::core::Result<IDebugEventCallbacksWide> {
        let mut result__ = ::windows::core::zeroed::<IDebugEventCallbacksWide>();
        (::windows::core::Interface::vtable(self).GetEventCallbacksWide)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetEventCallbacksWide<P0>(&self, callbacks: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugEventCallbacksWide>,
    {
        (::windows::core::Interface::vtable(self).SetEventCallbacksWide)(::windows::core::Interface::as_raw(self), callbacks.into_param().abi()).ok()
    }
    pub unsafe fn CreateProcess2<P0, P1, P2>(&self, server: u64, commandline: P0, optionsbuffer: *const ::core::ffi::c_void, optionsbuffersize: u32, initialdirectory: P1, environment: P2) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
        P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
        P2: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).CreateProcess2)(::windows::core::Interface::as_raw(self), server, commandline.into_param().abi(), optionsbuffer, optionsbuffersize, initialdirectory.into_param().abi(), environment.into_param().abi()).ok()
    }
    pub unsafe fn CreateProcess2Wide<P0, P1, P2>(&self, server: u64, commandline: P0, optionsbuffer: *const ::core::ffi::c_void, optionsbuffersize: u32, initialdirectory: P1, environment: P2) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P2: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).CreateProcess2Wide)(::windows::core::Interface::as_raw(self), server, commandline.into_param().abi(), optionsbuffer, optionsbuffersize, initialdirectory.into_param().abi(), environment.into_param().abi()).ok()
    }
    pub unsafe fn CreateProcessAndAttach2<P0, P1, P2>(&self, server: u64, commandline: P0, optionsbuffer: *const ::core::ffi::c_void, optionsbuffersize: u32, initialdirectory: P1, environment: P2, processid: u32, attachflags: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
        P1: ::windows::core::IntoParam<::windows::core::PCSTR>,
        P2: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).CreateProcessAndAttach2)(::windows::core::Interface::as_raw(self), server, commandline.into_param().abi(), optionsbuffer, optionsbuffersize, initialdirectory.into_param().abi(), environment.into_param().abi(), processid, attachflags).ok()
    }
    pub unsafe fn CreateProcessAndAttach2Wide<P0, P1, P2>(&self, server: u64, commandline: P0, optionsbuffer: *const ::core::ffi::c_void, optionsbuffersize: u32, initialdirectory: P1, environment: P2, processid: u32, attachflags: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P1: ::windows::core::IntoParam<::windows::core::PCWSTR>,
        P2: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).CreateProcessAndAttach2Wide)(::windows::core::Interface::as_raw(self), server, commandline.into_param().abi(), optionsbuffer, optionsbuffersize, initialdirectory.into_param().abi(), environment.into_param().abi(), processid, attachflags).ok()
    }
    pub unsafe fn PushOutputLinePrefix<P0>(&self, newprefix: P0) -> ::windows::core::Result<u64>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        let mut result__ = ::windows::core::zeroed::<u64>();
        (::windows::core::Interface::vtable(self).PushOutputLinePrefix)(::windows::core::Interface::as_raw(self), newprefix.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn PushOutputLinePrefixWide<P0>(&self, newprefix: P0) -> ::windows::core::Result<u64>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        let mut result__ = ::windows::core::zeroed::<u64>();
        (::windows::core::Interface::vtable(self).PushOutputLinePrefixWide)(::windows::core::Interface::as_raw(self), newprefix.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn PopOutputLinePrefix(&self, handle: u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).PopOutputLinePrefix)(::windows::core::Interface::as_raw(self), handle).ok()
    }
    pub unsafe fn GetNumberInputCallbacks(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetNumberInputCallbacks)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetNumberOutputCallbacks(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetNumberOutputCallbacks)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetNumberEventCallbacks(&self, eventflags: u32) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetNumberEventCallbacks)(::windows::core::Interface::as_raw(self), eventflags, &mut result__).from_abi(result__)
    }
    pub unsafe fn GetQuitLockString(&self, buffer: ::core::option::Option<&mut [u8]>, stringsize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetQuitLockString)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(stringsize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetQuitLockString<P0>(&self, string: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).SetQuitLockString)(::windows::core::Interface::as_raw(self), string.into_param().abi()).ok()
    }
    pub unsafe fn GetQuitLockStringWide(&self, buffer: ::core::option::Option<&mut [u16]>, stringsize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetQuitLockStringWide)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(stringsize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetQuitLockStringWide<P0>(&self, string: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).SetQuitLockStringWide)(::windows::core::Interface::as_raw(self), string.into_param().abi()).ok()
    }
    pub unsafe fn SetEventContextCallbacks<P0>(&self, callbacks: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<IDebugEventContextCallbacks>,
    {
        (::windows::core::Interface::vtable(self).SetEventContextCallbacks)(::windows::core::Interface::as_raw(self), callbacks.into_param().abi()).ok()
    }
    pub unsafe fn SetClientContext(&self, context: *const ::core::ffi::c_void, contextsize: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetClientContext)(::windows::core::Interface::as_raw(self), context, contextsize).ok()
    }
    pub unsafe fn OpenDumpFileWide2<P0>(&self, filename: P0, filehandle: u64, alternatearch: u32) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCWSTR>,
    {
        (::windows::core::Interface::vtable(self).OpenDumpFileWide2)(::windows::core::Interface::as_raw(self), filename.into_param().abi(), filehandle, alternatearch).ok()
    }
}
::windows::imp::interface_hierarchy!(IDebugClient8, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IDebugClient8 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDebugClient8 {}
impl ::core::fmt::Debug for IDebugClient8 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDebugClient8").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDebugClient8 {
    type Vtable = IDebugClient8_Vtbl;
}
impl ::core::clone::Clone for IDebugClient8 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IDebugClient8 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xcec43add_6375_469e_83d5_414e4033c19a);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDebugClient8_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub AttachKernel: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flags: u32, connectoptions: ::windows::core::PCSTR) -> ::windows::core::HRESULT,
    pub GetKernelConnectionOptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, buffer: ::windows::core::PSTR, buffersize: u32, optionssize: *mut u32) -> ::windows::core::HRESULT,
    pub SetKernelConnectionOptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, options: ::windows::core::PCSTR) -> ::windows::core::HRESULT,
    pub StartProcessServer: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flags: u32, options: ::windows::core::PCSTR, reserved: *const ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub ConnectProcessServer: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, remoteoptions: ::windows::core::PCSTR, server: *mut u64) -> ::windows::core::HRESULT,
    pub DisconnectProcessServer: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64) -> ::windows::core::HRESULT,
    pub GetRunningProcessSystemIds: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, ids: *mut u32, count: u32, actualcount: *mut u32) -> ::windows::core::HRESULT,
    pub GetRunningProcessSystemIdByExecutableName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, exename: ::windows::core::PCSTR, flags: u32, id: *mut u32) -> ::windows::core::HRESULT,
    pub GetRunningProcessDescription: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, systemid: u32, flags: u32, exename: ::windows::core::PSTR, exenamesize: u32, actualexenamesize: *mut u32, description: ::windows::core::PSTR, descriptionsize: u32, actualdescriptionsize: *mut u32) -> ::windows::core::HRESULT,
    pub AttachProcess: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, processid: u32, attachflags: u32) -> ::windows::core::HRESULT,
    pub CreateProcessA: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, commandline: ::windows::core::PCSTR, createflags: u32) -> ::windows::core::HRESULT,
    pub CreateProcessAndAttach: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, commandline: ::windows::core::PCSTR, createflags: u32, processid: u32, attachflags: u32) -> ::windows::core::HRESULT,
    pub GetProcessOptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, options: *mut u32) -> ::windows::core::HRESULT,
    pub AddProcessOptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, options: u32) -> ::windows::core::HRESULT,
    pub RemoveProcessOptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, options: u32) -> ::windows::core::HRESULT,
    pub SetProcessOptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, options: u32) -> ::windows::core::HRESULT,
    pub OpenDumpFile: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dumpfile: ::windows::core::PCSTR) -> ::windows::core::HRESULT,
    pub WriteDumpFile: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dumpfile: ::windows::core::PCSTR, qualifier: u32) -> ::windows::core::HRESULT,
    pub ConnectSession: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flags: u32, historylimit: u32) -> ::windows::core::HRESULT,
    pub StartServer: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, options: ::windows::core::PCSTR) -> ::windows::core::HRESULT,
    pub OutputServers: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, outputcontrol: u32, machine: ::windows::core::PCSTR, flags: u32) -> ::windows::core::HRESULT,
    pub TerminateProcesses: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub DetachProcesses: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub EndSession: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flags: u32) -> ::windows::core::HRESULT,
    pub GetExitCode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, code: *mut u32) -> ::windows::core::HRESULT,
    pub DispatchCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, timeout: u32) -> ::windows::core::HRESULT,
    pub ExitDispatch: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, client: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub CreateClient: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, client: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetInputCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, callbacks: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub SetInputCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, callbacks: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetOutputCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, callbacks: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub SetOutputCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, callbacks: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetOutputMask: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, mask: *mut u32) -> ::windows::core::HRESULT,
    pub SetOutputMask: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, mask: u32) -> ::windows::core::HRESULT,
    pub GetOtherOutputMask: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, client: *mut ::core::ffi::c_void, mask: *mut u32) -> ::windows::core::HRESULT,
    pub SetOtherOutputMask: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, client: *mut ::core::ffi::c_void, mask: u32) -> ::windows::core::HRESULT,
    pub GetOutputWidth: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, columns: *mut u32) -> ::windows::core::HRESULT,
    pub SetOutputWidth: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, columns: u32) -> ::windows::core::HRESULT,
    pub GetOutputLinePrefix: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, buffer: ::windows::core::PSTR, buffersize: u32, prefixsize: *mut u32) -> ::windows::core::HRESULT,
    pub SetOutputLinePrefix: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, prefix: ::windows::core::PCSTR) -> ::windows::core::HRESULT,
    pub GetIdentity: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, buffer: ::windows::core::PSTR, buffersize: u32, identitysize: *mut u32) -> ::windows::core::HRESULT,
    pub OutputIdentity: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, outputcontrol: u32, flags: u32, format: ::windows::core::PCSTR) -> ::windows::core::HRESULT,
    pub GetEventCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, callbacks: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub SetEventCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, callbacks: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub FlushCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub WriteDumpFile2: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dumpfile: ::windows::core::PCSTR, qualifier: u32, formatflags: u32, comment: ::windows::core::PCSTR) -> ::windows::core::HRESULT,
    pub AddDumpInformationFile: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, infofile: ::windows::core::PCSTR, r#type: u32) -> ::windows::core::HRESULT,
    pub EndProcessServer: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64) -> ::windows::core::HRESULT,
    pub WaitForProcessServerEnd: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, timeout: u32) -> ::windows::core::HRESULT,
    pub IsKernelDebuggerEnabled: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub TerminateCurrentProcess: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub DetachCurrentProcess: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub AbandonCurrentProcess: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetRunningProcessSystemIdByExecutableNameWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, exename: ::windows::core::PCWSTR, flags: u32, id: *mut u32) -> ::windows::core::HRESULT,
    pub GetRunningProcessDescriptionWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, systemid: u32, flags: u32, exename: ::windows::core::PWSTR, exenamesize: u32, actualexenamesize: *mut u32, description: ::windows::core::PWSTR, descriptionsize: u32, actualdescriptionsize: *mut u32) -> ::windows::core::HRESULT,
    pub CreateProcessWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, commandline: ::windows::core::PCWSTR, createflags: u32) -> ::windows::core::HRESULT,
    pub CreateProcessAndAttachWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, commandline: ::windows::core::PCWSTR, createflags: u32, processid: u32, attachflags: u32) -> ::windows::core::HRESULT,
    pub OpenDumpFileWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, filename: ::windows::core::PCWSTR, filehandle: u64) -> ::windows::core::HRESULT,
    pub WriteDumpFileWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, filename: ::windows::core::PCWSTR, filehandle: u64, qualifier: u32, formatflags: u32, comment: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub AddDumpInformationFileWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, filename: ::windows::core::PCWSTR, filehandle: u64, r#type: u32) -> ::windows::core::HRESULT,
    pub GetNumberDumpFiles: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, number: *mut u32) -> ::windows::core::HRESULT,
    pub GetDumpFile: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, index: u32, buffer: ::windows::core::PSTR, buffersize: u32, namesize: *mut u32, handle: *mut u64, r#type: *mut u32) -> ::windows::core::HRESULT,
    pub GetDumpFileWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, index: u32, buffer: ::windows::core::PWSTR, buffersize: u32, namesize: *mut u32, handle: *mut u64, r#type: *mut u32) -> ::windows::core::HRESULT,
    pub AttachKernelWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flags: u32, connectoptions: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub GetKernelConnectionOptionsWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, buffer: ::windows::core::PWSTR, buffersize: u32, optionssize: *mut u32) -> ::windows::core::HRESULT,
    pub SetKernelConnectionOptionsWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, options: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub StartProcessServerWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flags: u32, options: ::windows::core::PCWSTR, reserved: *const ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub ConnectProcessServerWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, remoteoptions: ::windows::core::PCWSTR, server: *mut u64) -> ::windows::core::HRESULT,
    pub StartServerWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, options: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub OutputServersWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, outputcontrol: u32, machine: ::windows::core::PCWSTR, flags: u32) -> ::windows::core::HRESULT,
    pub GetOutputCallbacksWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, callbacks: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub SetOutputCallbacksWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, callbacks: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetOutputLinePrefixWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, buffer: ::windows::core::PWSTR, buffersize: u32, prefixsize: *mut u32) -> ::windows::core::HRESULT,
    pub SetOutputLinePrefixWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, prefix: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub GetIdentityWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, buffer: ::windows::core::PWSTR, buffersize: u32, identitysize: *mut u32) -> ::windows::core::HRESULT,
    pub OutputIdentityWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, outputcontrol: u32, flags: u32, format: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub GetEventCallbacksWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, callbacks: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub SetEventCallbacksWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, callbacks: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub CreateProcess2: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, commandline: ::windows::core::PCSTR, optionsbuffer: *const ::core::ffi::c_void, optionsbuffersize: u32, initialdirectory: ::windows::core::PCSTR, environment: ::windows::core::PCSTR) -> ::windows::core::HRESULT,
    pub CreateProcess2Wide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, commandline: ::windows::core::PCWSTR, optionsbuffer: *const ::core::ffi::c_void, optionsbuffersize: u32, initialdirectory: ::windows::core::PCWSTR, environment: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub CreateProcessAndAttach2: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, commandline: ::windows::core::PCSTR, optionsbuffer: *const ::core::ffi::c_void, optionsbuffersize: u32, initialdirectory: ::windows::core::PCSTR, environment: ::windows::core::PCSTR, processid: u32, attachflags: u32) -> ::windows::core::HRESULT,
    pub CreateProcessAndAttach2Wide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, server: u64, commandline: ::windows::core::PCWSTR, optionsbuffer: *const ::core::ffi::c_void, optionsbuffersize: u32, initialdirectory: ::windows::core::PCWSTR, environment: ::windows::core::PCWSTR, processid: u32, attachflags: u32) -> ::windows::core::HRESULT,
    pub PushOutputLinePrefix: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, newprefix: ::windows::core::PCSTR, handle: *mut u64) -> ::windows::core::HRESULT,
    pub PushOutputLinePrefixWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, newprefix: ::windows::core::PCWSTR, handle: *mut u64) -> ::windows::core::HRESULT,
    pub PopOutputLinePrefix: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, handle: u64) -> ::windows::core::HRESULT,
    pub GetNumberInputCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, count: *mut u32) -> ::windows::core::HRESULT,
    pub GetNumberOutputCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, count: *mut u32) -> ::windows::core::HRESULT,
    pub GetNumberEventCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, eventflags: u32, count: *mut u32) -> ::windows::core::HRESULT,
    pub GetQuitLockString: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, buffer: ::windows::core::PSTR, buffersize: u32, stringsize: *mut u32) -> ::windows::core::HRESULT,
    pub SetQuitLockString: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, string: ::windows::core::PCSTR) -> ::windows::core::HRESULT,
    pub GetQuitLockStringWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, buffer: ::windows::core::PWSTR, buffersize: u32, stringsize: *mut u32) -> ::windows::core::HRESULT,
    pub SetQuitLockStringWide: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, string: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub SetEventContextCallbacks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, callbacks: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub SetClientContext: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, context: *const ::core::ffi::c_void, contextsize: u32) -> ::windows::core::HRESULT,
    pub OpenDumpFileWide2: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, filename: ::windows::core::PCWSTR, filehandle: u64, alternatearch: u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IDebugCodeContext(::windows::core::IUnknown);
impl IDebugCodeContext {
    pub unsafe fn GetDocumentContext(&self) -> ::windows::core::Result<IDebugDocumentContext> {
        let mut result__ = ::windows::core::zeroed::<IDebugDocumentContext>();
        (::windows::core::Interface::vtable(self).GetDocumentContext)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetBreakPoint(&self, bps: BREAKPOINT_STATE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetBreakPoint)(::windows::core::Interface::as_raw(self), bps).ok()
    }
}
::windows::imp::interface_hierarchy!(IDebugCodeContext, ::windows::core::IUnknown);
impl ::core::cmp::PartialEq for IDebugCodeContext {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDebugCodeContext {}
impl ::core::fmt::Debug for IDebugCodeContext {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDebugCodeContext").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IDebugCodeContext {
    type Vtable = IDebugCodeContext_Vtbl;
}
impl ::core::clone::Clone for IDebugCodeContext {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows::core::ComInterface for IDebugCodeContext {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x51973c13_cb0c_11d0_b5c9_00a0244a0e7a);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDebugCodeContext_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub GetDocumentContext: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppsc: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub SetBreakPoint: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bps: BREAKPOINT_STATE) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Diagnostics_Debug\"`*"]
#[repr(transparent)]
pub struct IDebugControl(::windows::core::IUnknown);
impl IDebugControl {
    pub unsafe fn GetInterrupt(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetInterrupt)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn SetInterrupt(&self, flags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetInterrupt)(::windows::core::Interface::as_raw(self), flags).ok()
    }
    pub unsafe fn GetInterruptTimeout(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetInterruptTimeout)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetInterruptTimeout(&self, seconds: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetInterruptTimeout)(::windows::core::Interface::as_raw(self), seconds).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetLogFile(&self, buffer: ::core::option::Option<&mut [u8]>, filesize: ::core::option::Option<*mut u32>, append: *mut super::super::super::Foundation::BOOL) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetLogFile)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(filesize.unwrap_or(::std::ptr::null_mut())), append).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OpenLogFile<P0, P1>(&self, file: P0, append: P1) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
        P1: ::windows::core::IntoParam<super::super::super::Foundation::BOOL>,
    {
        (::windows::core::Interface::vtable(self).OpenLogFile)(::windows::core::Interface::as_raw(self), file.into_param().abi(), append.into_param().abi()).ok()
    }
    pub unsafe fn CloseLogFile(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).CloseLogFile)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetLogMask(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetLogMask)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetLogMask(&self, mask: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetLogMask)(::windows::core::Interface::as_raw(self), mask).ok()
    }
    pub unsafe fn Input(&self, buffer: &mut [u8], inputsize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Input)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(buffer.as_ptr()), buffer.len() as _, ::core::mem::transmute(inputsize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn ReturnInput<P0>(&self, buffer: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).ReturnInput)(::windows::core::Interface::as_raw(self), buffer.into_param().abi()).ok()
    }
    pub unsafe fn Output<P0>(&self, mask: u32, format: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).Output)(::windows::core::Interface::as_raw(self), mask, format.into_param().abi()).ok()
    }
    pub unsafe fn OutputVaList<P0>(&self, mask: u32, format: P0, args: *const i8) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).OutputVaList)(::windows::core::Interface::as_raw(self), mask, format.into_param().abi(), args).ok()
    }
    pub unsafe fn ControlledOutput<P0>(&self, outputcontrol: u32, mask: u32, format: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).ControlledOutput)(::windows::core::Interface::as_raw(self), outputcontrol, mask, format.into_param().abi()).ok()
    }
    pub unsafe fn ControlledOutputVaList<P0>(&self, outputcontrol: u32, mask: u32, format: P0, args: *const i8) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).ControlledOutputVaList)(::windows::core::Interface::as_raw(self), outputcontrol, mask, format.into_param().abi(), args).ok()
    }
    pub unsafe fn OutputPrompt<P0>(&self, outputcontrol: u32, format: P0) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).OutputPrompt)(::windows::core::Interface::as_raw(self), outputcontrol, format.into_param().abi()).ok()
    }
    pub unsafe fn OutputPromptVaList<P0>(&self, outputcontrol: u32, format: P0, args: *const i8) -> ::windows::core::Result<()>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        (::windows::core::Interface::vtable(self).OutputPromptVaList)(::windows::core::Interface::as_raw(self), outputcontrol, format.into_param().abi(), args).ok()
    }
    pub unsafe fn GetPromptText(&self, buffer: ::core::option::Option<&mut [u8]>, textsize: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetPromptText)(::windows::core::Interface::as_raw(self), ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(textsize.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn OutputCurrentState(&self, outputcontrol: u32, flags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).OutputCurrentState)(::windows::core::Interface::as_raw(self), outputcontrol, flags).ok()
    }
    pub unsafe fn OutputVersionInformation(&self, outputcontrol: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).OutputVersionInformation)(::windows::core::Interface::as_raw(self), outputcontrol).ok()
    }
    pub unsafe fn GetNotifyEventHandle(&self) -> ::windows::core::Result<u64> {
        let mut result__ = ::windows::core::zeroed::<u64>();
        (::windows::core::Interface::vtable(self).GetNotifyEventHandle)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetNotifyEventHandle(&self, handle: u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetNotifyEventHandle)(::windows::core::Interface::as_raw(self), handle).ok()
    }
    pub unsafe fn Assemble<P0>(&self, offset: u64, instr: P0) -> ::windows::core::Result<u64>
    where
        P0: ::windows::core::IntoParam<::windows::core::PCSTR>,
    {
        let mut result__ = ::windows::core::zeroed::<u64>();
        (::windows::core::Interface::vtable(self).Assemble)(::windows::core::Interface::as_raw(self), offset, instr.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn Disassemble(&self, offset: u64, flags: u32, buffer: ::core::option::Option<&mut [u8]>, disassemblysize: ::core::option::Option<*mut u32>, endoffset: *mut u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Disassemble)(::windows::core::Interface::as_raw(self), offset, flags, ::core::mem::transmute(buffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(disassemblysize.unwrap_or(::std::ptr::null_mut())), endoffset).ok()
    }
    pub unsafe fn GetDisassembleEffectiveOffset(&self) -> ::windows::core::Result<u64> {
        let mut result__ = ::windows::core::zeroed::<u64>();
        (::windows::core::Interface::vtable(self).GetDisassembleEffectiveOffset)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn OutputDisassembly(&self, outputcontrol: u32, offset: u64, flags: u32) -> ::windows::core::Result<u64> {
        let mut result__ = ::windows::core::zeroed::<u64>();
        (::windows::core::Interface::vtable(self).OutputDisassembly)(::windows::core::Interface::as_raw(self), outputcontrol, offset, flags, &mut result__).from_abi(result__)
    }
    pub unsafe fn OutputDisassemblyLines(&self, outputcontrol: u32, previouslines: u32, offset: u64, flags: u32, offsetline: ::core::option::Option<*mut u32>, startoffset: ::core::option::Option<*mut u64>, endoffset: ::core::option::Option<*mut u64>, lineoffsets: ::core::option::Option<&mut [u64]>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).OutputDisassemblyLines)(::windows::core::Interface::as_raw(self), outputcontrol, previouslines, lineoffsets.as_deref().map_or(0, |slice| slice.len() as _), offset, flags, ::core::mem::transmute(offsetline.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(startoffset.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(endoffset.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(lineoffsets.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr()))).ok()
    }
    pub unsafe fn GetNearInstruction(&self, offset: u64, delta: i32) -> ::windows::core::Result<u64> {
        let mut result__ = ::windows::core::zeroed::<u64>();
        (::windows::core::Interface::vtable(self).GetNearInstruction)(::windows::core::Interface::as_raw(self), offset, delta, &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetStackTrace(&self, frameoffset: u64, stackoffset: u64, instructionoffset: u64, frames: &mut [DEBUG_STACK_FRAME], framesfilled: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetStackTrace)(::windows::core::Interface::as_raw(self), frameoffset, stackoffset, instructionoffset, ::core::mem::transmute(frames.as_ptr()), frames.len() as _, ::core::mem::transmute(framesfilled.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetReturnOffset(&self) -> ::windows::core::Result<u64> {
        let mut result__ = ::windows::core::zeroed::<u64>();
        (::windows::core::Interface::vtable(self).GetReturnOffset)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OutputStackTrace(&self, outputcontrol: u32, frames: ::core::option::Option<&[DEBUG_STACK_FRAME]>, flags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).OutputStackTrace)(::windows::core::Interface::as_raw(self), outputcontrol, ::core::mem::transmute(frames.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), frames.as_deref().map_or(0, |slice| slice.len() as _), flags).ok()
    }
    pub unsafe fn GetDebuggeeType(&self, class: *mut u32, qualifier: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetDebuggeeType)(::windows::core::Interface::as_raw(self), class, qualifier).ok()
    }
    pub unsafe fn GetActualProcessorType(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetActualProcessorType)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetExecutingProcessorType(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetExecutingProcessorType)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetNumberPossibleExecutingProcessorTypes(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetNumberPossibleExecutingProcessorTypes)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetPossibleExecutingProcessorTypes(&self, start: u32, types: &mut [u32]) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetPossibleExecutingProcessorTypes)(::windows::core::Interface::as_raw(self), start, types.len() as _, ::core::mem::transmute(types.as_ptr())).ok()
    }
    pub unsafe fn GetNumberProcessors(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetNumberProcessors)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetSystemVersion(&self, platformid: *mut u32, major: *mut u32, minor: *mut u32, servicepackstring: ::core::option::Option<&mut [u8]>, servicepackstringused: ::core::option::Option<*mut u32>, servicepacknumber: *mut u32, buildstring: ::core::option::Option<&mut [u8]>, buildstringused: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetSystemVersion)(
            ::windows::core::Interface::as_raw(self),
            platformid,
            major,
            minor,
            ::core::mem::transmute(servicepackstring.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
            servicepackstring.as_deref().map_or(0, |slice| slice.len() as _),
            ::core::mem::transmute(servicepackstringused.unwrap_or(::std::ptr::null_mut())),
            servicepacknumber,
            ::core::mem::transmute(buildstring.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
            buildstring.as_deref().map_or(0, |slice| slice.len() as _),
            ::core::mem::transmute(buildstringused.unwrap_or(::std::ptr::null_mut())),
        )
        .ok()
    }
    pub unsafe fn GetPageSize(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::windows::core::zeroed::<u32>();
        (::windows::core::Interface::vtable(self).GetPageSize)(::windows::core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn IsPointer64Bit(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).IsPointer64Bit)(::windows::core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn ReadBugCheckData(&self, code: *mut u32, arg1: *mut u64, arg2: *mut u64, arg3: *mut u64, arg4: *mut u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).ReadBugCheckData)(::windows::core::Interfac