#! /usr/bin/env perl

use strict;
use warnings;
use utf8;
use Data::Dumper;

$Data::Dumper::Sortkeys = 1;
$Data::Dumper::Indent   = 1;

use lib 'lib';
use Database::Order;

binmode( STDOUT, "utf8" );

my $order1 = Database::Order->new_from_string( 'first:a,second:d,' .
                                               'column_with_implicit_order,' .
                                               'last.column_with/strange?name:a',
                                               'main_table' );
print Dumper [ $order1,
               $order1->order_clause( '`' ) ];

my $order2 = Database::Order->new_from_string( '' );
print Dumper [ $order2,
               $order2->order_clause( '`' ) ];
