% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unnest-wider.R
\name{unnest_wider}
\alias{unnest_wider}
\title{Unnest a list-column into columns}
\usage{
unnest_wider(
  data,
  col,
  names_sep = NULL,
  simplify = TRUE,
  strict = FALSE,
  names_repair = "check_unique",
  ptype = NULL,
  transform = NULL
)
}
\arguments{
\item{data}{A data frame.}

\item{col}{<\code{\link[=tidyr_tidy_select]{tidy-select}}> List-column(s) to unnest.

When selecting multiple columns, values from the same row will be recycled
to their common size.}

\item{names_sep}{If \code{NULL}, the default, the names will be left
as is. If a string, the outer and inner names will be pasted together using
\code{names_sep} as a separator.

If any values being unnested are unnamed, then \code{names_sep} must be
supplied, otherwise an error is thrown. When \code{names_sep} is supplied,
names are automatically generated for unnamed values as an increasing
sequence of integers.}

\item{simplify}{If \code{TRUE}, will attempt to simplify lists of
length-1 vectors to an atomic vector. Can also be a named list containing
\code{TRUE} or \code{FALSE} declaring whether or not to attempt to simplify a
particular column. If a named list is provided, the default for any
unspecified columns is \code{TRUE}.}

\item{strict}{A single logical specifying whether or not to apply strict
vctrs typing rules. If \code{FALSE}, typed empty values (like \code{list()} or
\code{integer()}) nested within list-columns will be treated like \code{NULL} and
will not contribute to the type of the unnested column. This is useful
when working with JSON, where empty values tend to lose their type
information and show up as \code{list()}.}

\item{names_repair}{Used to check that output data frame has valid
names. Must be one of the following options:
\itemize{
\item \verb{"minimal}": no name repair or checks, beyond basic existence,
\item \verb{"unique}": make sure names are unique and not empty,
\item \verb{"check_unique}": (the default), no name repair, but check they are unique,
\item \verb{"universal}": make the names unique and syntactic
\item a function: apply custom name repair.
\item \link{tidyr_legacy}: use the name repair from tidyr 0.8.
\item a formula: a purrr-style anonymous function (see \code{\link[rlang:as_function]{rlang::as_function()}})
}

See \code{\link[vctrs:vec_as_names]{vctrs::vec_as_names()}} for more details on these terms and the
strategies used to enforce them.}

\item{ptype}{Optionally, a named list of prototypes declaring the
desired output type of each component. Alternatively, a single empty
prototype can be supplied, which will be applied to all components. Use
this argument if you want to check that each element has the type you
expect when simplifying.

If a \code{ptype} has been specified, but \code{simplify = FALSE} or simplification
isn't possible, then a \link[vctrs:list_of]{list-of} column will be returned
and each element will have type \code{ptype}.}

\item{transform}{Optionally, a named list of transformation
functions applied to each component. Alternatively, a single function can
be supplied, which will be applied to all components. Use this argument if
you want to transform or parse individual elements as they are extracted.

When both \code{ptype} and \code{transform} are supplied, the \code{transform} is applied
before the \code{ptype}.}
}
\description{
\code{unnest_wider()} turns each element of a list-column into a column. It
is most naturally suited to list-columns where every element is named,
and the names are consistent from row-to-row.
\code{unnest_wider()} preserves the rows of \code{x} while modifying the columns.

Learn more in \code{vignette("rectangle")}.
}
\examples{
df <- tibble(
  character = c("Toothless", "Dory"),
  metadata = list(
    list(
      species = "dragon",
      color = "black",
      films = c(
        "How to Train Your Dragon",
        "How to Train Your Dragon 2",
        "How to Train Your Dragon: The Hidden World"
      )
    ),
    list(
      species = "blue tang",
      color = "blue",
      films = c("Finding Nemo", "Finding Dory")
    )
  )
)
df

# Turn all components of metadata into columns
df \%>\% unnest_wider(metadata)

# Choose not to simplify list-cols of length-1 elements
df \%>\% unnest_wider(metadata, simplify = FALSE)
df \%>\% unnest_wider(metadata, simplify = list(color = FALSE))

# You can also widen unnamed list-cols:
df <- tibble(
  x = 1:3,
  y = list(NULL, 1:3, 4:5)
)
# but you must supply `names_sep` to do so, which generates automatic names:
df \%>\% unnest_wider(y, names_sep = "_")

# 0-length elements ---------------------------------------------------------
# The defaults of `unnest_wider()` treat empty types (like `list()`) as `NULL`.
json <- list(
  list(x = 1:2, y = 1:2),
  list(x = list(), y = 3:4),
  list(x = 3L, y = list())
)

df <- tibble(json = json)
df \%>\%
  unnest_wider(json)

# To instead enforce strict vctrs typing rules, use `strict`
df \%>\%
  unnest_wider(json, strict = TRUE)
}
\seealso{
Other rectangling: 
\code{\link{hoist}()},
\code{\link{unnest_longer}()},
\code{\link{unnest}()}
}
\concept{rectangling}
