% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node_topology.R
\name{node_topology}
\alias{node_topology}
\alias{node_dominator}
\alias{node_topo_order}
\title{Node properties related to the graph topology}
\usage{
node_dominator(root, mode = "out")

node_topo_order(mode = "out")
}
\arguments{
\item{root}{The node to start the dominator search from}

\item{mode}{How should edges be followed. Either \code{'in'} or \code{'out'}}
}
\value{
A vector of the same length as the number of nodes in the graph
}
\description{
These functions calculate properties that are dependent on the overall
topology of the graph.
}
\section{Functions}{
\itemize{
\item \code{node_dominator()}: Get the immediate dominator of each node. Wraps \code{\link[igraph:dominator_tree]{igraph::dominator_tree()}}.

\item \code{node_topo_order()}: Get the topological order of nodes in a DAG. Wraps \code{\link[igraph:topo_sort]{igraph::topo_sort()}}.

}}
\examples{
# Sort a graph based on its topological order
create_tree(10, 2) \%>\%
  arrange(sample(graph_order())) \%>\%
  mutate(old_ind = seq_len(graph_order())) \%>\%
  arrange(node_topo_order())
}
