% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/play.R
\name{component_games}
\alias{component_games}
\alias{play_blocks}
\alias{play_blocks_hierarchy}
\alias{play_islands}
\alias{play_smallworld}
\title{Graph games based on connected components}
\usage{
play_blocks(n, size_blocks, p_between, directed = TRUE, loops = FALSE)

play_blocks_hierarchy(n, size_blocks, rho, p_within, p_between)

play_islands(n_islands, size_islands, p_within, m_between)

play_smallworld(
  n_dim,
  dim_size,
  order,
  p_rewire,
  loops = FALSE,
  multiple = FALSE
)
}
\arguments{
\item{n}{The number of nodes in the graph.}

\item{size_blocks}{The number of vertices in each block}

\item{p_between, p_within}{The probability of edges within and between groups/blocks}

\item{directed}{Should the resulting graph be directed}

\item{loops}{Are loop edges allowed}

\item{rho}{The fraction of vertices per cluster}

\item{n_islands}{The number of densely connected islands}

\item{size_islands}{The number of nodes in each island}

\item{m_between}{The number of edges between groups/islands}

\item{n_dim, dim_size}{The dimension and size of the starting lattice}

\item{order}{The neighborhood size to create connections from}

\item{p_rewire}{The rewiring probability of edges}

\item{multiple}{Are multiple edges allowed}
}
\value{
A tbl_graph object
}
\description{
This set of graph creation algorithms simulate the topology by, in some way,
connecting subgraphs. The nature of their algorithm is described in detail at
the linked igraph documentation.
}
\section{Functions}{
\itemize{
\item \code{play_blocks}: Create graphs by sampling from stochastic block
model. See \code{\link[igraph:sample_sbm]{igraph::sample_sbm()}}

\item \code{play_blocks_hierarchy}: Create graphs by sampling from the hierarchical
stochastic block model. See \code{\link[igraph:sample_hierarchical_sbm]{igraph::sample_hierarchical_sbm()}}

\item \code{play_islands}: Create graphs with fixed size and edge
probability of subgraphs as well as fixed edge count between subgraphs. See
\code{\link[igraph:sample_islands]{igraph::sample_islands()}}

\item \code{play_smallworld}: Create graphs based on the Watts-Strogatz small-
world model. See \code{\link[igraph:sample_smallworld]{igraph::sample_smallworld()}}
}}

\examples{
plot(play_islands(4, 10, 0.7, 3))

}
\seealso{
Other graph games: 
\code{\link{evolution_games}},
\code{\link{sampling_games}},
\code{\link{type_games}}
}
\concept{graph games}
