% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lead-lag.R
\name{lag}
\alias{lag}
\alias{lead}
\title{Compute lagged or leading values}
\usage{
lag(x, n = 1L, default = NA)

lead(x, n = 1L, default = NA)
}
\arguments{
\item{x}{A \code{vector} of values}

\item{n}{A positive \code{integer(1)}, giving the number of positions to lead or lag by.}

\item{default}{The value used for non-existent rows (default: \code{NA}).}
}
\description{
Find the "previous" (\code{lag()}) or "next" (\code{lead()}) values in a vector. Useful for comparing values behind of or ahead
of the current values.
}
\examples{
lag(1:5)
lead(1:5)

x <- 1:5
data.frame(behind = lag(x), x, ahead = lead(x))

# If you want to look more rows behind or ahead, use `n`
lag(1:5, n = 1)
lag(1:5, n = 2)

lead(1:5, n = 1)
lead(1:5, n = 2)

# If you want to define a value for non-existing rows, use `default`
lag(1:5)
lag(1:5, default = 0)

lead(1:5)
lead(1:5, default = 6)

}
