% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse-body.R
\name{parser_form}
\alias{parser_form}
\alias{parser_json}
\alias{parser_geojson}
\alias{parser_text}
\alias{parser_yaml}
\alias{parser_csv}
\alias{parser_tsv}
\alias{parser_read_file}
\alias{parser_rds}
\alias{parser_feather}
\alias{parser_parquet}
\alias{parser_excel}
\alias{parser_octet}
\alias{parser_multi}
\alias{parser_none}
\title{Plumber Parsers}
\usage{
parser_form()

parser_json(...)

parser_geojson(...)

parser_text(parse_fn = identity)

parser_yaml(...)

parser_csv(...)

parser_tsv(...)

parser_read_file(read_fn = readLines)

parser_rds(...)

parser_feather(...)

parser_parquet(...)

parser_excel(..., sheet = NULL)

parser_octet()

parser_multi()

parser_none()
}
\arguments{
\item{...}{parameters supplied to the appropriate internal function}

\item{parse_fn}{function to further decode a text string into an object}

\item{read_fn}{function used to read a the content of a file. Ex: \code{\link[=readRDS]{readRDS()}}}

\item{sheet}{Sheet to read. Either a string (the name of a sheet), or an
integer (the position of the sheet). Defaults to the first sheet. To read all
sheets, use \code{NA}.}
}
\description{
Parsers are used in Plumber to transform request body received
by the API. Extra parameters may be provided to parser
functions when enabling them on router. This will allow for
non-default behavior.
}
\details{
Parsers are optional. When unspecified, only default endpoint parsers are enabled.
You can use \verb{@parser NAME} tag to enable parser on endpoint.
Multiple parsers can be enabled on the same endpoint using multiple \verb{@parser NAME} tags.

User should be aware that \code{rds} parsing should only be done from a
trusted source. Do not accept \code{rds} files blindly.

See \code{\link[=registered_parsers]{registered_parsers()}} for a list of registered parsers names.
}
\section{Functions}{
\itemize{
\item \code{parser_form()}: Form query string parser

\item \code{parser_json()}: JSON parser. See \code{\link[jsonlite:read_json]{jsonlite::parse_json()}} for more details. (Defaults to using \code{simplifyVectors = TRUE})

\item \code{parser_geojson()}: GeoJSON parser. See \code{\link[geojsonsf:geojson_sf]{geojsonsf::geojson_sf()}} for more details.

\item \code{parser_text()}: Helper parser to parse plain text

\item \code{parser_yaml()}: YAML parser. See \code{\link[yaml:yaml.load]{yaml::yaml.load()}} for more details.

\item \code{parser_csv()}: CSV parser. See \code{\link[readr:read_delim]{readr::read_csv()}} for more details.

\item \code{parser_tsv()}: TSV parser. See \code{\link[readr:read_delim]{readr::read_tsv()}} for more details.

\item \code{parser_read_file()}: Helper parser that writes the binary body to a file and reads it back again using \code{read_fn}.
This parser should be used when reading from a file is required.

\item \code{parser_rds()}: RDS parser. See \code{\link[=readRDS]{readRDS()}} for more details.

\item \code{parser_feather()}: feather parser. See \code{\link[arrow:read_feather]{arrow::read_feather()}} for more details.

\item \code{parser_parquet()}: parquet parser. See \code{\link[arrow:read_parquet]{arrow::read_parquet()}} for more details.

\item \code{parser_excel()}: excel parser. See \code{\link[readxl:read_excel]{readxl::read_excel()}} for more details. (Defaults to reading in the first worksheet only, use \verb{@parser excel list(sheet=NA)} to read in all worksheets.)

\item \code{parser_octet()}: Octet stream parser. Returns the raw content.

\item \code{parser_multi()}: Multi part parser. This parser will then parse each individual body with its respective parser.  When this parser is used, \code{req$body} will contain the updated output from \code{\link[webutils:parse_multipart]{webutils::parse_multipart()}} by adding the \code{parsed} output to each part.  Each part may contain detailed information, such as \code{name} (required), \code{content_type}, \code{content_disposition}, \code{filename}, (raw, original) \code{value}, and \code{parsed} (parsed \code{value}).  When performing Plumber route argument matching, each multipart part will match its \code{name} to the \code{parsed} content.

\item \code{parser_none()}: No parser. Will not process the postBody.

}}
\examples{
\dontrun{
# Overwrite `text/json` parsing behavior to not allow JSON vectors to be simplified
#* @parser json list(simplifyVector = FALSE)
# Activate `rds` parser in a multipart request
#* @parser multi
#* @parser rds
pr <- Plumber$new()
pr$handle("GET", "/upload", function(rds) {rds}, parsers = c("multi", "rds"))
}
}
