% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_annotation.R
\name{plot_annotation}
\alias{plot_annotation}
\title{Annotate the final patchwork}
\usage{
plot_annotation(
  title = waiver(),
  subtitle = waiver(),
  caption = waiver(),
  tag_levels = waiver(),
  tag_prefix = waiver(),
  tag_suffix = waiver(),
  tag_sep = waiver(),
  theme = waiver()
)
}
\arguments{
\item{title, subtitle, caption}{Text strings to use for the various plot
annotations.}

\item{tag_levels}{A character vector defining the enumeration format to use
at each level. Possible values are \code{'a'} for lowercase letters, \code{'A'} for
uppercase letters, \code{'1'} for numbers, \code{'i'} for lowercase Roman numerals, and
\code{'I'} for uppercase Roman numerals. It can also be a list containing
character vectors defining arbitrary tag sequences. If any element in the
list is a scalar and one of \code{'a'}, \code{'A'}, \code{'1'}, \verb{'i}, or \code{'I'}, this level
will be expanded to the expected sequence.}

\item{tag_prefix, tag_suffix}{Strings that should appear before or after the
tag.}

\item{tag_sep}{A separator between different tag levels}

\item{theme}{A ggplot theme specification to use for the plot. Only elements
related to the titles as well as plot margin and background is used.}
}
\value{
A \code{plot_annotation} object
}
\description{
The result of this function can be added to a patchwork using \code{+} in the same
way as \code{\link[=plot_layout]{plot_layout()}}, but unlike \code{\link[=plot_layout]{plot_layout()}} it will only have an
effect on the top level plot. As the name suggests it controls different
aspects of the annotation of the final plot, such as titles and tags. Already
added annotations can be removed by setting the relevant argument to \code{NULL}.
}
\details{
Tagging of subplots is done automatically and following the order of the
plots as they are added. When the plot contains nested layouts the
\code{tag_level} argument in the nested \link{plot_layout} will define whether
enumeration should continue as usual or add a new level. The format of the
levels are defined with \code{tag_levels} argument in \code{plot_annotation}
}
\examples{
library(ggplot2)

p1 <- ggplot(mtcars) + geom_point(aes(mpg, disp))
p2 <- ggplot(mtcars) + geom_boxplot(aes(gear, disp, group = gear))
p3 <- ggplot(mtcars) + geom_bar(aes(gear)) + facet_wrap(~cyl)

# Add title, etc. to a patchwork
p1 + p2 + plot_annotation('This is a title', caption = 'made with patchwork')

# Change styling of patchwork elements
p1 + p2 +
  plot_annotation(
    title = 'This is a title',
    caption = 'made with patchwork',
    theme = theme(plot.title = element_text(size = 16))
  )

# Add tags to plots
p1 / (p2 | p3) +
  plot_annotation(tag_levels = 'A')

# Add multilevel tagging to nested layouts
p1 / ((p2 | p3) + plot_layout(tag_level = 'new')) +
  plot_annotation(tag_levels = c('A', '1'))

# Use a custom tag sequence (mixed with a standard one)
p1 / ((p2 | p3) + plot_layout(tag_level = 'new')) +
  plot_annotation(tag_levels = list(c('&', '\%'), '1'))

}
