% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getOptionOrEnvVar.R
\name{getOptionOrEnvVar}
\alias{getOptionOrEnvVar}
\title{Gets an R Option or an Environment Variable}
\usage{
getOptionOrEnvVar(name, default = NULL, envvar = NULL)
}
\arguments{
\item{name}{(character string) The name of the \R option.}

\item{default}{(a single object) The value to be returned if neither
the \R option nor the environment variable is set.  If the environment
variable is set, its value is coerced to the same type as \code{default}.}

\item{envvar}{(character string) The name of the environment variable.
If not set, or NULL, then the name is automatically constructed from
the upper-case version of argument \code{name} with periods (\code{.}) substituted
by underscores (\verb{_}) and prefixed with \code{R_}, e.g. with \code{"abc.debug"}
becomes \code{R_ABC_DEBUG}.}
}
\value{
Returns an object.
}
\description{
Gets an R Option or an Environment Variable
}
\keyword{internal}
