% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotParallel.R
\name{plotParallel}
\alias{plotParallel}
\title{Plot a Parallel Analysis Class Object}
\usage{
plotParallel(parallel, eig = NA, x = eig, model = "components",
  legend = TRUE, ylab = "Eigenvalues", xlab = "Components",
  main = "Parallel Analysis", ...)
}
\arguments{
\item{parallel}{numeric: vector of the results of a previous parallel
analysis}

\item{eig}{depreciated parameter: eigenvalues to analyse (not used if x is
used, recommended)}

\item{x}{numeric: a \code{vector} of eigenvalues, a \code{matrix} of
correlations or of covariances or a \code{data.frame} of data}

\item{model}{character: \code{"components"} or \code{"factors"}}

\item{legend}{logical: indicator of the presence or not of a legend}

\item{ylab}{character: label of the y axis}

\item{xlab}{character: label of the x axis}

\item{main}{character: title of the plot}

\item{...}{variable: additionnal parameters to give to the \code{cor} or
\code{cov} functions}
}
\value{
Nothing returned.
}
\description{
Plot a scree plot adding information about a parallel analysis.
}
\details{
If \code{eig} is \code{FALSE} the plot shows only the parallel analysis
without eigenvalues.
}
\examples{

## SIMPLE EXAMPLE OF A PARALLEL ANALYSIS
## OF A CORRELATION MATRIX WITH ITS PLOT
 data(dFactors)
 eig      <- dFactors$Raiche$eigenvalues
 subject  <- dFactors$Raiche$nsubjects
 var      <- length(eig)
 rep      <- 100
 cent     <- 0.95
 results  <- parallel(subject,var,rep,cent)

 results


## PARALLEL ANALYSIS SCREE PLOT
 plotParallel(results, x=eig)
 plotParallel(results)


}
\references{
Raiche, G., Walls, T. A., Magis, D., Riopel, M. and Blais, J.-G. (2013). Non-graphical solutions
for Cattell's scree test. Methodology, 9(1), 23-29.
}
\seealso{
\code{\link{plotuScree}}, \code{\link{nScree}},
\code{\link{plotnScree}}, \code{\link{parallel}}
}
\author{
Gilles Raiche \cr Centre sur les Applications des Modeles de
Reponses aux Items (CAMRI) \cr Universite du Quebec a Montreal\cr
\email{raiche.gilles@uqam.ca}
}
\keyword{Graphics}
