% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merList.R
\name{modelInfo}
\alias{modelInfo}
\title{Extract model information from a merMod}
\usage{
modelInfo(object)
}
\arguments{
\item{object}{a merMod object}
}
\value{
Simple summary information about the object, number
of observations, number of grouping terms, AIC, and residual standard deviation
}
\description{
Extract model information from a merMod
}
\examples{
\donttest{
sim_list <- replicate(n = 10,
        expr = sleepstudy[sample(row.names(sleepstudy), 180),],
        simplify=FALSE)
fml <- "Reaction ~ Days + (Days | Subject)"
mod <- lmerModList(fml, data = sim_list)
modelInfo(mod[[1]])
lapply(mod, modelInfo)
}
}
