% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layouts.R
\name{layout_syslognet}
\alias{layout_syslognet}
\title{Format a log record for syslognet}
\usage{
layout_syslognet(
  level,
  msg,
  namespace = NA_character_,
  .logcall = sys.call(),
  .topcall = sys.call(-1),
  .topenv = parent.frame()
)
}
\arguments{
\item{level}{log level, see \code{\link{log_levels}} for more details}

\item{msg}{string message}

\item{namespace}{string referring to the \code{logger} environment / config to be used to override the target of the message record to be used instead of the default namespace, which is defined by the R package name from which the logger was called, and falls back to a common, global namespace.}

\item{.logcall}{the logging call being evaluated (useful in formatters and layouts when you want to have access to the raw, unevaluated R expression)}

\item{.topcall}{R expression from which the logging function was called (useful in formatters and layouts to extract the calling function's name or arguments)}

\item{.topenv}{original frame of the \code{.topcall} calling function where the formatter function will be evaluated and that is used to look up the \code{namespace} as well via \code{logger:::top_env_name}}
}
\value{
A character vector with a severity attribute.
}
\description{
Format a log record for syslognet.
This function converts the logger log level to a
log severity level according to RFC 5424 "The Syslog Protocol".
}
