% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ls_means.R
\name{ls_means.lmerModLmerTest}
\alias{ls_means.lmerModLmerTest}
\alias{lsmeansLT.lmerModLmerTest}
\alias{difflsmeans.lmerModLmerTest}
\title{LS-means for lmerTest Model Fits}
\usage{
\method{ls_means}{lmerModLmerTest}(
  model,
  which = NULL,
  level = 0.95,
  ddf = c("Satterthwaite", "Kenward-Roger"),
  pairwise = FALSE,
  ...
)

\method{lsmeansLT}{lmerModLmerTest}(
  model,
  which = NULL,
  level = 0.95,
  ddf = c("Satterthwaite", "Kenward-Roger"),
  pairwise = FALSE,
  ...
)

\method{difflsmeans}{lmerModLmerTest}(
  model,
  which = NULL,
  level = 0.95,
  ddf = c("Satterthwaite", "Kenward-Roger"),
  ...
)
}
\arguments{
\item{model}{a model object fitted with \code{\link{lmer}} (of class
\code{"lmerModLmerTest"}).}

\item{which}{optional character vector naming factors for which LS-means should
be computed. If \code{NULL} (default) LS-means for all factors are computed.}

\item{level}{confidence level.}

\item{ddf}{method for computation of denominator degrees of freedom.}

\item{pairwise}{compute pairwise differences of LS-means instead?}

\item{...}{currently not used.}
}
\value{
An LS-means table in the form of a \code{data.frame}. Formally an object
of class \code{c("ls_means", "data.frame")} with a number of attributes set.
}
\description{
Computes LS-means or pairwise differences of LS-mean for all factors in a
linear mixed model. \code{lsmeansLT} is provided as an alias for
\code{ls_means} for backward compatibility.
}
\details{
Confidence intervals and p-values are based on the t-distribution using
degrees of freedom based on Satterthwaites or Kenward-Roger methods.

LS-means is SAS terminology for predicted/estimated marginal means, i.e. means
for levels of factors which are averaged over the levels of other factors in
the model. A flat (i.e. unweighted) average is taken which gives equal weight
to all levels of each of the other factors. Numeric/continuous variables are
set at their mean values. See \pkg{emmeans} package
for more options and greater flexibility.

LS-means contrasts are checked for estimability and unestimable contrasts appear
as \code{NA}s in the resulting table.

LS-means objects (of class \code{"ls_means"} have a print method).
}
\examples{

# Get data and fit model:
data("cake", package="lme4")
model <- lmer(angle ~ recipe * temp + (1|recipe:replicate), cake)

# Compute LS-means:
ls_means(model)

# Get LS-means contrasts:
show_tests(ls_means(model))

# Compute pairwise differences of LS-means for each factor:
ls_means(model, pairwise=TRUE)
difflsmeans(model) # Equivalent.

}
\seealso{
\code{\link[=show_tests.ls_means]{show_tests}} for display of the
underlying LS-means contrasts.
}
\author{
Rune Haubo B. Christensen and Alexandra Kuznetsova
}
