% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_parameters_bayesian.R
\name{get_parameters.BGGM}
\alias{get_parameters.BGGM}
\alias{get_parameters.BFBayesFactor}
\alias{get_parameters.brmsfit}
\title{Get model parameters from Bayesian models}
\usage{
\method{get_parameters}{BGGM}(
  x,
  component = "correlation",
  summary = FALSE,
  centrality = "mean",
  ...
)

\method{get_parameters}{BFBayesFactor}(
  x,
  effects = "all",
  component = "all",
  iterations = 4000,
  progress = FALSE,
  verbose = TRUE,
  summary = FALSE,
  centrality = "mean",
  ...
)

\method{get_parameters}{brmsfit}(
  x,
  effects = "fixed",
  component = "all",
  parameters = NULL,
  summary = FALSE,
  centrality = "mean",
  ...
)
}
\arguments{
\item{x}{A fitted model.}

\item{component}{Which type of parameters to return, such as parameters for
the conditional model, the zero-inflated part of the model, the dispersion
term, the instrumental variables or marginal effects be returned? Applies to
models with zero-inflated and/or dispersion formula, or to models with
instrumental variables (so called fixed-effects regressions), or models with
marginal effects (from \strong{mfx}). See details in section \emph{Model Components}
.May be abbreviated. Note that the \emph{conditional} component also refers to the
\emph{count} or \emph{mean} component - names may differ, depending on the modeling
package. There are three convenient shortcuts (not applicable to \emph{all} model
classes):
\itemize{
\item \code{component = "all"} returns all possible parameters.
\item If \code{component = "location"}, location parameters such as \code{conditional},
\code{zero_inflated}, \code{smooth_terms}, or \code{instruments} are returned (everything
that are fixed or random effects - depending on the \code{effects} argument -
but no auxiliary parameters).
\item For \code{component = "distributional"} (or \code{"auxiliary"}), components like
\code{sigma}, \code{dispersion}, \code{beta} or \code{precision} (and other auxiliary
parameters) are returned.
}}

\item{summary}{Logical, indicates whether the full posterior samples
(\code{summary = FALSE})) or the summarized centrality indices of
the posterior samples (\code{summary = TRUE})) should be returned as
estimates.}

\item{centrality}{Only for models with posterior samples, and when
\code{summary = TRUE}. In this case, \code{centrality = "mean"} would
calculate means of posterior samples for each parameter, while
\code{centrality = "median"} would use the more robust median value as
measure of central tendency.}

\item{...}{Currently only used for models of class \code{brmsfit}, where a \code{variable}
argument can be used, which is directly passed to the \code{as.data.frame()}
method (i.e., \code{as.data.frame(x, variable = variable)}).}

\item{effects}{Should variables for fixed effects (\code{"fixed"}), random effects
(\code{"random"}) or both (\code{"all"}) be returned? Only applies to mixed models. May
be abbreviated.

For models of from packages \strong{brms} or \strong{rstanarm} there are additional
options:
\itemize{
\item \code{"fixed"} returns fixed effects.
\item \code{"random_variance"} return random effects parameters (variance and
correlation components, e.g. those parameters that start with \code{sd_} or
\code{cor_}).
\item \code{"grouplevel"} returns random effects group level estimates, i.e. those
parameters that start with \code{r_}.
\item \code{"random"} returns both \code{"random_variance"} and \code{"grouplevel"}.
\item \code{"all"} returns fixed effects and random effects variances.
\item \code{"full"} returns all parameters.
}}

\item{iterations}{Number of posterior draws.}

\item{progress}{Display progress.}

\item{verbose}{Toggle messages and warnings.}

\item{parameters}{Regular expression pattern that describes the parameters that
should be returned.}
}
\value{
The posterior samples from the requested parameters as data frame.
If \code{summary = TRUE}, returns a data frame with two columns: the
parameter names and the related point estimates (based on \code{centrality}).
}
\description{
Returns the coefficients (or posterior samples for Bayesian
models) from a model.
}
\details{
In most cases when models either return different "effects" (fixed,
random) or "components" (conditional, zero-inflated, ...), the arguments
\code{effects} and \code{component} can be used.
}
\section{BFBayesFactor Models}{

Note that for \code{BFBayesFactor} models (from the \strong{BayesFactor} package),
posteriors are only extracted from the first numerator model (i.e.,
\code{model[1]}). If you want to apply some function \code{foo()} to another
model stored in the \code{BFBayesFactor} object, index it directly, e.g.
\code{foo(model[2])}, \code{foo(1/model[5])}, etc.
See also \code{\link[bayestestR:weighted_posteriors]{bayestestR::weighted_posteriors()}}.
}

\section{Model components}{

Possible values for the \code{component} argument depend on the model class.
Following are valid options:
\itemize{
\item \code{"all"}: returns all model components, applies to all models, but will only
have an effect for models with more than just the conditional model component.
\item \code{"conditional"}: only returns the conditional component, i.e. "fixed effects"
terms from the model. Will only have an effect for models with more than
just the conditional model component.
\item \code{"smooth_terms"}: returns smooth terms, only applies to GAMs (or similar
models that may contain smooth terms).
\item \code{"zero_inflated"} (or \code{"zi"}): returns the zero-inflation component.
\item \code{"dispersion"}: returns the dispersion model component. This is common
for models with zero-inflation or that can model the dispersion parameter.
\item \code{"instruments"}: for instrumental-variable or some fixed effects regression,
returns the instruments.
\item \code{"nonlinear"}: for non-linear models (like models of class \code{nlmerMod} or
\code{nls}), returns staring estimates for the nonlinear parameters.
\item \code{"correlation"}: for models with correlation-component, like \code{gls}, the
variables used to describe the correlation structure are returned.
\item \code{"location"}: returns location parameters such as \code{conditional},
\code{zero_inflated}, \code{smooth_terms}, or \code{instruments} (everything that are
fixed or random effects - depending on the \code{effects} argument - but no
auxiliary parameters).
\item \code{"distributional"} (or \code{"auxiliary"}): components like \code{sigma}, \code{dispersion},
\code{beta} or \code{precision} (and other auxiliary parameters) are returned.
}

\strong{Special models}

Some model classes also allow rather uncommon options. These are:
\itemize{
\item \strong{mhurdle}: \code{"infrequent_purchase"}, \code{"ip"}, and \code{"auxiliary"}
\item \strong{BGGM}: \code{"correlation"} and \code{"intercept"}
\item \strong{BFBayesFactor}, \strong{glmx}: \code{"extra"}
\item \strong{averaging}:\code{"conditional"} and \code{"full"}
\item \strong{mjoint}: \code{"survival"}
\item \strong{mfx}: \code{"precision"}, \code{"marginal"}
\item \strong{betareg}, \strong{DirichletRegModel}: \code{"precision"}
\item \strong{mvord}: \code{"thresholds"} and \code{"correlation"}
\item \strong{clm2}: \code{"scale"}
\item \strong{selection}: \code{"selection"}, \code{"outcome"}, and \code{"auxiliary"}
\item \strong{lcmm}: \code{"membership"}, \code{"longitudinal"}, \code{"beta"}, \code{"splines"}, and
\code{"linear"}
}

For models of class \code{brmsfit} (package \strong{brms}), even more options are
possible for the \code{component} argument, which are not all documented in detail
here. It can be any pre-defined or arbitrary distributional parameter, like
\code{mu}, \code{ndt}, \code{kappa}, etc.
}

\examples{
data(mtcars)
m <- lm(mpg ~ wt + cyl + vs, data = mtcars)
get_parameters(m)
}
