% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_nullmodel.R
\name{is_nullmodel}
\alias{is_nullmodel}
\title{Checks if model is a null-model (intercept-only)}
\usage{
is_nullmodel(x)
}
\arguments{
\item{x}{A model object.}
}
\value{
\code{TRUE} if \code{x} is a null-model, \code{FALSE} otherwise.
}
\description{
Checks if model is a null-model (intercept-only), i.e. if
  the conditional part of the model has no predictors.
}
\examples{
model <- lm(mpg ~ 1, data = mtcars)
is_nullmodel(model)

model <- lm(mpg ~ gear, data = mtcars)
is_nullmodel(model)

library(lme4)
model <- lmer(Reaction ~ 1 + (Days | Subject), data = sleepstudy)
is_nullmodel(model)

model <- lmer(Reaction ~ Days + (Days | Subject), data = sleepstudy)
is_nullmodel(model)
}
